# Generated by Django 3.0 on 2022-01-25 16:02

import _utils.models
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("rp", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="ProcessType",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("abbreviation", models.CharField(max_length=3, unique=True)),
                ("description", models.CharField(max_length=200)),
                (
                    "example_html",
                    models.CharField(blank=True, max_length=200, null=True),
                ),
            ],
            bases=(_utils.models.QualifiedIDMixin, models.Model),
        ),
        migrations.CreateModel(
            name="ProductList",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
            ],
            options={
                "db_table": "rxn_reaction_products",
            },
        ),
        migrations.CreateModel(
            name="ReactantList",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
            ],
            options={
                "db_table": "rxn_reaction_reactants",
            },
        ),
        migrations.CreateModel(
            name="Reaction",
            fields=[
                ("id", models.AutoField(primary_key=True, serialize=False)),
                ("text", models.CharField(editable=False, max_length=256)),
                ("html", models.CharField(editable=False, max_length=1024)),
                ("comment", models.CharField(blank=True, max_length=1024)),
                ("process_types", models.ManyToManyField(to="rxn.ProcessType")),
                (
                    "products",
                    models.ManyToManyField(
                        related_name="products_related",
                        through="rxn.ProductList",
                        to="rp.RP",
                    ),
                ),
                (
                    "reactants",
                    models.ManyToManyField(
                        related_name="reactants_related",
                        through="rxn.ReactantList",
                        to="rp.RP",
                    ),
                ),
            ],
            bases=(_utils.models.QualifiedIDMixin, models.Model),
        ),
        migrations.AddField(
            model_name="reactantlist",
            name="reaction",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="rxn.Reaction"
            ),
        ),
        migrations.AddField(
            model_name="reactantlist",
            name="rp",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="rp.RP"
            ),
        ),
        migrations.AddField(
            model_name="productlist",
            name="reaction",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="rxn.Reaction"
            ),
        ),
        migrations.AddField(
            model_name="productlist",
            name="rp",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="rp.RP"
            ),
        ),
    ]
