# The contents of this file are automatically written by
# tools/generate_schema_wrapper.py. Do not modify directly.
from . import core
from altair.utils import use_signature
from altair.utils.schemapi import Undefined


class MarkMethodMixin(object):
    """A mixin class that defines mark methods"""

    def mark_area(self, align=Undefined, angle=Undefined, baseline=Undefined, clip=Undefined,
                  color=Undefined, cursor=Undefined, dx=Undefined, dy=Undefined, fill=Undefined,
                  fillOpacity=Undefined, filled=Undefined, font=Undefined, fontSize=Undefined,
                  fontStyle=Undefined, fontWeight=Undefined, href=Undefined, interpolate=Undefined,
                  limit=Undefined, opacity=Undefined, orient=Undefined, radius=Undefined,
                  shape=Undefined, size=Undefined, stroke=Undefined, strokeDash=Undefined,
                  strokeDashOffset=Undefined, strokeOpacity=Undefined, strokeWidth=Undefined,
                  style=Undefined, tension=Undefined, text=Undefined, theta=Undefined, **kwds):
        """Set the chart's mark to 'area'
    
        For information on additional arguments, see ``alt.MarkDef``
        """
        kwds = dict(align=align, angle=angle, baseline=baseline, clip=clip, color=color, cursor=cursor,
                    dx=dx, dy=dy, fill=fill, fillOpacity=fillOpacity, filled=filled, font=font,
                    fontSize=fontSize, fontStyle=fontStyle, fontWeight=fontWeight, href=href,
                    interpolate=interpolate, limit=limit, opacity=opacity, orient=orient, radius=radius,
                    shape=shape, size=size, stroke=stroke, strokeDash=strokeDash,
                    strokeDashOffset=strokeDashOffset, strokeOpacity=strokeOpacity,
                    strokeWidth=strokeWidth, style=style, tension=tension, text=text, theta=theta,
                    **kwds)
        copy = self.copy(deep=True, ignore=['data'])
        if any(val is not Undefined for val in kwds.values()):
            copy.mark = core.MarkDef(type="area", **kwds)
        else:
            copy.mark = "area"
        return copy

    def mark_bar(self, align=Undefined, angle=Undefined, baseline=Undefined, clip=Undefined,
                 color=Undefined, cursor=Undefined, dx=Undefined, dy=Undefined, fill=Undefined,
                 fillOpacity=Undefined, filled=Undefined, font=Undefined, fontSize=Undefined,
                 fontStyle=Undefined, fontWeight=Undefined, href=Undefined, interpolate=Undefined,
                 limit=Undefined, opacity=Undefined, orient=Undefined, radius=Undefined,
                 shape=Undefined, size=Undefined, stroke=Undefined, strokeDash=Undefined,
                 strokeDashOffset=Undefined, strokeOpacity=Undefined, strokeWidth=Undefined,
                 style=Undefined, tension=Undefined, text=Undefined, theta=Undefined, **kwds):
        """Set the chart's mark to 'bar'
    
        For information on additional arguments, see ``alt.MarkDef``
        """
        kwds = dict(align=align, angle=angle, baseline=baseline, clip=clip, color=color, cursor=cursor,
                    dx=dx, dy=dy, fill=fill, fillOpacity=fillOpacity, filled=filled, font=font,
                    fontSize=fontSize, fontStyle=fontStyle, fontWeight=fontWeight, href=href,
                    interpolate=interpolate, limit=limit, opacity=opacity, orient=orient, radius=radius,
                    shape=shape, size=size, stroke=stroke, strokeDash=strokeDash,
                    strokeDashOffset=strokeDashOffset, strokeOpacity=strokeOpacity,
                    strokeWidth=strokeWidth, style=style, tension=tension, text=text, theta=theta,
                    **kwds)
        copy = self.copy(deep=True, ignore=['data'])
        if any(val is not Undefined for val in kwds.values()):
            copy.mark = core.MarkDef(type="bar", **kwds)
        else:
            copy.mark = "bar"
        return copy

    def mark_line(self, align=Undefined, angle=Undefined, baseline=Undefined, clip=Undefined,
                  color=Undefined, cursor=Undefined, dx=Undefined, dy=Undefined, fill=Undefined,
                  fillOpacity=Undefined, filled=Undefined, font=Undefined, fontSize=Undefined,
                  fontStyle=Undefined, fontWeight=Undefined, href=Undefined, interpolate=Undefined,
                  limit=Undefined, opacity=Undefined, orient=Undefined, radius=Undefined,
                  shape=Undefined, size=Undefined, stroke=Undefined, strokeDash=Undefined,
                  strokeDashOffset=Undefined, strokeOpacity=Undefined, strokeWidth=Undefined,
                  style=Undefined, tension=Undefined, text=Undefined, theta=Undefined, **kwds):
        """Set the chart's mark to 'line'
    
        For information on additional arguments, see ``alt.MarkDef``
        """
        kwds = dict(align=align, angle=angle, baseline=baseline, clip=clip, color=color, cursor=cursor,
                    dx=dx, dy=dy, fill=fill, fillOpacity=fillOpacity, filled=filled, font=font,
                    fontSize=fontSize, fontStyle=fontStyle, fontWeight=fontWeight, href=href,
                    interpolate=interpolate, limit=limit, opacity=opacity, orient=orient, radius=radius,
                    shape=shape, size=size, stroke=stroke, strokeDash=strokeDash,
                    strokeDashOffset=strokeDashOffset, strokeOpacity=strokeOpacity,
                    strokeWidth=strokeWidth, style=style, tension=tension, text=text, theta=theta,
                    **kwds)
        copy = self.copy(deep=True, ignore=['data'])
        if any(val is not Undefined for val in kwds.values()):
            copy.mark = core.MarkDef(type="line", **kwds)
        else:
            copy.mark = "line"
        return copy

    def mark_point(self, align=Undefined, angle=Undefined, baseline=Undefined, clip=Undefined,
                   color=Undefined, cursor=Undefined, dx=Undefined, dy=Undefined, fill=Undefined,
                   fillOpacity=Undefined, filled=Undefined, font=Undefined, fontSize=Undefined,
                   fontStyle=Undefined, fontWeight=Undefined, href=Undefined, interpolate=Undefined,
                   limit=Undefined, opacity=Undefined, orient=Undefined, radius=Undefined,
                   shape=Undefined, size=Undefined, stroke=Undefined, strokeDash=Undefined,
                   strokeDashOffset=Undefined, strokeOpacity=Undefined, strokeWidth=Undefined,
                   style=Undefined, tension=Undefined, text=Undefined, theta=Undefined, **kwds):
        """Set the chart's mark to 'point'
    
        For information on additional arguments, see ``alt.MarkDef``
        """
        kwds = dict(align=align, angle=angle, baseline=baseline, clip=clip, color=color, cursor=cursor,
                    dx=dx, dy=dy, fill=fill, fillOpacity=fillOpacity, filled=filled, font=font,
                    fontSize=fontSize, fontStyle=fontStyle, fontWeight=fontWeight, href=href,
                    interpolate=interpolate, limit=limit, opacity=opacity, orient=orient, radius=radius,
                    shape=shape, size=size, stroke=stroke, strokeDash=strokeDash,
                    strokeDashOffset=strokeDashOffset, strokeOpacity=strokeOpacity,
                    strokeWidth=strokeWidth, style=style, tension=tension, text=text, theta=theta,
                    **kwds)
        copy = self.copy(deep=True, ignore=['data'])
        if any(val is not Undefined for val in kwds.values()):
            copy.mark = core.MarkDef(type="point", **kwds)
        else:
            copy.mark = "point"
        return copy

    def mark_text(self, align=Undefined, angle=Undefined, baseline=Undefined, clip=Undefined,
                  color=Undefined, cursor=Undefined, dx=Undefined, dy=Undefined, fill=Undefined,
                  fillOpacity=Undefined, filled=Undefined, font=Undefined, fontSize=Undefined,
                  fontStyle=Undefined, fontWeight=Undefined, href=Undefined, interpolate=Undefined,
                  limit=Undefined, opacity=Undefined, orient=Undefined, radius=Undefined,
                  shape=Undefined, size=Undefined, stroke=Undefined, strokeDash=Undefined,
                  strokeDashOffset=Undefined, strokeOpacity=Undefined, strokeWidth=Undefined,
                  style=Undefined, tension=Undefined, text=Undefined, theta=Undefined, **kwds):
        """Set the chart's mark to 'text'
    
        For information on additional arguments, see ``alt.MarkDef``
        """
        kwds = dict(align=align, angle=angle, baseline=baseline, clip=clip, color=color, cursor=cursor,
                    dx=dx, dy=dy, fill=fill, fillOpacity=fillOpacity, filled=filled, font=font,
                    fontSize=fontSize, fontStyle=fontStyle, fontWeight=fontWeight, href=href,
                    interpolate=interpolate, limit=limit, opacity=opacity, orient=orient, radius=radius,
                    shape=shape, size=size, stroke=stroke, strokeDash=strokeDash,
                    strokeDashOffset=strokeDashOffset, strokeOpacity=strokeOpacity,
                    strokeWidth=strokeWidth, style=style, tension=tension, text=text, theta=theta,
                    **kwds)
        copy = self.copy(deep=True, ignore=['data'])
        if any(val is not Undefined for val in kwds.values()):
            copy.mark = core.MarkDef(type="text", **kwds)
        else:
            copy.mark = "text"
        return copy

    def mark_tick(self, align=Undefined, angle=Undefined, baseline=Undefined, clip=Undefined,
                  color=Undefined, cursor=Undefined, dx=Undefined, dy=Undefined, fill=Undefined,
                  fillOpacity=Undefined, filled=Undefined, font=Undefined, fontSize=Undefined,
                  fontStyle=Undefined, fontWeight=Undefined, href=Undefined, interpolate=Undefined,
                  limit=Undefined, opacity=Undefined, orient=Undefined, radius=Undefined,
                  shape=Undefined, size=Undefined, stroke=Undefined, strokeDash=Undefined,
                  strokeDashOffset=Undefined, strokeOpacity=Undefined, strokeWidth=Undefined,
                  style=Undefined, tension=Undefined, text=Undefined, theta=Undefined, **kwds):
        """Set the chart's mark to 'tick'
    
        For information on additional arguments, see ``alt.MarkDef``
        """
        kwds = dict(align=align, angle=angle, baseline=baseline, clip=clip, color=color, cursor=cursor,
                    dx=dx, dy=dy, fill=fill, fillOpacity=fillOpacity, filled=filled, font=font,
                    fontSize=fontSize, fontStyle=fontStyle, fontWeight=fontWeight, href=href,
                    interpolate=interpolate, limit=limit, opacity=opacity, orient=orient, radius=radius,
                    shape=shape, size=size, stroke=stroke, strokeDash=strokeDash,
                    strokeDashOffset=strokeDashOffset, strokeOpacity=strokeOpacity,
                    strokeWidth=strokeWidth, style=style, tension=tension, text=text, theta=theta,
                    **kwds)
        copy = self.copy(deep=True, ignore=['data'])
        if any(val is not Undefined for val in kwds.values()):
            copy.mark = core.MarkDef(type="tick", **kwds)
        else:
            copy.mark = "tick"
        return copy

    def mark_rect(self, align=Undefined, angle=Undefined, baseline=Undefined, clip=Undefined,
                  color=Undefined, cursor=Undefined, dx=Undefined, dy=Undefined, fill=Undefined,
                  fillOpacity=Undefined, filled=Undefined, font=Undefined, fontSize=Undefined,
                  fontStyle=Undefined, fontWeight=Undefined, href=Undefined, interpolate=Undefined,
                  limit=Undefined, opacity=Undefined, orient=Undefined, radius=Undefined,
                  shape=Undefined, size=Undefined, stroke=Undefined, strokeDash=Undefined,
                  strokeDashOffset=Undefined, strokeOpacity=Undefined, strokeWidth=Undefined,
                  style=Undefined, tension=Undefined, text=Undefined, theta=Undefined, **kwds):
        """Set the chart's mark to 'rect'
    
        For information on additional arguments, see ``alt.MarkDef``
        """
        kwds = dict(align=align, angle=angle, baseline=baseline, clip=clip, color=color, cursor=cursor,
                    dx=dx, dy=dy, fill=fill, fillOpacity=fillOpacity, filled=filled, font=font,
                    fontSize=fontSize, fontStyle=fontStyle, fontWeight=fontWeight, href=href,
                    interpolate=interpolate, limit=limit, opacity=opacity, orient=orient, radius=radius,
                    shape=shape, size=size, stroke=stroke, strokeDash=strokeDash,
                    strokeDashOffset=strokeDashOffset, strokeOpacity=strokeOpacity,
                    strokeWidth=strokeWidth, style=style, tension=tension, text=text, theta=theta,
                    **kwds)
        copy = self.copy(deep=True, ignore=['data'])
        if any(val is not Undefined for val in kwds.values()):
            copy.mark = core.MarkDef(type="rect", **kwds)
        else:
            copy.mark = "rect"
        return copy

    def mark_rule(self, align=Undefined, angle=Undefined, baseline=Undefined, clip=Undefined,
                  color=Undefined, cursor=Undefined, dx=Undefined, dy=Undefined, fill=Undefined,
                  fillOpacity=Undefined, filled=Undefined, font=Undefined, fontSize=Undefined,
                  fontStyle=Undefined, fontWeight=Undefined, href=Undefined, interpolate=Undefined,
                  limit=Undefined, opacity=Undefined, orient=Undefined, radius=Undefined,
                  shape=Undefined, size=Undefined, stroke=Undefined, strokeDash=Undefined,
                  strokeDashOffset=Undefined, strokeOpacity=Undefined, strokeWidth=Undefined,
                  style=Undefined, tension=Undefined, text=Undefined, theta=Undefined, **kwds):
        """Set the chart's mark to 'rule'
    
        For information on additional arguments, see ``alt.MarkDef``
        """
        kwds = dict(align=align, angle=angle, baseline=baseline, clip=clip, color=color, cursor=cursor,
                    dx=dx, dy=dy, fill=fill, fillOpacity=fillOpacity, filled=filled, font=font,
                    fontSize=fontSize, fontStyle=fontStyle, fontWeight=fontWeight, href=href,
                    interpolate=interpolate, limit=limit, opacity=opacity, orient=orient, radius=radius,
                    shape=shape, size=size, stroke=stroke, strokeDash=strokeDash,
                    strokeDashOffset=strokeDashOffset, strokeOpacity=strokeOpacity,
                    strokeWidth=strokeWidth, style=style, tension=tension, text=text, theta=theta,
                    **kwds)
        copy = self.copy(deep=True, ignore=['data'])
        if any(val is not Undefined for val in kwds.values()):
            copy.mark = core.MarkDef(type="rule", **kwds)
        else:
            copy.mark = "rule"
        return copy

    def mark_circle(self, align=Undefined, angle=Undefined, baseline=Undefined, clip=Undefined,
                    color=Undefined, cursor=Undefined, dx=Undefined, dy=Undefined, fill=Undefined,
                    fillOpacity=Undefined, filled=Undefined, font=Undefined, fontSize=Undefined,
                    fontStyle=Undefined, fontWeight=Undefined, href=Undefined, interpolate=Undefined,
                    limit=Undefined, opacity=Undefined, orient=Undefined, radius=Undefined,
                    shape=Undefined, size=Undefined, stroke=Undefined, strokeDash=Undefined,
                    strokeDashOffset=Undefined, strokeOpacity=Undefined, strokeWidth=Undefined,
                    style=Undefined, tension=Undefined, text=Undefined, theta=Undefined, **kwds):
        """Set the chart's mark to 'circle'
    
        For information on additional arguments, see ``alt.MarkDef``
        """
        kwds = dict(align=align, angle=angle, baseline=baseline, clip=clip, color=color, cursor=cursor,
                    dx=dx, dy=dy, fill=fill, fillOpacity=fillOpacity, filled=filled, font=font,
                    fontSize=fontSize, fontStyle=fontStyle, fontWeight=fontWeight, href=href,
                    interpolate=interpolate, limit=limit, opacity=opacity, orient=orient, radius=radius,
                    shape=shape, size=size, stroke=stroke, strokeDash=strokeDash,
                    strokeDashOffset=strokeDashOffset, strokeOpacity=strokeOpacity,
                    strokeWidth=strokeWidth, style=style, tension=tension, text=text, theta=theta,
                    **kwds)
        copy = self.copy(deep=True, ignore=['data'])
        if any(val is not Undefined for val in kwds.values()):
            copy.mark = core.MarkDef(type="circle", **kwds)
        else:
            copy.mark = "circle"
        return copy

    def mark_square(self, align=Undefined, angle=Undefined, baseline=Undefined, clip=Undefined,
                    color=Undefined, cursor=Undefined, dx=Undefined, dy=Undefined, fill=Undefined,
                    fillOpacity=Undefined, filled=Undefined, font=Undefined, fontSize=Undefined,
                    fontStyle=Undefined, fontWeight=Undefined, href=Undefined, interpolate=Undefined,
                    limit=Undefined, opacity=Undefined, orient=Undefined, radius=Undefined,
                    shape=Undefined, size=Undefined, stroke=Undefined, strokeDash=Undefined,
                    strokeDashOffset=Undefined, strokeOpacity=Undefined, strokeWidth=Undefined,
                    style=Undefined, tension=Undefined, text=Undefined, theta=Undefined, **kwds):
        """Set the chart's mark to 'square'
    
        For information on additional arguments, see ``alt.MarkDef``
        """
        kwds = dict(align=align, angle=angle, baseline=baseline, clip=clip, color=color, cursor=cursor,
                    dx=dx, dy=dy, fill=fill, fillOpacity=fillOpacity, filled=filled, font=font,
                    fontSize=fontSize, fontStyle=fontStyle, fontWeight=fontWeight, href=href,
                    interpolate=interpolate, limit=limit, opacity=opacity, orient=orient, radius=radius,
                    shape=shape, size=size, stroke=stroke, strokeDash=strokeDash,
                    strokeDashOffset=strokeDashOffset, strokeOpacity=strokeOpacity,
                    strokeWidth=strokeWidth, style=style, tension=tension, text=text, theta=theta,
                    **kwds)
        copy = self.copy(deep=True, ignore=['data'])
        if any(val is not Undefined for val in kwds.values()):
            copy.mark = core.MarkDef(type="square", **kwds)
        else:
            copy.mark = "square"
        return copy

    def mark_geoshape(self, align=Undefined, angle=Undefined, baseline=Undefined, clip=Undefined,
                      color=Undefined, cursor=Undefined, dx=Undefined, dy=Undefined, fill=Undefined,
                      fillOpacity=Undefined, filled=Undefined, font=Undefined, fontSize=Undefined,
                      fontStyle=Undefined, fontWeight=Undefined, href=Undefined, interpolate=Undefined,
                      limit=Undefined, opacity=Undefined, orient=Undefined, radius=Undefined,
                      shape=Undefined, size=Undefined, stroke=Undefined, strokeDash=Undefined,
                      strokeDashOffset=Undefined, strokeOpacity=Undefined, strokeWidth=Undefined,
                      style=Undefined, tension=Undefined, text=Undefined, theta=Undefined, **kwds):
        """Set the chart's mark to 'geoshape'
    
        For information on additional arguments, see ``alt.MarkDef``
        """
        kwds = dict(align=align, angle=angle, baseline=baseline, clip=clip, color=color, cursor=cursor,
                    dx=dx, dy=dy, fill=fill, fillOpacity=fillOpacity, filled=filled, font=font,
                    fontSize=fontSize, fontStyle=fontStyle, fontWeight=fontWeight, href=href,
                    interpolate=interpolate, limit=limit, opacity=opacity, orient=orient, radius=radius,
                    shape=shape, size=size, stroke=stroke, strokeDash=strokeDash,
                    strokeDashOffset=strokeDashOffset, strokeOpacity=strokeOpacity,
                    strokeWidth=strokeWidth, style=style, tension=tension, text=text, theta=theta,
                    **kwds)
        copy = self.copy(deep=True, ignore=['data'])
        if any(val is not Undefined for val in kwds.values()):
            copy.mark = core.MarkDef(type="geoshape", **kwds)
        else:
            copy.mark = "geoshape"
        return copy


class ConfigMethodMixin(object):
    """A mixin class that defines config methods"""

    @use_signature(core.Config)
    def configure(self, *args, **kwargs):
        copy = self.copy()
        copy.config = core.Config(*args, **kwargs)
        return copy

    @use_signature(core.MarkConfig)
    def configure_area(self, *args, **kwargs):
        copy = self.copy(deep=False)
        if copy.config is Undefined:
            copy.config = core.Config()
        else:
            copy.config = copy.config.copy(deep=False)
        copy.config["area"] = core.MarkConfig(*args, **kwargs)
        return copy

    @use_signature(core.AxisConfig)
    def configure_axis(self, *args, **kwargs):
        copy = self.copy(deep=False)
        if copy.config is Undefined:
            copy.config = core.Config()
        else:
            copy.config = copy.config.copy(deep=False)
        copy.config["axis"] = core.AxisConfig(*args, **kwargs)
        return copy

    @use_signature(core.VgAxisConfig)
    def configure_axisBand(self, *args, **kwargs):
        copy = self.copy(deep=False)
        if copy.config is Undefined:
            copy.config = core.Config()
        else:
            copy.config = copy.config.copy(deep=False)
        copy.config["axisBand"] = core.VgAxisConfig(*args, **kwargs)
        return copy

    @use_signature(core.VgAxisConfig)
    def configure_axisBottom(self, *args, **kwargs):
        copy = self.copy(deep=False)
        if copy.config is Undefined:
            copy.config = core.Config()
        else:
            copy.config = copy.config.copy(deep=False)
        copy.config["axisBottom"] = core.VgAxisConfig(*args, **kwargs)
        return copy

    @use_signature(core.VgAxisConfig)
    def configure_axisLeft(self, *args, **kwargs):
        copy = self.copy(deep=False)
        if copy.config is Undefined:
            copy.config = core.Config()
        else:
            copy.config = copy.config.copy(deep=False)
        copy.config["axisLeft"] = core.VgAxisConfig(*args, **kwargs)
        return copy

    @use_signature(core.VgAxisConfig)
    def configure_axisRight(self, *args, **kwargs):
        copy = self.copy(deep=False)
        if copy.config is Undefined:
            copy.config = core.Config()
        else:
            copy.config = copy.config.copy(deep=False)
        copy.config["axisRight"] = core.VgAxisConfig(*args, **kwargs)
        return copy

    @use_signature(core.VgAxisConfig)
    def configure_axisTop(self, *args, **kwargs):
        copy = self.copy(deep=False)
        if copy.config is Undefined:
            copy.config = core.Config()
        else:
            copy.config = copy.config.copy(deep=False)
        copy.config["axisTop"] = core.VgAxisConfig(*args, **kwargs)
        return copy

    @use_signature(core.VgAxisConfig)
    def configure_axisX(self, *args, **kwargs):
        copy = self.copy(deep=False)
        if copy.config is Undefined:
            copy.config = core.Config()
        else:
            copy.config = copy.config.copy(deep=False)
        copy.config["axisX"] = core.VgAxisConfig(*args, **kwargs)
        return copy

    @use_signature(core.VgAxisConfig)
    def configure_axisY(self, *args, **kwargs):
        copy = self.copy(deep=False)
        if copy.config is Undefined:
            copy.config = core.Config()
        else:
            copy.config = copy.config.copy(deep=False)
        copy.config["axisY"] = core.VgAxisConfig(*args, **kwargs)
        return copy

    @use_signature(core.BarConfig)
    def configure_bar(self, *args, **kwargs):
        copy = self.copy(deep=False)
        if copy.config is Undefined:
            copy.config = core.Config()
        else:
            copy.config = copy.config.copy(deep=False)
        copy.config["bar"] = core.BarConfig(*args, **kwargs)
        return copy

    @use_signature(core.MarkConfig)
    def configure_circle(self, *args, **kwargs):
        copy = self.copy(deep=False)
        if copy.config is Undefined:
            copy.config = core.Config()
        else:
            copy.config = copy.config.copy(deep=False)
        copy.config["circle"] = core.MarkConfig(*args, **kwargs)
        return copy

    @use_signature(core.Datasets)
    def configure_datasets(self, *args, **kwargs):
        copy = self.copy(deep=False)
        if copy.config is Undefined:
            copy.config = core.Config()
        else:
            copy.config = copy.config.copy(deep=False)
        copy.config["datasets"] = core.Datasets(*args, **kwargs)
        return copy

    @use_signature(core.MarkConfig)
    def configure_geoshape(self, *args, **kwargs):
        copy = self.copy(deep=False)
        if copy.config is Undefined:
            copy.config = core.Config()
        else:
            copy.config = copy.config.copy(deep=False)
        copy.config["geoshape"] = core.MarkConfig(*args, **kwargs)
        return copy

    @use_signature(core.LegendConfig)
    def configure_legend(self, *args, **kwargs):
        copy = self.copy(deep=False)
        if copy.config is Undefined:
            copy.config = core.Config()
        else:
            copy.config = copy.config.copy(deep=False)
        copy.config["legend"] = core.LegendConfig(*args, **kwargs)
        return copy

    @use_signature(core.MarkConfig)
    def configure_line(self, *args, **kwargs):
        copy = self.copy(deep=False)
        if copy.config is Undefined:
            copy.config = core.Config()
        else:
            copy.config = copy.config.copy(deep=False)
        copy.config["line"] = core.MarkConfig(*args, **kwargs)
        return copy

    @use_signature(core.MarkConfig)
    def configure_mark(self, *args, **kwargs):
        copy = self.copy(deep=False)
        if copy.config is Undefined:
            copy.config = core.Config()
        else:
            copy.config = copy.config.copy(deep=False)
        copy.config["mark"] = core.MarkConfig(*args, **kwargs)
        return copy

    @use_signature(core.Padding)
    def configure_padding(self, *args, **kwargs):
        copy = self.copy(deep=False)
        if copy.config is Undefined:
            copy.config = core.Config()
        else:
            copy.config = copy.config.copy(deep=False)
        copy.config["padding"] = core.Padding(*args, **kwargs)
        return copy

    @use_signature(core.MarkConfig)
    def configure_point(self, *args, **kwargs):
        copy = self.copy(deep=False)
        if copy.config is Undefined:
            copy.config = core.Config()
        else:
            copy.config = copy.config.copy(deep=False)
        copy.config["point"] = core.MarkConfig(*args, **kwargs)
        return copy

    @use_signature(core.ProjectionConfig)
    def configure_projection(self, *args, **kwargs):
        copy = self.copy(deep=False)
        if copy.config is Undefined:
            copy.config = core.Config()
        else:
            copy.config = copy.config.copy(deep=False)
        copy.config["projection"] = core.ProjectionConfig(*args, **kwargs)
        return copy

    @use_signature(core.RangeConfig)
    def configure_range(self, *args, **kwargs):
        copy = self.copy(deep=False)
        if copy.config is Undefined:
            copy.config = core.Config()
        else:
            copy.config = copy.config.copy(deep=False)
        copy.config["range"] = core.RangeConfig(*args, **kwargs)
        return copy

    @use_signature(core.MarkConfig)
    def configure_rect(self, *args, **kwargs):
        copy = self.copy(deep=False)
        if copy.config is Undefined:
            copy.config = core.Config()
        else:
            copy.config = copy.config.copy(deep=False)
        copy.config["rect"] = core.MarkConfig(*args, **kwargs)
        return copy

    @use_signature(core.MarkConfig)
    def configure_rule(self, *args, **kwargs):
        copy = self.copy(deep=False)
        if copy.config is Undefined:
            copy.config = core.Config()
        else:
            copy.config = copy.config.copy(deep=False)
        copy.config["rule"] = core.MarkConfig(*args, **kwargs)
        return copy

    @use_signature(core.ScaleConfig)
    def configure_scale(self, *args, **kwargs):
        copy = self.copy(deep=False)
        if copy.config is Undefined:
            copy.config = core.Config()
        else:
            copy.config = copy.config.copy(deep=False)
        copy.config["scale"] = core.ScaleConfig(*args, **kwargs)
        return copy

    @use_signature(core.SelectionConfig)
    def configure_selection(self, *args, **kwargs):
        copy = self.copy(deep=False)
        if copy.config is Undefined:
            copy.config = core.Config()
        else:
            copy.config = copy.config.copy(deep=False)
        copy.config["selection"] = core.SelectionConfig(*args, **kwargs)
        return copy

    @use_signature(core.MarkConfig)
    def configure_square(self, *args, **kwargs):
        copy = self.copy(deep=False)
        if copy.config is Undefined:
            copy.config = core.Config()
        else:
            copy.config = copy.config.copy(deep=False)
        copy.config["square"] = core.MarkConfig(*args, **kwargs)
        return copy

    @use_signature(core.StackOffset)
    def configure_stack(self, *args, **kwargs):
        copy = self.copy(deep=False)
        if copy.config is Undefined:
            copy.config = core.Config()
        else:
            copy.config = copy.config.copy(deep=False)
        copy.config["stack"] = core.StackOffset(*args, **kwargs)
        return copy

    @use_signature(core.StyleConfigIndex)
    def configure_style(self, *args, **kwargs):
        copy = self.copy(deep=False)
        if copy.config is Undefined:
            copy.config = core.Config()
        else:
            copy.config = copy.config.copy(deep=False)
        copy.config["style"] = core.StyleConfigIndex(*args, **kwargs)
        return copy

    @use_signature(core.TextConfig)
    def configure_text(self, *args, **kwargs):
        copy = self.copy(deep=False)
        if copy.config is Undefined:
            copy.config = core.Config()
        else:
            copy.config = copy.config.copy(deep=False)
        copy.config["text"] = core.TextConfig(*args, **kwargs)
        return copy

    @use_signature(core.TickConfig)
    def configure_tick(self, *args, **kwargs):
        copy = self.copy(deep=False)
        if copy.config is Undefined:
            copy.config = core.Config()
        else:
            copy.config = copy.config.copy(deep=False)
        copy.config["tick"] = core.TickConfig(*args, **kwargs)
        return copy

    @use_signature(core.VgTitleConfig)
    def configure_title(self, *args, **kwargs):
        copy = self.copy(deep=False)
        if copy.config is Undefined:
            copy.config = core.Config()
        else:
            copy.config = copy.config.copy(deep=False)
        copy.config["title"] = core.VgTitleConfig(*args, **kwargs)
        return copy

    @use_signature(core.ViewConfig)
    def configure_view(self, *args, **kwargs):
        copy = self.copy(deep=False)
        if copy.config is Undefined:
            copy.config = core.Config()
        else:
            copy.config = copy.config.copy(deep=False)
        copy.config["view"] = core.ViewConfig(*args, **kwargs)
        return copy