/*!
 * Copyright (c) 2012 - 2022, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
(function(root, factory) {
  const bokeh = factory();
  bokeh.__bokeh__ = true;
  if (typeof root.Bokeh === "undefined" || typeof root.Bokeh.__bokeh__ === "undefined") {
    root.Bokeh = bokeh;
  }
  const Bokeh = root.Bokeh;
  Bokeh[bokeh.version] = bokeh;
})(this, function() {
  let define;
  const parent_require = typeof require === "function" && require
  return (function(modules, entry, aliases, externals) {
  if (aliases === undefined) aliases = {};
  if (externals === undefined) externals = {};

  const cache = {};

  const normalize = function(name) {
    if (typeof name === "number")
      return name;

    if (name === "bokehjs")
      return entry;

    if (!externals[name]) {
      const prefix = "@bokehjs/"
      if (name.slice(0, prefix.length) === prefix)
        name = name.slice(prefix.length)
    }

    const alias = aliases[name]
    if (alias != null)
      return alias;

    const trailing = name.length > 0 && name[name.lenght-1] === "/";
    const index = aliases[name + (trailing ? "" : "/") + "index"];
    if (index != null)
      return index;

    return name;
  }

  const require = function(name) {
    let mod = cache[name];
    if (!mod) {
      const id = normalize(name);

      mod = cache[id];
      if (!mod) {
        if (!modules[id]) {
          if (externals[id] === false || (externals[id] == true && parent_require)) {
            try {
              mod = {exports: externals[id] ? parent_require(id) : {}};
              cache[id] = cache[name] = mod;
              return mod.exports;
            } catch (e) {}
          }

          const err = new Error("Cannot find module '" + name + "'");
          err.code = 'MODULE_NOT_FOUND';
          throw err;
        }

        mod = {exports: {}};
        cache[id] = cache[name] = mod;

        function __esModule() {
          Object.defineProperty(mod.exports, "__esModule", {value: true});
        }

        function __esExport(name, value) {
          Object.defineProperty(mod.exports, name, {
            enumerable: true, get: function () { return value; }
          });
        }

        modules[id].call(mod.exports, require, mod, mod.exports, __esModule, __esExport);
      } else {
        cache[name] = mod;
      }
    }

    return mod.exports;
  }
  require.resolve = function(name) {
    return ""
  }

  const main = require(entry);
  main.require = require;

  if (typeof Proxy !== "undefined") {
    // allow Bokeh.loader["@bokehjs/module/name"] syntax
    main.loader = new Proxy({}, {
      get: function(_obj, module) {
        return require(module);
      }
    });
  }

  main.register_plugin = function(plugin_modules, plugin_entry, plugin_aliases, plugin_externals) {
    if (plugin_aliases === undefined) plugin_aliases = {};
    if (plugin_externals === undefined) plugin_externals = {};

    for (let name in plugin_modules) {
      modules[name] = plugin_modules[name];
    }

    for (let name in plugin_aliases) {
      aliases[name] = plugin_aliases[name];
    }

    for (let name in plugin_externals) {
      externals[name] = plugin_externals[name];
    }

    const plugin = require(plugin_entry);

    for (let name in plugin) {
      main[name] = plugin[name];
    }

    return plugin;
  }

  return main;
})
([
function _(t,_,n,o,r){o();(0,t(1).__exportStar)(t(2),n)},
function _(t,e,r,n,o){n();var a=function(t,e){return a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var r in e)Object.prototype.hasOwnProperty.call(e,r)&&(t[r]=e[r])},a(t,e)};r.__extends=function(t,e){if("function"!=typeof e&&null!==e)throw new TypeError("Class extends value "+String(e)+" is not a constructor or null");function r(){this.constructor=t}a(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)};function i(t){var e="function"==typeof Symbol&&Symbol.iterator,r=e&&t[e],n=0;if(r)return r.call(t);if(t&&"number"==typeof t.length)return{next:function(){return t&&n>=t.length&&(t=void 0),{value:t&&t[n++],done:!t}}};throw new TypeError(e?"Object is not iterable.":"Symbol.iterator is not defined.")}function c(t,e){var r="function"==typeof Symbol&&t[Symbol.iterator];if(!r)return t;var n,o,a=r.call(t),i=[];try{for(;(void 0===e||e-- >0)&&!(n=a.next()).done;)i.push(n.value)}catch(t){o={error:t}}finally{try{n&&!n.done&&(r=a.return)&&r.call(a)}finally{if(o)throw o.error}}return i}function u(t){return this instanceof u?(this.v=t,this):new u(t)}r.__assign=function(){return r.__assign=Object.assign||function(t){for(var e,r=1,n=arguments.length;r<n;r++)for(var o in e=arguments[r])Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o]);return t},r.__assign.apply(this,arguments)},r.__rest=function(t,e){var r={};for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&e.indexOf(n)<0&&(r[n]=t[n]);if(null!=t&&"function"==typeof Object.getOwnPropertySymbols){var o=0;for(n=Object.getOwnPropertySymbols(t);o<n.length;o++)e.indexOf(n[o])<0&&Object.prototype.propertyIsEnumerable.call(t,n[o])&&(r[n[o]]=t[n[o]])}return r},r.__decorate=function(t,e,r,n){var o,a=arguments.length,i=a<3?e:null===n?n=Object.getOwnPropertyDescriptor(e,r):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)i=Reflect.decorate(t,e,r,n);else for(var c=t.length-1;c>=0;c--)(o=t[c])&&(i=(a<3?o(i):a>3?o(e,r,i):o(e,r))||i);return a>3&&i&&Object.defineProperty(e,r,i),i},r.__param=function(t,e){return function(r,n){e(r,n,t)}},r.__metadata=function(t,e){if("object"==typeof Reflect&&"function"==typeof Reflect.metadata)return Reflect.metadata(t,e)},r.__awaiter=function(t,e,r,n){return new(r||(r=Promise))((function(o,a){function i(t){try{u(n.next(t))}catch(t){a(t)}}function c(t){try{u(n.throw(t))}catch(t){a(t)}}function u(t){var e;t.done?o(t.value):(e=t.value,e instanceof r?e:new r((function(t){t(e)}))).then(i,c)}u((n=n.apply(t,e||[])).next())}))},r.__generator=function(t,e){var r,n,o,a,i={label:0,sent:function(){if(1&o[0])throw o[1];return o[1]},trys:[],ops:[]};return a={next:c(0),throw:c(1),return:c(2)},"function"==typeof Symbol&&(a[Symbol.iterator]=function(){return this}),a;function c(a){return function(c){return function(a){if(r)throw new TypeError("Generator is already executing.");for(;i;)try{if(r=1,n&&(o=2&a[0]?n.return:a[0]?n.throw||((o=n.return)&&o.call(n),0):n.next)&&!(o=o.call(n,a[1])).done)return o;switch(n=0,o&&(a=[2&a[0],o.value]),a[0]){case 0:case 1:o=a;break;case 4:return i.label++,{value:a[1],done:!1};case 5:i.label++,n=a[1],a=[0];continue;case 7:a=i.ops.pop(),i.trys.pop();continue;default:if(!(o=i.trys,(o=o.length>0&&o[o.length-1])||6!==a[0]&&2!==a[0])){i=0;continue}if(3===a[0]&&(!o||a[1]>o[0]&&a[1]<o[3])){i.label=a[1];break}if(6===a[0]&&i.label<o[1]){i.label=o[1],o=a;break}if(o&&i.label<o[2]){i.label=o[2],i.ops.push(a);break}o[2]&&i.ops.pop(),i.trys.pop();continue}a=e.call(t,i)}catch(t){a=[6,t],n=0}finally{r=o=0}if(5&a[0])throw a[1];return{value:a[0]?a[1]:void 0,done:!0}}([a,c])}}},r.__createBinding=Object.create?function(t,e,r,n){void 0===n&&(n=r),Object.defineProperty(t,n,{enumerable:!0,get:function(){return e[r]}})}:function(t,e,r,n){void 0===n&&(n=r),t[n]=e[r]},r.__exportStar=function(t,e){for(var n in t)"default"===n||Object.prototype.hasOwnProperty.call(e,n)||(0,r.__createBinding)(e,t,n)},r.__values=i,r.__read=c,r.__spread=function(){for(var t=[],e=0;e<arguments.length;e++)t=t.concat(c(arguments[e]));return t},r.__spreadArrays=function(){for(var t=0,e=0,r=arguments.length;e<r;e++)t+=arguments[e].length;var n=Array(t),o=0;for(e=0;e<r;e++)for(var a=arguments[e],i=0,c=a.length;i<c;i++,o++)n[o]=a[i];return n},r.__spreadArray=function(t,e,r){if(r||2===arguments.length)for(var n,o=0,a=e.length;o<a;o++)!n&&o in e||(n||(n=Array.prototype.slice.call(e,0,o)),n[o]=e[o]);return t.concat(n||Array.prototype.slice.call(e))},r.__await=u,r.__asyncGenerator=function(t,e,r){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var n,o=r.apply(t,e||[]),a=[];return n={},i("next"),i("throw"),i("return"),n[Symbol.asyncIterator]=function(){return this},n;function i(t){o[t]&&(n[t]=function(e){return new Promise((function(r,n){a.push([t,e,r,n])>1||c(t,e)}))})}function c(t,e){try{(r=o[t](e)).value instanceof u?Promise.resolve(r.value.v).then(f,l):s(a[0][2],r)}catch(t){s(a[0][3],t)}var r}function f(t){c("next",t)}function l(t){c("throw",t)}function s(t,e){t(e),a.shift(),a.length&&c(a[0][0],a[0][1])}},r.__asyncDelegator=function(t){var e,r;return e={},n("next"),n("throw",(function(t){throw t})),n("return"),e[Symbol.iterator]=function(){return this},e;function n(n,o){e[n]=t[n]?function(e){return(r=!r)?{value:u(t[n](e)),done:"return"===n}:o?o(e):e}:o}},r.__asyncValues=function(t){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var e,r=t[Symbol.asyncIterator];return r?r.call(t):(t=i(t),e={},n("next"),n("throw"),n("return"),e[Symbol.asyncIterator]=function(){return this},e);function n(r){e[r]=t[r]&&function(e){return new Promise((function(n,o){(function(t,e,r,n){Promise.resolve(n).then((function(e){t({value:e,done:r})}),e)})(n,o,(e=t[r](e)).done,e.value)}))}}},r.__makeTemplateObject=function(t,e){return Object.defineProperty?Object.defineProperty(t,"raw",{value:e}):t.raw=e,t};var f=Object.create?function(t,e){Object.defineProperty(t,"default",{enumerable:!0,value:e})}:function(t,e){t.default=e};r.__importStar=function(t){if(t&&t.__esModule)return t;var e={};if(null!=t)for(var n in t)"default"!==n&&Object.prototype.hasOwnProperty.call(t,n)&&(0,r.__createBinding)(e,t,n);return f(e,t),e},r.__importDefault=function(t){return t&&t.__esModule?t:{default:t}},r.__classPrivateFieldGet=function(t,e,r,n){if("a"===r&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof e?t!==e||!n:!e.has(t))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===r?n:"a"===r?n.call(t):n?n.value:e.get(t)},r.__classPrivateFieldSet=function(t,e,r,n,o){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!o)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof e?t!==e||!o:!e.has(t))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?o.call(t,r):o?o.value=r:e.set(t,r),r}},
function _(e,t,o,s,l){s();const n=e(1);l("version",e(3).version),l("index",e(4).index),o.embed=(0,n.__importStar)(e(4)),o.protocol=(0,n.__importStar)(e(406)),o._testing=(0,n.__importStar)(e(407));var r=e(19);l("logger",r.logger),l("set_log_level",r.set_log_level),l("settings",e(28).settings),l("Models",e(7).Models),l("documents",e(5).documents),l("safely",e(408).safely)},
function _(n,c,i,o,r){o(),i.version="2.4.3-rc.1"},
function _(e,o,t,n,s){n();const d=e(5),r=e(19),_=e(34),c=e(13),i=e(8),a=e(16),u=e(397),l=e(399),m=e(398);var f=e(397);s("add_document_standalone",f.add_document_standalone),s("index",f.index),s("add_document_from_session",e(399).add_document_from_session);var g=e(404);async function w(e,o,t,n){(0,i.isString)(e)&&(e=JSON.parse((0,_.unescape)(e)));const s={};for(const[o,t]of(0,c.entries)(e))s[o]=d.Document.from_json(t);const a=[];for(const e of o){const o=(0,m._resolve_element)(e),d=(0,m._resolve_root_elements)(e);if(null!=e.docid)a.push(await(0,u.add_document_standalone)(s[e.docid],o,d,e.use_for_title));else{if(null==e.token)throw new Error("Error rendering Bokeh items: either 'docid' or 'token' was expected.");{const s=(0,l._get_ws_url)(t,n);r.logger.debug(`embed: computed ws url: ${s}`);try{a.push(await(0,l.add_document_from_session)(s,e.token,o,d,e.use_for_title)),console.log("Bokeh items were rendered successfully")}catch(e){console.log("Error rendering Bokeh items:",e)}}}}return a}s("embed_items_notebook",g.embed_items_notebook),s("kernels",g.kernels),s("BOKEH_ROOT",e(398).BOKEH_ROOT),t.embed_item=async function(e,o){const t={},n=(0,_.uuid4)();t[n]=e.doc,null==o&&(o=e.target_id);const s=document.getElementById(o);null!=s&&s.classList.add(m.BOKEH_ROOT);const d={roots:{[e.root_id]:o},root_ids:[e.root_id],docid:n};await(0,a.defer)();const[r]=await w(t,[d]);return r},t.embed_items=async function(e,o,t,n){return await(0,a.defer)(),w(e,o,t,n)}},
function _(t,_,o,r,n){r();const a=t(1);(0,a.__exportStar)(t(6),o),(0,a.__exportStar)(t(35),o)},
function _(e,t,s,o,n){o();const i=e(1),r=e(7),l=e(3),_=e(19),a=e(251),c=e(14),d=e(30),h=e(15),f=e(17),u=e(31),m=e(29),g=e(9),v=e(13),p=(0,i.__importStar)(e(77)),w=e(26),b=e(8),y=e(309),k=e(75),M=e(53),j=e(396),z=e(35);class S{constructor(e){this.document=e,this.session=null,this.subscribed_models=new Set}send_event(e){const t=new z.MessageSentEvent(this.document,"bokeh_event",e.to_json());this.document._trigger_on_change(t)}trigger(e){for(const t of this.subscribed_models)null!=e.origin&&e.origin!=t||t._process_event(e)}}s.EventManager=S,S.__name__="EventManager",s.documents=[],s.DEFAULT_TITLE="Bokeh Application";class E{constructor(e){var t;s.documents.push(this),this._init_timestamp=Date.now(),this._resolver=null!==(t=null==e?void 0:e.resolver)&&void 0!==t?t:new r.ModelResolver,this._title=s.DEFAULT_TITLE,this._roots=[],this._all_models=new Map,this._all_models_freeze_count=0,this._callbacks=new Map,this._message_callbacks=new Map,this.event_manager=new S(this),this.idle=new h.Signal0(this,"idle"),this._idle_roots=new WeakMap,this._interactive_timestamp=null,this._interactive_plot=null}get layoutables(){return this._roots.filter((e=>e instanceof y.LayoutDOM))}get is_idle(){for(const e of this.layoutables)if(!this._idle_roots.has(e))return!1;return!0}notify_idle(e){this._idle_roots.set(e,!0),this.is_idle&&(_.logger.info(`document idle at ${Date.now()-this._init_timestamp} ms`),this.event_manager.send_event(new a.DocumentReady),this.idle.emit())}clear(){this._push_all_models_freeze();try{for(;this._roots.length>0;)this.remove_root(this._roots[0])}finally{this._pop_all_models_freeze()}}interactive_start(e,t=null){null==this._interactive_plot&&(this._interactive_plot=e,this._interactive_plot.trigger_event(new a.LODStart)),this._interactive_finalize=t,this._interactive_timestamp=Date.now()}interactive_stop(){null!=this._interactive_plot&&(this._interactive_plot.trigger_event(new a.LODEnd),null!=this._interactive_finalize&&this._interactive_finalize()),this._interactive_plot=null,this._interactive_timestamp=null,this._interactive_finalize=null}interactive_duration(){return null==this._interactive_timestamp?-1:Date.now()-this._interactive_timestamp}destructively_move(e){if(e===this)throw new Error("Attempted to overwrite a document with itself");e.clear();const t=(0,g.copy)(this._roots);this.clear();for(const e of t)if(null!=e.document)throw new Error(`Somehow we didn't detach ${e}`);if(0!=this._all_models.size)throw new Error(`this._all_models still had stuff in it: ${this._all_models}`);for(const s of t)e.add_root(s);e.set_title(this._title)}_push_all_models_freeze(){this._all_models_freeze_count+=1}_pop_all_models_freeze(){this._all_models_freeze_count-=1,0===this._all_models_freeze_count&&this._recompute_all_models()}_invalidate_all_models(){_.logger.debug("invalidating document models"),0===this._all_models_freeze_count&&this._recompute_all_models()}_recompute_all_models(){let e=new Set;for(const t of this._roots)e=p.union(e,t.references());const t=new Set(this._all_models.values()),s=p.difference(t,e),o=p.difference(e,t),n=new Map;for(const t of e)n.set(t.id,t);for(const e of s)e.detach_document();for(const e of o)e.attach_document(this);this._all_models=n}roots(){return this._roots}add_root(e,t){if(_.logger.debug(`Adding root: ${e}`),!(0,g.includes)(this._roots,e)){this._push_all_models_freeze();try{this._roots.push(e)}finally{this._pop_all_models_freeze()}this._trigger_on_change(new z.RootAddedEvent(this,e,t))}}remove_root(e,t){const s=this._roots.indexOf(e);if(!(s<0)){this._push_all_models_freeze();try{this._roots.splice(s,1)}finally{this._pop_all_models_freeze()}this._trigger_on_change(new z.RootRemovedEvent(this,e,t))}}title(){return this._title}set_title(e,t){e!==this._title&&(this._title=e,this._trigger_on_change(new z.TitleChangedEvent(this,e,t)))}get_model_by_id(e){var t;return null!==(t=this._all_models.get(e))&&void 0!==t?t:null}get_model_by_name(e){const t=[];for(const s of this._all_models.values())s instanceof M.Model&&s.name==e&&t.push(s);switch(t.length){case 0:return null;case 1:return t[0];default:throw new Error(`Multiple models are named '${e}'`)}}on_message(e,t){const s=this._message_callbacks.get(e);null==s?this._message_callbacks.set(e,new Set([t])):s.add(t)}remove_on_message(e,t){var s;null===(s=this._message_callbacks.get(e))||void 0===s||s.delete(t)}_trigger_on_message(e,t){const s=this._message_callbacks.get(e);if(null!=s)for(const e of s)e(t)}on_change(e,t=!1){this._callbacks.has(e)||this._callbacks.set(e,t)}remove_on_change(e){this._callbacks.delete(e)}_trigger_on_change(e){for(const[t,s]of this._callbacks)if(!s&&e instanceof z.DocumentEventBatch)for(const s of e.events)t(s);else t(e)}_notify_change(e,t,s,o,n){this._trigger_on_change(new z.ModelChangedEvent(this,e,t,s,o,null==n?void 0:n.setter_id,null==n?void 0:n.hint))}static _instantiate_object(e,t,s,o){const n=Object.assign(Object.assign({},s),{id:e,__deferred__:!0});return new(o.get(t))(n)}static _instantiate_references_json(e,t,s){var o;const n=new Map;for(const i of e){const e=i.id,r=i.type,l=null!==(o=i.attributes)&&void 0!==o?o:{};let _=t.get(e);null==_&&(_=E._instantiate_object(e,r,l,s),null!=i.subtype&&_.set_subtype(i.subtype)),n.set(_.id,_)}return n}static _resolve_refs(e,t,s,o){function n(e){var i;if((0,f.is_ref)(e)){const o=null!==(i=t.get(e.id))&&void 0!==i?i:s.get(e.id);if(null!=o)return o;throw new Error(`reference ${JSON.stringify(e)} isn't known (not in Document?)`)}if((0,u.is_NDArray_ref)(e)){const{buffer:t,dtype:s,shape:n}=(0,u.decode_NDArray)(e,o);return(0,m.ndarray)(t,{dtype:s,shape:n})}return(0,b.isArray)(e)?function(e){const t=[];for(const s of e)t.push(n(s));return t}(e):(0,b.isPlainObject)(e)?function(e){const t={};for(const[s,o]of(0,v.entries)(e))t[s]=n(o);return t}(e):e}return n(e)}static _initialize_references_json(e,t,s,o){const n=new Map;for(const{id:i,attributes:r}of e){const e=!t.has(i),l=e?s.get(i):t.get(i),_=E._resolve_refs(r,t,s,o);l.setv(_,{silent:!0}),n.set(i,{instance:l,is_new:e})}const i=[],r=new Set;function l(e){if(e instanceof c.HasProps){if(n.has(e.id)&&!r.has(e.id)){r.add(e.id);const{instance:t,is_new:s}=n.get(e.id),{attributes:o}=t;for(const e of(0,v.values)(o))l(e);s&&(t.finalize(),i.push(t))}}else if((0,b.isArray)(e))for(const t of e)l(t);else if((0,b.isPlainObject)(e))for(const t of(0,v.values)(e))l(t)}for(const e of n.values())l(e.instance);for(const e of i)e.connect_signals()}static _event_for_attribute_change(e,t,s,o,n){if(o.get_model_by_id(e.id).property(t).syncable){const i={kind:"ModelChanged",model:{id:e.id},attr:t,new:s};return c.HasProps._json_record_references(o,s,n,{recursive:!0}),i}return null}static _events_to_sync_objects(e,t,s,o){const n=Object.keys(e.attributes),i=Object.keys(t.attributes),r=(0,g.difference)(n,i),l=(0,g.difference)(i,n),a=(0,g.intersection)(n,i),c=[];for(const e of r)_.logger.warn(`Server sent key ${e} but we don't seem to have it in our JSON`);for(const n of l){const i=t.attributes[n];c.push(E._event_for_attribute_change(e,n,i,s,o))}for(const n of a){const i=e.attributes[n],r=t.attributes[n];null==i&&null==r||(null==i||null==r?c.push(E._event_for_attribute_change(e,n,r,s,o)):"data"==n||(0,w.is_equal)(i,r)||c.push(E._event_for_attribute_change(e,n,r,s,o)))}return c.filter((e=>null!=e))}static _compute_patch_since_json(e,t){const s=t.to_json(!1);function o(e){const t=new Map;for(const s of e.roots.references)t.set(s.id,s);return t}const n=o(e),i=new Map,r=[];for(const t of e.roots.root_ids)i.set(t,n.get(t)),r.push(t);const l=o(s),_=new Map,a=[];for(const e of s.roots.root_ids)_.set(e,l.get(e)),a.push(e);if(r.sort(),a.sort(),(0,g.difference)(r,a).length>0||(0,g.difference)(a,r).length>0)throw new Error("Not implemented: computing add/remove of document roots");const c=new Set;let h=[];for(const e of t._all_models.keys())if(n.has(e)){const s=E._events_to_sync_objects(n.get(e),l.get(e),t,c);h=h.concat(s)}const f=new d.Serializer({include_defaults:!1});return f.to_serializable([...c]),{references:[...f.definitions],events:h}}to_json_string(e=!0){return JSON.stringify(this.to_json(e))}to_json(e=!0){const t=new d.Serializer({include_defaults:e}),s=t.to_serializable(this._roots);return{version:l.version,title:this._title,roots:{root_ids:s.map((e=>e.id)),references:[...t.definitions]}}}static from_json_string(e){const t=JSON.parse(e);return E.from_json(t)}static from_json(e){_.logger.debug("Creating Document from JSON");const t=e.version,s=-1!==t.indexOf("+")||-1!==t.indexOf("-"),o=`Library versions: JS (${l.version}) / Python (${t})`;s||l.version.replace(/-(dev|rc)\./,"$1")==t?_.logger.debug(o):(_.logger.warn("JS/Python version mismatch"),_.logger.warn(o));const n=new r.ModelResolver;null!=e.defs&&(0,j.resolve_defs)(e.defs,n);const i=e.roots,a=i.root_ids,c=i.references,d=E._instantiate_references_json(c,new Map,n);E._initialize_references_json(c,new Map,d,new Map);const h=new E({resolver:n});h._push_all_models_freeze();for(const e of a){const t=d.get(e);null!=t&&h.add_root(t)}return h._pop_all_models_freeze(),h.set_title(e.title),h}replace_with_json(e){E.from_json(e).destructively_move(this)}create_json_patch_string(e){return JSON.stringify(this.create_json_patch(e))}create_json_patch(e){for(const t of e)if(t.document!=this)throw new Error("Cannot create a patch using events from a different document");const t=new d.Serializer,s=t.to_serializable(e);for(const e of this._all_models.values())t.remove_def(e);return{events:s,references:[...t.definitions]}}apply_json_patch(e,t=new Map,s){const o=e.references,n=e.events,i=E._instantiate_references_json(o,this._all_models,this._resolver);t instanceof Map||(t=new Map(t));for(const e of n)switch(e.kind){case"RootAdded":case"RootRemoved":case"ModelChanged":{const t=e.model.id,s=this._all_models.get(t);if(null!=s)i.set(t,s);else if(!i.has(t))throw _.logger.warn(`Got an event for unknown model ${e.model}"`),new Error("event model wasn't known");break}}const r=new Map(this._all_models),l=new Map;for(const[e,t]of i)r.has(e)||l.set(e,t);E._initialize_references_json(o,r,l,t);for(const e of n)switch(e.kind){case"MessageSent":{const{msg_type:s,msg_data:o}=e;let n;if(void 0===o){if(1!=t.size)throw new Error("expected exactly one buffer");{const[[,e]]=t;n=e}}else n=E._resolve_refs(o,r,l,t);this._trigger_on_message(s,n);break}case"ModelChanged":{const o=e.model.id,n=this._all_models.get(o);if(null==n)throw new Error(`Cannot apply patch to ${o} which is not in the document`);const i=e.attr,_=E._resolve_refs(e.new,r,l,t);n.setv({[i]:_},{setter_id:s});break}case"ColumnDataChanged":{const o=e.column_source.id,n=this._all_models.get(o);if(null==n)throw new Error(`Cannot stream to ${o} which is not in the document`);const i=E._resolve_refs(e.new,new Map,new Map,t);if(null!=e.cols)for(const e in n.data)e in i||(i[e]=n.data[e]);n.setv({data:i},{setter_id:s,check_eq:!1});break}case"ColumnsStreamed":{const t=e.column_source.id,o=this._all_models.get(t);if(null==o)throw new Error(`Cannot stream to ${t} which is not in the document`);if(!(o instanceof k.ColumnDataSource))throw new Error("Cannot stream to non-ColumnDataSource");const n=e.data,i=e.rollover;o.stream(n,i,s);break}case"ColumnsPatched":{const t=e.column_source.id,o=this._all_models.get(t);if(null==o)throw new Error(`Cannot patch ${t} which is not in the document`);if(!(o instanceof k.ColumnDataSource))throw new Error("Cannot patch non-ColumnDataSource");const n=e.patches;o.patch(n,s);break}case"RootAdded":{const t=e.model.id,o=i.get(t);this.add_root(o,s);break}case"RootRemoved":{const t=e.model.id,o=i.get(t);this.remove_root(o,s);break}case"TitleChanged":this.set_title(e.title,s);break;default:throw new Error(`Unknown patch event ${JSON.stringify(e)}`)}}}s.Document=E,E.__name__="Document"},
function _(e,o,s,r,t){r();const l=e(1),i=e(8),d=e(13),n=e(14);s.overrides={};const a=new Map;s.Models=e=>{const o=s.Models.get(e);if(null!=o)return o;throw new Error(`Model '${e}' does not exist. This could be due to a widget or a custom model not being registered before first usage.`)},s.Models.get=e=>{var o;return null!==(o=s.overrides[e])&&void 0!==o?o:a.get(e)},s.Models.register=(e,o)=>{s.overrides[e]=o},s.Models.unregister=e=>{delete s.overrides[e]},s.Models.register_models=(e,o=!1,s)=>{var r;if(null!=e)for(const t of(0,i.isArray)(e)?e:(0,d.values)(e))if(r=t,(0,i.isObject)(r)&&r.prototype instanceof n.HasProps){const e=t.__qualified__;o||!a.has(e)?a.set(e,t):null!=s?s(e):console.warn(`Model '${e}' was already registered`)}},s.register_models=s.Models.register_models,s.Models.registered_names=()=>[...a.keys()];class _{constructor(){this._known_models=new Map}get(e,o){var r;const t=null!==(r=s.Models.get(e))&&void 0!==r?r:this._known_models.get(e);if(null!=t)return t;if(void 0!==o)return o;throw new Error(`Model '${e}' does not exist. This could be due to a widget or a custom model not being registered before first usage.`)}register(e){const o=e.__qualified__;null==this.get(o,null)?this._known_models.set(o,e):console.warn(`Model '${o}' was already registered with this resolver`)}}s.ModelResolver=_,_.__name__="ModelResolver";const g=(0,l.__importStar)(e(38));(0,s.register_models)(g);const u=(0,l.__importStar)(e(392));(0,s.register_models)(u)},
function _(n,t,r,e,i){e();
//     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Underscore may be freely distributed under the MIT license.
const o=n(9),u=Object.prototype.toString;function c(n){return!0===n||!1===n||"[object Boolean]"===u.call(n)}function f(n){return"[object Number]"===u.call(n)}function l(n){return"[object String]"===u.call(n)}function s(n){return"symbol"==typeof n}function a(n){const t=typeof n;return"function"===t||"object"===t&&!!n}function b(n){return a(n)&&void 0!==n[Symbol.iterator]}r.isBoolean=c,r.isNumber=f,r.isInteger=function(n){return f(n)&&Number.isInteger(n)},r.isString=l,r.isSymbol=s,r.isPrimitive=function(n){return null===n||c(n)||f(n)||l(n)||s(n)},r.isFunction=function(n){return"[object Function]"===u.call(n)},r.isArray=function(n){return Array.isArray(n)},r.isArrayOf=function(n,t){return(0,o.every)(n,t)},r.isArrayableOf=function(n,t){for(let r=0,e=n.length;r<e;r++)if(!t(n[r]))return!1;return!0},r.isTypedArray=function(n){return ArrayBuffer.isView(n)&&!(n instanceof DataView)},r.isObject=a,r.isPlainObject=function(n){return a(n)&&(null==n.constructor||n.constructor===Object)},r.isIterable=b,r.isArrayable=function(n){return b(n)&&"length"in n}},
function _(n,t,e,r,o){r();
//     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Underscore may be freely distributed under the MIT license.
const i=n(10),u=n(11),c=n(12);o("map",c.map),o("reduce",c.reduce),o("min",c.min),o("min_by",c.min_by),o("max",c.max),o("max_by",c.max_by),o("sum",c.sum),o("cumsum",c.cumsum),o("every",c.every),o("some",c.some),o("find",c.find),o("find_last",c.find_last),o("find_index",c.find_index),o("find_last_index",c.find_last_index),o("sorted_index",c.sorted_index),o("is_empty",c.is_empty);const f=Array.prototype.slice;function s(n){return f.call(n)}function a(n){return[].concat(...n)}function l(n,t){return-1!==n.indexOf(t)}function m(n,t,e=1){(0,u.assert)(e>0,"'step' must be a positive number"),null==t&&(t=n,n=0);const{max:r,ceil:o,abs:i}=Math,c=n<=t?e:-e,f=r(o(i(t-n)/e),0),s=new Array(f);for(let t=0;t<f;t++,n+=c)s[t]=n;return s}e.head=function(n){return n[0]},e.tail=function(n){return n[n.length-1]},e.last=function(n){return n[n.length-1]},e.copy=s,e.concat=a,e.includes=l,e.contains=l,e.nth=function(n,t){return n[t>=0?t:n.length+t]},e.zip=function(...n){if(0==n.length)return[];const t=(0,c.min)(n.map((n=>n.length))),e=n.length,r=new Array(t);for(let o=0;o<t;o++){r[o]=new Array(e);for(let t=0;t<e;t++)r[o][t]=n[t][o]}return r},e.unzip=function(n){const t=n.length,e=(0,c.min)(n.map((n=>n.length))),r=Array(e);for(let n=0;n<e;n++)r[n]=new Array(t);for(let o=0;o<t;o++)for(let t=0;t<e;t++)r[t][o]=n[o][t];return r},e.range=m,e.linspace=function(n,t,e=100){const r=(t-n)/(e-1),o=new Array(e);for(let t=0;t<e;t++)o[t]=n+r*t;return o},e.transpose=function(n){const t=n.length,e=n[0].length,r=[];for(let o=0;o<e;o++){r[o]=[];for(let e=0;e<t;e++)r[o][e]=n[e][o]}return r},e.argmin=function(n){return(0,c.min_by)(m(n.length),(t=>n[t]))},e.argmax=function(n){return(0,c.max_by)(m(n.length),(t=>n[t]))},e.sort_by=function(n,t){const e=n.map(((n,e)=>({value:n,index:e,key:t(n)})));return e.sort(((n,t)=>{const e=n.key,r=t.key;if(e!==r){if(e>r||void 0===e)return 1;if(e<r||void 0===r)return-1}return n.index-t.index})),e.map((n=>n.value))},e.uniq=function(n){const t=new Set;for(const e of n)t.add(e);return[...t]},e.uniq_by=function(n,t){const e=[],r=[];for(const o of n){const n=t(o);l(r,n)||(r.push(n),e.push(o))}return e},e.union=function(...n){const t=new Set;for(const e of n)for(const n of e)t.add(n);return[...t]},e.intersection=function(n,...t){const e=[];n:for(const r of n)if(!l(e,r)){for(const n of t)if(!l(n,r))continue n;e.push(r)}return e},e.difference=function(n,...t){const e=a(t);return n.filter((n=>!l(e,n)))},e.remove_at=function(n,t){const e=s(n);return e.splice(t,1),e},e.remove_by=function(n,t){for(let e=0;e<n.length;)t(n[e])?n.splice(e,1):e++},e.shuffle=function(n){const t=n.length,e=new Array(t);for(let r=0;r<t;r++){const t=(0,i.randomIn)(0,r);t!==r&&(e[r]=e[t]),e[t]=n[r]}return e},e.pairwise=function(n,t){const e=n.length,r=new Array(e-1);for(let o=0;o<e-1;o++)r[o]=t(n[o],n[o+1]);return r},e.reversed=function(n){const t=n.length,e=new Array(t);for(let r=0;r<t;r++)e[t-r-1]=n[r];return e},e.repeat=function(n,t){const e=new Array(t);for(let r=0;r<t;r++)e[r]=n;return e}},
function _(n,t,r,e,o){e();const{PI:a}=Math;function u(n){if(0==n)return 0;for(;n<=0;)n+=2*a;for(;n>2*a;)n-=2*a;return n}function c(n,t){return u(n-t)}function f(){return Math.random()}function i(n){switch(n){case"deg":return a/180;case"rad":return 1;case"grad":return a/200;case"turn":return 2*a}}r.angle_norm=u,r.angle_dist=c,r.angle_between=function(n,t,r,e=!1){const o=c(t,r);if(0==o)return!1;if(o==2*a)return!0;const f=u(n),i=c(t,f)<=o&&c(f,r)<=o;return e?!i:i},r.random=f,r.randomIn=function(n,t){return null==t&&(t=n,n=0),n+Math.floor(Math.random()*(t-n+1))},r.atan2=function(n,t){return Math.atan2(t[1]-n[1],t[0]-n[0])},r.radians=function(n){return n*(a/180)},r.degrees=function(n){return n/(a/180)},r.resolve_angle=function(n,t){return-i(t)*n},r.to_radians_coeff=i,r.rnorm=function(n,t){let r,e;for(;r=f(),e=f(),e=(2*e-1)*Math.sqrt(1/Math.E*2),!(-4*r*r*Math.log(r)>=e*e););let o=e/r;return o=n+t*o,o},r.clamp=function(n,t,r){return n<t?t:n>r?r:n},r.log=function(n,t=Math.E){return Math.log(n)/Math.log(t)},r.float32_epsilon=1.1920928955078125e-7},
function _(r,n,e,o,s){o();class t extends Error{}e.AssertionError=t,t.__name__="AssertionError",e.assert=function(r,n){if(!(!0===r||!1!==r&&r()))throw new t(null!=n?n:"Assertion failed")},e.unreachable=function(){throw new Error("unreachable code")}},
function _(n,t,e,r,o){r();const i=n(10);function l(n,t,e,...r){const o=n.length;t<0&&(t+=o),t<0?t=0:t>o&&(t=o),null==e||e>o-t?e=o-t:e<0&&(e=0);const i=o-e+r.length,l=new n.constructor(i);let u=0;for(;u<t;u++)l[u]=n[u];for(const n of r)l[u++]=n;for(let r=t+e;r<o;r++)l[u++]=n[r];return l}function u(n,t){return l(n,t,n.length-t)}function c(n,t){const e=n.length,r=new n.constructor(e);for(let o=0;o<e;o++)r[o]=t(n[o],o,n);return r}function f(n,t,e){const r=n.length;if(void 0===e&&0==r)throw new Error("can't reduce an empty array without an initial value");let o,i;for(void 0===e?(o=n[0],i=1):(o=e,i=0);i<r;i++)o=t(o,n[i],i,n);return o}function s(n){return function(t,e){const r=t.length;let o=n>0?0:r-1;for(;o>=0&&o<r;o+=n)if(e(t[o]))return o;return-1}}function h(n,t){let e=0,r=n.length;for(;e<r;){const o=Math.floor((e+r)/2);n[o]<t?e=o+1:r=o}return e}function a(n,t,e,r,o){const i=(o-e)/(r-t);let l=i*(n-t)+e;return isFinite(l)||(l=i*(n-r)+o,isFinite(l)||e!=o||(l=e)),l}function g(n,t){if(n<t[0])return-1;if(n>t[t.length-1])return t.length;let e=0,r=t.length-1;for(;r-e!=1;){const o=e+Math.floor((r-e)/2);n>=t[o]?e=o:r=o}return e}e.is_empty=function(n){return 0==n.length},e.copy=function(n){return Array.isArray(n)?n.slice():new n.constructor(n)},e.splice=l,e.head=u,e.insert=function(n,t,e){return l(n,e,0,t)},e.append=function(n,t){return l(n,n.length,0,t)},e.prepend=function(n,t){return l(n,0,0,t)},e.indexOf=function(n,t){for(let e=0,r=n.length;e<r;e++)if(n[e]===t)return e;return-1},e.subselect=function(n,t){const e=t.length,r=new n.constructor(e);for(let o=0;o<e;o++)r[o]=n[t[o]];return r},e.mul=function(n,t,e){const r=n.length,o=null!=e?e:new n.constructor(r);for(let e=0;e<r;e++)o[e]=n[e]*t;return o},e.map=c,e.inplace_map=function(n,t,e){const r=n.length,o=null!=e?e:n;for(let e=0;e<r;e++)o[e]=t(n[e],e)},e.filter=function(n,t){const e=n.length,r=new n.constructor(e);let o=0;for(let i=0;i<e;i++){const e=n[i];t(e,i,n)&&(r[o++]=e)}return u(r,o)},e.reduce=f,e.min=function(n){let t,e=1/0;for(let r=0,o=n.length;r<o;r++)t=n[r],!isNaN(t)&&t<e&&(e=t);return e},e.max=function(n){let t,e=-1/0;for(let r=0,o=n.length;r<o;r++)t=n[r],!isNaN(t)&&t>e&&(e=t);return e},e.minmax=function(n){let t,e=1/0,r=-1/0;for(let o=0,i=n.length;o<i;o++)t=n[o],isNaN(t)||(t<e&&(e=t),t>r&&(r=t));return[e,r]},e.minmax2=function(n,t){let e,r,o=1/0,i=-1/0,l=1/0,u=-1/0;const c=Math.min(n.length,t.length);for(let f=0;f<c;f++)e=n[f],r=t[f],isNaN(e)||isNaN(r)||(e<o&&(o=e),e>i&&(i=e),r<l&&(l=r),r>u&&(u=r));return[o,i,l,u]},e.min_by=function(n,t){if(0==n.length)throw new Error("min_by() called with an empty array");let e=n[0],r=t(e);for(let o=1,i=n.length;o<i;o++){const i=n[o],l=t(i);l<r&&(e=i,r=l)}return e},e.max_by=function(n,t){if(0==n.length)throw new Error("max_by() called with an empty array");let e=n[0],r=t(e);for(let o=1,i=n.length;o<i;o++){const i=n[o],l=t(i);l>r&&(e=i,r=l)}return e},e.sum=function(n){let t=0;for(let e=0,r=n.length;e<r;e++)t+=n[e];return t},e.cumsum=function(n){const t=new n.constructor(n.length);return f(n,((n,e,r)=>t[r]=n+e),0),t},e.every=function(n,t){for(let e=0,r=n.length;e<r;e++)if(!t(n[e]))return!1;return!0},e.some=function(n,t){for(let e=0,r=n.length;e<r;e++)if(t(n[e]))return!0;return!1},e.index_of=function(n,t){for(let e=0,r=n.length;e<r;e++)if(n[e]===t)return e;return-1},e.find_index=s(1),e.find_last_index=s(-1),e.find=function(n,t){const r=(0,e.find_index)(n,t);return-1==r?void 0:n[r]},e.find_last=function(n,t){const r=(0,e.find_last_index)(n,t);return-1==r?void 0:n[r]},e.sorted_index=h,e.bin_counts=function(n,t){const e=t.length-1,r=Array(e).fill(0);for(let o=0;o<n.length;o++){const l=h(t,n[o]);r[(0,i.clamp)(l-1,0,e-1)]+=1}return r},e.interpolate=function(n,t,e){const r=n.length,o=new Array(r);for(let i=0;i<r;i++){const r=n[i];if(isNaN(r)){o[i]=r;continue}const l=g(r,t);if(-1==l)o[i]=e[0];else if(l==t.length)o[i]=e[e.length-1];else if(l==t.length-1||t[l]==r)o[i]=e[l];else{const n=t[l],u=e[l],c=t[l+1],f=e[l+1];o[i]=a(r,n,u,c,f)}}return o},e.left_edge_index=g,e.norm=function(n,t,e){const r=e-t;return c(n,(n=>(n-t)/r))}},
function _(t,e,n,c,o){c();const s=t(9),{hasOwnProperty:r}=Object.prototype;function i(t){return Object.keys(t).length}function u(t){return 0==i(t)}n.keys=Object.keys,n.values=Object.values,n.entries=Object.entries,n.extend=Object.assign,n.clone=function(t){return Object.assign({},t)},n.merge=function(t,e){const n=Object.create(Object.prototype),c=(0,s.concat)([Object.keys(t),Object.keys(e)]);for(const o of c){const c=r.call(t,o)?t[o]:[],i=r.call(e,o)?e[o]:[];n[o]=(0,s.union)(c,i)}return n},n.size=i,n.is_empty=u,n.isEmpty=u,n.to_object=function(t){const e={};for(const[n,c]of t)e[n]=c;return e}},
function _(e,t,s,n,r){n();const i=e(1);var o;const c=e(15),a=e(17),_=(0,i.__importStar)(e(18)),h=(0,i.__importStar)(e(21)),u=e(34),l=e(13),f=e(8),p=e(26),d=e(30),g=e(35),y=e(26),v=e(36),m=e(37),b=(0,i.__importStar)(e(21));class w extends((0,c.Signalable)()){constructor(e={}){var t,s;super(),this._subtype=void 0,this.document=null,this.destroyed=new c.Signal0(this,"destroyed"),this.change=new c.Signal0(this,"change"),this.transformchange=new c.Signal0(this,"transformchange"),this.exprchange=new c.Signal0(this,"exprchange"),this.properties={},this._watchers=new WeakMap,this._pending=!1,this._changing=!1;const n=e instanceof Map?e.get.bind(e):t=>e[t];this.id=null!==(t=n("id"))&&void 0!==t?t:(0,u.uniqueId)();for(const[e,{type:t,default_value:s,options:r}]of(0,l.entries)(this._props)){let i;t instanceof _.PropertyAlias?Object.defineProperty(this.properties,e,{get:()=>this.properties[t.attr],configurable:!1,enumerable:!1}):(i=t instanceof h.Kind?new _.PrimitiveProperty(this,e,t,s,n(e),r):new t(this,e,h.Any,s,n(e),r),this.properties[e]=i)}null!==(s=n("__deferred__"))&&void 0!==s&&s||(this.finalize(),this.connect_signals())}get is_syncable(){return!0}set type(e){console.warn("prototype.type = 'ModelName' is deprecated, use static __name__ instead"),this.constructor.__name__=e}get type(){return this.constructor.__qualified__}static get __qualified__(){const{__module__:e,__name__:t}=this;return null!=e?`${e}.${t}`:t}static get[Symbol.toStringTag](){return this.__name__}static _fix_default(e,t){if(void 0===e||(0,f.isFunction)(e))return e;if((0,f.isPrimitive)(e))return()=>e;{const t=new m.Cloner;return()=>t.clone(e)}}static define(e){for(const[t,s]of(0,l.entries)((0,f.isFunction)(e)?e(b):e)){if(null!=this.prototype._props[t])throw new Error(`attempted to redefine property '${this.prototype.type}.${t}'`);if(null!=this.prototype[t])throw new Error(`attempted to redefine attribute '${this.prototype.type}.${t}'`);Object.defineProperty(this.prototype,t,{get(){return this.properties[t].get_value()},set(e){return this.setv({[t]:e}),this},configurable:!1,enumerable:!0});const[e,n,r={}]=s,i={type:e,default_value:this._fix_default(n,t),options:r},o=Object.assign({},this.prototype._props);o[t]=i,this.prototype._props=o}}static internal(e){const t={};for(const[s,n]of(0,l.entries)((0,f.isFunction)(e)?e(b):e)){const[e,r,i={}]=n;t[s]=[e,r,Object.assign(Object.assign({},i),{internal:!0})]}this.define(t)}static mixins(e){function t(e,t){const s={};for(const[n,r]of(0,l.entries)(t))s[e+n]=r;return s}const s={},n=[];for(const r of(0,f.isArray)(e)?e:[e])if((0,f.isArray)(r)){const[e,i]=r;(0,l.extend)(s,t(e,i)),n.push([e,i])}else{const e=r;(0,l.extend)(s,e),n.push(["",e])}this.define(s),this.prototype._mixins=[...this.prototype._mixins,...n]}static override(e){for(const[t,s]of(0,l.entries)(e)){const e=this._fix_default(s,t),n=this.prototype._props[t];if(null==n)throw new Error(`attempted to override nonexistent '${this.prototype.type}.${t}'`);const r=Object.assign({},this.prototype._props);r[t]=Object.assign(Object.assign({},n),{default_value:e}),this.prototype._props=r}}toString(){return`${this.type}(${this.id})`}property(e){const t=this.properties[e];if(null!=t)return t;throw new Error(`unknown property ${this.type}.${e}`)}get attributes(){const e={};for(const t of this)e[t.attr]=t.get_value();return e}[m.clone](e){const t=new Map;for(const s of this)s.dirty&&t.set(s.attr,e.clone(s.get_value()));return new this.constructor(t)}[y.equals](e,t){for(const s of this){const n=e.property(s.attr);if(!t.eq(s.get_value(),n.get_value()))return!1}return!0}[v.pretty](e){const t=e.token,s=[];for(const n of this)if(n.dirty){const r=n.get_value();s.push(`${n.attr}${t(":")} ${e.to_string(r)}`)}return`${this.constructor.__qualified__}${t("(")}${t("{")}${s.join(`${t(",")} `)}${t("}")}${t(")")}`}[d.serialize](e){const t=this.ref();e.add_ref(this,t);const s=this.struct();for(const t of this)t.syncable&&(e.include_defaults||t.dirty)&&(s.attributes[t.attr]=e.to_serializable(t.get_value()));return e.add_def(this,s),t}finalize(){for(const e of this){if(!(e instanceof _.VectorSpec||e instanceof _.ScalarSpec))continue;const t=e.get_value();if(null!=t){const{transform:e,expr:s}=t;null!=e&&this.connect(e.change,(()=>this.transformchange.emit())),null!=s&&this.connect(s.change,(()=>this.exprchange.emit()))}}this.initialize()}initialize(){}connect_signals(){}disconnect_signals(){c.Signal.disconnectReceiver(this)}destroy(){this.disconnect_signals(),this.destroyed.emit()}clone(){return(new m.Cloner).clone(this)}changed_for(e){const t=this._watchers.get(e);return this._watchers.set(e,!1),null==t||t}_setv(e,t){const s=t.check_eq,n=[],r=this._changing;this._changing=!0;for(const[t,r]of e)!1!==s&&(0,p.is_equal)(t.get_value(),r)||(t.set_value(r),n.push(t));n.length>0&&(this._watchers=new WeakMap,this._pending=!0);for(const e of n)e.change.emit();if(!r){if(!t.no_change)for(;this._pending;)this._pending=!1,this.change.emit();this._pending=!1,this._changing=!1}}setv(e,t={}){const s=(0,l.entries)(e);if(0==s.length)return;if(!0===t.silent){this._watchers=new WeakMap;for(const[e,t]of s)this.properties[e].set_value(t);return}const n=new Map,r=new Map;for(const[e,t]of s){const s=this.properties[e];n.set(s,t),r.set(s,s.get_value())}this._setv(n,t);const{document:i}=this;if(null!=i){const e=[];for(const[t,s]of r)e.push([t,s,t.get_value()]);for(const[,t,s]of e)if(this._needs_invalidate(t,s)){i._invalidate_all_models();break}this._push_changes(e,t)}}getv(e){return this.property(e).get_value()}ref(){return{id:this.id}}struct(){const e={type:this.type,id:this.id,attributes:{}};return null!=this._subtype&&(e.subtype=this._subtype),e}set_subtype(e){this._subtype=e}*[Symbol.iterator](){yield*(0,l.values)(this.properties)}*syncable_properties(){for(const e of this)e.syncable&&(yield e)}serializable_attributes(){const e={};for(const t of this.syncable_properties())e[t.attr]=t.get_value();return e}static _json_record_references(e,t,s,n){const{recursive:r}=n;if((0,a.is_ref)(t)){const n=e.get_model_by_id(t.id);null==n||s.has(n)||w._value_record_references(n,s,{recursive:r})}else if((0,f.isArray)(t))for(const n of t)w._json_record_references(e,n,s,{recursive:r});else if((0,f.isPlainObject)(t))for(const n of(0,l.values)(t))w._json_record_references(e,n,s,{recursive:r})}static _value_record_references(e,t,s){const{recursive:n}=s;if(e instanceof w){if(!t.has(e)&&(t.add(e),n))for(const s of e.syncable_properties()){const e=s.get_value();w._value_record_references(e,t,{recursive:n})}}else if((0,f.isArray)(e))for(const s of e)w._value_record_references(s,t,{recursive:n});else if((0,f.isPlainObject)(e))for(const s of(0,l.values)(e))w._value_record_references(s,t,{recursive:n})}references(){const e=new Set;return w._value_record_references(this,e,{recursive:!0}),e}_doc_attached(){}_doc_detached(){}attach_document(e){if(null!=this.document&&this.document!=e)throw new Error("models must be owned by only a single document");this.document=e,this._doc_attached()}detach_document(){this._doc_detached(),this.document=null}_needs_invalidate(e,t){const s=new Set;w._value_record_references(t,s,{recursive:!1});const n=new Set;w._value_record_references(e,n,{recursive:!1});for(const e of s)if(!n.has(e))return!0;for(const e of n)if(!s.has(e))return!0;return!1}_push_changes(e,t={}){if(!this.is_syncable)return;const{document:s}=this;if(null==s)return;const{setter_id:n}=t,r=[];for(const[t,i,o]of e)t.syncable&&r.push(new g.ModelChangedEvent(s,this,t.attr,i,o,n));if(0!=r.length){let e;1==r.length?[e]=r:e=new g.DocumentEventBatch(s,r,n),s._trigger_on_change(e)}}on_change(e,t){for(const s of(0,f.isArray)(e)?e:[e])this.connect(s.change,t)}}s.HasProps=w,(o=w).prototype._props={},o.prototype._mixins=[]},
function _(n,t,e,l,s){l();const i=n(16),o=n(9);class c{constructor(n,t){this.sender=n,this.name=t}connect(n,t=null){u.has(this.sender)||u.set(this.sender,[]);const e=u.get(this.sender);if(null!=g(e,this,n,t))return!1;const l=null!=t?t:n;a.has(l)||a.set(l,[]);const s=a.get(l),i={signal:this,slot:n,context:t};return e.push(i),s.push(i),!0}disconnect(n,t=null){const e=u.get(this.sender);if(null==e||0===e.length)return!1;const l=g(e,this,n,t);if(null==l)return!1;const s=null!=t?t:n,i=a.get(s);return l.signal=null,d(e),d(i),!0}emit(n){var t;const e=null!==(t=u.get(this.sender))&&void 0!==t?t:[];for(const{signal:t,slot:l,context:s}of e)t===this&&l.call(s,n,this.sender)}}e.Signal=c,c.__name__="Signal";class r extends c{emit(){super.emit(void 0)}}e.Signal0=r,r.__name__="Signal0",function(n){function t(n,t){const e=u.get(n);if(null==e||0===e.length)return;const l=a.get(t);if(null!=l&&0!==l.length){for(const t of l){if(null==t.signal)return;t.signal.sender===n&&(t.signal=null)}d(e),d(l)}}function e(n){var t;const e=u.get(n);if(null!=e&&0!==e.length){for(const n of e){if(null==n.signal)return;const e=null!==(t=n.context)&&void 0!==t?t:n.slot;n.signal=null,d(a.get(e))}d(e)}}function l(n,t,e){const l=a.get(n);if(null!=l&&0!==l.length){for(const n of l){if(null==n.signal)return;if(null!=t&&n.slot!=t)continue;const l=n.signal.sender;null!=e&&e.has(l)||(n.signal=null,d(u.get(l)))}d(l)}}function s(n){const t=u.get(n);if(null!=t&&0!==t.length){for(const n of t)n.signal=null;d(t)}const e=a.get(n);if(null!=e&&0!==e.length){for(const n of e)n.signal=null;d(e)}}n.disconnect_between=t,n.disconnect_sender=e,n.disconnect_receiver=l,n.disconnect_all=s,n.disconnectBetween=t,n.disconnectSender=e,n.disconnectReceiver=l,n.disconnectAll=s}(c||(e.Signal=c={})),e.Signalable=function(){return class{connect(n,t){return n.connect(t,this)}disconnect(n,t){return n.disconnect(t,this)}}};const u=new WeakMap,a=new WeakMap;function g(n,t,e,l){return(0,o.find)(n,(n=>n.signal===t&&n.slot===e&&n.context===l))}const f=new Set;function d(n){0===f.size&&(async()=>{await(0,i.defer)(),function(){for(const n of f)(0,o.remove_by)(n,(n=>null==n.signal));f.clear()}()})(),f.add(n)}},
function _(e,n,t,s,o){s();const r=new MessageChannel,a=new Map;r.port1.onmessage=e=>{const n=e.data,t=a.get(n);if(null!=t)try{t()}finally{a.delete(n)}};let i=1;t.defer=function(){return new Promise((e=>{const n=i++;a.set(n,e),r.port2.postMessage(n)}))},t.wait=function(e){return new Promise((n=>setTimeout(n,e)))}},
function _(n,t,i,e,c){e();const r=n(8),s=n(13);i.is_ref=function(n){if((0,r.isPlainObject)(n)){const t=(0,s.keys)(n);return 1==t.length&&"id"==t[0]}return!1}},
function _(e,t,n,r,a){r(),n.YCoordinateSeqSeqSeqSpec=n.XCoordinateSeqSeqSeqSpec=n.YCoordinateSeqSpec=n.XCoordinateSeqSpec=n.YCoordinateSpec=n.XCoordinateSpec=n.CoordinateSeqSeqSeqSpec=n.CoordinateSeqSpec=n.CoordinateSpec=n.BaseCoordinateSpec=n.NumberUnitsSpec=n.UnitsSpec=n.DataSpec=n.VectorSpec=n.TextBaselineScalar=n.TextAlignScalar=n.FontStyleScalar=n.FontSizeScalar=n.FontScalar=n.LineDashScalar=n.LineCapScalar=n.LineJoinScalar=n.ArrayScalar=n.NullStringScalar=n.StringScalar=n.NumberScalar=n.ColorScalar=n.AnyScalar=n.ScalarSpec=n.VerticalAlign=n.UpdateMode=n.TooltipAttachment=n.TickLabelOrientation=n.TextureRepetition=n.TextBaseline=n.TextAlign=n.TapBehavior=n.StepMode=n.StartEnd=n.SpatialUnits=n.Sort=n.SizingMode=n.Side=n.RoundingFunction=n.ResetPolicy=n.RenderMode=n.RenderLevel=n.RadiusDimension=n.PointPolicy=n.Place=void 0,n.TextBaselineSpec=n.TextAlignSpec=n.FontStyleSpec=n.FontSizeSpec=n.FontSpec=n.LineDashSpec=n.LineCapSpec=n.LineJoinSpec=n.MarkerSpec=n.ArraySpec=n.NullStringSpec=n.StringSpec=n.AnySpec=n.NDArraySpec=n.ColorSpec=n.ScreenSizeSpec=n.NumberSpec=n.IntSpec=n.BooleanSpec=n.NullDistanceSpec=n.DistanceSpec=n.AngleSpec=void 0;const i=e(1),s=e(15),l=e(19),o=(0,i.__importStar)(e(20)),c=e(24),_=e(9),u=e(12),d=e(10),S=e(22),p=e(27),m=e(8),h=e(28),v=e(29),y=e(33);function x(e){try{return JSON.stringify(e)}catch(t){return e.toString()}}function g(e){return(0,m.isPlainObject)(e)&&(void 0===e.value?0:1)+(void 0===e.field?0:1)+(void 0===e.expr?0:1)==1}a("Uniform",y.Uniform),a("UniformScalar",y.UniformScalar),a("UniformVector",y.UniformVector),n.isSpec=g;class f{constructor(e,t,n,r,a,i={}){var l;let o;if(this.obj=e,this.attr=t,this.kind=n,this.default_value=r,this._dirty=!1,this.change=new s.Signal0(this.obj,"change"),this.internal=null!==(l=i.internal)&&void 0!==l&&l,this.convert=i.convert,this.on_update=i.on_update,void 0!==a)o=a,this._dirty=!0;else{const t=this._default_override();if(void 0!==t)o=t;else{if(void 0===r)return void(this.spec={value:null});o=r(e)}}this._update(o)}get is_value(){return void 0!==this.spec.value}get syncable(){return!this.internal}get_value(){return this.spec.value}set_value(e){this._update(e),this._dirty=!0}_default_override(){}get dirty(){return this._dirty}_update(e){var t;if(this.validate(e),null!=this.convert){const t=this.convert(e);void 0!==t&&(e=t)}this.spec={value:e},null===(t=this.on_update)||void 0===t||t.call(this,e,this.obj)}toString(){return`Prop(${this.obj}.${this.attr}, spec: ${x(this.spec)})`}normalize(e){return e}validate(e){if(!this.valid(e))throw new Error(`${this.obj}.${this.attr} given invalid value: ${x(e)}`)}valid(e){return this.kind.valid(e)}_value(e=!0){if(!this.is_value)throw new Error("attempted to retrieve property value for property without value specification");let t=this.normalize([this.spec.value])[0];return null!=this.spec.transform&&e&&(t=this.spec.transform.compute(t)),t}}n.Property=f,f.__name__="Property";class A{constructor(e){this.attr=e}}n.PropertyAlias=A,A.__name__="PropertyAlias",n.Alias=function(e){return new A(e)};class C extends f{}n.PrimitiveProperty=C,C.__name__="PrimitiveProperty";class T extends f{}n.Any=T,T.__name__="Any";class L extends f{valid(e){return(0,m.isArray)(e)||(0,m.isTypedArray)(e)}}n.Array=L,L.__name__="Array";class w extends f{valid(e){return(0,m.isBoolean)(e)}}n.Boolean=w,w.__name__="Boolean";class P extends f{valid(e){return(0,S.is_Color)(e)}}n.Color=P,P.__name__="Color";class b extends f{}n.Instance=b,b.__name__="Instance";class q extends f{valid(e){return(0,m.isNumber)(e)}}n.Number=q,q.__name__="Number";class N extends q{valid(e){return(0,m.isNumber)(e)&&(0|e)==e}}n.Int=N,N.__name__="Int";class z extends q{}n.Angle=z,z.__name__="Angle";class B extends q{valid(e){return(0,m.isNumber)(e)&&0<=e&&e<=1}}n.Percent=B,B.__name__="Percent";class F extends f{valid(e){return(0,m.isString)(e)}}n.String=F,F.__name__="String";class D extends f{valid(e){return null===e||(0,m.isString)(e)}}n.NullString=D,D.__name__="NullString";class U extends F{}n.FontSize=U,U.__name__="FontSize";class M extends F{_default_override(){return h.settings.dev?"Bokeh":void 0}}n.Font=M,M.__name__="Font";class R extends f{valid(e){return(0,m.isString)(e)&&(0,_.includes)(this.enum_values,e)}}function k(e){return class extends R{get enum_values(){return[...e]}}}n.EnumProperty=R,R.__name__="EnumProperty",n.Enum=k;class O extends R{get enum_values(){return[...o.Direction]}normalize(e){const t=new Uint8Array(e.length);for(let n=0;n<e.length;n++)switch(e[n]){case"clock":t[n]=0;break;case"anticlock":t[n]=1}return t}}n.Direction=O,O.__name__="Direction",n.Anchor=k(o.Anchor),n.AngleUnits=k(o.AngleUnits),n.BoxOrigin=k(o.BoxOrigin),n.ButtonType=k(o.ButtonType),n.CalendarPosition=k(o.CalendarPosition),n.Dimension=k(o.Dimension),n.Dimensions=k(o.Dimensions),n.Distribution=k(o.Distribution),n.FontStyle=k(o.FontStyle),n.HatchPatternType=k(o.HatchPatternType),n.HTTPMethod=k(o.HTTPMethod),n.HexTileOrientation=k(o.HexTileOrientation),n.HoverMode=k(o.HoverMode),n.LatLon=k(o.LatLon),n.LegendClickPolicy=k(o.LegendClickPolicy),n.LegendLocation=k(o.LegendLocation),n.LineCap=k(o.LineCap),n.LineJoin=k(o.LineJoin),n.LinePolicy=k(o.LinePolicy),n.Location=k(o.Location),n.Logo=k(o.Logo),n.MarkerType=k(o.MarkerType),n.MutedPolicy=k(o.MutedPolicy),n.Orientation=k(o.Orientation),n.OutputBackend=k(o.OutputBackend),n.PaddingUnits=k(o.PaddingUnits),n.Place=k(o.Place),n.PointPolicy=k(o.PointPolicy),n.RadiusDimension=k(o.RadiusDimension),n.RenderLevel=k(o.RenderLevel),n.RenderMode=k(o.RenderMode),n.ResetPolicy=k(o.ResetPolicy),n.RoundingFunction=k(o.RoundingFunction),n.Side=k(o.Side),n.SizingMode=k(o.SizingMode),n.Sort=k(o.Sort),n.SpatialUnits=k(o.SpatialUnits),n.StartEnd=k(o.StartEnd),n.StepMode=k(o.StepMode),n.TapBehavior=k(o.TapBehavior),n.TextAlign=k(o.TextAlign),n.TextBaseline=k(o.TextBaseline),n.TextureRepetition=k(o.TextureRepetition),n.TickLabelOrientation=k(o.TickLabelOrientation),n.TooltipAttachment=k(o.TooltipAttachment),n.UpdateMode=k(o.UpdateMode),n.VerticalAlign=k(o.VerticalAlign);class E extends f{get_value(){const{value:e,expr:t,transform:n}=this.spec;return null!=t||null!=n?this.spec:e}_update(e){g(e)?this.spec=e:this.spec={value:e},null!=this.spec.value&&this.validate(this.spec.value)}materialize(e){return e}scalar(e,t){return new y.UniformScalar(e,t)}uniform(e){var t;const{expr:n,value:r,transform:a}=this.spec,i=null!==(t=e.get_length())&&void 0!==t?t:1;if(null!=n){let t=n.compute(e);return null!=a&&(t=a.compute(t)),t=this.materialize(t),this.scalar(t,i)}{let e=r;return null!=a&&(e=a.compute(e)),e=this.materialize(e),this.scalar(e,i)}}}n.ScalarSpec=E,E.__name__="ScalarSpec";class V extends E{}n.AnyScalar=V,V.__name__="AnyScalar";class $ extends E{}n.ColorScalar=$,$.__name__="ColorScalar";class I extends E{}n.NumberScalar=I,I.__name__="NumberScalar";class J extends E{}n.StringScalar=J,J.__name__="StringScalar";class X extends E{}n.NullStringScalar=X,X.__name__="NullStringScalar";class Y extends E{}n.ArrayScalar=Y,Y.__name__="ArrayScalar";class H extends E{}n.LineJoinScalar=H,H.__name__="LineJoinScalar";class j extends E{}n.LineCapScalar=j,j.__name__="LineCapScalar";class G extends E{}n.LineDashScalar=G,G.__name__="LineDashScalar";class K extends E{_default_override(){return h.settings.dev?"Bokeh":void 0}}n.FontScalar=K,K.__name__="FontScalar";class Q extends E{}n.FontSizeScalar=Q,Q.__name__="FontSizeScalar";class W extends E{}n.FontStyleScalar=W,W.__name__="FontStyleScalar";class Z extends E{}n.TextAlignScalar=Z,Z.__name__="TextAlignScalar";class ee extends E{}n.TextBaselineScalar=ee,ee.__name__="TextBaselineScalar";class te extends f{get_value(){return null===this.spec.value?null:this.spec}_update(e){g(e)?this.spec=e:this.spec={value:e},null!=this.spec.value&&this.validate(this.spec.value)}materialize(e){return e}v_materialize(e){return e}scalar(e,t){return new y.UniformScalar(e,t)}vector(e){return new y.UniformVector(e)}uniform(e){var t;const{field:n,expr:r,value:a,transform:i}=this.spec,s=null!==(t=e.get_length())&&void 0!==t?t:1;if(null!=n){let t=e.get_column(n);return null!=t?(null!=i&&(t=i.v_compute(t)),t=this.v_materialize(t),this.vector(t)):(l.logger.warn(`attempted to retrieve property array for nonexistent field '${n}'`),this.scalar(null,s))}if(null!=r){let t=r.v_compute(e);return null!=i&&(t=i.v_compute(t)),t=this.v_materialize(t),this.vector(t)}{let e=a;return null!=i&&(e=i.compute(e)),e=this.materialize(e),this.scalar(e,s)}}array(e){var t;let n;const r=null!==(t=e.get_length())&&void 0!==t?t:1;if(null!=this.spec.field){const t=e.get_column(this.spec.field);if(null!=t)n=this.normalize(t);else{l.logger.warn(`attempted to retrieve property array for nonexistent field '${this.spec.field}'`);const e=new Float64Array(r);e.fill(NaN),n=e}}else if(null!=this.spec.expr)n=this.normalize(this.spec.expr.v_compute(e));else{const e=this._value(!1);if((0,m.isNumber)(e)){const t=new Float64Array(r);t.fill(e),n=t}else n=(0,_.repeat)(e,r)}return null!=this.spec.transform&&(n=this.spec.transform.v_compute(n)),n}}n.VectorSpec=te,te.__name__="VectorSpec";class ne extends te{}n.DataSpec=ne,ne.__name__="DataSpec";class re extends te{_update(e){super._update(e);const{units:t}=this.spec;if(null!=t&&!(0,_.includes)(this.valid_units,t))throw new Error(`units must be one of ${this.valid_units.join(", ")}; got: ${t}`)}get units(){var e;return null!==(e=this.spec.units)&&void 0!==e?e:this.default_units}set units(e){e!=this.default_units?this.spec.units=e:delete this.spec.units}}n.UnitsSpec=re,re.__name__="UnitsSpec";class ae extends re{array(e){return new Float64Array(super.array(e))}}n.NumberUnitsSpec=ae,ae.__name__="NumberUnitsSpec";class ie extends ne{}n.BaseCoordinateSpec=ie,ie.__name__="BaseCoordinateSpec";class se extends ie{}n.CoordinateSpec=se,se.__name__="CoordinateSpec";class le extends ie{}n.CoordinateSeqSpec=le,le.__name__="CoordinateSeqSpec";class oe extends ie{}n.CoordinateSeqSeqSeqSpec=oe,oe.__name__="CoordinateSeqSeqSeqSpec";class ce extends se{constructor(){super(...arguments),this.dimension="x"}}n.XCoordinateSpec=ce,ce.__name__="XCoordinateSpec";class _e extends se{constructor(){super(...arguments),this.dimension="y"}}n.YCoordinateSpec=_e,_e.__name__="YCoordinateSpec";class ue extends le{constructor(){super(...arguments),this.dimension="x"}}n.XCoordinateSeqSpec=ue,ue.__name__="XCoordinateSeqSpec";class de extends le{constructor(){super(...arguments),this.dimension="y"}}n.YCoordinateSeqSpec=de,de.__name__="YCoordinateSeqSpec";class Se extends oe{constructor(){super(...arguments),this.dimension="x"}}n.XCoordinateSeqSeqSeqSpec=Se,Se.__name__="XCoordinateSeqSeqSeqSpec";class pe extends oe{constructor(){super(...arguments),this.dimension="y"}}n.YCoordinateSeqSeqSeqSpec=pe,pe.__name__="YCoordinateSeqSeqSeqSpec";class me extends ae{get default_units(){return"rad"}get valid_units(){return[...o.AngleUnits]}materialize(e){return e*-(0,d.to_radians_coeff)(this.units)}v_materialize(e){const t=-(0,d.to_radians_coeff)(this.units),n=new Float32Array(e.length);return(0,u.mul)(e,t,n),n}array(e){throw new Error("not supported")}}n.AngleSpec=me,me.__name__="AngleSpec";class he extends ae{get default_units(){return"data"}get valid_units(){return[...o.SpatialUnits]}}n.DistanceSpec=he,he.__name__="DistanceSpec";class ve extends he{materialize(e){return null!=e?e:NaN}}n.NullDistanceSpec=ve,ve.__name__="NullDistanceSpec";class ye extends ne{v_materialize(e){return new Uint8Array(e)}array(e){return new Uint8Array(super.array(e))}}n.BooleanSpec=ye,ye.__name__="BooleanSpec";class xe extends ne{v_materialize(e){return(0,m.isTypedArray)(e)?e:new Int32Array(e)}array(e){return new Int32Array(super.array(e))}}n.IntSpec=xe,xe.__name__="IntSpec";class ge extends ne{v_materialize(e){return(0,m.isTypedArray)(e)?e:new Float64Array(e)}array(e){return new Float64Array(super.array(e))}}n.NumberSpec=ge,ge.__name__="NumberSpec";class fe extends ge{valid(e){return(0,m.isNumber)(e)&&e>=0}}n.ScreenSizeSpec=fe,fe.__name__="ScreenSizeSpec";class Ae extends ne{materialize(e){return(0,S.encode_rgba)((0,S.color2rgba)(e))}v_materialize(e){if(!(0,v.is_NDArray)(e)){const t=e.length,n=new c.RGBAArray(4*t);let r=0;for(const t of e){const[e,a,i,s]=(0,S.color2rgba)(t);n[r++]=e,n[r++]=a,n[r++]=i,n[r++]=s}return new c.ColorArray(n.buffer)}if("uint32"==e.dtype&&1==e.dimension)return(0,p.to_big_endian)(e);if("uint8"==e.dtype&&1==e.dimension){const[t]=e.shape,n=new c.RGBAArray(4*t);let r=0;for(const t of e)n[r++]=t,n[r++]=t,n[r++]=t,n[r++]=255;return new c.ColorArray(n.buffer)}if("uint8"==e.dtype&&2==e.dimension){const[t,n]=e.shape;if(4==n)return new c.ColorArray(e.buffer);if(3==n){const r=new c.RGBAArray(4*t);for(let a=0,i=0;a<n*t;)r[i++]=e[a++],r[i++]=e[a++],r[i++]=e[a++],r[i++]=255;return new c.ColorArray(r.buffer)}}else if(("float32"==e.dtype||"float64"==e.dtype)&&2==e.dimension){const[t,n]=e.shape;if(3==n||4==n){const r=new c.RGBAArray(4*t);for(let a=0,i=0;a<n*t;)r[i++]=255*e[a++],r[i++]=255*e[a++],r[i++]=255*e[a++],r[i++]=255*(3==n?1:e[a++]);return new c.ColorArray(r.buffer)}}throw new Error("invalid color array")}vector(e){return new y.ColorUniformVector(e)}}n.ColorSpec=Ae,Ae.__name__="ColorSpec";class Ce extends ne{}n.NDArraySpec=Ce,Ce.__name__="NDArraySpec";class Te extends ne{}n.AnySpec=Te,Te.__name__="AnySpec";class Le extends ne{}n.StringSpec=Le,Le.__name__="StringSpec";class we extends ne{}n.NullStringSpec=we,we.__name__="NullStringSpec";class Pe extends ne{}n.ArraySpec=Pe,Pe.__name__="ArraySpec";class be extends ne{}n.MarkerSpec=be,be.__name__="MarkerSpec";class qe extends ne{}n.LineJoinSpec=qe,qe.__name__="LineJoinSpec";class Ne extends ne{}n.LineCapSpec=Ne,Ne.__name__="LineCapSpec";class ze extends ne{}n.LineDashSpec=ze,ze.__name__="LineDashSpec";class Be extends ne{_default_override(){return h.settings.dev?"Bokeh":void 0}}n.FontSpec=Be,Be.__name__="FontSpec";class Fe extends ne{}n.FontSizeSpec=Fe,Fe.__name__="FontSizeSpec";class De extends ne{}n.FontStyleSpec=De,De.__name__="FontStyleSpec";class Ue extends ne{}n.TextAlignSpec=Ue,Ue.__name__="TextAlignSpec";class Me extends ne{}n.TextBaselineSpec=Me,Me.__name__="TextBaselineSpec"},
function _(e,l,o,n,t){n();const s=e(8),g=e(13),r={};class i{constructor(e,l){this.name=e,this.level=l}}o.LogLevel=i,i.__name__="LogLevel";class v{constructor(e,l=v.INFO){this._name=e,this.set_level(l)}static get levels(){return Object.keys(v.log_levels)}static get(e,l=v.INFO){if(e.length>0){let o=r[e];return null==o&&(r[e]=o=new v(e,l)),o}throw new TypeError("Logger.get() expects a non-empty string name and an optional log-level")}get level(){return this.get_level()}get_level(){return this._log_level}set_level(e){if(e instanceof i)this._log_level=e;else{if(!(0,s.isString)(e)||null==v.log_levels[e])throw new Error("Logger.set_level() expects a log-level object or a string name of a log-level");this._log_level=v.log_levels[e]}const l=`[${this._name}]`;for(const[e,o]of(0,g.entries)(v.log_levels))o.level<this._log_level.level||this._log_level.level===v.OFF.level?this[e]=function(){}:this[e]=_(e,l)}trace(...e){}debug(...e){}info(...e){}warn(...e){}error(...e){}}function _(e,l){return null!=console[e]?console[e].bind(console,l):null!=console.log?console.log.bind(console,l):function(){}}function c(e){const l=o.logger.level;return(0,s.isString)(e)&&null==v.log_levels[e]?(console.log(`[bokeh] unrecognized logging level '${e}' passed to Bokeh.set_log_level(), ignoring`),console.log(`[bokeh] valid log levels are: ${v.levels.join(", ")}`)):(console.log(`[bokeh] setting log level to: '${(0,s.isString)(e)?e:e.level}'`),o.logger.set_level(e)),l}o.Logger=v,v.__name__="Logger",v.TRACE=new i("trace",0),v.DEBUG=new i("debug",1),v.INFO=new i("info",2),v.WARN=new i("warn",6),v.ERROR=new i("error",7),v.FATAL=new i("fatal",8),v.OFF=new i("off",9),v.log_levels={trace:v.TRACE,debug:v.DEBUG,info:v.INFO,warn:v.WARN,error:v.ERROR,fatal:v.FATAL,off:v.OFF},o.logger=v.get("bokeh"),o.set_log_level=c,o.with_log_level=function(e,l){const o=c(e);try{l()}finally{c(o)}}},
function _(e,n,t,o,i){o(),t.VerticalAlign=void 0;const a=e(21);t.Align=(0,a.Enum)("start","center","end"),t.Anchor=(0,a.Enum)("top_left","top_center","top_right","center_left","center_center","center_right","bottom_left","bottom_center","bottom_right","top","left","center","right","bottom"),t.AngleUnits=(0,a.Enum)("deg","rad","grad","turn"),t.BoxOrigin=(0,a.Enum)("corner","center"),t.ButtonType=(0,a.Enum)("default","primary","success","warning","danger","light"),t.CalendarPosition=(0,a.Enum)("auto","above","below"),t.Dimension=(0,a.Enum)("width","height"),t.Dimensions=(0,a.Enum)("width","height","both"),t.Direction=(0,a.Enum)("clock","anticlock"),t.Distribution=(0,a.Enum)("uniform","normal"),t.FontStyle=(0,a.Enum)("normal","italic","bold","bold italic"),t.HatchPatternType=(0,a.Enum)("blank","dot","ring","horizontal_line","vertical_line","cross","horizontal_dash","vertical_dash","spiral","right_diagonal_line","left_diagonal_line","diagonal_cross","right_diagonal_dash","left_diagonal_dash","horizontal_wave","vertical_wave","criss_cross"," ",".","o","-","|","+",'"',":","@","/","\\","x",",","`","v",">","*"),t.HTTPMethod=(0,a.Enum)("POST","GET"),t.HexTileOrientation=(0,a.Enum)("pointytop","flattop"),t.HoverMode=(0,a.Enum)("mouse","hline","vline"),t.LatLon=(0,a.Enum)("lat","lon"),t.LegendClickPolicy=(0,a.Enum)("none","hide","mute"),t.LegendLocation=t.Anchor,t.LineCap=(0,a.Enum)("butt","round","square"),t.LineJoin=(0,a.Enum)("miter","round","bevel"),t.LineDash=(0,a.Enum)("solid","dashed","dotted","dotdash","dashdot"),t.LinePolicy=(0,a.Enum)("prev","next","nearest","interp","none"),t.Location=(0,a.Enum)("above","below","left","right"),t.Logo=(0,a.Enum)("normal","grey"),t.MarkerType=(0,a.Enum)("asterisk","circle","circle_cross","circle_dot","circle_x","circle_y","cross","dash","diamond","diamond_cross","diamond_dot","dot","hex","hex_dot","inverted_triangle","plus","square","square_cross","square_dot","square_pin","square_x","star","star_dot","triangle","triangle_dot","triangle_pin","x","y"),t.MutedPolicy=(0,a.Enum)("show","ignore"),t.Orientation=(0,a.Enum)("vertical","horizontal"),t.OutputBackend=(0,a.Enum)("canvas","svg","webgl"),t.PaddingUnits=(0,a.Enum)("percent","absolute"),t.Place=(0,a.Enum)("above","below","left","right","center"),t.PointPolicy=(0,a.Enum)("snap_to_data","follow_mouse","none"),t.RadiusDimension=(0,a.Enum)("x","y","max","min"),t.RenderLevel=(0,a.Enum)("image","underlay","glyph","guide","annotation","overlay"),t.RenderMode=(0,a.Enum)("canvas","css"),t.ResetPolicy=(0,a.Enum)("standard","event_only"),t.RoundingFunction=(0,a.Enum)("round","nearest","floor","rounddown","ceil","roundup"),t.SelectionMode=(0,a.Enum)("replace","append","intersect","subtract"),t.Side=(0,a.Enum)("above","below","left","right"),t.SizingMode=(0,a.Enum)("stretch_width","stretch_height","stretch_both","scale_width","scale_height","scale_both","fixed"),t.Sort=(0,a.Enum)("ascending","descending"),t.SpatialUnits=(0,a.Enum)("screen","data"),t.StartEnd=(0,a.Enum)("start","end"),t.StepMode=(0,a.Enum)("after","before","center"),t.TapBehavior=(0,a.Enum)("select","inspect"),t.TextAlign=(0,a.Enum)("left","right","center"),t.TextBaseline=(0,a.Enum)("top","middle","bottom","alphabetic","hanging","ideographic"),t.TextureRepetition=(0,a.Enum)("repeat","repeat_x","repeat_y","no_repeat"),t.TickLabelOrientation=(0,a.Enum)("vertical","horizontal","parallel","normal"),t.TooltipAttachment=(0,a.Enum)("horizontal","vertical","left","right","above","below"),t.UpdateMode=(0,a.Enum)("replace","append"),t.VerticalAlign=(0,a.Enum)("top","middle","bottom")},
function _(e,n,t,s,r){s();const i=(0,e(1).__importStar)(e(8)),a=e(22),l=e(13),_=window.Map,{hasOwnProperty:u}=Object.prototype;class d{}t.Kind=d,d.__name__="Kind",function(e){class n extends d{valid(e){return!0}}n.__name__="Any",e.Any=n;class t extends d{valid(e){return!0}}t.__name__="Unknown",e.Unknown=t;class s extends d{valid(e){return i.isBoolean(e)}}s.__name__="Boolean",e.Boolean=s;class r extends d{constructor(e){super(),this.obj_type=e}valid(e){return!0}}r.__name__="Ref",e.Ref=r;class c extends d{valid(e){return!0}}c.__name__="AnyRef",e.AnyRef=c;class o extends d{valid(e){return i.isNumber(e)}}o.__name__="Number",e.Number=o;class p extends o{valid(e){return super.valid(e)&&i.isInteger(e)}}p.__name__="Int",e.Int=p;class y extends o{valid(e){return super.valid(e)&&0<=e&&e<=1}}y.__name__="Percent",e.Percent=y;class m extends d{constructor(e){super(),this.types=e,this.types=e}valid(e){return this.types.some((n=>n.valid(e)))}}m.__name__="Or",e.Or=m;class v extends d{constructor(e){super(),this.types=e,this.types=e}valid(e){if(!i.isArray(e))return!1;for(let n=0;n<this.types.length;n++){const t=this.types[n],s=e[n];if(!t.valid(s))return!1}return!0}}v.__name__="Tuple",e.Tuple=v;class w extends d{constructor(e){super(),this.struct_type=e}valid(e){if(!i.isPlainObject(e))return!1;const{struct_type:n}=this;if((0,l.size)(n)!=(0,l.size)(e))return!1;for(const t in n)if(u.call(n,t)){if(!u.call(e,t))return!1;const s=n[t],r=e[t];if(!s.valid(r))return!1}return!0}}w.__name__="Struct",e.Struct=w;class h extends d{valid(e){return i.isArray(e)||i.isTypedArray(e)}}h.__name__="Arrayable",e.Arrayable=h;class f extends d{constructor(e){super(),this.item_type=e}valid(e){return i.isArray(e)&&e.every((e=>this.item_type.valid(e)))}}f.__name__="Array",e.Array=f;class K extends d{valid(e){return null===e}}K.__name__="Null",e.Null=K;class b extends d{constructor(e){super(),this.base_type=e}valid(e){return null===e||this.base_type.valid(e)}}b.__name__="Nullable",e.Nullable=b;class A extends d{constructor(e){super(),this.base_type=e}valid(e){return void 0===e||this.base_type.valid(e)}}A.__name__="Opt",e.Opt=A;class x extends d{valid(e){return i.isString(e)}}x.__name__="String",e.String=x;class S extends d{constructor(e){super(),this.values=new Set(e)}valid(e){return this.values.has(e)}*[Symbol.iterator](){yield*this.values}}S.__name__="Enum",e.Enum=S;class N extends d{constructor(e){super(),this.item_type=e}valid(e){if(!i.isPlainObject(e))return!1;for(const n in e)if(u.call(e,n)){const t=e[n];if(!this.item_type.valid(t))return!1}return!0}}N.__name__="Dict",e.Dict=N;class O extends d{constructor(e,n){super(),this.key_type=e,this.item_type=n}valid(e){if(!(e instanceof _))return!1;for(const[n,t]of e.entries())if(!this.key_type.valid(n)||!this.item_type.valid(t))return!1;return!0}}O.__name__="Map",e.Map=O;class g extends d{valid(e){return(0,a.is_Color)(e)}}g.__name__="Color",e.Color=g;class P extends d{valid(e){return i.isFunction(e)}}P.__name__="Function",e.Function=P}(t.Kinds||(t.Kinds={})),t.Any=new t.Kinds.Any,t.Unknown=new t.Kinds.Unknown,t.Boolean=new t.Kinds.Boolean,t.Number=new t.Kinds.Number,t.Int=new t.Kinds.Int,t.String=new t.Kinds.String,t.Null=new t.Kinds.Null;t.Nullable=e=>new t.Kinds.Nullable(e);t.Opt=e=>new t.Kinds.Opt(e);t.Or=(...e)=>new t.Kinds.Or(e);t.Tuple=(...e)=>new t.Kinds.Tuple(e);t.Struct=e=>new t.Kinds.Struct(e),t.Arrayable=new t.Kinds.Arrayable;t.Array=e=>new t.Kinds.Array(e);t.Dict=e=>new t.Kinds.Dict(e);t.Map=(e,n)=>new t.Kinds.Map(e,n);t.Enum=(...e)=>new t.Kinds.Enum(e);t.Ref=e=>new t.Kinds.Ref(e);t.AnyRef=()=>new t.Kinds.AnyRef;t.Function=()=>new t.Kinds.Function,t.Percent=new t.Kinds.Percent,t.Alpha=t.Percent,t.Color=new t.Kinds.Color,t.Auto=(0,t.Enum)("auto"),t.FontSize=t.String,t.Font=t.String,t.Angle=t.Number},
function _(n,t,r,e,s){e();const u=n(23),c=n(10),l=n(8),{round:i}=Math;function o(n){return(0,c.clamp)(i(n),0,255)}function a(){return[0,0,0,0]}function f(n){return[n>>24&255,n>>16&255,n>>8&255,255&n]}function d(n,t){var r;let e,s,u,c;return null==n?[e,s,u,c]=[0,0,0,0]:(0,l.isInteger)(n)?[e,s,u,c]=f(n):(0,l.isString)(n)?[e,s,u,c]=null!==(r=_(n))&&void 0!==r?r:[0,0,0,0]:([e,s,u,c=1]=n,c=o(255*c)),255==c&&null!=t&&(c=o(255*t)),[e,s,u,c]}r.transparent=a,r.encode_rgba=function([n,t,r,e]){return n<<24|t<<16|r<<8|e},r.decode_rgba=f,r.compose_alpha=function(n,t){return 255==(255&n)?4294967040&n|o(255*t):n},r.color2rgba=d;const h={0:"0",1:"1",2:"2",3:"3",4:"4",5:"5",6:"6",7:"7",8:"8",9:"9",10:"a",11:"b",12:"c",13:"d",14:"e",15:"f"};function g(n){return h[n>>4]+h[15&n]}r.color2css=function(n,t){const[r,e,s,u]=d(n,t);return`rgba(${r}, ${e}, ${s}, ${u/255})`},r.color2hex=function(n,t){const[r,e,s,u]=d(n,t),c=`#${g(r)}${g(e)}${g(s)}`;return 255==u?c:`${c}${g(u)}`},r.color2hexrgb=function(n){const[t,r,e]=d(n);return`#${g(t)}${g(r)}${g(e)}`};const b=/^rgba?\(\s*([^\s,]+?)\s+([^\s,]+?)\s+([^\s,]+?)(?:\s*\/\s*([^\s,]+?))?\s*\)$/,$=/^rgba?\(\s*([^\s,]+?)\s*,\s*([^\s,]+?)\s*,\s*([^\s,]+?)(?:\s*,\s*([^\s,]+?))?\s*\)$/,m=(()=>{const n=document.createElement("canvas");n.width=1,n.height=1;const t=n.getContext("2d"),r=t.createLinearGradient(0,0,1,1);return n=>{t.fillStyle=r,t.fillStyle=n;const e=t.fillStyle;return e!=r?e:null}})();function _(n){var t;if(!(n=n.trim().toLowerCase()))return null;if("transparent"==n)return[0,0,0,0];if((0,u.is_named_color)(n))return f(u.named_colors[n]);if("#"==n[0]){const t=Number(`0x${n.substr(1)}`);if(isNaN(t))return null;switch(n.length-1){case 3:{const n=t>>8&15,r=t>>4&15,e=t>>0&15;return[n<<4|n,r<<4|r,e<<4|e,255]}case 4:{const n=t>>12&15,r=t>>8&15,e=t>>4&15,s=t>>0&15;return[n<<4|n,r<<4|r,e<<4|e,s<<4|s]}case 6:return[t>>16&255,t>>8&255,t>>0&255,255];case 8:return[t>>24&255,t>>16&255,t>>8&255,t>>0&255]}}else if(n.startsWith("rgb")){const r=null!==(t=n.match(b))&&void 0!==t?t:n.match($);if(null!=r){let[,n,t,e,s="1"]=r;const u=n.endsWith("%"),c=t.endsWith("%"),l=e.endsWith("%"),i=s.endsWith("%");if(!(u&&c&&l)&&(u||c||l))return null;u&&(n=n.slice(0,-1)),c&&(t=t.slice(0,-1)),l&&(e=e.slice(0,-1)),i&&(s=s.slice(0,-1));let a=Number(n),f=Number(t),d=Number(e),h=Number(s);return isNaN(a+f+d+h)?null:(u&&(a=a/100*255),c&&(f=f/100*255),l&&(d=d/100*255),h=255*(i?h/100:h),a=o(a),f=o(f),d=o(d),h=o(h),[a,f,d,h])}}else{const t=m(n);if(null!=t)return _(t)}return null}r.css4_parse=_,r.is_Color=function(n){return!!(0,l.isInteger)(n)||(!(!(0,l.isString)(n)||null==_(n))||!(!(0,l.isArray)(n)||3!=n.length&&4!=n.length))},r.is_dark=function([n,t,r]){return 1-(.299*n+.587*t+.114*r)/255>=.6}},
function _(e,r,l,a,i){a();l.named_colors={aliceblue:4042850303,antiquewhite:4209760255,aqua:16777215,aquamarine:2147472639,azure:4043309055,beige:4126530815,bisque:4293182719,black:255,blanchedalmond:4293643775,blue:65535,blueviolet:2318131967,brown:2771004159,burlywood:3736635391,cadetblue:1604231423,chartreuse:2147418367,chocolate:3530104575,coral:4286533887,cornflowerblue:1687547391,cornsilk:4294499583,crimson:3692313855,cyan:16777215,darkblue:35839,darkcyan:9145343,darkgoldenrod:3095792639,darkgray:2846468607,darkgreen:6553855,darkgrey:2846468607,darkkhaki:3182914559,darkmagenta:2332068863,darkolivegreen:1433087999,darkorange:4287365375,darkorchid:2570243327,darkred:2332033279,darksalmon:3918953215,darkseagreen:2411499519,darkslateblue:1211993087,darkslategray:793726975,darkslategrey:793726975,darkturquoise:13554175,darkviolet:2483082239,deeppink:4279538687,deepskyblue:12582911,dimgray:1768516095,dimgrey:1768516095,dodgerblue:512819199,firebrick:2988581631,floralwhite:4294635775,forestgreen:579543807,fuchsia:4278255615,gainsboro:3705462015,ghostwhite:4177068031,gold:4292280575,goldenrod:3668254975,gray:2155905279,green:8388863,greenyellow:2919182335,grey:2155905279,honeydew:4043305215,hotpink:4285117695,indianred:3445382399,indigo:1258324735,ivory:4294963455,khaki:4041641215,lavender:3873897215,lavenderblush:4293981695,lawngreen:2096890111,lemonchiffon:4294626815,lightblue:2916673279,lightcoral:4034953471,lightcyan:3774873599,lightgoldenrodyellow:4210742015,lightgray:3553874943,lightgreen:2431553791,lightgrey:3553874943,lightpink:4290167295,lightsalmon:4288707327,lightseagreen:548580095,lightskyblue:2278488831,lightslategray:2005441023,lightslategrey:2005441023,lightsteelblue:2965692159,lightyellow:4294959359,lime:16711935,limegreen:852308735,linen:4210091775,magenta:4278255615,maroon:2147483903,mediumaquamarine:1724754687,mediumblue:52735,mediumorchid:3126187007,mediumpurple:2473647103,mediumseagreen:1018393087,mediumslateblue:2070474495,mediumspringgreen:16423679,mediumturquoise:1221709055,mediumvioletred:3340076543,midnightblue:421097727,mintcream:4127193855,mistyrose:4293190143,moccasin:4293178879,navajowhite:4292783615,navy:33023,oldlace:4260751103,olive:2155872511,olivedrab:1804477439,orange:4289003775,orangered:4282712319,orchid:3664828159,palegoldenrod:4008225535,palegreen:2566625535,paleturquoise:2951671551,palevioletred:3681588223,papayawhip:4293907967,peachpuff:4292524543,peru:3448061951,pink:4290825215,plum:3718307327,powderblue:2967529215,purple:2147516671,rebeccapurple:1714657791,red:4278190335,rosybrown:3163525119,royalblue:1097458175,saddlebrown:2336560127,salmon:4202722047,sandybrown:4104413439,seagreen:780883967,seashell:4294307583,sienna:2689740287,silver:3233857791,skyblue:2278484991,slateblue:1784335871,slategray:1887473919,slategrey:1887473919,snow:4294638335,springgreen:16744447,steelblue:1182971135,tan:3535047935,teal:8421631,thistle:3636451583,tomato:4284696575,turquoise:1088475391,violet:4001558271,wheat:4125012991,white:4294967295,whitesmoke:4126537215,yellow:4294902015,yellowgreen:2597139199},l.is_named_color=function(e){return e in l.named_colors}},
function _(r,t,n,a,o){a(),n.GeneratorFunction=Object.getPrototypeOf((function*(){})).constructor,n.ColorArray=Uint32Array,n.RGBAArray=Uint8ClampedArray,n.infer_type=function(r,t){return r instanceof Float64Array||r instanceof Array||t instanceof Float64Array||t instanceof Array?Float64Array:Float32Array},n.ScreenArray=Float32Array,n.to_screen=function(r){return r instanceof Float32Array?r:Float32Array.from(r)},o("Indices",r(25).BitSet)},
function _(t,s,r,e,i){var n;e();const o=t(26),a=t(11);class _{constructor(t,s=0){this.size=t,this[n]="BitSet",this._count=null,this._nwords=Math.ceil(t/32),0==s||1==s?(this._array=new Uint32Array(this._nwords),1==s&&this._array.fill(4294967295)):((0,a.assert)(s.length==this._nwords,"Initializer size mismatch"),this._array=s)}clone(){return new _(this.size,new Uint32Array(this._array))}[(n=Symbol.toStringTag,o.equals)](t,s){if(!s.eq(this.size,t.size))return!1;const{_nwords:r}=this,e=this.size%r,i=0==e?r:r-1;for(let s=0;s<i;s++)if(this._array[s]!=t._array[s])return!1;if(0==e)return!0;{const s=1<<e-1,r=s-1^s;return(this._array[i]&r)==(t._array[i]&r)}}static all_set(t){return new _(t,1)}static all_unset(t){return new _(t,0)}static from_indices(t,s){const r=new _(t);for(const t of s)r.set(t);return r}static from_booleans(t,s){const r=new _(t),e=Math.min(t,s.length);for(let t=0;t<e;t++)s[t]&&r.set(t);return r}_check_bounds(t){(0,a.assert)(0<=t&&t<this.size,`Out of bounds: 0 <= ${t} < ${this.size}`)}get(t){this._check_bounds(t);const s=t>>>5,r=31&t;return!!(this._array[s]>>r&1)}set(t,s=!0){this._check_bounds(t),this._count=null;const r=t>>>5,e=31&t;s?this._array[r]|=1<<e:this._array[r]&=~(1<<e)}unset(t){this.set(t,!1)}*[Symbol.iterator](){yield*this.ones()}get count(){let t=this._count;return null==t&&(this._count=t=this._get_count()),t}_get_count(){const{_array:t,_nwords:s,size:r}=this;let e=0;for(let i=0,n=0;n<s;n++){const s=t[n];if(0==s)i+=32;else for(let t=0;t<32&&i<r;t++,i++)s>>>t&1&&(e+=1)}return e}*ones(){const{_array:t,_nwords:s,size:r}=this;for(let e=0,i=0;i<s;i++){const s=t[i];if(0!=s)for(let t=0;t<32&&e<r;t++,e++)s>>>t&1&&(yield e);else e+=32}}*zeros(){const{_array:t,_nwords:s,size:r}=this;for(let e=0,i=0;i<s;i++){const s=t[i];if(4294967295!=s)for(let t=0;t<32&&e<r;t++,e++)s>>>t&1||(yield e);else e+=32}}_check_size(t){(0,a.assert)(this.size==t.size,"Size mismatch")}add(t){this._check_size(t);for(let s=0;s<this._nwords;s++)this._array[s]|=t._array[s]}intersect(t){this._check_size(t);for(let s=0;s<this._nwords;s++)this._array[s]&=t._array[s]}subtract(t){this._check_size(t);for(let s=0;s<this._nwords;s++){const r=this._array[s],e=t._array[s];this._array[s]=(r^e)&r}}union(t){this._check_size(t);const s=this.clone();for(let r=0;r<this._nwords;r++)s._array[r]|=t._array[r];return s}intersection(t){this._check_size(t);const s=this.clone();for(let r=0;r<this._nwords;r++)s._array[r]&=t._array[r];return s}difference(t){this._check_size(t);const s=this.clone();for(let r=0;r<this._nwords;r++){const e=this._array[r],i=t._array[r];s._array[r]=(e^i)&e}return s}select(t){(0,a.assert)(this.size<=t.length,"Size mismatch");const s=this.count,r=new t.constructor(s);let e=0;for(const s of this)r[e++]=t[s];return r}}r.BitSet=_,_.__name__="BitSet"},
function _(t,e,r,n,s){n();const o=t(8),{hasOwnProperty:c}=Object.prototype;function a(t){return(0,o.isObject)(t)&&void 0!==t[r.equals]}r.equals=Symbol("equals"),r.wildcard=Symbol("wildcard");const i=Object.prototype.toString;class u{constructor(){this.a_stack=[],this.b_stack=[]}eq(t,e){if(Object.is(t,e))return!0;if(t===r.wildcard||e===r.wildcard)return!0;if(null==t||null==e)return t===e;const n=i.call(t);if(n!=i.call(e))return!1;switch(n){case"[object Number]":return this.numbers(t,e);case"[object RegExp]":case"[object String]":return`${t}`==`${e}`;case"[object Date]":case"[object Boolean]":return+t==+e}const{a_stack:s,b_stack:o}=this;let c=s.length;for(;c--;)if(s[c]===t)return o[c]===e;s.push(t),o.push(e);const u=(()=>{if(a(t)&&a(e))return t[r.equals](e,this);switch(n){case"[object Array]":case"[object Uint8Array]":case"[object Int8Array]":case"[object Uint16Array]":case"[object Int16Array]":case"[object Uint32Array]":case"[object Int32Array]":case"[object Float32Array]":case"[object Float64Array]":return this.arrays(t,e);case"[object Map]":return this.maps(t,e);case"[object Set]":return this.sets(t,e);case"[object Object]":if(t.constructor==e.constructor&&(null==t.constructor||t.constructor===Object))return this.objects(t,e);case"[object Function]":if(t.constructor==e.constructor&&t.constructor===Function)return this.eq(`${t}`,`${e}`)}if(t instanceof Node)return this.nodes(t,e);throw Error(`can't compare objects of type ${n}`)})();return s.pop(),o.pop(),u}numbers(t,e){return Object.is(t,e)}arrays(t,e){const{length:r}=t;if(r!=e.length)return!1;for(let n=0;n<r;n++)if(!this.eq(t[n],e[n]))return!1;return!0}iterables(t,e){const r=t[Symbol.iterator](),n=e[Symbol.iterator]();for(;;){const t=r.next(),e=n.next();if(t.done&&e.done)return!0;if(t.done||e.done)return!1;if(!this.eq(t.value,e.value))return!1}}maps(t,e){if(t.size!=e.size)return!1;for(const[r,n]of t)if(!e.has(r)||!this.eq(n,e.get(r)))return!1;return!0}sets(t,e){if(t.size!=e.size)return!1;for(const r of t)if(!e.has(r))return!1;return!0}objects(t,e){const r=Object.keys(t);if(r.length!=Object.keys(e).length)return!1;for(const n of r)if(!c.call(e,n)||!this.eq(t[n],e[n]))return!1;return!0}nodes(t,e){return t.nodeType==e.nodeType&&(t.textContent==e.textContent&&!!this.iterables(t.childNodes,e.childNodes))}}r.Comparator=u,u.__name__="Comparator";const{abs:l}=Math;class b extends u{constructor(t=1e-4){super(),this.tolerance=t}numbers(t,e){return super.numbers(t,e)||l(t-e)<this.tolerance}}function f(t,e){return(new u).eq(t,e)}r.SimilarComparator=b,b.__name__="SimilarComparator",r.is_equal=f,r.is_similar=function(t,e,r){return new b(r).eq(t,e)},r.isEqual=f},
function _(n,i,e,t,r){t(),e.is_windows=navigator.appVersion.includes("Windows"),e.is_ie=(()=>{const n=navigator.userAgent;return n.includes("MSIE")||n.includes("Trident")||n.includes("Edge")})(),e.is_mobile="undefined"!=typeof window&&("ontouchstart"in window||navigator.maxTouchPoints>0),e.is_little_endian=(()=>{const n=new ArrayBuffer(4),i=new Uint8Array(n);new Uint32Array(n)[1]=168496141;let e=!0;return 10==i[4]&&11==i[5]&&12==i[6]&&13==i[7]&&(e=!1),e})(),e.BYTE_ORDER=e.is_little_endian?"little":"big",e.to_big_endian=function(n){if(e.is_little_endian){const i=new Uint32Array(n.length),e=new DataView(i.buffer);let t=0;for(const i of n)e.setUint32(t,i),t+=4;return i}return n}},
function _(e,t,r,s,_){s();class i{constructor(){this._dev=!1,this._wireframe=!1,this._force_webgl=!1}set dev(e){this._dev=e}get dev(){return this._dev}set wireframe(e){this._wireframe=e}get wireframe(){return this._wireframe}set force_webgl(e){this._force_webgl=e}get force_webgl(){return this._force_webgl}}r.Settings=i,i.__name__="Settings",r.settings=new i},
function _(e,s,t,i,r){var a,n,l,h,u,o,p,c;i();const y=e(8),_=e(11),A=e(26),q=e(30),d=e(31),z=Symbol("__ndarray__");class D extends Uint8Array{constructor(e,s){super(e),this[a]=!0,this.dtype="uint8",this.shape=null!=s?s:x(e)?e.shape:[this.length],this.dimension=this.shape.length,null==this[A.equals]&&(this[A.equals]=(e,s)=>D.prototype[A.equals].call(this,e,s)),null==this[q.serialize]&&(this[q.serialize]=e=>D.prototype[q.serialize].call(this,e))}[(a=z,A.equals)](e,s){return s.eq(this.shape,e.shape)&&s.arrays(this,e)}[q.serialize](e){return(0,d.encode_NDArray)(this)}}t.Uint8NDArray=D,D.__name__="Uint8NDArray";class N extends Int8Array{constructor(e,s){super(e),this[n]=!0,this.dtype="int8",this.shape=null!=s?s:x(e)?e.shape:[this.length],this.dimension=this.shape.length,null==this[A.equals]&&(this[A.equals]=(e,s)=>N.prototype[A.equals].call(this,e,s)),null==this[q.serialize]&&(this[q.serialize]=e=>N.prototype[q.serialize].call(this,e))}[(n=z,A.equals)](e,s){return s.eq(this.shape,e.shape)&&s.arrays(this,e)}[q.serialize](e){return(0,d.encode_NDArray)(this)}}t.Int8NDArray=N,N.__name__="Int8NDArray";class f extends Uint16Array{constructor(e,s){super(e),this[l]=!0,this.dtype="uint16",this.shape=null!=s?s:x(e)?e.shape:[this.length],this.dimension=this.shape.length,null==this[A.equals]&&(this[A.equals]=(e,s)=>f.prototype[A.equals].call(this,e,s)),null==this[q.serialize]&&(this[q.serialize]=e=>f.prototype[q.serialize].call(this,e))}[(l=z,A.equals)](e,s){return s.eq(this.shape,e.shape)&&s.arrays(this,e)}[q.serialize](e){return(0,d.encode_NDArray)(this)}}t.Uint16NDArray=f,f.__name__="Uint16NDArray";class m extends Int16Array{constructor(e,s){super(e),this[h]=!0,this.dtype="int16",this.shape=null!=s?s:x(e)?e.shape:[this.length],this.dimension=this.shape.length,null==this[A.equals]&&(this[A.equals]=(e,s)=>m.prototype[A.equals].call(this,e,s)),null==this[q.serialize]&&(this[q.serialize]=e=>m.prototype[q.serialize].call(this,e))}[(h=z,A.equals)](e,s){return s.eq(this.shape,e.shape)&&s.arrays(this,e)}[q.serialize](e){return(0,d.encode_NDArray)(this)}}t.Int16NDArray=m,m.__name__="Int16NDArray";class g extends Uint32Array{constructor(e,s){super(e),this[u]=!0,this.dtype="uint32",this.shape=null!=s?s:x(e)?e.shape:[this.length],this.dimension=this.shape.length,null==this[A.equals]&&(this[A.equals]=(e,s)=>g.prototype[A.equals].call(this,e,s)),null==this[q.serialize]&&(this[q.serialize]=e=>g.prototype[q.serialize].call(this,e))}[(u=z,A.equals)](e,s){return s.eq(this.shape,e.shape)&&s.arrays(this,e)}[q.serialize](e){return(0,d.encode_NDArray)(this)}}t.Uint32NDArray=g,g.__name__="Uint32NDArray";class I extends Int32Array{constructor(e,s){super(e),this[o]=!0,this.dtype="int32",this.shape=null!=s?s:x(e)?e.shape:[this.length],this.dimension=this.shape.length,null==this[A.equals]&&(this[A.equals]=(e,s)=>I.prototype[A.equals].call(this,e,s)),null==this[q.serialize]&&(this[q.serialize]=e=>I.prototype[q.serialize].call(this,e))}[(o=z,A.equals)](e,s){return s.eq(this.shape,e.shape)&&s.arrays(this,e)}[q.serialize](e){return(0,d.encode_NDArray)(this)}}t.Int32NDArray=I,I.__name__="Int32NDArray";class U extends Float32Array{constructor(e,s){super(e),this[p]=!0,this.dtype="float32",this.shape=null!=s?s:x(e)?e.shape:[this.length],this.dimension=this.shape.length,null==this[A.equals]&&(this[A.equals]=(e,s)=>U.prototype[A.equals].call(this,e,s)),null==this[q.serialize]&&(this[q.serialize]=e=>U.prototype[q.serialize].call(this,e))}[(p=z,A.equals)](e,s){return s.eq(this.shape,e.shape)&&s.arrays(this,e)}[q.serialize](e){return(0,d.encode_NDArray)(this)}}t.Float32NDArray=U,U.__name__="Float32NDArray";class w extends Float64Array{constructor(e,s){super(e),this[c]=!0,this.dtype="float64",this.shape=null!=s?s:x(e)?e.shape:[this.length],this.dimension=this.shape.length,null==this[A.equals]&&(this[A.equals]=(e,s)=>w.prototype[A.equals].call(this,e,s)),null==this[q.serialize]&&(this[q.serialize]=e=>w.prototype[q.serialize].call(this,e))}[(c=z,A.equals)](e,s){return s.eq(this.shape,e.shape)&&s.arrays(this,e)}[q.serialize](e){return(0,d.encode_NDArray)(this)}}function x(e){return(0,y.isObject)(e)&&void 0!==e[z]}t.Float64NDArray=w,w.__name__="Float64NDArray",t.is_NDArray=x,t.ndarray=function(e,s={}){let{dtype:t}=s;null==t&&(t=e instanceof ArrayBuffer||(0,y.isArray)(e)?"float64":(()=>{switch(!0){case e instanceof Uint8Array:return"uint8";case e instanceof Int8Array:return"int8";case e instanceof Uint16Array:return"uint16";case e instanceof Int16Array:return"int16";case e instanceof Uint32Array:return"uint32";case e instanceof Int32Array:return"int32";case e instanceof Float32Array:return"float32";case e instanceof Float64Array:return"float64";default:(0,_.unreachable)()}})());const{shape:i}=s;switch(t){case"uint8":return new D(e,i);case"int8":return new N(e,i);case"uint16":return new f(e,i);case"int16":return new m(e,i);case"uint32":return new g(e,i);case"int32":return new I(e,i);case"float32":return new U(e,i);case"float64":return new w(e,i)}}},
function _(e,r,t,i,s){i();const n=e(11),a=e(13),l=e(8);t.serialize=Symbol("serialize");class o extends Error{}t.SerializationError=o,o.__name__="SerializationError";class f{constructor(e){var r;this._references=new Map,this._definitions=new Map,this._refmap=new Map,this.include_defaults=null===(r=null==e?void 0:e.include_defaults)||void 0===r||r}get_ref(e){return this._references.get(e)}add_ref(e,r){(0,n.assert)(!this._references.has(e)),this._references.set(e,r)}add_def(e,r){const t=this.get_ref(e);(0,n.assert)(null!=t),this._definitions.set(e,r),this._refmap.set(t,r)}get objects(){return new Set(this._references.keys())}get references(){return new Set(this._references.values())}get definitions(){return new Set(this._definitions.values())}resolve_ref(e){return this._refmap.get(e)}remove_ref(e){return this._references.delete(e)}remove_def(e){return this._definitions.delete(e)}to_serializable(e){const r=this.get_ref(e);if(null!=r)return r;if(function(e){return(0,l.isObject)(e)&&void 0!==e[t.serialize]}(e))return e[t.serialize](this);if((0,l.isArray)(e)||(0,l.isTypedArray)(e)){const r=e.length,t=new Array(r);for(let i=0;i<r;i++){const r=e[i];t[i]=this.to_serializable(r)}return t}if((0,l.isPlainObject)(e)){const r={};for(const[t,i]of(0,a.entries)(e))r[t]=this.to_serializable(i);return r}if(null===e||(0,l.isBoolean)(e)||(0,l.isNumber)(e)||(0,l.isString)(e))return e;throw new o(`${Object.prototype.toString.call(e)} is not serializable`)}}t.Serializer=f,f.__name__="Serializer"},
function _(_,e,r,n,f){n();const t=_(8),o=_(27),s=_(32);r.is_NDArray_ref=function(_){return(0,t.isPlainObject)(_)&&("__buffer__"in _||"__ndarray__"in _)},r.decode_NDArray=function(_,e){const{shape:r,dtype:n,order:f}=_;let t;if("__buffer__"in _){const r=e.get(_.__buffer__);if(null==r)throw new Error(`buffer for ${_.__buffer__} not found`);t=r}else t=(0,s.base64_to_buffer)(_.__ndarray__);return f!==o.BYTE_ORDER&&(0,s.swap)(t,n),{buffer:t,dtype:n,shape:r}},r.encode_NDArray=function(_,e){const r={order:o.BYTE_ORDER,dtype:_.dtype,shape:_.shape};if(null!=e){const n=`${e.size}`;return e.set(n,_.buffer),Object.assign({__buffer__:n},r)}{const e={toJSON:()=>(0,s.buffer_to_base64)(_.buffer)};return Object.assign({__ndarray__:e},r)}}},
function _(t,n,e,r,o){r(),e.buffer_to_base64=function(t){const n=new Uint8Array(t),e=Array.from(n).map((t=>String.fromCharCode(t)));return btoa(e.join(""))},e.base64_to_buffer=function(t){const n=atob(t),e=n.length,r=new Uint8Array(e);for(let t=0,o=e;t<o;t++)r[t]=n.charCodeAt(t);return r.buffer},e.swap=function(t,n){switch(n){case"uint16":case"int16":!function(t){const n=new Uint8Array(t);for(let t=0,e=n.length;t<e;t+=2){const e=n[t];n[t]=n[t+1],n[t+1]=e}}(t);break;case"uint32":case"int32":case"float32":!function(t){const n=new Uint8Array(t);for(let t=0,e=n.length;t<e;t+=4){let e=n[t];n[t]=n[t+3],n[t+3]=e,e=n[t+1],n[t+1]=n[t+2],n[t+2]=e}}(t);break;case"float64":!function(t){const n=new Uint8Array(t);for(let t=0,e=n.length;t<e;t+=8){let e=n[t];n[t]=n[t+7],n[t+7]=e,e=n[t+1],n[t+1]=n[t+6],n[t+6]=e,e=n[t+2],n[t+2]=n[t+5],n[t+5]=e,e=n[t+3],n[t+3]=n[t+4],n[t+4]=e}}(t)}}},
function _(t,r,e,s,a){s();const i=t(26);class n{is_Scalar(){return this.is_scalar}is_Vector(){return!this.is_scalar}}e.Uniform=n,n.__name__="Uniform";class l extends n{constructor(t,r){super(),this.value=t,this.length=r,this.is_scalar=!0}get(t){return this.value}*[Symbol.iterator](){const{length:t,value:r}=this;for(let e=0;e<t;e++)yield r}select(t){return new l(this.value,t.count)}[i.equals](t,r){return r.eq(this.length,t.length)&&r.eq(this.value,t.value)}}e.UniformScalar=l,l.__name__="UniformScalar";class o extends n{constructor(t){super(),this.array=t,this.is_scalar=!1,this.length=this.array.length}get(t){return this.array[t]}*[Symbol.iterator](){yield*this.array}select(t){const r=t.select(this.array);return new this.constructor(r)}[i.equals](t,r){return r.eq(this.length,t.length)&&r.eq(this.array,t.array)}}e.UniformVector=o,o.__name__="UniformVector";class h extends o{constructor(t){super(t),this.array=t,this._view=new DataView(t.buffer)}get(t){return this._view.getUint32(4*t)}*[Symbol.iterator](){const t=this.length;for(let r=0;r<t;r++)yield this.get(r)}}e.ColorUniformVector=h,h.__name__="ColorUniformVector"},
function _(t,e,r,n,u){n();const c=t(28);function s(){const t=new Array(32),e="0123456789ABCDEF";for(let r=0;r<32;r++)t[r]=e.substr(Math.floor(16*Math.random()),1);return t[12]="4",t[16]=e.substr(3&t[16].charCodeAt(0)|8,1),t.join("")}r.startsWith=function(t,e,r=0){return t.substr(r,e.length)==e},r.uuid4=s;let a=1e3;r.uniqueId=function(t){const e=c.settings.dev?"j"+a++:s();return null!=t?`${t}-${e}`:e},r.escape=function(t){return t.replace(/(?:[&<>"'`])/g,(t=>{switch(t){case"&":return"&amp;";case"<":return"&lt;";case">":return"&gt;";case'"':return"&quot;";case"'":return"&#x27;";case"`":return"&#x60;";default:return t}}))},r.unescape=function(t){return t.replace(/&(amp|lt|gt|quot|#x27|#x60);/g,((t,e)=>{switch(e){case"amp":return"&";case"lt":return"<";case"gt":return">";case"quot":return'"';case"#x27":return"'";case"#x60":return"`";default:return e}}))},r.use_strict=function(t){return`'use strict';\n${t}`},r.to_fixed=function(t,e){return t.toFixed(e).replace(/(\.[0-9]*?)0+$/,"$1").replace(/\.$/,"")}},
function _(e,t,s,n,o){n();const i=e(30);class r{constructor(e){this.document=e}}s.DocumentEvent=r,r.__name__="DocumentEvent";class a extends r{constructor(e,t,s){super(e),this.events=t,this.setter_id=s}}s.DocumentEventBatch=a,a.__name__="DocumentEventBatch";class d extends r{}s.DocumentChangedEvent=d,d.__name__="DocumentChangedEvent";class l extends d{constructor(e,t,s){super(e),this.msg_type=t,this.msg_data=s}[i.serialize](e){const t=this.msg_data,s=e.to_serializable(t);return{kind:"MessageSent",msg_type:this.msg_type,msg_data:s}}}s.MessageSentEvent=l,l.__name__="MessageSentEvent";class _ extends d{constructor(e,t,s,n,o,i,r){super(e),this.model=t,this.attr=s,this.old=n,this.new_=o,this.setter_id=i,this.hint=r}[i.serialize](e){if(null!=this.hint)return e.to_serializable(this.hint);const t=this.new_,s=e.to_serializable(t);return this.model!=t&&e.remove_def(this.model),{kind:"ModelChanged",model:this.model.ref(),attr:this.attr,new:s}}}s.ModelChangedEvent=_,_.__name__="ModelChangedEvent";class c extends d{constructor(e,t,s){super(e),this.column_source=t,this.patches=s}[i.serialize](e){return{kind:"ColumnsPatched",column_source:this.column_source,patches:this.patches}}}s.ColumnsPatchedEvent=c,c.__name__="ColumnsPatchedEvent";class h extends d{constructor(e,t,s,n){super(e),this.column_source=t,this.data=s,this.rollover=n}[i.serialize](e){return{kind:"ColumnsStreamed",column_source:this.column_source,data:this.data,rollover:this.rollover}}}s.ColumnsStreamedEvent=h,h.__name__="ColumnsStreamedEvent";class m extends d{constructor(e,t,s){super(e),this.title=t,this.setter_id=s}[i.serialize](e){return{kind:"TitleChanged",title:this.title}}}s.TitleChangedEvent=m,m.__name__="TitleChangedEvent";class u extends d{constructor(e,t,s){super(e),this.model=t,this.setter_id=s}[i.serialize](e){return{kind:"RootAdded",model:e.to_serializable(this.model)}}}s.RootAddedEvent=u,u.__name__="RootAddedEvent";class v extends d{constructor(e,t,s){super(e),this.model=t,this.setter_id=s}[i.serialize](e){return{kind:"RootRemoved",model:this.model.ref()}}}s.RootRemovedEvent=v,v.__name__="RootRemovedEvent"},
function _(t,i,r,n,s){n();const e=t(8),o=t(13);r.pretty=Symbol("pretty");class c{constructor(t){this.visited=new Set,this.precision=null==t?void 0:t.precision}to_string(t){if((0,e.isObject)(t)){if(this.visited.has(t))return"<circular>";this.visited.add(t)}return function(t){return(0,e.isObject)(t)&&void 0!==t[r.pretty]}(t)?t[r.pretty](this):(0,e.isBoolean)(t)?this.boolean(t):(0,e.isNumber)(t)?this.number(t):(0,e.isString)(t)?this.string(t):(0,e.isArray)(t)?this.array(t):(0,e.isIterable)(t)?this.iterable(t):(0,e.isPlainObject)(t)?this.object(t):(0,e.isSymbol)(t)?this.symbol(t):`${t}`}token(t){return t}boolean(t){return`${t}`}number(t){return null!=this.precision?t.toFixed(this.precision):`${t}`}string(t){return`"${t.replace(/'/g,"\\'")}"`}symbol(t){return t.toString()}array(t){const i=this.token,r=[];for(const i of t)r.push(this.to_string(i));return`${i("[")}${r.join(`${i(",")} `)}${i("]")}`}iterable(t){var i;const r=this.token,n=null!==(i=Object(t)[Symbol.toStringTag])&&void 0!==i?i:"Object",s=this.array(t);return`${n}${r("(")}${s}${r(")")}`}object(t){const i=this.token,r=[];for(const[n,s]of(0,o.entries)(t))r.push(`${n}${i(":")} ${this.to_string(s)}`);return`${i("{")}${r.join(`${i(",")} `)}${i("}")}`}}r.Printer=c,c.__name__="Printer",r.to_string=function(t,i){return new c(i).to_string(t)}},
function _(n,o,r,e,t){e();const l=n(13),i=n(8);function c(n){return(0,i.isObject)(n)&&void 0!==n[r.clone]}r.clone=Symbol("clone"),r.is_Cloneable=c;class s extends Error{}r.CloningError=s,s.__name__="CloningError";class a{constructor(){}clone(n){if(c(n))return n[r.clone](this);if((0,i.isArray)(n)){const o=n.length,r=new Array(o);for(let e=0;e<o;e++){const o=n[e];r[e]=this.clone(o)}return r}if((0,i.isPlainObject)(n)){const o={};for(const[r,e]of(0,l.entries)(n))o[r]=this.clone(e);return o}if(null===n||(0,i.isBoolean)(n)||(0,i.isNumber)(n)||(0,i.isString)(n))return n;throw new s(`${Object.prototype.toString.call(n)} is not cloneable`)}}r.Cloner=a,a.__name__="Cloner"},
function _(t,_,r,o,a){o();const e=t(1);(0,e.__exportStar)(t(39),r),(0,e.__exportStar)(t(127),r),(0,e.__exportStar)(t(244),r),(0,e.__exportStar)(t(248),r),(0,e.__exportStar)(t(253),r),(0,e.__exportStar)(t(262),r),(0,e.__exportStar)(t(192),r),(0,e.__exportStar)(t(267),r),(0,e.__exportStar)(t(301),r),(0,e.__exportStar)(t(305),r),(0,e.__exportStar)(t(307),r),(0,e.__exportStar)(t(196),r),(0,e.__exportStar)(t(320),r),(0,e.__exportStar)(t(321),r),(0,e.__exportStar)(t(329),r),(0,e.__exportStar)(t(337),r),(0,e.__exportStar)(t(206),r),(0,e.__exportStar)(t(338),r),(0,e.__exportStar)(t(204),r),(0,e.__exportStar)(t(340),r),(0,e.__exportStar)(t(341),r),(0,e.__exportStar)(t(168),r),(0,e.__exportStar)(t(346),r),(0,e.__exportStar)(t(356),r),(0,e.__exportStar)(t(360),r)},
function _(e,o,n,a,t){a(),t("Annotation",e(40).Annotation),t("Arrow",e(68).Arrow),t("ArrowHead",e(112).ArrowHead),t("OpenHead",e(112).OpenHead),t("NormalHead",e(112).NormalHead),t("TeeHead",e(112).TeeHead),t("VeeHead",e(112).VeeHead),t("Band",e(114).Band),t("BoxAnnotation",e(116).BoxAnnotation),t("ColorBar",e(117).ColorBar),t("Label",e(212).Label),t("LabelSet",e(213).LabelSet),t("Legend",e(214).Legend),t("LegendItem",e(215).LegendItem),t("PolyAnnotation",e(217).PolyAnnotation),t("Slope",e(218).Slope),t("Span",e(219).Span),t("TextAnnotation",e(119).TextAnnotation),t("Title",e(118).Title),t("ToolbarPanel",e(220).ToolbarPanel),t("Tooltip",e(241).Tooltip),t("Whisker",e(243).Whisker)},
function _(t,e,i,n,s){var o;n();const l=t(41);class r extends l.RendererView{get_size(){if(this.model.visible){const{width:t,height:e}=this._get_size();return{width:Math.round(t),height:Math.round(e)}}return{width:0,height:0}}_get_size(){throw new Error("not implemented")}connect_signals(){super.connect_signals();const t=this.model.properties;this.on_change(t.visible,(()=>{null!=this.layout&&(this.layout.visible=this.model.visible,this.plot_view.request_layout())}))}get needs_clip(){return null==this.layout}serializable_state(){const t=super.serializable_state();return null==this.layout?t:Object.assign(Object.assign({},t),{bbox:this.layout.bbox.box})}}i.AnnotationView=r,r.__name__="AnnotationView";class a extends l.Renderer{constructor(t){super(t)}}i.Annotation=a,o=a,a.__name__="Annotation",o.override({level:"annotation"})},
function _(e,i,t,n,s){n();const r=e(1);var o,a;const _=e(42),l=(0,r.__importStar)(e(45)),d=e(20),h=e(53),u=e(54);class c extends h.Model{constructor(e){super(e)}}t.RendererGroup=c,o=c,c.__name__="RendererGroup",o.define((({Boolean:e})=>({visible:[e,!0]})));class p extends _.View{get coordinates(){const{_coordinates:e}=this;return null!=e?e:this._coordinates=this._initialize_coordinates()}initialize(){super.initialize(),this.visuals=new l.Visuals(this),this.needs_webgl_blit=!1}connect_signals(){super.connect_signals();const{x_range_name:e,y_range_name:i}=this.model.properties;this.on_change([e,i],(()=>this._initialize_coordinates()));const{group:t}=this.model;null!=t&&this.on_change(t.properties.visible,(()=>{this.model.visible=t.visible}))}_initialize_coordinates(){const{coordinates:e}=this.model,{frame:i}=this.plot_view;if(null!=e)return e.get_transform(i);{const{x_range_name:e,y_range_name:t}=this.model,n=i.x_scales.get(e),s=i.y_scales.get(t);return new u.CoordinateTransform(n,s)}}get plot_view(){return this.parent}get plot_model(){return this.parent.model}get layer(){const{overlays:e,primary:i}=this.canvas;return"overlay"==this.model.level?e:i}get canvas(){return this.plot_view.canvas_view}request_render(){this.request_paint()}request_paint(){this.plot_view.request_paint(this)}request_layout(){this.plot_view.request_layout()}notify_finished(){this.plot_view.notify_finished()}notify_finished_after_paint(){this.plot_view.notify_finished_after_paint()}get needs_clip(){return!1}get has_webgl(){return!1}render(){this.model.visible&&this._render(),this._has_finished=!0}renderer_view(e){}}t.RendererView=p,p.__name__="RendererView";class g extends h.Model{constructor(e){super(e)}}t.Renderer=g,a=g,g.__name__="Renderer",a.define((({Boolean:e,String:i,Ref:t,Nullable:n})=>({group:[n(t(c)),null],level:[d.RenderLevel,"image"],visible:[e,!0],x_range_name:[i,"default"],y_range_name:[i,"default"],coordinates:[n(t(u.CoordinateMapping)),null]})))},
function _(t,e,s,i,n){i();const o=t(1),h=t(15),r=t(43),l=t(8),_=(0,o.__importDefault)(t(44));class d{constructor(t){this.removed=new h.Signal0(this,"removed"),this._ready=Promise.resolve(void 0),this._slots=new WeakMap,this._idle_notified=!1;const{model:e,parent:s}=t;this.model=e,this.parent=s,this.root=null==s?this:s.root,this.removed.emit()}get ready(){return this._ready}connect(t,e){let s=this._slots.get(e);return null==s&&(s=(t,s)=>{const i=Promise.resolve(e.call(this,t,s));this._ready=this._ready.then((()=>i))},this._slots.set(e,s)),t.connect(s,this)}disconnect(t,e){return t.disconnect(e,this)}initialize(){this._has_finished=!1,this.is_root&&(this._stylesheet=r.stylesheet);for(const t of this.styles())this.stylesheet.append(t)}async lazy_initialize(){}remove(){this.disconnect_signals(),this.removed.emit()}toString(){return`${this.model.type}View(${this.model.id})`}serializable_state(){return{type:this.model.type}}get is_root(){return null==this.parent}has_finished(){return this._has_finished}get is_idle(){return this.has_finished()}connect_signals(){}disconnect_signals(){h.Signal.disconnect_receiver(this)}on_change(t,e){for(const s of(0,l.isArray)(t)?t:[t])this.connect(s.change,e)}cursor(t,e){return null}get stylesheet(){return this.is_root?this._stylesheet:this.root.stylesheet}styles(){return[_.default]}notify_finished(){this.is_root?!this._idle_notified&&this.has_finished()&&null!=this.model.document&&(this._idle_notified=!0,this.model.document.notify_idle(this.model)):this.root.notify_finished()}}s.View=d,d.__name__="View"},
function _(t,e,n,i,o){i();const s=t(8),l=t(13),r=t=>(e={},...n)=>{const i=document.createElement(t);i.classList.add("bk"),(0,s.isPlainObject)(e)||(n=[e,...n],e={});for(let[t,n]of(0,l.entries)(e))if(null!=n&&(!(0,s.isBoolean)(n)||n))if("class"===t&&((0,s.isString)(n)&&(n=n.split(/\s+/)),(0,s.isArray)(n)))for(const t of n)null!=t&&i.classList.add(t);else if("style"===t&&(0,s.isPlainObject)(n))for(const[t,e]of(0,l.entries)(n))i.style[t]=e;else if("data"===t&&(0,s.isPlainObject)(n))for(const[t,e]of(0,l.entries)(n))i.dataset[t]=e;else i.setAttribute(t,n);function o(t){if((0,s.isString)(t))i.appendChild(document.createTextNode(t));else if(t instanceof Node)i.appendChild(t);else if(t instanceof NodeList||t instanceof HTMLCollection)for(const e of t)i.appendChild(e);else if(null!=t&&!1!==t)throw new Error(`expected a DOM element, string, false or null, got ${JSON.stringify(t)}`)}for(const t of n)if((0,s.isArray)(t))for(const e of t)o(e);else o(t);return i};function a(t){const e=t.parentNode;null!=e&&e.removeChild(t)}function c(t,...e){const n=t.firstChild;for(const i of e)t.insertBefore(i,n)}function d(t,e){var n,i,o;const s=Element.prototype;return(null!==(o=null!==(i=null!==(n=s.matches)&&void 0!==n?n:s.webkitMatchesSelector)&&void 0!==i?i:s.mozMatchesSelector)&&void 0!==o?o:s.msMatchesSelector).call(t,e)}function h(t){return parseFloat(t)||0}function f(t){const e=getComputedStyle(t);return{border:{top:h(e.borderTopWidth),bottom:h(e.borderBottomWidth),left:h(e.borderLeftWidth),right:h(e.borderRightWidth)},margin:{top:h(e.marginTop),bottom:h(e.marginBottom),left:h(e.marginLeft),right:h(e.marginRight)},padding:{top:h(e.paddingTop),bottom:h(e.paddingBottom),left:h(e.paddingLeft),right:h(e.paddingRight)}}}function u(t){const e=t.getBoundingClientRect();return{width:Math.ceil(e.width),height:Math.ceil(e.height)}}n.createElement=function(t,e,...n){return r(t)(e,...n)},n.div=r("div"),n.span=r("span"),n.canvas=r("canvas"),n.link=r("link"),n.style=r("style"),n.a=r("a"),n.p=r("p"),n.i=r("i"),n.pre=r("pre"),n.button=r("button"),n.label=r("label"),n.input=r("input"),n.select=r("select"),n.option=r("option"),n.optgroup=r("optgroup"),n.textarea=r("textarea"),n.createSVGElement=function(t,e,...n){const i=document.createElementNS("http://www.w3.org/2000/svg",t);for(const[t,n]of(0,l.entries)(null!=e?e:{}))null==n||(0,s.isBoolean)(n)&&!n||i.setAttribute(t,n);function o(t){if((0,s.isString)(t))i.appendChild(document.createTextNode(t));else if(t instanceof Node)i.appendChild(t);else if(t instanceof NodeList||t instanceof HTMLCollection)for(const e of t)i.appendChild(e);else if(null!=t&&!1!==t)throw new Error(`expected a DOM element, string, false or null, got ${JSON.stringify(t)}`)}for(const t of n)if((0,s.isArray)(t))for(const e of t)o(e);else o(t);return i},n.nbsp=function(){return document.createTextNode("\xa0")},n.append=function(t,...e){for(const n of e)t.appendChild(n)},n.remove=a,n.removeElement=a,n.replaceWith=function(t,e){const n=t.parentNode;null!=n&&n.replaceChild(e,t)},n.prepend=c,n.empty=function(t,e=!1){let n;for(;n=t.firstChild;)t.removeChild(n);if(e&&t instanceof Element)for(const e of t.attributes)t.removeAttributeNode(e)},n.display=function(t){t.style.display=""},n.undisplay=function(t){t.style.display="none"},n.show=function(t){t.style.visibility=""},n.hide=function(t){t.style.visibility="hidden"},n.offset=function(t){const e=t.getBoundingClientRect();return{top:e.top+window.pageYOffset-document.documentElement.clientTop,left:e.left+window.pageXOffset-document.documentElement.clientLeft}},n.matches=d,n.parent=function(t,e){let n=t;for(;n=n.parentElement;)if(d(n,e))return n;return null},n.extents=f,n.size=u,n.scroll_size=function(t){return{width:Math.ceil(t.scrollWidth),height:Math.ceil(t.scrollHeight)}},n.outer_size=function(t){const{margin:{left:e,right:n,top:i,bottom:o}}=f(t),{width:s,height:l}=u(t);return{width:Math.ceil(s+e+n),height:Math.ceil(l+i+o)}},n.content_size=function(t){const{left:e,top:n}=t.getBoundingClientRect(),{padding:i}=f(t);let o=0,s=0;for(const l of t.children){const t=l.getBoundingClientRect();o=Math.max(o,Math.ceil(t.left-e-i.left+t.width)),s=Math.max(s,Math.ceil(t.top-n-i.top+t.height))}return{width:o,height:s}},n.position=function(t,e,n){const{style:i}=t;if(i.left=`${e.x}px`,i.top=`${e.y}px`,i.width=`${e.width}px`,i.height=`${e.height}px`,null==n)i.margin="";else{const{top:t,right:e,bottom:o,left:s}=n;i.margin=`${t}px ${e}px ${o}px ${s}px`}},n.children=function(t){return Array.from(t.children)};class p{constructor(t){this.el=t,this.classList=t.classList}get values(){const t=[];for(let e=0;e<this.classList.length;e++){const n=this.classList.item(e);null!=n&&t.push(n)}return t}has(t){return this.classList.contains(t)}add(...t){for(const e of t)this.classList.add(e);return this}remove(...t){for(const e of t)this.classList.remove(e);return this}clear(){for(const t of this.values)"bk"!=t&&this.classList.remove(t);return this}toggle(t,e){return(null!=e?e:!this.has(t))?this.add(t):this.remove(t),this}}var g;function m(t,e,n){const{width:i,height:o,position:s,display:l}=t.style;t.style.position="absolute",t.style.display="",t.style.width=null!=e.width&&e.width!=1/0?`${e.width}px`:"auto",t.style.height=null!=e.height&&e.height!=1/0?`${e.height}px`:"auto";try{return n()}finally{t.style.position=s,t.style.display=l,t.style.width=i,t.style.height=o}}n.ClassList=p,p.__name__="ClassList",n.classes=function(t){return new p(t)},n.toggle_attribute=function(t,e,n){null==n&&(n=!t.hasAttribute(e)),n?t.setAttribute(e,"true"):t.removeAttribute(e)},(g=n.Keys||(n.Keys={}))[g.Backspace=8]="Backspace",g[g.Tab=9]="Tab",g[g.Enter=13]="Enter",g[g.Esc=27]="Esc",g[g.PageUp=33]="PageUp",g[g.PageDown=34]="PageDown",g[g.Left=37]="Left",g[g.Up=38]="Up",g[g.Right=39]="Right",g[g.Down=40]="Down",g[g.Delete=46]="Delete",n.undisplayed=function(t,e){const{display:n}=t.style;t.style.display="none";try{return e()}finally{t.style.display=n}},n.unsized=function(t,e){return m(t,{},e)},n.sized=m;class y{constructor(t){this.root=t,this.known=new Set,this.style=(0,n.style)({type:"text/css"}),c(t,this.style)}append(t){this.known.has(t)||(this.style.appendChild(document.createTextNode(t)),this.known.add(t))}}n.StyleSheet=y,y.__name__="StyleSheet",n.stylesheet=new y(document.head),n.dom_ready=async function(){if("loading"==document.readyState)return new Promise(((t,e)=>{document.addEventListener("DOMContentLoaded",(()=>t()),{once:!0})}))}},
function _(o,i,t,e,r){e(),t.root="bk-root",t.default=".bk-root{position:relative;width:auto;height:auto;box-sizing:border-box;font-family:Helvetica, Arial, sans-serif;font-size:13px;}.bk-root .bk,.bk-root .bk:before,.bk-root .bk:after{box-sizing:inherit;margin:0;border:0;padding:0;background-image:none;font-family:inherit;font-size:100%;line-height:1.42857143;}.bk-root pre.bk{font-family:Courier, monospace;}"},
function _(e,t,r,a,c){a();const n=e(1),l=e(46);c("Line",l.Line),c("LineScalar",l.LineScalar),c("LineVector",l.LineVector);const i=e(49);c("Fill",i.Fill),c("FillScalar",i.FillScalar),c("FillVector",i.FillVector);const s=e(50);c("Text",s.Text),c("TextScalar",s.TextScalar),c("TextVector",s.TextVector);const o=e(51);c("Hatch",o.Hatch),c("HatchScalar",o.HatchScalar),c("HatchVector",o.HatchVector);const u=(0,n.__importStar)(e(48)),V=e(47);c("VisualProperties",V.VisualProperties),c("VisualUniforms",V.VisualUniforms);class h{constructor(e){this._visuals=[];for(const[t,r]of e.model._mixins){const a=(()=>{switch(r){case u.Line:return new l.Line(e,t);case u.LineScalar:return new l.LineScalar(e,t);case u.LineVector:return new l.LineVector(e,t);case u.Fill:return new i.Fill(e,t);case u.FillScalar:return new i.FillScalar(e,t);case u.FillVector:return new i.FillVector(e,t);case u.Text:return new s.Text(e,t);case u.TextScalar:return new s.TextScalar(e,t);case u.TextVector:return new s.TextVector(e,t);case u.Hatch:return new o.Hatch(e,t);case u.HatchScalar:return new o.HatchScalar(e,t);case u.HatchVector:return new o.HatchVector(e,t);default:throw new Error("unknown visual")}})();a instanceof V.VisualProperties&&a.update(),this._visuals.push(a),Object.defineProperty(this,t+a.type,{get:()=>a,configurable:!1,enumerable:!0})}}*[Symbol.iterator](){yield*this._visuals}}r.Visuals=h,h.__name__="Visuals"},
function _(e,t,i,l,s){l();const a=e(1),n=e(47),h=(0,a.__importStar)(e(48)),o=e(22),_=e(8);function r(e){if((0,_.isArray)(e))return e;switch(e){case"solid":return[];case"dashed":return[6];case"dotted":return[2,4];case"dotdash":return[2,4,6,4];case"dashdot":return[6,4,2,4];default:return e.split(" ").map(Number).filter(_.isInteger)}}i.resolve_line_dash=r;class u extends n.VisualProperties{get doit(){const e=this.line_color.get_value(),t=this.line_alpha.get_value(),i=this.line_width.get_value();return!(null==e||0==t||0==i)}apply(e){const{doit:t}=this;return t&&(this.set_value(e),e.stroke()),t}values(){return{color:this.line_color.get_value(),alpha:this.line_alpha.get_value(),width:this.line_width.get_value(),join:this.line_join.get_value(),cap:this.line_cap.get_value(),dash:this.line_dash.get_value(),offset:this.line_dash_offset.get_value()}}set_value(e){const t=this.line_color.get_value(),i=this.line_alpha.get_value();e.strokeStyle=(0,o.color2css)(t,i),e.lineWidth=this.line_width.get_value(),e.lineJoin=this.line_join.get_value(),e.lineCap=this.line_cap.get_value(),e.lineDash=r(this.line_dash.get_value()),e.lineDashOffset=this.line_dash_offset.get_value()}}i.Line=u,u.__name__="Line";class c extends n.VisualUniforms{get doit(){const e=this.line_color.value,t=this.line_alpha.value,i=this.line_width.value;return!(0==e||0==t||0==i)}apply(e){const{doit:t}=this;return t&&(this.set_value(e),e.stroke()),t}values(){return{color:this.line_color.value,alpha:this.line_alpha.value,width:this.line_width.value,join:this.line_join.value,cap:this.line_cap.value,dash:this.line_dash.value,offset:this.line_dash_offset.value}}set_value(e){const t=this.line_color.value,i=this.line_alpha.value;e.strokeStyle=(0,o.color2css)(t,i),e.lineWidth=this.line_width.value,e.lineJoin=this.line_join.value,e.lineCap=this.line_cap.value,e.lineDash=r(this.line_dash.value),e.lineDashOffset=this.line_dash_offset.value}}i.LineScalar=c,c.__name__="LineScalar";class d extends n.VisualUniforms{get doit(){const{line_color:e}=this;if(e.is_Scalar()&&0==e.value)return!1;const{line_alpha:t}=this;if(t.is_Scalar()&&0==t.value)return!1;const{line_width:i}=this;return!i.is_Scalar()||0!=i.value}apply(e,t){const{doit:i}=this;return i&&(this.set_vectorize(e,t),e.stroke()),i}values(e){return{color:this.line_color.get(e),alpha:this.line_alpha.get(e),width:this.line_width.get(e),join:this.line_join.get(e),cap:this.line_cap.get(e),dash:this.line_dash.get(e),offset:this.line_dash_offset.get(e)}}set_vectorize(e,t){const i=this.line_color.get(t),l=this.line_alpha.get(t),s=this.line_width.get(t),a=this.line_join.get(t),n=this.line_cap.get(t),h=this.line_dash.get(t),_=this.line_dash_offset.get(t);e.strokeStyle=(0,o.color2css)(i,l),e.lineWidth=s,e.lineJoin=a,e.lineCap=n,e.lineDash=r(h),e.lineDashOffset=_}}i.LineVector=d,d.__name__="LineVector",u.prototype.type="line",u.prototype.attrs=Object.keys(h.Line),c.prototype.type="line",c.prototype.attrs=Object.keys(h.LineScalar),d.prototype.type="line",d.prototype.attrs=Object.keys(h.LineVector)},
function _(t,s,o,i,r){i();class e{constructor(t,s=""){this.obj=t,this.prefix=s;const o=this;this._props=[];for(const i of this.attrs){const r=t.model.properties[s+i];r.change.connect((()=>this.update())),o[i]=r,this._props.push(r)}}*[Symbol.iterator](){yield*this._props}update(){}}o.VisualProperties=e,e.__name__="VisualProperties";class p{constructor(t,s=""){this.obj=t,this.prefix=s;for(const o of this.attrs)Object.defineProperty(this,o,{get:()=>t[s+o]})}*[Symbol.iterator](){for(const t of this.attrs)yield this.obj.model.properties[this.prefix+t]}update(){}}o.VisualUniforms=p,p.__name__="VisualUniforms"},
function _(e,l,t,a,c){a();const r=e(1),o=(0,r.__importStar)(e(18)),n=e(20),i=(0,r.__importStar)(e(21)),_=e(13);t.Line={line_color:[i.Nullable(i.Color),"black"],line_alpha:[i.Alpha,1],line_width:[i.Number,1],line_join:[n.LineJoin,"bevel"],line_cap:[n.LineCap,"butt"],line_dash:[i.Or(n.LineDash,i.Array(i.Number)),[]],line_dash_offset:[i.Number,0]},t.Fill={fill_color:[i.Nullable(i.Color),"gray"],fill_alpha:[i.Alpha,1]},t.Hatch={hatch_color:[i.Nullable(i.Color),"black"],hatch_alpha:[i.Alpha,1],hatch_scale:[i.Number,12],hatch_pattern:[i.Nullable(i.Or(n.HatchPatternType,i.String)),null],hatch_weight:[i.Number,1],hatch_extra:[i.Dict(i.AnyRef()),{}]},t.Text={text_color:[i.Nullable(i.Color),"#444444"],text_alpha:[i.Alpha,1],text_font:[o.Font,"helvetica"],text_font_size:[i.FontSize,"16px"],text_font_style:[n.FontStyle,"normal"],text_align:[n.TextAlign,"left"],text_baseline:[n.TextBaseline,"bottom"],text_line_height:[i.Number,1.2]},t.LineScalar={line_color:[o.ColorScalar,"black"],line_alpha:[o.NumberScalar,1],line_width:[o.NumberScalar,1],line_join:[o.LineJoinScalar,"bevel"],line_cap:[o.LineCapScalar,"butt"],line_dash:[o.LineDashScalar,[]],line_dash_offset:[o.NumberScalar,0]},t.FillScalar={fill_color:[o.ColorScalar,"gray"],fill_alpha:[o.NumberScalar,1]},t.HatchScalar={hatch_color:[o.ColorScalar,"black"],hatch_alpha:[o.NumberScalar,1],hatch_scale:[o.NumberScalar,12],hatch_pattern:[o.NullStringScalar,null],hatch_weight:[o.NumberScalar,1],hatch_extra:[o.AnyScalar,{}]},t.TextScalar={text_color:[o.ColorScalar,"#444444"],text_alpha:[o.NumberScalar,1],text_font:[o.FontScalar,"helvetica"],text_font_size:[o.FontSizeScalar,"16px"],text_font_style:[o.FontStyleScalar,"normal"],text_align:[o.TextAlignScalar,"left"],text_baseline:[o.TextBaselineScalar,"bottom"],text_line_height:[o.NumberScalar,1.2]},t.LineVector={line_color:[o.ColorSpec,"black"],line_alpha:[o.NumberSpec,1],line_width:[o.NumberSpec,1],line_join:[o.LineJoinSpec,"bevel"],line_cap:[o.LineCapSpec,"butt"],line_dash:[o.LineDashSpec,[]],line_dash_offset:[o.NumberSpec,0]},t.FillVector={fill_color:[o.ColorSpec,"gray"],fill_alpha:[o.NumberSpec,1]},t.HatchVector={hatch_color:[o.ColorSpec,"black"],hatch_alpha:[o.NumberSpec,1],hatch_scale:[o.NumberSpec,12],hatch_pattern:[o.NullStringSpec,null],hatch_weight:[o.NumberSpec,1],hatch_extra:[o.AnyScalar,{}]},t.TextVector={text_color:[o.ColorSpec,"#444444"],text_alpha:[o.NumberSpec,1],text_font:[o.FontSpec,"helvetica"],text_font_size:[o.FontSizeSpec,"16px"],text_font_style:[o.FontStyleSpec,"normal"],text_align:[o.TextAlignSpec,"left"],text_baseline:[o.TextBaselineSpec,"bottom"],text_line_height:[o.NumberSpec,1.2]},t.attrs_of=function(e,l,t,a=!1){const c={};for(const r of(0,_.keys)(t)){const t=`${l}${r}`,o=e[t];c[a?t:r]=o}return c}},
function _(l,t,e,i,s){i();const a=l(1),o=l(47),r=(0,a.__importStar)(l(48)),_=l(22);class c extends o.VisualProperties{get doit(){const l=this.fill_color.get_value(),t=this.fill_alpha.get_value();return!(null==l||0==t)}apply(l,t){const{doit:e}=this;return e&&(this.set_value(l),l.fill(t)),e}values(){return{color:this.fill_color.get_value(),alpha:this.fill_alpha.get_value()}}set_value(l){const t=this.fill_color.get_value(),e=this.fill_alpha.get_value();l.fillStyle=(0,_.color2css)(t,e)}}e.Fill=c,c.__name__="Fill";class h extends o.VisualUniforms{get doit(){const l=this.fill_color.value,t=this.fill_alpha.value;return!(0==l||0==t)}apply(l,t){const{doit:e}=this;return e&&(this.set_value(l),l.fill(t)),e}values(){return{color:this.fill_color.value,alpha:this.fill_alpha.value}}set_value(l){const t=this.fill_color.value,e=this.fill_alpha.value;l.fillStyle=(0,_.color2css)(t,e)}}e.FillScalar=h,h.__name__="FillScalar";class u extends o.VisualUniforms{get doit(){const{fill_color:l}=this;if(l.is_Scalar()&&0==l.value)return!1;const{fill_alpha:t}=this;return!t.is_Scalar()||0!=t.value}apply(l,t,e){const{doit:i}=this;return i&&(this.set_vectorize(l,t),l.fill(e)),i}values(l){return{color:this.fill_color.get(l),alpha:this.fill_alpha.get(l)}}set_vectorize(l,t){const e=this.fill_color.get(t),i=this.fill_alpha.get(t);l.fillStyle=(0,_.color2css)(e,i)}}e.FillVector=u,u.__name__="FillVector",c.prototype.type="fill",c.prototype.attrs=Object.keys(r.Fill),h.prototype.type="fill",h.prototype.attrs=Object.keys(r.FillScalar),u.prototype.type="fill",u.prototype.attrs=Object.keys(r.FillVector)},
function _(t,e,l,s,_){s();const i=t(1),a=t(47),o=(0,i.__importStar)(t(48)),n=t(22);class h extends a.VisualProperties{get doit(){const t=this.text_color.get_value(),e=this.text_alpha.get_value();return!(null==t||0==e)}values(){return{color:this.text_color.get_value(),alpha:this.text_alpha.get_value(),font:this.text_font.get_value(),font_size:this.text_font_size.get_value(),font_style:this.text_font_style.get_value(),align:this.text_align.get_value(),baseline:this.text_baseline.get_value(),line_height:this.text_line_height.get_value()}}set_value(t){const e=this.text_color.get_value(),l=this.text_alpha.get_value();t.fillStyle=(0,n.color2css)(e,l),t.font=this.font_value(),t.textAlign=this.text_align.get_value(),t.textBaseline=this.text_baseline.get_value()}font_value(){return`${this.text_font_style.get_value()} ${this.text_font_size.get_value()} ${this.text_font.get_value()}`}}l.Text=h,h.__name__="Text";class x extends a.VisualUniforms{get doit(){const t=this.text_color.value,e=this.text_alpha.value;return!(0==t||0==e)}values(){return{color:this.text_color.value,alpha:this.text_alpha.value,font:this.text_font.value,font_size:this.text_font_size.value,font_style:this.text_font_style.value,align:this.text_align.value,baseline:this.text_baseline.value,line_height:this.text_line_height.value}}set_value(t){const e=this.text_color.value,l=this.text_alpha.value,s=this.font_value(),_=this.text_align.value,i=this.text_baseline.value;t.fillStyle=(0,n.color2css)(e,l),t.font=s,t.textAlign=_,t.textBaseline=i}font_value(){return`${this.text_font_style.value} ${this.text_font_size.value} ${this.text_font.value}`}}l.TextScalar=x,x.__name__="TextScalar";class u extends a.VisualUniforms{values(t){return{color:this.text_color.get(t),alpha:this.text_alpha.get(t),font:this.text_font.get(t),font_size:this.text_font_size.get(t),font_style:this.text_font_style.get(t),align:this.text_align.get(t),baseline:this.text_baseline.get(t),line_height:this.text_line_height.get(t)}}get doit(){const{text_color:t}=this;if(t.is_Scalar()&&0==t.value)return!1;const{text_alpha:e}=this;return!e.is_Scalar()||0!=e.value}set_vectorize(t,e){const l=this.text_color.get(e),s=this.text_alpha.get(e),_=this.font_value(e),i=this.text_align.get(e),a=this.text_baseline.get(e);t.fillStyle=(0,n.color2css)(l,s),t.font=_,t.textAlign=i,t.textBaseline=a}font_value(t){return`${this.text_font_style.get(t)} ${this.text_font_size.get(t)} ${this.text_font.get(t)}`}}l.TextVector=u,u.__name__="TextVector",h.prototype.type="text",h.prototype.attrs=Object.keys(o.Text),x.prototype.type="text",x.prototype.attrs=Object.keys(o.TextScalar),u.prototype.type="text",u.prototype.attrs=Object.keys(o.TextVector)},
function _(t,e,a,r,i){r();const h=t(1),s=t(47),n=t(52),c=(0,h.__importStar)(t(18)),_=(0,h.__importStar)(t(48));class l extends s.VisualProperties{constructor(){super(...arguments),this._update_iteration=0}update(){if(this._update_iteration++,this._hatch_image=null,!this.doit)return;const t=this.hatch_color.get_value(),e=this.hatch_alpha.get_value(),a=this.hatch_scale.get_value(),r=this.hatch_pattern.get_value(),i=this.hatch_weight.get_value(),h=t=>{this._hatch_image=t},s=this.hatch_extra.get_value()[r];if(null!=s){const r=s.get_pattern(t,e,a,i);if(r instanceof Promise){const{_update_iteration:t}=this;r.then((e=>{this._update_iteration==t&&(h(e),this.obj.request_render())}))}else h(r)}else{const s=this.obj.canvas.create_layer(),c=(0,n.get_pattern)(s,r,t,e,a,i);h(c)}}get doit(){const t=this.hatch_color.get_value(),e=this.hatch_alpha.get_value(),a=this.hatch_pattern.get_value();return!(null==t||0==e||" "==a||"blank"==a||null==a)}apply(t,e){const{doit:a}=this;return a&&(this.set_value(t),t.layer.undo_transform((()=>t.fill(e)))),a}set_value(t){const e=this.pattern(t);t.fillStyle=null!=e?e:"transparent"}pattern(t){const e=this._hatch_image;return null==e?null:t.createPattern(e,this.repetition())}repetition(){const t=this.hatch_pattern.get_value(),e=this.hatch_extra.get_value()[t];if(null==e)return"repeat";switch(e.repetition){case"repeat":return"repeat";case"repeat_x":return"repeat-x";case"repeat_y":return"repeat-y";case"no_repeat":return"no-repeat"}}}a.Hatch=l,l.__name__="Hatch";class o extends s.VisualUniforms{constructor(){super(...arguments),this._static_doit=!1,this._update_iteration=0}_compute_static_doit(){const t=this.hatch_color.value,e=this.hatch_alpha.value,a=this.hatch_pattern.value;return!(null==t||0==e||" "==a||"blank"==a||null==a)}update(){this._update_iteration++;const t=this.hatch_color.length;if(this._hatch_image=new c.UniformScalar(null,t),this._static_doit=this._compute_static_doit(),!this._static_doit)return;const e=this.hatch_color.value,a=this.hatch_alpha.value,r=this.hatch_scale.value,i=this.hatch_pattern.value,h=this.hatch_weight.value,s=e=>{this._hatch_image=new c.UniformScalar(e,t)},_=this.hatch_extra.value[i];if(null!=_){const t=_.get_pattern(e,a,r,h);if(t instanceof Promise){const{_update_iteration:e}=this;t.then((t=>{this._update_iteration==e&&(s(t),this.obj.request_render())}))}else s(t)}else{const t=this.obj.canvas.create_layer(),c=(0,n.get_pattern)(t,i,e,a,r,h);s(c)}}get doit(){return this._static_doit}apply(t,e){const{doit:a}=this;return a&&(this.set_value(t),t.layer.undo_transform((()=>t.fill(e)))),a}set_value(t){var e;t.fillStyle=null!==(e=this.pattern(t))&&void 0!==e?e:"transparent"}pattern(t){const e=this._hatch_image.value;return null==e?null:t.createPattern(e,this.repetition())}repetition(){const t=this.hatch_pattern.value,e=this.hatch_extra.value[t];if(null==e)return"repeat";switch(e.repetition){case"repeat":return"repeat";case"repeat_x":return"repeat-x";case"repeat_y":return"repeat-y";case"no_repeat":return"no-repeat"}}}a.HatchScalar=o,o.__name__="HatchScalar";class u extends s.VisualUniforms{constructor(){super(...arguments),this._static_doit=!1,this._update_iteration=0}_compute_static_doit(){const{hatch_color:t}=this;if(t.is_Scalar()&&0==t.value)return!1;const{hatch_alpha:e}=this;if(e.is_Scalar()&&0==e.value)return!1;const{hatch_pattern:a}=this;if(a.is_Scalar()){const t=a.value;if(" "==t||"blank"==t||null==t)return!1}return!0}update(){this._update_iteration++;const t=this.hatch_color.length;if(this._hatch_image=new c.UniformScalar(null,t),this._static_doit=this._compute_static_doit(),!this._static_doit)return;const e=(t,e,a,r,i,h)=>{const s=this.hatch_extra.value[t];if(null!=s){const t=s.get_pattern(e,a,r,i);if(t instanceof Promise){const{_update_iteration:e}=this;t.then((t=>{this._update_iteration==e&&(h(t),this.obj.request_render())}))}else h(t)}else{const s=this.obj.canvas.create_layer(),c=(0,n.get_pattern)(s,t,e,a,r,i);h(c)}};if(this.hatch_color.is_Scalar()&&this.hatch_alpha.is_Scalar()&&this.hatch_scale.is_Scalar()&&this.hatch_pattern.is_Scalar()&&this.hatch_weight.is_Scalar()){const a=this.hatch_color.value,r=this.hatch_alpha.value,i=this.hatch_scale.value;e(this.hatch_pattern.value,a,r,i,this.hatch_weight.value,(e=>{this._hatch_image=new c.UniformScalar(e,t)}))}else{const a=new Array(t);a.fill(null),this._hatch_image=new c.UniformVector(a);for(let r=0;r<t;r++){const t=this.hatch_color.get(r),i=this.hatch_alpha.get(r),h=this.hatch_scale.get(r);e(this.hatch_pattern.get(r),t,i,h,this.hatch_weight.get(r),(t=>{a[r]=t}))}}}get doit(){return this._static_doit}apply(t,e,a){const{doit:r}=this;return r&&(this.set_vectorize(t,e),t.layer.undo_transform((()=>t.fill(a)))),r}set_vectorize(t,e){var a;t.fillStyle=null!==(a=this.pattern(t,e))&&void 0!==a?a:"transparent"}pattern(t,e){const a=this._hatch_image.get(e);return null==a?null:t.createPattern(a,this.repetition(e))}repetition(t){const e=this.hatch_pattern.get(t),a=this.hatch_extra.value[e];if(null==a)return"repeat";switch(a.repetition){case"repeat":return"repeat";case"repeat_x":return"repeat-x";case"repeat_y":return"repeat-y";case"no_repeat":return"no-repeat"}}}a.HatchVector=u,u.__name__="HatchVector",l.prototype.type="hatch",l.prototype.attrs=Object.keys(_.Hatch),o.prototype.type="hatch",o.prototype.attrs=Object.keys(_.HatchScalar),u.prototype.type="hatch",u.prototype.attrs=Object.keys(_.HatchVector)},
function _(e,o,a,s,r){s();const i=e(22);function l(e,o,a){e.moveTo(0,a+.5),e.lineTo(o,a+.5),e.stroke()}function n(e,o,a){e.moveTo(a+.5,0),e.lineTo(a+.5,o),e.stroke()}function t(e,o){e.moveTo(0,o),e.lineTo(o,0),e.stroke(),e.moveTo(0,0),e.lineTo(o,o),e.stroke()}a.hatch_aliases={" ":"blank",".":"dot",o:"ring","-":"horizontal_line","|":"vertical_line","+":"cross",'"':"horizontal_dash",":":"vertical_dash","@":"spiral","/":"right_diagonal_line","\\":"left_diagonal_line",x:"diagonal_cross",",":"right_diagonal_dash","`":"left_diagonal_dash",v:"horizontal_wave",">":"vertical_wave","*":"criss_cross"},a.get_pattern=function(e,o,s,r,c,k){return e.resize(c,c),e.prepare(),function(e,o,s,r,c,k){var _;const T=c,v=T/2,h=v/2,d=(0,i.color2css)(s,r);switch(e.strokeStyle=d,e.fillStyle=d,e.lineCap="square",e.lineWidth=k,null!==(_=a.hatch_aliases[o])&&void 0!==_?_:o){case"blank":break;case"dot":e.arc(v,v,v/2,0,2*Math.PI,!0),e.fill();break;case"ring":e.arc(v,v,v/2,0,2*Math.PI,!0),e.stroke();break;case"horizontal_line":l(e,T,v);break;case"vertical_line":n(e,T,v);break;case"cross":l(e,T,v),n(e,T,v);break;case"horizontal_dash":l(e,v,v);break;case"vertical_dash":n(e,v,v);break;case"spiral":{const o=T/30;e.moveTo(v,v);for(let a=0;a<360;a++){const s=.1*a,r=v+o*s*Math.cos(s),i=v+o*s*Math.sin(s);e.lineTo(r,i)}e.stroke();break}case"right_diagonal_line":e.moveTo(.5-h,T),e.lineTo(h+.5,0),e.stroke(),e.moveTo(h+.5,T),e.lineTo(3*h+.5,0),e.stroke(),e.moveTo(3*h+.5,T),e.lineTo(5*h+.5,0),e.stroke(),e.stroke();break;case"left_diagonal_line":e.moveTo(h+.5,T),e.lineTo(.5-h,0),e.stroke(),e.moveTo(3*h+.5,T),e.lineTo(h+.5,0),e.stroke(),e.moveTo(5*h+.5,T),e.lineTo(3*h+.5,0),e.stroke(),e.stroke();break;case"diagonal_cross":t(e,T);break;case"right_diagonal_dash":e.moveTo(h+.5,3*h+.5),e.lineTo(3*h+.5,h+.5),e.stroke();break;case"left_diagonal_dash":e.moveTo(h+.5,h+.5),e.lineTo(3*h+.5,3*h+.5),e.stroke();break;case"horizontal_wave":e.moveTo(0,h),e.lineTo(v,3*h),e.lineTo(T,h),e.stroke();break;case"vertical_wave":e.moveTo(h,0),e.lineTo(3*h,v),e.lineTo(h,T),e.stroke();break;case"criss_cross":t(e,T),l(e,T,v),n(e,T,v)}}(e.ctx,o,s,r,c,k),e.canvas}},
function _(e,t,s,n,c){var a;n();const i=e(14),r=e(8),l=e(13),o=e(26),_=e(19);class h extends i.HasProps{constructor(e){super(e)}get is_syncable(){return this.syncable}[o.equals](e,t){return t.eq(this.id,e.id)&&super[o.equals](e,t)}initialize(){super.initialize(),this._js_callbacks=new Map}connect_signals(){super.connect_signals(),this._update_property_callbacks(),this.connect(this.properties.js_property_callbacks.change,(()=>this._update_property_callbacks())),this.connect(this.properties.js_event_callbacks.change,(()=>this._update_event_callbacks())),this.connect(this.properties.subscribed_events.change,(()=>this._update_event_callbacks()))}_process_event(e){var t;for(const s of null!==(t=this.js_event_callbacks[e.event_name])&&void 0!==t?t:[])s.execute(e);null!=this.document&&this.subscribed_events.some((t=>t==e.event_name))&&this.document.event_manager.send_event(e)}trigger_event(e){null!=this.document&&(e.origin=this,this.document.event_manager.trigger(e))}_update_event_callbacks(){null!=this.document?this.document.event_manager.subscribed_models.add(this):_.logger.warn("WARNING: Document not defined for updating event callbacks")}_update_property_callbacks(){const e=e=>{const[t,s=null]=e.split(":");return null!=s?this.properties[s][t]:this[t]};for(const[t,s]of this._js_callbacks){const n=e(t);for(const e of s)this.disconnect(n,e)}this._js_callbacks.clear();for(const[t,s]of(0,l.entries)(this.js_property_callbacks)){const n=s.map((e=>()=>e.execute(this)));this._js_callbacks.set(t,n);const c=e(t);for(const e of n)this.connect(c,e)}}_doc_attached(){(0,l.isEmpty)(this.js_event_callbacks)&&0==this.subscribed_events.length||this._update_event_callbacks()}_doc_detached(){this.document.event_manager.subscribed_models.delete(this)}select(e){if((0,r.isString)(e))return[...this.references()].filter((t=>t instanceof h&&t.name===e));if(e.prototype instanceof i.HasProps)return[...this.references()].filter((t=>t instanceof e));throw new Error("invalid selector")}select_one(e){const t=this.select(e);switch(t.length){case 0:return null;case 1:return t[0];default:throw new Error("found more than one object matching given selector")}}}s.Model=h,a=h,h.__name__="Model",a.define((({Any:e,Unknown:t,Boolean:s,String:n,Array:c,Dict:a,Nullable:i})=>({tags:[c(t),[]],name:[i(n),null],js_property_callbacks:[a(c(e)),{}],js_event_callbacks:[a(c(e)),{}],subscribed_events:[c(n),[]],syncable:[s,!0]})))},
function _(e,t,s,a,r){var c,n;a();const _=e(12),o=e(53),i=e(55),l=e(59),u=e(61),g=e(62),h=e(57),p=e(63),m=e(67);class x{constructor(e,t){this.x_scale=e,this.y_scale=t,this.x_source=this.x_scale.source_range,this.y_source=this.y_scale.source_range,this.ranges=[this.x_source,this.y_source],this.scales=[this.x_scale,this.y_scale]}map_to_screen(e,t){return[this.x_scale.v_compute(e),this.y_scale.v_compute(t)]}map_from_screen(e,t){return[this.x_scale.v_invert(e),this.y_scale.v_invert(t)]}}s.CoordinateTransform=x,x.__name__="CoordinateTransform";class y extends o.Model{constructor(e){super(e)}get x_ranges(){return new Map([["default",this.x_source]])}get y_ranges(){return new Map([["default",this.y_source]])}_get_scale(e,t,s){if(e instanceof m.FactorRange!=t instanceof g.CategoricalScale)throw new Error(`Range ${e.type} is incompatible is Scale ${t.type}`);t instanceof u.LogScale&&e instanceof p.DataRange1d&&(e.scale_hint="log");const a=t.clone();return a.setv({source_range:e,target_range:s}),a}get_transform(e){const{x_source:t,x_scale:s,x_target:a}=this,r=this._get_scale(t,s,a),{y_source:c,y_scale:n,y_target:_}=this,o=this._get_scale(c,n,_),i=new v({source_scale:r,source_range:r.source_range,target_scale:e.x_scale,target_range:e.x_target}),l=new v({source_scale:o,source_range:o.source_range,target_scale:e.y_scale,target_range:e.y_target});return new x(i,l)}}s.CoordinateMapping=y,c=y,y.__name__="CoordinateMapping",c.define((({Ref:e})=>({x_source:[e(h.Range),()=>new p.DataRange1d],y_source:[e(h.Range),()=>new p.DataRange1d],x_scale:[e(i.Scale),()=>new l.LinearScale],y_scale:[e(i.Scale),()=>new l.LinearScale],x_target:[e(h.Range)],y_target:[e(h.Range)]})));class v extends i.Scale{constructor(e){super(e)}get s_compute(){const e=this.source_scale.s_compute,t=this.target_scale.s_compute;return s=>t(e(s))}get s_invert(){const e=this.source_scale.s_invert,t=this.target_scale.s_invert;return s=>e(t(s))}compute(e){return this.s_compute(e)}v_compute(e){const{s_compute:t}=this;return(0,_.map)(e,t)}invert(e){return this.s_invert(e)}v_invert(e){const{s_invert:t}=this;return(0,_.map)(e,t)}}s.CompositeScale=v,n=v,v.__name__="CompositeScale",n.internal((({Ref:e})=>({source_scale:[e(i.Scale)],target_scale:[e(i.Scale)]})))},
function _(e,t,r,n,s){var _;n();const a=e(56),c=e(57),o=e(58),i=e(24);class u extends a.Transform{constructor(e){super(e)}compute(e){return this.s_compute(e)}v_compute(e){const t=new i.ScreenArray(e.length),{s_compute:r}=this;for(let n=0;n<e.length;n++)t[n]=r(e[n]);return t}invert(e){return this.s_invert(e)}v_invert(e){const t=new Float64Array(e.length),{s_invert:r}=this;for(let n=0;n<e.length;n++)t[n]=r(e[n]);return t}r_compute(e,t){const{s_compute:r}=this;return this.target_range.is_reversed?[r(t),r(e)]:[r(e),r(t)]}r_invert(e,t){const{s_invert:r}=this;return this.target_range.is_reversed?[r(t),r(e)]:[r(e),r(t)]}}r.Scale=u,_=u,u.__name__="Scale",_.internal((({Ref:e})=>({source_range:[e(c.Range)],target_range:[e(o.Range1d)]})))},
function _(n,s,o,r,c){r();const e=n(53);class t extends e.Model{constructor(n){super(n)}}o.Transform=t,t.__name__="Transform"},
function _(e,t,n,i,s){var r;i();const a=e(53);class l extends a.Model{constructor(e){super(e),this.have_updated_interactively=!1}get is_reversed(){return this.start>this.end}get is_valid(){return isFinite(this.min)&&isFinite(this.max)}get span(){return Math.abs(this.end-this.start)}}n.Range=l,r=l,l.__name__="Range",r.define((({Number:e,Tuple:t,Or:n,Auto:i,Nullable:s})=>({bounds:[s(n(t(s(e),s(e)),i)),null],min_interval:[s(e),null],max_interval:[s(e),null]}))),r.internal((({Array:e,AnyRef:t})=>({plots:[e(t()),[]]})))},
function _(t,e,s,n,r){var a;n();const i=t(57);class _ extends i.Range{constructor(t){super(t)}_set_auto_bounds(){if("auto"==this.bounds){const t=Math.min(this._reset_start,this._reset_end),e=Math.max(this._reset_start,this._reset_end);this.setv({bounds:[t,e]},{silent:!0})}}initialize(){super.initialize(),this._set_auto_bounds()}get min(){return Math.min(this.start,this.end)}get max(){return Math.max(this.start,this.end)}reset(){this._set_auto_bounds();const{_reset_start:t,_reset_end:e}=this;this.start!=t||this.end!=e?this.setv({start:t,end:e}):this.change.emit()}map(t){return new _({start:t(this.start),end:t(this.end)})}widen(t){let{start:e,end:s}=this;return this.is_reversed?(e+=t,s-=t):(e-=t,s+=t),new _({start:e,end:s})}}s.Range1d=_,a=_,_.__name__="Range1d",a.define((({Number:t,Nullable:e})=>({start:[t,0],end:[t,1],reset_start:[e(t),null,{on_update(t,e){e._reset_start=null!=t?t:e.start}}],reset_end:[e(t),null,{on_update(t,e){e._reset_end=null!=t?t:e.end}}]})))},
function _(t,e,n,r,s){r();const a=t(60);class _ extends a.ContinuousScale{constructor(t){super(t)}get s_compute(){const[t,e]=this._linear_compute_state();return n=>t*n+e}get s_invert(){const[t,e]=this._linear_compute_state();return n=>(n-e)/t}_linear_compute_state(){const t=this.source_range.start,e=this.source_range.end,n=this.target_range.start,r=(this.target_range.end-n)/(e-t);return[r,-r*t+n]}}n.LinearScale=_,_.__name__="LinearScale"},
function _(n,c,o,s,e){s();const t=n(55);class u extends t.Scale{constructor(n){super(n)}}o.ContinuousScale=u,u.__name__="ContinuousScale"},
function _(t,e,a,o,s){o();const r=t(60);class n extends r.ContinuousScale{constructor(t){super(t)}get s_compute(){const[t,e,a,o]=this._compute_state();return s=>{if(0==a)return 0;{const r=(Math.log(s)-o)/a;return isFinite(r)?r*t+e:NaN}}}get s_invert(){const[t,e,a,o]=this._compute_state();return s=>{const r=(s-e)/t;return Math.exp(a*r+o)}}_get_safe_factor(t,e){let a=t<0?0:t,o=e<0?0:e;if(a==o)if(0==a)[a,o]=[1,10];else{const t=Math.log(a)/Math.log(10);a=10**Math.floor(t),o=Math.ceil(t)!=Math.floor(t)?10**Math.ceil(t):10**(Math.ceil(t)+1)}return[a,o]}_compute_state(){const t=this.source_range.start,e=this.source_range.end,a=this.target_range.start,o=this.target_range.end-a,[s,r]=this._get_safe_factor(t,e);let n,c;0==s?(n=Math.log(r),c=0):(n=Math.log(r)-Math.log(s),c=Math.log(s));return[o,a,n,c]}}a.LogScale=n,n.__name__="LogScale"},
function _(t,e,c,a,s){a();const n=t(55),r=t(59),{_linear_compute_state:o}=r.LinearScale.prototype;class l extends n.Scale{constructor(t){super(t)}get s_compute(){const[t,e]=o.call(this),c=this.source_range;return a=>t*c.synthetic(a)+e}get s_invert(){const[t,e]=o.call(this);return c=>(c-e)/t}}c.CategoricalScale=l,l.__name__="CategoricalScale"},
function _(t,i,n,e,a){e();const s=t(1);var l;const _=t(64),o=t(20),r=t(9),h=t(19),d=(0,s.__importStar)(t(65)),u=t(66);class g extends _.DataRange{constructor(t){super(t),this.have_updated_interactively=!1}initialize(){super.initialize(),this._initial_start=this.start,this._initial_end=this.end,this._initial_range_padding=this.range_padding,this._initial_range_padding_units=this.range_padding_units,this._initial_follow=this.follow,this._initial_follow_interval=this.follow_interval,this._initial_default_span=this.default_span,this._plot_bounds=new Map}get min(){return Math.min(this.start,this.end)}get max(){return Math.max(this.start,this.end)}computed_renderers(){const{renderers:t,names:i}=this,n=(0,r.concat)(this.plots.map((t=>t.data_renderers)));return(0,u.compute_renderers)(0==t.length?"auto":t,n,i)}_compute_plot_bounds(t,i){let n=d.empty();for(const e of t){const t=i.get(e);null==t||!e.visible&&this.only_visible||(n=d.union(n,t))}return n}adjust_bounds_for_aspect(t,i){const n=d.empty();let e=t.x1-t.x0;e<=0&&(e=1);let a=t.y1-t.y0;a<=0&&(a=1);const s=.5*(t.x1+t.x0),l=.5*(t.y1+t.y0);return e<i*a?e=i*a:a=e/i,n.x1=s+.5*e,n.x0=s-.5*e,n.y1=l+.5*a,n.y0=l-.5*a,n}_compute_min_max(t,i){let n,e,a=d.empty();for(const[i,n]of t)i.visible&&(a=d.union(a,n));return[n,e]=0==i?[a.x0,a.x1]:[a.y0,a.y1],[n,e]}_compute_range(t,i){const n=this.range_padding;let e,a;if(null!=this._initial_start&&(t=this._initial_start),null!=this._initial_end&&(i=this._initial_end),"log"==this.scale_hint){let s,l;if((isNaN(t)||!isFinite(t)||t<=0)&&(t=isNaN(i)||!isFinite(i)||i<=0?.1:i/100,h.logger.warn(`could not determine minimum data value for log axis, DataRange1d using value ${t}`)),(isNaN(i)||!isFinite(i)||i<=0)&&(i=isNaN(t)||!isFinite(t)||t<=0?10:100*t,h.logger.warn(`could not determine maximum data value for log axis, DataRange1d using value ${i}`)),i==t)l=this.default_span+.001,s=Math.log(t)/Math.log(10);else{let e,a;"percent"==this.range_padding_units?(e=Math.log(t)/Math.log(10),a=Math.log(i)/Math.log(10),l=(a-e)*(1+n)):(e=Math.log(t-n)/Math.log(10),a=Math.log(i+n)/Math.log(10),l=a-e),s=(e+a)/2}e=10**(s-l/2),a=10**(s+l/2)}else{let s;s=i==t?this.default_span:"percent"==this.range_padding_units?(i-t)*(1+n):i-t+2*n;const l=(i+t)/2;e=l-s/2,a=l+s/2}let s=1;this.flipped&&([e,a]=[a,e],s=-1);const l=this.follow_interval;return null!=l&&Math.abs(e-a)>l&&("start"==this.follow?a=e+s*l:"end"==this.follow&&(e=a-s*l)),[e,a]}update(t,i,n,e){if(this.have_updated_interactively)return;const a=this.computed_renderers();let s=this._compute_plot_bounds(a,t);null!=e&&(s=this.adjust_bounds_for_aspect(s,e)),this._plot_bounds.set(n,s);const[l,_]=this._compute_min_max(this._plot_bounds.entries(),i);let[o,r]=this._compute_range(l,_);null!=this._initial_start&&("log"==this.scale_hint?this._initial_start>0&&(o=this._initial_start):o=this._initial_start),null!=this._initial_end&&("log"==this.scale_hint?this._initial_end>0&&(r=this._initial_end):r=this._initial_end);let h=!1;"auto"==this.bounds&&(this.setv({bounds:[o,r]},{silent:!0}),h=!0);const[d,u]=[this.start,this.end];if(o!=d||r!=u){const t={};o!=d&&(t.start=o),r!=u&&(t.end=r),this.setv(t),h=!1}h&&this.change.emit()}reset(){this.have_updated_interactively=!1,this.setv({range_padding:this._initial_range_padding,range_padding_units:this._initial_range_padding_units,follow:this._initial_follow,follow_interval:this._initial_follow_interval,default_span:this._initial_default_span},{silent:!0}),this.change.emit()}}n.DataRange1d=g,l=g,g.__name__="DataRange1d",l.define((({Boolean:t,Number:i,Nullable:n})=>({start:[i],end:[i],range_padding:[i,.1],range_padding_units:[o.PaddingUnits,"percent"],flipped:[t,!1],follow:[n(o.StartEnd),null],follow_interval:[n(i),null],default_span:[i,2],only_visible:[t,!1]}))),l.internal((({Enum:t})=>({scale_hint:[t("log","auto"),"auto"]})))},
function _(e,n,a,r,s){var t;r();const c=e(57);class _ extends c.Range{constructor(e){super(e)}}a.DataRange=_,t=_,_.__name__="DataRange",t.define((({String:e,Array:n,AnyRef:a})=>({names:[n(e),[]],renderers:[n(a()),[]]})))},
function _(t,i,e,h,r){h();const s=t(24),n=t(26),{min:x,max:y}=Math;e.empty=function(){return{x0:1/0,y0:1/0,x1:-1/0,y1:-1/0}},e.positive_x=function(){return{x0:Number.MIN_VALUE,y0:-1/0,x1:1/0,y1:1/0}},e.positive_y=function(){return{x0:-1/0,y0:Number.MIN_VALUE,x1:1/0,y1:1/0}},e.union=function(t,i){return{x0:x(t.x0,i.x0),x1:y(t.x1,i.x1),y0:x(t.y0,i.y0),y1:y(t.y1,i.y1)}};class o{constructor(t){if(null==t)this.x0=0,this.y0=0,this.x1=0,this.y1=0;else if("x0"in t){const{x0:i,y0:e,x1:h,y1:r}=t;if(!(i<=h&&e<=r))throw new Error(`invalid bbox {x0: ${i}, y0: ${e}, x1: ${h}, y1: ${r}}`);this.x0=i,this.y0=e,this.x1=h,this.y1=r}else if("x"in t){const{x:i,y:e,width:h,height:r}=t;if(!(h>=0&&r>=0))throw new Error(`invalid bbox {x: ${i}, y: ${e}, width: ${h}, height: ${r}}`);this.x0=i,this.y0=e,this.x1=i+h,this.y1=e+r}else{let i,e,h,r;if("width"in t)if("left"in t)i=t.left,e=i+t.width;else if("right"in t)e=t.right,i=e-t.width;else{const h=t.width/2;i=t.hcenter-h,e=t.hcenter+h}else i=t.left,e=t.right;if("height"in t)if("top"in t)h=t.top,r=h+t.height;else if("bottom"in t)r=t.bottom,h=r-t.height;else{const i=t.height/2;h=t.vcenter-i,r=t.vcenter+i}else h=t.top,r=t.bottom;if(!(i<=e&&h<=r))throw new Error(`invalid bbox {left: ${i}, top: ${h}, right: ${e}, bottom: ${r}}`);this.x0=i,this.y0=h,this.x1=e,this.y1=r}}static from_rect({left:t,right:i,top:e,bottom:h}){return new o({x0:Math.min(t,i),y0:Math.min(e,h),x1:Math.max(t,i),y1:Math.max(e,h)})}equals(t){return this.x0==t.x0&&this.y0==t.y0&&this.x1==t.x1&&this.y1==t.y1}[n.equals](t,i){return i.eq(this.x0,t.x0)&&i.eq(this.y0,t.y0)&&i.eq(this.x1,t.x1)&&i.eq(this.y1,t.y1)}toString(){return`BBox({left: ${this.left}, top: ${this.top}, width: ${this.width}, height: ${this.height}})`}get left(){return this.x0}get top(){return this.y0}get right(){return this.x1}get bottom(){return this.y1}get p0(){return[this.x0,this.y0]}get p1(){return[this.x1,this.y1]}get x(){return this.x0}get y(){return this.y0}get width(){return this.x1-this.x0}get height(){return this.y1-this.y0}get size(){return{width:this.width,height:this.height}}get rect(){const{x0:t,y0:i,x1:e,y1:h}=this;return{p0:{x:t,y:i},p1:{x:e,y:i},p2:{x:e,y:h},p3:{x:t,y:h}}}get box(){const{x:t,y:i,width:e,height:h}=this;return{x:t,y:i,width:e,height:h}}get h_range(){return{start:this.x0,end:this.x1}}get v_range(){return{start:this.y0,end:this.y1}}get ranges(){return[this.h_range,this.v_range]}get aspect(){return this.width/this.height}get hcenter(){return(this.left+this.right)/2}get vcenter(){return(this.top+this.bottom)/2}get area(){return this.width*this.height}relative(){const{width:t,height:i}=this;return new o({x:0,y:0,width:t,height:i})}translate(t,i){const{x:e,y:h,width:r,height:s}=this;return new o({x:t+e,y:i+h,width:r,height:s})}relativize(t,i){return[t-this.x,i-this.y]}contains(t,i){return this.x0<=t&&t<=this.x1&&this.y0<=i&&i<=this.y1}clip(t,i){return t<this.x0?t=this.x0:t>this.x1&&(t=this.x1),i<this.y0?i=this.y0:i>this.y1&&(i=this.y1),[t,i]}grow_by(t){return new o({left:this.left-t,right:this.right+t,top:this.top-t,bottom:this.bottom+t})}shrink_by(t){return new o({left:this.left+t,right:this.right-t,top:this.top+t,bottom:this.bottom-t})}union(t){return new o({x0:x(this.x0,t.x0),y0:x(this.y0,t.y0),x1:y(this.x1,t.x1),y1:y(this.y1,t.y1)})}intersection(t){return this.intersects(t)?new o({x0:y(this.x0,t.x0),y0:y(this.y0,t.y0),x1:x(this.x1,t.x1),y1:x(this.y1,t.y1)}):null}intersects(t){return!(t.x1<this.x0||t.x0>this.x1||t.y1<this.y0||t.y0>this.y1)}get xview(){return{compute:t=>this.left+t,v_compute:t=>{const i=new s.ScreenArray(t.length),e=this.left;for(let h=0;h<t.length;h++)i[h]=e+t[h];return i}}}get yview(){return{compute:t=>this.bottom-t,v_compute:t=>{const i=new s.ScreenArray(t.length),e=this.bottom;for(let h=0;h<t.length;h++)i[h]=e-t[h];return i}}}}e.BBox=o,o.__name__="BBox"},
function _(n,e,t,r,u){r();const l=n(9);t.compute_renderers=function(n,e,t){if(null==n)return[];let r="auto"==n?e:n;return t.length>0&&(r=r.filter((n=>(0,l.includes)(t,n.name)))),r}},
function _(t,n,e,i,s){var r;i();const a=t(57),o=t(20),g=t(21),p=t(24),c=t(9),l=t(8),u=t(11);function h(t,n,e=0){const i=new Map;for(let s=0;s<t.length;s++){const r=t[s];if(i.has(r))throw new Error(`duplicate factor or subfactor: ${r}`);i.set(r,{value:.5+s*(1+n)+e})}return[i,(t.length-1)*n]}function d(t,n,e,i=0){var s;const r=new Map,a=new Map;for(const[n,e]of t){const t=null!==(s=a.get(n))&&void 0!==s?s:[];a.set(n,[...t,e])}let o=i,g=0;for(const[t,i]of a){const s=i.length,[a,p]=h(i,e,o);g+=p;const l=(0,c.sum)(i.map((t=>a.get(t).value)));r.set(t,{value:l/s,mapping:a}),o+=s+n+p}return[r,(a.size-1)*n+g]}function _(t,n,e,i,s=0){var r;const a=new Map,o=new Map;for(const[n,e,i]of t){const t=null!==(r=o.get(n))&&void 0!==r?r:[];o.set(n,[...t,[e,i]])}let g=s,p=0;for(const[t,s]of o){const r=s.length,[o,l]=d(s,e,i,g);p+=l;const u=(0,c.sum)(s.map((([t])=>o.get(t).value)));a.set(t,{value:u/r,mapping:o}),g+=r+n+l}return[a,(o.size-1)*n+p]}e.Factor=(0,g.Or)(g.String,(0,g.Tuple)(g.String,g.String),(0,g.Tuple)(g.String,g.String,g.String)),e.FactorSeq=(0,g.Or)((0,g.Array)(g.String),(0,g.Array)((0,g.Tuple)(g.String,g.String)),(0,g.Array)((0,g.Tuple)(g.String,g.String,g.String))),e.map_one_level=h,e.map_two_levels=d,e.map_three_levels=_;class f extends a.Range{constructor(t){super(t)}get min(){return this.start}get max(){return this.end}initialize(){super.initialize(),this._init(!0)}connect_signals(){super.connect_signals(),this.connect(this.properties.factors.change,(()=>this.reset())),this.connect(this.properties.factor_padding.change,(()=>this.reset())),this.connect(this.properties.group_padding.change,(()=>this.reset())),this.connect(this.properties.subgroup_padding.change,(()=>this.reset())),this.connect(this.properties.range_padding.change,(()=>this.reset())),this.connect(this.properties.range_padding_units.change,(()=>this.reset()))}reset(){this._init(!1),this.change.emit()}_lookup(t){switch(t.length){case 1:{const[n]=t,e=this._mapping.get(n);return null!=e?e.value:NaN}case 2:{const[n,e]=t,i=this._mapping.get(n);if(null!=i){const t=i.mapping.get(e);if(null!=t)return t.value}return NaN}case 3:{const[n,e,i]=t,s=this._mapping.get(n);if(null!=s){const t=s.mapping.get(e);if(null!=t){const n=t.mapping.get(i);if(null!=n)return n.value}}return NaN}default:(0,u.unreachable)()}}synthetic(t){if((0,l.isNumber)(t))return t;if((0,l.isString)(t))return this._lookup([t]);let n=0;const e=t[t.length-1];return(0,l.isNumber)(e)&&(n=e,t=t.slice(0,-1)),this._lookup(t)+n}v_synthetic(t){const n=t.length,e=new p.ScreenArray(n);for(let i=0;i<n;i++)e[i]=this.synthetic(t[i]);return e}_init(t){const{levels:n,mapping:e,tops:i,mids:s,inside_padding:r}=(()=>{if((0,c.every)(this.factors,l.isString)){const t=this.factors,[n,e]=h(t,this.factor_padding);return{levels:1,mapping:n,tops:null,mids:null,inside_padding:e}}if((0,c.every)(this.factors,(t=>(0,l.isArray)(t)&&2==t.length&&(0,l.isString)(t[0])&&(0,l.isString)(t[1])))){const t=this.factors,[n,e]=d(t,this.group_padding,this.factor_padding),i=[...n.keys()];return{levels:2,mapping:n,tops:i,mids:null,inside_padding:e}}if((0,c.every)(this.factors,(t=>(0,l.isArray)(t)&&3==t.length&&(0,l.isString)(t[0])&&(0,l.isString)(t[1])&&(0,l.isString)(t[2])))){const t=this.factors,[n,e]=_(t,this.group_padding,this.subgroup_padding,this.factor_padding),i=[...n.keys()],s=[];for(const[t,e]of n)for(const n of e.mapping.keys())s.push([t,n]);return{levels:3,mapping:n,tops:i,mids:s,inside_padding:e}}(0,u.unreachable)()})();this._mapping=e,this.tops=i,this.mids=s;let a=0,o=this.factors.length+r;if("percent"==this.range_padding_units){const t=(o-a)*this.range_padding/2;a-=t,o+=t}else a-=this.range_padding,o+=this.range_padding;this.setv({start:a,end:o,levels:n},{silent:t}),"auto"==this.bounds&&this.setv({bounds:[a,o]},{silent:!0})}}e.FactorRange=f,r=f,f.__name__="FactorRange",r.define((({Number:t})=>({factors:[e.FactorSeq,[]],factor_padding:[t,0],subgroup_padding:[t,.8],group_padding:[t,1.4],range_padding:[t,0],range_padding_units:[o.PaddingUnits,"percent"],start:[t],end:[t]}))),r.internal((({Number:t,String:n,Array:e,Tuple:i,Nullable:s})=>({levels:[t],mids:[s(e(i(n,n))),null],tops:[s(e(n)),null]})))},
function _(t,e,s,a,i){a();const n=t(1);var _;const r=t(69),o=t(112),l=t(48),d=t(20),h=t(24),c=t(113),u=(0,n.__importStar)(t(18)),v=t(10);class p extends r.DataAnnotationView{async lazy_initialize(){await super.lazy_initialize();const{start:t,end:e}=this.model;null!=t&&(this.start=await(0,c.build_view)(t,{parent:this})),null!=e&&(this.end=await(0,c.build_view)(e,{parent:this}))}set_data(t){var e,s;super.set_data(t),null===(e=this.start)||void 0===e||e.set_data(t),null===(s=this.end)||void 0===s||s.set_data(t)}remove(){var t,e;null===(t=this.start)||void 0===t||t.remove(),null===(e=this.end)||void 0===e||e.remove(),super.remove()}map_data(){const{frame:t}=this.plot_view;"data"==this.model.start_units?(this._sx_start=this.coordinates.x_scale.v_compute(this._x_start),this._sy_start=this.coordinates.y_scale.v_compute(this._y_start)):(this._sx_start=t.bbox.xview.v_compute(this._x_start),this._sy_start=t.bbox.yview.v_compute(this._y_start)),"data"==this.model.end_units?(this._sx_end=this.coordinates.x_scale.v_compute(this._x_end),this._sy_end=this.coordinates.y_scale.v_compute(this._y_end)):(this._sx_end=t.bbox.xview.v_compute(this._x_end),this._sy_end=t.bbox.yview.v_compute(this._y_end));const{_sx_start:e,_sy_start:s,_sx_end:a,_sy_end:i}=this,n=e.length,_=this._angles=new h.ScreenArray(n);for(let t=0;t<n;t++)_[t]=Math.PI/2+(0,v.atan2)([e[t],s[t]],[a[t],i[t]])}paint(t){const{start:e,end:s}=this,{_sx_start:a,_sy_start:i,_sx_end:n,_sy_end:_,_angles:r}=this,{x:o,y:l,width:d,height:h}=this.plot_view.frame.bbox;for(let c=0,u=a.length;c<u;c++)null!=s&&(t.save(),t.translate(n[c],_[c]),t.rotate(r[c]),s.render(t,c),t.restore()),null!=e&&(t.save(),t.translate(a[c],i[c]),t.rotate(r[c]+Math.PI),e.render(t,c),t.restore()),this.visuals.line.doit&&(t.save(),null==e&&null==s||(t.beginPath(),t.rect(o,l,d,h),null!=s&&(t.save(),t.translate(n[c],_[c]),t.rotate(r[c]),s.clip(t,c),t.restore()),null!=e&&(t.save(),t.translate(a[c],i[c]),t.rotate(r[c]+Math.PI),e.clip(t,c),t.restore()),t.closePath(),t.clip()),this.visuals.line.set_vectorize(t,c),t.beginPath(),t.moveTo(a[c],i[c]),t.lineTo(n[c],_[c]),t.stroke(),t.restore())}}s.ArrowView=p,p.__name__="ArrowView";class x extends r.DataAnnotation{constructor(t){super(t)}}s.Arrow=x,_=x,x.__name__="Arrow",_.prototype.default_view=p,_.mixins(l.LineVector),_.define((({Ref:t,Nullable:e})=>({x_start:[u.XCoordinateSpec,{field:"x_start"}],y_start:[u.YCoordinateSpec,{field:"y_start"}],start_units:[d.SpatialUnits,"data"],start:[e(t(o.ArrowHead)),null],x_end:[u.XCoordinateSpec,{field:"x_end"}],y_end:[u.YCoordinateSpec,{field:"y_end"}],end_units:[d.SpatialUnits,"data"],end:[e(t(o.ArrowHead)),()=>new o.OpenHead]})))},
function _(t,e,n,s,a){s();const o=t(1);var i;const c=t(40),r=t(70),_=t(75),l=t(78),h=(0,o.__importStar)(t(18));class d extends c.AnnotationView{constructor(){super(...arguments),this._initial_set_data=!1}connect_signals(){super.connect_signals();const t=()=>{this.set_data(this.model.source),this._rerender()};this.connect(this.model.change,t),this.connect(this.model.source.streaming,t),this.connect(this.model.source.patching,t),this.connect(this.model.source.change,t)}_rerender(){this.request_render()}set_data(t){const e=this;for(const n of this.model)if(n instanceof h.VectorSpec||n instanceof h.ScalarSpec)if(n instanceof h.BaseCoordinateSpec){const s=n.array(t);e[`_${n.attr}`]=s}else{const s=n.uniform(t);e[`${n.attr}`]=s}this.plot_model.use_map&&(null!=e._x&&l.inplace.project_xy(e._x,e._y),null!=e._xs&&l.inplace.project_xsys(e._xs,e._ys));for(const t of this.visuals)t.update()}_render(){this._initial_set_data||(this.set_data(this.model.source),this._initial_set_data=!0),this.map_data(),this.paint(this.layer.ctx)}}n.DataAnnotationView=d,d.__name__="DataAnnotationView";class u extends c.Annotation{constructor(t){super(t)}}n.DataAnnotation=u,i=u,u.__name__="DataAnnotation",i.define((({Ref:t})=>({source:[t(r.ColumnarDataSource),()=>new _.ColumnDataSource]})))},
function _(t,e,n,s,a){var i;s();const r=t(71),l=t(15),c=t(19),o=t(73),h=t(8),u=t(9),g=t(13),d=t(72),_=t(74),m=t(29);class w extends r.DataSource{constructor(t){super(t),this.selection_manager=new o.SelectionManager(this)}get_array(t){let e=this.data[t];return null==e?this.data[t]=e=[]:(0,h.isArray)(e)||(this.data[t]=e=Array.from(e)),e}initialize(){super.initialize(),this._select=new l.Signal0(this,"select"),this.inspect=new l.Signal(this,"inspect"),this.streaming=new l.Signal0(this,"streaming"),this.patching=new l.Signal(this,"patching")}get_column(t){const e=this.data[t];return null!=e?e:null}columns(){return(0,g.keys)(this.data)}get_length(t=!0){const e=(0,u.uniq)((0,g.values)(this.data).map((t=>(0,m.is_NDArray)(t)?t.shape[0]:t.length)));switch(e.length){case 0:return null;case 1:return e[0];default:{const n="data source has columns of inconsistent lengths";if(t)return c.logger.warn(n),e.sort()[0];throw new Error(n)}}}get length(){var t;return null!==(t=this.get_length())&&void 0!==t?t:0}clear(){const t={};for(const e of this.columns())t[e]=new this.data[e].constructor(0);this.data=t}}n.ColumnarDataSource=w,i=w,w.__name__="ColumnarDataSource",i.define((({Ref:t})=>({selection_policy:[t(_.SelectionPolicy),()=>new _.UnionRenderers]}))),i.internal((({AnyRef:t})=>({inspected:[t(),()=>new d.Selection]})))},
function _(e,c,n,t,o){var a;t();const s=e(53),r=e(72);class l extends s.Model{constructor(e){super(e)}}n.DataSource=l,a=l,l.__name__="DataSource",a.define((({Ref:e})=>({selected:[e(r.Selection),()=>new r.Selection]})))},
function _(i,e,s,t,n){var l;t();const c=i(53),d=i(9),h=i(13);class _ extends c.Model{constructor(i){super(i)}get_view(){return this.view}get selected_glyph(){return this.selected_glyphs.length>0?this.selected_glyphs[0]:null}add_to_selected_glyphs(i){this.selected_glyphs.push(i)}update(i,e=!0,s="replace"){switch(s){case"replace":this.indices=i.indices,this.line_indices=i.line_indices,this.multiline_indices=i.multiline_indices,this.image_indices=i.image_indices,this.view=i.view,this.selected_glyphs=i.selected_glyphs;break;case"append":this.update_through_union(i);break;case"intersect":this.update_through_intersection(i);break;case"subtract":this.update_through_subtraction(i)}}clear(){this.indices=[],this.line_indices=[],this.multiline_indices={},this.image_indices=[],this.view=null,this.selected_glyphs=[]}map(i){return new _(Object.assign(Object.assign({},this.attributes),{indices:this.indices.map(i),multiline_indices:(0,h.to_object)((0,h.entries)(this.multiline_indices).map((([e,s])=>[i(Number(e)),s]))),image_indices:this.image_indices.map((e=>Object.assign(Object.assign({},e),{index:i(e.index)})))}))}is_empty(){return 0==this.indices.length&&0==this.line_indices.length&&0==this.image_indices.length}update_through_union(i){this.indices=(0,d.union)(this.indices,i.indices),this.selected_glyphs=(0,d.union)(i.selected_glyphs,this.selected_glyphs),this.line_indices=(0,d.union)(i.line_indices,this.line_indices),this.view=i.view,this.multiline_indices=(0,h.merge)(i.multiline_indices,this.multiline_indices)}update_through_intersection(i){this.indices=(0,d.intersection)(this.indices,i.indices),this.selected_glyphs=(0,d.union)(i.selected_glyphs,this.selected_glyphs),this.line_indices=(0,d.union)(i.line_indices,this.line_indices),this.view=i.view,this.multiline_indices=(0,h.merge)(i.multiline_indices,this.multiline_indices)}update_through_subtraction(i){this.indices=(0,d.difference)(this.indices,i.indices),this.selected_glyphs=(0,d.union)(i.selected_glyphs,this.selected_glyphs),this.line_indices=(0,d.union)(i.line_indices,this.line_indices),this.view=i.view,this.multiline_indices=(0,h.merge)(i.multiline_indices,this.multiline_indices)}}s.Selection=_,l=_,_.__name__="Selection",l.define((({Int:i,Array:e,Dict:s})=>({indices:[e(i),[]],line_indices:[e(i),[]],multiline_indices:[s(e(i)),{}]}))),l.internal((({Int:i,Array:e,AnyRef:s,Struct:t,Nullable:n})=>({selected_glyphs:[e(s()),[]],view:[n(s()),null],image_indices:[e(t({index:i,dim1:i,dim2:i,flat_index:i})),[]]})))},
function _(e,t,o,s,c){s();const n=e(72);function i(e){return"GlyphRenderer"==e.model.type}function l(e){return"GraphRenderer"==e.model.type}class r{constructor(e){this.source=e,this.inspectors=new Map}select(e,t,o,s="replace"){const c=[],n=[];for(const t of e)i(t)?c.push(t):l(t)&&n.push(t);let r=!1;for(const e of n){const c=e.model.selection_policy.hit_test(t,e);r=r||e.model.selection_policy.do_selection(c,e.model,o,s)}if(c.length>0){const e=this.source.selection_policy.hit_test(t,c);r=r||this.source.selection_policy.do_selection(e,this.source,o,s)}return r}inspect(e,t){let o=!1;if(i(e)){const s=e.hit_test(t);if(null!=s){o=!s.is_empty();const c=this.get_or_create_inspector(e.model);c.update(s,!0,"replace"),this.source.setv({inspected:c},{silent:!0}),this.source.inspect.emit([e.model,{geometry:t}])}}else if(l(e)){const s=e.model.inspection_policy.hit_test(t,e);o=o||e.model.inspection_policy.do_inspection(s,t,e,!1,"replace")}return o}clear(e){this.source.selected.clear(),null!=e&&this.get_or_create_inspector(e.model).clear()}get_or_create_inspector(e){let t=this.inspectors.get(e);return null==t&&(t=new n.Selection,this.inspectors.set(e,t)),t}}o.SelectionManager=r,r.__name__="SelectionManager"},
function _(e,t,n,s,o){s();const r=e(53);class c extends r.Model{do_selection(e,t,n,s){return null!=e&&(t.selected.update(e,n,s),t._select.emit(),!t.selected.is_empty())}}n.SelectionPolicy=c,c.__name__="SelectionPolicy";class l extends c{hit_test(e,t){const n=[];for(const s of t){const t=s.hit_test(e);null!=t&&n.push(t)}if(n.length>0){const e=n[0];for(const t of n)e.update_through_intersection(t);return e}return null}}n.IntersectRenderers=l,l.__name__="IntersectRenderers";class _ extends c{hit_test(e,t){const n=[];for(const s of t){const t=s.hit_test(e);null!=t&&n.push(t)}if(n.length>0){const e=n[0];for(const t of n)e.update_through_union(t);return e}return null}}n.UnionRenderers=_,_.__name__="UnionRenderers"},
function _(t,n,e,s,o){s();const r=t(1);var l;const c=t(70),i=t(8),a=t(13),u=(0,r.__importStar)(t(76)),h=t(77),d=t(35);function f(t,n,e){if((0,i.isArray)(t)){const s=t.concat(n);return null!=e&&s.length>e?s.slice(-e):s}if((0,i.isTypedArray)(t)){const s=t.length+n.length;if(null!=e&&s>e){const o=s-e,r=t.length;let l;t.length<e?(l=new t.constructor(e),l.set(t,0)):l=t;for(let t=o,n=r;t<n;t++)l[t-o]=l[t];for(let t=0,e=n.length;t<e;t++)l[t+(r-o)]=n[t];return l}{const e=new t.constructor(n);return u.concat(t,e)}}throw new Error("unsupported array types")}function m(t,n){let e,s,o;return(0,i.isNumber)(t)?(e=t,o=t+1,s=1):(e=null!=t.start?t.start:0,o=null!=t.stop?t.stop:n,s=null!=t.step?t.step:1),[e,o,s]}function _(t,n){const e=new Set;let s=!1;for(const[o,r]of n){let n,l,c,a;if((0,i.isArray)(o)){const[s]=o;e.add(s),n=t[s].shape,l=t[s],a=r,2===o.length?(n=[1,n[0]],c=[o[0],0,o[1]]):c=o}else(0,i.isNumber)(o)?(a=[r],e.add(o)):(a=r,s=!0),c=[0,0,o],n=[1,t.length],l=t;let u=0;const[h,d,f]=m(c[1],n[0]),[_,p,g]=m(c[2],n[1]);for(let t=h;t<d;t+=f)for(let o=_;o<p;o+=g)s&&e.add(o),l[t*n[1]+o]=a[u],u++}return e}e.stream_to_column=f,e.slice=m,e.patch_to_column=_;class p extends c.ColumnarDataSource{constructor(t){super(t)}stream(t,n,e){const{data:s}=this;for(const[e,o]of(0,a.entries)(t))s[e]=f(s[e],o,n);if(this.setv({data:s},{silent:!0}),this.streaming.emit(),null!=this.document){const s=new d.ColumnsStreamedEvent(this.document,this.ref(),t,n);this.document._notify_change(this,"data",null,null,{setter_id:e,hint:s})}}patch(t,n){const{data:e}=this;let s=new Set;for(const[n,o]of(0,a.entries)(t))s=(0,h.union)(s,_(e[n],o));if(this.setv({data:e},{silent:!0}),this.patching.emit([...s]),null!=this.document){const e=new d.ColumnsPatchedEvent(this.document,this.ref(),t);this.document._notify_change(this,"data",null,null,{setter_id:n,hint:e})}}}e.ColumnDataSource=p,l=p,p.__name__="ColumnDataSource",l.define((({Dict:t,Any:n})=>({data:[t(n),{}]})))},
function _(t,n,o,e,c){e(),o.concat=function(t,...n){let o=t.length;for(const t of n)o+=t.length;const e=new t.constructor(o);e.set(t,0);let c=t.length;for(const t of n)e.set(t,c),c+=t.length;return e}},
function _(n,o,t,e,f){function c(...n){const o=new Set;for(const t of n)for(const n of t)o.add(n);return o}e(),t.union=c,t.intersection=function(n,...o){const t=new Set;n:for(const e of n){for(const n of o)if(!n.has(e))continue n;t.add(e)}return t},t.difference=function(n,...o){const t=new Set(n);for(const n of c(...o))t.delete(n);return t}},
function _(n,t,e,o,r){o();const c=n(1),l=(0,c.__importDefault)(n(79)),i=(0,c.__importDefault)(n(80)),u=n(24),a=new i.default("GOOGLE"),s=new i.default("WGS84"),f=(0,l.default)(s,a);e.wgs84_mercator={compute:(n,t)=>isFinite(n)&&isFinite(t)?f.forward([n,t]):[NaN,NaN],invert:(n,t)=>isFinite(n)&&isFinite(t)?f.inverse([n,t]):[NaN,NaN]};const _={lon:[-20026376.39,20026376.39],lat:[-20048966.1,20048966.1]},p={lon:[-180,180],lat:[-85.06,85.06]},{min:g,max:h}=Math;function m(n,t){const o=g(n.length,t.length),r=(0,u.infer_type)(n,t),c=new r(o),l=new r(o);return e.inplace.project_xy(n,t,c,l),[c,l]}e.clip_mercator=function(n,t,e){const[o,r]=_[e];return[h(n,o),g(t,r)]},e.in_bounds=function(n,t){const[e,o]=p[t];return e<n&&n<o},function(n){function t(n,t,o,r){const c=g(n.length,t.length);o=null!=o?o:n,r=null!=r?r:t;for(let l=0;l<c;l++){const c=n[l],i=t[l],[u,a]=e.wgs84_mercator.compute(c,i);o[l]=u,r[l]=a}}n.project_xy=t,n.project_xsys=function(n,e,o,r){const c=g(n.length,e.length);o=null!=o?o:n,r=null!=r?r:e;for(let l=0;l<c;l++)t(n[l],e[l],o[l],r[l])}}(e.inplace||(e.inplace={})),e.project_xy=m,e.project_xsys=function(n,t){const e=g(n.length,t.length),o=new Array(e),r=new Array(e);for(let c=0;c<e;c++){const[e,l]=m(n[c],t[c]);o[c]=e,r[c]=l}return[o,r]}},
function _(e,n,t,r,o){r();const a=e(1),i=(0,a.__importDefault)(e(80)),c=(0,a.__importDefault)(e(106));var u=(0,i.default)("WGS84");function f(e,n,t,r){var o,a,i;return Array.isArray(t)?(o=(0,c.default)(e,n,t,r)||{x:NaN,y:NaN},t.length>2?void 0!==e.name&&"geocent"===e.name||void 0!==n.name&&"geocent"===n.name?"number"==typeof o.z?[o.x,o.y,o.z].concat(t.splice(3)):[o.x,o.y,t[2]].concat(t.splice(3)):[o.x,o.y].concat(t.splice(2)):[o.x,o.y]):(a=(0,c.default)(e,n,t,r),2===(i=Object.keys(t)).length||i.forEach((function(r){if(void 0!==e.name&&"geocent"===e.name||void 0!==n.name&&"geocent"===n.name){if("x"===r||"y"===r||"z"===r)return}else if("x"===r||"y"===r)return;a[r]=t[r]})),a)}function l(e){return e instanceof i.default?e:e.oProj?e.oProj:(0,i.default)(e)}t.default=function(e,n,t){e=l(e);var r,o=!1;return void 0===n?(n=e,e=u,o=!0):(void 0!==n.x||Array.isArray(n))&&(t=n,n=e,e=u,o=!0),n=l(n),t?f(e,n,t):(r={forward:function(t,r){return f(e,n,t,r)},inverse:function(t,r){return f(n,e,t,r)}},o&&(r.oProj=n),r)}},
function _(t,e,a,s,i){s();const l=t(1),u=(0,l.__importDefault)(t(81)),r=(0,l.__importDefault)(t(92)),d=(0,l.__importDefault)(t(93)),o=t(101),f=(0,l.__importDefault)(t(103)),p=(0,l.__importDefault)(t(104)),m=(0,l.__importDefault)(t(88)),n=t(105);function h(t,e){if(!(this instanceof h))return new h(t);e=e||function(t){if(t)throw t};var a=(0,u.default)(t);if("object"==typeof a){var s=h.projections.get(a.projName);if(s){if(a.datumCode&&"none"!==a.datumCode){var i=(0,m.default)(f.default,a.datumCode);i&&(a.datum_params=a.datum_params||(i.towgs84?i.towgs84.split(","):null),a.ellps=i.ellipse,a.datumName=i.datumName?i.datumName:a.datumCode)}a.k0=a.k0||1,a.axis=a.axis||"enu",a.ellps=a.ellps||"wgs84",a.lat1=a.lat1||a.lat0;var l=(0,o.sphere)(a.a,a.b,a.rf,a.ellps,a.sphere),d=(0,o.eccentricity)(l.a,l.b,l.rf,a.R_A),_=(0,n.getNadgrids)(a.nadgrids),c=a.datum||(0,p.default)(a.datumCode,a.datum_params,l.a,l.b,d.es,d.ep2,_);(0,r.default)(this,a),(0,r.default)(this,s),this.a=l.a,this.b=l.b,this.rf=l.rf,this.sphere=l.sphere,this.es=d.es,this.e=d.e,this.ep2=d.ep2,this.datum=c,this.init(),e(null,this)}else e(t)}else e(t)}h.projections=d.default,h.projections.start(),a.default=h},
function _(t,r,n,u,e){u();const f=t(1),i=(0,f.__importDefault)(t(82)),a=(0,f.__importDefault)(t(89)),o=(0,f.__importDefault)(t(84)),l=(0,f.__importDefault)(t(88));var C=["PROJECTEDCRS","PROJCRS","GEOGCS","GEOCCS","PROJCS","LOCAL_CS","GEODCRS","GEODETICCRS","GEODETICDATUM","ENGCRS","ENGINEERINGCRS"];var d=["3857","900913","3785","102113"];n.default=function(t){if(!function(t){return"string"==typeof t}(t))return t;if(function(t){return t in i.default}(t))return i.default[t];if(function(t){return C.some((function(r){return t.indexOf(r)>-1}))}(t)){var r=(0,a.default)(t);if(function(t){var r=(0,l.default)(t,"authority");if(r){var n=(0,l.default)(r,"epsg");return n&&d.indexOf(n)>-1}}(r))return i.default["EPSG:3857"];var n=function(t){var r=(0,l.default)(t,"extension");if(r)return(0,l.default)(r,"proj4")}(r);return n?(0,o.default)(n):r}return function(t){return"+"===t[0]}(t)?(0,o.default)(t):void 0}},
function _(t,r,i,e,n){e();const f=t(1),a=(0,f.__importDefault)(t(83)),l=(0,f.__importDefault)(t(84)),u=(0,f.__importDefault)(t(89));function o(t){var r=this;if(2===arguments.length){var i=arguments[1];"string"==typeof i?"+"===i.charAt(0)?o[t]=(0,l.default)(arguments[1]):o[t]=(0,u.default)(arguments[1]):o[t]=i}else if(1===arguments.length){if(Array.isArray(t))return t.map((function(t){Array.isArray(t)?o.apply(r,t):o(t)}));if("string"==typeof t){if(t in o)return o[t]}else"EPSG"in t?o["EPSG:"+t.EPSG]=t:"ESRI"in t?o["ESRI:"+t.ESRI]=t:"IAU2000"in t?o["IAU2000:"+t.IAU2000]=t:console.log(t);return}}(0,a.default)(o),i.default=o},
function _(t,l,G,S,e){S(),G.default=function(t){t("EPSG:4326","+title=WGS 84 (long/lat) +proj=longlat +ellps=WGS84 +datum=WGS84 +units=degrees"),t("EPSG:4269","+title=NAD83 (long/lat) +proj=longlat +a=6378137.0 +b=6356752.31414036 +ellps=GRS80 +datum=NAD83 +units=degrees"),t("EPSG:3857","+title=WGS 84 / Pseudo-Mercator +proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +no_defs"),t.WGS84=t["EPSG:4326"],t["EPSG:3785"]=t["EPSG:3857"],t.GOOGLE=t["EPSG:3857"],t["EPSG:900913"]=t["EPSG:3857"],t["EPSG:102113"]=t["EPSG:3857"]}},
function _(t,n,o,a,u){a();const e=t(1),r=t(85),i=(0,e.__importDefault)(t(86)),f=(0,e.__importDefault)(t(87)),l=(0,e.__importDefault)(t(88));o.default=function(t){var n,o,a,u={},e=t.split("+").map((function(t){return t.trim()})).filter((function(t){return t})).reduce((function(t,n){var o=n.split("=");return o.push(!0),t[o[0].toLowerCase()]=o[1],t}),{}),c={proj:"projName",datum:"datumCode",rf:function(t){u.rf=parseFloat(t)},lat_0:function(t){u.lat0=t*r.D2R},lat_1:function(t){u.lat1=t*r.D2R},lat_2:function(t){u.lat2=t*r.D2R},lat_ts:function(t){u.lat_ts=t*r.D2R},lon_0:function(t){u.long0=t*r.D2R},lon_1:function(t){u.long1=t*r.D2R},lon_2:function(t){u.long2=t*r.D2R},alpha:function(t){u.alpha=parseFloat(t)*r.D2R},gamma:function(t){u.rectified_grid_angle=parseFloat(t)},lonc:function(t){u.longc=t*r.D2R},x_0:function(t){u.x0=parseFloat(t)},y_0:function(t){u.y0=parseFloat(t)},k_0:function(t){u.k0=parseFloat(t)},k:function(t){u.k0=parseFloat(t)},a:function(t){u.a=parseFloat(t)},b:function(t){u.b=parseFloat(t)},r_a:function(){u.R_A=!0},zone:function(t){u.zone=parseInt(t,10)},south:function(){u.utmSouth=!0},towgs84:function(t){u.datum_params=t.split(",").map((function(t){return parseFloat(t)}))},to_meter:function(t){u.to_meter=parseFloat(t)},units:function(t){u.units=t;var n=(0,l.default)(f.default,t);n&&(u.to_meter=n.to_meter)},from_greenwich:function(t){u.from_greenwich=t*r.D2R},pm:function(t){var n=(0,l.default)(i.default,t);u.from_greenwich=(n||parseFloat(t))*r.D2R},nadgrids:function(t){"@null"===t?u.datumCode="none":u.nadgrids=t},axis:function(t){var n="ewnsud";3===t.length&&-1!==n.indexOf(t.substr(0,1))&&-1!==n.indexOf(t.substr(1,1))&&-1!==n.indexOf(t.substr(2,1))&&(u.axis=t)},approx:function(){u.approx=!0}};for(n in e)o=e[n],n in c?"function"==typeof(a=c[n])?a(o):u[a]=o:u[n]=o;return"string"==typeof u.datumCode&&"WGS84"!==u.datumCode&&(u.datumCode=u.datumCode.toLowerCase()),u}},
function _(S,_,P,R,I){R(),P.PJD_3PARAM=1,P.PJD_7PARAM=2,P.PJD_GRIDSHIFT=3,P.PJD_WGS84=4,P.PJD_NODATUM=5,P.SRS_WGS84_SEMIMAJOR=6378137,P.SRS_WGS84_SEMIMINOR=6356752.314,P.SRS_WGS84_ESQUARED=.0066943799901413165,P.SEC_TO_RAD=484813681109536e-20,P.HALF_PI=Math.PI/2,P.SIXTH=.16666666666666666,P.RA4=.04722222222222222,P.RA6=.022156084656084655,P.EPSLN=1e-10,P.D2R=.017453292519943295,P.R2D=57.29577951308232,P.FORTPI=Math.PI/4,P.TWO_PI=2*Math.PI,P.SPI=3.14159265359},
function _(o,r,a,e,s){e();var n={};a.default=n,n.greenwich=0,n.lisbon=-9.131906111111,n.paris=2.337229166667,n.bogota=-74.080916666667,n.madrid=-3.687938888889,n.rome=12.452333333333,n.bern=7.439583333333,n.jakarta=106.807719444444,n.ferro=-17.666666666667,n.brussels=4.367975,n.stockholm=18.058277777778,n.athens=23.7163375,n.oslo=10.722916666667},
function _(t,e,f,o,u){o(),f.default={ft:{to_meter:.3048},"us-ft":{to_meter:1200/3937}}},
function _(e,r,t,a,n){a();var o=/[\s_\-\/\(\)]/g;t.default=function(e,r){if(e[r])return e[r];for(var t,a=Object.keys(e),n=r.toLowerCase().replace(o,""),f=-1;++f<a.length;)if((t=a[f]).toLowerCase().replace(o,"")===n)return e[t]}},
function _(e,a,t,o,n){o();const r=e(1);const l=(0,r.__importDefault)(e(90)),d=e(91);function i(e){return.017453292519943295*e}t.default=function(e){var a=(0,l.default)(e),t=a.shift(),o=a.shift();a.unshift(["name",o]),a.unshift(["type",t]);var n={};return(0,d.sExpr)(a,n),function(e){if("GEOGCS"===e.type?e.projName="longlat":"LOCAL_CS"===e.type?(e.projName="identity",e.local=!0):"object"==typeof e.PROJECTION?e.projName=Object.keys(e.PROJECTION)[0]:e.projName=e.PROJECTION,e.AXIS){for(var a="",t=0,o=e.AXIS.length;t<o;++t){var n=[e.AXIS[t][0].toLowerCase(),e.AXIS[t][1].toLowerCase()];-1!==n[0].indexOf("north")||("y"===n[0]||"lat"===n[0])&&"north"===n[1]?a+="n":-1!==n[0].indexOf("south")||("y"===n[0]||"lat"===n[0])&&"south"===n[1]?a+="s":-1!==n[0].indexOf("east")||("x"===n[0]||"lon"===n[0])&&"east"===n[1]?a+="e":-1===n[0].indexOf("west")&&("x"!==n[0]&&"lon"!==n[0]||"west"!==n[1])||(a+="w")}2===a.length&&(a+="u"),3===a.length&&(e.axis=a)}e.UNIT&&(e.units=e.UNIT.name.toLowerCase(),"metre"===e.units&&(e.units="meter"),e.UNIT.convert&&("GEOGCS"===e.type?e.DATUM&&e.DATUM.SPHEROID&&(e.to_meter=e.UNIT.convert*e.DATUM.SPHEROID.a):e.to_meter=e.UNIT.convert));var r=e.GEOGCS;function l(a){return a*(e.to_meter||1)}"GEOGCS"===e.type&&(r=e),r&&(r.DATUM?e.datumCode=r.DATUM.name.toLowerCase():e.datumCode=r.name.toLowerCase(),"d_"===e.datumCode.slice(0,2)&&(e.datumCode=e.datumCode.slice(2)),"new_zealand_geodetic_datum_1949"!==e.datumCode&&"new_zealand_1949"!==e.datumCode||(e.datumCode="nzgd49"),"wgs_1984"!==e.datumCode&&"world_geodetic_system_1984"!==e.datumCode||("Mercator_Auxiliary_Sphere"===e.PROJECTION&&(e.sphere=!0),e.datumCode="wgs84"),"_ferro"===e.datumCode.slice(-6)&&(e.datumCode=e.datumCode.slice(0,-6)),"_jakarta"===e.datumCode.slice(-8)&&(e.datumCode=e.datumCode.slice(0,-8)),~e.datumCode.indexOf("belge")&&(e.datumCode="rnb72"),r.DATUM&&r.DATUM.SPHEROID&&(e.ellps=r.DATUM.SPHEROID.name.replace("_19","").replace(/[Cc]larke\_18/,"clrk"),"international"===e.ellps.toLowerCase().slice(0,13)&&(e.ellps="intl"),e.a=r.DATUM.SPHEROID.a,e.rf=parseFloat(r.DATUM.SPHEROID.rf,10)),r.DATUM&&r.DATUM.TOWGS84&&(e.datum_params=r.DATUM.TOWGS84),~e.datumCode.indexOf("osgb_1936")&&(e.datumCode="osgb36"),~e.datumCode.indexOf("osni_1952")&&(e.datumCode="osni52"),(~e.datumCode.indexOf("tm65")||~e.datumCode.indexOf("geodetic_datum_of_1965"))&&(e.datumCode="ire65"),"ch1903+"===e.datumCode&&(e.datumCode="ch1903"),~e.datumCode.indexOf("israel")&&(e.datumCode="isr93")),e.b&&!isFinite(e.b)&&(e.b=e.a),[["standard_parallel_1","Standard_Parallel_1"],["standard_parallel_1","Latitude of 1st standard parallel"],["standard_parallel_2","Standard_Parallel_2"],["standard_parallel_2","Latitude of 2nd standard parallel"],["false_easting","False_Easting"],["false_easting","False easting"],["false-easting","Easting at false origin"],["false_northing","False_Northing"],["false_northing","False northing"],["false_northing","Northing at false origin"],["central_meridian","Central_Meridian"],["central_meridian","Longitude of natural origin"],["central_meridian","Longitude of false origin"],["latitude_of_origin","Latitude_Of_Origin"],["latitude_of_origin","Central_Parallel"],["latitude_of_origin","Latitude of natural origin"],["latitude_of_origin","Latitude of false origin"],["scale_factor","Scale_Factor"],["k0","scale_factor"],["latitude_of_center","Latitude_Of_Center"],["latitude_of_center","Latitude_of_center"],["lat0","latitude_of_center",i],["longitude_of_center","Longitude_Of_Center"],["longitude_of_center","Longitude_of_center"],["longc","longitude_of_center",i],["x0","false_easting",l],["y0","false_northing",l],["long0","central_meridian",i],["lat0","latitude_of_origin",i],["lat0","standard_parallel_1",i],["lat1","standard_parallel_1",i],["lat2","standard_parallel_2",i],["azimuth","Azimuth"],["alpha","azimuth",i],["srsCode","name"]].forEach((function(a){return t=e,n=(o=a)[0],r=o[1],void(!(n in t)&&r in t&&(t[n]=t[r],3===o.length&&(t[n]=o[2](t[n]))));var t,o,n,r})),e.long0||!e.longc||"Albers_Conic_Equal_Area"!==e.projName&&"Lambert_Azimuthal_Equal_Area"!==e.projName||(e.long0=e.longc),e.lat_ts||!e.lat1||"Stereographic_South_Pole"!==e.projName&&"Polar Stereographic (variant B)"!==e.projName||(e.lat0=i(e.lat1>0?90:-90),e.lat_ts=e.lat1)}(n),n}},
function _(t,e,r,i,s){i(),r.default=function(t){return new d(t).output()};var h=/\s/,o=/[A-Za-z]/,n=/[A-Za-z84]/,a=/[,\]]/,u=/[\d\.E\-\+]/;function d(t){if("string"!=typeof t)throw new Error("not a string");this.text=t.trim(),this.level=0,this.place=0,this.root=null,this.stack=[],this.currentObject=null,this.state=1}d.prototype.readCharicter=function(){var t=this.text[this.place++];if(4!==this.state)for(;h.test(t);){if(this.place>=this.text.length)return;t=this.text[this.place++]}switch(this.state){case 1:return this.neutral(t);case 2:return this.keyword(t);case 4:return this.quoted(t);case 5:return this.afterquote(t);case 3:return this.number(t);case-1:return}},d.prototype.afterquote=function(t){if('"'===t)return this.word+='"',void(this.state=4);if(a.test(t))return this.word=this.word.trim(),void this.afterItem(t);throw new Error("havn't handled \""+t+'" in afterquote yet, index '+this.place)},d.prototype.afterItem=function(t){return","===t?(null!==this.word&&this.currentObject.push(this.word),this.word=null,void(this.state=1)):"]"===t?(this.level--,null!==this.word&&(this.currentObject.push(this.word),this.word=null),this.state=1,this.currentObject=this.stack.pop(),void(this.currentObject||(this.state=-1))):void 0},d.prototype.number=function(t){if(!u.test(t)){if(a.test(t))return this.word=parseFloat(this.word),void this.afterItem(t);throw new Error("havn't handled \""+t+'" in number yet, index '+this.place)}this.word+=t},d.prototype.quoted=function(t){'"'!==t?this.word+=t:this.state=5},d.prototype.keyword=function(t){if(n.test(t))this.word+=t;else{if("["===t){var e=[];return e.push(this.word),this.level++,null===this.root?this.root=e:this.currentObject.push(e),this.stack.push(this.currentObject),this.currentObject=e,void(this.state=1)}if(!a.test(t))throw new Error("havn't handled \""+t+'" in keyword yet, index '+this.place);this.afterItem(t)}},d.prototype.neutral=function(t){if(o.test(t))return this.word=t,void(this.state=2);if('"'===t)return this.word="",void(this.state=4);if(u.test(t))return this.word=t,void(this.state=3);if(!a.test(t))throw new Error("havn't handled \""+t+'" in neutral yet, index '+this.place);this.afterItem(t)},d.prototype.output=function(){for(;this.place<this.text.length;)this.readCharicter();if(-1===this.state)return this.root;throw new Error('unable to parse string "'+this.text+'". State is '+this.state)}},
function _(e,a,r,s,c){function n(e,a,r){Array.isArray(a)&&(r.unshift(a),a=null);var s=a?{}:e,c=r.reduce((function(e,a){return E(a,e),e}),s);a&&(e[a]=c)}function E(e,a){if(Array.isArray(e)){var r=e.shift();if("PARAMETER"===r&&(r=e.shift()),1===e.length)return Array.isArray(e[0])?(a[r]={},void E(e[0],a[r])):void(a[r]=e[0]);if(e.length)if("TOWGS84"!==r){if("AXIS"===r)return r in a||(a[r]=[]),void a[r].push(e);var s;switch(Array.isArray(r)||(a[r]={}),r){case"UNIT":case"PRIMEM":case"VERT_DATUM":return a[r]={name:e[0].toLowerCase(),convert:e[1]},void(3===e.length&&E(e[2],a[r]));case"SPHEROID":case"ELLIPSOID":return a[r]={name:e[0],a:e[1],rf:e[2]},void(4===e.length&&E(e[3],a[r]));case"PROJECTEDCRS":case"PROJCRS":case"GEOGCS":case"GEOCCS":case"PROJCS":case"LOCAL_CS":case"GEODCRS":case"GEODETICCRS":case"GEODETICDATUM":case"EDATUM":case"ENGINEERINGDATUM":case"VERT_CS":case"VERTCRS":case"VERTICALCRS":case"COMPD_CS":case"COMPOUNDCRS":case"ENGINEERINGCRS":case"ENGCRS":case"FITTED_CS":case"LOCAL_DATUM":case"DATUM":return e[0]=["name",e[0]],void n(a,r,e);default:for(s=-1;++s<e.length;)if(!Array.isArray(e[s]))return E(e,a[r]);return n(a,r,e)}}else a[r]=e;else a[r]=!0}else a[e]=!0}s(),r.sExpr=E},
function _(n,r,f,i,t){i(),f.default=function(n,r){var f,i;if(n=n||{},!r)return n;for(i in r)void 0!==(f=r[i])&&(n[i]=f);return n}},
function _(t,o,a,e,n){e();const r=t(1),f=(0,r.__importDefault)(t(94)),u=(0,r.__importDefault)(t(100));var i=[f.default,u.default],c={},d=[];function s(t,o){var a=d.length;return t.names?(d[a]=t,t.names.forEach((function(t){c[t.toLowerCase()]=a})),this):(console.log(o),!0)}function l(t){if(!t)return!1;var o=t.toLowerCase();return void 0!==c[o]&&d[c[o]]?d[c[o]]:void 0}function v(){i.forEach(s)}a.add=s,a.get=l,a.start=v,a.default={start:v,add:s,get:l}},
function _(t,i,s,h,a){h();const e=t(1),r=(0,e.__importDefault)(t(95)),n=(0,e.__importDefault)(t(96)),l=(0,e.__importDefault)(t(98)),u=(0,e.__importDefault)(t(99)),o=t(85);function f(){var t=this.b/this.a;this.es=1-t*t,"x0"in this||(this.x0=0),"y0"in this||(this.y0=0),this.e=Math.sqrt(this.es),this.lat_ts?this.sphere?this.k0=Math.cos(this.lat_ts):this.k0=(0,r.default)(this.e,Math.sin(this.lat_ts),Math.cos(this.lat_ts)):this.k0||(this.k?this.k0=this.k:this.k0=1)}function _(t){var i,s,h=t.x,a=t.y;if(a*o.R2D>90&&a*o.R2D<-90&&h*o.R2D>180&&h*o.R2D<-180)return null;if(Math.abs(Math.abs(a)-o.HALF_PI)<=o.EPSLN)return null;if(this.sphere)i=this.x0+this.a*this.k0*(0,n.default)(h-this.long0),s=this.y0+this.a*this.k0*Math.log(Math.tan(o.FORTPI+.5*a));else{var e=Math.sin(a),r=(0,l.default)(this.e,a,e);i=this.x0+this.a*this.k0*(0,n.default)(h-this.long0),s=this.y0-this.a*this.k0*Math.log(r)}return t.x=i,t.y=s,t}function M(t){var i,s,h=t.x-this.x0,a=t.y-this.y0;if(this.sphere)s=o.HALF_PI-2*Math.atan(Math.exp(-a/(this.a*this.k0)));else{var e=Math.exp(-a/(this.a*this.k0));if(-9999===(s=(0,u.default)(this.e,e)))return null}return i=(0,n.default)(this.long0+h/(this.a*this.k0)),t.x=i,t.y=s,t}s.init=f,s.forward=_,s.inverse=M,s.names=["Mercator","Popular Visualisation Pseudo Mercator","Mercator_1SP","Mercator_Auxiliary_Sphere","merc"],s.default={init:f,forward:_,inverse:M,names:s.names}},
function _(t,n,r,u,a){u(),r.default=function(t,n,r){var u=t*n;return r/Math.sqrt(1-u*u)}},
function _(t,n,u,a,f){a();const e=t(1),o=t(85),_=(0,e.__importDefault)(t(97));u.default=function(t){return Math.abs(t)<=o.SPI?t:t-(0,_.default)(t)*o.TWO_PI}},
function _(n,t,u,f,c){f(),u.default=function(n){return n<0?-1:1}},
function _(t,n,a,o,u){o();const c=t(85);a.default=function(t,n,a){var o=t*a,u=.5*t;return o=Math.pow((1-o)/(1+o),u),Math.tan(.5*(c.HALF_PI-n))/o}},
function _(t,a,n,r,f){r();const h=t(85);n.default=function(t,a){for(var n,r,f=.5*t,o=h.HALF_PI-2*Math.atan(a),u=0;u<=15;u++)if(n=t*Math.sin(o),o+=r=h.HALF_PI-2*Math.atan(a*Math.pow((1-n)/(1+n),f))-o,Math.abs(r)<=1e-10)return o;return-9999}},
function _(n,i,e,t,r){function a(){}function f(n){return n}t(),e.init=a,e.forward=f,e.inverse=f,e.names=["longlat","identity"],e.default={init:a,forward:f,inverse:f,names:e.names}},
function _(t,r,e,a,n){a();const f=t(1),i=t(85),u=(0,f.__importStar)(t(102)),c=(0,f.__importDefault)(t(88));e.eccentricity=function(t,r,e,a){var n=t*t,f=r*r,u=(n-f)/n,c=0;return a?(n=(t*=1-u*(i.SIXTH+u*(i.RA4+u*i.RA6)))*t,u=0):c=Math.sqrt(u),{es:u,e:c,ep2:(n-f)/f}},e.sphere=function(t,r,e,a,n){if(!t){var f=(0,c.default)(u.default,a);f||(f=u.WGS84),t=f.a,r=f.b,e=f.rf}return e&&!r&&(r=(1-1/e)*t),(0===e||Math.abs(t-r)<i.EPSLN)&&(n=!0,r=t),{a:t,b:r,rf:e,sphere:n}}},
function _(e,a,l,s,r){s();var i={};l.default=i,i.MERIT={a:6378137,rf:298.257,ellipseName:"MERIT 1983"},i.SGS85={a:6378136,rf:298.257,ellipseName:"Soviet Geodetic System 85"},i.GRS80={a:6378137,rf:298.257222101,ellipseName:"GRS 1980(IUGG, 1980)"},i.IAU76={a:6378140,rf:298.257,ellipseName:"IAU 1976"},i.airy={a:6377563.396,b:6356256.91,ellipseName:"Airy 1830"},i.APL4={a:6378137,rf:298.25,ellipseName:"Appl. Physics. 1965"},i.NWL9D={a:6378145,rf:298.25,ellipseName:"Naval Weapons Lab., 1965"},i.mod_airy={a:6377340.189,b:6356034.446,ellipseName:"Modified Airy"},i.andrae={a:6377104.43,rf:300,ellipseName:"Andrae 1876 (Den., Iclnd.)"},i.aust_SA={a:6378160,rf:298.25,ellipseName:"Australian Natl & S. Amer. 1969"},i.GRS67={a:6378160,rf:298.247167427,ellipseName:"GRS 67(IUGG 1967)"},i.bessel={a:6377397.155,rf:299.1528128,ellipseName:"Bessel 1841"},i.bess_nam={a:6377483.865,rf:299.1528128,ellipseName:"Bessel 1841 (Namibia)"},i.clrk66={a:6378206.4,b:6356583.8,ellipseName:"Clarke 1866"},i.clrk80={a:6378249.145,rf:293.4663,ellipseName:"Clarke 1880 mod."},i.clrk58={a:6378293.645208759,rf:294.2606763692654,ellipseName:"Clarke 1858"},i.CPM={a:6375738.7,rf:334.29,ellipseName:"Comm. des Poids et Mesures 1799"},i.delmbr={a:6376428,rf:311.5,ellipseName:"Delambre 1810 (Belgium)"},i.engelis={a:6378136.05,rf:298.2566,ellipseName:"Engelis 1985"},i.evrst30={a:6377276.345,rf:300.8017,ellipseName:"Everest 1830"},i.evrst48={a:6377304.063,rf:300.8017,ellipseName:"Everest 1948"},i.evrst56={a:6377301.243,rf:300.8017,ellipseName:"Everest 1956"},i.evrst69={a:6377295.664,rf:300.8017,ellipseName:"Everest 1969"},i.evrstSS={a:6377298.556,rf:300.8017,ellipseName:"Everest (Sabah & Sarawak)"},i.fschr60={a:6378166,rf:298.3,ellipseName:"Fischer (Mercury Datum) 1960"},i.fschr60m={a:6378155,rf:298.3,ellipseName:"Fischer 1960"},i.fschr68={a:6378150,rf:298.3,ellipseName:"Fischer 1968"},i.helmert={a:6378200,rf:298.3,ellipseName:"Helmert 1906"},i.hough={a:6378270,rf:297,ellipseName:"Hough"},i.intl={a:6378388,rf:297,ellipseName:"International 1909 (Hayford)"},i.kaula={a:6378163,rf:298.24,ellipseName:"Kaula 1961"},i.lerch={a:6378139,rf:298.257,ellipseName:"Lerch 1979"},i.mprts={a:6397300,rf:191,ellipseName:"Maupertius 1738"},i.new_intl={a:6378157.5,b:6356772.2,ellipseName:"New International 1967"},i.plessis={a:6376523,rf:6355863,ellipseName:"Plessis 1817 (France)"},i.krass={a:6378245,rf:298.3,ellipseName:"Krassovsky, 1942"},i.SEasia={a:6378155,b:6356773.3205,ellipseName:"Southeast Asia"},i.walbeck={a:6376896,b:6355834.8467,ellipseName:"Walbeck"},i.WGS60={a:6378165,rf:298.3,ellipseName:"WGS 60"},i.WGS66={a:6378145,rf:298.25,ellipseName:"WGS 66"},i.WGS7={a:6378135,rf:298.26,ellipseName:"WGS 72"},l.WGS84=i.WGS84={a:6378137,rf:298.257223563,ellipseName:"WGS 84"},i.sphere={a:6370997,b:6370997,ellipseName:"Normal Sphere (r=6370997)"}},
function _(e,a,s,t,l){t();var m={};s.default=m,m.wgs84={towgs84:"0,0,0",ellipse:"WGS84",datumName:"WGS84"},m.ch1903={towgs84:"674.374,15.056,405.346",ellipse:"bessel",datumName:"swiss"},m.ggrs87={towgs84:"-199.87,74.79,246.62",ellipse:"GRS80",datumName:"Greek_Geodetic_Reference_System_1987"},m.nad83={towgs84:"0,0,0",ellipse:"GRS80",datumName:"North_American_Datum_1983"},m.nad27={nadgrids:"@conus,@alaska,@ntv2_0.gsb,@ntv1_can.dat",ellipse:"clrk66",datumName:"North_American_Datum_1927"},m.potsdam={towgs84:"598.1,73.7,418.2,0.202,0.045,-2.455,6.7",ellipse:"bessel",datumName:"Potsdam Rauenberg 1950 DHDN"},m.carthage={towgs84:"-263.0,6.0,431.0",ellipse:"clark80",datumName:"Carthage 1934 Tunisia"},m.hermannskogel={towgs84:"577.326,90.129,463.919,5.137,1.474,5.297,2.4232",ellipse:"bessel",datumName:"Hermannskogel"},m.osni52={towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"airy",datumName:"Irish National"},m.ire65={towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"mod_airy",datumName:"Ireland 1965"},m.rassadiran={towgs84:"-133.63,-157.5,-158.62",ellipse:"intl",datumName:"Rassadiran"},m.nzgd49={towgs84:"59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993",ellipse:"intl",datumName:"New Zealand Geodetic Datum 1949"},m.osgb36={towgs84:"446.448,-125.157,542.060,0.1502,0.2470,0.8421,-20.4894",ellipse:"airy",datumName:"Airy 1830"},m.s_jtsk={towgs84:"589,76,480",ellipse:"bessel",datumName:"S-JTSK (Ferro)"},m.beduaram={towgs84:"-106,-87,188",ellipse:"clrk80",datumName:"Beduaram"},m.gunung_segara={towgs84:"-403,684,41",ellipse:"bessel",datumName:"Gunung Segara Jakarta"},m.rnb72={towgs84:"106.869,-52.2978,103.724,-0.33657,0.456955,-1.84218,1",ellipse:"intl",datumName:"Reseau National Belge 1972"}},
function _(a,m,_,t,u){t();const d=a(85);_.default=function(a,m,_,t,u,p,r){var s={};return s.datum_type=void 0===a||"none"===a?d.PJD_NODATUM:d.PJD_WGS84,m&&(s.datum_params=m.map(parseFloat),0===s.datum_params[0]&&0===s.datum_params[1]&&0===s.datum_params[2]||(s.datum_type=d.PJD_3PARAM),s.datum_params.length>3&&(0===s.datum_params[3]&&0===s.datum_params[4]&&0===s.datum_params[5]&&0===s.datum_params[6]||(s.datum_type=d.PJD_7PARAM,s.datum_params[3]*=d.SEC_TO_RAD,s.datum_params[4]*=d.SEC_TO_RAD,s.datum_params[5]*=d.SEC_TO_RAD,s.datum_params[6]=s.datum_params[6]/1e6+1))),r&&(s.datum_type=d.PJD_GRIDSHIFT,s.grids=r),s.a=_,s.b=t,s.es=u,s.ep2=p,s}},
function _(t,e,n,r,i){r();var u={};function l(t){if(0===t.length)return null;var e="@"===t[0];return e&&(t=t.slice(1)),"null"===t?{name:"null",mandatory:!e,grid:null,isNull:!0}:{name:t,mandatory:!e,grid:u[t]||null,isNull:!1}}function o(t){return t/3600*Math.PI/180}function a(t,e,n){return String.fromCharCode.apply(null,new Uint8Array(t.buffer.slice(e,n)))}function d(t){return t.map((function(t){return[o(t.longitudeShift),o(t.latitudeShift)]}))}function g(t,e,n){return{name:a(t,e+8,e+16).trim(),parent:a(t,e+24,e+24+8).trim(),lowerLatitude:t.getFloat64(e+72,n),upperLatitude:t.getFloat64(e+88,n),lowerLongitude:t.getFloat64(e+104,n),upperLongitude:t.getFloat64(e+120,n),latitudeInterval:t.getFloat64(e+136,n),longitudeInterval:t.getFloat64(e+152,n),gridNodeCount:t.getInt32(e+168,n)}}function s(t,e,n,r){for(var i=e+176,u=[],l=0;l<n.gridNodeCount;l++){var o={latitudeShift:t.getFloat32(i+16*l,r),longitudeShift:t.getFloat32(i+16*l+4,r),latitudeAccuracy:t.getFloat32(i+16*l+8,r),longitudeAccuracy:t.getFloat32(i+16*l+12,r)};u.push(o)}return u}n.default=function(t,e){var n=new DataView(e),r=function(t){var e=t.getInt32(8,!1);if(11===e)return!1;11!==(e=t.getInt32(8,!0))&&console.warn("Failed to detect nadgrid endian-ness, defaulting to little-endian");return!0}(n),i=function(t,e){return{nFields:t.getInt32(8,e),nSubgridFields:t.getInt32(24,e),nSubgrids:t.getInt32(40,e),shiftType:a(t,56,64).trim(),fromSemiMajorAxis:t.getFloat64(120,e),fromSemiMinorAxis:t.getFloat64(136,e),toSemiMajorAxis:t.getFloat64(152,e),toSemiMinorAxis:t.getFloat64(168,e)}}(n,r);i.nSubgrids>1&&console.log("Only single NTv2 subgrids are currently supported, subsequent sub grids are ignored");var l=function(t,e,n){for(var r=176,i=[],u=0;u<e.nSubgrids;u++){var l=g(t,r,n),a=s(t,r,l,n),f=Math.round(1+(l.upperLongitude-l.lowerLongitude)/l.longitudeInterval),c=Math.round(1+(l.upperLatitude-l.lowerLatitude)/l.latitudeInterval);i.push({ll:[o(l.lowerLongitude),o(l.lowerLatitude)],del:[o(l.longitudeInterval),o(l.latitudeInterval)],lim:[f,c],count:l.gridNodeCount,cvs:d(a)})}return i}(n,i,r),f={header:i,subgrids:l};return u[t]=f,f},n.getNadgrids=function(t){return void 0===t?null:t.split(",").map(l)}},
function _(t,e,a,r,u){r();const m=t(1),_=t(85),o=(0,m.__importDefault)(t(107)),d=(0,m.__importDefault)(t(109)),f=(0,m.__importDefault)(t(80)),n=(0,m.__importDefault)(t(110)),i=(0,m.__importDefault)(t(111));a.default=function t(e,a,r,u){var m;if(Array.isArray(r)&&(r=(0,n.default)(r)),(0,i.default)(r),e.datum&&a.datum&&function(t,e){return(t.datum.datum_type===_.PJD_3PARAM||t.datum.datum_type===_.PJD_7PARAM)&&"WGS84"!==e.datumCode||(e.datum.datum_type===_.PJD_3PARAM||e.datum.datum_type===_.PJD_7PARAM)&&"WGS84"!==t.datumCode}(e,a)&&(r=t(e,m=new f.default("WGS84"),r,u),e=m),u&&"enu"!==e.axis&&(r=(0,d.default)(e,!1,r)),"longlat"===e.projName)r={x:r.x*_.D2R,y:r.y*_.D2R,z:r.z||0};else if(e.to_meter&&(r={x:r.x*e.to_meter,y:r.y*e.to_meter,z:r.z||0}),!(r=e.inverse(r)))return;if(e.from_greenwich&&(r.x+=e.from_greenwich),r=(0,o.default)(e.datum,a.datum,r))return a.from_greenwich&&(r={x:r.x-a.from_greenwich,y:r.y,z:r.z||0}),"longlat"===a.projName?r={x:r.x*_.R2D,y:r.y*_.R2D,z:r.z||0}:(r=a.forward(r),a.to_meter&&(r={x:r.x/a.to_meter,y:r.y/a.to_meter,z:r.z||0})),u&&"enu"!==a.axis?(0,d.default)(a,!0,r):r}},
function _(r,e,t,a,i){a();const l=r(1),n=r(85),o=r(108),u=(0,l.__importDefault)(r(96));function d(r){return r===n.PJD_3PARAM||r===n.PJD_7PARAM}function s(r,e,t){if(null===r.grids||0===r.grids.length)return console.log("Grid shift grids not found"),-1;for(var a={x:-t.x,y:t.y},i={x:Number.NaN,y:Number.NaN},l=[],o=0;o<r.grids.length;o++){var u=r.grids[o];if(l.push(u.name),u.isNull){i=a;break}if(u.mandatory,null!==u.grid){var d=u.grid.subgrids[0],s=(Math.abs(d.del[1])+Math.abs(d.del[0]))/1e4,f=d.ll[0]-s,x=d.ll[1]-s,m=d.ll[0]+(d.lim[0]-1)*d.del[0]+s,N=d.ll[1]+(d.lim[1]-1)*d.del[1]+s;if(!(x>a.y||f>a.x||N<a.y||m<a.x||(i=y(a,e,d),isNaN(i.x))))break}else if(u.mandatory)return console.log("Unable to find mandatory grid '"+u.name+"'"),-1}return isNaN(i.x)?(console.log("Failed to find a grid shift table for location '"+-a.x*n.R2D+" "+a.y*n.R2D+" tried: '"+l+"'"),-1):(t.x=-i.x,t.y=i.y,0)}function y(r,e,t){var a={x:Number.NaN,y:Number.NaN};if(isNaN(r.x))return a;var i={x:r.x,y:r.y};i.x-=t.ll[0],i.y-=t.ll[1],i.x=(0,u.default)(i.x-Math.PI)+Math.PI;var l=f(i,t);if(e){if(isNaN(l.x))return a;l.x=i.x-l.x,l.y=i.y-l.y;var n,o,d=9;do{if(o=f(l,t),isNaN(o.x)){console.log("Inverse grid shift iteration failed, presumably at grid edge.  Using first approximation.");break}n={x:i.x-(o.x+l.x),y:i.y-(o.y+l.y)},l.x+=n.x,l.y+=n.y}while(d--&&Math.abs(n.x)>1e-12&&Math.abs(n.y)>1e-12);if(d<0)return console.log("Inverse grid shift iterator failed to converge."),a;a.x=(0,u.default)(l.x+t.ll[0]),a.y=l.y+t.ll[1]}else isNaN(l.x)||(a.x=r.x+l.x,a.y=r.y+l.y);return a}function f(r,e){var t,a={x:r.x/e.del[0],y:r.y/e.del[1]},i=Math.floor(a.x),l=Math.floor(a.y),n=a.x-1*i,o=a.y-1*l,u={x:Number.NaN,y:Number.NaN};if(i<0||i>=e.lim[0])return u;if(l<0||l>=e.lim[1])return u;t=l*e.lim[0]+i;var d=e.cvs[t][0],s=e.cvs[t][1];t++;var y=e.cvs[t][0],f=e.cvs[t][1];t+=e.lim[0];var x=e.cvs[t][0],m=e.cvs[t][1];t--;var N=e.cvs[t][0],c=e.cvs[t][1],_=n*o,g=n*(1-o),v=(1-n)*(1-o),S=(1-n)*o;return u.x=v*d+g*y+S*N+_*x,u.y=v*s+g*f+S*c+_*m,u}t.default=function(r,e,t){if((0,o.compareDatums)(r,e))return t;if(r.datum_type===n.PJD_NODATUM||e.datum_type===n.PJD_NODATUM)return t;var a=r.a,i=r.es;if(r.datum_type===n.PJD_GRIDSHIFT){if(0!==s(r,!1,t))return;a=n.SRS_WGS84_SEMIMAJOR,i=n.SRS_WGS84_ESQUARED}var l=e.a,u=e.b,y=e.es;if(e.datum_type===n.PJD_GRIDSHIFT&&(l=n.SRS_WGS84_SEMIMAJOR,u=n.SRS_WGS84_SEMIMINOR,y=n.SRS_WGS84_ESQUARED),i===y&&a===l&&!d(r.datum_type)&&!d(e.datum_type))return t;if(t=(0,o.geodeticToGeocentric)(t,i,a),d(r.datum_type)&&(t=(0,o.geocentricToWgs84)(t,r.datum_type,r.datum_params)),d(e.datum_type)&&(t=(0,o.geocentricFromWgs84)(t,e.datum_type,e.datum_params)),t=(0,o.geocentricToGeodetic)(t,y,l,u),e.datum_type===n.PJD_GRIDSHIFT&&0!==s(e,!0,t))return;return t},t.applyGridShift=s},
function _(a,t,r,m,s){m();const u=a(85);r.compareDatums=function(a,t){return a.datum_type===t.datum_type&&(!(a.a!==t.a||Math.abs(a.es-t.es)>5e-11)&&(a.datum_type===u.PJD_3PARAM?a.datum_params[0]===t.datum_params[0]&&a.datum_params[1]===t.datum_params[1]&&a.datum_params[2]===t.datum_params[2]:a.datum_type!==u.PJD_7PARAM||a.datum_params[0]===t.datum_params[0]&&a.datum_params[1]===t.datum_params[1]&&a.datum_params[2]===t.datum_params[2]&&a.datum_params[3]===t.datum_params[3]&&a.datum_params[4]===t.datum_params[4]&&a.datum_params[5]===t.datum_params[5]&&a.datum_params[6]===t.datum_params[6]))},r.geodeticToGeocentric=function(a,t,r){var m,s,_,e,n=a.x,d=a.y,i=a.z?a.z:0;if(d<-u.HALF_PI&&d>-1.001*u.HALF_PI)d=-u.HALF_PI;else if(d>u.HALF_PI&&d<1.001*u.HALF_PI)d=u.HALF_PI;else{if(d<-u.HALF_PI)return{x:-1/0,y:-1/0,z:a.z};if(d>u.HALF_PI)return{x:1/0,y:1/0,z:a.z}}return n>Math.PI&&(n-=2*Math.PI),s=Math.sin(d),e=Math.cos(d),_=s*s,{x:((m=r/Math.sqrt(1-t*_))+i)*e*Math.cos(n),y:(m+i)*e*Math.sin(n),z:(m*(1-t)+i)*s}},r.geocentricToGeodetic=function(a,t,r,m){var s,_,e,n,d,i,p,P,y,z,M,o,A,c,x,h=1e-12,f=a.x,I=a.y,F=a.z?a.z:0;if(s=Math.sqrt(f*f+I*I),_=Math.sqrt(f*f+I*I+F*F),s/r<h){if(c=0,_/r<h)return u.HALF_PI,x=-m,{x:a.x,y:a.y,z:a.z}}else c=Math.atan2(I,f);e=F/_,P=(n=s/_)*(1-t)*(d=1/Math.sqrt(1-t*(2-t)*n*n)),y=e*d,A=0;do{A++,i=t*(p=r/Math.sqrt(1-t*y*y))/(p+(x=s*P+F*y-p*(1-t*y*y))),o=(M=e*(d=1/Math.sqrt(1-i*(2-i)*n*n)))*P-(z=n*(1-i)*d)*y,P=z,y=M}while(o*o>1e-24&&A<30);return{x:c,y:Math.atan(M/Math.abs(z)),z:x}},r.geocentricToWgs84=function(a,t,r){if(t===u.PJD_3PARAM)return{x:a.x+r[0],y:a.y+r[1],z:a.z+r[2]};if(t===u.PJD_7PARAM){var m=r[0],s=r[1],_=r[2],e=r[3],n=r[4],d=r[5],i=r[6];return{x:i*(a.x-d*a.y+n*a.z)+m,y:i*(d*a.x+a.y-e*a.z)+s,z:i*(-n*a.x+e*a.y+a.z)+_}}},r.geocentricFromWgs84=function(a,t,r){if(t===u.PJD_3PARAM)return{x:a.x-r[0],y:a.y-r[1],z:a.z-r[2]};if(t===u.PJD_7PARAM){var m=r[0],s=r[1],_=r[2],e=r[3],n=r[4],d=r[5],i=r[6],p=(a.x-m)/i,P=(a.y-s)/i,y=(a.z-_)/i;return{x:p+d*P-n*y,y:-d*p+P+e*y,z:n*p-e*P+y}}}},
function _(e,a,i,r,s){r(),i.default=function(e,a,i){var r,s,n,c=i.x,d=i.y,f=i.z||0,u={};for(n=0;n<3;n++)if(!a||2!==n||void 0!==i.z)switch(0===n?(r=c,s=-1!=="ew".indexOf(e.axis[n])?"x":"y"):1===n?(r=d,s=-1!=="ns".indexOf(e.axis[n])?"y":"x"):(r=f,s="z"),e.axis[n]){case"e":u[s]=r;break;case"w":u[s]=-r;break;case"n":u[s]=r;break;case"s":u[s]=-r;break;case"u":void 0!==i[s]&&(u.z=r);break;case"d":void 0!==i[s]&&(u.z=-r);break;default:return null}return u}},
function _(n,t,e,u,f){u(),e.default=function(n){var t={x:n[0],y:n[1]};return n.length>2&&(t.z=n[2]),n.length>3&&(t.m=n[3]),t}},
function _(e,i,n,t,r){function o(e){if("function"==typeof Number.isFinite){if(Number.isFinite(e))return;throw new TypeError("coordinates must be finite numbers")}if("number"!=typeof e||e!=e||!isFinite(e))throw new TypeError("coordinates must be finite numbers")}t(),n.default=function(e){o(e.x),o(e.y)}},
function _(e,i,s,t,o){t();const n=e(1);var l,a,r,_,c;const d=e(53),v=e(42),u=(0,n.__importStar)(e(45)),h=e(48),m=(0,n.__importStar)(e(18));class T extends v.View{initialize(){super.initialize(),this.visuals=new u.Visuals(this)}request_render(){this.parent.request_render()}get canvas(){return this.parent.canvas}set_data(e){const i=this;for(const s of this.model){if(!(s instanceof m.VectorSpec||s instanceof m.ScalarSpec))continue;const t=s.uniform(e);i[`${s.attr}`]=t}}}s.ArrowHeadView=T,T.__name__="ArrowHeadView";class p extends d.Model{constructor(e){super(e)}}s.ArrowHead=p,l=p,p.__name__="ArrowHead",l.define((()=>({size:[m.NumberSpec,25]})));class V extends T{clip(e,i){this.visuals.line.set_vectorize(e,i);const s=this.size.get(i);e.moveTo(.5*s,s),e.lineTo(.5*s,-2),e.lineTo(-.5*s,-2),e.lineTo(-.5*s,s),e.lineTo(0,0),e.lineTo(.5*s,s)}render(e,i){if(this.visuals.line.doit){this.visuals.line.set_vectorize(e,i);const s=this.size.get(i);e.beginPath(),e.moveTo(.5*s,s),e.lineTo(0,0),e.lineTo(-.5*s,s),e.stroke()}}}s.OpenHeadView=V,V.__name__="OpenHeadView";class f extends p{constructor(e){super(e)}}s.OpenHead=f,a=f,f.__name__="OpenHead",a.prototype.default_view=V,a.mixins(h.LineVector);class w extends T{clip(e,i){this.visuals.line.set_vectorize(e,i);const s=this.size.get(i);e.moveTo(.5*s,s),e.lineTo(.5*s,-2),e.lineTo(-.5*s,-2),e.lineTo(-.5*s,s),e.lineTo(.5*s,s)}render(e,i){this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(e,i),this._normal(e,i),e.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(e,i),this._normal(e,i),e.stroke())}_normal(e,i){const s=this.size.get(i);e.beginPath(),e.moveTo(.5*s,s),e.lineTo(0,0),e.lineTo(-.5*s,s),e.closePath()}}s.NormalHeadView=w,w.__name__="NormalHeadView";class H extends p{constructor(e){super(e)}}s.NormalHead=H,r=H,H.__name__="NormalHead",r.prototype.default_view=w,r.mixins([h.LineVector,h.FillVector]),r.override({fill_color:"black"});class z extends T{clip(e,i){this.visuals.line.set_vectorize(e,i);const s=this.size.get(i);e.moveTo(.5*s,s),e.lineTo(.5*s,-2),e.lineTo(-.5*s,-2),e.lineTo(-.5*s,s),e.lineTo(0,.5*s),e.lineTo(.5*s,s)}render(e,i){this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(e,i),this._vee(e,i),e.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(e,i),this._vee(e,i),e.stroke())}_vee(e,i){const s=this.size.get(i);e.beginPath(),e.moveTo(.5*s,s),e.lineTo(0,0),e.lineTo(-.5*s,s),e.lineTo(0,.5*s),e.closePath()}}s.VeeHeadView=z,z.__name__="VeeHeadView";class x extends p{constructor(e){super(e)}}s.VeeHead=x,_=x,x.__name__="VeeHead",_.prototype.default_view=z,_.mixins([h.LineVector,h.FillVector]),_.override({fill_color:"black"});class g extends T{render(e,i){if(this.visuals.line.doit){this.visuals.line.set_vectorize(e,i);const s=this.size.get(i);e.beginPath(),e.moveTo(.5*s,0),e.lineTo(-.5*s,0),e.stroke()}}clip(e,i){}}s.TeeHeadView=g,g.__name__="TeeHeadView";class b extends p{constructor(e){super(e)}}s.TeeHead=b,c=b,b.__name__="TeeHead",c.prototype.default_view=g,c.mixins(h.LineVector)},
function _(n,e,t,i,o){i();const s=n(9);async function c(n,e,t){const i=new n(Object.assign(Object.assign({},t),{model:e}));return i.initialize(),await i.lazy_initialize(),i}t.build_view=async function(n,e={parent:null},t=(n=>n.default_view)){const i=await c(t(n),n,e);return i.connect_signals(),i},t.build_views=async function(n,e,t={parent:null},i=(n=>n.default_view)){const o=(0,s.difference)([...n.keys()],e);for(const e of o)n.get(e).remove(),n.delete(e);const a=[],f=e.filter((e=>!n.has(e)));for(const e of f){const o=await c(i(e),e,t);n.set(e,o),a.push(o)}for(const n of a)n.connect_signals();return a},t.remove_views=function(n){for(const[e,t]of n)t.remove(),n.delete(e)}},
function _(e,s,_,i,l){i();const t=e(1);var o;const r=e(115),p=(0,t.__importStar)(e(48));class h extends r.UpperLowerView{paint(e){e.beginPath(),e.moveTo(this._lower_sx[0],this._lower_sy[0]);for(let s=0,_=this._lower_sx.length;s<_;s++)e.lineTo(this._lower_sx[s],this._lower_sy[s]);for(let s=this._upper_sx.length-1;s>=0;s--)e.lineTo(this._upper_sx[s],this._upper_sy[s]);e.closePath(),this.visuals.fill.apply(e),e.beginPath(),e.moveTo(this._lower_sx[0],this._lower_sy[0]);for(let s=0,_=this._lower_sx.length;s<_;s++)e.lineTo(this._lower_sx[s],this._lower_sy[s]);this.visuals.line.apply(e),e.beginPath(),e.moveTo(this._upper_sx[0],this._upper_sy[0]);for(let s=0,_=this._upper_sx.length;s<_;s++)e.lineTo(this._upper_sx[s],this._upper_sy[s]);this.visuals.line.apply(e)}}_.BandView=h,h.__name__="BandView";class n extends r.UpperLower{constructor(e){super(e)}}_.Band=n,o=n,n.__name__="Band",o.prototype.default_view=h,o.mixins([p.Line,p.Fill]),o.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})},
function _(e,t,i,s,o){s();const r=e(1);var n;const p=e(69),a=e(20),_=(0,r.__importStar)(e(18));class h extends p.DataAnnotationView{map_data(){const{frame:e}=this.plot_view,t=this.model.dimension,i=this.coordinates.x_scale,s=this.coordinates.y_scale,o="height"==t?s:i,r="height"==t?i:s,n="height"==t?e.bbox.yview:e.bbox.xview,p="height"==t?e.bbox.xview:e.bbox.yview;let a,_,h;a="data"==this.model.properties.lower.units?o.v_compute(this._lower):n.v_compute(this._lower),_="data"==this.model.properties.upper.units?o.v_compute(this._upper):n.v_compute(this._upper),h="data"==this.model.properties.base.units?r.v_compute(this._base):p.v_compute(this._base);const[d,c]="height"==t?[1,0]:[0,1],u=[a,h],l=[_,h];this._lower_sx=u[d],this._lower_sy=u[c],this._upper_sx=l[d],this._upper_sy=l[c]}}i.UpperLowerView=h,h.__name__="UpperLowerView";class d extends _.CoordinateSpec{get dimension(){return"width"==this.obj.dimension?"x":"y"}get units(){var e;return null!==(e=this.spec.units)&&void 0!==e?e:"data"}}i.XOrYCoordinateSpec=d,d.__name__="XOrYCoordinateSpec";class c extends p.DataAnnotation{constructor(e){super(e)}}i.UpperLower=c,n=c,c.__name__="UpperLower",n.define((()=>({dimension:[a.Dimension,"height"],lower:[d,{field:"lower"}],upper:[d,{field:"upper"}],base:[d,{field:"base"}]})))},
function _(t,o,i,n,e){n();const s=t(1);var l;const r=t(40),a=(0,s.__importStar)(t(48)),c=t(20),h=t(65);i.EDGE_TOLERANCE=2.5;class b extends r.AnnotationView{constructor(){super(...arguments),this.bbox=new h.BBox}connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>this.request_render()))}_render(){const{left:t,right:o,top:i,bottom:n}=this.model;if(null==t&&null==o&&null==i&&null==n)return;const{frame:e}=this.plot_view,s=this.coordinates.x_scale,l=this.coordinates.y_scale,r=(t,o,i,n,e)=>{let s;return s=null!=t?this.model.screen?t:"data"==o?i.compute(t):n.compute(t):e,s};this.bbox=h.BBox.from_rect({left:r(t,this.model.left_units,s,e.bbox.xview,e.bbox.left),right:r(o,this.model.right_units,s,e.bbox.xview,e.bbox.right),top:r(i,this.model.top_units,l,e.bbox.yview,e.bbox.top),bottom:r(n,this.model.bottom_units,l,e.bbox.yview,e.bbox.bottom)}),this._paint_box()}_paint_box(){const{ctx:t}=this.layer;t.save();const{left:o,top:i,width:n,height:e}=this.bbox;t.beginPath(),t.rect(o,i,n,e),this.visuals.fill.apply(t),this.visuals.hatch.apply(t),this.visuals.line.apply(t),t.restore()}interactive_bbox(){const t=this.model.line_width+i.EDGE_TOLERANCE;return this.bbox.grow_by(t)}interactive_hit(t,o){if(null==this.model.in_cursor)return!1;return this.interactive_bbox().contains(t,o)}cursor(t,o){const{left:i,right:n,bottom:e,top:s}=this.bbox;return Math.abs(t-i)<3||Math.abs(t-n)<3?this.model.ew_cursor:Math.abs(o-e)<3||Math.abs(o-s)<3?this.model.ns_cursor:this.bbox.contains(t,o)?this.model.in_cursor:null}}i.BoxAnnotationView=b,b.__name__="BoxAnnotationView";class u extends r.Annotation{constructor(t){super(t)}update({left:t,right:o,top:i,bottom:n}){this.setv({left:t,right:o,top:i,bottom:n,screen:!0})}}i.BoxAnnotation=u,l=u,u.__name__="BoxAnnotation",l.prototype.default_view=b,l.mixins([a.Line,a.Fill,a.Hatch]),l.define((({Number:t,Nullable:o})=>({top:[o(t),null],top_units:[c.SpatialUnits,"data"],bottom:[o(t),null],bottom_units:[c.SpatialUnits,"data"],left:[o(t),null],left_units:[c.SpatialUnits,"data"],right:[o(t),null],right_units:[c.SpatialUnits,"data"],render_mode:[c.RenderMode,"canvas"]}))),l.internal((({Boolean:t,String:o,Nullable:i})=>({screen:[t,!1],ew_cursor:[i(o),null],ns_cursor:[i(o),null],in_cursor:[i(o),null]}))),l.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})},
function _(t,e,i,o,n){o();const a=t(1);var r;const s=t(40),l=t(118),_=t(126),c=t(127),h=t(130),u=t(168),p=t(131),m=t(192),g=t(132),d=t(173),f=t(172),w=t(196),b=t(204),v=t(206),x=t(133),y=t(20),k=(0,a.__importStar)(t(48)),z=t(9),j=t(207),C=t(208),L=t(211),B=t(123),S=t(11),M=t(113),T=t(65),A=t(8);class O extends s.AnnotationView{get orientation(){return this._orientation}initialize(){super.initialize();const{ticker:t,formatter:e,color_mapper:i}=this.model;this._ticker="auto"!=t?t:(()=>{switch(!0){case i instanceof w.LogColorMapper:return new u.LogTicker;case i instanceof w.ScanningColorMapper:return new u.BinnedTicker({mapper:i});case i instanceof w.CategoricalColorMapper:return new u.CategoricalTicker;default:return new u.BasicTicker}})(),this._formatter="auto"!=e?e:(()=>{switch(!0){case this._ticker instanceof u.LogTicker:return new m.LogTickFormatter;case i instanceof w.CategoricalColorMapper:return new m.CategoricalTickFormatter;default:return new m.BasicTickFormatter}})(),this._major_range=(()=>{if(i instanceof w.CategoricalColorMapper){const{factors:t}=i;return new v.FactorRange({factors:t})}if(i instanceof f.ContinuousColorMapper){const{min:t,max:e}=i.metrics;return new v.Range1d({start:t,end:e})}(0,S.unreachable)()})(),this._major_scale=(()=>{if(i instanceof w.LinearColorMapper)return new b.LinearScale;if(i instanceof w.LogColorMapper)return new b.LogScale;if(i instanceof w.ScanningColorMapper){const{binning:t}=i.metrics;return new b.LinearInterpolationScale({binning:t})}if(i instanceof w.CategoricalColorMapper)return new b.CategoricalScale;(0,S.unreachable)()})(),this._minor_range=new v.Range1d({start:0,end:1}),this._minor_scale=new b.LinearScale;const o=k.attrs_of(this.model,"major_label_",k.Text,!0),n=k.attrs_of(this.model,"major_tick_",k.Line,!0),a=k.attrs_of(this.model,"minor_tick_",k.Line,!0),r=k.attrs_of(this.model,"title_",k.Text),s=i instanceof w.CategoricalColorMapper?c.CategoricalAxis:i instanceof w.LogColorMapper?c.LogAxis:c.LinearAxis;this._axis=new s(Object.assign(Object.assign(Object.assign({ticker:this._ticker,formatter:this._formatter,major_tick_in:this.model.major_tick_in,major_tick_out:this.model.major_tick_out,minor_tick_in:this.model.minor_tick_in,minor_tick_out:this.model.minor_tick_out,major_label_standoff:this.model.label_standoff,major_label_overrides:this.model.major_label_overrides,major_label_policy:this.model.major_label_policy,axis_line_color:null},o),n),a));const{title:_}=this.model;_&&(this._title=new l.Title(Object.assign({text:_,standoff:this.model.title_standoff},r)))}async lazy_initialize(){await super.lazy_initialize();const t=this,e={get parent(){return t.parent},get root(){return t.root},get frame(){return t._frame},get canvas_view(){return t.parent.canvas_view},request_layout(){t.parent.request_layout()}};this._axis_view=await(0,M.build_view)(this._axis,{parent:e}),null!=this._title&&(this._title_view=await(0,M.build_view)(this._title,{parent:e}))}remove(){var t;null===(t=this._title_view)||void 0===t||t.remove(),this._axis_view.remove(),super.remove()}connect_signals(){super.connect_signals(),this.connect(this._ticker.change,(()=>this.request_render())),this.connect(this._formatter.change,(()=>this.request_render())),this.connect(this.model.color_mapper.metrics_change,(()=>{const t=this._major_range,e=this._major_scale,{color_mapper:i}=this.model;if(i instanceof f.ContinuousColorMapper&&t instanceof v.Range1d){const{min:e,max:o}=i.metrics;t.setv({start:e,end:o})}if(i instanceof w.ScanningColorMapper&&e instanceof b.LinearInterpolationScale){const{binning:t}=i.metrics;e.binning=t}this._set_canvas_image(),this.plot_view.request_layout()}))}_set_canvas_image(){const{orientation:t}=this,e=(()=>{const{palette:e}=this.model.color_mapper;return"vertical"==t?(0,z.reversed)(e):e})(),[i,o]="vertical"==t?[1,e.length]:[e.length,1],n=this._image=document.createElement("canvas");n.width=i,n.height=o;const a=n.getContext("2d"),r=a.getImageData(0,0,i,o),s=new w.LinearColorMapper({palette:e}).rgba_mapper.v_compute((0,z.range)(0,e.length));r.data.set(s),a.putImageData(r,0,0)}update_layout(){const{location:t,width:e,height:i,padding:o,margin:n}=this.model,[a,r]=(()=>{if(!(0,A.isString)(t))return["end","start"];switch(t){case"top_left":return["start","start"];case"top":case"top_center":return["start","center"];case"top_right":return["start","end"];case"bottom_left":return["end","start"];case"bottom":case"bottom_center":return["end","center"];case"bottom_right":return["end","end"];case"left":case"center_left":return["center","start"];case"center":case"center_center":return["center","center"];case"right":case"center_right":return["center","end"]}})(),s=this._orientation=(()=>{const{orientation:t}=this.model;return"auto"==t?null!=this.panel?this.panel.is_horizontal?"horizontal":"vertical":"start"==r||"end"==r||"center"==r&&"center"==a?"vertical":"horizontal":t})(),l=new C.NodeLayout,c=new C.VStack,h=new C.VStack,u=new C.HStack,p=new C.HStack;l.absolute=!0,c.absolute=!0,h.absolute=!0,u.absolute=!0,p.absolute=!0;const[m,g,d,f]=(()=>"horizontal"==s?[this._major_scale,this._minor_scale,this._major_range,this._minor_range]:[this._minor_scale,this._major_scale,this._minor_range,this._major_range])();this._frame=new _.CartesianFrame(m,g,d,f),l.on_resize((t=>this._frame.set_geometry(t)));const w=new L.BorderLayout;this._inner_layout=w,w.absolute=!0,w.center_panel=l,w.top_panel=c,w.bottom_panel=h,w.left_panel=u,w.right_panel=p;const b={left:o,right:o,top:o,bottom:o},v=(()=>{if(null==this.panel){if((0,A.isString)(t))return{left:n,right:n,top:n,bottom:n};{const[e,i]=t;return{left:e,right:n,top:n,bottom:i}}}if(!(0,A.isString)(t)){const[e,i]=t;return w.fixup_geometry=(t,o)=>{const n=t,a=this.layout.bbox,{width:r,height:s}=t;if(t=new T.BBox({left:a.left+e,bottom:a.bottom-i,width:r,height:s}),null!=o){const e=t.left-n.left,i=t.top-n.top,{left:a,top:r,width:s,height:l}=o;o=new T.BBox({left:a+e,top:r+i,width:s,height:l})}return[t,o]},{left:e,right:0,top:0,bottom:i}}w.fixup_geometry=(t,e)=>{const i=t;if("horizontal"==s){const{top:e,width:i,height:o}=t;if("end"==r){const{right:n}=this.layout.bbox;t=new T.BBox({right:n,top:e,width:i,height:o})}else if("center"==r){const{hcenter:n}=this.layout.bbox;t=new T.BBox({hcenter:Math.round(n),top:e,width:i,height:o})}}else{const{left:e,width:i,height:o}=t;if("end"==a){const{bottom:n}=this.layout.bbox;t=new T.BBox({left:e,bottom:n,width:i,height:o})}else if("center"==a){const{vcenter:n}=this.layout.bbox;t=new T.BBox({left:e,vcenter:Math.round(n),width:i,height:o})}}if(null!=e){const o=t.left-i.left,n=t.top-i.top,{left:a,top:r,width:s,height:l}=e;e=new T.BBox({left:a+o,top:r+n,width:s,height:l})}return[t,e]}})();let x,y,k,z;if(w.padding=b,null!=this.panel?(x="max",y=void 0,k=void 0,z=void 0):"auto"==("horizontal"==s?e:i)?(x="fixed",y=25*this.model.color_mapper.palette.length,k={percent:.3},z={percent:.8}):(x="fit",y=void 0),"horizontal"==s){const t="auto"==e?void 0:e,o="auto"==i?25:i;w.set_sizing({width_policy:x,height_policy:"min",width:y,min_width:k,max_width:z,halign:r,valign:a,margin:v}),w.center_panel.set_sizing({width_policy:"auto"==e?"fit":"fixed",height_policy:"fixed",width:t,height:o})}else{const t="auto"==e?25:e,o="auto"==i?void 0:i;w.set_sizing({width_policy:"min",height_policy:x,height:y,min_height:k,max_height:z,halign:r,valign:a,margin:v}),w.center_panel.set_sizing({width_policy:"fixed",height_policy:"auto"==i?"fit":"fixed",width:t,height:o})}c.set_sizing({width_policy:"fit",height_policy:"min"}),h.set_sizing({width_policy:"fit",height_policy:"min"}),u.set_sizing({width_policy:"min",height_policy:"fit"}),p.set_sizing({width_policy:"min",height_policy:"fit"});const{_title_view:S}=this;null!=S&&("horizontal"==s?(S.panel=new B.Panel("above"),S.update_layout(),c.children.push(S.layout)):(S.panel=new B.Panel("left"),S.update_layout(),u.children.push(S.layout)));const{panel:M}=this,O=null!=M&&s==M.orientation?M.side:"horizontal"==s?"below":"right",R=(()=>{switch(O){case"above":return c;case"below":return h;case"left":return u;case"right":return p}})(),{_axis_view:F}=this;if(F.panel=new B.Panel(O),F.update_layout(),R.children.push(F.layout),null!=this.panel){const t=new j.Grid([{layout:w,row:0,col:0}]);t.absolute=!0,"horizontal"==s?t.set_sizing({width_policy:"max",height_policy:"min"}):t.set_sizing({width_policy:"min",height_policy:"max"}),this.layout=t}else this.layout=this._inner_layout;const{visible:I}=this.model;this.layout.sizing.visible=I,this._set_canvas_image()}_render(){var t;const{ctx:e}=this.layer;e.save(),this._paint_bbox(e,this._inner_layout.bbox),this._paint_image(e,this._inner_layout.center_panel.bbox),null===(t=this._title_view)||void 0===t||t.render(),this._axis_view.render(),e.restore()}_paint_bbox(t,e){const{x:i,y:o}=e;let{width:n,height:a}=e;i+n>=this.parent.canvas_view.bbox.width&&(n-=1),o+a>=this.parent.canvas_view.bbox.height&&(a-=1),t.save(),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(t),t.fillRect(i,o,n,a)),this.visuals.border_line.doit&&(this.visuals.border_line.set_value(t),t.strokeRect(i,o,n,a)),t.restore()}_paint_image(t,e){const{x:i,y:o,width:n,height:a}=e;t.save(),t.setImageSmoothingEnabled(!1),t.globalAlpha=this.model.scale_alpha,t.drawImage(this._image,i,o,n,a),this.visuals.bar_line.doit&&(this.visuals.bar_line.set_value(t),t.strokeRect(i,o,n,a)),t.restore()}serializable_state(){const t=super.serializable_state(),{children:e=[]}=t,i=(0,a.__rest)(t,["children"]);return null!=this._title_view&&e.push(this._title_view.serializable_state()),e.push(this._axis_view.serializable_state()),Object.assign(Object.assign({},i),{children:e})}}i.ColorBarView=O,O.__name__="ColorBarView";class R extends s.Annotation{constructor(t){super(t)}}i.ColorBar=R,r=R,R.__name__="ColorBar",r.prototype.default_view=O,r.mixins([["major_label_",k.Text],["title_",k.Text],["major_tick_",k.Line],["minor_tick_",k.Line],["border_",k.Line],["bar_",k.Line],["background_",k.Fill]]),r.define((({Alpha:t,Number:e,String:i,Tuple:o,Dict:n,Or:a,Ref:r,Auto:s,Nullable:l})=>({location:[a(y.Anchor,o(e,e)),"top_right"],orientation:[a(y.Orientation,s),"auto"],title:[l(i),null],title_standoff:[e,2],width:[a(e,s),"auto"],height:[a(e,s),"auto"],scale_alpha:[t,1],ticker:[a(r(h.Ticker),s),"auto"],formatter:[a(r(p.TickFormatter),s),"auto"],major_label_overrides:[n(a(i,r(x.BaseText))),{}],major_label_policy:[r(g.LabelingPolicy),()=>new g.NoOverlap],color_mapper:[r(d.ColorMapper)],label_standoff:[e,5],margin:[e,30],padding:[e,10],major_tick_in:[e,5],major_tick_out:[e,0],minor_tick_in:[e,0],minor_tick_out:[e,0]}))),r.override({background_fill_color:"#ffffff",background_fill_alpha:.95,bar_line_color:null,border_line_color:null,major_label_text_font_size:"11px",major_tick_line_color:"#ffffff",minor_tick_line_color:null,title_text_font_size:"13px",title_text_font_style:"italic"})},
function _(t,e,i,s,l){s();const o=t(1);var a;const n=t(119),r=t(20),c=t(120),h=(0,o.__importStar)(t(48));class _ extends n.TextAnnotationView{_get_location(){const t=this.model.offset,e=this.model.standoff/2;let i,s;const{bbox:l}=this.layout;switch(this.panel.side){case"above":case"below":switch(this.model.vertical_align){case"top":s=l.top+e;break;case"middle":s=l.vcenter;break;case"bottom":s=l.bottom-e}switch(this.model.align){case"left":i=l.left+t;break;case"center":i=l.hcenter;break;case"right":i=l.right-t}break;case"left":switch(this.model.vertical_align){case"top":i=l.left+e;break;case"middle":i=l.hcenter;break;case"bottom":i=l.right-e}switch(this.model.align){case"left":s=l.bottom-t;break;case"center":s=l.vcenter;break;case"right":s=l.top+t}break;case"right":switch(this.model.vertical_align){case"top":i=l.right-e;break;case"middle":i=l.hcenter;break;case"bottom":i=l.left+e}switch(this.model.align){case"left":s=l.top+t;break;case"center":s=l.vcenter;break;case"right":s=l.bottom-t}}return[i,s]}_render(){const{text:t}=this.model;if(null==t||0==t.length)return;this.model.text_baseline=this.model.vertical_align,this.model.text_align=this.model.align;const[e,i]=this._get_location(),s=this.panel.get_label_angle_heuristic("parallel");("canvas"==this.model.render_mode?this._canvas_text.bind(this):this._css_text.bind(this))(this.layer.ctx,t,e,i,s)}_get_size(){const{text:t}=this.model,e=new c.TextBox({text:t});e.visuals=this.visuals.text.values();const{width:i,height:s}=e.size();return{width:i,height:0==s?0:2+s+this.model.standoff}}}i.TitleView=_,_.__name__="TitleView";class d extends n.TextAnnotation{constructor(t){super(t)}}i.Title=d,a=d,d.__name__="Title",a.prototype.default_view=_,a.mixins([h.Text,["border_",h.Line],["background_",h.Fill]]),a.define((({Number:t,String:e})=>({text:[e,""],vertical_align:[r.VerticalAlign,"bottom"],align:[r.TextAlign,"left"],offset:[t,0],standoff:[t,10]}))),a.prototype._props.text_align.options.internal=!0,a.prototype._props.text_baseline.options.internal=!0,a.override({text_font_size:"13px",text_font_style:"bold",text_line_height:1,background_fill_color:null,border_line_color:null})},
function _(e,t,s,i,l){var n;i();const o=e(40),a=e(43),r=e(20),d=e(120),u=e(123),c=e(11);class h extends o.AnnotationView{update_layout(){const{panel:e}=this;this.layout=null!=e?new u.SideLayout(e,(()=>this.get_size()),!0):void 0}initialize(){super.initialize(),"css"==this.model.render_mode&&(this.el=(0,a.div)(),this.plot_view.canvas_view.add_overlay(this.el))}remove(){null!=this.el&&(0,a.remove)(this.el),super.remove()}connect_signals(){super.connect_signals(),"css"==this.model.render_mode?this.connect(this.model.change,(()=>this.render())):this.connect(this.model.change,(()=>this.request_render()))}render(){this.model.visible||"css"!=this.model.render_mode||(0,a.undisplay)(this.el),super.render()}_canvas_text(e,t,s,i,l){const n=new d.TextBox({text:t});n.angle=l,n.position={sx:s,sy:i},n.visuals=this.visuals.text.values();const{background_fill:o,border_line:a}=this.visuals;if(o.doit||a.doit){const{p0:t,p1:s,p2:i,p3:l}=n.rect();e.beginPath(),e.moveTo(t.x,t.y),e.lineTo(s.x,s.y),e.lineTo(i.x,i.y),e.lineTo(l.x,l.y),e.closePath(),this.visuals.background_fill.apply(e),this.visuals.border_line.apply(e)}this.visuals.text.doit&&n.paint(e)}_css_text(e,t,s,i,l){const{el:n}=this;(0,c.assert)(null!=n),(0,a.undisplay)(n),n.textContent=t,this.visuals.text.set_value(e),n.style.position="absolute",n.style.left=`${s}px`,n.style.top=`${i}px`,n.style.color=e.fillStyle,n.style.font=e.font,n.style.lineHeight="normal",n.style.whiteSpace="pre";const[o,r]=(()=>{switch(this.visuals.text.text_align.get_value()){case"left":return["left","0%"];case"center":return["center","-50%"];case"right":return["right","-100%"]}})(),[d,u]=(()=>{switch(this.visuals.text.text_baseline.get_value()){case"top":return["top","0%"];case"middle":return["center","-50%"];case"bottom":return["bottom","-100%"];default:return["center","-50%"]}})();let h=`translate(${r}, ${u})`;l&&(h+=`rotate(${l}rad)`),n.style.transformOrigin=`${o} ${d}`,n.style.transform=h,this.layout,this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(e),n.style.backgroundColor=e.fillStyle),this.visuals.border_line.doit&&(this.visuals.border_line.set_value(e),n.style.borderStyle=e.lineDash.length<2?"solid":"dashed",n.style.borderWidth=`${e.lineWidth}px`,n.style.borderColor=e.strokeStyle),(0,a.display)(n)}}s.TextAnnotationView=h,h.__name__="TextAnnotationView";class _ extends o.Annotation{constructor(e){super(e)}}s.TextAnnotation=_,n=_,_.__name__="TextAnnotation",n.define((()=>({render_mode:[r.RenderMode,"canvas"]})))},
function _(t,e,s,i,n){i();const h=t(65),o=t(121),r=t(9),a=t(8),c=t(122),_=t(22);s.text_width=(()=>{const t=document.createElement("canvas").getContext("2d");let e="";return(s,i)=>(i!=e&&(e=i,t.font=i),t.measureText(s).width)})();class l{constructor(){this._position={sx:0,sy:0},this.font_size_scale=1,this.align="left",this._base_font_size=13,this._x_anchor="left",this._y_anchor="center"}set base_font_size(t){null!=t&&(this._base_font_size=t)}get base_font_size(){return this._base_font_size}set position(t){this._position=t}get position(){return this._position}infer_text_height(){return"ascent_descent"}bbox(){const{p0:t,p1:e,p2:s,p3:i}=this.rect(),n=Math.min(t.x,e.x,s.x,i.x),o=Math.min(t.y,e.y,s.y,i.y),r=Math.max(t.x,e.x,s.x,i.x),a=Math.max(t.y,e.y,s.y,i.y);return new h.BBox({left:n,right:r,top:o,bottom:a})}size(){const{width:t,height:e}=this._size(),{angle:s}=this;if(s){const i=Math.cos(Math.abs(s)),n=Math.sin(Math.abs(s));return{width:Math.abs(t*i+e*n),height:Math.abs(t*n+e*i)}}return{width:t,height:e}}rect(){const t=this._rect(),{angle:e}=this;if(e){const{sx:s,sy:i}=this.position,n=new c.AffineTransform;return n.translate(s,i),n.rotate(e),n.translate(-s,-i),n.apply_rect(t)}return t}paint_rect(t){const{p0:e,p1:s,p2:i,p3:n}=this.rect();t.save(),t.strokeStyle="red",t.lineWidth=1,t.beginPath();const{round:h}=Math;t.moveTo(h(e.x),h(e.y)),t.lineTo(h(s.x),h(s.y)),t.lineTo(h(i.x),h(i.y)),t.lineTo(h(n.x),h(n.y)),t.closePath(),t.stroke(),t.restore()}paint_bbox(t){const{x:e,y:s,width:i,height:n}=this.bbox();t.save(),t.strokeStyle="blue",t.lineWidth=1,t.beginPath();const{round:h}=Math;t.moveTo(h(e),h(s)),t.lineTo(h(e),h(s+n)),t.lineTo(h(e+i),h(s+n)),t.lineTo(h(e+i),h(s)),t.closePath(),t.stroke(),t.restore()}}s.GraphicsBox=l,l.__name__="GraphicsBox";class x extends l{constructor({text:t}){super(),this.text=t}set visuals(t){const e=t.color,s=t.alpha,i=t.font_style;let n=t.font_size;const h=t.font,{font_size_scale:r,base_font_size:a}=this,c=(0,o.parse_css_font_size)(n);if(null!=c){let{value:t,unit:e}=c;t*=r,"em"==e&&a&&(t*=a,e="px"),n=`${t}${e}`}const l=`${i} ${n} ${h}`;this.font=l,this.color=(0,_.color2css)(e,s),this.line_height=t.line_height;const x=t.align;this._x_anchor=x;const u=t.baseline;this._y_anchor=(()=>{switch(u){case"top":return"top";case"middle":return"center";case"bottom":return"bottom";default:return"baseline"}})()}infer_text_height(){if(this.text.includes("\n"))return"ascent_descent";{function t(t){for(const e of new Set(t))if(!("0"<=e&&e<="9"))switch(e){case",":case".":case"+":case"-":case"\u2212":case"e":continue;default:return!1}return!0}return t(this.text)?"cap":"ascent_descent"}}_text_line(t){var e;const s=null!==(e=this.text_height_metric)&&void 0!==e?e:this.infer_text_height(),i=(()=>{switch(s){case"x":case"x_descent":return t.x_height;case"cap":case"cap_descent":return t.cap_height;case"ascent":case"ascent_descent":return t.ascent}})(),n=(()=>{switch(s){case"x":case"cap":case"ascent":return 0;case"x_descent":case"cap_descent":case"ascent_descent":return t.descent}})();return{height:i+n,ascent:i,descent:n}}get nlines(){return this.text.split("\n").length}_size(){var t,e;const{font:i}=this,n=(0,o.font_metrics)(i),h=(this.line_height-1)*n.height,a=""==this.text,c=this.text.split("\n"),_=c.length,l=c.map((t=>(0,s.text_width)(t,i))),x=this._text_line(n).height*_,u="%"==(null===(t=this.width)||void 0===t?void 0:t.unit)?this.width.value:1,p="%"==(null===(e=this.height)||void 0===e?void 0:e.unit)?this.height.value:1;return{width:(0,r.max)(l)*u,height:a?0:(x+h*(_-1))*p,metrics:n}}_computed_position(t,e,s){const{width:i,height:n}=t,{sx:h,sy:o,x_anchor:r=this._x_anchor,y_anchor:c=this._y_anchor}=this.position;return{x:h-(()=>{if((0,a.isNumber)(r))return r*i;switch(r){case"left":return 0;case"center":return.5*i;case"right":return i}})(),y:o-(()=>{var t;if((0,a.isNumber)(c))return c*n;switch(c){case"top":return 0;case"center":return.5*n;case"bottom":return n;case"baseline":if(1!=s)return.5*n;switch(null!==(t=this.text_height_metric)&&void 0!==t?t:this.infer_text_height()){case"x":case"x_descent":return e.x_height;case"cap":case"cap_descent":return e.cap_height;case"ascent":case"ascent_descent":return e.ascent}}})()}}_rect(){const{width:t,height:e,metrics:s}=this._size(),i=this.text.split("\n").length,{x:n,y:o}=this._computed_position({width:t,height:e},s,i);return new h.BBox({x:n,y:o,width:t,height:e}).rect}paint(t){var e,i;const{font:n}=this,h=(0,o.font_metrics)(n),a=(this.line_height-1)*h.height,c=this.text.split("\n"),_=c.length,l=c.map((t=>(0,s.text_width)(t,n))),x=this._text_line(h),u=x.height*_,p="%"==(null===(e=this.width)||void 0===e?void 0:e.unit)?this.width.value:1,f="%"==(null===(i=this.height)||void 0===i?void 0:i.unit)?this.height.value:1,g=(0,r.max)(l)*p,d=(u+a*(_-1))*f;t.save(),t.fillStyle=this.color,t.font=this.font,t.textAlign="left",t.textBaseline="alphabetic";const{sx:b,sy:m}=this.position,{align:y}=this,{angle:w}=this;w&&(t.translate(b,m),t.rotate(w),t.translate(-b,-m));let{x:v,y:z}=this._computed_position({width:g,height:d},h,_);if("justify"==y)for(let e=0;e<_;e++){let i=v;const h=c[e].split(" "),o=h.length,_=h.map((t=>(0,s.text_width)(t,n))),l=(g-(0,r.sum)(_))/(o-1);for(let e=0;e<o;e++)t.fillText(h[e],i,z),i+=_[e]+l;z+=x.height+a}else for(let e=0;e<_;e++){const s=v+(()=>{switch(y){case"left":return 0;case"center":return.5*(g-l[e]);case"right":return g-l[e]}})();t.fillStyle=this.color,t.fillText(c[e],s,z+x.ascent),z+=x.height+a}t.restore()}}s.TextBox=x,x.__name__="TextBox";class u extends l{constructor(t,e){super(),this.base=t,this.expo=e}get children(){return[this.base,this.expo]}set base_font_size(t){super.base_font_size=t,this.base.base_font_size=t,this.expo.base_font_size=t}set position(t){this._position=t;const e=this.base.size(),s=this.expo.size(),i=this._shift_scale()*e.height,n=Math.max(e.height,i+s.height);this.base.position={sx:0,x_anchor:"left",sy:n,y_anchor:"bottom"},this.expo.position={sx:e.width,x_anchor:"left",sy:i,y_anchor:"bottom"}}get position(){return this._position}set visuals(t){this.expo.font_size_scale=.7,this.base.visuals=t,this.expo.visuals=t}_shift_scale(){if(this.base instanceof x&&1==this.base.nlines){const{x_height:t,cap_height:e}=(0,o.font_metrics)(this.base.font);return t/e}return 2/3}infer_text_height(){return this.base.infer_text_height()}_rect(){const t=this.base.bbox(),e=this.expo.bbox(),s=t.union(e),{x:i,y:n}=this._computed_position();return s.translate(i,n).rect}_size(){const t=this.base.size(),e=this.expo.size();return{width:t.width+e.width,height:Math.max(t.height,this._shift_scale()*t.height+e.height)}}paint(t){t.save();const{angle:e}=this;if(e){const{sx:s,sy:i}=this.position;t.translate(s,i),t.rotate(e),t.translate(-s,-i)}const{x:s,y:i}=this._computed_position();t.translate(s,i),this.base.paint(t),this.expo.paint(t),t.restore()}paint_bbox(t){super.paint_bbox(t);const{x:e,y:s}=this._computed_position();t.save(),t.translate(e,s);for(const e of this.children)e.paint_bbox(t);t.restore()}_computed_position(){const{width:t,height:e}=this._size(),{sx:s,sy:i,x_anchor:n=this._x_anchor,y_anchor:h=this._y_anchor}=this.position;return{x:s-(()=>{if((0,a.isNumber)(n))return n*t;switch(n){case"left":return 0;case"center":return.5*t;case"right":return t}})(),y:i-(()=>{if((0,a.isNumber)(h))return h*e;switch(h){case"top":return 0;case"center":return.5*e;case"bottom":return e;case"baseline":return.5*e}})()}}}s.BaseExpo=u,u.__name__="BaseExpo";class p{constructor(t){this.items=t}set base_font_size(t){for(const e of this.items)e.base_font_size=t}get length(){return this.items.length}set visuals(t){for(const e of this.items)e.visuals=t;const e={x:0,cap:1,ascent:2,x_descent:3,cap_descent:4,ascent_descent:5},s=(0,r.max_by)(this.items.map((t=>t.infer_text_height())),(t=>e[t]));for(const t of this.items)t.text_height_metric=s}set angle(t){for(const e of this.items)e.angle=t}max_size(){let t=0,e=0;for(const s of this.items){const i=s.size();t=Math.max(t,i.width),e=Math.max(e,i.height)}return{width:t,height:e}}}s.GraphicsBoxes=p,p.__name__="GraphicsBoxes"},
function _(t,e,n,r,l){r();const a=t(11),c=(()=>{try{return"undefined"!=typeof OffscreenCanvas&&null!=new OffscreenCanvas(0,0).getContext("2d")}catch(t){return!1}})()?(t,e)=>new OffscreenCanvas(t,e):(t,e)=>{const n=document.createElement("canvas");return n.width=t,n.height=e,n},o=(()=>{const t=c(0,0).getContext("2d");return e=>{t.font=e;const n=t.measureText("M"),r=t.measureText("x"),l=t.measureText("\xc5\u015ag|"),c=l.fontBoundingBoxAscent,o=l.fontBoundingBoxDescent;if(null!=c&&null!=o)return{height:c+o,ascent:c,descent:o,cap_height:n.actualBoundingBoxAscent,x_height:r.actualBoundingBoxAscent};const s=l.actualBoundingBoxAscent,u=l.actualBoundingBoxDescent;if(null!=s&&null!=u)return{height:s+u,ascent:s,descent:u,cap_height:n.actualBoundingBoxAscent,x_height:r.actualBoundingBoxAscent};(0,a.unreachable)()}})(),s=(()=>{const t=c(0,0).getContext("2d");return(e,n)=>{t.font=n;const r=t.measureText(e),l=r.actualBoundingBoxAscent,c=r.actualBoundingBoxDescent;if(null!=l&&null!=c)return{width:r.width,height:l+c,ascent:l,descent:c};(0,a.unreachable)()}})(),u=(()=>{const t=document.createElement("canvas"),e=t.getContext("2d");let n=-1,r=-1;return(l,a=1)=>{e.font=l;const{width:c}=e.measureText("M"),o=c*a,s=Math.ceil(o),u=Math.ceil(2*o),i=Math.ceil(1.5*o);n<s&&(n=s,t.width=s),r<u&&(r=u,t.height=u),e.save(),e.scale(a,a),e.fillStyle="#f00",e.fillRect(0,0,s,u);const f=t=>{let e=0;for(let n=0;n<=i;n++)for(let r=0;r<s;r++,e+=4)if(255!=t[e])return i-n;return 0};e.font=l,e.fillStyle="#000";for(const t of"xa")e.fillText(t,0,i/a);const{data:h}=e.getImageData(0,0,s,u),g=f(h)/a;for(const t of"ASQ")e.fillText(t,0,i/a);const{data:d}=e.getImageData(0,0,s,u),x=f(d)/a;for(const t of"\xc5\u015agy")e.fillText(t,0,i/a);const{data:m}=e.getImageData(0,0,s,u),B=f(m)/a,w=(t=>{let e=t.length-4;for(let n=u;n>=i;n--)for(let r=0;r<s;r++,e-=4)if(255!=t[e])return n-i;return 0})(m)/a;return e.restore(),{height:B+w,ascent:B,cap_height:x,x_height:g,descent:w}}})(),i=(()=>{const t=document.createElement("canvas"),e=t.getContext("2d");let n=-1,r=-1;return(l,a,c=1)=>{e.font=a;const{width:o}=e.measureText("M"),s=o*c,u=Math.ceil(s),i=Math.ceil(2*s),f=Math.ceil(1.5*s);(n<u||r<i)&&(n=u,t.width=u,r=i,t.height=i),e.save(),e.scale(c,c),e.fillStyle="#f00",e.fillRect(0,0,u,i);e.font=a,e.fillStyle="#000",e.fillText(l,0,f/c);const h=e.measureText(l),{data:g}=e.getImageData(0,0,u,i),d=(t=>{let e=0;for(let n=0;n<=f;n++)for(let r=0;r<u;r++,e+=4)if(255!=t[e])return f-n;return 0})(g)/c,x=(t=>{let e=t.length-4;for(let n=i;n>=f;n--)for(let r=0;r<u;r++,e-=4)if(255!=t[e])return n-f;return 0})(g)/c;return e.restore(),{width:h.width,height:d+x,ascent:d,descent:x}}})(),f=(()=>{try{return o("normal 10px sans-serif"),o}catch(t){return u}})(),h=(()=>{try{return s("A","normal 10px sans-serif"),s}catch(t){return i}})(),g=new Map;function d(t){let e=g.get(t);return null==e&&(e={font:f(t),glyphs:new Map},g.set(t,e)),e.font}n.font_metrics=d,n.glyph_metrics=function(t,e){let n=g.get(e);null==n&&(d(e),n=g.get(e));let r=n.glyphs.get(t);return null==r&&(r=h(t,e),n.glyphs.set(t,r)),r},n.parse_css_font_size=function(t){const e=t.match(/^\s*(\d+(\.\d+)?)(\w+)\s*$/);if(null!=e){const[,t,,n]=e,r=Number(t);if(isFinite(r))return{value:r,unit:n}}return null}},
function _(t,s,r,n,i){n();const{sin:e,cos:a}=Math;class h{constructor(t=1,s=0,r=0,n=1,i=0,e=0){this.a=t,this.b=s,this.c=r,this.d=n,this.e=i,this.f=e}toString(){const{a:t,b:s,c:r,d:n,e:i,f:e}=this;return`matrix(${t}, ${s}, ${r}, ${n}, ${i}, ${e})`}static from_DOMMatrix(t){const{a:s,b:r,c:n,d:i,e,f:a}=t;return new h(s,r,n,i,e,a)}to_DOMMatrix(){const{a:t,b:s,c:r,d:n,e:i,f:e}=this;return new DOMMatrix([t,s,r,n,i,e])}clone(){const{a:t,b:s,c:r,d:n,e:i,f:e}=this;return new h(t,s,r,n,i,e)}get is_identity(){const{a:t,b:s,c:r,d:n,e:i,f:e}=this;return 1==t&&0==s&&0==r&&1==n&&0==i&&0==e}apply_point(t){const[s,r]=this.apply(t.x,t.y);return{x:s,y:r}}apply_rect(t){return{p0:this.apply_point(t.p0),p1:this.apply_point(t.p1),p2:this.apply_point(t.p2),p3:this.apply_point(t.p3)}}apply(t,s){const{a:r,b:n,c:i,d:e,e:a,f:h}=this;return[r*t+i*s+a,n*t+e*s+h]}iv_apply(t,s){const{a:r,b:n,c:i,d:e,e:a,f:h}=this,c=t.length;for(let o=0;o<c;o++){const c=t[o],p=s[o];t[o]=r*c+i*p+a,s[o]=n*c+e*p+h}}transform(t,s,r,n,i,e){const{a,b:h,c,d:o,e:p,f}=this;return this.a=a*t+c*s,this.c=a*r+c*n,this.e=a*i+c*e+p,this.b=h*t+o*s,this.d=h*r+o*n,this.f=h*i+o*e+f,this}translate(t,s){return this.transform(1,0,0,1,t,s)}scale(t,s){return this.transform(t,0,0,s,0,0)}skew(t,s){return this.transform(1,s,t,1,0,0)}rotate(t){const s=e(t),r=a(t);return this.transform(r,s,-s,r,0,0)}rotate_ccw(t){return this.rotate(-t)}translate_x(t){return this.translate(t,0)}translate_y(t){return this.translate(0,t)}flip(){return this.scale(-1,-1)}flip_x(){return this.scale(1,-1)}flip_y(){return this.scale(-1,1)}}r.AffineTransform=h,h.__name__="AffineTransform"},
function _(t,e,i,l,r){l();const a=t(124),o=t(125),n=t(8),h=Math.PI/2,s={above:{parallel:0,normal:-h,horizontal:0,vertical:-h},below:{parallel:0,normal:h,horizontal:0,vertical:h},left:{parallel:-h,normal:0,horizontal:0,vertical:-h},right:{parallel:h,normal:0,horizontal:0,vertical:h}},c={above:{parallel:"bottom",normal:"center",horizontal:"bottom",vertical:"center"},below:{parallel:"top",normal:"center",horizontal:"top",vertical:"center"},left:{parallel:"bottom",normal:"center",horizontal:"center",vertical:"bottom"},right:{parallel:"bottom",normal:"center",horizontal:"center",vertical:"bottom"}},g={above:{parallel:"center",normal:"left",horizontal:"center",vertical:"left"},below:{parallel:"center",normal:"left",horizontal:"center",vertical:"left"},left:{parallel:"center",normal:"right",horizontal:"right",vertical:"center"},right:{parallel:"center",normal:"left",horizontal:"left",vertical:"center"}},_={above:"right",below:"left",left:"right",right:"left"},b={above:"left",below:"right",left:"right",right:"left"};class z{constructor(t){this.side=t}get dimension(){return"above"==this.side||"below"==this.side?0:1}get normals(){switch(this.side){case"above":return[0,-1];case"below":return[0,1];case"left":return[-1,0];case"right":return[1,0]}}get orientation(){return this.is_horizontal?"horizontal":"vertical"}get is_horizontal(){return 0==this.dimension}get is_vertical(){return 1==this.dimension}get_label_text_heuristics(t){const{side:e}=this;return(0,n.isString)(t)?{vertical_align:c[e][t],align:g[e][t]}:{vertical_align:"center",align:(t<0?_:b)[e]}}get_label_angle_heuristic(t){return(0,n.isString)(t)?s[this.side][t]:-t}}i.Panel=z,z.__name__="Panel";class m extends o.ContentLayoutable{constructor(t,e,i=!1){super(),this.panel=t,this.get_size=e,this.rotate=i,this.panel.is_horizontal?this.set_sizing({width_policy:"max",height_policy:"fixed"}):this.set_sizing({width_policy:"fixed",height_policy:"max"})}_content_size(){const{width:t,height:e}=this.get_size();return!this.rotate||this.panel.is_horizontal?new a.Sizeable({width:t,height:e}):new a.Sizeable({width:e,height:t})}has_size_changed(){const{width:t,height:e}=this._content_size();return this.panel.is_horizontal?this.bbox.height!=e:this.bbox.width!=t}}i.SideLayout=m,m.__name__="SideLayout"},
function _(h,t,i,e,w){e();const n=h(21),{min:d,max:s}=Math;class g{constructor(h={}){this.width=null!=h.width?h.width:0,this.height=null!=h.height?h.height:0}bounded_to({width:h,height:t}){return new g({width:this.width==1/0&&null!=h?h:this.width,height:this.height==1/0&&null!=t?t:this.height})}expanded_to({width:h,height:t}){return new g({width:h!=1/0?s(this.width,h):this.width,height:t!=1/0?s(this.height,t):this.height})}expand_to({width:h,height:t}){this.width=s(this.width,h),this.height=s(this.height,t)}narrowed_to({width:h,height:t}){return new g({width:d(this.width,h),height:d(this.height,t)})}narrow_to({width:h,height:t}){this.width=d(this.width,h),this.height=d(this.height,t)}grow_by({left:h,right:t,top:i,bottom:e}){const w=this.width+h+t,n=this.height+i+e;return new g({width:w,height:n})}shrink_by({left:h,right:t,top:i,bottom:e}){const w=s(this.width-h-t,0),n=s(this.height-i-e,0);return new g({width:w,height:n})}map(h,t){return new g({width:h(this.width),height:(null!=t?t:h)(this.height)})}}i.Sizeable=g,g.__name__="Sizeable",i.SizingPolicy=(0,n.Enum)("fixed","fit","min","max")},
function _(i,t,h,e,n){e();const s=i(124),r=i(65),g=i(8),{min:l,max:a,round:_}=Math;class o{constructor(){this.absolute=!1,this._bbox=new r.BBox,this._inner_bbox=new r.BBox,this._dirty=!1,this._handlers=[]}*[Symbol.iterator](){}get bbox(){return this._bbox}get inner_bbox(){return this._inner_bbox}get sizing(){return this._sizing}set visible(i){this._sizing.visible=i,this._dirty=!0}set_sizing(i){var t,h,e,n,s;const r=null!==(t=i.width_policy)&&void 0!==t?t:"fit",g=i.width,l=i.min_width,a=i.max_width,_=null!==(h=i.height_policy)&&void 0!==h?h:"fit",o=i.height,d=i.min_height,u=i.max_height,c=i.aspect,w=null!==(e=i.margin)&&void 0!==e?e:{top:0,right:0,bottom:0,left:0},m=!1!==i.visible,x=null!==(n=i.halign)&&void 0!==n?n:"start",b=null!==(s=i.valign)&&void 0!==s?s:"start";this._sizing={width_policy:r,min_width:l,width:g,max_width:a,height_policy:_,min_height:d,height:o,max_height:u,aspect:c,margin:w,visible:m,halign:x,valign:b,size:{width:g,height:o}},this._init()}_init(){}_set_geometry(i,t){this._bbox=i,this._inner_bbox=t}set_geometry(i,t){const{fixup_geometry:h}=this;null!=h&&([i,t]=h(i,t)),this._set_geometry(i,null!=t?t:i);for(const i of this._handlers)i(this._bbox,this._inner_bbox)}on_resize(i){this._handlers.push(i)}is_width_expanding(){return"max"==this.sizing.width_policy}is_height_expanding(){return"max"==this.sizing.height_policy}apply_aspect(i,{width:t,height:h}){const{aspect:e}=this.sizing;if(null!=e){const{width_policy:n,height_policy:s}=this.sizing,r=(i,t)=>{const h={max:4,fit:3,min:2,fixed:1};return h[i]>h[t]};if("fixed"!=n&&"fixed"!=s)if(n==s){const n=t,s=_(t/e),r=_(h*e),g=h;Math.abs(i.width-n)+Math.abs(i.height-s)<=Math.abs(i.width-r)+Math.abs(i.height-g)?(t=n,h=s):(t=r,h=g)}else r(n,s)?h=_(t/e):t=_(h*e);else"fixed"==n?h=_(t/e):"fixed"==s&&(t=_(h*e))}return{width:t,height:h}}measure(i){if(!this.sizing.visible)return{width:0,height:0};const t=i=>"fixed"==this.sizing.width_policy&&null!=this.sizing.width?this.sizing.width:i,h=i=>"fixed"==this.sizing.height_policy&&null!=this.sizing.height?this.sizing.height:i,e=new s.Sizeable(i).shrink_by(this.sizing.margin).map(t,h),n=this._measure(e),r=this.clip_size(n,e),g=t(r.width),l=h(r.height),a=this.apply_aspect(e,{width:g,height:l});return Object.assign(Object.assign({},n),a)}compute(i={}){const t=this.measure({width:null!=i.width&&this.is_width_expanding()?i.width:1/0,height:null!=i.height&&this.is_height_expanding()?i.height:1/0}),{width:h,height:e}=t,n=new r.BBox({left:0,top:0,width:h,height:e});let s;if(null!=t.inner){const{left:i,top:n,right:g,bottom:l}=t.inner;s=new r.BBox({left:i,top:n,right:h-g,bottom:e-l})}this.set_geometry(n,s)}get xview(){return this.bbox.xview}get yview(){return this.bbox.yview}clip_size(i,t){function h(i,t,h,e){return null==h?h=0:(0,g.isNumber)(h)||(h=Math.round(h.percent*t)),null==e?e=1/0:(0,g.isNumber)(e)||(e=Math.round(e.percent*t)),a(h,l(i,e))}return{width:h(i.width,t.width,this.sizing.min_width,this.sizing.max_width),height:h(i.height,t.height,this.sizing.min_height,this.sizing.max_height)}}has_size_changed(){const{_dirty:i}=this;return this._dirty=!1,i}}h.Layoutable=o,o.__name__="Layoutable";class d extends o{_measure(i){const{width_policy:t,height_policy:h}=this.sizing;return{width:(()=>{const{width:h}=this.sizing;if(i.width==1/0)return null!=h?h:0;switch(t){case"fixed":return null!=h?h:0;case"min":return null!=h?l(i.width,h):0;case"fit":return null!=h?l(i.width,h):i.width;case"max":return null!=h?a(i.width,h):i.width}})(),height:(()=>{const{height:t}=this.sizing;if(i.height==1/0)return null!=t?t:0;switch(h){case"fixed":return null!=t?t:0;case"min":return null!=t?l(i.height,t):0;case"fit":return null!=t?l(i.height,t):i.height;case"max":return null!=t?a(i.height,t):i.height}})()}}}h.LayoutItem=d,d.__name__="LayoutItem";class u extends o{_measure(i){const t=this._content_size(),h=i.bounded_to(this.sizing.size).bounded_to(t);return{width:(()=>{switch(this.sizing.width_policy){case"fixed":return null!=this.sizing.width?this.sizing.width:t.width;case"min":return t.width;case"fit":return h.width;case"max":return Math.max(t.width,h.width)}})(),height:(()=>{switch(this.sizing.height_policy){case"fixed":return null!=this.sizing.height?this.sizing.height:t.height;case"min":return t.height;case"fit":return h.height;case"max":return Math.max(t.height,h.height)}})()}}}h.ContentLayoutable=u,u.__name__="ContentLayoutable"},
function _(e,t,s,a,_){a();const r=e(62),n=e(61),g=e(58),i=e(63),c=e(67),h=e(65),l=e(13),o=e(11);class x{constructor(e,t,s,a,_={},r={},n={},g={}){this.in_x_scale=e,this.in_y_scale=t,this.x_range=s,this.y_range=a,this.extra_x_ranges=_,this.extra_y_ranges=r,this.extra_x_scales=n,this.extra_y_scales=g,this._bbox=new h.BBox,(0,o.assert)(null==e.source_range&&null==e.target_range),(0,o.assert)(null==t.source_range&&null==t.target_range),this._configure_scales()}get bbox(){return this._bbox}_get_ranges(e,t){return new Map((0,l.entries)(Object.assign(Object.assign({},t),{default:e})))}_get_scales(e,t,s,a){var _;const g=new Map((0,l.entries)(Object.assign(Object.assign({},t),{default:e}))),h=new Map;for(const[t,l]of s){if(l instanceof c.FactorRange!=e instanceof r.CategoricalScale)throw new Error(`Range ${l.type} is incompatible is Scale ${e.type}`);e instanceof n.LogScale&&l instanceof i.DataRange1d&&(l.scale_hint="log");const s=(null!==(_=g.get(t))&&void 0!==_?_:e).clone();s.setv({source_range:l,target_range:a}),h.set(t,s)}return h}_configure_frame_ranges(){const{bbox:e}=this;this._x_target=new g.Range1d({start:e.left,end:e.right}),this._y_target=new g.Range1d({start:e.bottom,end:e.top})}_configure_scales(){this._configure_frame_ranges(),this._x_ranges=this._get_ranges(this.x_range,this.extra_x_ranges),this._y_ranges=this._get_ranges(this.y_range,this.extra_y_ranges),this._x_scales=this._get_scales(this.in_x_scale,this.extra_x_scales,this._x_ranges,this._x_target),this._y_scales=this._get_scales(this.in_y_scale,this.extra_y_scales,this._y_ranges,this._y_target)}_update_scales(){this._configure_frame_ranges();for(const[,e]of this._x_scales)e.target_range=this._x_target;for(const[,e]of this._y_scales)e.target_range=this._y_target}set_geometry(e){this._bbox=e,this._update_scales()}get x_target(){return this._x_target}get y_target(){return this._y_target}get x_ranges(){return this._x_ranges}get y_ranges(){return this._y_ranges}get x_scales(){return this._x_scales}get y_scales(){return this._y_scales}get x_scale(){return this._x_scales.get("default")}get y_scale(){return this._y_scales.get("default")}get xscales(){return(0,l.to_object)(this.x_scales)}get yscales(){return(0,l.to_object)(this.y_scales)}}s.CartesianFrame=x,x.__name__="CartesianFrame"},
function _(i,s,x,A,o){A(),o("Axis",i(128).Axis),o("CategoricalAxis",i(140).CategoricalAxis),o("ContinuousAxis",i(143).ContinuousAxis),o("DatetimeAxis",i(144).DatetimeAxis),o("LinearAxis",i(145).LinearAxis),o("LogAxis",i(162).LogAxis),o("MercatorAxis",i(165).MercatorAxis)},
function _(t,e,i,s,a){s();const o=t(1);var l;const n=t(129),_=t(130),r=t(131),h=t(132),c=(0,o.__importStar)(t(48)),b=t(20),u=t(24),m=t(123),d=t(9),x=t(13),f=t(8),g=t(120),p=t(67),v=t(133),w=t(113),j=t(11),k=t(8),y=t(134),{abs:z}=Math;class M extends n.GuideRendererView{constructor(){super(...arguments),this._axis_label_view=null,this._major_label_views=new Map}async lazy_initialize(){await super.lazy_initialize(),await this._init_axis_label(),await this._init_major_labels()}async _init_axis_label(){const{axis_label:t}=this.model;if(null!=t){const e=(0,k.isString)(t)?(0,y.parse_delimited_string)(t):t;this._axis_label_view=await(0,w.build_view)(e,{parent:this})}else this._axis_label_view=null}async _init_major_labels(){const{major_label_overrides:t}=this.model;for(const[e,i]of(0,x.entries)(t)){const t=(0,k.isString)(i)?(0,y.parse_delimited_string)(i):i;this._major_label_views.set(e,await(0,w.build_view)(t,{parent:this}))}}update_layout(){this.layout=new m.SideLayout(this.panel,(()=>this.get_size()),!0),this.layout.on_resize((()=>this._coordinates=void 0))}get_size(){const{visible:t,fixed_location:e}=this.model;if(t&&null==e&&this.is_renderable){const{extents:t}=this;return{width:0,height:Math.round(t.tick+t.tick_label+t.axis_label)}}return{width:0,height:0}}get is_renderable(){const[t,e]=this.ranges;return t.is_valid&&e.is_valid}_render(){var t;if(!this.is_renderable)return;const{tick_coords:e,extents:i}=this,s=this.layer.ctx;s.save(),this._draw_rule(s,i),this._draw_major_ticks(s,i,e),this._draw_minor_ticks(s,i,e),this._draw_major_labels(s,i,e),this._draw_axis_label(s,i,e),null===(t=this._paint)||void 0===t||t.call(this,s,i,e),s.restore()}connect_signals(){super.connect_signals();const{axis_label:t,major_label_overrides:e}=this.model.properties;this.on_change(t,(async()=>{var t;null===(t=this._axis_label_view)||void 0===t||t.remove(),await this._init_axis_label()})),this.on_change(e,(async()=>{for(const t of this._major_label_views.values())t.remove();await this._init_major_labels()})),this.connect(this.model.change,(()=>this.plot_view.request_layout()))}get needs_clip(){return null!=this.model.fixed_location}_draw_rule(t,e){if(!this.visuals.axis_line.doit)return;const[i,s]=this.rule_coords,[a,o]=this.coordinates.map_to_screen(i,s),[l,n]=this.normals,[_,r]=this.offsets;this.visuals.axis_line.set_value(t),t.beginPath();for(let e=0;e<a.length;e++){const i=Math.round(a[e]+l*_),s=Math.round(o[e]+n*r);t.lineTo(i,s)}t.stroke()}_draw_major_ticks(t,e,i){const s=this.model.major_tick_in,a=this.model.major_tick_out,o=this.visuals.major_tick_line;this._draw_ticks(t,i.major,s,a,o)}_draw_minor_ticks(t,e,i){const s=this.model.minor_tick_in,a=this.model.minor_tick_out,o=this.visuals.minor_tick_line;this._draw_ticks(t,i.minor,s,a,o)}_draw_major_labels(t,e,i){const s=i.major,a=this.compute_labels(s[this.dimension]),o=this.model.major_label_orientation,l=e.tick+this.model.major_label_standoff,n=this.visuals.major_label_text;this._draw_oriented_labels(t,a,s,o,this.panel.side,l,n)}_axis_label_extent(){if(null==this._axis_label_view)return 0;const t=this._axis_label_view.graphics();t.visuals=this.visuals.axis_label_text.values(),t.angle=this.panel.get_label_angle_heuristic("parallel"),(0,f.isNumber)(this.plot_view.base_font_size)&&(t.base_font_size=this.plot_view.base_font_size);const e=t.size(),i=0==this.dimension?e.height:e.width,s=this.model.axis_label_standoff;return i>0?s+i+3:0}_draw_axis_label(t,e,i){if(null==this._axis_label_view||null!=this.model.fixed_location)return;const[s,a]=(()=>{const{bbox:t}=this.layout;switch(this.panel.side){case"above":return[t.hcenter,t.bottom];case"below":return[t.hcenter,t.top];case"left":return[t.right,t.vcenter];case"right":return[t.left,t.vcenter]}})(),[o,l]=this.normals,n=e.tick+e.tick_label+this.model.axis_label_standoff,{vertical_align:_,align:r}=this.panel.get_label_text_heuristics("parallel"),h={sx:s+o*n,sy:a+l*n,x_anchor:r,y_anchor:_},c=this._axis_label_view.graphics();c.visuals=this.visuals.axis_label_text.values(),c.angle=this.panel.get_label_angle_heuristic("parallel"),this.plot_view.base_font_size&&(c.base_font_size=this.plot_view.base_font_size),c.position=h,c.align=r,c.paint(t)}_draw_ticks(t,e,i,s,a){if(!a.doit)return;const[o,l]=e,[n,_]=this.coordinates.map_to_screen(o,l),[r,h]=this.normals,[c,b]=this.offsets,[u,m]=[r*(c-i),h*(b-i)],[d,x]=[r*(c+s),h*(b+s)];a.set_value(t),t.beginPath();for(let e=0;e<n.length;e++){const i=Math.round(n[e]+d),s=Math.round(_[e]+x),a=Math.round(n[e]+u),o=Math.round(_[e]+m);t.moveTo(i,s),t.lineTo(a,o)}t.stroke()}_draw_oriented_labels(t,e,i,s,a,o,l){if(!l.doit||0==e.length)return;const[n,_]=i,[r,h]=this.coordinates.map_to_screen(n,_),[c,b]=this.offsets,[m,d]=this.normals,x=m*(c+o),f=d*(b+o),{vertical_align:p,align:v}=this.panel.get_label_text_heuristics(s),w=this.panel.get_label_angle_heuristic(s);e.visuals=l.values(),e.angle=w,e.base_font_size=this.plot_view.base_font_size;for(let t=0;t<e.length;t++){const i=e.items[t];i.position={sx:r[t]+x,sy:h[t]+f,x_anchor:v,y_anchor:p},i instanceof g.TextBox&&(i.align=v)}const j=e.length,k=u.Indices.all_set(j),{items:y}=e,z=y.map((t=>t.bbox())),M=(()=>{const[t]=this.ranges;return t.is_reversed?0==this.dimension?(t,e)=>z[t].left-z[e].right:(t,e)=>z[e].top-z[t].bottom:0==this.dimension?(t,e)=>z[e].left-z[t].right:(t,e)=>z[t].top-z[e].bottom})(),{major_label_policy:O}=this.model,T=O.filter(k,z,M),A=[...T.ones()];if(0!=A.length){const t=this.parent.canvas_view.bbox,e=e=>{const i=z[e];if(i.left<0){const t=-i.left,{position:s}=y[e];y[e].position=Object.assign(Object.assign({},s),{sx:s.sx+t})}else if(i.right>t.width){const s=i.right-t.width,{position:a}=y[e];y[e].position=Object.assign(Object.assign({},a),{sx:a.sx-s})}},i=e=>{const i=z[e];if(i.top<0){const t=-i.top,{position:s}=y[e];y[e].position=Object.assign(Object.assign({},s),{sy:s.sy+t})}else if(i.bottom>t.height){const s=i.bottom-t.height,{position:a}=y[e];y[e].position=Object.assign(Object.assign({},a),{sy:a.sy-s})}},s=A[0],a=A[A.length-1];0==this.dimension?(e(s),e(a)):(i(s),i(a))}for(const e of T){y[e].paint(t)}}_tick_extent(){return this.model.major_tick_out}_tick_label_extents(){const t=this.tick_coords.major,e=this.compute_labels(t[this.dimension]),i=this.model.major_label_orientation,s=this.model.major_label_standoff,a=this.visuals.major_label_text;return[this._oriented_labels_extent(e,i,s,a)]}get extents(){const t=this._tick_label_extents();return{tick:this._tick_extent(),tick_labels:t,tick_label:(0,d.sum)(t),axis_label:this._axis_label_extent()}}_oriented_labels_extent(t,e,i,s){if(0==t.length||!s.doit)return 0;const a=this.panel.get_label_angle_heuristic(e);t.visuals=s.values(),t.angle=a,t.base_font_size=this.plot_view.base_font_size;const o=t.max_size(),l=0==this.dimension?o.height:o.width;return l>0?i+l+3:0}get normals(){return this.panel.normals}get dimension(){return this.panel.dimension}compute_labels(t){const e=this.model.formatter.format_graphics(t,this),{_major_label_views:i}=this,s=new Set;for(let a=0;a<t.length;a++){const o=i.get(t[a].toString());null!=o&&(s.add(o),e[a]=o.graphics())}for(const t of this._major_label_views.values())s.has(t)||(t._has_finished=!0);return new g.GraphicsBoxes(e)}get offsets(){if(null!=this.model.fixed_location)return[0,0];const{frame:t}=this.plot_view;let[e,i]=[0,0];switch(this.panel.side){case"below":i=z(this.layout.bbox.top-t.bbox.bottom);break;case"above":i=z(this.layout.bbox.bottom-t.bbox.top);break;case"right":e=z(this.layout.bbox.left-t.bbox.right);break;case"left":e=z(this.layout.bbox.right-t.bbox.left)}return[e,i]}get ranges(){const t=this.dimension,e=(t+1)%2,{ranges:i}=this.coordinates;return[i[t],i[e]]}get computed_bounds(){const[t]=this.ranges,e=this.model.bounds,i=[t.min,t.max];if("auto"==e)return[t.min,t.max];{let t,s;const[a,o]=e,[l,n]=i,{min:_,max:r}=Math;return z(a-o)>z(l-n)?(t=r(_(a,o),l),s=_(r(a,o),n)):(t=_(a,o),s=r(a,o)),[t,s]}}get rule_coords(){const t=this.dimension,e=(t+1)%2,[i]=this.ranges,[s,a]=this.computed_bounds,o=[new Array(2),new Array(2)];return o[t][0]=Math.max(s,i.min),o[t][1]=Math.min(a,i.max),o[t][0]>o[t][1]&&(o[t][0]=o[t][1]=NaN),o[e][0]=this.loc,o[e][1]=this.loc,o}get tick_coords(){const t=this.dimension,e=(t+1)%2,[i]=this.ranges,[s,a]=this.computed_bounds,o=this.model.ticker.get_ticks(s,a,i,this.loc),l=o.major,n=o.minor,_=[[],[]],r=[[],[]],[h,c]=[i.min,i.max];for(let i=0;i<l.length;i++)l[i]<h||l[i]>c||(_[t].push(l[i]),_[e].push(this.loc));for(let i=0;i<n.length;i++)n[i]<h||n[i]>c||(r[t].push(n[i]),r[e].push(this.loc));return{major:_,minor:r}}get loc(){const{fixed_location:t}=this.model;if(null!=t){if((0,f.isNumber)(t))return t;const[,e]=this.ranges;if(e instanceof p.FactorRange)return e.synthetic(t);(0,j.unreachable)()}const[,e]=this.ranges;switch(this.panel.side){case"left":case"below":return e.start;case"right":case"above":return e.end}}serializable_state(){return Object.assign(Object.assign({},super.serializable_state()),{bbox:this.layout.bbox.box})}remove(){var t;null===(t=this._axis_label_view)||void 0===t||t.remove();for(const t of this._major_label_views.values())t.remove();super.remove()}has_finished(){if(!super.has_finished())return!1;if(null!=this._axis_label_view&&!this._axis_label_view.has_finished())return!1;for(const t of this._major_label_views.values())if(!t.has_finished())return!1;return!0}}i.AxisView=M,M.__name__="AxisView";class O extends n.GuideRenderer{constructor(t){super(t)}}i.Axis=O,l=O,O.__name__="Axis",l.prototype.default_view=M,l.mixins([["axis_",c.Line],["major_tick_",c.Line],["minor_tick_",c.Line],["major_label_",c.Text],["axis_label_",c.Text]]),l.define((({Any:t,Int:e,Number:i,String:s,Ref:a,Dict:o,Tuple:l,Or:n,Nullable:c,Auto:u})=>({bounds:[n(l(i,i),u),"auto"],ticker:[a(_.Ticker)],formatter:[a(r.TickFormatter)],axis_label:[c(n(s,a(v.BaseText))),null],axis_label_standoff:[e,5],major_label_standoff:[e,5],major_label_orientation:[n(b.TickLabelOrientation,i),"horizontal"],major_label_overrides:[o(n(s,a(v.BaseText))),{}],major_label_policy:[a(h.LabelingPolicy),()=>new h.AllLabels],major_tick_in:[i,2],major_tick_out:[i,6],minor_tick_in:[i,0],minor_tick_out:[i,4],fixed_location:[c(n(i,t)),null]}))),l.override({axis_line_color:"black",major_tick_line_color:"black",minor_tick_line_color:"black",major_label_text_font_size:"11px",major_label_text_align:"center",major_label_text_baseline:"alphabetic",axis_label_text_font_size:"13px",axis_label_text_font_style:"italic"})},
function _(e,r,d,n,i){var s;n();const _=e(41);class u extends _.RendererView{}d.GuideRendererView=u,u.__name__="GuideRendererView";class c extends _.Renderer{constructor(e){super(e)}}d.GuideRenderer=c,s=c,c.__name__="GuideRenderer",s.override({level:"guide"})},
function _(c,e,n,s,o){s();const r=c(53);class t extends r.Model{constructor(c){super(c)}}n.Ticker=t,t.__name__="Ticker"},
function _(t,o,r,e,c){e();const n=t(53),a=t(120);class m extends n.Model{constructor(t){super(t)}format_graphics(t,o){return this.doFormat(t,o).map((t=>new a.TextBox({text:t})))}compute(t,o){return this.doFormat([t],null!=o?o:{loc:0})[0]}v_compute(t,o){return this.doFormat(t,null!=o?o:{loc:0})}}r.TickFormatter=m,m.__name__="TickFormatter"},
function _(e,n,s,t,i){var c,r;t();const l=e(53),o=e(13),a=e(34),u=e(8),d=e(24);class _ extends l.Model{constructor(e){super(e)}}s.LabelingPolicy=_,_.__name__="LabelingPolicy";class f extends _{constructor(e){super(e)}filter(e,n,s){return e}}s.AllLabels=f,f.__name__="AllLabels";class m extends _{constructor(e){super(e)}filter(e,n,s){const{min_distance:t}=this;let i=null;for(const n of e)null!=i&&s(i,n)<t?e.unset(n):i=n;return e}}s.NoOverlap=m,c=m,m.__name__="NoOverlap",c.define((({Number:e})=>({min_distance:[e,5]})));class b extends _{constructor(e){super(e)}get names(){return(0,o.keys)(this.args)}get values(){return(0,o.values)(this.args)}get func(){const e=(0,a.use_strict)(this.code);return new d.GeneratorFunction("indices","bboxes","distance",...this.names,e)}filter(e,n,s){const t=Object.create(null),i=this.func.call(t,e,n,s,...this.values);let c=i.next();if(c.done&&void 0!==c.value){const{value:n}=c;return n instanceof d.Indices?n:void 0===n?e:(0,u.isIterable)(n)?d.Indices.from_indices(e.size,n):d.Indices.all_unset(e.size)}{const n=[];do{n.push(c.value),c=i.next()}while(!c.done);return d.Indices.from_indices(e.size,n)}}}s.CustomLabelingPolicy=b,r=b,b.__name__="CustomLabelingPolicy",r.define((({Unknown:e,String:n,Dict:s})=>({args:[s(e),{}],code:[n,""]})))},
function _(e,s,t,n,a){var _;n();const x=e(53),c=e(42);class i extends c.View{}t.BaseTextView=i,i.__name__="BaseTextView";class o extends x.Model{constructor(e){super(e)}}t.BaseText=o,_=o,o.__name__="BaseText",_.define((({String:e})=>({text:[e]})))},
function _(n,e,t,i,r){i();const s=n(135),l=n(139),d=[{start:"$$",end:"$$",inline:!1},{start:"\\[",end:"\\]",inline:!1},{start:"\\(",end:"\\)",inline:!0}];t.parse_delimited_string=function(n){for(const e of d){const t=n.indexOf(e.start),i=t+e.start.length;if(0==t){const t=n.indexOf(e.end,i),r=t;if(t==n.length-e.end.length)return new s.TeX({text:n.slice(i,r),inline:e.inline});break}}return new l.PlainText({text:n})}},
function _(t,e,s,i,n){var o,r,a;i();const h=t(8),_=t(136),l=t(22),c=t(120),d=t(121),u=t(122),g=t(65),p=t(133),x=t(137);class m extends p.BaseTextView{constructor(){super(...arguments),this._position={sx:0,sy:0},this.align="left",this._x_anchor="left",this._y_anchor="center",this._base_font_size=13,this.font_size_scale=1,this.svg_image=null}graphics(){return this}infer_text_height(){return"ascent_descent"}set base_font_size(t){null!=t&&(this._base_font_size=t)}get base_font_size(){return this._base_font_size}get has_image_loaded(){return null!=this.svg_image}_rect(){const{width:t,height:e}=this._size(),{x:s,y:i}=this._computed_position();return new g.BBox({x:s,y:i,width:t,height:e}).rect}set position(t){this._position=t}get position(){return this._position}get text(){return this.model.text}get provider(){return x.default_provider}async lazy_initialize(){await super.lazy_initialize(),"not_started"==this.provider.status&&await this.provider.fetch(),"not_started"!=this.provider.status&&"loading"!=this.provider.status||this.provider.ready.connect((()=>this.load_image())),"loaded"==this.provider.status&&await this.load_image()}connect_signals(){super.connect_signals(),this.on_change(this.model.properties.text,(()=>this.load_image()))}set visuals(t){const e=t.color,s=t.alpha,i=t.font_style;let n=t.font_size;const o=t.font,{font_size_scale:r,_base_font_size:a}=this,h=(0,d.parse_css_font_size)(n);if(null!=h){let{value:t,unit:e}=h;t*=r,"em"==e&&a&&(t*=a,e="px"),n=`${t}${e}`}const _=`${i} ${n} ${o}`;this.font=_,this.color=(0,l.color2css)(e,s)}_computed_position(){const{width:t,height:e}=this._size(),{sx:s,sy:i,x_anchor:n=this._x_anchor,y_anchor:o=this._y_anchor}=this.position;return{x:s-(()=>{if((0,h.isNumber)(n))return n*t;switch(n){case"left":return 0;case"center":return.5*t;case"right":return t}})(),y:i-(()=>{if((0,h.isNumber)(o))return o*e;switch(o){case"top":return 0;case"center":return.5*e;case"bottom":return e;case"baseline":return.5*e}})()}}size(){const{width:t,height:e}=this._size(),{angle:s}=this;if(s){const i=Math.cos(Math.abs(s)),n=Math.sin(Math.abs(s));return{width:Math.abs(t*i+e*n),height:Math.abs(t*n+e*i)}}return{width:t,height:e}}get_text_dimensions(){return{width:(0,c.text_width)(this.model.text,this.font),height:(0,d.font_metrics)(this.font).height}}get_image_dimensions(){var t,e,s,i;const n=parseFloat(null!==(e=null===(t=this.svg_element.getAttribute("height"))||void 0===t?void 0:t.replace(/([A-z])/g,""))&&void 0!==e?e:"0"),o=parseFloat(null!==(i=null===(s=this.svg_element.getAttribute("width"))||void 0===s?void 0:s.replace(/([A-z])/g,""))&&void 0!==i?i:"0");return{width:(0,d.font_metrics)(this.font).x_height*o,height:(0,d.font_metrics)(this.font).x_height*n}}_size(){return this.has_image_loaded?this.get_image_dimensions():this.get_text_dimensions()}bbox(){const{p0:t,p1:e,p2:s,p3:i}=this.rect(),n=Math.min(t.x,e.x,s.x,i.x),o=Math.min(t.y,e.y,s.y,i.y),r=Math.max(t.x,e.x,s.x,i.x),a=Math.max(t.y,e.y,s.y,i.y);return new g.BBox({left:n,right:r,top:o,bottom:a})}rect(){const t=this._rect(),{angle:e}=this;if(e){const{sx:s,sy:i}=this.position,n=new u.AffineTransform;return n.translate(s,i),n.rotate(e),n.translate(-s,-i),n.apply_rect(t)}return t}paint_rect(t){const{p0:e,p1:s,p2:i,p3:n}=this.rect();t.save(),t.strokeStyle="red",t.lineWidth=1,t.beginPath();const{round:o}=Math;t.moveTo(o(e.x),o(e.y)),t.lineTo(o(s.x),o(s.y)),t.lineTo(o(i.x),o(i.y)),t.lineTo(o(n.x),o(n.y)),t.closePath(),t.stroke(),t.restore()}paint_bbox(t){const{x:e,y:s,width:i,height:n}=this.bbox();t.save(),t.strokeStyle="blue",t.lineWidth=1,t.beginPath();const{round:o}=Math;t.moveTo(o(e),o(s)),t.lineTo(o(e),o(s+n)),t.lineTo(o(e+i),o(s+n)),t.lineTo(o(e+i),o(s)),t.closePath(),t.stroke(),t.restore()}async load_image(){if(null==this.provider.MathJax)return null;const t=this._process_text(this.model.text);if(null==t)return this._has_finished=!0,null;const e=t.children[0];this.svg_element=e,e.setAttribute("font",this.font),e.setAttribute("stroke",this.color);const s=e.outerHTML,i=new Blob([s],{type:"image/svg+xml"}),n=URL.createObjectURL(i);try{this.svg_image=await(0,_.load_image)(n)}finally{URL.revokeObjectURL(n)}return this.parent.request_layout(),this.svg_image}paint(t){t.save();const{sx:e,sy:s}=this.position;this.angle&&(t.translate(e,s),t.rotate(this.angle),t.translate(-e,-s));const{x:i,y:n}=this._computed_position();if(null!=this.svg_image){const{width:e,height:s}=this.get_image_dimensions();t.drawImage(this.svg_image,i,n,e,s)}else t.fillStyle=this.color,t.font=this.font,t.textAlign="left",t.textBaseline="alphabetic",t.fillText(this.model.text,i,n+(0,d.font_metrics)(this.font).ascent);t.restore(),this._has_finished||"failed"!=this.provider.status&&!this.has_image_loaded||(this._has_finished=!0,this.parent.notify_finished_after_paint())}}s.MathTextView=m,m.__name__="MathTextView";class f extends p.BaseText{constructor(t){super(t)}}s.MathText=f,f.__name__="MathText";class v extends m{_process_text(t){}}s.AsciiView=v,v.__name__="AsciiView";class y extends f{constructor(t){super(t)}}s.Ascii=y,o=y,y.__name__="Ascii",o.prototype.default_view=v;class w extends m{_process_text(t){var e;return null===(e=this.provider.MathJax)||void 0===e?void 0:e.mathml2svg(t.trim())}}s.MathMLView=w,w.__name__="MathMLView";class b extends f{constructor(t){super(t)}}s.MathML=b,r=b,b.__name__="MathML",r.prototype.default_view=w;class M extends m{_process_text(t){var e;return null===(e=this.provider.MathJax)||void 0===e?void 0:e.tex2svg(t,void 0,this.model.macros)}}s.TeXView=M,M.__name__="TeXView";class T extends f{constructor(t){super(t)}}s.TeX=T,a=T,T.__name__="TeX",a.prototype.default_view=M,a.define((({Boolean:t,Number:e,String:s,Dict:i,Tuple:n,Or:o})=>({macros:[i(o(s,n(s,e))),{}],inline:[t,!1]})))},
function _(i,e,t,s,o){s();const a=i(19);t.load_image=async function(i,e){return new n(i,e).promise};class n{constructor(i,e={}){this._image=new Image,this._finished=!1;const{attempts:t=1,timeout:s=1}=e;this.promise=new Promise(((o,n)=>{this._image.crossOrigin="anonymous";let r=0;this._image.onerror=()=>{if(++r==t){const s=`unable to load ${i} image after ${t} attempts`;if(a.logger.warn(s),null==this._image.crossOrigin)return void(null!=e.failed&&e.failed());a.logger.warn(`attempting to load ${i} without a cross origin policy`),this._image.crossOrigin=null,r=0}setTimeout((()=>this._image.src=i),s)},this._image.onload=()=>{this._finished=!0,null!=e.loaded&&e.loaded(this._image),o(this._image)},this._image.src=i}))}get finished(){return this._finished}get image(){if(this._finished)return this._image;throw new Error("not loaded yet")}}t.ImageLoader=n,n.__name__="ImageLoader"},
function _(t,e,a,s,n){var r=this&&this.__createBinding||(Object.create?function(t,e,a,s){void 0===s&&(s=a),Object.defineProperty(t,s,{enumerable:!0,get:function(){return e[a]}})}:function(t,e,a,s){void 0===s&&(s=a),t[s]=e[a]}),i=this&&this.__setModuleDefault||(Object.create?function(t,e){Object.defineProperty(t,"default",{enumerable:!0,value:e})}:function(t,e){t.default=e}),d=this&&this.__importStar||function(t){if(t&&t.__esModule)return t;var e={};if(null!=t)for(var a in t)"default"!==a&&Object.prototype.hasOwnProperty.call(t,a)&&r(e,t,a);return i(e,t),e};s();const o=t(15),u=t(138);class c{constructor(){this.ready=new o.Signal0(this,"ready"),this.status="not_started"}}a.MathJaxProvider=c,c.__name__="MathJaxProvider";class h extends c{get MathJax(){return null}async fetch(){this.status="failed"}}a.NoProvider=h,h.__name__="NoProvider";class l extends c{get MathJax(){return"undefined"!=typeof MathJax?MathJax:null}async fetch(){const t=document.createElement("script");t.src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-svg.js",t.onload=()=>{this.status="loaded",this.ready.emit()},t.onerror=()=>{this.status="failed"},this.status="loading",document.head.appendChild(t)}}a.CDNProvider=l,l.__name__="CDNProvider";class _ extends c{get MathJax(){return this._mathjax}async fetch(){this.status="loading";try{const e=await(0,u.load_module)(Promise.resolve().then((()=>d(t(519)))));this._mathjax=e,this.status="loaded",this.ready.emit()}catch(t){this.status="failed"}}}a.BundleProvider=_,_.__name__="BundleProvider",a.default_provider=new _},
function _(n,r,o,t,c){t(),o.load_module=async function(n){try{return await n}catch(n){if((r=n)instanceof Error&&"code"in r&&"MODULE_NOT_FOUND"===n.code)return null;throw n}var r}},
function _(e,t,i,n,s){var a;n();const x=e(133),_=e(120);class l extends x.BaseTextView{initialize(){super.initialize(),this._has_finished=!0}graphics(){return new _.TextBox({text:this.model.text})}}i.PlainTextView=l,l.__name__="PlainTextView";class r extends x.BaseText{constructor(e){super(e)}}i.PlainText=r,a=r,r.__name__="PlainText",a.prototype.default_view=l},
function _(t,s,o,e,i){e();const r=t(1);var a;const l=t(128),_=t(141),n=t(142),p=(0,r.__importStar)(t(48)),c=t(20),h=t(120),m=t(8);class u extends l.AxisView{_paint(t,s,o){this._draw_group_separators(t,s,o)}_draw_group_separators(t,s,o){const[e]=this.ranges,[i,r]=this.computed_bounds;if(!e.tops||e.tops.length<2||!this.visuals.separator_line.doit)return;const a=this.dimension,l=(a+1)%2,_=[[],[]];let n=0;for(let t=0;t<e.tops.length-1;t++){let s,o;for(let i=n;i<e.factors.length;i++)if(e.factors[i][0]==e.tops[t+1]){[s,o]=[e.factors[i-1],e.factors[i]],n=i;break}const p=(e.synthetic(s)+e.synthetic(o))/2;p>i&&p<r&&(_[a].push(p),_[l].push(this.loc))}const p=this.extents.tick_label;this._draw_ticks(t,_,-3,p-6,this.visuals.separator_line)}_draw_major_labels(t,s,o){const e=this._get_factor_info();let i=s.tick+this.model.major_label_standoff;for(let o=0;o<e.length;o++){const[r,a,l,_]=e[o];this._draw_oriented_labels(t,r,a,l,this.panel.side,i,_),i+=s.tick_labels[o]}}_tick_label_extents(){const t=this._get_factor_info(),s=[];for(const[o,,e,i]of t){const t=this._oriented_labels_extent(o,e,this.model.major_label_standoff,i);s.push(t)}return s}_get_factor_info(){const[t]=this.ranges,[s,o]=this.computed_bounds,e=this.loc,i=this.model.ticker.get_ticks(s,o,t,e),r=this.tick_coords,a=[],l=t=>new h.GraphicsBoxes(t.map((t=>(0,m.isString)(t)?new h.TextBox({text:t}):t))),_=t=>l(this.model.formatter.doFormat(t,this));if(1==t.levels){const t=_(i.major);a.push([t,r.major,this.model.major_label_orientation,this.visuals.major_label_text])}else if(2==t.levels){const t=_(i.major.map((t=>t[1])));a.push([t,r.major,this.model.major_label_orientation,this.visuals.major_label_text]),a.push([l(i.tops),r.tops,this.model.group_label_orientation,this.visuals.group_text])}else if(3==t.levels){const t=_(i.major.map((t=>t[2]))),s=i.mids.map((t=>t[1]));a.push([t,r.major,this.model.major_label_orientation,this.visuals.major_label_text]),a.push([l(s),r.mids,this.model.subgroup_label_orientation,this.visuals.subgroup_text]),a.push([l(i.tops),r.tops,this.model.group_label_orientation,this.visuals.group_text])}return a}get tick_coords(){const t=this.dimension,s=(t+1)%2,[o]=this.ranges,[e,i]=this.computed_bounds,r=this.model.ticker.get_ticks(e,i,o,this.loc),a={major:[[],[]],mids:[[],[]],tops:[[],[]],minor:[[],[]]};return a.major[t]=r.major,a.major[s]=r.major.map((()=>this.loc)),3==o.levels&&(a.mids[t]=r.mids,a.mids[s]=r.mids.map((()=>this.loc))),o.levels>1&&(a.tops[t]=r.tops,a.tops[s]=r.tops.map((()=>this.loc))),a}}o.CategoricalAxisView=u,u.__name__="CategoricalAxisView";class d extends l.Axis{constructor(t){super(t)}}o.CategoricalAxis=d,a=d,d.__name__="CategoricalAxis",a.prototype.default_view=u,a.mixins([["separator_",p.Line],["group_",p.Text],["subgroup_",p.Text]]),a.define((({Number:t,Or:s})=>({group_label_orientation:[s(c.TickLabelOrientation,t),"parallel"],subgroup_label_orientation:[s(c.TickLabelOrientation,t),"parallel"]}))),a.override({ticker:()=>new _.CategoricalTicker,formatter:()=>new n.CategoricalTickFormatter,separator_line_color:"lightgrey",separator_line_width:2,group_text_font_style:"bold",group_text_font_size:"11px",group_text_color:"grey",subgroup_text_font_style:"bold",subgroup_text_font_size:"11px"})},
function _(t,c,o,s,e){s();const r=t(130);class i extends r.Ticker{constructor(t){super(t)}get_ticks(t,c,o,s){var e,r;return{major:this._collect(o.factors,o,t,c),minor:[],tops:this._collect(null!==(e=o.tops)&&void 0!==e?e:[],o,t,c),mids:this._collect(null!==(r=o.mids)&&void 0!==r?r:[],o,t,c)}}_collect(t,c,o,s){const e=[];for(const r of t){const t=c.synthetic(r);t>o&&t<s&&e.push(r)}return e}}o.CategoricalTicker=i,i.__name__="CategoricalTicker"},
function _(t,r,o,c,a){c();const e=t(131),n=t(9);class i extends e.TickFormatter{constructor(t){super(t)}doFormat(t,r){return(0,n.copy)(t)}}o.CategoricalTickFormatter=i,i.__name__="CategoricalTickFormatter"},
function _(s,n,i,o,u){o();const e=s(128);class t extends e.AxisView{}i.ContinuousAxisView=t,t.__name__="ContinuousAxisView";class _ extends e.Axis{constructor(s){super(s)}}i.ContinuousAxis=_,_.__name__="ContinuousAxis"},
function _(e,t,i,a,r){var s;a();const n=e(145),m=e(150),_=e(155);class c extends n.LinearAxisView{}i.DatetimeAxisView=c,c.__name__="DatetimeAxisView";class o extends n.LinearAxis{constructor(e){super(e)}}i.DatetimeAxis=o,s=o,o.__name__="DatetimeAxis",s.prototype.default_view=c,s.override({ticker:()=>new _.DatetimeTicker,formatter:()=>new m.DatetimeTickFormatter})},
function _(e,i,s,n,r){var t;n();const a=e(143),o=e(146),c=e(147);class _ extends a.ContinuousAxisView{}s.LinearAxisView=_,_.__name__="LinearAxisView";class u extends a.ContinuousAxis{constructor(e){super(e)}}s.LinearAxis=u,t=u,u.__name__="LinearAxis",t.prototype.default_view=_,t.override({ticker:()=>new c.BasicTicker,formatter:()=>new o.BasicTickFormatter})},
function _(i,t,e,n,o){var r;n();const s=i(131),c=i(34);function _(i){let t="";for(const e of i)t+="-"==e?"\u2212":e;return t}e.unicode_replace=_;class a extends s.TickFormatter{constructor(i){super(i),this.last_precision=3}get scientific_limit_low(){return 10**this.power_limit_low}get scientific_limit_high(){return 10**this.power_limit_high}_need_sci(i){if(!this.use_scientific)return!1;const{scientific_limit_high:t}=this,{scientific_limit_low:e}=this,n=i.length<2?0:Math.abs(i[1]-i[0])/1e4;for(const o of i){const i=Math.abs(o);if(!(i<=n)&&(i>=t||i<=e))return!0}return!1}_format_with_precision(i,t,e){return t?i.map((i=>_(i.toExponential(e)))):i.map((i=>_((0,c.to_fixed)(i,e))))}_auto_precision(i,t){const e=new Array(i.length),n=this.last_precision<=15;i:for(let o=this.last_precision;n?o<=15:o>=1;n?o++:o--){if(t){e[0]=i[0].toExponential(o);for(let t=1;t<i.length;t++)if(e[t]==e[t-1])continue i;this.last_precision=o;break}e[0]=(0,c.to_fixed)(i[0],o);for(let t=1;t<i.length;t++)if(e[t]=(0,c.to_fixed)(i[t],o),e[t]==e[t-1])continue i;this.last_precision=o;break}return this.last_precision}doFormat(i,t){if(0==i.length)return[];const e=this._need_sci(i),n="auto"==this.precision?this._auto_precision(i,e):this.precision;return this._format_with_precision(i,e,n)}}e.BasicTickFormatter=a,r=a,a.__name__="BasicTickFormatter",r.define((({Boolean:i,Int:t,Auto:e,Or:n})=>({precision:[n(t,e),"auto"],use_scientific:[i,!0],power_limit_high:[t,5],power_limit_low:[t,-3]})))},
function _(c,e,s,i,n){i();const r=c(148);class t extends r.AdaptiveTicker{constructor(c){super(c)}}s.BasicTicker=t,t.__name__="BasicTicker"},
function _(t,i,a,s,e){var n;s();const r=t(149),_=t(9),l=t(10);class h extends r.ContinuousTicker{constructor(t){super(t)}get_min_interval(){return this.min_interval}get_max_interval(){var t;return null!==(t=this.max_interval)&&void 0!==t?t:1/0}initialize(){super.initialize();const t=(0,_.nth)(this.mantissas,-1)/this.base,i=(0,_.nth)(this.mantissas,0)*this.base;this.extended_mantissas=[t,...this.mantissas,i],this.base_factor=0===this.get_min_interval()?1:this.get_min_interval()}get_interval(t,i,a){const s=i-t,e=this.get_ideal_interval(t,i,a),n=Math.floor((0,l.log)(e/this.base_factor,this.base)),r=this.base**n*this.base_factor,h=this.extended_mantissas,m=h.map((t=>Math.abs(a-s/(t*r)))),v=h[(0,_.argmin)(m)]*r;return(0,l.clamp)(v,this.get_min_interval(),this.get_max_interval())}}a.AdaptiveTicker=h,n=h,h.__name__="AdaptiveTicker",n.define((({Number:t,Array:i,Nullable:a})=>({base:[t,10],mantissas:[i(t),[1,2,5]],min_interval:[t,0],max_interval:[a(t),null]})))},
function _(t,n,i,s,e){var o;s();const r=t(130),c=t(9);class _ extends r.Ticker{constructor(t){super(t)}get_ticks(t,n,i,s){return this.get_ticks_no_defaults(t,n,s,this.desired_num_ticks)}get_ticks_no_defaults(t,n,i,s){const e=this.get_interval(t,n,s),o=Math.floor(t/e),r=Math.ceil(n/e);let _;_=isFinite(o)&&isFinite(r)?(0,c.range)(o,r+1):[];const u=_.map((t=>t*e)).filter((i=>t<=i&&i<=n)),a=this.num_minor_ticks,f=[];if(a>0&&u.length>0){const i=e/a,s=(0,c.range)(0,a).map((t=>t*i));for(const i of s.slice(1)){const s=u[0]-i;t<=s&&s<=n&&f.push(s)}for(const i of u)for(const e of s){const s=i+e;t<=s&&s<=n&&f.push(s)}}return{major:u,minor:f}}get_ideal_interval(t,n,i){return(n-t)/i}}i.ContinuousTicker=_,o=_,_.__name__="ContinuousTicker",o.define((({Int:t})=>({num_minor_ticks:[t,5],desired_num_ticks:[t,6]})))},
function _(s,t,e,n,i){n();var r;const o=(0,s(1).__importDefault)(s(151)),a=s(131),c=s(19),u=s(152),m=s(9),h=s(8);function d(s){return(0,o.default)(s,"%Y %m %d %H %M %S").split(/\s+/).map((s=>parseInt(s,10)))}function l(s,t){if((0,h.isFunction)(t))return t(s);{const e=(0,u.sprintf)("$1%06d",function(s){return Math.round(s/1e3%1*1e6)}(s));return-1==(t=t.replace(/((^|[^%])(%%)*)%f/,e)).indexOf("%")?t:(0,o.default)(s,t)}}const f=["microseconds","milliseconds","seconds","minsec","minutes","hourmin","hours","days","months","years"];class _ extends a.TickFormatter{constructor(s){super(s),this.strip_leading_zeros=!0}initialize(){super.initialize(),this._update_width_formats()}_update_width_formats(){const s=+(0,o.default)(new Date),t=function(t){const e=t.map((t=>l(s,t).length)),n=(0,m.sort_by)((0,m.zip)(e,t),(([s])=>s));return(0,m.unzip)(n)};this._width_formats={microseconds:t(this.microseconds),milliseconds:t(this.milliseconds),seconds:t(this.seconds),minsec:t(this.minsec),minutes:t(this.minutes),hourmin:t(this.hourmin),hours:t(this.hours),days:t(this.days),months:t(this.months),years:t(this.years)}}_get_resolution_str(s,t){const e=1.1*s;switch(!1){case!(e<.001):return"microseconds";case!(e<1):return"milliseconds";case!(e<60):return t>=60?"minsec":"seconds";case!(e<3600):return t>=3600?"hourmin":"minutes";case!(e<86400):return"hours";case!(e<2678400):return"days";case!(e<31536e3):return"months";default:return"years"}}doFormat(s,t){if(0==s.length)return[];const e=Math.abs(s[s.length-1]-s[0])/1e3,n=e/(s.length-1),i=this._get_resolution_str(n,e),[,[r]]=this._width_formats[i],o=[],a=f.indexOf(i),u={};for(const s of f)u[s]=0;u.seconds=5,u.minsec=4,u.minutes=4,u.hourmin=3,u.hours=3;for(const t of s){let s,e;try{e=d(t),s=l(t,r)}catch(s){c.logger.warn(`unable to format tick for timestamp value ${t}`),c.logger.warn(` - ${s}`),o.push("ERR");continue}let n=!1,m=a;for(;0==e[u[f[m]]];){let r;if(m+=1,m==f.length)break;if(("minsec"==i||"hourmin"==i)&&!n){if("minsec"==i&&0==e[4]&&0!=e[5]||"hourmin"==i&&0==e[3]&&0!=e[4]){r=this._width_formats[f[a-1]][1][0],s=l(t,r);break}n=!0}r=this._width_formats[f[m]][1][0],s=l(t,r)}if(this.strip_leading_zeros){let t=s.replace(/^0+/g,"");t!=s&&isNaN(parseInt(t))&&(t=`0${t}`),o.push(t)}else o.push(s)}return o}}e.DatetimeTickFormatter=_,r=_,_.__name__="DatetimeTickFormatter",r.define((({String:s,Array:t})=>({microseconds:[t(s),["%fus"]],milliseconds:[t(s),["%3Nms","%S.%3Ns"]],seconds:[t(s),["%Ss"]],minsec:[t(s),[":%M:%S"]],minutes:[t(s),[":%M","%Mm"]],hourmin:[t(s),["%H:%M"]],hours:[t(s),["%Hh","%H:%M"]],days:[t(s),["%m/%d","%a%d"]],months:[t(s),["%m/%Y","%b %Y"]],years:[t(s),["%Y"]]})))},
function _(e,t,n,r,o){!function(e){"object"==typeof t&&t.exports?t.exports=e():"function"==typeof define?define(e):this.tz=e()}((function(){function e(e,t,n){var r,o=t.day[1];do{r=new Date(Date.UTC(n,t.month,Math.abs(o++)))}while(t.day[0]<7&&r.getUTCDay()!=t.day[0]);return(r={clock:t.clock,sort:r.getTime(),rule:t,save:6e4*t.save,offset:e.offset})[r.clock]=r.sort+6e4*t.time,r.posix?r.wallclock=r[r.clock]+(e.offset+t.saved):r.posix=r[r.clock]-(e.offset+t.saved),r}function t(t,n,r){var o,a,u,i,l,s,c,f=t[t.zone],h=[],T=new Date(r).getUTCFullYear(),g=1;for(o=1,a=f.length;o<a&&!(f[o][n]<=r);o++);if((u=f[o]).rules){for(s=t[u.rules],c=T+1;c>=T-g;--c)for(o=0,a=s.length;o<a;o++)s[o].from<=c&&c<=s[o].to?h.push(e(u,s[o],c)):s[o].to<c&&1==g&&(g=c-s[o].to);for(h.sort((function(e,t){return e.sort-t.sort})),o=0,a=h.length;o<a;o++)r>=h[o][n]&&h[o][h[o].clock]>u[h[o].clock]&&(i=h[o])}return i&&((l=/^(.*)\/(.*)$/.exec(u.format))?i.abbrev=l[i.save?2:1]:i.abbrev=u.format.replace(/%s/,i.rule.letter)),i||u}function n(e,n){return"UTC"==e.zone?n:(e.entry=t(e,"posix",n),n+e.entry.offset+e.entry.save)}function r(e,n){return"UTC"==e.zone?n:(e.entry=r=t(e,"wallclock",n),0<(o=n-r.wallclock)&&o<r.save?null:n-r.offset-r.save);var r,o}function o(e,t,o){var a,i=+(o[1]+1),s=o[2]*i,c=u.indexOf(o[3].toLowerCase());if(c>9)t+=s*l[c-10];else{if(a=new Date(n(e,t)),c<7)for(;s;)a.setUTCDate(a.getUTCDate()+i),a.getUTCDay()==c&&(s-=i);else 7==c?a.setUTCFullYear(a.getUTCFullYear()+s):8==c?a.setUTCMonth(a.getUTCMonth()+s):a.setUTCDate(a.getUTCDate()+s);null==(t=r(e,a.getTime()))&&(t=r(e,a.getTime()+864e5*i)-864e5*i)}return t}var a={clock:function(){return+new Date},zone:"UTC",entry:{abbrev:"UTC",offset:0,save:0},UTC:1,z:function(e,t,n,r){var o,a,u=this.entry.offset+this.entry.save,i=Math.abs(u/1e3),l=[],s=3600;for(o=0;o<3;o++)l.push(("0"+Math.floor(i/s)).slice(-2)),i%=s,s/=60;return"^"!=n||u?("^"==n&&(r=3),3==r?(a=(a=l.join(":")).replace(/:00$/,""),"^"!=n&&(a=a.replace(/:00$/,""))):r?(a=l.slice(0,r+1).join(":"),"^"==n&&(a=a.replace(/:00$/,""))):a=l.slice(0,2).join(""),a=(a=(u<0?"-":"+")+a).replace(/([-+])(0)/,{_:" $1","-":"$1"}[n]||"$1$2")):"Z"},"%":function(e){return"%"},n:function(e){return"\n"},t:function(e){return"\t"},U:function(e){return s(e,0)},W:function(e){return s(e,1)},V:function(e){return c(e)[0]},G:function(e){return c(e)[1]},g:function(e){return c(e)[1]%100},j:function(e){return Math.floor((e.getTime()-Date.UTC(e.getUTCFullYear(),0))/864e5)+1},s:function(e){return Math.floor(e.getTime()/1e3)},C:function(e){return Math.floor(e.getUTCFullYear()/100)},N:function(e){return e.getTime()%1e3*1e6},m:function(e){return e.getUTCMonth()+1},Y:function(e){return e.getUTCFullYear()},y:function(e){return e.getUTCFullYear()%100},H:function(e){return e.getUTCHours()},M:function(e){return e.getUTCMinutes()},S:function(e){return e.getUTCSeconds()},e:function(e){return e.getUTCDate()},d:function(e){return e.getUTCDate()},u:function(e){return e.getUTCDay()||7},w:function(e){return e.getUTCDay()},l:function(e){return e.getUTCHours()%12||12},I:function(e){return e.getUTCHours()%12||12},k:function(e){return e.getUTCHours()},Z:function(e){return this.entry.abbrev},a:function(e){return this[this.locale].day.abbrev[e.getUTCDay()]},A:function(e){return this[this.locale].day.full[e.getUTCDay()]},h:function(e){return this[this.locale].month.abbrev[e.getUTCMonth()]},b:function(e){return this[this.locale].month.abbrev[e.getUTCMonth()]},B:function(e){return this[this.locale].month.full[e.getUTCMonth()]},P:function(e){return this[this.locale].meridiem[Math.floor(e.getUTCHours()/12)].toLowerCase()},p:function(e){return this[this.locale].meridiem[Math.floor(e.getUTCHours()/12)]},R:function(e,t){return this.convert([t,"%H:%M"])},T:function(e,t){return this.convert([t,"%H:%M:%S"])},D:function(e,t){return this.convert([t,"%m/%d/%y"])},F:function(e,t){return this.convert([t,"%Y-%m-%d"])},x:function(e,t){return this.convert([t,this[this.locale].date])},r:function(e,t){return this.convert([t,this[this.locale].time12||"%I:%M:%S"])},X:function(e,t){return this.convert([t,this[this.locale].time24])},c:function(e,t){return this.convert([t,this[this.locale].dateTime])},convert:function(e){if(!e.length)return"1.0.23";var t,a,u,l,s,c=Object.create(this),f=[];for(t=0;t<e.length;t++)if(l=e[t],Array.isArray(l))t||isNaN(l[1])?l.splice.apply(e,[t--,1].concat(l)):s=l;else if(isNaN(l)){if("string"==(u=typeof l))~l.indexOf("%")?c.format=l:t||"*"!=l?!t&&(u=/^(\d{4})-(\d{2})-(\d{2})(?:[T\s](\d{2}):(\d{2})(?::(\d{2})(?:\.(\d+))?)?(Z|(([+-])(\d{2}(:\d{2}){0,2})))?)?$/.exec(l))?((s=[]).push.apply(s,u.slice(1,8)),u[9]?(s.push(u[10]+1),s.push.apply(s,u[11].split(/:/))):u[8]&&s.push(1)):/^\w{2,3}_\w{2}$/.test(l)?c.locale=l:(u=i.exec(l))?f.push(u):c.zone=l:s=l;else if("function"==u){if(u=l.call(c))return u}else if(/^\w{2,3}_\w{2}$/.test(l.name))c[l.name]=l;else if(l.zones){for(u in l.zones)c[u]=l.zones[u];for(u in l.rules)c[u]=l.rules[u]}}else t||(s=l);if(c[c.locale]||delete c.locale,c[c.zone]||delete c.zone,null!=s){if("*"==s)s=c.clock();else if(Array.isArray(s)){for(u=[],a=!s[7],t=0;t<11;t++)u[t]=+(s[t]||0);--u[1],s=Date.UTC.apply(Date.UTC,u)+-u[7]*(36e5*u[8]+6e4*u[9]+1e3*u[10])}else s=Math.floor(s);if(!isNaN(s)){if(a&&(s=r(c,s)),null==s)return s;for(t=0,a=f.length;t<a;t++)s=o(c,s,f[t]);return c.format?(u=new Date(n(c,s)),c.format.replace(/%([-0_^]?)(:{0,3})(\d*)(.)/g,(function(e,t,n,r,o){var a,i,l="0";if(a=c[o]){for(e=String(a.call(c,u,s,t,n.length)),"_"==(t||a.style)&&(l=" "),i="-"==t?0:a.pad||0;e.length<i;)e=l+e;for(i="-"==t?0:r||a.pad;e.length<i;)e=l+e;"N"==o&&i<e.length&&(e=e.slice(0,i)),"^"==t&&(e=e.toUpperCase())}return e}))):s}}return function(){return c.convert(arguments)}},locale:"en_US",en_US:{date:"%m/%d/%Y",time24:"%I:%M:%S %p",time12:"%I:%M:%S %p",dateTime:"%a %d %b %Y %I:%M:%S %p %Z",meridiem:["AM","PM"],month:{abbrev:"Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec".split("|"),full:"January|February|March|April|May|June|July|August|September|October|November|December".split("|")},day:{abbrev:"Sun|Mon|Tue|Wed|Thu|Fri|Sat".split("|"),full:"Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday".split("|")}}},u="Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|year|month|day|hour|minute|second|millisecond",i=new RegExp("^\\s*([+-])(\\d+)\\s+("+u+")s?\\s*$","i"),l=[36e5,6e4,1e3,1];function s(e,t){var n,r,o;return r=new Date(Date.UTC(e.getUTCFullYear(),0)),n=Math.floor((e.getTime()-r.getTime())/864e5),r.getUTCDay()==t?o=0:8==(o=7-r.getUTCDay()+t)&&(o=1),n>=o?Math.floor((n-o)/7)+1:0}function c(e){var t,n,r;return n=e.getUTCFullYear(),t=new Date(Date.UTC(n,0)).getUTCDay(),(r=s(e,1)+(t>1&&t<=4?1:0))?53!=r||4==t||3==t&&29==new Date(n,1,29).getDate()?[r,e.getUTCFullYear()]:[1,e.getUTCFullYear()+1]:(n=e.getUTCFullYear()-1,[r=4==(t=new Date(Date.UTC(n,0)).getUTCDay())||3==t&&29==new Date(n,1,29).getDate()?53:52,e.getUTCFullYear()-1])}return u=u.toLowerCase().split("|"),"delmHMSUWVgCIky".replace(/./g,(function(e){a[e].pad=2})),a.N.pad=9,a.j.pad=3,a.k.style="_",a.l.style="_",a.e.style="_",function(){return a.convert(arguments)}}))},
function _(r,t,n,e,i){e();const u=r(1),a=(0,u.__importStar)(r(153)),f=r(154),o=(0,u.__importDefault)(r(151)),l=r(21),s=r(8);function c(r,...t){return(0,f.sprintf)(r,...t)}function m(r,t,n){if((0,s.isNumber)(r)){return c((()=>{switch(!1){case Math.floor(r)!=r:return"%d";case!(Math.abs(r)>.1&&Math.abs(r)<1e3):return"%0.3f";default:return"%0.3e"}})(),r)}return`${r}`}function _(r,t,e){if(null==t)return m;if(null!=e&&r in e){const t=e[r];if((0,s.isString)(t)){if(t in n.DEFAULT_FORMATTERS)return n.DEFAULT_FORMATTERS[t];throw new Error(`Unknown tooltip field formatter type '${t}'`)}return function(r,n,e){return t.format(r,n,e)}}return n.DEFAULT_FORMATTERS.numeral}function p(r,t,n){const e=t.get_column(r);if(null==e)return null;if((0,s.isNumber)(n))return e[n];const i=e[n.index];if((0,s.isTypedArray)(i)||(0,s.isArray)(i)){if((0,s.isArray)(i[0])){return i[n.dim2][n.dim1]}return i[n.flat_index]}return i}function d(r,t,n,e){if("$"==r[0]){return function(r,t){if(r in t)return t[r];throw new Error(`Unknown special variable '$${r}'`)}(r.substring(1),e)}return p(r.substring(1).replace(/[{}]/g,""),t,n)}n.FormatterType=(0,l.Enum)("numeral","printf","datetime"),n.DEFAULT_FORMATTERS={numeral:(r,t,n)=>a.format(r,t),datetime:(r,t,n)=>(0,o.default)(r,t),printf:(r,t,n)=>c(t,r)},n.sprintf=c,n.basic_formatter=m,n.get_formatter=_,n._get_column_value=p,n.get_value=d,n.replace_placeholders=function(r,t,n,e,i={},u){let a,f;if((0,s.isString)(r)?(a=r,f=!1):(a=r.html,f=!0),a=a.replace(/@\$name/g,(r=>`@{${i.name}}`)),a=a.replace(/((?:\$\w+)|(?:@\w+)|(?:@{(?:[^{}]+)}))(?:{([^{}]+)})?/g,((r,a,o)=>{const l=d(a,t,n,i);if(null==l)return u?u("???"):"???";if("safe"==o)return f=!0,`${l}`;const s=`${_(a,o,e)(l,o,i)}`;return u?u(s):s})),f){return[...(new DOMParser).parseFromString(a,"text/html").body.childNodes]}return a}},
function _(e,n,t,r,i){
/*!
     * numbro.js
     * version : 1.6.2
     * author : Företagsplatsen AB
     * license : MIT
     * http://www.foretagsplatsen.se
     */
var a,o={},l=o,u="en-US",c=null,s="0,0";void 0!==n&&n.exports;function f(e){this._value=e}function d(e){var n,t="";for(n=0;n<e;n++)t+="0";return t}function h(e,n,t,r){var i,a,o=Math.pow(10,n);return a=e.toFixed(0).search("e")>-1?function(e,n){var t,r,i,a;return t=(a=e.toString()).split("e")[0],i=a.split("e")[1],a=t.split(".")[0]+(r=t.split(".")[1]||"")+d(i-r.length),n>0&&(a+="."+d(n)),a}(e,n):(t(e*o)/o).toFixed(n),r&&(i=new RegExp("0{1,"+r+"}$"),a=a.replace(i,"")),a}function p(e,n,t){var r;return r=n.indexOf("$")>-1?function(e,n,t){var r,i,a=n,l=a.indexOf("$"),c=a.indexOf("("),s=a.indexOf("+"),f=a.indexOf("-"),d="",h="";-1===a.indexOf("$")?"infix"===o[u].currency.position?(h=o[u].currency.symbol,o[u].currency.spaceSeparated&&(h=" "+h+" ")):o[u].currency.spaceSeparated&&(d=" "):a.indexOf(" $")>-1?(d=" ",a=a.replace(" $","")):a.indexOf("$ ")>-1?(d=" ",a=a.replace("$ ","")):a=a.replace("$","");if(i=m(e,a,t,h),-1===n.indexOf("$"))switch(o[u].currency.position){case"postfix":i.indexOf(")")>-1?((i=i.split("")).splice(-1,0,d+o[u].currency.symbol),i=i.join("")):i=i+d+o[u].currency.symbol;break;case"infix":break;case"prefix":i.indexOf("(")>-1||i.indexOf("-")>-1?(i=i.split(""),r=Math.max(c,f)+1,i.splice(r,0,o[u].currency.symbol+d),i=i.join("")):i=o[u].currency.symbol+d+i;break;default:throw Error('Currency position should be among ["prefix", "infix", "postfix"]')}else l<=1?i.indexOf("(")>-1||i.indexOf("+")>-1||i.indexOf("-")>-1?(r=1,(l<c||l<s||l<f)&&(r=0),(i=i.split("")).splice(r,0,o[u].currency.symbol+d),i=i.join("")):i=o[u].currency.symbol+d+i:i.indexOf(")")>-1?((i=i.split("")).splice(-1,0,d+o[u].currency.symbol),i=i.join("")):i=i+d+o[u].currency.symbol;return i}(e,n,t):n.indexOf("%")>-1?function(e,n,t){var r,i="";e*=100,n.indexOf(" %")>-1?(i=" ",n=n.replace(" %","")):n=n.replace("%","");(r=m(e,n,t)).indexOf(")")>-1?((r=r.split("")).splice(-1,0,i+"%"),r=r.join("")):r=r+i+"%";return r}(e,n,t):n.indexOf(":")>-1?function(e){var n=Math.floor(e/60/60),t=Math.floor((e-60*n*60)/60),r=Math.round(e-60*n*60-60*t);return n+":"+(t<10?"0"+t:t)+":"+(r<10?"0"+r:r)}(e):m(e,n,t),r}function m(e,n,t,r){var i,a,l,s,f,d,p,m,x,g,O,b,w,y,M,v,$,B=!1,E=!1,F=!1,k="",U=!1,N=!1,S=!1,j=!1,D=!1,C="",L="",T=Math.abs(e),K=["B","KiB","MiB","GiB","TiB","PiB","EiB","ZiB","YiB"],G=["B","KB","MB","GB","TB","PB","EB","ZB","YB"],I="",P=!1,R=!1;if(0===e&&null!==c)return c;if(!isFinite(e))return""+e;if(0===n.indexOf("{")){var W=n.indexOf("}");if(-1===W)throw Error('Format should also contain a "}"');b=n.slice(1,W),n=n.slice(W+1)}else b="";if(n.indexOf("}")===n.length-1){var Y=n.indexOf("{");if(-1===Y)throw Error('Format should also contain a "{"');w=n.slice(Y+1,-1),n=n.slice(0,Y+1)}else w="";if(v=null===($=-1===n.indexOf(".")?n.match(/([0-9]+).*/):n.match(/([0-9]+)\..*/))?-1:$[1].length,-1!==n.indexOf("-")&&(P=!0),n.indexOf("(")>-1?(B=!0,n=n.slice(1,-1)):n.indexOf("+")>-1&&(E=!0,n=n.replace(/\+/g,"")),n.indexOf("a")>-1){if(g=n.split(".")[0].match(/[0-9]+/g)||["0"],g=parseInt(g[0],10),U=n.indexOf("aK")>=0,N=n.indexOf("aM")>=0,S=n.indexOf("aB")>=0,j=n.indexOf("aT")>=0,D=U||N||S||j,n.indexOf(" a")>-1?(k=" ",n=n.replace(" a","")):n=n.replace("a",""),p=0===(p=(f=Math.floor(Math.log(T)/Math.LN10)+1)%3)?3:p,g&&0!==T&&(d=Math.floor(Math.log(T)/Math.LN10)+1-g,m=3*~~((Math.min(g,f)-p)/3),T/=Math.pow(10,m),-1===n.indexOf(".")&&g>3))for(n+="[.]",M=(M=0===d?0:3*~~(d/3)-d)<0?M+3:M,i=0;i<M;i++)n+="0";Math.floor(Math.log(Math.abs(e))/Math.LN10)+1!==g&&(T>=Math.pow(10,12)&&!D||j?(k+=o[u].abbreviations.trillion,e/=Math.pow(10,12)):T<Math.pow(10,12)&&T>=Math.pow(10,9)&&!D||S?(k+=o[u].abbreviations.billion,e/=Math.pow(10,9)):T<Math.pow(10,9)&&T>=Math.pow(10,6)&&!D||N?(k+=o[u].abbreviations.million,e/=Math.pow(10,6)):(T<Math.pow(10,6)&&T>=Math.pow(10,3)&&!D||U)&&(k+=o[u].abbreviations.thousand,e/=Math.pow(10,3)))}if(n.indexOf("b")>-1)for(n.indexOf(" b")>-1?(C=" ",n=n.replace(" b","")):n=n.replace("b",""),s=0;s<=K.length;s++)if(a=Math.pow(1024,s),l=Math.pow(1024,s+1),e>=a&&e<l){C+=K[s],a>0&&(e/=a);break}if(n.indexOf("d")>-1)for(n.indexOf(" d")>-1?(C=" ",n=n.replace(" d","")):n=n.replace("d",""),s=0;s<=G.length;s++)if(a=Math.pow(1e3,s),l=Math.pow(1e3,s+1),e>=a&&e<l){C+=G[s],a>0&&(e/=a);break}if(n.indexOf("o")>-1&&(n.indexOf(" o")>-1?(L=" ",n=n.replace(" o","")):n=n.replace("o",""),o[u].ordinal&&(L+=o[u].ordinal(e))),n.indexOf("[.]")>-1&&(F=!0,n=n.replace("[.]",".")),x=e.toString().split(".")[0],O=n.split(".")[1],y=n.indexOf(","),O){if(x=(I=-1!==O.indexOf("*")?h(e,e.toString().split(".")[1].length,t):O.indexOf("[")>-1?h(e,(O=(O=O.replace("]","")).split("["))[0].length+O[1].length,t,O[1].length):h(e,O.length,t)).split(".")[0],I.split(".")[1].length)I=(r?k+r:o[u].delimiters.decimal)+I.split(".")[1];else I="";F&&0===Number(I.slice(1))&&(I="")}else x=h(e,null,t);return x.indexOf("-")>-1&&(x=x.slice(1),R=!0),x.length<v&&(x=new Array(v-x.length+1).join("0")+x),y>-1&&(x=x.toString().replace(/(\d)(?=(\d{3})+(?!\d))/g,"$1"+o[u].delimiters.thousands)),0===n.indexOf(".")&&(x=""),b+(n.indexOf("(")<n.indexOf("-")?(B&&R?"(":"")+(P&&R||!B&&R?"-":""):(P&&R||!B&&R?"-":"")+(B&&R?"(":""))+(!R&&E&&0!==e?"+":"")+x+I+(L||"")+(k&&!r?k:"")+(C||"")+(B&&R?")":"")+w}function x(e,n){o[e]=n}function g(e){u=e;var n=o[e].defaults;n&&n.format&&a.defaultFormat(n.format),n&&n.currencyFormat&&a.defaultCurrencyFormat(n.currencyFormat)}(a=function(e){return a.isNumbro(e)?e=e.value():0===e||void 0===e?e=0:Number(e)||(e=a.fn.unformat(e)),new f(Number(e))}).version="1.6.2",a.isNumbro=function(e){return e instanceof f},a.setLanguage=function(e,n){console.warn("`setLanguage` is deprecated since version 1.6.0. Use `setCulture` instead");var t=e,r=e.split("-")[0],i=null;l[t]||(Object.keys(l).forEach((function(e){i||e.split("-")[0]!==r||(i=e)})),t=i||n||"en-US"),g(t)},a.setCulture=function(e,n){var t=e,r=e.split("-")[1],i=null;o[t]||(r&&Object.keys(o).forEach((function(e){i||e.split("-")[1]!==r||(i=e)})),t=i||n||"en-US"),g(t)},a.language=function(e,n){if(console.warn("`language` is deprecated since version 1.6.0. Use `culture` instead"),!e)return u;if(e&&!n){if(!l[e])throw new Error("Unknown language : "+e);g(e)}return!n&&l[e]||x(e,n),a},a.culture=function(e,n){if(!e)return u;if(e&&!n){if(!o[e])throw new Error("Unknown culture : "+e);g(e)}return!n&&o[e]||x(e,n),a},a.languageData=function(e){if(console.warn("`languageData` is deprecated since version 1.6.0. Use `cultureData` instead"),!e)return l[u];if(!l[e])throw new Error("Unknown language : "+e);return l[e]},a.cultureData=function(e){if(!e)return o[u];if(!o[e])throw new Error("Unknown culture : "+e);return o[e]},a.culture("en-US",{delimiters:{thousands:",",decimal:"."},abbreviations:{thousand:"k",million:"m",billion:"b",trillion:"t"},ordinal:function(e){var n=e%10;return 1==~~(e%100/10)?"th":1===n?"st":2===n?"nd":3===n?"rd":"th"},currency:{symbol:"$",position:"prefix"},defaults:{currencyFormat:",0000 a"},formats:{fourDigits:"0000 a",fullWithTwoDecimals:"$ ,0.00",fullWithTwoDecimalsNoCurrency:",0.00"}}),a.languages=function(){return console.warn("`languages` is deprecated since version 1.6.0. Use `cultures` instead"),l},a.cultures=function(){return o},a.zeroFormat=function(e){c="string"==typeof e?e:null},a.defaultFormat=function(e){s="string"==typeof e?e:"0.0"},a.defaultCurrencyFormat=function(e){"string"==typeof e?e:"0$"},a.validate=function(e,n){var t,r,i,o,l,u,c,s;if("string"!=typeof e&&(e+="",console.warn&&console.warn("Numbro.js: Value is not string. It has been co-erced to: ",e)),(e=e.trim()).match(/^\d+$/))return!0;if(""===e)return!1;try{c=a.cultureData(n)}catch(e){c=a.cultureData(a.culture())}return i=c.currency.symbol,l=c.abbreviations,t=c.delimiters.decimal,r="."===c.delimiters.thousands?"\\.":c.delimiters.thousands,(null===(s=e.match(/^[^\d]+/))||(e=e.substr(1),s[0]===i))&&((null===(s=e.match(/[^\d]+$/))||(e=e.slice(0,-1),s[0]===l.thousand||s[0]===l.million||s[0]===l.billion||s[0]===l.trillion))&&(u=new RegExp(r+"{2}"),!e.match(/[^\d.,]/g)&&(!((o=e.split(t)).length>2)&&(o.length<2?!!o[0].match(/^\d+.*\d$/)&&!o[0].match(u):1===o[0].length?!!o[0].match(/^\d+$/)&&!o[0].match(u)&&!!o[1].match(/^\d+$/):!!o[0].match(/^\d+.*\d$/)&&!o[0].match(u)&&!!o[1].match(/^\d+$/)))))},n.exports={format:function(e,n,t,r){return null!=t&&t!==a.culture()&&a.setCulture(t),p(Number(e),null!=n?n:s,null==r?Math.round:r)}}},
function _(e,n,t,r,i){!function(){"use strict";var e={not_string:/[^s]/,not_bool:/[^t]/,not_type:/[^T]/,not_primitive:/[^v]/,number:/[diefg]/,numeric_arg:/[bcdiefguxX]/,json:/[j]/,not_json:/[^j]/,text:/^[^\x25]+/,modulo:/^\x25{2}/,placeholder:/^\x25(?:([1-9]\d*)\$|\(([^)]+)\))?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-gijostTuvxX])/,key:/^([a-z_][a-z_\d]*)/i,key_access:/^\.([a-z_][a-z_\d]*)/i,index_access:/^\[(\d+)\]/,sign:/^[+-]/};function n(e){return i(a(e),arguments)}function r(e,t){return n.apply(null,[e].concat(t||[]))}function i(t,r){var i,s,a,o,p,c,l,u,f,d=1,g=t.length,y="";for(s=0;s<g;s++)if("string"==typeof t[s])y+=t[s];else if("object"==typeof t[s]){if((o=t[s]).keys)for(i=r[d],a=0;a<o.keys.length;a++){if(null==i)throw new Error(n('[sprintf] Cannot access property "%s" of undefined value "%s"',o.keys[a],o.keys[a-1]));i=i[o.keys[a]]}else i=o.param_no?r[o.param_no]:r[d++];if(e.not_type.test(o.type)&&e.not_primitive.test(o.type)&&i instanceof Function&&(i=i()),e.numeric_arg.test(o.type)&&"number"!=typeof i&&isNaN(i))throw new TypeError(n("[sprintf] expecting number but found %T",i));switch(e.number.test(o.type)&&(u=i>=0),o.type){case"b":i=parseInt(i,10).toString(2);break;case"c":i=String.fromCharCode(parseInt(i,10));break;case"d":case"i":i=parseInt(i,10);break;case"j":i=JSON.stringify(i,null,o.width?parseInt(o.width):0);break;case"e":i=o.precision?parseFloat(i).toExponential(o.precision):parseFloat(i).toExponential();break;case"f":i=o.precision?parseFloat(i).toFixed(o.precision):parseFloat(i);break;case"g":i=o.precision?String(Number(i.toPrecision(o.precision))):parseFloat(i);break;case"o":i=(parseInt(i,10)>>>0).toString(8);break;case"s":i=String(i),i=o.precision?i.substring(0,o.precision):i;break;case"t":i=String(!!i),i=o.precision?i.substring(0,o.precision):i;break;case"T":i=Object.prototype.toString.call(i).slice(8,-1).toLowerCase(),i=o.precision?i.substring(0,o.precision):i;break;case"u":i=parseInt(i,10)>>>0;break;case"v":i=i.valueOf(),i=o.precision?i.substring(0,o.precision):i;break;case"x":i=(parseInt(i,10)>>>0).toString(16);break;case"X":i=(parseInt(i,10)>>>0).toString(16).toUpperCase()}e.json.test(o.type)?y+=i:(!e.number.test(o.type)||u&&!o.sign?f="":(f=u?"+":"-",i=i.toString().replace(e.sign,"")),c=o.pad_char?"0"===o.pad_char?"0":o.pad_char.charAt(1):" ",l=o.width-(f+i).length,p=o.width&&l>0?c.repeat(l):"",y+=o.align?f+i+p:"0"===c?f+p+i:p+f+i)}return y}var s=Object.create(null);function a(n){if(s[n])return s[n];for(var t,r=n,i=[],a=0;r;){if(null!==(t=e.text.exec(r)))i.push(t[0]);else if(null!==(t=e.modulo.exec(r)))i.push("%");else{if(null===(t=e.placeholder.exec(r)))throw new SyntaxError("[sprintf] unexpected placeholder");if(t[2]){a|=1;var o=[],p=t[2],c=[];if(null===(c=e.key.exec(p)))throw new SyntaxError("[sprintf] failed to parse named argument key");for(o.push(c[1]);""!==(p=p.substring(c[0].length));)if(null!==(c=e.key_access.exec(p)))o.push(c[1]);else{if(null===(c=e.index_access.exec(p)))throw new SyntaxError("[sprintf] failed to parse named argument key");o.push(c[1])}t[2]=o}else a|=2;if(3===a)throw new Error("[sprintf] mixing positional and named placeholders is not (yet) supported");i.push({placeholder:t[0],param_no:t[1],keys:t[2],sign:t[3],pad_char:t[4],align:t[5],width:t[6],precision:t[7],type:t[8]})}r=r.substring(t[0].length)}return s[n]=i}void 0!==t&&(t.sprintf=n,t.vsprintf=r),"undefined"!=typeof window&&(window.sprintf=n,window.vsprintf=r,"function"==typeof define&&define.amd&&define((function(){return{sprintf:n,vsprintf:r}})))}()},
function _(e,n,i,a,s){var r;a();const t=e(9),c=e(148),m=e(156),_=e(157),k=e(160),o=e(161),T=e(159);class w extends m.CompositeTicker{constructor(e){super(e)}}i.DatetimeTicker=w,r=w,w.__name__="DatetimeTicker",r.override({num_minor_ticks:0,tickers:()=>[new c.AdaptiveTicker({mantissas:[1,2,5],base:10,min_interval:0,max_interval:500*T.ONE_MILLI,num_minor_ticks:0}),new c.AdaptiveTicker({mantissas:[1,2,5,10,15,20,30],base:60,min_interval:T.ONE_SECOND,max_interval:30*T.ONE_MINUTE,num_minor_ticks:0}),new c.AdaptiveTicker({mantissas:[1,2,4,6,8,12],base:24,min_interval:T.ONE_HOUR,max_interval:12*T.ONE_HOUR,num_minor_ticks:0}),new _.DaysTicker({days:(0,t.range)(1,32)}),new _.DaysTicker({days:(0,t.range)(1,31,3)}),new _.DaysTicker({days:[1,8,15,22]}),new _.DaysTicker({days:[1,15]}),new k.MonthsTicker({months:(0,t.range)(0,12,1)}),new k.MonthsTicker({months:(0,t.range)(0,12,2)}),new k.MonthsTicker({months:(0,t.range)(0,12,4)}),new k.MonthsTicker({months:(0,t.range)(0,12,6)}),new o.YearsTicker({})]})},
function _(t,e,i,r,s){var n;r();const _=t(149),a=t(9);class l extends _.ContinuousTicker{constructor(t){super(t)}get min_intervals(){return this.tickers.map((t=>t.get_min_interval()))}get max_intervals(){return this.tickers.map((t=>t.get_max_interval()))}get_min_interval(){return this.min_intervals[0]}get_max_interval(){return this.max_intervals[0]}get_best_ticker(t,e,i){const r=e-t,s=this.get_ideal_interval(t,e,i),n=[(0,a.sorted_index)(this.min_intervals,s)-1,(0,a.sorted_index)(this.max_intervals,s)],_=[this.min_intervals[n[0]],this.max_intervals[n[1]]].map((t=>Math.abs(i-r/t)));let l;if((0,a.is_empty)(_.filter((t=>!isNaN(t)))))l=this.tickers[0];else{const t=n[(0,a.argmin)(_)];l=this.tickers[t]}return l}get_interval(t,e,i){return this.get_best_ticker(t,e,i).get_interval(t,e,i)}get_ticks_no_defaults(t,e,i,r){return this.get_best_ticker(t,e,r).get_ticks_no_defaults(t,e,i,r)}}i.CompositeTicker=l,n=l,l.__name__="CompositeTicker",n.define((({Array:t,Ref:e})=>({tickers:[t(e(_.ContinuousTicker)),[]]})))},
function _(t,e,n,s,o){var a;s();const i=t(158),r=t(159),c=t(9);class _ extends i.SingleIntervalTicker{constructor(t){super(t)}initialize(){super.initialize();const t=this.days;t.length>1?this.interval=(t[1]-t[0])*r.ONE_DAY:this.interval=31*r.ONE_DAY}get_ticks_no_defaults(t,e,n,s){const o=function(t,e){const n=(0,r.last_month_no_later_than)(new Date(t)),s=(0,r.last_month_no_later_than)(new Date(e));s.setUTCMonth(s.getUTCMonth()+1);const o=[],a=n;for(;o.push((0,r.copy_date)(a)),a.setUTCMonth(a.getUTCMonth()+1),!(a>s););return o}(t,e),a=this.days,i=this.interval,_=(0,c.concat)(o.map((t=>((t,e)=>{const n=t.getUTCMonth(),s=[];for(const o of a){const a=(0,r.copy_date)(t);a.setUTCDate(o),new Date(a.getTime()+e/2).getUTCMonth()==n&&s.push(a)}return s})(t,i))));return{major:_.map((t=>t.getTime())).filter((n=>t<=n&&n<=e)),minor:[]}}}n.DaysTicker=_,a=_,_.__name__="DaysTicker",a.define((({Int:t,Array:e})=>({days:[e(t),[]]}))),a.override({num_minor_ticks:0})},
function _(e,n,t,r,i){var a;r();const l=e(149);class s extends l.ContinuousTicker{constructor(e){super(e)}get_interval(e,n,t){return this.interval}get_min_interval(){return this.interval}get_max_interval(){return this.interval}}t.SingleIntervalTicker=s,a=s,s.__name__="SingleIntervalTicker",a.define((({Number:e})=>({interval:[e]})))},
function _(t,n,e,_,E){function N(t){return new Date(t.getTime())}function O(t){const n=N(t);return n.setUTCDate(1),n.setUTCHours(0),n.setUTCMinutes(0),n.setUTCSeconds(0),n.setUTCMilliseconds(0),n}_(),e.ONE_MILLI=1,e.ONE_SECOND=1e3,e.ONE_MINUTE=60*e.ONE_SECOND,e.ONE_HOUR=60*e.ONE_MINUTE,e.ONE_DAY=24*e.ONE_HOUR,e.ONE_MONTH=30*e.ONE_DAY,e.ONE_YEAR=365*e.ONE_DAY,e.copy_date=N,e.last_month_no_later_than=O,e.last_year_no_later_than=function(t){const n=O(t);return n.setUTCMonth(0),n}},
function _(t,e,n,a,r){var s;a();const i=t(158),o=t(159),l=t(9);class _ extends i.SingleIntervalTicker{constructor(t){super(t)}initialize(){super.initialize();const t=this.months;t.length>1?this.interval=(t[1]-t[0])*o.ONE_MONTH:this.interval=12*o.ONE_MONTH}get_ticks_no_defaults(t,e,n,a){const r=function(t,e){const n=(0,o.last_year_no_later_than)(new Date(t)),a=(0,o.last_year_no_later_than)(new Date(e));a.setUTCFullYear(a.getUTCFullYear()+1);const r=[],s=n;for(;r.push((0,o.copy_date)(s)),s.setUTCFullYear(s.getUTCFullYear()+1),!(s>a););return r}(t,e),s=this.months;return{major:(0,l.concat)(r.map((t=>s.map((e=>{const n=(0,o.copy_date)(t);return n.setUTCMonth(e),n}))))).map((t=>t.getTime())).filter((n=>t<=n&&n<=e)),minor:[]}}}n.MonthsTicker=_,s=_,_.__name__="MonthsTicker",s.define((({Int:t,Array:e})=>({months:[e(t),[]]})))},
function _(e,t,a,i,r){i();const n=e(147),_=e(158),s=e(159);class c extends _.SingleIntervalTicker{constructor(e){super(e)}initialize(){super.initialize(),this.interval=s.ONE_YEAR,this.basic_ticker=new n.BasicTicker({num_minor_ticks:0})}get_ticks_no_defaults(e,t,a,i){const r=(0,s.last_year_no_later_than)(new Date(e)).getUTCFullYear(),n=(0,s.last_year_no_later_than)(new Date(t)).getUTCFullYear();return{major:this.basic_ticker.get_ticks_no_defaults(r,n,a,i).major.map((e=>Date.UTC(e,0,1))).filter((a=>e<=a&&a<=t)),minor:[]}}}a.YearsTicker=c,c.__name__="YearsTicker"},
function _(e,o,i,s,t){var n;s();const r=e(143),_=e(163),c=e(164);class a extends r.ContinuousAxisView{}i.LogAxisView=a,a.__name__="LogAxisView";class u extends r.ContinuousAxis{constructor(e){super(e)}}i.LogAxis=u,n=u,u.__name__="LogAxis",n.prototype.default_view=a,n.override({ticker:()=>new c.LogTicker,formatter:()=>new _.LogTickFormatter})},
function _(e,t,n,o,r){var i;o();const a=e(131),s=e(146),c=e(164),l=e(120),{abs:u,log:x,round:_}=Math;class p extends a.TickFormatter{constructor(e){super(e)}initialize(){super.initialize(),this.basic_formatter=new s.BasicTickFormatter}format_graphics(e,t){var n,o;if(0==e.length)return[];const r=null!==(o=null===(n=this.ticker)||void 0===n?void 0:n.base)&&void 0!==o?o:10,i=this._exponents(e,r);return null==i?this.basic_formatter.format_graphics(e,t):i.map((e=>{if(u(e)<this.min_exponent){const t=new l.TextBox({text:(0,s.unicode_replace)(`${r**e}`)}),n=new l.TextBox({text:""});return new l.BaseExpo(t,n)}{const t=new l.TextBox({text:(0,s.unicode_replace)(`${r}`)}),n=new l.TextBox({text:(0,s.unicode_replace)(`${e}`)});return new l.BaseExpo(t,n)}}))}_exponents(e,t){let n=null;const o=[];for(const r of e){const e=_(x(r)/x(t));if(n==e)return null;n=e,o.push(e)}return o}doFormat(e,t){var n,o;if(0==e.length)return[];const r=null!==(o=null===(n=this.ticker)||void 0===n?void 0:n.base)&&void 0!==o?o:10,i=this._exponents(e,r);return null==i?this.basic_formatter.doFormat(e,t):i.map((e=>u(e)<this.min_exponent?(0,s.unicode_replace)(`${r**e}`):(0,s.unicode_replace)(`${r}^${e}`)))}}n.LogTickFormatter=p,i=p,p.__name__="LogTickFormatter",i.define((({Int:e,Ref:t,Nullable:n})=>({ticker:[n(t(c.LogTicker)),null],min_exponent:[e,0]})))},
function _(t,o,e,s,n){var r;s();const i=t(148),a=t(9);class c extends i.AdaptiveTicker{constructor(t){super(t)}get_ticks_no_defaults(t,o,e,s){const n=this.num_minor_ticks,r=[],i=this.base,c=Math.log(t)/Math.log(i),f=Math.log(o)/Math.log(i),l=f-c;let h;if(isFinite(l))if(l<2){const e=this.get_interval(t,o,s),i=Math.floor(t/e),c=Math.ceil(o/e);if(h=(0,a.range)(i,c+1).filter((t=>0!=t)).map((t=>t*e)).filter((e=>t<=e&&e<=o)),n>0&&h.length>0){const t=e/n,o=(0,a.range)(0,n).map((o=>o*t));for(const t of o.slice(1))r.push(h[0]-t);for(const t of h)for(const e of o)r.push(t+e)}}else{const t=Math.ceil(.999999*c),o=Math.floor(1.000001*f),e=Math.ceil((o-t)/9);if(h=(0,a.range)(t-1,o+1,e).map((t=>i**t)),n>0&&h.length>0){const t=i**e/n,o=(0,a.range)(1,n+1).map((o=>o*t));for(const t of o)r.push(h[0]/t);r.push(h[0]);for(const t of h)for(const e of o)r.push(t*e)}}else h=[];return{major:h.filter((e=>t<=e&&e<=o)),minor:r.filter((e=>t<=e&&e<=o))}}}e.LogTicker=c,r=c,c.__name__="LogTicker",r.override({mantissas:[1,5]})},
function _(e,r,t,i,a){var o;i();const s=e(128),c=e(145),n=e(166),_=e(167);class x extends s.AxisView{}t.MercatorAxisView=x,x.__name__="MercatorAxisView";class d extends c.LinearAxis{constructor(e){super(e)}}t.MercatorAxis=d,o=d,d.__name__="MercatorAxis",o.prototype.default_view=x,o.override({ticker:()=>new _.MercatorTicker({dimension:"lat"}),formatter:()=>new n.MercatorTickFormatter({dimension:"lat"})})},
function _(r,t,e,o,n){var i;o();const c=r(146),s=r(20),a=r(78);class l extends c.BasicTickFormatter{constructor(r){super(r)}doFormat(r,t){if(null==this.dimension)throw new Error("MercatorTickFormatter.dimension not configured");if(0==r.length)return[];const e=r.length,o=new Array(e);if("lon"==this.dimension)for(let n=0;n<e;n++){const[e]=a.wgs84_mercator.invert(r[n],t.loc);o[n]=e}else for(let n=0;n<e;n++){const[,e]=a.wgs84_mercator.invert(t.loc,r[n]);o[n]=e}return super.doFormat(o,t)}}e.MercatorTickFormatter=l,i=l,l.__name__="MercatorTickFormatter",i.define((({Nullable:r})=>({dimension:[r(s.LatLon),null]})))},
function _(t,o,n,s,r){var e;s();const i=t(147),c=t(20),_=t(78);class a extends i.BasicTicker{constructor(t){super(t)}get_ticks_no_defaults(t,o,n,s){if(null==this.dimension)throw new Error(`${this}.dimension wasn't configured`);return[t,o]=(0,_.clip_mercator)(t,o,this.dimension),"lon"==this.dimension?this._get_ticks_lon(t,o,n,s):this._get_ticks_lat(t,o,n,s)}_get_ticks_lon(t,o,n,s){const[r]=_.wgs84_mercator.invert(t,n),[e,i]=_.wgs84_mercator.invert(o,n),c=super.get_ticks_no_defaults(r,e,n,s),a=[];for(const t of c.major)if((0,_.in_bounds)(t,"lon")){const[o]=_.wgs84_mercator.compute(t,i);a.push(o)}const m=[];for(const t of c.minor)if((0,_.in_bounds)(t,"lon")){const[o]=_.wgs84_mercator.compute(t,i);m.push(o)}return{major:a,minor:m}}_get_ticks_lat(t,o,n,s){const[,r]=_.wgs84_mercator.invert(n,t),[e,i]=_.wgs84_mercator.invert(n,o),c=super.get_ticks_no_defaults(r,i,n,s),a=[];for(const t of c.major)if((0,_.in_bounds)(t,"lat")){const[,o]=_.wgs84_mercator.compute(e,t);a.push(o)}const m=[];for(const t of c.minor)if((0,_.in_bounds)(t,"lat")){const[,o]=_.wgs84_mercator.compute(e,t);m.push(o)}return{major:a,minor:m}}}n.MercatorTicker=a,e=a,a.__name__="MercatorTicker",e.define((({Nullable:t})=>({dimension:[t(c.LatLon),null]})))},
function _(e,i,r,c,k){c(),k("AdaptiveTicker",e(148).AdaptiveTicker),k("BasicTicker",e(147).BasicTicker),k("CategoricalTicker",e(141).CategoricalTicker),k("CompositeTicker",e(156).CompositeTicker),k("ContinuousTicker",e(149).ContinuousTicker),k("DatetimeTicker",e(155).DatetimeTicker),k("DaysTicker",e(157).DaysTicker),k("FixedTicker",e(169).FixedTicker),k("LogTicker",e(164).LogTicker),k("MercatorTicker",e(167).MercatorTicker),k("MonthsTicker",e(160).MonthsTicker),k("SingleIntervalTicker",e(158).SingleIntervalTicker),k("Ticker",e(130).Ticker),k("YearsTicker",e(161).YearsTicker),k("BinnedTicker",e(170).BinnedTicker)},
function _(r,t,e,i,n){var s;i();const _=r(149);class c extends _.ContinuousTicker{constructor(r){super(r)}get_ticks_no_defaults(r,t,e,i){return{major:this.ticks,minor:this.minor_ticks}}get_interval(r,t,e){return 0}get_min_interval(){return 0}get_max_interval(){return 0}}e.FixedTicker=c,s=c,c.__name__="FixedTicker",s.define((({Number:r,Array:t})=>({ticks:[t(r),[]],minor_ticks:[t(r),[]]})))},
function _(e,n,t,r,i){var o;r();const a=e(130),s=e(171),c=e(12);class m extends a.Ticker{constructor(e){super(e)}get_ticks(e,n,t,r){const{binning:i}=this.mapper.metrics,o=Math.max(0,(0,c.left_edge_index)(e,i)),a=Math.min((0,c.left_edge_index)(n,i)+1,i.length-1),s=[];for(let e=o;e<=a;e++)s.push(i[e]);const{num_major_ticks:m}=this,_=[],h="auto"==m?s.length:m,l=Math.max(1,Math.floor(s.length/h));for(let e=0;e<s.length;e+=l)_.push(s[e]);return{major:_,minor:[]}}}t.BinnedTicker=m,o=m,m.__name__="BinnedTicker",o.define((({Number:e,Ref:n,Or:t,Auto:r})=>({mapper:[n(s.ScanningColorMapper)],num_major_ticks:[t(e,r),8]})))},
function _(n,e,i,r,o){r();const t=n(172),a=n(12);class c extends t.ContinuousColorMapper{constructor(n){super(n)}cmap(n,e,i,r,o){if(n<o.binning[0])return i;if(n>o.binning[o.binning.length-1])return r;return e[(0,a.left_edge_index)(n,o.binning)]}}i.ScanningColorMapper=c,c.__name__="ScanningColorMapper"},
function _(t,e,o,n,s){var l;n();const c=t(173),i=t(175),a=t(9),h=t(8);class r extends c.ColorMapper{constructor(t){super(t),this._scan_data=null}connect_signals(){super.connect_signals();const t=()=>{for(const[t]of this.domain)this.connect(t.view.change,(()=>this.update_data())),this.connect(t.data_source.selected.change,(()=>this.update_data()))};this.connect(this.properties.domain.change,(()=>t())),t()}update_data(){const{domain:t,palette:e}=this,o=[...this._collect(t)];this._scan_data=this.scan(o,e.length),this.metrics_change.emit(),this.change.emit()}get metrics(){return null==this._scan_data&&this.update_data(),this._scan_data}*_collect(t){for(const[e,o]of t)for(const t of(0,h.isArray)(o)?o:[o]){let o=e.data_source.get_column(t);o=e.view.indices.select(o);const n=e.view.masked,s=e.data_source.selected.indices;let l;if(null!=n&&s.length>0?l=(0,a.intersection)([...n],s):null!=n?l=[...n]:s.length>0&&(l=s),null!=l&&(o=(0,a.map)(l,(t=>o[t]))),o.length>0&&!(0,h.isNumber)(o[0]))for(const t of o)yield*t;else yield*o}}_v_compute(t,e,o,n){const{nan_color:s}=n;let{low_color:l,high_color:c}=n;null==l&&(l=o[0]),null==c&&(c=o[o.length-1]);const{domain:i}=this,h=(0,a.is_empty)(i)?t:[...this._collect(i)];this._scan_data=this.scan(h,o.length),this.metrics_change.emit();for(let n=0,i=t.length;n<i;n++){const i=t[n];isNaN(i)?e[n]=s:e[n]=this.cmap(i,o,l,c,this._scan_data)}}_colors(t){return Object.assign(Object.assign({},super._colors(t)),{low_color:null!=this.low_color?t(this.low_color):void 0,high_color:null!=this.high_color?t(this.high_color):void 0})}}o.ContinuousColorMapper=r,l=r,r.__name__="ContinuousColorMapper",l.define((({Number:t,String:e,Ref:o,Color:n,Or:s,Tuple:l,Array:c,Nullable:a})=>({high:[a(t),null],low:[a(t),null],high_color:[a(n),null],low_color:[a(n),null],domain:[c(l(o(i.GlyphRenderer),s(e,c(e)))),[]]})))},
function _(e,r,t,n,o){var a;n();const c=e(174),i=e(15),_=e(24),l=e(22),s=e(27);function p(e){return(0,l.encode_rgba)((0,l.color2rgba)(e))}function u(e){const r=new Uint32Array(e.length);for(let t=0,n=e.length;t<n;t++)r[t]=p(e[t]);return r}t._convert_color=p,t._convert_palette=u;class h extends c.Mapper{constructor(e){super(e)}initialize(){super.initialize(),this.metrics_change=new i.Signal0(this,"metrics_change")}v_compute(e){const r=new Array(e.length);return this._v_compute(e,r,this.palette,this._colors((e=>e))),r}get rgba_mapper(){const e=this,r=u(this.palette),t=this._colors(p);return{v_compute(n){const o=new _.ColorArray(n.length);return e._v_compute(n,o,r,t),new Uint8ClampedArray((0,s.to_big_endian)(o).buffer)}}}_colors(e){return{nan_color:e(this.nan_color)}}}t.ColorMapper=h,a=h,h.__name__="ColorMapper",a.define((({Color:e,Array:r})=>({palette:[r(e)],nan_color:[e,"gray"]})))},
function _(r,e,n,s,o){s();const p=r(56);class t extends p.Transform{constructor(r){super(r)}compute(r){throw new Error("mapping single values is not supported")}}n.Mapper=t,t.__name__="Mapper"},
function _(e,t,i,s,l){var h;s();const n=e(176),o=e(177),a=e(186),c=e(187),_=e(189),r=e(179),d=e(70),p=e(190),g=e(24),u=e(12),y=e(13),m=e(113),v=e(67),f={fill:{},line:{}},w={fill:{fill_alpha:.3,fill_color:"grey"},line:{line_alpha:.3,line_color:"grey"}},b={fill:{fill_alpha:.2},line:{}},V={fill:{fill_alpha:.2},line:{}};class x extends n.DataRendererView{get glyph_view(){return this.glyph}async lazy_initialize(){var e;await super.lazy_initialize();const t=this.model.glyph;this.glyph=await this.build_glyph_view(t);const i="fill"in this.glyph.visuals,s="line"in this.glyph.visuals,l=Object.assign({},t.attributes);function h(e){const h=(0,y.clone)(l);return i&&(0,y.extend)(h,e.fill),s&&(0,y.extend)(h,e.line),new t.constructor(h)}function n(e,t){return t instanceof r.Glyph?t:h("auto"==t?e:{fill:{},line:{}})}delete l.id;let{selection_glyph:o,nonselection_glyph:a,hover_glyph:c,muted_glyph:_}=this.model;o=n(f,o),this.selection_glyph=await this.build_glyph_view(o),a=n(b,a),this.nonselection_glyph=await this.build_glyph_view(a),null!=c&&(this.hover_glyph=await this.build_glyph_view(c)),_=n(V,_),this.muted_glyph=await this.build_glyph_view(_);const d=n(w,"auto");this.decimated_glyph=await this.build_glyph_view(d),this.selection_glyph.set_base(this.glyph),this.nonselection_glyph.set_base(this.glyph),null===(e=this.hover_glyph)||void 0===e||e.set_base(this.glyph),this.muted_glyph.set_base(this.glyph),this.decimated_glyph.set_base(this.glyph),this.set_data()}async build_glyph_view(e){return(0,m.build_view)(e,{parent:this})}remove(){var e;this.glyph.remove(),this.selection_glyph.remove(),this.nonselection_glyph.remove(),null===(e=this.hover_glyph)||void 0===e||e.remove(),this.muted_glyph.remove(),this.decimated_glyph.remove(),super.remove()}connect_signals(){super.connect_signals();const e=()=>this.request_render(),t=()=>this.update_data();this.connect(this.model.change,e),this.connect(this.glyph.model.change,t),this.connect(this.selection_glyph.model.change,t),this.connect(this.nonselection_glyph.model.change,t),null!=this.hover_glyph&&this.connect(this.hover_glyph.model.change,t),this.connect(this.muted_glyph.model.change,t),this.connect(this.decimated_glyph.model.change,t),this.connect(this.model.data_source.change,t),this.connect(this.model.data_source.streaming,t),this.connect(this.model.data_source.patching,(e=>this.update_data(e))),this.connect(this.model.data_source.selected.change,e),this.connect(this.model.data_source._select,e),null!=this.hover_glyph&&this.connect(this.model.data_source.inspect,e),this.connect(this.model.properties.view.change,t),this.connect(this.model.view.properties.indices.change,t),this.connect(this.model.view.properties.masked.change,(()=>this.set_visuals())),this.connect(this.model.properties.visible.change,(()=>this.plot_view.invalidate_dataranges=!0));const{x_ranges:i,y_ranges:s}=this.plot_view.frame;for(const[,e]of i)e instanceof v.FactorRange&&this.connect(e.change,t);for(const[,e]of s)e instanceof v.FactorRange&&this.connect(e.change,t);const{transformchange:l,exprchange:h}=this.model.glyph;this.connect(l,t),this.connect(h,t)}_update_masked_indices(){const e=this.glyph.mask_data();return this.model.view.masked=e,e}update_data(e){this.set_data(e),this.request_render()}set_data(e){const t=this.model.data_source;this.all_indices=this.model.view.indices;const{all_indices:i}=this;this.glyph.set_data(t,i,e),this.set_visuals(),this._update_masked_indices();const{lod_factor:s}=this.plot_model,l=this.all_indices.count;this.decimated=new g.Indices(l);for(let e=0;e<l;e+=s)this.decimated.set(e);this.plot_view.invalidate_dataranges=!0}set_visuals(){var e;const t=this.model.data_source,{all_indices:i}=this;this.glyph.set_visuals(t,i),this.decimated_glyph.set_visuals(t,i),this.selection_glyph.set_visuals(t,i),this.nonselection_glyph.set_visuals(t,i),null===(e=this.hover_glyph)||void 0===e||e.set_visuals(t,i),this.muted_glyph.set_visuals(t,i)}get has_webgl(){return this.glyph.has_webgl}_render(){const e=this.has_webgl;this.glyph.map_data();const t=[...this.all_indices];let i=[...this._update_masked_indices()];const{ctx:s}=this.layer;s.save();const{selected:l}=this.model.data_source;let h;h=!l||l.is_empty()?[]:this.glyph instanceof o.LineView&&l.selected_glyph===this.glyph.model?this.model.view.convert_indices_from_subset(i):l.indices;const{inspected:n}=this.model.data_source,r=new Set((()=>!n||n.is_empty()?[]:n.selected_glyph?this.model.view.convert_indices_from_subset(i):n.indices.length>0?n.indices:Object.keys(n.multiline_indices).map((e=>parseInt(e))))()),d=(0,u.filter)(i,(e=>r.has(t[e]))),{lod_threshold:p}=this.plot_model;let g,y,m;if(null!=this.model.document&&this.model.document.interactive_duration()>0&&!e&&null!=p&&t.length>p?(i=[...this.decimated],g=this.decimated_glyph,y=this.decimated_glyph,m=this.selection_glyph):(g=this.model.muted?this.muted_glyph:this.glyph,y=this.nonselection_glyph,m=this.selection_glyph),null!=this.hover_glyph&&d.length){const e=new Set(i);for(const t of d)e.delete(t);i=[...e]}if(h.length){const e={};for(const t of h)e[t]=!0;const l=new Array,n=new Array;if(this.glyph instanceof o.LineView)for(const i of t)null!=e[i]?l.push(i):n.push(i);else for(const s of i)null!=e[t[s]]?l.push(s):n.push(s);y.render(s,n),m.render(s,l),null!=this.hover_glyph&&(this.glyph instanceof o.LineView?this.hover_glyph.render(s,this.model.view.convert_indices_from_subset(d)):this.hover_glyph.render(s,d))}else if(this.glyph instanceof o.LineView)this.hover_glyph&&d.length?this.hover_glyph.render(s,this.model.view.convert_indices_from_subset(d)):g.render(s,t);else if(this.glyph instanceof a.PatchView||this.glyph instanceof c.HAreaView||this.glyph instanceof _.VAreaView)if(0==n.selected_glyphs.length||null==this.hover_glyph)g.render(s,t);else for(const e of n.selected_glyphs)e==this.glyph.model&&this.hover_glyph.render(s,t);else g.render(s,i),this.hover_glyph&&d.length&&this.hover_glyph.render(s,d);s.restore()}draw_legend(e,t,i,s,l,h,n,o){0!=this.glyph.data_size&&(null==o&&(o=this.model.get_reference_point(h,n)),this.glyph.draw_legend_for_index(e,{x0:t,x1:i,y0:s,y1:l},o))}hit_test(e){if(!this.model.visible)return null;const t=this.glyph.hit_test(e);return null==t?null:this.model.view.convert_selection_from_subset(t)}}i.GlyphRendererView=x,x.__name__="GlyphRendererView";class G extends n.DataRenderer{constructor(e){super(e)}initialize(){super.initialize(),this.view.source!=this.data_source&&(this.view.source=this.data_source,this.view.compute_indices())}get_reference_point(e,t){if(null!=e){const i=this.data_source.get_column(e);if(null!=i)for(const[e,s]of Object.entries(this.view.indices_map))if(i[parseInt(e)]==t)return s}return 0}get_selection_manager(){return this.data_source.selection_manager}}i.GlyphRenderer=G,h=G,G.__name__="GlyphRenderer",h.prototype.default_view=x,h.define((({Boolean:e,Auto:t,Or:i,Ref:s,Null:l,Nullable:h})=>({data_source:[s(d.ColumnarDataSource)],view:[s(p.CDSView),e=>new p.CDSView({source:e.data_source})],glyph:[s(r.Glyph)],hover_glyph:[h(s(r.Glyph)),null],nonselection_glyph:[i(s(r.Glyph),t,l),"auto"],selection_glyph:[i(s(r.Glyph),t,l),"auto"],muted_glyph:[i(s(r.Glyph),t,l),"auto"],muted:[e,!1]})))},
function _(e,r,t,a,n){var s;a();const c=e(41);class _ extends c.RendererView{get xscale(){return this.coordinates.x_scale}get yscale(){return this.coordinates.y_scale}}t.DataRendererView=_,_.__name__="DataRendererView";class i extends c.Renderer{constructor(e){super(e)}get selection_manager(){return this.get_selection_manager()}}t.DataRenderer=i,s=i,i.__name__="DataRenderer",s.override({level:"glyph"})},
function _(e,t,i,s,n){s();const l=e(1);var _;const r=e(178),o=e(184),a=(0,l.__importStar)(e(48)),h=(0,l.__importStar)(e(185)),c=e(72);class d extends r.XYGlyphView{async lazy_initialize(){await super.lazy_initialize();const{webgl:t}=this.renderer.plot_view.canvas_view;if(null==t?void 0:t.regl_wrapper.has_webgl){const{LineGL:i}=await Promise.resolve().then((()=>(0,l.__importStar)(e(426))));this.glglyph=new i(t.regl_wrapper,this)}}_render(e,t,i){const{sx:s,sy:n}=null!=i?i:this;let l=null;const _=e=>null!=l&&e-l!=1;let r=!0;e.beginPath();for(const i of t){const t=s[i],o=n[i];isFinite(t+o)?r||_(i)?(e.moveTo(t,o),r=!1):e.lineTo(t,o):r=!0,l=i}this.visuals.line.set_value(e),e.stroke()}_hit_point(e){const t=new c.Selection,i={x:e.sx,y:e.sy};let s=9999;const n=Math.max(2,this.line_width.value/2);for(let e=0,l=this.sx.length-1;e<l;e++){const l={x:this.sx[e],y:this.sy[e]},_={x:this.sx[e+1],y:this.sy[e+1]},r=h.dist_to_segment(i,l,_);r<n&&r<s&&(s=r,t.add_to_selected_glyphs(this.model),t.view=this,t.line_indices=[e])}return t}_hit_span(e){const{sx:t,sy:i}=e,s=new c.Selection;let n,l;"v"==e.direction?(n=this.renderer.yscale.invert(i),l=this._y):(n=this.renderer.xscale.invert(t),l=this._x);for(let e=0,t=l.length-1;e<t;e++)(l[e]<=n&&n<=l[e+1]||l[e+1]<=n&&n<=l[e])&&(s.add_to_selected_glyphs(this.model),s.view=this,s.line_indices.push(e));return s}get_interpolation_hit(e,t){const[i,s,n,l]=[this._x[e],this._y[e],this._x[e+1],this._y[e+1]];return(0,o.line_interpolation)(this.renderer,t,i,s,n,l)}draw_legend_for_index(e,t,i){(0,o.generic_line_scalar_legend)(this.visuals,e,t)}}i.LineView=d,d.__name__="LineView";class p extends r.XYGlyph{constructor(e){super(e)}}i.Line=p,_=p,p.__name__="Line",_.prototype.default_view=d,_.mixins(a.LineScalar)},
function _(e,t,_,s,i){s();const n=e(1);var a;const o=e(78),c=(0,n.__importStar)(e(18)),p=e(179);class r extends p.GlyphView{_project_data(){o.inplace.project_xy(this._x,this._y)}_index_data(e){const{_x:t,_y:_,data_size:s}=this;for(let i=0;i<s;i++){const s=t[i],n=_[i];e.add_point(s,n)}}scenterxy(e){return[this.sx[e],this.sy[e]]}}_.XYGlyphView=r,r.__name__="XYGlyphView";class d extends p.Glyph{constructor(e){super(e)}}_.XYGlyph=d,a=d,d.__name__="XYGlyph",a.define((({})=>({x:[c.XCoordinateSpec,{field:"x"}],y:[c.YCoordinateSpec,{field:"y"}]})))},
function _(e,t,s,i,n){i();const r=e(1),a=(0,r.__importStar)(e(18)),o=(0,r.__importStar)(e(65)),_=(0,r.__importStar)(e(45)),l=e(42),c=e(53),h=e(19),d=e(24),u=e(8),f=e(180),p=e(12),g=e(26),y=e(181),x=e(67),v=e(72),{abs:b,ceil:m}=Math;class w extends l.View{constructor(){super(...arguments),this._index=null,this._data_size=null,this._nohit_warned=new Set}get renderer(){return this.parent}get has_webgl(){return null!=this.glglyph}get index(){const{_index:e}=this;if(null!=e)return e;throw new Error(`${this}.index_data() wasn't called`)}get data_size(){const{_data_size:e}=this;if(null!=e)return e;throw new Error(`${this}.set_data() wasn't called`)}initialize(){super.initialize(),this.visuals=new _.Visuals(this)}request_render(){this.parent.request_render()}get canvas(){return this.renderer.parent.canvas_view}render(e,t,s){var i;null!=this.glglyph&&(this.renderer.needs_webgl_blit=this.glglyph.render(e,t,null!==(i=this.base)&&void 0!==i?i:this),this.renderer.needs_webgl_blit)||this._render(e,t,null!=s?s:this.base)}has_finished(){return!0}notify_finished(){this.renderer.notify_finished()}_bounds(e){return e}bounds(){return this._bounds(this.index.bbox)}log_bounds(){const{x0:e,x1:t}=this.index.bounds(o.positive_x()),{y0:s,y1:i}=this.index.bounds(o.positive_y());return this._bounds({x0:e,y0:s,x1:t,y1:i})}get_anchor_point(e,t,[s,i]){switch(e){case"center":case"center_center":{const[e,n]=this.scenterxy(t,s,i);return{x:e,y:n}}default:return null}}scenterx(e,t,s){return this.scenterxy(e,t,s)[0]}scentery(e,t,s){return this.scenterxy(e,t,s)[1]}sdist(e,t,s,i="edge",n=!1){const r=t.length,a=new d.ScreenArray(r),o=e.s_compute;if("center"==i)for(let e=0;e<r;e++){const i=t[e],n=s.get(e)/2,r=o(i-n),_=o(i+n);a[e]=b(_-r)}else for(let e=0;e<r;e++){const i=t[e],n=o(i),r=o(i+s.get(e));a[e]=b(r-n)}return n&&(0,p.inplace_map)(a,(e=>m(e))),a}draw_legend_for_index(e,t,s){}hit_test(e){switch(e.type){case"point":if(null!=this._hit_point)return this._hit_point(e);break;case"span":if(null!=this._hit_span)return this._hit_span(e);break;case"rect":if(null!=this._hit_rect)return this._hit_rect(e);break;case"poly":if(null!=this._hit_poly)return this._hit_poly(e)}return this._nohit_warned.has(e.type)||(h.logger.debug(`'${e.type}' selection not available for ${this.model.type}`),this._nohit_warned.add(e.type)),null}_hit_rect_against_index(e){const{sx0:t,sx1:s,sy0:i,sy1:n}=e,[r,a]=this.renderer.coordinates.x_scale.r_invert(t,s),[o,_]=this.renderer.coordinates.y_scale.r_invert(i,n),l=[...this.index.indices({x0:r,x1:a,y0:o,y1:_})];return new v.Selection({indices:l})}_project_data(){}*_iter_visuals(){for(const e of this.visuals)for(const t of e)(t instanceof a.VectorSpec||t instanceof a.ScalarSpec)&&(yield t)}set_base(e){e!=this&&e instanceof this.constructor&&(this.base=e)}_configure(e,t){Object.defineProperty(this,(0,u.isString)(e)?e:e.attr,Object.assign({configurable:!0,enumerable:!0},t))}set_visuals(e,t){var s;for(const s of this._iter_visuals()){const{base:i}=this;if(null!=i){const e=i.model.properties[s.attr];if(null!=e&&(0,g.is_equal)(s.get_value(),e.get_value())){this._configure(s,{get:()=>i[`${s.attr}`]});continue}}const n=s.uniform(e).select(t);this._configure(s,{value:n})}for(const e of this.visuals)e.update();null===(s=this.glglyph)||void 0===s||s.set_visuals_changed()}set_data(e,t,s){var i;const{x_source:n,y_source:r}=this.renderer.coordinates,o=new Set(this._iter_visuals());this._data_size=t.count;for(const s of this.model)if((s instanceof a.VectorSpec||s instanceof a.ScalarSpec)&&!o.has(s))if(s instanceof a.BaseCoordinateSpec){const i=s.array(e);let o=t.select(i);const _="x"==s.dimension?n:r;if(_ instanceof x.FactorRange)if(s instanceof a.CoordinateSpec)o=_.v_synthetic(o);else if(s instanceof a.CoordinateSeqSpec)for(let e=0;e<o.length;e++)o[e]=_.v_synthetic(o[e]);let l;l=s instanceof a.CoordinateSeqSpec?f.RaggedArray.from(o,Float64Array):o,this._configure(`_${s.attr}`,{value:l})}else{const i=s.uniform(e).select(t);if(this._configure(s,{value:i}),s instanceof a.DistanceSpec){const e=i.is_Scalar()?i.value:(0,p.max)(i.array);this._configure(`max_${s.attr}`,{value:e})}}this.renderer.plot_view.model.use_map&&this._project_data(),this._set_data(null!=s?s:null),null===(i=this.glglyph)||void 0===i||i.set_data_changed(),this.index_data()}_set_data(e){}get _index_size(){return this.data_size}index_data(){const e=new y.SpatialIndex(this._index_size);this._index_data(e),e.finish(),this._index=e}mask_data(){return null==this._mask_data?d.Indices.all_set(this.data_size):this._mask_data()}map_data(){var e;const t=this,{x_scale:s,y_scale:i}=this.renderer.coordinates;for(const e of this.model)if(e instanceof a.BaseCoordinateSpec){const n="x"==e.dimension?s:i;let r=t[`_${e.attr}`];if(r instanceof f.RaggedArray){const e=n.v_compute(r.array);r=new f.RaggedArray(r.offsets,e)}else r=n.v_compute(r);this[`s${e.attr}`]=r}this._map_data(),null===(e=this.glglyph)||void 0===e||e.set_data_changed()}_map_data(){}}s.GlyphView=w,w.__name__="GlyphView";class S extends c.Model{constructor(e){super(e)}}s.Glyph=S,S.__name__="Glyph"},
function _(t,s,r,e,a){var n;e();const o=t(26),h=t(11);class i{constructor(t,s){this.offsets=t,this.array=s}[(n=Symbol.toStringTag,o.equals)](t,s){return s.arrays(this.offsets,t.offsets)&&s.arrays(this.array,t.array)}get length(){return this.offsets.length}clone(){return new i(this.offsets.slice(),this.array.slice())}static from(t,s){const r=t.length;let e=0;const a=(()=>{const s=new Uint32Array(r);for(let a=0;a<r;a++){const r=t[a].length;s[a]=e,e+=r}return e<256?new Uint8Array(s):e<65536?new Uint16Array(s):s})(),n=new s(e);for(let s=0;s<r;s++)n.set(t[s],a[s]);return new i(a,n)}*[Symbol.iterator](){const{offsets:t,length:s}=this;for(let r=0;r<s;r++)yield this.array.subarray(t[r],t[r+1])}_check_bounds(t){(0,h.assert)(0<=t&&t<this.length,`Out of bounds: 0 <= ${t} < ${this.length}`)}get(t){this._check_bounds(t);const{offsets:s}=this;return this.array.subarray(s[t],s[t+1])}set(t,s){this._check_bounds(t),this.array.set(s,this.offsets[t])}}r.RaggedArray=i,i.__name__="RaggedArray",i[n]="RaggedArray"},
function _(i,t,n,e,s){e();const d=(0,i(1).__importDefault)(i(182)),o=i(24),x=i(65);function h(i,t){let n=0,e=t.length-1;for(;n<e;){const s=n+e>>1;t[s]>i?e=s:n=s+1}return t[n]}class r extends d.default{get boxes(){return this._boxes}search_indices(i,t,n,e){if(this._pos!==this._boxes.length)throw new Error("Data not yet indexed - call index.finish().");let s=this._boxes.length-4;const d=[],x=new o.Indices(this.numItems);for(;void 0!==s;){const o=Math.min(s+4*this.nodeSize,h(s,this._levelBounds));for(let h=s;h<o;h+=4){const o=0|this._indices[h>>2],r=this._boxes[h+0],l=this._boxes[h+1],a=this._boxes[h+2],_=this._boxes[h+3];n<r||(e<l||i>a||t>_||(s<4*this.numItems?x.set(o):d.push(o)))}s=d.pop()}return x}}r.__name__="_FlatBush";class l{constructor(i){this.index=null,i>0&&(this.index=new r(i))}add_rect(i,t,n,e){var s;isFinite(i+t+n+e)?null===(s=this.index)||void 0===s||s.add(i,t,n,e):this.add_empty()}add_point(i,t){var n;isFinite(i+t)?null===(n=this.index)||void 0===n||n.add(i,t,i,t):this.add_empty()}add_empty(){var i;null===(i=this.index)||void 0===i||i.add(1/0,1/0,-1/0,-1/0)}finish(){var i;null===(i=this.index)||void 0===i||i.finish()}_normalize(i){let{x0:t,y0:n,x1:e,y1:s}=i;return t>e&&([t,e]=[e,t]),n>s&&([n,s]=[s,n]),{x0:t,y0:n,x1:e,y1:s}}get bbox(){if(null==this.index)return(0,x.empty)();{const{minX:i,minY:t,maxX:n,maxY:e}=this.index;return{x0:i,y0:t,x1:n,y1:e}}}indices(i){if(null==this.index)return new o.Indices(0);{const{x0:t,y0:n,x1:e,y1:s}=this._normalize(i);return this.index.search_indices(t,n,e,s)}}bounds(i){const t=(0,x.empty)();if(null==this.index)return t;const{boxes:n}=this.index;for(const e of this.indices(i)){const s=n[4*e+0],d=n[4*e+1],o=n[4*e+2],x=n[4*e+3];s>=i.x0&&s<t.x0&&(t.x0=s),o<=i.x1&&o>t.x1&&(t.x1=o),d>=i.y0&&d<t.y0&&(t.y0=d),x<=i.y1&&x>t.y1&&(t.y1=x)}return t}}n.SpatialIndex=l,l.__name__="SpatialIndex"},
function _(t,s,i,e,h){e();const n=(0,t(1).__importDefault)(t(183)),o=[Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array];class r{static from(t){if(!(t instanceof ArrayBuffer))throw new Error("Data must be an instance of ArrayBuffer.");const[s,i]=new Uint8Array(t,0,2);if(251!==s)throw new Error("Data does not appear to be in a Flatbush format.");if(i>>4!=3)throw new Error(`Got v${i>>4} data when expected v3.`);const[e]=new Uint16Array(t,2,1),[h]=new Uint32Array(t,4,1);return new r(h,e,o[15&i],t)}constructor(t,s=16,i=Float64Array,e){if(void 0===t)throw new Error("Missing required argument: numItems.");if(isNaN(t)||t<=0)throw new Error(`Unpexpected numItems value: ${t}.`);this.numItems=+t,this.nodeSize=Math.min(Math.max(+s,2),65535);let h=t,r=h;this._levelBounds=[4*h];do{h=Math.ceil(h/this.nodeSize),r+=h,this._levelBounds.push(4*r)}while(1!==h);this.ArrayType=i||Float64Array,this.IndexArrayType=r<16384?Uint16Array:Uint32Array;const a=o.indexOf(this.ArrayType),_=4*r*this.ArrayType.BYTES_PER_ELEMENT;if(a<0)throw new Error(`Unexpected typed array class: ${i}.`);e&&e instanceof ArrayBuffer?(this.data=e,this._boxes=new this.ArrayType(this.data,8,4*r),this._indices=new this.IndexArrayType(this.data,8+_,r),this._pos=4*r,this.minX=this._boxes[this._pos-4],this.minY=this._boxes[this._pos-3],this.maxX=this._boxes[this._pos-2],this.maxY=this._boxes[this._pos-1]):(this.data=new ArrayBuffer(8+_+r*this.IndexArrayType.BYTES_PER_ELEMENT),this._boxes=new this.ArrayType(this.data,8,4*r),this._indices=new this.IndexArrayType(this.data,8+_,r),this._pos=0,this.minX=1/0,this.minY=1/0,this.maxX=-1/0,this.maxY=-1/0,new Uint8Array(this.data,0,2).set([251,48+a]),new Uint16Array(this.data,2,1)[0]=s,new Uint32Array(this.data,4,1)[0]=t),this._queue=new n.default}add(t,s,i,e){const h=this._pos>>2;return this._indices[h]=h,this._boxes[this._pos++]=t,this._boxes[this._pos++]=s,this._boxes[this._pos++]=i,this._boxes[this._pos++]=e,t<this.minX&&(this.minX=t),s<this.minY&&(this.minY=s),i>this.maxX&&(this.maxX=i),e>this.maxY&&(this.maxY=e),h}finish(){if(this._pos>>2!==this.numItems)throw new Error(`Added ${this._pos>>2} items when expected ${this.numItems}.`);if(this.numItems<=this.nodeSize)return this._boxes[this._pos++]=this.minX,this._boxes[this._pos++]=this.minY,this._boxes[this._pos++]=this.maxX,void(this._boxes[this._pos++]=this.maxY);const t=this.maxX-this.minX,s=this.maxY-this.minY,i=new Uint32Array(this.numItems);for(let e=0;e<this.numItems;e++){let h=4*e;const n=this._boxes[h++],o=this._boxes[h++],r=this._boxes[h++],a=this._boxes[h++],_=Math.floor(65535*((n+r)/2-this.minX)/t),x=Math.floor(65535*((o+a)/2-this.minY)/s);i[e]=m(_,x)}x(i,this._boxes,this._indices,0,this.numItems-1,this.nodeSize);for(let t=0,s=0;t<this._levelBounds.length-1;t++){const i=this._levelBounds[t];for(;s<i;){const t=s;let e=1/0,h=1/0,n=-1/0,o=-1/0;for(let t=0;t<this.nodeSize&&s<i;t++)e=Math.min(e,this._boxes[s++]),h=Math.min(h,this._boxes[s++]),n=Math.max(n,this._boxes[s++]),o=Math.max(o,this._boxes[s++]);this._indices[this._pos>>2]=t,this._boxes[this._pos++]=e,this._boxes[this._pos++]=h,this._boxes[this._pos++]=n,this._boxes[this._pos++]=o}}}search(t,s,i,e,h){if(this._pos!==this._boxes.length)throw new Error("Data not yet indexed - call index.finish().");let n=this._boxes.length-4;const o=[],r=[];for(;void 0!==n;){const a=Math.min(n+4*this.nodeSize,_(n,this._levelBounds));for(let _=n;_<a;_+=4){const a=0|this._indices[_>>2];i<this._boxes[_]||(e<this._boxes[_+1]||t>this._boxes[_+2]||s>this._boxes[_+3]||(n<4*this.numItems?(void 0===h||h(a))&&r.push(a):o.push(a)))}n=o.pop()}return r}neighbors(t,s,i=1/0,e=1/0,h){if(this._pos!==this._boxes.length)throw new Error("Data not yet indexed - call index.finish().");let n=this._boxes.length-4;const o=this._queue,r=[],x=e*e;for(;void 0!==n;){const e=Math.min(n+4*this.nodeSize,_(n,this._levelBounds));for(let i=n;i<e;i+=4){const e=0|this._indices[i>>2],r=a(t,this._boxes[i],this._boxes[i+2]),_=a(s,this._boxes[i+1],this._boxes[i+3]),x=r*r+_*_;n<4*this.numItems?(void 0===h||h(e))&&o.push(-e-1,x):o.push(e,x)}for(;o.length&&o.peek()<0;){if(o.peekValue()>x)return o.clear(),r;if(r.push(-o.pop()-1),r.length===i)return o.clear(),r}n=o.pop()}return o.clear(),r}}function a(t,s,i){return t<s?s-t:t<=i?0:t-i}function _(t,s){let i=0,e=s.length-1;for(;i<e;){const h=i+e>>1;s[h]>t?e=h:i=h+1}return s[i]}function x(t,s,i,e,h,n){if(Math.floor(e/n)>=Math.floor(h/n))return;const o=t[e+h>>1];let r=e-1,a=h+1;for(;;){do{r++}while(t[r]<o);do{a--}while(t[a]>o);if(r>=a)break;d(t,s,i,r,a)}x(t,s,i,e,a,n),x(t,s,i,a+1,h,n)}function d(t,s,i,e,h){const n=t[e];t[e]=t[h],t[h]=n;const o=4*e,r=4*h,a=s[o],_=s[o+1],x=s[o+2],d=s[o+3];s[o]=s[r],s[o+1]=s[r+1],s[o+2]=s[r+2],s[o+3]=s[r+3],s[r]=a,s[r+1]=_,s[r+2]=x,s[r+3]=d;const m=i[e];i[e]=i[h],i[h]=m}function m(t,s){let i=t^s,e=65535^i,h=65535^(t|s),n=t&(65535^s),o=i|e>>1,r=i>>1^i,a=h>>1^e&n>>1^h,_=i&h>>1^n>>1^n;i=o,e=r,h=a,n=_,o=i&i>>2^e&e>>2,r=i&e>>2^e&(i^e)>>2,a^=i&h>>2^e&n>>2,_^=e&h>>2^(i^e)&n>>2,i=o,e=r,h=a,n=_,o=i&i>>4^e&e>>4,r=i&e>>4^e&(i^e)>>4,a^=i&h>>4^e&n>>4,_^=e&h>>4^(i^e)&n>>4,i=o,e=r,h=a,n=_,a^=i&h>>8^e&n>>8,_^=e&h>>8^(i^e)&n>>8,i=a^a>>1,e=_^_>>1;let x=t^s,d=e|65535^(x|i);return x=16711935&(x|x<<8),x=252645135&(x|x<<4),x=858993459&(x|x<<2),x=1431655765&(x|x<<1),d=16711935&(d|d<<8),d=252645135&(d|d<<4),d=858993459&(d|d<<2),d=1431655765&(d|d<<1),(d<<1|x)>>>0}i.default=r},
function _(s,t,i,h,e){h();i.default=class{constructor(){this.ids=[],this.values=[],this.length=0}clear(){this.length=0}push(s,t){let i=this.length++;for(this.ids[i]=s,this.values[i]=t;i>0;){const s=i-1>>1,h=this.values[s];if(t>=h)break;this.ids[i]=this.ids[s],this.values[i]=h,i=s}this.ids[i]=s,this.values[i]=t}pop(){if(0===this.length)return;const s=this.ids[0];if(this.length--,this.length>0){const s=this.ids[0]=this.ids[this.length],t=this.values[0]=this.values[this.length],i=this.length>>1;let h=0;for(;h<i;){let s=1+(h<<1);const i=s+1;let e=this.ids[s],l=this.values[s];const n=this.values[i];if(i<this.length&&n<l&&(s=i,e=this.ids[i],l=n),l>=t)break;this.ids[h]=e,this.values[h]=l,h=s}this.ids[h]=s,this.values[h]=t}return s}peek(){if(0!==this.length)return this.ids[0]}peekValue(){if(0!==this.length)return this.values[0]}}},
function _(e,n,a,t,i){t();const l=(0,e(1).__importStar)(e(185));function r(e,n,{x0:a,x1:t,y0:i,y1:l},r){n.save(),n.beginPath(),n.moveTo(a,(i+l)/2),n.lineTo(t,(i+l)/2),e.line.apply(n,r),n.restore()}function c(e,n,{x0:a,x1:t,y0:i,y1:l},r){var c,o;const _=.1*Math.abs(t-a),s=.1*Math.abs(l-i),y=a+_,p=t-_,g=i+s,h=l-s;n.beginPath(),n.rect(y,g,p-y,h-g),e.fill.apply(n,r),null===(c=e.hatch)||void 0===c||c.apply(n,r),null===(o=e.line)||void 0===o||o.apply(n,r)}a.generic_line_scalar_legend=function(e,n,{x0:a,x1:t,y0:i,y1:l}){n.save(),n.beginPath(),n.moveTo(a,(i+l)/2),n.lineTo(t,(i+l)/2),e.line.apply(n),n.restore()},a.generic_line_vector_legend=r,a.generic_line_legend=r,a.generic_area_scalar_legend=function(e,n,{x0:a,x1:t,y0:i,y1:l}){var r,c;const o=.1*Math.abs(t-a),_=.1*Math.abs(l-i),s=a+o,y=t-o,p=i+_,g=l-_;n.beginPath(),n.rect(s,p,y-s,g-p),e.fill.apply(n),null===(r=e.hatch)||void 0===r||r.apply(n),null===(c=e.line)||void 0===c||c.apply(n)},a.generic_area_vector_legend=c,a.generic_area_legend=c,a.line_interpolation=function(e,n,a,t,i,r){const{sx:c,sy:o}=n;let _,s,y,p;"point"==n.type?([y,p]=e.yscale.r_invert(o-1,o+1),[_,s]=e.xscale.r_invert(c-1,c+1)):"v"==n.direction?([y,p]=e.yscale.r_invert(o,o),[_,s]=[Math.min(a-1,i-1),Math.max(a+1,i+1)]):([_,s]=e.xscale.r_invert(c,c),[y,p]=[Math.min(t-1,r-1),Math.max(t+1,r+1)]);const{x:g,y:h}=l.check_2_segments_intersect(_,y,s,p,a,t,i,r);return[g,h]}},
function _(t,n,e,i,r){function s(t,n){return(t.x-n.x)**2+(t.y-n.y)**2}function o(t,n,e){const i=s(n,e);if(0==i)return s(t,n);const r=((t.x-n.x)*(e.x-n.x)+(t.y-n.y)*(e.y-n.y))/i;if(r<0)return s(t,n);if(r>1)return s(t,e);return s(t,{x:n.x+r*(e.x-n.x),y:n.y+r*(e.y-n.y)})}i(),e.point_in_poly=function(t,n,e,i){let r=!1,s=e[e.length-1],o=i[i.length-1];for(let u=0;u<e.length;u++){const c=e[u],_=i[u];o<n!=_<n&&s+(n-o)/(_-o)*(c-s)<t&&(r=!r),s=c,o=_}return r},e.point_in_ellipse=function(t,n,e,i,r,s,o){return((Math.cos(e)/r)**2+(Math.sin(e)/i)**2)*(t-s)**2+2*Math.cos(e)*Math.sin(e)*((1/r)**2-(1/i)**2)*(t-s)*(n-o)+((Math.cos(e)/i)**2+(Math.sin(e)/r)**2)*(n-o)**2<=1},e.dist_2_pts=s,e.dist_to_segment_squared=o,e.dist_to_segment=function(t,n,e){return Math.sqrt(o(t,n,e))},e.check_2_segments_intersect=function(t,n,e,i,r,s,o,u){const c=(u-s)*(e-t)-(o-r)*(i-n);if(0==c)return{hit:!1,x:null,y:null};{let _=n-s,h=t-r;const l=(e-t)*_-(i-n)*h;_=((o-r)*_-(u-s)*h)/c,h=l/c;return{hit:_>0&&_<1&&h>0&&h<1,x:t+_*(e-t),y:n+_*(i-n)}}}},
function _(t,s,e,i,a){i();const l=t(1);var n;const _=t(178),o=t(184),c=(0,l.__importStar)(t(185)),h=(0,l.__importStar)(t(48)),r=t(72);class p extends _.XYGlyphView{_render(t,s,e){const{sx:i,sy:a}=null!=e?e:this;let l=!0;t.beginPath();for(const e of s){const s=i[e],n=a[e];isFinite(s+n)?l?(t.moveTo(s,n),l=!1):t.lineTo(s,n):(t.closePath(),l=!0)}t.closePath(),this.visuals.fill.apply(t),this.visuals.hatch.apply(t),this.visuals.line.apply(t)}draw_legend_for_index(t,s,e){(0,o.generic_area_scalar_legend)(this.visuals,t,s)}_hit_point(t){const s=new r.Selection;return c.point_in_poly(t.sx,t.sy,this.sx,this.sy)&&(s.add_to_selected_glyphs(this.model),s.view=this),s}}e.PatchView=p,p.__name__="PatchView";class d extends _.XYGlyph{constructor(t){super(t)}}e.Patch=d,n=d,d.__name__="Patch",n.prototype.default_view=p,n.mixins([h.LineScalar,h.FillScalar,h.HatchScalar])},
function _(t,s,e,i,n){i();const h=t(1);var r;const a=t(188),_=(0,h.__importStar)(t(185)),o=(0,h.__importStar)(t(18)),l=t(72);class c extends a.AreaView{_index_data(t){const{min:s,max:e}=Math,{data_size:i}=this;for(let n=0;n<i;n++){const i=this._x1[n],h=this._x2[n],r=this._y[n];t.add_rect(s(i,h),r,e(i,h),r)}}_render(t,s,e){const{sx1:i,sx2:n,sy:h}=null!=e?e:this;t.beginPath();for(let s=0,e=i.length;s<e;s++)t.lineTo(i[s],h[s]);for(let s=n.length-1;s>=0;s--)t.lineTo(n[s],h[s]);t.closePath(),this.visuals.fill.apply(t),this.visuals.hatch.apply(t)}_hit_point(t){const s=this.sy.length,e=new l.Selection;for(let i=0,n=s-1;i<n;i++){const s=[this.sx1[i],this.sx1[i+1],this.sx2[i+1],this.sx2[i]],n=[this.sy[i],this.sy[i+1],this.sy[i+1],this.sy[i]];if(_.point_in_poly(t.sx,t.sy,s,n)){e.add_to_selected_glyphs(this.model),e.view=this,e.line_indices=[i];break}}return e}scenterxy(t){return[(this.sx1[t]+this.sx2[t])/2,this.sy[t]]}_map_data(){this.sx1=this.renderer.xscale.v_compute(this._x1),this.sx2=this.renderer.xscale.v_compute(this._x2),this.sy=this.renderer.yscale.v_compute(this._y)}}e.HAreaView=c,c.__name__="HAreaView";class x extends a.Area{constructor(t){super(t)}}e.HArea=x,r=x,x.__name__="HArea",r.prototype.default_view=c,r.define((({})=>({x1:[o.XCoordinateSpec,{field:"x1"}],x2:[o.XCoordinateSpec,{field:"x2"}],y:[o.YCoordinateSpec,{field:"y"}]})))},
function _(e,a,r,_,s){_();const n=e(1);var c;const i=e(179),l=e(184),t=(0,n.__importStar)(e(48));class o extends i.GlyphView{draw_legend_for_index(e,a,r){(0,l.generic_area_scalar_legend)(this.visuals,e,a)}}r.AreaView=o,o.__name__="AreaView";class d extends i.Glyph{constructor(e){super(e)}}r.Area=d,c=d,d.__name__="Area",c.mixins([t.FillScalar,t.HatchScalar])},
function _(t,s,e,i,n){i();const h=t(1);var r;const a=t(188),_=(0,h.__importStar)(t(185)),o=(0,h.__importStar)(t(18)),l=t(72);class c extends a.AreaView{_index_data(t){const{min:s,max:e}=Math,{data_size:i}=this;for(let n=0;n<i;n++){const i=this._x[n],h=this._y1[n],r=this._y2[n];t.add_rect(i,s(h,r),i,e(h,r))}}_render(t,s,e){const{sx:i,sy1:n,sy2:h}=null!=e?e:this;t.beginPath();for(let s=0,e=n.length;s<e;s++)t.lineTo(i[s],n[s]);for(let s=h.length-1;s>=0;s--)t.lineTo(i[s],h[s]);t.closePath(),this.visuals.fill.apply(t),this.visuals.hatch.apply(t)}scenterxy(t){return[this.sx[t],(this.sy1[t]+this.sy2[t])/2]}_hit_point(t){const s=this.sx.length,e=new l.Selection;for(let i=0,n=s-1;i<n;i++){const s=[this.sx[i],this.sx[i+1],this.sx[i+1],this.sx[i]],n=[this.sy1[i],this.sy1[i+1],this.sy2[i+1],this.sy2[i]];if(_.point_in_poly(t.sx,t.sy,s,n)){e.add_to_selected_glyphs(this.model),e.view=this,e.line_indices=[i];break}}return e}_map_data(){this.sx=this.renderer.xscale.v_compute(this._x),this.sy1=this.renderer.yscale.v_compute(this._y1),this.sy2=this.renderer.yscale.v_compute(this._y2)}}e.VAreaView=c,c.__name__="VAreaView";class y extends a.Area{constructor(t){super(t)}}e.VArea=y,r=y,y.__name__="VArea",r.prototype.default_view=c,r.define((({})=>({x:[o.XCoordinateSpec,{field:"x"}],y1:[o.YCoordinateSpec,{field:"y1"}],y2:[o.YCoordinateSpec,{field:"y2"}]})))},
function _(e,i,s,t,n){var c;t();const o=e(53),r=e(24),u=e(191),_=e(70);class a extends o.Model{constructor(e){super(e)}initialize(){super.initialize(),this.compute_indices()}connect_signals(){super.connect_signals(),this.connect(this.properties.filters.change,(()=>this.compute_indices()));const e=()=>{const e=()=>this.compute_indices();null!=this.source&&(this.connect(this.source.change,e),this.source instanceof _.ColumnarDataSource&&(this.connect(this.source.streaming,e),this.connect(this.source.patching,e)))};let i=null!=this.source;i?e():this.connect(this.properties.source.change,(()=>{i||(e(),i=!0)}))}compute_indices(){var e;const{source:i}=this;if(null==i)return;const s=null!==(e=i.get_length())&&void 0!==e?e:1,t=r.Indices.all_set(s);for(const e of this.filters)t.intersect(e.compute_indices(i));this.indices=t,this._indices=[...t],this.indices_map_to_subset()}indices_map_to_subset(){this.indices_map={};for(let e=0;e<this._indices.length;e++)this.indices_map[this._indices[e]]=e}convert_selection_from_subset(e){return e.map((e=>this._indices[e]))}convert_selection_to_subset(e){return e.map((e=>this.indices_map[e]))}convert_indices_from_subset(e){return e.map((e=>this._indices[e]))}}s.CDSView=a,c=a,a.__name__="CDSView",c.define((({Array:e,Ref:i})=>({filters:[e(i(u.Filter)),[]],source:[i(_.ColumnarDataSource)]}))),c.internal((({Int:e,Dict:i,Ref:s,Nullable:t})=>({indices:[s(r.Indices)],indices_map:[i(e),{}],masked:[t(s(r.Indices)),null]})))},
function _(e,t,n,s,c){s();const o=e(53);class r extends o.Model{constructor(e){super(e)}}n.Filter=r,r.__name__="Filter"},
function _(t,r,a,e,c){e(),c("BasicTickFormatter",t(146).BasicTickFormatter),c("CategoricalTickFormatter",t(142).CategoricalTickFormatter),c("DatetimeTickFormatter",t(150).DatetimeTickFormatter),c("FuncTickFormatter",t(193).FuncTickFormatter),c("LogTickFormatter",t(163).LogTickFormatter),c("MercatorTickFormatter",t(166).MercatorTickFormatter),c("NumeralTickFormatter",t(194).NumeralTickFormatter),c("PrintfTickFormatter",t(195).PrintfTickFormatter),c("TickFormatter",t(131).TickFormatter)},
function _(t,e,n,s,r){var c;s();const i=t(131),a=t(13),u=t(34);class o extends i.TickFormatter{constructor(t){super(t)}get names(){return(0,a.keys)(this.args)}get values(){return(0,a.values)(this.args)}_make_func(){const t=(0,u.use_strict)(this.code);return new Function("tick","index","ticks",...this.names,t)}doFormat(t,e){const n=this._make_func().bind({});return t.map(((t,e,s)=>`${n(t,e,s,...this.values)}`))}}n.FuncTickFormatter=o,c=o,o.__name__="FuncTickFormatter",c.define((({Unknown:t,String:e,Dict:n})=>({args:[n(t),{}],code:[e,""]})))},
function _(r,n,t,o,e){o();var a;const u=(0,r(1).__importStar)(r(153)),c=r(131),i=r(20);class s extends c.TickFormatter{constructor(r){super(r)}get _rounding_fn(){switch(this.rounding){case"round":case"nearest":return Math.round;case"floor":case"rounddown":return Math.floor;case"ceil":case"roundup":return Math.ceil}}doFormat(r,n){const{format:t,language:o,_rounding_fn:e}=this;return r.map((r=>u.format(r,t,o,e)))}}t.NumeralTickFormatter=s,a=s,s.__name__="NumeralTickFormatter",a.define((({String:r})=>({format:[r,"0,0"],language:[r,"en"],rounding:[i.RoundingFunction,"round"]})))},
function _(t,r,n,o,a){var e;o();const i=t(131),s=t(152);class c extends i.TickFormatter{constructor(t){super(t)}doFormat(t,r){return t.map((t=>(0,s.sprintf)(this.format,t)))}}n.PrintfTickFormatter=c,e=c,c.__name__="PrintfTickFormatter",e.define((({String:t})=>({format:[t,"%s"]})))},
function _(r,o,a,p,e){p(),e("CategoricalColorMapper",r(197).CategoricalColorMapper),e("CategoricalMarkerMapper",r(199).CategoricalMarkerMapper),e("CategoricalPatternMapper",r(200).CategoricalPatternMapper),e("ContinuousColorMapper",r(172).ContinuousColorMapper),e("ColorMapper",r(173).ColorMapper),e("LinearColorMapper",r(201).LinearColorMapper),e("LogColorMapper",r(202).LogColorMapper),e("ScanningColorMapper",r(171).ScanningColorMapper),e("EqHistColorMapper",r(203).EqHistColorMapper)},
function _(t,o,r,a,e){var c;a();const s=t(198),l=t(173),n=t(67);class _ extends l.ColorMapper{constructor(t){super(t)}_v_compute(t,o,r,{nan_color:a}){(0,s.cat_v_compute)(t,this.factors,r,o,this.start,this.end,a)}}r.CategoricalColorMapper=_,c=_,_.__name__="CategoricalColorMapper",c.define((({Number:t,Nullable:o})=>({factors:[n.FactorSeq],start:[t,0],end:[o(t),null]})))},
function _(n,t,e,l,i){l();const c=n(12),u=n(8);function f(n,t){if(n.length!=t.length)return!1;for(let e=0,l=n.length;e<l;e++)if(n[e]!==t[e])return!1;return!0}e._cat_equals=f,e.cat_v_compute=function(n,t,e,l,i,o,r){const _=n.length;for(let g=0;g<_;g++){let _,s,h=n[g];(0,u.isString)(h)?_=(0,c.index_of)(t,h):(null!=i?h=null!=o?h.slice(i,o):h.slice(i):null!=o&&(h=h.slice(0,o)),_=1==h.length?(0,c.index_of)(t,h[0]):(0,c.find_index)(t,(n=>f(n,h)))),s=_<0||_>=e.length?r:e[_],l[g]=s}}},
function _(e,r,a,t,s){var c;t();const l=e(198),n=e(67),u=e(174),o=e(20);class p extends u.Mapper{constructor(e){super(e)}v_compute(e){const r=new Array(e.length);return(0,l.cat_v_compute)(e,this.factors,this.markers,r,this.start,this.end,this.default_value),r}}a.CategoricalMarkerMapper=p,c=p,p.__name__="CategoricalMarkerMapper",c.define((({Number:e,Array:r,Nullable:a})=>({factors:[n.FactorSeq],markers:[r(o.MarkerType)],start:[e,0],end:[a(e),null],default_value:[o.MarkerType,"circle"]})))},
function _(t,e,a,r,n){var s;r();const c=t(198),l=t(67),p=t(174),u=t(20);class o extends p.Mapper{constructor(t){super(t)}v_compute(t){const e=new Array(t.length);return(0,c.cat_v_compute)(t,this.factors,this.patterns,e,this.start,this.end,this.default_value),e}}a.CategoricalPatternMapper=o,s=o,o.__name__="CategoricalPatternMapper",s.define((({Number:t,Array:e,Nullable:a})=>({factors:[l.FactorSeq],patterns:[e(u.HatchPatternType)],start:[t,0],end:[a(t),null],default_value:[u.HatchPatternType," "]})))},
function _(n,r,o,t,a){t();const e=n(172),i=n(12);class s extends e.ContinuousColorMapper{constructor(n){super(n)}scan(n,r){const o=null!=this.low?this.low:(0,i.min)(n),t=null!=this.high?this.high:(0,i.max)(n);return{max:t,min:o,norm_factor:1/(t-o),normed_interval:1/r}}cmap(n,r,o,t,a){const e=r.length-1;if(n==a.max)return r[e];const i=(n-a.min)*a.norm_factor,s=Math.floor(i/a.normed_interval);return s<0?o:s>e?t:r[s]}}o.LinearColorMapper=s,s.__name__="LinearColorMapper"},
function _(o,t,n,r,l){r();const a=o(172),s=o(12);class e extends a.ContinuousColorMapper{constructor(o){super(o)}scan(o,t){const n=null!=this.low?this.low:(0,s.min)(o),r=null!=this.high?this.high:(0,s.max)(o);return{max:r,min:n,scale:t/(Math.log(r)-Math.log(n))}}cmap(o,t,n,r,l){const a=t.length-1;if(o>l.max)return r;if(o==l.max)return t[a];if(o<l.min)return n;const s=Math.log(o)-Math.log(l.min);let e=Math.floor(s*l.scale);return e>a&&(e=a),t[e]}}n.LogColorMapper=e,e.__name__="LogColorMapper"},
function _(e,n,s,t,l){var i;t();const r=e(171),o=e(12),c=e(9);class a extends r.ScanningColorMapper{constructor(e){super(e)}scan(e,n){let s=null!=this.low?this.low:(0,o.min)(e);const t=null!=this.high?this.high:(0,o.max)(e),l=this.bins,i=(0,c.linspace)(s,t,l+1),r=(0,o.bin_counts)(e,i);let a=0;for(let e=0;e<l;e++)0!=r[e]&&a++;const h=new Array(a+1),_=new Array(a+1);for(let e=0,n=1;e<l;e++)0!=r[e]&&(h[n]=r[e],_[n]=(i[e]+i[e+1])/2,n++);h[0]=0,_[0]=2*_[1]-_[a];const p=(0,c.cumsum)(h),u=p[1],m=p[a]-u;for(let e=1;e<=a;e++)p[e]=(p[e]-u)/m;p[0]=-1;let f=0;if(this.rescale_discrete_levels){const e=-.5/98,n=e*a+(1.5-2*e);n>1&&(f=1-n)}const d=(0,c.linspace)(f,1,n+1),g=(0,o.interpolate)(d,p,_);return this.rescale_discrete_levels?s=g[0]:g[0]=s,g[g.length-1]=t,{min:s,max:t,binning:g}}}s.EqHistColorMapper=a,i=a,a.__name__="EqHistColorMapper",i.define((({Boolean:e,Int:n})=>({bins:[n,65536],rescale_discrete_levels:[e,!1]})))},
function _(a,e,l,c,n){c(),n("CategoricalScale",a(62).CategoricalScale),n("ContinuousScale",a(60).ContinuousScale),n("LinearScale",a(59).LinearScale),n("LinearInterpolationScale",a(205).LinearInterpolationScale),n("LogScale",a(61).LogScale),n("Scale",a(55).Scale)},
function _(e,r,n,t,a){var i;t();const s=e(55),o=e(59),c=e(12);class _ extends s.Scale{constructor(e){super(e)}connect_signals(){super.connect_signals();const{source_range:e,target_range:r}=this.properties;this.on_change([e,r],(()=>{this.linear_scale=new o.LinearScale({source_range:this.source_range,target_range:this.target_range})}))}get s_compute(){throw new Error("not implemented")}get s_invert(){throw new Error("not implemented")}compute(e){return e}v_compute(e){const{binning:r}=this,{start:n,end:t}=this.source_range,a=n,i=t,s=r.length,o=(t-n)/(s-1),_=new Float64Array(s);for(let e=0;e<s;e++)_[e]=n+e*o;const l=(0,c.map)(e,(e=>{if(e<a)return a;if(e>i)return i;const n=(0,c.left_edge_index)(e,r);if(-1==n)return a;if(n>=s-1)return i;const t=r[n],o=(e-t)/(r[n+1]-t),l=_[n];return l+o*(_[n+1]-l)}));return this.linear_scale.v_compute(l)}invert(e){return e}v_invert(e){return new Float64Array(e)}}n.LinearInterpolationScale=_,i=_,_.__name__="LinearInterpolationScale",i.internal((({Arrayable:e,Ref:r})=>({binning:[e],linear_scale:[r(o.LinearScale),e=>new o.LinearScale({source_range:e.source_range,target_range:e.target_range})]})))},
function _(a,n,e,g,R){g(),R("DataRange",a(64).DataRange),R("DataRange1d",a(63).DataRange1d),R("FactorRange",a(67).FactorRange),R("Range",a(57).Range),R("Range1d",a(58).Range1d)},
function _(a,o,i,t,e){t();var n=a(124);e("Sizeable",n.Sizeable),e("SizingPolicy",n.SizingPolicy);var c=a(125);e("Layoutable",c.Layoutable),e("LayoutItem",c.LayoutItem);var r=a(208);e("HStack",r.HStack),e("VStack",r.VStack);var l=a(209);e("Grid",l.Grid),e("Row",l.Row),e("Column",l.Column);var S=a(210);e("ContentBox",S.ContentBox),e("VariadicBox",S.VariadicBox)},
function _(t,e,h,i,r){i();const n=t(125),o=t(65);class s extends n.Layoutable{constructor(){super(...arguments),this.children=[]}*[Symbol.iterator](){yield*this.children}}h.Stack=s,s.__name__="Stack";class c extends s{_measure(t){let e=0,h=0;for(const t of this.children){const i=t.measure({width:0,height:0});e+=i.width,h=Math.max(h,i.height)}return{width:e,height:h}}_set_geometry(t,e){super._set_geometry(t,e);const h=this.absolute?t.top:0;let i=this.absolute?t.left:0;const{height:r}=t;for(const t of this.children){const{width:e}=t.measure({width:0,height:0});t.set_geometry(new o.BBox({left:i,width:e,top:h,height:r})),i+=e}}}h.HStack=c,c.__name__="HStack";class a extends s{_measure(t){let e=0,h=0;for(const t of this.children){const i=t.measure({width:0,height:0});e=Math.max(e,i.width),h+=i.height}return{width:e,height:h}}_set_geometry(t,e){super._set_geometry(t,e);const h=this.absolute?t.left:0;let i=this.absolute?t.top:0;const{width:r}=t;for(const t of this.children){const{height:e}=t.measure({width:0,height:0});t.set_geometry(new o.BBox({top:i,height:e,left:h,width:r})),i+=e}}}h.VStack=a,a.__name__="VStack";class l extends n.Layoutable{constructor(){super(...arguments),this.children=[]}*[Symbol.iterator](){yield*this.children}_measure(t){const{width_policy:e,height_policy:h}=this.sizing,{min:i,max:r}=Math;let n=0,o=0;for(const e of this.children){const{width:h,height:i}=e.measure(t);n=r(n,h),o=r(o,i)}return{width:(()=>{const{width:h}=this.sizing;if(t.width==1/0)return"fixed"==e&&null!=h?h:n;switch(e){case"fixed":return null!=h?h:n;case"min":return n;case"fit":return null!=h?i(t.width,h):t.width;case"max":return null!=h?r(t.width,h):t.width}})(),height:(()=>{const{height:e}=this.sizing;if(t.height==1/0)return"fixed"==h&&null!=e?e:o;switch(h){case"fixed":return null!=e?e:o;case"min":return o;case"fit":return null!=e?i(t.height,e):t.height;case"max":return null!=e?r(t.height,e):t.height}})()}}_set_geometry(t,e){super._set_geometry(t,e);const h=this.absolute?t:t.relative(),{left:i,right:r,top:n,bottom:s}=h,c=Math.round(h.vcenter),a=Math.round(h.hcenter);for(const e of this.children){const{margin:h,halign:l,valign:d}=e.sizing,{width:u,height:g,inner:_}=e.measure(t),w=(()=>{switch(`${d}_${l}`){case"start_start":return new o.BBox({left:i+h.left,top:n+h.top,width:u,height:g});case"start_center":return new o.BBox({hcenter:a,top:n+h.top,width:u,height:g});case"start_end":return new o.BBox({right:r-h.right,top:n+h.top,width:u,height:g});case"center_start":return new o.BBox({left:i+h.left,vcenter:c,width:u,height:g});case"center_center":return new o.BBox({hcenter:a,vcenter:c,width:u,height:g});case"center_end":return new o.BBox({right:r-h.right,vcenter:c,width:u,height:g});case"end_start":return new o.BBox({left:i+h.left,bottom:s-h.bottom,width:u,height:g});case"end_center":return new o.BBox({hcenter:a,bottom:s-h.bottom,width:u,height:g});case"end_end":return new o.BBox({right:r-h.right,bottom:s-h.bottom,width:u,height:g})}})(),m=null==_?w:new o.BBox({left:w.left+_.left,top:w.top+_.top,right:w.right-_.right,bottom:w.bottom-_.bottom});e.set_geometry(w,m)}}}h.NodeLayout=l,l.__name__="NodeLayout"},
function _(t,i,s,e,o){e();const n=t(124),l=t(125),r=t(8),h=t(65),c=t(9),{max:a,round:g}=Math;class p{constructor(t){this.def=t,this._map=new Map}get(t){let i=this._map.get(t);return void 0===i&&(i=this.def(),this._map.set(t,i)),i}apply(t,i){const s=this.get(t);this._map.set(t,i(s))}}p.__name__="DefaultMap";class f{constructor(){this._items=[],this._nrows=0,this._ncols=0}get nrows(){return this._nrows}get ncols(){return this._ncols}add(t,i){const{r1:s,c1:e}=t;this._nrows=a(this._nrows,s+1),this._ncols=a(this._ncols,e+1),this._items.push({span:t,data:i})}at(t,i){return this._items.filter((({span:s})=>s.r0<=t&&t<=s.r1&&s.c0<=i&&i<=s.c1)).map((({data:t})=>t))}row(t){return this._items.filter((({span:i})=>i.r0<=t&&t<=i.r1)).map((({data:t})=>t))}col(t){return this._items.filter((({span:i})=>i.c0<=t&&t<=i.c1)).map((({data:t})=>t))}foreach(t){for(const{span:i,data:s}of this._items)t(i,s)}map(t){const i=new f;for(const{span:s,data:e}of this._items)i.add(s,t(s,e));return i}}f.__name__="Container";class _ extends l.Layoutable{constructor(t=[]){super(),this.items=t,this.rows="auto",this.cols="auto",this.spacing=0}*[Symbol.iterator](){for(const{layout:t}of this.items)yield t}is_width_expanding(){if(super.is_width_expanding())return!0;if("fixed"==this.sizing.width_policy)return!1;const{cols:t}=this._state;return(0,c.some)(t,(t=>"max"==t.policy))}is_height_expanding(){if(super.is_height_expanding())return!0;if("fixed"==this.sizing.height_policy)return!1;const{rows:t}=this._state;return(0,c.some)(t,(t=>"max"==t.policy))}_init(){var t,i,s,e;super._init();const o=new f;for(const{layout:t,row:i,col:s,row_span:e,col_span:n}of this.items)if(t.sizing.visible){const l=i,r=s,h=i+(null!=e?e:1)-1,c=s+(null!=n?n:1)-1;o.add({r0:l,c0:r,r1:h,c1:c},t)}const{nrows:n,ncols:l}=o,h=new Array(n);for(let s=0;s<n;s++){const e=(()=>{var t;const i=(0,r.isPlainObject)(this.rows)?null!==(t=this.rows[s])&&void 0!==t?t:this.rows["*"]:this.rows;return null==i?{policy:"auto"}:(0,r.isNumber)(i)?{policy:"fixed",height:i}:(0,r.isString)(i)?{policy:i}:i})(),n=null!==(t=e.align)&&void 0!==t?t:"auto";if("fixed"==e.policy)h[s]={policy:"fixed",height:e.height,align:n};else if("min"==e.policy)h[s]={policy:"min",align:n};else if("fit"==e.policy||"max"==e.policy)h[s]={policy:e.policy,flex:null!==(i=e.flex)&&void 0!==i?i:1,align:n};else{if("auto"!=e.policy)throw new Error("unrechable");(0,c.some)(o.row(s),(t=>t.is_height_expanding()))?h[s]={policy:"max",flex:1,align:n}:h[s]={policy:"min",align:n}}}const a=new Array(l);for(let t=0;t<l;t++){const i=(()=>{var i;const s=(0,r.isPlainObject)(this.cols)?null!==(i=this.cols[t])&&void 0!==i?i:this.cols["*"]:this.cols;return null==s?{policy:"auto"}:(0,r.isNumber)(s)?{policy:"fixed",width:s}:(0,r.isString)(s)?{policy:s}:s})(),n=null!==(s=i.align)&&void 0!==s?s:"auto";if("fixed"==i.policy)a[t]={policy:"fixed",width:i.width,align:n};else if("min"==i.policy)a[t]={policy:"min",align:n};else if("fit"==i.policy||"max"==i.policy)a[t]={policy:i.policy,flex:null!==(e=i.flex)&&void 0!==e?e:1,align:n};else{if("auto"!=i.policy)throw new Error("unrechable");(0,c.some)(o.col(t),(t=>t.is_width_expanding()))?a[t]={policy:"max",flex:1,align:n}:a[t]={policy:"min",align:n}}}const[g,p]=(0,r.isNumber)(this.spacing)?[this.spacing,this.spacing]:this.spacing;this._state={items:o,nrows:n,ncols:l,rows:h,cols:a,rspacing:g,cspacing:p}}_measure_totals(t,i){const{nrows:s,ncols:e,rspacing:o,cspacing:n}=this._state;return{height:(0,c.sum)(t)+(s-1)*o,width:(0,c.sum)(i)+(e-1)*n}}_measure_cells(t){const{items:i,nrows:s,ncols:e,rows:o,cols:l,rspacing:r,cspacing:h}=this._state,c=new Array(s);for(let t=0;t<s;t++){const i=o[t];c[t]="fixed"==i.policy?i.height:0}const p=new Array(e);for(let t=0;t<e;t++){const i=l[t];p[t]="fixed"==i.policy?i.width:0}const _=new f;i.foreach(((i,s)=>{const{r0:e,c0:f,r1:d,c1:u}=i,w=(d-e)*r,m=(u-f)*h;let y=0;for(let i=e;i<=d;i++)y+=t(i,f).height;y+=w;let x=0;for(let i=f;i<=u;i++)x+=t(e,i).width;x+=m;const b=s.measure({width:x,height:y});_.add(i,{layout:s,size_hint:b});const z=new n.Sizeable(b).grow_by(s.sizing.margin);z.height-=w,z.width-=m;const v=[];for(let t=e;t<=d;t++){const i=o[t];"fixed"==i.policy?z.height-=i.height:v.push(t)}if(z.height>0){const t=g(z.height/v.length);for(const i of v)c[i]=a(c[i],t)}const j=[];for(let t=f;t<=u;t++){const i=l[t];"fixed"==i.policy?z.width-=i.width:j.push(t)}if(z.width>0){const t=g(z.width/j.length);for(const i of j)p[i]=a(p[i],t)}}));return{size:this._measure_totals(c,p),row_heights:c,col_widths:p,size_hints:_}}_measure_grid(t){const{nrows:i,ncols:s,rows:e,cols:o,rspacing:n,cspacing:l}=this._state,r=this._measure_cells(((t,i)=>{const s=e[t],n=o[i];return{width:"fixed"==n.policy?n.width:1/0,height:"fixed"==s.policy?s.height:1/0}}));let h;h="fixed"==this.sizing.height_policy&&null!=this.sizing.height?this.sizing.height:t.height!=1/0&&this.is_height_expanding()?t.height:r.size.height;let c,p=0;for(let t=0;t<i;t++){const i=e[t];"fit"==i.policy||"max"==i.policy?p+=i.flex:h-=r.row_heights[t]}if(h-=(i-1)*n,0!=p&&h>0)for(let t=0;t<i;t++){const i=e[t];if("fit"==i.policy||"max"==i.policy){const s=g(h*(i.flex/p));h-=s,r.row_heights[t]=s,p-=i.flex}}else if(h<0){let t=0;for(let s=0;s<i;s++){"fixed"!=e[s].policy&&t++}let s=-h;for(let o=0;o<i;o++){if("fixed"!=e[o].policy){const i=r.row_heights[o],e=g(s/t);r.row_heights[o]=a(i-e,0),s-=e>i?i:e,t--}}}c="fixed"==this.sizing.width_policy&&null!=this.sizing.width?this.sizing.width:t.width!=1/0&&this.is_width_expanding()?t.width:r.size.width;let f=0;for(let t=0;t<s;t++){const i=o[t];"fit"==i.policy||"max"==i.policy?f+=i.flex:c-=r.col_widths[t]}if(c-=(s-1)*l,0!=f&&c>0)for(let t=0;t<s;t++){const i=o[t];if("fit"==i.policy||"max"==i.policy){const s=g(c*(i.flex/f));c-=s,r.col_widths[t]=s,f-=i.flex}}else if(c<0){let t=0;for(let i=0;i<s;i++){"fixed"!=o[i].policy&&t++}let i=-c;for(let e=0;e<s;e++){if("fixed"!=o[e].policy){const s=r.col_widths[e],o=g(i/t);r.col_widths[e]=a(s-o,0),i-=o>s?s:o,t--}}}const{row_heights:_,col_widths:d,size_hints:u}=this._measure_cells(((t,i)=>({width:r.col_widths[i],height:r.row_heights[t]})));return{size:this._measure_totals(_,d),row_heights:_,col_widths:d,size_hints:u}}_measure(t){const{size:i}=this._measure_grid(t);return i}_set_geometry(t,i){super._set_geometry(t,i);const{nrows:s,ncols:e,rspacing:o,cspacing:n}=this._state,{row_heights:l,col_widths:r,size_hints:c}=this._measure_grid(t),f=this._state.rows.map(((t,i)=>Object.assign(Object.assign({},t),{top:0,height:l[i],get bottom(){return this.top+this.height}}))),_=this._state.cols.map(((t,i)=>Object.assign(Object.assign({},t),{left:0,width:r[i],get right(){return this.left+this.width}}))),d=c.map(((t,i)=>Object.assign(Object.assign({},i),{outer:new h.BBox,inner:new h.BBox})));for(let i=0,e=this.absolute?t.top:0;i<s;i++){const t=f[i];t.top=e,e+=t.height+o}for(let i=0,s=this.absolute?t.left:0;i<e;i++){const t=_[i];t.left=s,s+=t.width+n}d.foreach((({r0:t,c0:i,r1:s,c1:e},l)=>{const{layout:r,size_hint:c}=l,{sizing:a}=r,{width:p,height:d}=c,u=function(t,i){let s=(i-t)*n;for(let e=t;e<=i;e++)s+=_[e].width;return s}(i,e),w=function(t,i){let s=(i-t)*o;for(let e=t;e<=i;e++)s+=f[e].height;return s}(t,s),m=i==e&&"auto"!=_[i].align?_[i].align:a.halign,y=t==s&&"auto"!=f[t].align?f[t].align:a.valign;let x=_[i].left;"start"==m?x+=a.margin.left:"center"==m?x+=g((u-p)/2):"end"==m&&(x+=u-a.margin.right-p);let b=f[t].top;"start"==y?b+=a.margin.top:"center"==y?b+=g((w-d)/2):"end"==y&&(b+=w-a.margin.bottom-d),l.outer=new h.BBox({left:x,top:b,width:p,height:d})}));const u=f.map((()=>({start:new p((()=>0)),end:new p((()=>0))}))),w=_.map((()=>({start:new p((()=>0)),end:new p((()=>0))})));d.foreach((({r0:t,c0:i,r1:s,c1:e},{size_hint:o,outer:n})=>{const{inner:l}=o;null!=l&&(u[t].start.apply(n.top,(t=>a(t,l.top))),u[s].end.apply(f[s].bottom-n.bottom,(t=>a(t,l.bottom))),w[i].start.apply(n.left,(t=>a(t,l.left))),w[e].end.apply(_[e].right-n.right,(t=>a(t,l.right))))})),d.foreach((({r0:t,c0:i,r1:s,c1:e},o)=>{const{size_hint:n,outer:l}=o,r=t=>{const i=this.absolute?l:l.relative(),s=i.left+t.left,e=i.top+t.top,o=i.right-t.right,n=i.bottom-t.bottom;return new h.BBox({left:s,top:e,right:o,bottom:n})};if(null!=n.inner){let h=r(n.inner);if(!1!==n.align){const o=u[t].start.get(l.top),n=u[s].end.get(f[s].bottom-l.bottom),c=w[i].start.get(l.left),a=w[e].end.get(_[e].right-l.right);try{h=r({top:o,bottom:n,left:c,right:a})}catch(t){}}o.inner=h}else o.inner=l})),d.foreach(((t,{layout:i,outer:s,inner:e})=>{i.set_geometry(s,e)}))}}s.Grid=_,_.__name__="Grid";class d extends _{constructor(t){super(),this.items=t.map(((t,i)=>({layout:t,row:0,col:i}))),this.rows="fit"}}s.Row=d,d.__name__="Row";class u extends _{constructor(t){super(),this.items=t.map(((t,i)=>({layout:t,row:i,col:0}))),this.cols="fit"}}s.Column=u,u.__name__="Column"},
function _(e,t,s,n,i){n();const a=e(125),c=e(124),o=e(43);class r extends a.ContentLayoutable{constructor(e){super(),this.content_size=(0,o.unsized)(e,(()=>new c.Sizeable((0,o.size)(e))))}_content_size(){return this.content_size}}s.ContentBox=r,r.__name__="ContentBox";class _ extends a.Layoutable{constructor(e){super(),this.el=e}_measure(e){const t=new c.Sizeable(e).bounded_to(this.sizing.size);return(0,o.sized)(this.el,t,(()=>{const e=new c.Sizeable((0,o.content_size)(this.el)),{border:t,padding:s}=(0,o.extents)(this.el);return e.grow_by(t).grow_by(s).map(Math.ceil)}))}}s.VariadicBox=_,_.__name__="VariadicBox";class h extends _{constructor(e){super(e),this._cache=new Map}_measure(e){const{width:t,height:s}=e,n=`${t},${s}`;let i=this._cache.get(n);return null==i&&(i=super._measure(e),this._cache.set(n,i)),i}invalidate_cache(){this._cache.clear()}}s.CachedVariadicBox=h,h.__name__="CachedVariadicBox"},
function _(t,e,i,h,o){h();const s=t(124),r=t(125),n=t(65);class g extends r.Layoutable{constructor(){super(...arguments),this.min_border={left:0,top:0,right:0,bottom:0},this.padding={left:0,top:0,right:0,bottom:0}}*[Symbol.iterator](){yield this.top_panel,yield this.bottom_panel,yield this.left_panel,yield this.right_panel,yield this.center_panel}_measure(t){t=new s.Sizeable({width:"fixed"==this.sizing.width_policy||t.width==1/0?this.sizing.width:t.width,height:"fixed"==this.sizing.height_policy||t.height==1/0?this.sizing.height:t.height});const e=this.left_panel.measure({width:0,height:t.height}),i=Math.max(e.width,this.min_border.left)+this.padding.left,h=this.right_panel.measure({width:0,height:t.height}),o=Math.max(h.width,this.min_border.right)+this.padding.right,r=this.top_panel.measure({width:t.width,height:0}),n=Math.max(r.height,this.min_border.top)+this.padding.top,g=this.bottom_panel.measure({width:t.width,height:0}),a=Math.max(g.height,this.min_border.bottom)+this.padding.bottom,d=new s.Sizeable(t).shrink_by({left:i,right:o,top:n,bottom:a}),l=this.center_panel.measure(d);return{width:i+l.width+o,height:n+l.height+a,inner:{left:i,right:o,top:n,bottom:a},align:(()=>{const{width_policy:t,height_policy:e}=this.center_panel.sizing;return"fixed"!=t&&"fixed"!=e})()}}_set_geometry(t,e){super._set_geometry(t,e),this.center_panel.set_geometry(e);const i=this.left_panel.measure({width:0,height:t.height}),h=this.right_panel.measure({width:0,height:t.height}),o=this.top_panel.measure({width:t.width,height:0}),s=this.bottom_panel.measure({width:t.width,height:0}),{left:r,top:g,right:a,bottom:d}=e;this.top_panel.set_geometry(new n.BBox({left:r,right:a,bottom:g,height:o.height})),this.bottom_panel.set_geometry(new n.BBox({left:r,right:a,top:d,height:s.height})),this.left_panel.set_geometry(new n.BBox({top:g,bottom:d,right:r,width:i.width})),this.right_panel.set_geometry(new n.BBox({top:g,bottom:d,left:a,width:h.width}))}}i.BorderLayout=g,g.__name__="BorderLayout"},
function _(t,e,i,s,l){s();const n=t(1);var o;const a=t(119),_=t(10),d=t(20),h=t(120),r=t(123),u=(0,n.__importStar)(t(48));class c extends a.TextAnnotationView{update_layout(){const{panel:t}=this;this.layout=null!=t?new r.SideLayout(t,(()=>this.get_size()),!1):void 0}_get_size(){const{text:t}=this.model,e=new h.TextBox({text:t}),{angle:i,angle_units:s}=this.model;e.angle=(0,_.resolve_angle)(i,s),e.visuals=this.visuals.text.values();const{width:l,height:n}=e.size();return{width:l,height:n}}_render(){const{angle:t,angle_units:e}=this.model,i=(0,_.resolve_angle)(t,e),s=null!=this.layout?this.layout:this.plot_view.frame,l=this.coordinates.x_scale,n=this.coordinates.y_scale;let o="data"==this.model.x_units?l.compute(this.model.x):s.bbox.xview.compute(this.model.x),a="data"==this.model.y_units?n.compute(this.model.y):s.bbox.yview.compute(this.model.y);o+=this.model.x_offset,a-=this.model.y_offset;("canvas"==this.model.render_mode?this._canvas_text.bind(this):this._css_text.bind(this))(this.layer.ctx,this.model.text,o,a,i)}}i.LabelView=c,c.__name__="LabelView";class x extends a.TextAnnotation{constructor(t){super(t)}}i.Label=x,o=x,x.__name__="Label",o.prototype.default_view=c,o.mixins([u.Text,["border_",u.Line],["background_",u.Fill]]),o.define((({Number:t,String:e,Angle:i})=>({x:[t],x_units:[d.SpatialUnits,"data"],y:[t],y_units:[d.SpatialUnits,"data"],text:[e,""],angle:[i,0],angle_units:[d.AngleUnits,"rad"],x_offset:[t,0],y_offset:[t,0]}))),o.override({background_fill_color:null,border_line_color:null})},
function _(t,e,s,i,l){i();const o=t(1);var a;const r=t(69),n=(0,o.__importStar)(t(48)),d=t(20),_=t(43),c=t(120),h=(0,o.__importStar)(t(18)),u=t(11);class v extends r.DataAnnotationView{set_data(t){var e;if(super.set_data(t),null===(e=this.els)||void 0===e||e.forEach((t=>(0,_.remove)(t))),"css"==this.model.render_mode){const t=this.els=[...this.text].map((()=>(0,_.div)({style:{display:"none"}})));for(const e of t)this.plot_view.canvas_view.add_overlay(e)}else delete this.els}remove(){var t;null===(t=this.els)||void 0===t||t.forEach((t=>(0,_.remove)(t))),super.remove()}_rerender(){"css"==this.model.render_mode?this.render():this.request_render()}map_data(){const{x_scale:t,y_scale:e}=this.coordinates,s=null!=this.layout?this.layout:this.plot_view.frame;this.sx="data"==this.model.x_units?t.v_compute(this._x):s.bbox.xview.v_compute(this._x),this.sy="data"==this.model.y_units?e.v_compute(this._y):s.bbox.yview.v_compute(this._y)}paint(){const t="canvas"==this.model.render_mode?this._v_canvas_text.bind(this):this._v_css_text.bind(this),{ctx:e}=this.layer;for(let s=0,i=this.text.length;s<i;s++){const i=this.x_offset.get(s),l=this.y_offset.get(s),o=this.sx[s]+i,a=this.sy[s]-l,r=this.angle.get(s);t(e,s,this.text.get(s),o,a,r)}}_v_canvas_text(t,e,s,i,l,o){const a=new c.TextBox({text:s});a.angle=o,a.position={sx:i,sy:l},a.visuals=this.visuals.text.values(e);const{background_fill:r,border_line:n}=this.visuals;if(r.doit||n.doit){const{p0:s,p1:i,p2:l,p3:o}=a.rect();t.beginPath(),t.moveTo(s.x,s.y),t.lineTo(i.x,i.y),t.lineTo(l.x,l.y),t.lineTo(o.x,o.y),t.closePath(),this.visuals.background_fill.apply(t,e),this.visuals.border_line.apply(t,e)}this.visuals.text.doit&&a.paint(t)}_v_css_text(t,e,s,i,l,o){(0,u.assert)(null!=this.els);const a=this.els[e];a.textContent=s,this.visuals.text.set_vectorize(t,e),a.style.position="absolute",a.style.left=`${i}px`,a.style.top=`${l}px`,a.style.color=t.fillStyle,a.style.font=t.font,a.style.lineHeight="normal",a.style.whiteSpace="pre";const[r,n]=(()=>{switch(this.visuals.text.text_align.get(e)){case"left":return["left","0%"];case"center":return["center","-50%"];case"right":return["right","-100%"]}})(),[d,c]=(()=>{switch(this.visuals.text.text_baseline.get(e)){case"top":return["top","0%"];case"middle":return["center","-50%"];case"bottom":return["bottom","-100%"];default:return["center","-50%"]}})();let h=`translate(${n}, ${c})`;o&&(h+=`rotate(${o}rad)`),a.style.transformOrigin=`${r} ${d}`,a.style.transform=h,this.layout,this.visuals.background_fill.doit&&(this.visuals.background_fill.set_vectorize(t,e),a.style.backgroundColor=t.fillStyle),this.visuals.border_line.doit&&(this.visuals.border_line.set_vectorize(t,e),a.style.borderStyle=t.lineDash.length<2?"solid":"dashed",a.style.borderWidth=`${t.lineWidth}px`,a.style.borderColor=t.strokeStyle),(0,_.display)(a)}}s.LabelSetView=v,v.__name__="LabelSetView";class x extends r.DataAnnotation{constructor(t){super(t)}}s.LabelSet=x,a=x,x.__name__="LabelSet",a.prototype.default_view=v,a.mixins([n.TextVector,["border_",n.LineVector],["background_",n.FillVector]]),a.define((()=>({x:[h.XCoordinateSpec,{field:"x"}],y:[h.YCoordinateSpec,{field:"y"}],x_units:[d.SpatialUnits,"data"],y_units:[d.SpatialUnits,"data"],text:[h.StringSpec,{field:"text"}],angle:[h.AngleSpec,0],x_offset:[h.NumberSpec,{value:0}],y_offset:[h.NumberSpec,{value:0}],render_mode:[d.RenderMode,"canvas"]}))),a.override({background_fill_color:null,border_line_color:null})},
function _(t,e,i,l,s){l();const n=t(1);var o;const h=t(40),a=t(215),_=t(20),r=(0,n.__importStar)(t(48)),d=t(15),c=t(123),g=t(121),m=t(65),b=t(9),f=t(8),u=t(11);class x extends h.AnnotationView{update_layout(){const{panel:t}=this;this.layout=null!=t?new c.SideLayout(t,(()=>this.get_size())):void 0}cursor(t,e){return"none"==this.model.click_policy?null:"pointer"}get legend_padding(){return null!=this.model.border_line_color?this.model.padding:0}connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>this.request_render())),this.connect(this.model.item_change,(()=>this.request_render()))}compute_legend_bbox(){const t=this.model.get_legend_names(),{glyph_height:e,glyph_width:i}=this.model,{label_height:l,label_width:s}=this.model;this.max_label_height=(0,b.max)([(0,g.font_metrics)(this.visuals.label_text.font_value()).height,l,e]);const{ctx:n}=this.layer;n.save(),this.visuals.label_text.set_value(n),this.text_widths=new Map;for(const e of t)this.text_widths.set(e,(0,b.max)([n.measureText(e).width,s]));this.visuals.title_text.set_value(n),this.title_height=this.model.title?(0,g.font_metrics)(this.visuals.title_text.font_value()).height+this.model.title_standoff:0,this.title_width=this.model.title?n.measureText(this.model.title).width:0,n.restore();const o=Math.max((0,b.max)([...this.text_widths.values()]),0),h=this.model.margin,{legend_padding:a}=this,_=this.model.spacing,{label_standoff:r}=this.model;let d,c;if("vertical"==this.model.orientation)d=t.length*this.max_label_height+Math.max(t.length-1,0)*_+2*a+this.title_height,c=(0,b.max)([o+i+r+2*a,this.title_width+2*a]);else{let e=2*a+Math.max(t.length-1,0)*_;for(const[,t]of this.text_widths)e+=(0,b.max)([t,s])+i+r;c=(0,b.max)([this.title_width+2*a,e]),d=this.max_label_height+this.title_height+2*a}const x=null!=this.layout?this.layout:this.plot_view.frame,[p,w]=x.bbox.ranges,{location:v}=this.model;let y,k;if((0,f.isString)(v))switch(v){case"top_left":y=p.start+h,k=w.start+h;break;case"top":case"top_center":y=(p.end+p.start)/2-c/2,k=w.start+h;break;case"top_right":y=p.end-h-c,k=w.start+h;break;case"bottom_right":y=p.end-h-c,k=w.end-h-d;break;case"bottom":case"bottom_center":y=(p.end+p.start)/2-c/2,k=w.end-h-d;break;case"bottom_left":y=p.start+h,k=w.end-h-d;break;case"left":case"center_left":y=p.start+h,k=(w.end+w.start)/2-d/2;break;case"center":case"center_center":y=(p.end+p.start)/2-c/2,k=(w.end+w.start)/2-d/2;break;case"right":case"center_right":y=p.end-h-c,k=(w.end+w.start)/2-d/2}else if((0,f.isArray)(v)&&2==v.length){const[t,e]=v;y=x.bbox.xview.compute(t),k=x.bbox.yview.compute(e)-d}else(0,u.unreachable)();return new m.BBox({left:y,top:k,width:c,height:d})}interactive_bbox(){return this.compute_legend_bbox()}interactive_hit(t,e){return this.interactive_bbox().contains(t,e)}on_hit(t,e){let i;const{glyph_width:l}=this.model,{legend_padding:s}=this,n=this.model.spacing,{label_standoff:o}=this.model;let h=i=s;const a=this.compute_legend_bbox(),_="vertical"==this.model.orientation;for(const r of this.model.items){const d=r.get_labels_list_from_label_prop();for(const c of d){const d=a.x+h,g=a.y+i+this.title_height;let b,f;[b,f]=_?[a.width-2*s,this.max_label_height]:[this.text_widths.get(c)+l+o,this.max_label_height];if(new m.BBox({left:d,top:g,width:b,height:f}).contains(t,e)){switch(this.model.click_policy){case"hide":for(const t of r.renderers)t.visible=!t.visible;break;case"mute":for(const t of r.renderers)t.muted=!t.muted}return!0}_?i+=this.max_label_height+n:h+=this.text_widths.get(c)+l+o+n}}return!1}_render(){if(0==this.model.items.length)return;if(!(0,b.some)(this.model.items,(t=>t.visible)))return;for(const t of this.model.items)t.legend=this.model;const{ctx:t}=this.layer,e=this.compute_legend_bbox();t.save(),this._draw_legend_box(t,e),this._draw_legend_items(t,e),this._draw_title(t,e),t.restore()}_draw_legend_box(t,e){t.beginPath(),t.rect(e.x,e.y,e.width,e.height),this.visuals.background_fill.apply(t),this.visuals.border_line.apply(t)}_draw_legend_items(t,e){const{glyph_width:i,glyph_height:l}=this.model,{legend_padding:s}=this,n=this.model.spacing,{label_standoff:o}=this.model;let h=s,a=s;const _="vertical"==this.model.orientation;for(const r of this.model.items){if(!r.visible)continue;const d=r.get_labels_list_from_label_prop(),c=r.get_field_from_label_prop();if(0==d.length)continue;const g=(()=>{switch(this.model.click_policy){case"none":return!0;case"hide":return(0,b.every)(r.renderers,(t=>t.visible));case"mute":return(0,b.every)(r.renderers,(t=>!t.muted))}})();for(const m of d){const d=e.x+h,b=e.y+a+this.title_height,f=d+i,u=b+l;_?a+=this.max_label_height+n:h+=this.text_widths.get(m)+i+o+n,this.visuals.label_text.set_value(t),t.fillText(m,f+o,b+this.max_label_height/2);for(const e of r.renderers){const i=this.plot_view.renderer_view(e);null==i||i.draw_legend(t,d,f,b,u,c,m,r.index)}if(!g){let l,n;[l,n]=_?[e.width-2*s,this.max_label_height]:[this.text_widths.get(m)+i+o,this.max_label_height],t.beginPath(),t.rect(d,b,l,n),this.visuals.inactive_fill.set_value(t),t.fill()}}}}_draw_title(t,e){const{title:i}=this.model;i&&this.visuals.title_text.doit&&(t.save(),t.translate(e.x0,e.y0+this.title_height),this.visuals.title_text.set_value(t),t.fillText(i,this.legend_padding,this.legend_padding-this.model.title_standoff),t.restore())}_get_size(){const{width:t,height:e}=this.compute_legend_bbox();return{width:t+2*this.model.margin,height:e+2*this.model.margin}}}i.LegendView=x,x.__name__="LegendView";class p extends h.Annotation{constructor(t){super(t)}initialize(){super.initialize(),this.item_change=new d.Signal0(this,"item_change")}get_legend_names(){const t=[];for(const e of this.items){const i=e.get_labels_list_from_label_prop();t.push(...i)}return t}}i.Legend=p,o=p,p.__name__="Legend",o.prototype.default_view=x,o.mixins([["label_",r.Text],["title_",r.Text],["inactive_",r.Fill],["border_",r.Line],["background_",r.Fill]]),o.define((({Number:t,String:e,Array:i,Tuple:l,Or:s,Ref:n,Nullable:o})=>({orientation:[_.Orientation,"vertical"],location:[s(_.LegendLocation,l(t,t)),"top_right"],title:[o(e),null],title_standoff:[t,5],label_standoff:[t,5],glyph_height:[t,20],glyph_width:[t,20],label_height:[t,20],label_width:[t,20],margin:[t,10],padding:[t,10],spacing:[t,3],items:[i(n(a.LegendItem)),[]],click_policy:[_.LegendClickPolicy,"none"]}))),o.override({border_line_color:"#e5e5e5",border_line_alpha:.5,border_line_width:1,background_fill_color:"#ffffff",background_fill_alpha:.95,inactive_fill_color:"white",inactive_fill_alpha:.7,label_text_font_size:"13px",label_text_baseline:"middle",title_text_font_size:"13px",title_text_font_style:"italic"})},
function _(e,r,l,n,t){n();const i=e(1);var s;const o=e(53),a=e(175),_=e(70),u=e(216),d=(0,i.__importStar)(e(18)),c=e(19),f=e(9);class h extends o.Model{constructor(e){super(e)}_check_data_sources_on_renderers(){if(null!=this.get_field_from_label_prop()){if(this.renderers.length<1)return!1;const e=this.renderers[0].data_source;if(null!=e)for(const r of this.renderers)if(r.data_source!=e)return!1}return!0}_check_field_label_on_data_source(){const e=this.get_field_from_label_prop();if(null!=e){if(this.renderers.length<1)return!1;const r=this.renderers[0].data_source;if(null!=r&&!(0,f.includes)(r.columns(),e))return!1}return!0}initialize(){super.initialize(),this.legend=null,this.connect(this.change,(()=>{var e;return null===(e=this.legend)||void 0===e?void 0:e.item_change.emit()}));this._check_data_sources_on_renderers()||c.logger.error("Non matching data sources on legend item renderers");this._check_field_label_on_data_source()||c.logger.error(`Bad column name on label: ${this.label}`)}get_field_from_label_prop(){const{label:e}=this;return(0,u.isField)(e)?e.field:null}get_labels_list_from_label_prop(){if(!this.visible)return[];if((0,u.isValue)(this.label)){const{value:e}=this.label;return null!=e?[e]:[]}const e=this.get_field_from_label_prop();if(null!=e){let r;if(!this.renderers[0]||null==this.renderers[0].data_source)return["No source found"];if(r=this.renderers[0].data_source,r instanceof _.ColumnarDataSource){const l=r.get_column(e);return null!=l?(0,f.uniq)(Array.from(l)):["Invalid field"]}}return[]}}l.LegendItem=h,s=h,h.__name__="LegendItem",s.define((({Boolean:e,Int:r,Array:l,Ref:n,Nullable:t})=>({label:[d.NullStringSpec,null],renderers:[l(n(a.GlyphRenderer)),[]],index:[t(r),null],visible:[e,!0]})))},
function _(i,n,e,t,u){t();const c=i(8);e.isValue=function(i){return(0,c.isPlainObject)(i)&&"value"in i},e.isField=function(i){return(0,c.isPlainObject)(i)&&"field"in i},e.isExpr=function(i){return(0,c.isPlainObject)(i)&&"expr"in i}},
function _(t,n,e,s,i){s();const o=t(1);var a;const l=t(40),c=(0,o.__importStar)(t(48)),r=t(20);class _ extends l.AnnotationView{connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>this.request_render()))}_render(){const{xs:t,ys:n}=this.model;if(t.length!=n.length)return;const e=t.length;if(e<3)return;const{frame:s}=this.plot_view,{ctx:i}=this.layer,o=this.coordinates.x_scale,a=this.coordinates.y_scale,{screen:l}=this.model;function c(t,n,e,s){return l?t:"data"==n?e.v_compute(t):s.v_compute(t)}const r=c(t,this.model.xs_units,o,s.bbox.xview),_=c(n,this.model.ys_units,a,s.bbox.yview);i.beginPath();for(let t=0;t<e;t++)i.lineTo(r[t],_[t]);i.closePath(),this.visuals.fill.apply(i),this.visuals.hatch.apply(i),this.visuals.line.apply(i)}}e.PolyAnnotationView=_,_.__name__="PolyAnnotationView";class h extends l.Annotation{constructor(t){super(t)}update({xs:t,ys:n}){this.setv({xs:t,ys:n,screen:!0},{check_eq:!1})}}e.PolyAnnotation=h,a=h,h.__name__="PolyAnnotation",a.prototype.default_view=_,a.mixins([c.Line,c.Fill,c.Hatch]),a.define((({Number:t,Array:n})=>({xs:[n(t),[]],xs_units:[r.SpatialUnits,"data"],ys:[n(t),[]],ys_units:[r.SpatialUnits,"data"]}))),a.internal((({Boolean:t})=>({screen:[t,!1]}))),a.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})},
function _(e,t,n,o,i){o();const s=e(1);var l;const r=e(40),c=(0,s.__importStar)(e(48));class a extends r.AnnotationView{connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>this.request_render()))}_render(){const{gradient:e,y_intercept:t}=this.model;if(null==e||null==t)return;const{frame:n}=this.plot_view,o=this.coordinates.x_scale,i=this.coordinates.y_scale;let s,l,r,c;if(0==e)s=i.compute(t),l=s,r=n.bbox.left,c=r+n.bbox.width;else{s=n.bbox.top,l=s+n.bbox.height;const a=(i.invert(s)-t)/e,_=(i.invert(l)-t)/e;r=o.compute(a),c=o.compute(_)}const{ctx:a}=this.layer;a.save(),a.beginPath(),this.visuals.line.set_value(a),a.moveTo(r,s),a.lineTo(c,l),a.stroke(),a.restore()}}n.SlopeView=a,a.__name__="SlopeView";class _ extends r.Annotation{constructor(e){super(e)}}n.Slope=_,l=_,_.__name__="Slope",l.prototype.default_view=a,l.mixins(c.Line),l.define((({Number:e,Nullable:t})=>({gradient:[t(e),null],y_intercept:[t(e),null]}))),l.override({line_color:"black"})},
function _(e,t,i,o,n){o();const s=e(1);var l;const a=e(40),r=(0,s.__importStar)(e(48)),c=e(20);class d extends a.AnnotationView{connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>this.plot_view.request_paint(this)))}_render(){const{location:e}=this.model;if(null==e)return;const{frame:t}=this.plot_view,i=this.coordinates.x_scale,o=this.coordinates.y_scale,n=(t,i)=>"data"==this.model.location_units?t.compute(e):this.model.for_hover?e:i.compute(e);let s,l,a,r;"width"==this.model.dimension?(a=n(o,t.bbox.yview),l=t.bbox.left,r=t.bbox.width,s=this.model.line_width):(a=t.bbox.top,l=n(i,t.bbox.xview),r=this.model.line_width,s=t.bbox.height);const{ctx:c}=this.layer;c.save(),c.beginPath(),this.visuals.line.set_value(c),c.moveTo(l,a),"width"==this.model.dimension?c.lineTo(l+r,a):c.lineTo(l,a+s),c.stroke(),c.restore()}}i.SpanView=d,d.__name__="SpanView";class _ extends a.Annotation{constructor(e){super(e)}}i.Span=_,l=_,_.__name__="Span",l.prototype.default_view=d,l.mixins(r.Line),l.define((({Number:e,Nullable:t})=>({render_mode:[c.RenderMode,"canvas"],location:[t(e),null],location_units:[c.SpatialUnits,"data"],dimension:[c.Dimension,"width"]}))),l.internal((({Boolean:e})=>({for_hover:[e,!1]}))),l.override({line_color:"black"})},
function _(i,e,t,o,l){var s;o();const a=i(40),_=i(221),n=i(113),r=i(43),h=i(123),b=i(65);class v extends a.AnnotationView{constructor(){super(...arguments),this._invalidate_toolbar=!0,this._previous_bbox=new b.BBox}update_layout(){this.layout=new h.SideLayout(this.panel,(()=>this.get_size()),!0)}initialize(){super.initialize(),this.el=(0,r.div)(),this.plot_view.canvas_view.add_event(this.el)}async lazy_initialize(){await super.lazy_initialize(),this._toolbar_view=await(0,n.build_view)(this.model.toolbar,{parent:this}),this.plot_view.visibility_callbacks.push((i=>this._toolbar_view.set_visibility(i)))}remove(){this._toolbar_view.remove(),(0,r.remove)(this.el),super.remove()}render(){this.model.visible||(0,r.undisplay)(this.el),super.render()}_render(){const{bbox:i}=this.layout;this._previous_bbox.equals(i)||((0,r.position)(this.el,i),this._previous_bbox=i,this._invalidate_toolbar=!0),this._invalidate_toolbar&&(this.el.style.position="absolute",this.el.style.overflow="hidden",(0,r.empty)(this.el),this.el.appendChild(this._toolbar_view.el),this._toolbar_view.layout.bbox=i,this._toolbar_view.render(),this._invalidate_toolbar=!1),(0,r.display)(this.el)}_get_size(){const{tools:i,logo:e}=this.model.toolbar;return{width:30*i.length+(null!=e?25:0)+15,height:30}}}t.ToolbarPanelView=v,v.__name__="ToolbarPanelView";class d extends a.Annotation{constructor(i){super(i)}}t.ToolbarPanel=d,s=d,d.__name__="ToolbarPanel",s.prototype.default_view=v,s.define((({Ref:i})=>({toolbar:[i(_.Toolbar)]})))},
function _(t,e,s,i,o){var c;i();const n=t(8),a=t(9),l=t(13),r=t(222),_=t(223),u=t(232),p=t(233);function v(t){switch(t){case"tap":return"active_tap";case"pan":return"active_drag";case"pinch":case"scroll":return"active_scroll";case"multi":return"active_multi"}return null}function h(t){return"tap"==t||"pan"==t}s.Drag=r.Tool,s.Inspection=r.Tool,s.Scroll=r.Tool,s.Tap=r.Tool;class f extends p.ToolbarBase{constructor(t){super(t)}connect_signals(){super.connect_signals();const{tools:t,active_drag:e,active_inspect:s,active_scroll:i,active_tap:o,active_multi:c}=this.properties;this.on_change([t,e,s,i,o,c],(()=>this._init_tools()))}_init_tools(){if(super._init_tools(),"auto"==this.active_inspect);else if(this.active_inspect instanceof u.InspectTool){let t=!1;for(const e of this.inspectors)e!=this.active_inspect?e.active=!1:t=!0;t||(this.active_inspect=null)}else if((0,n.isArray)(this.active_inspect)){const t=(0,a.intersection)(this.active_inspect,this.inspectors);t.length!=this.active_inspect.length&&(this.active_inspect=t);for(const t of this.inspectors)(0,a.includes)(this.active_inspect,t)||(t.active=!1)}else if(null==this.active_inspect)for(const t of this.inspectors)t.active=!1;const t=t=>{t.active?this._active_change(t):t.active=!0};for(const t of(0,l.values)(this.gestures)){t.tools=(0,a.sort_by)(t.tools,(t=>t.default_order));for(const e of t.tools)this.connect(e.properties.active.change,(()=>this._active_change(e)))}for(const[e,s]of(0,l.entries)(this.gestures)){const i=v(e);if(i){const o=this[i];"auto"==o?0!=s.tools.length&&h(e)&&t(s.tools[0]):null!=o&&((0,a.includes)(this.tools,o)?t(o):this[i]=null)}}}}s.Toolbar=f,c=f,f.__name__="Toolbar",c.prototype.default_view=p.ToolbarBaseView,c.define((({Or:t,Ref:e,Auto:i,Null:o})=>({active_drag:[t(e(s.Drag),i,o),"auto"],active_inspect:[t(e(s.Inspection),i,o),"auto"],active_scroll:[t(e(s.Scroll),i,o),"auto"],active_tap:[t(e(s.Tap),i,o),"auto"],active_multi:[t(e(_.GestureTool),i,o),"auto"]})))},
function _(t,e,n,o,s){var i;o();const a=t(42),r=t(9),l=t(53);class c extends a.View{get plot_view(){return this.parent}get plot_model(){return this.parent.model}connect_signals(){super.connect_signals(),this.connect(this.model.properties.active.change,(()=>{this.model.active?this.activate():this.deactivate()}))}activate(){}deactivate(){}}n.ToolView=c,c.__name__="ToolView";class _ extends l.Model{constructor(t){super(t)}get synthetic_renderers(){return[]}_get_dim_limits([t,e],[n,o],s,i){const a=s.bbox.h_range;let l;"width"==i||"both"==i?(l=[(0,r.min)([t,n]),(0,r.max)([t,n])],l=[(0,r.max)([l[0],a.start]),(0,r.min)([l[1],a.end])]):l=[a.start,a.end];const c=s.bbox.v_range;let _;return"height"==i||"both"==i?(_=[(0,r.min)([e,o]),(0,r.max)([e,o])],_=[(0,r.max)([_[0],c.start]),(0,r.min)([_[1],c.end])]):_=[c.start,c.end],[l,_]}static register_alias(t,e){this.prototype._known_aliases.set(t,e)}static from_string(t){const e=this.prototype._known_aliases.get(t);if(null!=e)return e();{const e=[...this.prototype._known_aliases.keys()];throw new Error(`unexpected tool name '${t}', possible tools are ${e.join(", ")}`)}}}n.Tool=_,i=_,_.__name__="Tool",i.prototype._known_aliases=new Map,i.define((({String:t,Nullable:e})=>({description:[e(t),null]}))),i.internal((({Boolean:t})=>({active:[t,!1]})))},
function _(e,o,t,s,n){s();const u=e(224),_=e(231);class l extends u.ButtonToolView{}t.GestureToolView=l,l.__name__="GestureToolView";class i extends u.ButtonTool{constructor(e){super(e),this.button_view=_.OnOffButtonView}}t.GestureTool=i,i.__name__="GestureTool"},
function _(t,e,o,s,i){s();const n=t(1);var l;const r=(0,n.__importDefault)(t(225)),a=t(226),u=t(222),h=t(43),_=t(34),d=t(8),c=t(9),m=(0,n.__importStar)(t(227)),p=m,v=(0,n.__importDefault)(t(228)),f=(0,n.__importDefault)(t(229)),g=t(230);class b extends a.DOMView{initialize(){super.initialize();const t=this.model.menu;if(null!=t){const e=this.parent.model.toolbar_location,o="left"==e||"above"==e,s=this.parent.model.horizontal?"vertical":"horizontal";this._menu=new g.ContextMenu(o?(0,c.reversed)(t):t,{orientation:s,prevent_hide:t=>t.target==this.el})}this._hammer=new r.default(this.el,{touchAction:"auto",inputClass:r.default.TouchMouseInput}),this.connect(this.model.change,(()=>this.render())),this._hammer.on("tap",(t=>{var e;(null===(e=this._menu)||void 0===e?void 0:e.is_open)?this._menu.hide():t.target==this.el&&this._clicked()})),this._hammer.on("press",(()=>this._pressed())),this.el.addEventListener("keydown",(t=>{t.keyCode==h.Keys.Enter&&this._clicked()}))}remove(){var t;this._hammer.destroy(),null===(t=this._menu)||void 0===t||t.remove(),super.remove()}styles(){return[...super.styles(),m.default,v.default,f.default]}css_classes(){return super.css_classes().concat(p.toolbar_button)}render(){(0,h.empty)(this.el);const t=this.model.computed_icon;(0,d.isString)(t)&&((0,_.startsWith)(t,"data:image")?this.el.style.backgroundImage=`url("${t}")`:this.el.classList.add(t)),this.el.title=this.model.tooltip,this.el.tabIndex=0,null!=this._menu&&this.root.el.appendChild(this._menu.el)}_pressed(){var t;const e=(()=>{switch(this.parent.model.toolbar_location){case"right":return{left_of:this.el};case"left":return{right_of:this.el};case"above":return{below:this.el};case"below":return{above:this.el}}})();null===(t=this._menu)||void 0===t||t.toggle(e)}}o.ButtonToolButtonView=b,b.__name__="ButtonToolButtonView";class w extends u.ToolView{}o.ButtonToolView=w,w.__name__="ButtonToolView";class y extends u.Tool{constructor(t){super(t)}_get_dim_tooltip(t){const{description:e,tool_name:o}=this;return null!=e?e:"both"==t?o:`${o} (${"width"==t?"x":"y"}-axis)`}get tooltip(){var t;return null!==(t=this.description)&&void 0!==t?t:this.tool_name}get computed_icon(){return this.icon}get menu(){return null}}o.ButtonTool=y,l=y,y.__name__="ButtonTool",l.internal((({Boolean:t})=>({disabled:[t,!1]})))},
function _(t,e,i,n,r){
/*! Hammer.JS - v2.0.7 - 2016-04-22
     * http://hammerjs.github.io/
     *
     * Copyright (c) 2016 Jorik Tangelder;
     * Licensed under the MIT license */
!function(t,i,n,r){"use strict";var s,o=["","webkit","Moz","MS","ms","o"],a=i.createElement("div"),h=Math.round,u=Math.abs,c=Date.now;function l(t,e,i){return setTimeout(T(t,i),e)}function p(t,e,i){return!!Array.isArray(t)&&(f(t,i[e],i),!0)}function f(t,e,i){var n;if(t)if(t.forEach)t.forEach(e,i);else if(t.length!==r)for(n=0;n<t.length;)e.call(i,t[n],n,t),n++;else for(n in t)t.hasOwnProperty(n)&&e.call(i,t[n],n,t)}function v(e,i,n){var r="DEPRECATED METHOD: "+i+"\n"+n+" AT \n";return function(){var i=new Error("get-stack-trace"),n=i&&i.stack?i.stack.replace(/^[^\(]+?[\n$]/gm,"").replace(/^\s+at\s+/gm,"").replace(/^Object.<anonymous>\s*\(/gm,"{anonymous}()@"):"Unknown Stack Trace",s=t.console&&(t.console.warn||t.console.log);return s&&s.call(t.console,r,n),e.apply(this,arguments)}}s="function"!=typeof Object.assign?function(t){if(t===r||null===t)throw new TypeError("Cannot convert undefined or null to object");for(var e=Object(t),i=1;i<arguments.length;i++){var n=arguments[i];if(n!==r&&null!==n)for(var s in n)n.hasOwnProperty(s)&&(e[s]=n[s])}return e}:Object.assign;var d=v((function(t,e,i){for(var n=Object.keys(e),s=0;s<n.length;)(!i||i&&t[n[s]]===r)&&(t[n[s]]=e[n[s]]),s++;return t}),"extend","Use `assign`."),m=v((function(t,e){return d(t,e,!0)}),"merge","Use `assign`.");function g(t,e,i){var n,r=e.prototype;(n=t.prototype=Object.create(r)).constructor=t,n._super=r,i&&s(n,i)}function T(t,e){return function(){return t.apply(e,arguments)}}function y(t,e){return"function"==typeof t?t.apply(e&&e[0]||r,e):t}function E(t,e){return t===r?e:t}function I(t,e,i){f(S(e),(function(e){t.addEventListener(e,i,!1)}))}function A(t,e,i){f(S(e),(function(e){t.removeEventListener(e,i,!1)}))}function _(t,e){for(;t;){if(t==e)return!0;t=t.parentNode}return!1}function C(t,e){return t.indexOf(e)>-1}function S(t){return t.trim().split(/\s+/g)}function b(t,e,i){if(t.indexOf&&!i)return t.indexOf(e);for(var n=0;n<t.length;){if(i&&t[n][i]==e||!i&&t[n]===e)return n;n++}return-1}function P(t){return Array.prototype.slice.call(t,0)}function D(t,e,i){for(var n=[],r=[],s=0;s<t.length;){var o=e?t[s][e]:t[s];b(r,o)<0&&n.push(t[s]),r[s]=o,s++}return i&&(n=e?n.sort((function(t,i){return t[e]>i[e]})):n.sort()),n}function x(t,e){for(var i,n,s=e[0].toUpperCase()+e.slice(1),a=0;a<o.length;){if((n=(i=o[a])?i+s:e)in t)return n;a++}return r}var w=1;function O(e){var i=e.ownerDocument||e;return i.defaultView||i.parentWindow||t}var R="ontouchstart"in t,M=x(t,"PointerEvent")!==r,z=R&&/mobile|tablet|ip(ad|hone|od)|android/i.test(navigator.userAgent),N="touch",X="mouse",Y=24,F=["x","y"],W=["clientX","clientY"];function q(t,e){var i=this;this.manager=t,this.callback=e,this.element=t.element,this.target=t.options.inputTarget,this.domHandler=function(e){y(t.options.enable,[t])&&i.handler(e)},this.init()}function k(t,e,i){var n=i.pointers.length,s=i.changedPointers.length,o=1&e&&n-s==0,a=12&e&&n-s==0;i.isFirst=!!o,i.isFinal=!!a,o&&(t.session={}),i.eventType=e,function(t,e){var i=t.session,n=e.pointers,s=n.length;i.firstInput||(i.firstInput=H(e));s>1&&!i.firstMultiple?i.firstMultiple=H(e):1===s&&(i.firstMultiple=!1);var o=i.firstInput,a=i.firstMultiple,h=a?a.center:o.center,l=e.center=L(n);e.timeStamp=c(),e.deltaTime=e.timeStamp-o.timeStamp,e.angle=G(h,l),e.distance=j(h,l),function(t,e){var i=e.center,n=t.offsetDelta||{},r=t.prevDelta||{},s=t.prevInput||{};1!==e.eventType&&4!==s.eventType||(r=t.prevDelta={x:s.deltaX||0,y:s.deltaY||0},n=t.offsetDelta={x:i.x,y:i.y});e.deltaX=r.x+(i.x-n.x),e.deltaY=r.y+(i.y-n.y)}(i,e),e.offsetDirection=V(e.deltaX,e.deltaY);var p=U(e.deltaTime,e.deltaX,e.deltaY);e.overallVelocityX=p.x,e.overallVelocityY=p.y,e.overallVelocity=u(p.x)>u(p.y)?p.x:p.y,e.scale=a?(f=a.pointers,v=n,j(v[0],v[1],W)/j(f[0],f[1],W)):1,e.rotation=a?function(t,e){return G(e[1],e[0],W)+G(t[1],t[0],W)}(a.pointers,n):0,e.maxPointers=i.prevInput?e.pointers.length>i.prevInput.maxPointers?e.pointers.length:i.prevInput.maxPointers:e.pointers.length,function(t,e){var i,n,s,o,a=t.lastInterval||e,h=e.timeStamp-a.timeStamp;if(8!=e.eventType&&(h>25||a.velocity===r)){var c=e.deltaX-a.deltaX,l=e.deltaY-a.deltaY,p=U(h,c,l);n=p.x,s=p.y,i=u(p.x)>u(p.y)?p.x:p.y,o=V(c,l),t.lastInterval=e}else i=a.velocity,n=a.velocityX,s=a.velocityY,o=a.direction;e.velocity=i,e.velocityX=n,e.velocityY=s,e.direction=o}(i,e);var f,v;var d=t.element;_(e.srcEvent.target,d)&&(d=e.srcEvent.target);e.target=d}(t,i),t.emit("hammer.input",i),t.recognize(i),t.session.prevInput=i}function H(t){for(var e=[],i=0;i<t.pointers.length;)e[i]={clientX:h(t.pointers[i].clientX),clientY:h(t.pointers[i].clientY)},i++;return{timeStamp:c(),pointers:e,center:L(e),deltaX:t.deltaX,deltaY:t.deltaY}}function L(t){var e=t.length;if(1===e)return{x:h(t[0].clientX),y:h(t[0].clientY)};for(var i=0,n=0,r=0;r<e;)i+=t[r].clientX,n+=t[r].clientY,r++;return{x:h(i/e),y:h(n/e)}}function U(t,e,i){return{x:e/t||0,y:i/t||0}}function V(t,e){return t===e?1:u(t)>=u(e)?t<0?2:4:e<0?8:16}function j(t,e,i){i||(i=F);var n=e[i[0]]-t[i[0]],r=e[i[1]]-t[i[1]];return Math.sqrt(n*n+r*r)}function G(t,e,i){i||(i=F);var n=e[i[0]]-t[i[0]],r=e[i[1]]-t[i[1]];return 180*Math.atan2(r,n)/Math.PI}q.prototype={handler:function(){},init:function(){this.evEl&&I(this.element,this.evEl,this.domHandler),this.evTarget&&I(this.target,this.evTarget,this.domHandler),this.evWin&&I(O(this.element),this.evWin,this.domHandler)},destroy:function(){this.evEl&&A(this.element,this.evEl,this.domHandler),this.evTarget&&A(this.target,this.evTarget,this.domHandler),this.evWin&&A(O(this.element),this.evWin,this.domHandler)}};var Z={mousedown:1,mousemove:2,mouseup:4},B="mousedown",$="mousemove mouseup";function J(){this.evEl=B,this.evWin=$,this.pressed=!1,q.apply(this,arguments)}g(J,q,{handler:function(t){var e=Z[t.type];1&e&&0===t.button&&(this.pressed=!0),2&e&&1!==t.which&&(e=4),this.pressed&&(4&e&&(this.pressed=!1),this.callback(this.manager,e,{pointers:[t],changedPointers:[t],pointerType:X,srcEvent:t}))}});var K={pointerdown:1,pointermove:2,pointerup:4,pointercancel:8,pointerout:8},Q={2:N,3:"pen",4:X,5:"kinect"},tt="pointerdown",et="pointermove pointerup pointercancel";function it(){this.evEl=tt,this.evWin=et,q.apply(this,arguments),this.store=this.manager.session.pointerEvents=[]}t.MSPointerEvent&&!t.PointerEvent&&(tt="MSPointerDown",et="MSPointerMove MSPointerUp MSPointerCancel"),g(it,q,{handler:function(t){var e=this.store,i=!1,n=t.type.toLowerCase().replace("ms",""),r=K[n],s=Q[t.pointerType]||t.pointerType,o=s==N,a=b(e,t.pointerId,"pointerId");1&r&&(0===t.button||o)?a<0&&(e.push(t),a=e.length-1):12&r&&(i=!0),a<0||(e[a]=t,this.callback(this.manager,r,{pointers:e,changedPointers:[t],pointerType:s,srcEvent:t}),i&&e.splice(a,1))}});var nt={touchstart:1,touchmove:2,touchend:4,touchcancel:8},rt="touchstart",st="touchstart touchmove touchend touchcancel";function ot(){this.evTarget=rt,this.evWin=st,this.started=!1,q.apply(this,arguments)}function at(t,e){var i=P(t.touches),n=P(t.changedTouches);return 12&e&&(i=D(i.concat(n),"identifier",!0)),[i,n]}g(ot,q,{handler:function(t){var e=nt[t.type];if(1===e&&(this.started=!0),this.started){var i=at.call(this,t,e);12&e&&i[0].length-i[1].length==0&&(this.started=!1),this.callback(this.manager,e,{pointers:i[0],changedPointers:i[1],pointerType:N,srcEvent:t})}}});var ht={touchstart:1,touchmove:2,touchend:4,touchcancel:8},ut="touchstart touchmove touchend touchcancel";function ct(){this.evTarget=ut,this.targetIds={},q.apply(this,arguments)}function lt(t,e){var i=P(t.touches),n=this.targetIds;if(3&e&&1===i.length)return n[i[0].identifier]=!0,[i,i];var r,s,o=P(t.changedTouches),a=[],h=this.target;if(s=i.filter((function(t){return _(t.target,h)})),1===e)for(r=0;r<s.length;)n[s[r].identifier]=!0,r++;for(r=0;r<o.length;)n[o[r].identifier]&&a.push(o[r]),12&e&&delete n[o[r].identifier],r++;return a.length?[D(s.concat(a),"identifier",!0),a]:void 0}g(ct,q,{handler:function(t){var e=ht[t.type],i=lt.call(this,t,e);i&&this.callback(this.manager,e,{pointers:i[0],changedPointers:i[1],pointerType:N,srcEvent:t})}});function pt(){q.apply(this,arguments);var t=T(this.handler,this);this.touch=new ct(this.manager,t),this.mouse=new J(this.manager,t),this.primaryTouch=null,this.lastTouches=[]}function ft(t,e){1&t?(this.primaryTouch=e.changedPointers[0].identifier,vt.call(this,e)):12&t&&vt.call(this,e)}function vt(t){var e=t.changedPointers[0];if(e.identifier===this.primaryTouch){var i={x:e.clientX,y:e.clientY};this.lastTouches.push(i);var n=this.lastTouches;setTimeout((function(){var t=n.indexOf(i);t>-1&&n.splice(t,1)}),2500)}}function dt(t){for(var e=t.srcEvent.clientX,i=t.srcEvent.clientY,n=0;n<this.lastTouches.length;n++){var r=this.lastTouches[n],s=Math.abs(e-r.x),o=Math.abs(i-r.y);if(s<=25&&o<=25)return!0}return!1}g(pt,q,{handler:function(t,e,i){var n=i.pointerType==N,r=i.pointerType==X;if(!(r&&i.sourceCapabilities&&i.sourceCapabilities.firesTouchEvents)){if(n)ft.call(this,e,i);else if(r&&dt.call(this,i))return;this.callback(t,e,i)}},destroy:function(){this.touch.destroy(),this.mouse.destroy()}});var mt=x(a.style,"touchAction"),gt=mt!==r,Tt="compute",yt="auto",Et="manipulation",It="none",At="pan-x",_t="pan-y",Ct=function(){if(!gt)return!1;var e={},i=t.CSS&&t.CSS.supports;return["auto","manipulation","pan-y","pan-x","pan-x pan-y","none"].forEach((function(n){e[n]=!i||t.CSS.supports("touch-action",n)})),e}();function St(t,e){this.manager=t,this.set(e)}St.prototype={set:function(t){t==Tt&&(t=this.compute()),gt&&this.manager.element.style&&Ct[t]&&(this.manager.element.style[mt]=t),this.actions=t.toLowerCase().trim()},update:function(){this.set(this.manager.options.touchAction)},compute:function(){var t=[];return f(this.manager.recognizers,(function(e){y(e.options.enable,[e])&&(t=t.concat(e.getTouchAction()))})),function(t){if(C(t,It))return It;var e=C(t,At),i=C(t,_t);if(e&&i)return It;if(e||i)return e?At:_t;if(C(t,Et))return Et;return yt}(t.join(" "))},preventDefaults:function(t){var e=t.srcEvent,i=t.offsetDirection;if(this.manager.session.prevented)e.preventDefault();else{var n=this.actions,r=C(n,It)&&!Ct.none,s=C(n,_t)&&!Ct["pan-y"],o=C(n,At)&&!Ct["pan-x"];if(r){var a=1===t.pointers.length,h=t.distance<2,u=t.deltaTime<250;if(a&&h&&u)return}if(!o||!s)return r||s&&6&i||o&&i&Y?this.preventSrc(e):void 0}},preventSrc:function(t){this.manager.session.prevented=!0,t.preventDefault()}};var bt=32;function Pt(t){this.options=s({},this.defaults,t||{}),this.id=w++,this.manager=null,this.options.enable=E(this.options.enable,!0),this.state=1,this.simultaneous={},this.requireFail=[]}function Dt(t){return 16&t?"cancel":8&t?"end":4&t?"move":2&t?"start":""}function xt(t){return 16==t?"down":8==t?"up":2==t?"left":4==t?"right":""}function wt(t,e){var i=e.manager;return i?i.get(t):t}function Ot(){Pt.apply(this,arguments)}function Rt(){Ot.apply(this,arguments),this.pX=null,this.pY=null}function Mt(){Ot.apply(this,arguments)}function zt(){Pt.apply(this,arguments),this._timer=null,this._input=null}function Nt(){Ot.apply(this,arguments)}function Xt(){Ot.apply(this,arguments)}function Yt(){Pt.apply(this,arguments),this.pTime=!1,this.pCenter=!1,this._timer=null,this._input=null,this.count=0}function Ft(t,e){return(e=e||{}).recognizers=E(e.recognizers,Ft.defaults.preset),new Wt(t,e)}Pt.prototype={defaults:{},set:function(t){return s(this.options,t),this.manager&&this.manager.touchAction.update(),this},recognizeWith:function(t){if(p(t,"recognizeWith",this))return this;var e=this.simultaneous;return e[(t=wt(t,this)).id]||(e[t.id]=t,t.recognizeWith(this)),this},dropRecognizeWith:function(t){return p(t,"dropRecognizeWith",this)||(t=wt(t,this),delete this.simultaneous[t.id]),this},requireFailure:function(t){if(p(t,"requireFailure",this))return this;var e=this.requireFail;return-1===b(e,t=wt(t,this))&&(e.push(t),t.requireFailure(this)),this},dropRequireFailure:function(t){if(p(t,"dropRequireFailure",this))return this;t=wt(t,this);var e=b(this.requireFail,t);return e>-1&&this.requireFail.splice(e,1),this},hasRequireFailures:function(){return this.requireFail.length>0},canRecognizeWith:function(t){return!!this.simultaneous[t.id]},emit:function(t){var e=this,i=this.state;function n(i){e.manager.emit(i,t)}i<8&&n(e.options.event+Dt(i)),n(e.options.event),t.additionalEvent&&n(t.additionalEvent),i>=8&&n(e.options.event+Dt(i))},tryEmit:function(t){if(this.canEmit())return this.emit(t);this.state=bt},canEmit:function(){for(var t=0;t<this.requireFail.length;){if(!(33&this.requireFail[t].state))return!1;t++}return!0},recognize:function(t){var e=s({},t);if(!y(this.options.enable,[this,e]))return this.reset(),void(this.state=bt);56&this.state&&(this.state=1),this.state=this.process(e),30&this.state&&this.tryEmit(e)},process:function(t){},getTouchAction:function(){},reset:function(){}},g(Ot,Pt,{defaults:{pointers:1},attrTest:function(t){var e=this.options.pointers;return 0===e||t.pointers.length===e},process:function(t){var e=this.state,i=t.eventType,n=6&e,r=this.attrTest(t);return n&&(8&i||!r)?16|e:n||r?4&i?8|e:2&e?4|e:2:bt}}),g(Rt,Ot,{defaults:{event:"pan",threshold:10,pointers:1,direction:30},getTouchAction:function(){var t=this.options.direction,e=[];return 6&t&&e.push(_t),t&Y&&e.push(At),e},directionTest:function(t){var e=this.options,i=!0,n=t.distance,r=t.direction,s=t.deltaX,o=t.deltaY;return r&e.direction||(6&e.direction?(r=0===s?1:s<0?2:4,i=s!=this.pX,n=Math.abs(t.deltaX)):(r=0===o?1:o<0?8:16,i=o!=this.pY,n=Math.abs(t.deltaY))),t.direction=r,i&&n>e.threshold&&r&e.direction},attrTest:function(t){return Ot.prototype.attrTest.call(this,t)&&(2&this.state||!(2&this.state)&&this.directionTest(t))},emit:function(t){this.pX=t.deltaX,this.pY=t.deltaY;var e=xt(t.direction);e&&(t.additionalEvent=this.options.event+e),this._super.emit.call(this,t)}}),g(Mt,Ot,{defaults:{event:"pinch",threshold:0,pointers:2},getTouchAction:function(){return[It]},attrTest:function(t){return this._super.attrTest.call(this,t)&&(Math.abs(t.scale-1)>this.options.threshold||2&this.state)},emit:function(t){if(1!==t.scale){var e=t.scale<1?"in":"out";t.additionalEvent=this.options.event+e}this._super.emit.call(this,t)}}),g(zt,Pt,{defaults:{event:"press",pointers:1,time:251,threshold:9},getTouchAction:function(){return[yt]},process:function(t){var e=this.options,i=t.pointers.length===e.pointers,n=t.distance<e.threshold,r=t.deltaTime>e.time;if(this._input=t,!n||!i||12&t.eventType&&!r)this.reset();else if(1&t.eventType)this.reset(),this._timer=l((function(){this.state=8,this.tryEmit()}),e.time,this);else if(4&t.eventType)return 8;return bt},reset:function(){clearTimeout(this._timer)},emit:function(t){8===this.state&&(t&&4&t.eventType?this.manager.emit(this.options.event+"up",t):(this._input.timeStamp=c(),this.manager.emit(this.options.event,this._input)))}}),g(Nt,Ot,{defaults:{event:"rotate",threshold:0,pointers:2},getTouchAction:function(){return[It]},attrTest:function(t){return this._super.attrTest.call(this,t)&&(Math.abs(t.rotation)>this.options.threshold||2&this.state)}}),g(Xt,Ot,{defaults:{event:"swipe",threshold:10,velocity:.3,direction:30,pointers:1},getTouchAction:function(){return Rt.prototype.getTouchAction.call(this)},attrTest:function(t){var e,i=this.options.direction;return 30&i?e=t.overallVelocity:6&i?e=t.overallVelocityX:i&Y&&(e=t.overallVelocityY),this._super.attrTest.call(this,t)&&i&t.offsetDirection&&t.distance>this.options.threshold&&t.maxPointers==this.options.pointers&&u(e)>this.options.velocity&&4&t.eventType},emit:function(t){var e=xt(t.offsetDirection);e&&this.manager.emit(this.options.event+e,t),this.manager.emit(this.options.event,t)}}),g(Yt,Pt,{defaults:{event:"tap",pointers:1,taps:1,interval:300,time:250,threshold:9,posThreshold:10},getTouchAction:function(){return[Et]},process:function(t){var e=this.options,i=t.pointers.length===e.pointers,n=t.distance<e.threshold,r=t.deltaTime<e.time;if(this.reset(),1&t.eventType&&0===this.count)return this.failTimeout();if(n&&r&&i){if(4!=t.eventType)return this.failTimeout();var s=!this.pTime||t.timeStamp-this.pTime<e.interval,o=!this.pCenter||j(this.pCenter,t.center)<e.posThreshold;if(this.pTime=t.timeStamp,this.pCenter=t.center,o&&s?this.count+=1:this.count=1,this._input=t,0===this.count%e.taps)return this.hasRequireFailures()?(this._timer=l((function(){this.state=8,this.tryEmit()}),e.interval,this),2):8}return bt},failTimeout:function(){return this._timer=l((function(){this.state=bt}),this.options.interval,this),bt},reset:function(){clearTimeout(this._timer)},emit:function(){8==this.state&&(this._input.tapCount=this.count,this.manager.emit(this.options.event,this._input))}}),Ft.VERSION="2.0.7",Ft.defaults={domEvents:!1,touchAction:Tt,enable:!0,inputTarget:null,inputClass:null,preset:[[Nt,{enable:!1}],[Mt,{enable:!1},["rotate"]],[Xt,{direction:6}],[Rt,{direction:6},["swipe"]],[Yt],[Yt,{event:"doubletap",taps:2},["tap"]],[zt]],cssProps:{userSelect:"none",touchSelect:"none",touchCallout:"none",contentZooming:"none",userDrag:"none",tapHighlightColor:"rgba(0,0,0,0)"}};function Wt(t,e){var i;this.options=s({},Ft.defaults,e||{}),this.options.inputTarget=this.options.inputTarget||t,this.handlers={},this.session={},this.recognizers=[],this.oldCssProps={},this.element=t,this.input=new((i=this).options.inputClass||(M?it:z?ct:R?pt:J))(i,k),this.touchAction=new St(this,this.options.touchAction),qt(this,!0),f(this.options.recognizers,(function(t){var e=this.add(new t[0](t[1]));t[2]&&e.recognizeWith(t[2]),t[3]&&e.requireFailure(t[3])}),this)}function qt(t,e){var i,n=t.element;n.style&&(f(t.options.cssProps,(function(r,s){i=x(n.style,s),e?(t.oldCssProps[i]=n.style[i],n.style[i]=r):n.style[i]=t.oldCssProps[i]||""})),e||(t.oldCssProps={}))}Wt.prototype={set:function(t){return s(this.options,t),t.touchAction&&this.touchAction.update(),t.inputTarget&&(this.input.destroy(),this.input.target=t.inputTarget,this.input.init()),this},stop:function(t){this.session.stopped=t?2:1},recognize:function(t){var e=this.session;if(!e.stopped){var i;this.touchAction.preventDefaults(t);var n=this.recognizers,r=e.curRecognizer;(!r||r&&8&r.state)&&(r=e.curRecognizer=null);for(var s=0;s<n.length;)i=n[s],2===e.stopped||r&&i!=r&&!i.canRecognizeWith(r)?i.reset():i.recognize(t),!r&&14&i.state&&(r=e.curRecognizer=i),s++}},get:function(t){if(t instanceof Pt)return t;for(var e=this.recognizers,i=0;i<e.length;i++)if(e[i].options.event==t)return e[i];return null},add:function(t){if(p(t,"add",this))return this;var e=this.get(t.options.event);return e&&this.remove(e),this.recognizers.push(t),t.manager=this,this.touchAction.update(),t},remove:function(t){if(p(t,"remove",this))return this;if(t=this.get(t)){var e=this.recognizers,i=b(e,t);-1!==i&&(e.splice(i,1),this.touchAction.update())}return this},on:function(t,e){if(t!==r&&e!==r){var i=this.handlers;return f(S(t),(function(t){i[t]=i[t]||[],i[t].push(e)})),this}},off:function(t,e){if(t!==r){var i=this.handlers;return f(S(t),(function(t){e?i[t]&&i[t].splice(b(i[t],e),1):delete i[t]})),this}},emit:function(t,e){this.options.domEvents&&function(t,e){var n=i.createEvent("Event");n.initEvent(t,!0,!0),n.gesture=e,e.target.dispatchEvent(n)}(t,e);var n=this.handlers[t]&&this.handlers[t].slice();if(n&&n.length){e.type=t,e.preventDefault=function(){e.srcEvent.preventDefault()};for(var r=0;r<n.length;)n[r](e),r++}},destroy:function(){this.element&&qt(this,!1),this.handlers={},this.session={},this.input.destroy(),this.element=null}},s(Ft,{INPUT_START:1,INPUT_MOVE:2,INPUT_END:4,INPUT_CANCEL:8,STATE_POSSIBLE:1,STATE_BEGAN:2,STATE_CHANGED:4,STATE_ENDED:8,STATE_RECOGNIZED:8,STATE_CANCELLED:16,STATE_FAILED:bt,DIRECTION_NONE:1,DIRECTION_LEFT:2,DIRECTION_RIGHT:4,DIRECTION_UP:8,DIRECTION_DOWN:16,DIRECTION_HORIZONTAL:6,DIRECTION_VERTICAL:Y,DIRECTION_ALL:30,Manager:Wt,Input:q,TouchAction:St,TouchInput:ct,MouseInput:J,PointerEventInput:it,TouchMouseInput:pt,SingleTouchInput:ot,Recognizer:Pt,AttrRecognizer:Ot,Tap:Yt,Pan:Rt,Swipe:Xt,Pinch:Mt,Rotate:Nt,Press:zt,on:I,off:A,each:f,merge:m,extend:d,assign:s,inherit:g,bindFn:T,prefixed:x}),(void 0!==t?t:"undefined"!=typeof self?self:{}).Hammer=Ft,"function"==typeof define&&define.amd?define((function(){return Ft})):void 0!==e&&e.exports?e.exports=Ft:t.Hammer=Ft}(window,document)},
function _(e,s,i,t,n){t();const r=e(42),a=e(43);class _ extends r.View{initialize(){super.initialize(),this.el=this._createElement()}remove(){(0,a.remove)(this.el),super.remove()}css_classes(){return[]}render(){}renderTo(e){e.appendChild(this.el),this.render(),this._has_finished=!0,this.notify_finished()}_createElement(){return(0,a.createElement)(this.constructor.tag_name,{class:this.css_classes()})}}i.DOMView=_,_.__name__="DOMView",_.tag_name="div"},
function _(o,t,b,r,e){r(),b.root="bk-root",b.toolbar_hidden="bk-toolbar-hidden",b.toolbar="bk-toolbar",b.logo="bk-logo",b.above="bk-above",b.below="bk-below",b.left="bk-left",b.right="bk-right",b.toolbar_button="bk-toolbar-button",b.tool_overflow="bk-tool-overflow",b.active="bk-active",b.divider="bk-divider",b.horizontal="bk-horizontal",b.vertical="bk-vertical",b.default='.bk-root .bk-toolbar-hidden{visibility:hidden;opacity:0;transition:visibility 0.3s linear, opacity 0.3s linear;}.bk-root .bk-toolbar{display:flex;flex-wrap:nowrap;align-items:center;user-select:none;-ms-user-select:none;-moz-user-select:none;-webkit-user-select:none;}.bk-root .bk-toolbar .bk-logo{flex-shrink:0;}.bk-root .bk-toolbar.bk-above,.bk-root .bk-toolbar.bk-below{flex-direction:row;justify-content:flex-end;}.bk-root .bk-toolbar.bk-above .bk-logo,.bk-root .bk-toolbar.bk-below .bk-logo{order:1;margin-left:5px;margin-right:0px;}.bk-root .bk-toolbar.bk-left,.bk-root .bk-toolbar.bk-right{flex-direction:column;justify-content:flex-start;}.bk-root .bk-toolbar.bk-left .bk-logo,.bk-root .bk-toolbar.bk-right .bk-logo{order:0;margin-bottom:5px;margin-top:0px;}.bk-root .bk-toolbar-button{width:30px;height:30px;cursor:pointer;background-size:60% 60%;background-origin:border-box;background-color:transparent;background-repeat:no-repeat;background-position:center center;}.bk-root .bk-toolbar-button:hover,.bk-root .bk-tool-overflow:hover{background-color:rgba(192, 192, 192, 0.15);}.bk-root .bk-toolbar-button:focus,.bk-root .bk-tool-overflow:focus,.bk-root .bk-toolbar-button:focus-visible,.bk-root .bk-tool-overflow:focus-visible{outline:1px dotted #26aae1;outline-offset:-1px;}.bk-root .bk-toolbar-button::-moz-focus-inner,.bk-root .bk-tool-overflow::-moz-focus-inner{border:0;}.bk-root .bk-above .bk-toolbar-button{border-bottom:2px solid transparent;}.bk-root .bk-above .bk-toolbar-button.bk-active{border-bottom-color:#26aae1;}.bk-root .bk-below .bk-toolbar-button{border-top:2px solid transparent;}.bk-root .bk-below .bk-toolbar-button.bk-active{border-top-color:#26aae1;}.bk-root .bk-right .bk-toolbar-button{border-left:2px solid transparent;}.bk-root .bk-right .bk-toolbar-button.bk-active{border-left-color:#26aae1;}.bk-root .bk-left .bk-toolbar-button{border-right:2px solid transparent;}.bk-root .bk-left .bk-toolbar-button.bk-active{border-right-color:#26aae1;}.bk-root .bk-divider{content:" ";display:inline-block;background-color:lightgray;}.bk-root .bk-above .bk-divider,.bk-root .bk-below .bk-divider{height:10px;width:1px;}.bk-root .bk-left .bk-divider,.bk-root .bk-right .bk-divider{height:1px;width:10px;}.bk-root .bk-tool-overflow{color:gray;display:flex;align-items:center;}.bk-root .bk-above .bk-tool-overflow,.bk-root .bk-below .bk-tool-overflow,.bk-root .bk-horizontal .bk-tool-overflow{width:15px;height:30px;flex-direction:row;}.bk-root .bk-left .bk-tool-overflow,.bk-root .bk-right .bk-tool-overflow,.bk-root .bk-vertical .bk-tool-overflow{width:30px;height:15px;flex-direction:column;}'},
function _(A,g,o,C,l){C(),o.root="bk-root",o.tool_icon_copy_to_clipboard="bk-tool-icon-copy-to-clipboard",o.tool_icon_replace_mode="bk-tool-icon-replace-mode",o.tool_icon_append_mode="bk-tool-icon-append-mode",o.tool_icon_intersect_mode="bk-tool-icon-intersect-mode",o.tool_icon_subtract_mode="bk-tool-icon-subtract-mode",o.tool_icon_clear_selection="bk-tool-icon-clear-selection",o.tool_icon_box_select="bk-tool-icon-box-select",o.tool_icon_box_zoom="bk-tool-icon-box-zoom",o.tool_icon_zoom_in="bk-tool-icon-zoom-in",o.tool_icon_zoom_out="bk-tool-icon-zoom-out",o.tool_icon_help="bk-tool-icon-help",o.tool_icon_hover="bk-tool-icon-hover",o.tool_icon_crosshair="bk-tool-icon-crosshair",o.tool_icon_lasso_select="bk-tool-icon-lasso-select",o.tool_icon_pan="bk-tool-icon-pan",o.tool_icon_xpan="bk-tool-icon-xpan",o.tool_icon_ypan="bk-tool-icon-ypan",o.tool_icon_range="bk-tool-icon-range",o.tool_icon_polygon_select="bk-tool-icon-polygon-select",o.tool_icon_redo="bk-tool-icon-redo",o.tool_icon_reset="bk-tool-icon-reset",o.tool_icon_save="bk-tool-icon-save",o.tool_icon_tap_select="bk-tool-icon-tap-select",o.tool_icon_undo="bk-tool-icon-undo",o.tool_icon_wheel_pan="bk-tool-icon-wheel-pan",o.tool_icon_wheel_zoom="bk-tool-icon-wheel-zoom",o.tool_icon_box_edit="bk-tool-icon-box-edit",o.tool_icon_freehand_draw="bk-tool-icon-freehand-draw",o.tool_icon_poly_draw="bk-tool-icon-poly-draw",o.tool_icon_point_draw="bk-tool-icon-point-draw",o.tool_icon_poly_edit="bk-tool-icon-poly-edit",o.tool_icon_line_edit="bk-tool-icon-line-edit",o.default='.bk-root .bk-tool-icon-copy-to-clipboard{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUSDBoBvcHQeQAAAG9JREFUWMNjXLhsJcNAAiaGAQYwB/xHwh/Q+ITEkfHQCwEWND4jmeb8H/JpgBwfI6cNBhLSEkqaGXRpgFRAcZoZsmlg1AGjDhh1wKgDRh0w6gCaVcf/R2wIkNqw+D9s0wADvUNiyIYA47BJAwPuAAAj/Cjd0TCN6wAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-replace-mode{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxokK3gniQAAAHpJREFUWMNjXLhsJcNAAiaGAQajDhhwB7DgEP+PxmeksvjgDwFcLmYkUh2hkBj8IcBIZXsYh1w2/I8v3sgAOM0bLYhGc8GgrwuICgldfQO88pcvXvg/aOuCUQeM5oLRuoCFCJcTbOMh5XOiW0JDNhdQS3y0IBp1ABwAAF8KGrhC1Eg6AAAAAElFTkSuQmCC");}.bk-root .bk-tool-icon-append-mode{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxkZWD04WwAAAB1pVFh0Q29tbWVudAAAAAAAQ3JlYXRlZCB3aXRoIEdJTVBkLmUHAAAAoUlEQVRYw+1WQQ6AIAwrhO8Y/bIXEz9jIMSDr8ETCUEPQzA4pMeFLKNbu4l5WR0CDOMEALBGIzMuQIBEZQjPgP9JLjwTfBjY9sO9lZsFA9IafZng3BlIyVefgd8XQFZBAWe8jfNxwsDhir6rzoCiPiy1K+J8/FRQemv2XfAdFcQ9znU4Viqg9ta1qYJ+D1BnAIBrkgGVOrXNqUA9rbyZm/AEzFh4jEeY/soAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-intersect-mode{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxkrkOpp2wAAAPhJREFUWMPtV1EKwjAMTUavI3oawR/vtn5srJdREfzwMvHHQlcT2mpdMzFfWxiP5r2+JMN+mAiCOB72CABgR1cln4oOGocJnuMTSxWk8jMm7OggYkYXA9gPE3uyd8NXHONJ+eYMdE/NqCJmEZ5ZqlJJ4sUksKN7cYSaPoCZFWR1QI+Xm1fBACU63Cw22x0AAJxudwrffVwvZ+JmQdAHZkw0d4EpAMCw8k87pMdbnwtizQumJYv3nwV6XOA1qbUT/oQLUJgFRbsiNwFVucBIlyR3p0tdMp+XmFjfLKi1LatyAXtCRjPWBdL3Ke3VuACJKFfDr/xFN2fgAR/Go0qaLlmEAAAAAElFTkSuQmCC");}.bk-root .bk-tool-icon-subtract-mode{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxgsF5XNOQAAAB1pVFh0Q29tbWVudAAAAAAAQ3JlYXRlZCB3aXRoIEdJTVBkLmUHAAABFUlEQVRYw9VWUQqDMAxNpWfxQxD1MoP97G7zQ5mH2RTZYLtM9lWoMbXtxLXNX4OG9r28l4hrd0PQoqxqAACYpxH25C/nkwCHyCBwSPoS09k1T5Fo+4EiExcC4v584xGFmyIXHBLRISAVZyZufUPVa4rcrwmPDgr93ylo+2GliLRUYHK6th/o/6r7nfLpqaCsagEA8Hh9FmcNKeRmgeYDC+SCq0B6FFi8/BcV6BdR9cL3gCv3ijPKOacsn3rBEcjmaVxpfGcg4wHxzgJJnc6241Hn23DERFRAu1bNcWa3Q0uXi62XR6sCaWoSejbtdLYmU3kTEunNgj0bUbQqYG/IcMaqwPS9jftoVCAQ0ZVDJwf0zQdH4AsyW6fpQu4YegAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-clear-selection{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUGEhcuan3d3wAAAoRJREFUWMPtlzFP3EAQhd+b3TNSzg0N5TWXLkJQUUaKhIQ4fgP/g5ArrriE/I3opEgRrZtIVJR0FJQ010SioUmEZHtnUpwN9gWHGA5BJCy58MraffvmfZ41v3z9hqe8BE98vQh4cgG+Ydzmnrng8efvQJNi/uN7dznx/B3ggtfhf4ehNdUttRzBDIm/2VTiiWCG1HK0nc+3UWtq8BQIiEEakEQOADBIA4QCQmBqoHBhFNR27ikQSmGdYCdTqCpEHMDZmEKRWUBEv1gBDg5SzRJnpopILWICgWuRYflLamuzxB2BmtYqSRIka5VWU8QduXO+1hRc5YZu5GAwmP2ZJzND0IBu5HCV2+NQcAhAVRsnC2IbPzPdSjzd6to6VtfWkXi6YLaVWr7xoAwkfpb8MnC3SH7rKSMBe4M0jA/OTicFIbtCGRIyNbURhcf3ErCd6YwA1m0HgAxhw1NGQnlXBHG4kylVlSJuH0RfIP2CkL2I/qS1gIAAQiBl1QwFggIHtyxgrxK5PgyfC0JWKoT0HLh8LwoietB4TYKaIl7yeNURxB05UtMxDOcVQlZIrlRKdK6m47gjR/fuBRQihyLArtNeJD50Izcx2Eczu7iFkIug4VM3cpOr3MKDekFED0fWUHv9Zq0kpLnridjhY3XDg7NTN0jDrhO3X7O9Wg7wwyANu4mnayNg3gmbu0tCNoUyBNGv2l4rB9EXynA7082FOxAQLhU6rQVO9T2AvWowFToNCJcPORGxIRcnpjZSKATSU9NxvOQnAPArDSaQoUKnNI4iufkGtD4P3EHIcWZhz4HLceSOyrR3Izf5memPAL2cX3yhAkonysZVaWLBkd9dw1Ivv2a/AYPkK+ty1U1DAAAAAElFTkSuQmCC");}.bk-root .bk-tool-icon-box-select{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg0kduFrowAAAIdJREFUWMPtVtEKwCAI9KL//4e9DPZ3+wP3KgOjNZouFYI4C8q7s7DtB1lGIeMoRMRinCLXg/ML3EcFqpjjloOyZxRntxpwQ8HsgHYARKFAtSFrCg3TCdMFCE1BuuALEXJLjC4qENsFVXCESZw38/kWLOkC/K4PcOc/Hj03WkoDT3EaWW9egQul6CUbq90JTwAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-box-zoom{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg82t254aQAAAkBJREFUWMPN11+E1FEUB/DPTFn2qaeIpcSwr5NlUyJiKWVXWUqvlUh/iE3RY9mUekkPPURtLKNRrFJEeuphGfUUaVliiX1aVjGs6aG7+XX9ZnZ+d2fTl2vmnHvPPfeee/79Sk+may2/UQq/q7Qu+bAJoxjHIKqB/wlfUMcMVqI9bLZ+DGIKwzlzQ2GcxCx2xwvKOUKlaHTiX8bHNspjDONHkOmJBW5jIof/FvPh/06MZOb6cRc7cGn1AKUE5cdzlM/gAr5F/O24H3xkFRfxAbVygvK+cIsspjGWo1zgjeFpxL+BvnLw7laBA4xjIFJwrgu52DoVjKdY4HBEX8dSF3JLYe1fe6UcYCii3xWQjdfuSTnAtoheKCC7GNED5Zx4L4qt61jbTLHA94geKSC7P7ZeShQ0Inoi1IJuEOeORooFXkV0FZNdZs5qvFfKAeqYy7nZ6yg//HG0MBfffh71lFrQDCW2EvEP4mt4okZUDftz9rmGZkotmMxJRtlisy+MTniAWrty3AlXw0hFM2TD89l+oNsoOJXjbIs4EpqNtTCLXbiZ0g+M4mFObj8U3vsNjoZCVcmk60ZwthpepLZkB/AsivWfOJZxtpUQHfWib7KWDwzjeegBZJSdKFiE2qJTFFTwElsi/unQ/awXrU4WGMD7nOJxBY/1EO2iYConq93CHT1GOwucjdqnRyFz+VcHmMNefMY9nNkA3SWUOoXhQviSWQ4huLIRFlirFixnQq/XaKXUgg2xQNGv4V7x/RcW+AXPB3h7H1PaiQAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-zoom-in{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgsUBmL8iQAAA2JJREFUWMO9l12IlFUYx3//MzPrLpSjkm5oN4FFIWVEl66IQlFYwtLOzozsjHdGRSCRF0sfBEXRVV0FQuQiLm5CZNBFgRRaRLVFhbJ2EdiN5gbK7toObTPn6eYdPTvNzPvOBz5Xh/ec5/n/n89zXtEHmZqeSXSuXBz/3zfdKvBWJHQrwZuRcP0El+QkbQXeBX6WZEgm6TtJk5lM5o4Lc+cV6qpf4Ga20Tm338zeATItVK9Ker6yvPzp4NDQ3+XieGsCU9MzTYumGbhz7m4ze9/MHgvBgItACrgfGAj2jgAvAYs3wlEujjc13kii8YyZrXXOfWhmo9GnFUlvOOemarVapVqtkslksmb2KjARqL62ecuWN9NxbRInzrldAXhV0uFSIfdew7G/gNLU9MwS8CwSmE3Oz88fcXG5blfpqVRq0Ix8VIAAX0XgrVL7HDCHGcCaWrV60LUBN8Dae58aQIxEqcA592I9M610JL0cpG/U9TIHJNKY3RV5z0R+7Nd4HZ0P1g/2RMBuegLAsRMnb4vT8d5vqKfMzOgtAlADrkmqGywmiMBTwfr3dC9j1Xv/r6Tvg/5/5ejxE6cO7M9faVbQZrYNOFSPmqQvVo9FKexvi5uWX58943aM7DwAfBDY+FbSCxP5sdkGx55GeguzrUEXPaSo2pFkAbiSZQCAzZJOmdkjwd6SpB/M7KykQTPbA2wDhoIzRzcNDx9MJwGNIXdJ0mEzmwbujL7dbma7gd03A7lKfnTOvf74nl0r6bonTUbujRSUCrm2d4L3/kvn3JPe+8+BDW2i9o+kT7z3kxP5sYsA6W47oE64TsR7P9tQL4vA2mh9WdIscKxUyJ0M7aR7acOGzikD65EQLEjaa2ZXzMwDFeB6qZBbbLTRE4EGeSaozNOZgYFf8qP7lmIvs354n0qlHpB0T7B9Ogl4IgJJrmjv/SiQjbrkD+BMUkfSbYATPdckrTOzkciWAXOlQu5cYgLdPEIapud9wMOR9zVJH3ViKx333mtHMJvNuoWFhZ3A+ojMcja77njXBEKwJJfTcqUyCIQ34Mf7nnh0paMnXacFuGoC1mr3AtuDfLzd8Zuyl+rfuGn4HLAD+Az4qZQf+61TAj0Noj8vX6oC35SL43u7teG6rf5+iXppwW7/JUL5D03qaFRvvUe+AAAAAElFTkSuQmCC");}.bk-root .bk-tool-icon-zoom-out{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgsHgty9VwAAA0FJREFUWMO9l09oXFUUxn/fmXlpItppi22k7UJBRSlVkCytSAuKUloIdjKT0El3FXVXdVFKRVAQV7qQohsNwdA0UFvBhYtqUVyIVlRaogtFQVq7qSTVjA3z3nHzBq/jvPmTN/Ss7rv3nvN99/y794kByMzcfE/7picn/jenmwWeRUI3E7wdCRskuCSTdDfwBvCtJEdySV9KOhpF0e0/LF5SqKtBgbv7ZjObcvfXgShD9Zqk5+orKx8Oj4z8NT05kU1gZm6+bdK0Azezu9z9hLs/HoIBvwAF4H5gKFh7B3gBWFY3460kWve4+3oze9fdx9OpVUmvmNlMHMf1RqNBFEUldz8OHAxUX9q6bduryut+Sfvc/Wz62ZD0fK1afjND9y3gGSRwv1GMojstTxUUCoVhdyopEYDzKXjWwZ4FFnEHWBc3Goet00m7lZlZYQixKw0FZnakGZksHUnHgvCN5/KARBH37enpOVg58H13HV0Kxg/kIuD/ngSA2ZMLt3bTSZJkUzNk7k4+D0AM/CGpaXCyBw/sC8Y/qZd2GpZiuL9YLN4Sx/HpoP5/c/exQ1OVq+1yyt13SLoArEsJnMjlgfOffvK3u58Kprab2QezJxfG2iTzUzI70wRPG9jbmpmb95SNB9mpzp7/j2yVdNbdx4K565K+cvfPJQ27+x5gBzAS7Hlvy+jo4WIvoC3kWpcvS3rR3eeAO9K529x9N7C7zX6AC2b28hN7Hl1Vt44niVq13LUjmtlYkiQfA5s6eO+GpDNJkhw9NFX5ueNt2ARodyF1IHIN2JiOl4H16fiKpK+B2Vq1vBAqFAf4IJkGNiIhWJK0192vunsC1IE/a9XycquNXARa5OnApeeioaHvKuP7r3dTGsiLqFAo7JR0T7B8rhfwXARa2us4UEqr5Ffgs151i/08oTNKdIO770ptObBYq5Yv5ibQq/sl3Qc8lJ4+lnSqH1vFfp9koZRKJVtaWnqkWXqSVkqlDe+vmUDWpZMlK/X6MBDegKf3P/nYaj8ErN9fqZBYEsf3Ag8G8Xit33BaniTcvGX0IvAw8BHwTa1y4Md+CeRqRL9fudwAvpienNi7Vhu21uwflOT+L+i1X2TJP57iUvUFtHWsAAAAAElFTkSuQmCC");}.bk-root .bk-tool-icon-help{background-image:url("data:image/png;base64,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");}.bk-root .bk-tool-icon-hover{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4oVHp0SwAAAQJJREFUWMPtlsENgzAMRb8RQ5VJItFDOgaZAMaAA0iZpN3KPZSoEEHSQBCViI/G8pfNt/KAFFcPshPdoAGgZkYVVYjQAFCyFLN8tlAbXRwAxp61nc9XCkGERpZCxRDvBl0zoxp7K98GAACxxH29srNNmPsK2l7zHoHHXZDr+/9vwDfB3kgeSB5IHkgeOH0DmesJjSXi6pUvkYt5u9teVy6aWREDM0D0BRvmGRV5N6DsQkMzI64FidtI5t3AOKWaFhuioY8dlYf9TO1PREUh/9HVeAqzIThHgWZ6MuNmC1jiL1mK4pAzlKUojEmNsxcmL0J60tazWjLZFpClPbd9BMJfL95145YajN5RHQAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-crosshair{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAADEUlEQVRYR81XXVIaQRCeHqug8CXmBNETaE4gniDwIgpVspxAbxC9ATkBkCpQ8gKeQDiB5AQxNyAvUlrldr7eHxyGXZi1rMJ5opbp7m++7un+htSGF204vsoMoNXrlzSpfWa1oxQfhAegCZGaEtPorHo8znIoJwCt6+td8uk7ApUQCIHTF4BNAWzImq8ap6cP68CsBdDp9i9ZqXM7ML79g/EnCWD+jgMKENKqWT+tXK0CkQqgNRjs0OxpQIqKhoMxaG6/6JeRnK7T6yO2UvVqhYSlLX+ryORfgKn9ORDFIy7ky41yGcwsr0QAQfDH5zucOswx819fs4egI9OFCcD8DjBF7VNbEX0JzdWEt3NHSSASAcCxBDqMgt/623kvyTgNgNjJIfTjk4D4FqaJR1715MjmYAmA5Bx3AwUXQL+t105KaTlcBSC26XRvhjEIoLiq1yqXpr8FAGG16/ug4IT27fxBWu7EiQuAiImJpEMKE6nYM30uAIDDttSUOPfJP7JzbjPhAiBIh9QE67vIvoOi9WJfCwDavf40ulpjbCqmUf+W753ezURuh7Dg1SqflwAEHU6pgfyBq9Y4qx0LG++2fnZ/eUzcstmdM2AWH+jfc+liWdBJfSENf8Lifi3GVwC9mybOfi5dzatWVrbbLIHNva8p5h/16gkaFiLGGxbufkoE6XguwePiXLF3XmMfCUCUAqtKXU7sumd1CowOuJEi3Pg1FBpjitIGhyvVSfvmjci6ZR+rFQfDiPVE2jFYeICQ+PoewwjC5h7CZld6DBdyu6nDSKgzOyIMhmhK5TTqXYbRorZYM46TmpKAAOrGWwSJJekSB1yqJNOzp1Gs7YJ0EDeySDIMtJbQHh6Kf/uFfNFZkolJICRmz0P8DKWZuIG2g1hpok+Mk0Qphs0h9lzMtWRoNvYLuVImUWrmPJDlBKeRBDfATGOpHkhw670QSHWGLLckmF1PTsMlYqMJpyUbiO0weiMMceqLVTcotnMCYAYJJbcuQrVgZFP0NOOJYpr62pf3AmrHfWUG4O7abefGAfwH7EXSMJafOlYAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-lasso-select{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgwlGP1qdAAABMBJREFUWMO9V1uIVVUY/r61z57ZMx4DnbzgkbQXL5iCJphlWdpIGY4jpFBkEiU9ZNaDRRcITcIwMwgxoQtU2IMXdAZfMjFvpERXYiSbysyBEXFmyuHMnLP32uvrwT2xnY5nxvHQ93Jg7fWv71/r//7L4a59TRgqJk+Z6v3a+sv0OI5nk5wu6VaSVZImAThHsgjgrKTvM5nMUWvtmf5n8HodCIKgOgzDhc65pSTrJQWDsSNpJX1ljHnDOfdT37oZLLHv+8OMMasKhcIJ59xHAJYMlhwAJGUAzJfUTHLFuFzOG5QDU6dNMyQfs9Yedc5tBpAD4IYYNQGoBrDtQnt7/b0LFrJsCHzfn2itfQfAnZLiazytA3AaQAuAiwDaEgeNpGkkswAWSBqRONB38b88z5uTKePt6iiKXkk8jq+iJC5LOmiMaTLGHLPWhmWeHr7vV0dRtATAapAzIVmSo51zyzIlbm2stesFPA6pKk0r6Ryg93y/ek8YFvPOOTg3cDSiKCoC2OP7/rEoirYm4rUkF12lAWNM1lr7lqQn0+QA8gI2jBg5cj6Aj8OwmB+KAKIoukhyp6SRJAUgl0ndPLDWPi9pJQCbuviXvu+/GIZhW1dnJ24UJFuTjCCA2ADA8sYGWmsXS3qmL94kDYAtkh4Nw7ANlQJ5U6INT1KrAYC9zQdykl7nFSj5fXp5Y8NWVBhy7mUAjqShMYdMXV2dJ2klyRwAJ8lIeuGWCRMP7N7frEqSG2OmAFhKshNAp5wrmO7u7jEAngPQm1S2z2pqapr+OPt7XEly0oxwzq2RdFmSD2AMgKKJouhhAL4kA+Cs53l7e3t7uytJHgRBreTWkXwkKVJnJD0B4GAGwIJE9R6AFufc6UqSZ7PZbD6ff5dkA4CQZEHSqwAOISmXtwGIE+F1SeqqIP8d+Xz+C0mLJYWSAODteXffczjdDQNJ0BWMCoLg5gqIbRTJNwHsljQhUb0luWPM2LE7Thw/9m/5NCT/TByxAOYWi8X6/gdWV1dnfN8fNRBxJpMZTXKdc+6IpFVJWAEgkvSJpA0X2tvtVTaSjgOYBCAEEADYSHK87/sfhmEYA9gShuEDkgzJHyWtB/B1irQ2juP7ADxkrX0wOUOpzmdpzEY590HJ7Ni1r2kSyZOSiv2+hSRjSTXp/QAukzySNJOJkmalyNIl10hqMcasdc61XDNcQRD8BnITgNp+36r6kfcNFMMlLQGwTNLMEuQGQBfJl2bdPru+HDkAZAqFQux53jZHEsC6aw0eg2gylNRBcqcx5v04ji999+03AwsWAOI4Lsy9a94WkisAnE5a5WCJYwCfA1g7LJudI2lTHMeXBm1faiQzxkyRtF3S5CTupeAB+KG2tnZFT0/P30NO2VKLzrmfAbwGMipjG5Oc0dPTc0Md05SZ5U4Q2FxChErtEYD7jTGNQ3UgM8Asv90Yc9I5LSKRlXSI5CxJa0jWSALJjKRnAewfkniT+vwf7N7fXHK9rq7O7+jo+BTA/NRrdBpjnnLOnUrvXd7YMPQXSBunneno6IhIHgYwW1JtkgmBpBkATlVMAwOk3nFJ+VSoqgCMr6gIy2FcLtdKspAedyQN/98caDt/3kpyabUmf8WvG/8A1vODTBVE/0MAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-pan{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4lKssI9gAAAOtJREFUWMPVll0KwyAMgNPgoc0JzDX2Mtgp3csKErSamGabIEUo/T6bHz0ezxdsjPJ5kvUDaROem7VJAp3gufkbtwtI+JYEOsHNEugIN0mgM1wtsVoF1MnyKtZHZBW4DVxoMh6jaAW0MTfnBAbALyUwCD6UwEB4VyJN4FXx4aqUAACgFLjzrsRP9AECAP4Cm88QtJeJrGivdeNdPpko+j1H7XzUB+6WYHmo4eDk4wj41XFMEfBZGXpK0F/eB+QhVcXslVo7i6eANjF5NYSojCN7wi05MJNgbfKiMaPZA75TBVKCrWWbnGrb3DPePZ9Bcbe/QecAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-xpan{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4X4hxZdgAAAMpJREFUWMPtlsEKwjAMhr/pwOOedINJe/PobWXCfAIvgo/nA4heOiilZQqN2yE5lpD/I38SWt3uD9aMHSuHAiiAAmwaYCqoM/0KMABtQYDW11wEaHyiEei28bWb8LGOkk5C4iEEgE11YBQWDyHGuAMD0CeS30IQPfACbC3o+Vd2bOIOWMCtoO1mC+ap3CfmoCokFs/SZd6E0ILjnzrhvFbyEJ2FIZzXyB6iZ3AkjITn8WOdSbbAoaD4NSW+tIZdQYBOPyQKoAAKkIsPv0se4A/1UC0AAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-ypan{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4anK0lywAAAMVJREFUWMPtlzEKwzAMRX/S7rlpIMXeOnaLaME36FLo8XqCdNFghGljyc4kgQi2Q/SUj0F/eL7eMMTKz6j9wNlYPGRrFcSoLH4XxQPvdQeYuPOlcLbw2dRTgqvoXEaolWM0aP4LYm0NkHYWzyFSSwlmzjw2sR6OvAXNwgEcwAEcwAEcwAEcoGYk20SiMCHlmVoCzACoojEqjHBmCeJOCOo1lgPA7Q8E8TvdjMmHuzsV3NFD4w+1t+Ai/gTx3qHuOFqdMQB8ASMwJX0IEHOeAAAAAElFTkSuQmCC");}.bk-root .bk-tool-icon-range{background-image:url("data:image/png;base64,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");}.bk-root .bk-tool-icon-polygon-select{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEjc1OfiVKAAAAe1JREFUWMPt1r9rU1EUB/DPK0XbqphFHETo4OCiFhwF0V1KHbRSROLqon+AUMVRRFBwEbRFMBiV+mMW/wIxi5OD1kERRVKRJHUwLvfBTZrU5OWBGXLgQu7Jfe98z/ec7z0vKa88b2q1BDtRHdAPBaylm1NzsxsOjPnPNt6WSWprbft+/c3I3zOAjhT1Y4+fvcjEQJIXnVECSa+AhqIHqlHH5lWCZoe+Gk4GRgDG86j9SAUdlDBSQaZhlOkuHyoVdJmsw98D1S5fM4NYM1LCpqM+Lwa240oLgmZzpVZvzKT75VLZcqksSZKWlQeAy/iORVwIvh31xvotvK7VG3Px4aWHj3Jl4C2uYSvq+Bn8v6LLbaVWb9zsBiKLCvbiNG7gLm7jAYqbPHMJMziZ9lsKoh8GtqCEVVzHftwJn+TFHp4/hg8BSCYVfMOZoPEv2NZGdy9WCGUr9toDR3E2/H4V6nwRe/BmgN65H1ZhvMuB3XiKIyFoGefwO6ysVkUlrNUNsyAK/jli533Q+Y8cJFvAeXyMS1CI/jiMr/gUtD2LQwMGr4R3p7bY3oQHQ5b38CT4D2AXXg6YcQXHpyYnlqKsi5iOAVSwL9zd7zJ09r+Cpwq72omFMazjT9Dnibym0dTkRDUKrrgwH7MwXVyYB38BstaGDfLUTsgAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-redo{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4itK+dVQAAAaFJREFUWMPt1L1rFFEUBfDfJDaBBSslIFjbaSFp1FJQFMVCHkzhKIqdUYOCoBgErVz8rCwiTDMwBCIKipDWyip/gxAIWAmBgBC0eYFh2Gx2l9lFcA5M8e59782Zc84dWrT435Hs1siLchqn43MS0zgW22vYxjesYjVLw3YjBPKinMUTBOwf8J5fKLGYpWFjJAJ5Uc7gIW6jM6Kim3iNZ1katgYmEL/6I+YasvY7Lg6iRpIX5VF8wuEe/XV8wGf8jN6LWTiAc7iEQ7ucPZ+lYW0vAtfwvlbfwCKW9gpXDOv1mJvZHiSO91MiyYsyiQSuxtpXXM7SsDmM5nlRdrCMMz3sOJWl4Xevc/vwBzdwAl+yNNwZxfRI+GxelK9ikHcwh8d4NNR/YFRES1ZwoTYdR7I0rNf3TzVNIGbmSvR/Bx08mIgCFSVu4l2ltIWD9WxNGR+W8KOynqnZ0rwCeVG+wa0hjrxtWoF5dAfc28V8Mib/n+Nev5dnabg/zgw87aNEN/bHOwVRiRe4Wym9zNKwMKkpgIWKEt24njxiJlq0aPFv4i9ZWXMSPPhE/QAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-reset{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4gWqH8eQAABLdJREFUWMPtlktsVGUUx3/nfvfOlLQaY2IiRRMQIRpI0PjamJhoVASDvNpCpYw1vJQYSVwZwIVQF6wwRHmkAUof9ElrI6VqDAXcID4TF0IiYQMkSlTokNCZ+b7jove2t+NMH7rQBWd3v+989/zP+Z8X3Jb/WGQySvUNTQBJESkNguAVYIWqzhaRhwBU9WcR+QXoymazn6jqzUQiMQSQzWZRVdal1vwzAI2tHQBPOuc2AbWTdOyQ53n7nHNfRwee51GzqoIQMCLDpr3x/tLQ0oZzrk5Vj0/BOEBt+KYuOlBVGlrahr0Wob27t3gEjnZ2AyQzmUwHsDgP6J/AYRE553neDwDOuUdU9QngNeCumK4TkRMhZUORcYC1qysLA6iuSQHIwkWLD6lqapQsuSmwTVV3h99I7EcAR462A2xR2Ilq6ehTaejvO1774kuLNALR33eclsaGsQDe3fYegHl43vyNwEeqGl1963mm2jl7YZRTQ82qlWP4HM6ZToC5ztkW4LHQoALru7s6Di5dvlIj/e6ujrEAWoZDn8hmMjXATMACGaAVuBjXTVVXFc/AxhaA+4zvn1DV+eHxVWPMAmvtb5GeMWZyZVhI2rt7qVy2pOh9U1snwIPW2vMi4oWJuBPYHkVAVScPoKmtkzVVK6cEMsyJraHhiCqJqJUwj/JRz7TW1iSSyR2rVyylqa0Ta+24Ic8vXaAEmDFc/l5Z2A/80OibuVyuz/f9ElUdHCmvw82t5HK5h6y1PYhsz2YyGw43t2KtBZHIGwB6+j4rCkBVUdV7gXrggnPuu8h4eP+xMeZS2D0rJYZ6AdAMzAt1b4nI26p6IFZOY8pugijcKSIHVLUK0LyST4vnrVfnWr3mjmP4QTATaERkXkypRFX3isjmuHdRJEK6Ckqquopp06bdKCkp2Sgi7XnGLcg7gzeutwNIiPYc8HixqIrIOlU9ONVIhHPEd851icgSVXUiskVV94gIqoonIt0i8gfQCfwae38e6BWRXuBZz5jZ8VbaOE4EIqlZVUEQBLlkMplS1QER2RwkEnsSyaREDUzyeNsvIhvCMqkH1kdIJ2o+k8iJB1LVVRfjZ6nqqlEAIbdVQGto8Lrv+/dbawcjAL7vc+6bs+zetetfLSHxniIFGofGGsU2oC7eOCbDfZ7nQawBOSAX74SF9oEPImOq+r7nmVmxb5raukZa8UReGmNmhbMkAwwBH467EYVZe49z7kdgenj8k7V2oTHm8kgdWcvrNdVFjR8cHkYzjDH9wLjDaEwEzpwa4MypgWvAjtjxfGNMj4jMiT+M+kFsZI/Q6Pv+HGNMT8w4wI7TAyevxXVPD5z8+zD64tRXAMHVK1eaVLUyVvuDqroV2BOnJF4ZIedviUidqt4Re9s+vbx8zZXLl7PR2+nl5Tz/zNOFp2FzxzGAklw22wUsLLaSKXwf8vhosZUM6PeDYEUum70VHfpBwKsVyyfeikOP6oBNwN1TrLbfgX3A1kKLzKeff8nLLzw38T5wZDgxn1LnNk5lLRfP26/OnR2hwfNYW2Atn9RCsrf+EECyrKysDFimqhXhyjY3VLkAXBKRDqA7nU6nS0tLhyIj6XSaN9bVclv+l/IXAmkwvZc+jNUAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-save{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4UexUIzAAAAIRJREFUWMNjXLhs5X+GAQRMDAMMWJDYjGhyf7CoIQf8x2H+f0KGM9M7BBio5FNcITo408CoA0YdQM1cwEhtB/ylgqMkCJmFLwrOQguj/xTg50hmkeyARAYGhlNUCIXjDAwM0eREwTUGBgbz0Ww46oBRB4w6YNQBow4YdcCIahP+H5EhAAAH2R8hH3Rg0QAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-tap-select{background-image:url("data:image/png;base64,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");}.bk-root .bk-tool-icon-undo{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4em8Dh0gAAAatJREFUWMPt1rFrFFEQBvDfGhACASshkL/ALpWVrSAKEQV5sIULWlgZNSgIFkGIVQ412gkBt1lYLERREFJqJRaW1oHAoZUQsDqwecWy7N3tbe6C4H2wxc682Zn3zTfvLXPM8b8j6RqYF+UCzsfnHBawGt3fMcAX7GEvS8NgKgXkRbmMxwg41TLsN0psZmnodyogL8pFPMIdLHUk7hA7eJKl4U/rAuKu3+HslFr/FZezNPSTFslX8QErDe4DvMVH/Iq9F7VwGpdwZUjsPtaSFjv/1vCBPjaxO0xcNbHejLpZrrlvJCMCT+JzA+2fcC1Lw+GE4l3CG1yIptfjCtiKoqtiJ0vD3aM0Py/K57iIMxgkQxat4EdN7e9xdRzlk+LEEPvDWvIDXJ928sYxjL36icWK+VaWhlezOIqbGFirJd/H7szugrwoX+D2BDEvszSsT5OBdfRaru/F9dPXQF6U27g/KnmWhgctxqyzBrZGMNGL/rHI0nDkKXiKexXTsywNGx0OnFbFNk3BRoWJXnw//j+ivCi32/S8CxPVNiWOAdUiJtXITIqYY45/Cn8B2D97FYW2H+IAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-wheel-pan{background-image:url("data:image/png;base64,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");}.bk-root .bk-tool-icon-wheel-zoom{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgskILvMJQAABTtJREFUWMPdl1+MXVUVxn/fPvf2zrSFmUKnoBCUdjRoVaIxEpO2JhilMYBCtBQS2hejpg1Uo2NUrIFAoyGmtiE+GHwQGtvQJhqDmKYRBv+URFsFDNCSptH60DJTO3dKnX/33rM/H7rvsDu9M20fDMaVnGTvtb69z7fWXmvtc/TEzqd4OyXwNsv/FwFJQVI/sA14SZKRLOlPkr5TrVYXHz70quYkEEK4TtI2YAgYkrQthHDdhV5uuw+43/ZrwCbgRttgY/tjtrc0m83X3/f+D6ydnJhYcB4BSZcBA7aP2d4ELAGW2N5k+xgwkDB0IH19CGGH7R8B1aQeAf4KvAw0ku4K2zu7uru3ApdPEyiKohd4TNKjtjt5h6RHgccSNrddbvuHtm9Jqoak7xVF8WFgdavV+pSk5cCObNmXgK++85prCj3z28HKqZMnH7D9YAY4BvwujT8BvCuL1INX9vVt+dfwcCvNb7f9q2RuSfrGvWu/sL2Nf3LX7pzvj4ENSGBPVarVd4fRkZFltjdmoMGiKO4IIWwIIWwoiuIOYDDzeOPoyMiyFLkum7WJCMDztrcrTTrIRuAQZ6NcK1utL4dWq/VZoC8BhqvV6l1lWb4YYxyLMY6VZflitVq9CxhOmL60hhCKeYiV7WMKIXw9jT1HpXw3c+bOAKzOjJubzebJrKQCQLPZPClpc7bP6rMYKtjXth2OMf7tIkr11Wz8oQDc1Fb09vY+kQw1YAuwJY2nbUluAnCWpKkaFl6IQIzxivaR2SYA89sJVK/Xp2x32R6w/a30DNjuqtfrU0ArYecDCEqgLqm94T0dEm9mBG7PxkdDlkBnkhebgIezNQ8nHcCZPL9ijE1Jf/bZZoPtzbavmqNZLbf9tSxq+yoduuJ+SZ+zXSZyBXCqU+d8fvC5yRUrV+0G2j3g2hDCLyXd/+Su3QdnvP/zCuH72LWsgf2k0oHlH2c2odlkxcpVEdgr6aDtjyb8x20/J+mA7T9I6rL9SWA5dne2/GdXLl58qNJh398An85yTMA+4DOz8Dgu6Zu2dwJXJ91ltm8Gbp7Fgb+EEB4aHhpq5CEtACqVyr3AC0AlPS8k3TSmQ2YPhhBuS/1/LpmS9JTtNTHGfwBU2uUALARotVqniqJYH2Pck85pfavVaufAwnQvnHc0McaDKVptebN94QAnJB0EdtjekydyZXqjs/0ZgLIs/w6sy8bnYGYJ63pgERKC05JutT1kOwITwL9tvzlzUQUYB+Zjs2DBgu6xsbGJZHstByZbezregcBXeCsEz1bnzXt5anLyzLq71zDLxTRdVgemdx0fv2e2w5thO5DbiqL4oKT3ZKpnpyYnz+SY2ZpTAPZmJfdIrVZbNBNUq9UW2X4kU+2dcf53Aj1pj2PA7y/6m1DS00A9za9uNBq7iqJYBuoGdRdFsazRaOzKSqye1rTbaa/tlbYrqXQP2X4FIA9/J1l39xrC0v7+w5IeB8XkwS1lWe6TGJAYKMty31tfO4qSHl/a3384I3CDpI+kzC4lnRfrue6GytEjR8oQwlY73gC0L4qlth/q0M1/LYWtR48cKQF6enrC6dOnVwGLEpnxnp7en4+O1i/tszzGOCTpPmB7ahb57QUwBWyXdF+McWg6MScmuoA8OX8xOlpvXGz422XYTsB/SnpA0h7bX5R0WzI9HUL4qe2XbI+dk3xl+V7gxoztD5jRI+YK/zkEEokx2/uB/RdzIfUtueqVN04cXwF8G3iHY3z9Urw/j8ClyhsnjrcS2Vv/J/8NLxT+/zqBTkcxU/cfEkyEAu3kmjAAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-box-edit{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4QfHjM1QAAAGRJREFUWMNjXLhsJcNAAiaGAQYsDAwM/+lsJ+OgCwGsLqMB+D8o08CoA0YdMOqAUQewDFQdMBoFIyoN/B/U7YFRB7DQIc7xyo9GwbBMA4xDqhxgISH1klXbDYk0QOseEeOgDgEAIS0JQleje6IAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-freehand-draw{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAADTElEQVRYCeWWTWwMYRjH/88721X1lZJIGxJxcEE4OOiBgzjXWh8TJKR76kWacOBGxdEJIdk4VChZI/phidRBHMRRIr7DSUiaSCRFRM3u88gz+o7Z6bBTdjmYZPf9eJ55fv/5zzvvDPC/H9QsA66Olo9Ga+/MdR+Ljm2/KQIULsz9FqItGdOfJKLhApLgVkiSCGODjWit7QpKWy+TNrFeXvzKVUT8NiTVaIgDcbiCFJ7GiT8WkARXAdYBK0Lbhi/CenArRNskuM7/tgNp4ArQ42dwjf3WY5gWTqC7O/NbNn2Xkfw/YwdSw/We14HP2IEZwX+y9cZ9SH0LmgFP7UCz4KkENBNeV0Cz4b8U8DfgKiDxMWwUXETqLvJpCQpXZfawbzS7t9v5pL19cHBwfja7YA0y/lyCM0+E5hv5+piZXwKYcF23as+37bTXsQVqgkL0p/34fHR7DcBtbetFsBmGDwMOJCggYG55yw7dMlk6DuC1Bdu2RsCU9TYWQq2IoGbsreZ5NzvEqfSBsIsIy8OTbcdgiRHeh4o8AFAEwDakbY2AaCCpH7V9aGhoUUUy3UyVbkPYFuYLDlUZH8XBpwxkK0Dbgxg5HcVi0ent7a0RULMIozaHBSMfF9b2SzdutFcFB2FkwMIJOG6qfteXOa1nHZ48tyefuwyfT9s6wtzZ3t7eZse2DR2I228TtHXzuWCx9g8MtK5cuHCZTH4tiHEOa4xFngvTyS8f35d6enomiCi4/foEXBkZaQuukChL4FYA2Whd7YcC4gEdW3CpdL3LtGAVCVYJywEyTpAuJKeMOKXZs/Bw947C50KhUFOG4cwz35cjWNBlHGeD53n3xsfHP/T19U1qciggar8Fa4I3PHobIotBWBtc2hSiChyZxVzM53Pv7FVH6Tp3uVy+g0r1ImD2GjIrQGYIxjnfuXTZGICS5k/bBwJoubwEFX4TLah9EXomJGMA3za+f9913Yl4TnzsDQ+vE6YTZOjHh4ngibstt1pzQwd04F0bPStEBpXqRoBeQ/AKghfBnOEKgS+Q7z91Xfdz/HGKg8Ox7z8iYD9z6wqTkZFgnvhMGP9VZ2or1XVkPM9z0mytSfVsHa1RLBZbLoyNzUnK+ydz3wC6I9x+lwbngwAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-poly-draw{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEjglo9eZgwAAAc5JREFUWMPt1zFrU1EUB/DfS4OmVTGDIChCP4BgnQXRxVHqIJUupp9AB8VBQcRBQUXIB9DWQoMRiXZzcnQSA34A7aAuHSJKkgo2LvfBrU3aJnlYkBy4vHcP557zP/9z3r33JdXa647N0kHSZd5Nn0rSxc8G3cXp85sMcnZZ8vge3osZ+l3vB8CWFA0iL14t79h210swAjACMAIwAjACkB90D/8/GchI9ve4nPwTBh5E9ws7OepzGWb9EddSn51Op9ZstadSg4VK1UKlKkmSDSMLALewiuNh/hVJq71Wxttmqz0dG88vPc+MgWP4grvYG3SLOBrZFFFrttqPe4HIDxh4GSei+98iSlusuYopXEAjBtEPA3tQwUpwluAbDm4TPJUz+BTW9l2Ce6G7L0X/Bw8D3T/7SKKIDzHg7QCcxjvcQAEtXAnrrg/RP0/DKPbqgcN4iVOR7gcO4dcQgRuoh7HSqwlP4n20m63jJu5n8MkWMYfP3UowhzdR8FU8w9iQwevBdyq3/27CMRzAE5yLuvsRLg+ZcR1nJ8YL81HWJUzGAPaFZwe/Q5MdyYDyNHgjzO90YyGHtVDncuiJchaHw8R4oREFV5qdiVmYLM3OgD9k5209/atmIAAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-point-draw{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEiERGWPELgAAA4RJREFUWMO1lr1uG1cQhb9ztdRSP7AF1QxgwKlcuZSqRC9gWUUUINWqTh5AnaFOnVPEteQmRuhCURqWsSqqc9IolREXdEvQBElxtdw7KURSFEVKu4w8wAKLxdw9Z+bMnRmZGXfZ29//II8th4WwGVNyIoQLYB5vxA9Caq04iUd9A+7ZlsNC2I7TdSd2hZXMJKlnTqp9jtl/GBaqoyQ0noFKpUIzBicYYc+DEFpxkglc4oVJa5gvDn8v1xV2irG3FM4NSVwjUKlUaMcpJhCGmSEJQ6QGD8M5WnHCd8+f3QCXpPLx8WNwv0j6Bm9FMK7FJ3WBE+R/2t7c/GBmFvSBrzRTCsyTDjXrxUgEMtpxynJYmJoBJ4VAybwVARgvL7Oik0okCodnKpVKX7P0leiVMb0VvbJT+upznK4vh0GIeQwwQStJkHQD3MwsCALTJRG7Qrdrj5m/djgYaIa0hlkRdJk26XEgC9txurccBtVW3IudBImmZuACUP+ZlIDBt9FKcubYNTcAH/X0RYM1E7utJPlqe+uZzPxUcEkiSS4sTT95n15Mud0xWC0o2PAWOCdK3KYZlFxfM+tHOcnMzNr1es18ug+cgsVjP4yBU/Ppfrter1m/+l0+zYygML1xRVHU7TSb1cSzBzoBzszsH+AMdJJ49jrNZjWKou6wBnwOzcyndBpNbuueURR1Dw8Pq35p9cc5p/Dy9Dypt7jXrtdGwQECS9NPhr6Gq6txUzNigE6zydLK6lTw12/KT4FGFEUfJX2YJNONq5tVs4ODA7sD/DnwJ/BoADZuE3tHFs12dna6d4C/BI6AlbyzI8ii2TTw12/KK33gb2cdXsNZoAntbZC2SeO4c9592k/5eNQbiwvFd1kJuFGwLJr1wSPg/SwpvyFBHufOeXcFeAlE97U/uCxOY+P3b+Bn4B3Q+L8EdJfD4a+/AbC4UBzPxiPg3wlHZquB28Cn2IuR9x3gr3uV4DbwfvSDOvi4uFA8BDZmIRHkjHpS9Ht9iRqd8+5G3g05mAGcQbsdiX5QJ428G7Kygo8XYdb1/K4NWVmjzkNge2sz84bs+ELmpDDLtqWsNZBXgvmw8CTtpWVMT7x5YWBjLARnwZfKQNYN2U2LPvrh+5nBt7c2M2/It9bArCTKR8eZN+SJ13AScPnoODeRdqNenH+wul5w2gUr2WUjMFAt8bZ/0axX/wNnv4H8vTFb1QAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-poly-edit{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gELFi46qJmxxAAABV9JREFUWMOdl19vFFUYxn9n9u9sCyylUIzWUoMQBAWCMdEEIt6xIRQSLIEKtvHe6AcA4yeQb7CAUNJy0daLeomJN8SEULAC2kBBapBKoLvbmdl/c14vdmY7u91tF95kknPOnHmf95znPc97Ro2OTeBbdjFDT3c32ZxVHUOE9kSMB0/m6ExuoJn1H+ur6Y+OTfD50SMN5168OgrAlyf7CfuD+z7+iDs3p8hkLUQ0iFQ/yFl5Nm/qonfHVva+s32Zw9GxCYILsZ08tpNfBhbs+1YN4OH9+7huGdECSBVfqUosbsllfmauBqiR+cCNwOr7AEo8pPHJnymXykhg5fUWjoQpl0vVvhZhbSzGoUOHqgBlt6B6uruj2Zy1E9jo0fhfeyL2x4Mnc8VErK0KUEOB64JSyptfG4RSytsJjUJVxw2lsFy3urL9nx1Qd25ObctkrVMi+jQivd7U2ZyV/3Hzpq7h3h1b/7p9Y0o8v8rwAbTWrGpSocN/FGDlbAI0Rl23PCBan0Ok158H9Ipwzi25A/Mzc9Gl/BYx/E4kYqC1NKRARNAaDCNUM27Z+Zr+ouXs0q4+LSLBHPYCFkTkC6uU39kwCdsS7WRKmaYUiAhdnZ3MPX2K4+QjQI+C94A93rMzm8ltMwyDeDzWjMZeEb2pYQDdW3vITU2jtUZ5QThOPgm8C7wP7J15OPsBsB3oWpGnVWisCeDS1VHj4vBI92+/3tgB7Ab2AruAXiDBK5oIOkhtkEYRNRuJhObrd8Dl9ewf4D5wG7hVLpen29vb5wzD+BrkbBMaL3d1dk5nsrnlFDTTFWAWmAZueWD3gCemGde2k2fw1Al1YXhEvjozoO49eczdqekrWmsc2zlrmvEKOGoW1GUjFLqSk2KpJrCLwyMCPAP+BO54QL8DM6YZX/ClsP9YnwKkXnIBP4jdIpJRpdJTCYdMwwi98KU0Hjc/dDILNyUcwTCWdOSMJ0TRmBktGRhLugu0xyLk7CIqVNm+0bGJptl1YXikD0grpY4Rjc4a8Fbgdab/6OGbAJeCUuyJnnHmZH9pbSyGuBXV8NUwlUpR1EWyixmSyTWEwqGlJ2Swbo2JXbAAfgDGgGQA9I1A9t1tlq0AxrXxn0ilUpw4fhQqYkH/sT41OTnJJwf2s6FjI5mshdYa7bqVR2uezr9MJmJt14FvGrh/O9D+e6UkM/xyCuCqEKCYnJyUTKFQrZDHjxzGshwWLQcRsOz8Hi85P23id0ug/XilAMLBmm4tPGdoaKjSH5+oAGrhwvBI9SjZTn4QSK9yenoD7dlrExPoJlXW8G8ytpNHxRKk02lGxsdRKFwXLNvx5yY94HQLGhGk4LFCYQSqaE0AwWM1eOoEbR0dKBSW7bC4mKuffxs4D/wCLKwQQPAUzIkslfp6cVomROWSolh0GjldAM4nzDi2k9/i5UAzC9aKfwNJ3zgJg9YEvN6+C7SHgKm69+sD7RfNnKTTaZRPQfAut4oFV//IS7gkcB34VlVo8kGzphlfB+DU+TfNGBpZtRastvrvARJmfMF28ge9sc2B9/PNnCilMIDwK6y8/ow/Ai4kvILTljAXvDvEvrqKSUs60KolzPjBxspavQD2tKqCAGF/Ba+xE/Wbilu54wZV8NEKF5fXzQHl/bh4hUsE0WAXSlDMYcQSrQXgCmsTseXHsJkNnjqBFGwKJaHsKlxtUHYVhbLCzr1kaOA4bcn1y1Swmb+iLpJKpVrfgdpfsiVVCYcgluwgnU7jEgJ4s5UkLFtWYyHyEg0/N1q1tmQH+YXnAMFr97Nmv3p+0QsHQRsF8qpBOE5+rb9Nkaj50tVQKjqh4OU3GNL/1/So3vuUgbAAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-line-edit{background-image:url("data:image/png;base64,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");}'},
function _(o,t,e,r,b){r(),e.root="bk-root",e.menu_icon="bk-menu-icon",e.context_menu="bk-context-menu",e.horizontal="bk-horizontal",e.vertical="bk-vertical",e.divider="bk-divider",e.active="bk-active",e.menu="bk-menu",e.above="bk-above",e.below="bk-below",e.caret="bk-caret",e.down="bk-down",e.up="bk-up",e.left="bk-left",e.right="bk-right",e.default=".bk-root .bk-menu-icon{width:28px;height:28px;background-size:60%;background-color:transparent;background-repeat:no-repeat;background-position:center center;}.bk-root .bk-context-menu{position:absolute;display:inline-flex;flex-wrap:nowrap;user-select:none;-ms-user-select:none;-moz-user-select:none;-webkit-user-select:none;width:auto;height:auto;z-index:100;cursor:pointer;font-size:12px;background-color:#fff;border:1px solid #ccc;border-radius:4px;box-shadow:0 6px 12px rgba(0, 0, 0, 0.175);}.bk-root .bk-context-menu.bk-horizontal{flex-direction:row;}.bk-root .bk-context-menu.bk-vertical{flex-direction:column;}.bk-root .bk-context-menu > .bk-divider{cursor:default;overflow:hidden;background-color:#e5e5e5;}.bk-root .bk-context-menu.bk-horizontal > .bk-divider{width:1px;margin:5px 0;}.bk-root .bk-context-menu.bk-vertical > .bk-divider{height:1px;margin:0 5px;}.bk-root .bk-context-menu > :not(.bk-divider){border:1px solid transparent;}.bk-root .bk-context-menu > :not(.bk-divider).bk-active{border-color:#26aae1;}.bk-root .bk-context-menu > :not(.bk-divider):hover{background-color:#f9f9f9;}.bk-root .bk-context-menu > :not(.bk-divider):focus,.bk-root .bk-context-menu > :not(.bk-divider):focus-visible{outline:1px dotted #26aae1;outline-offset:-1px;}.bk-root .bk-context-menu > :not(.bk-divider)::-moz-focus-inner{border:0;}.bk-root .bk-context-menu.bk-horizontal > :not(.bk-divider):first-child{border-top-left-radius:4px;border-bottom-left-radius:4px;}.bk-root .bk-context-menu.bk-horizontal > :not(.bk-divider):last-child{border-top-right-radius:4px;border-bottom-right-radius:4px;}.bk-root .bk-context-menu.bk-vertical > :not(.bk-divider):first-child{border-top-left-radius:4px;border-top-right-radius:4px;}.bk-root .bk-context-menu.bk-vertical > :not(.bk-divider):last-child{border-bottom-left-radius:4px;border-bottom-right-radius:4px;}.bk-root .bk-menu{position:absolute;left:0;width:100%;z-index:100;cursor:pointer;font-size:12px;background-color:#fff;border:1px solid #ccc;border-radius:4px;box-shadow:0 6px 12px rgba(0, 0, 0, 0.175);}.bk-root .bk-menu.bk-above{bottom:100%;}.bk-root .bk-menu.bk-below{top:100%;}.bk-root .bk-menu > .bk-divider{height:1px;margin:7.5px 0;overflow:hidden;background-color:#e5e5e5;}.bk-root .bk-menu > :not(.bk-divider){padding:6px 12px;}.bk-root .bk-menu > :not(.bk-divider):hover,.bk-root .bk-menu > :not(.bk-divider).bk-active{background-color:#e6e6e6;}.bk-root .bk-caret{display:inline-block;vertical-align:middle;width:0;height:0;margin:0 5px;}.bk-root .bk-caret.bk-down{border-top:4px solid;}.bk-root .bk-caret.bk-up{border-bottom:4px solid;}.bk-root .bk-caret.bk-down,.bk-root .bk-caret.bk-up{border-right:4px solid transparent;border-left:4px solid transparent;}.bk-root .bk-caret.bk-left{border-right:4px solid;}.bk-root .bk-caret.bk-right{border-left:4px solid;}.bk-root .bk-caret.bk-left,.bk-root .bk-caret.bk-right{border-top:4px solid transparent;border-bottom:4px solid transparent;}"},
function _(t,e,i,n,o){n();const s=t(1),l=t(43),h=t(9),r=(0,s.__importStar)(t(229));class d{constructor(t,e={}){var i,n;this.items=t,this.el=(0,l.div)(),this._open=!1,this._item_click=t=>{var e;null===(e=t.handler)||void 0===e||e.call(t),this.hide()},this._on_mousedown=t=>{var e;const{target:i}=t;i instanceof Node&&this.el.contains(i)||(null===(e=this.prevent_hide)||void 0===e?void 0:e.call(this,t))||this.hide()},this._on_keydown=t=>{t.keyCode==l.Keys.Esc&&this.hide()},this._on_blur=()=>{this.hide()},this.orientation=null!==(i=e.orientation)&&void 0!==i?i:"vertical",this.reversed=null!==(n=e.reversed)&&void 0!==n&&n,this.prevent_hide=e.prevent_hide,(0,l.undisplay)(this.el)}get is_open(){return this._open}get can_open(){return 0!=this.items.length}remove(){(0,l.remove)(this.el),this._unlisten()}_listen(){document.addEventListener("mousedown",this._on_mousedown),document.addEventListener("keydown",this._on_keydown),window.addEventListener("blur",this._on_blur)}_unlisten(){document.removeEventListener("mousedown",this._on_mousedown),document.removeEventListener("keydown",this._on_keydown),window.removeEventListener("blur",this._on_blur)}_position(t){const e=this.el.parentElement;if(null!=e){const i=(()=>{if("left_of"in t){const{left:e,top:i}=t.left_of.getBoundingClientRect();return{right:e,top:i}}if("right_of"in t){const{top:e,right:i}=t.right_of.getBoundingClientRect();return{left:i,top:e}}if("below"in t){const{left:e,bottom:i}=t.below.getBoundingClientRect();return{left:e,top:i}}if("above"in t){const{left:e,top:i}=t.above.getBoundingClientRect();return{left:e,bottom:i}}return t})(),n=e.getBoundingClientRect();this.el.style.left=null!=i.left?i.left-n.left+"px":"",this.el.style.top=null!=i.top?i.top-n.top+"px":"",this.el.style.right=null!=i.right?n.right-i.right+"px":"",this.el.style.bottom=null!=i.bottom?n.bottom-i.bottom+"px":""}}render(){var t;(0,l.empty)(this.el,!0),(0,l.classes)(this.el).add("bk-context-menu",`bk-${this.orientation}`);const e=this.reversed?(0,h.reversed)(this.items):this.items;for(const i of e){let e;if(null==i)e=(0,l.div)({class:r.divider});else{if(null!=i.if&&!i.if())continue;if(null!=i.content)e=i.content;else{const n=null!=i.icon?(0,l.div)({class:["bk-menu-icon",i.icon]}):null,o=[(null===(t=i.active)||void 0===t?void 0:t.call(i))?"bk-active":null,i.class];e=(0,l.div)({class:o,title:i.tooltip,tabIndex:0},n,i.label,i.content),e.addEventListener("click",(()=>{this._item_click(i)})),e.addEventListener("keydown",(t=>{t.keyCode==l.Keys.Enter&&this._item_click(i)}))}}this.el.appendChild(e)}}show(t){if(0!=this.items.length&&!this._open){if(this.render(),0==this.el.children.length)return;this._position(null!=t?t:{left:0,top:0}),(0,l.display)(this.el),this._listen(),this._open=!0}}hide(){this._open&&(this._open=!1,this._unlisten(),(0,l.undisplay)(this.el))}toggle(t){this._open?this.hide():this.show(t)}}i.ContextMenu=d,d.__name__="ContextMenu"},
function _(t,e,i,n,o){n();const s=t(1),c=t(224),l=(0,s.__importStar)(t(227)),a=t(43);class _ extends c.ButtonToolButtonView{render(){super.render(),(0,a.classes)(this.el).toggle(l.active,this.model.active)}_clicked(){const{active:t}=this.model;this.model.active=!t}}i.OnOffButtonView=_,_.__name__="OnOffButtonView"},
function _(e,o,t,n,s){var c;n();const l=e(224),_=e(231);class i extends l.ButtonToolView{}t.InspectToolView=i,i.__name__="InspectToolView";class a extends l.ButtonTool{constructor(e){super(e),this.event_type="move"}}t.InspectTool=a,c=a,a.__name__="InspectTool",c.prototype.button_view=_.OnOffButtonView,c.define((({Boolean:e})=>({toggleable:[e,!0]}))),c.override({active:!0})},
function _(t,o,e,l,i){l();const s=t(1);var n,a;const r=t(19),c=t(43),h=t(113),_=t(226),u=t(20),v=t(9),d=t(234),p=t(13),b=t(8),g=t(235),f=t(65),m=t(53),w=t(222),y=t(223),T=t(238),z=t(239),x=t(232),B=t(230),C=(0,s.__importStar)(t(227)),k=C,L=(0,s.__importStar)(t(240)),M=L;class S extends m.Model{constructor(t){super(t)}get visible(){var t;return!this.autohide||null!==(t=this._visible)&&void 0!==t&&t}}e.ToolbarViewModel=S,n=S,S.__name__="ToolbarViewModel",n.define((({Boolean:t})=>({autohide:[t,!1]}))),n.internal((({Boolean:t,Nullable:o})=>({_visible:[o(t),null]})));class $ extends _.DOMView{constructor(){super(...arguments),this.layout={bbox:new f.BBox}}initialize(){super.initialize(),this._tool_button_views=new Map,this._toolbar_view_model=new S({autohide:this.model.autohide});const{toolbar_location:t}=this.model,o="left"==t||"above"==t,e=this.model.horizontal?"vertical":"horizontal";this._overflow_menu=new B.ContextMenu([],{orientation:e,reversed:o})}async lazy_initialize(){await super.lazy_initialize(),await this._build_tool_button_views()}connect_signals(){super.connect_signals(),this.connect(this.model.properties.tools.change,(async()=>{await this._build_tool_button_views(),this.render()})),this.connect(this.model.properties.autohide.change,(()=>{this._toolbar_view_model.autohide=this.model.autohide,this._on_visible_change()})),this.connect(this._toolbar_view_model.properties._visible.change,(()=>this._on_visible_change()))}styles(){return[...super.styles(),C.default,L.default]}remove(){(0,h.remove_views)(this._tool_button_views),super.remove()}async _build_tool_button_views(){const t=null!=this.model._proxied_tools?this.model._proxied_tools:this.model.tools;await(0,h.build_views)(this._tool_button_views,t,{parent:this},(t=>t.button_view))}set_visibility(t){t!=this._toolbar_view_model._visible&&(this._toolbar_view_model._visible=t)}_on_visible_change(){const{visible:t}=this._toolbar_view_model;(0,c.classes)(this.el).toggle(k.toolbar_hidden,!t)}render(){(0,c.empty)(this.el),this.el.classList.add(k.toolbar),this.el.classList.add(k[this.model.toolbar_location]),this._toolbar_view_model.autohide=this.model.autohide,this._on_visible_change();const{horizontal:t}=this.model;let o=0;if(null!=this.model.logo){const e="grey"===this.model.logo?M.grey:null,l=(0,c.a)({href:"https://bokeh.org/",target:"_blank",class:[M.logo,M.logo_small,e]});this.el.appendChild(l);const{width:i,height:s}=l.getBoundingClientRect();o+=t?i:s}for(const[,t]of this._tool_button_views)t.render();const e=[],l=t=>this._tool_button_views.get(t).el,{gestures:i}=this.model;for(const t of(0,p.values)(i))e.push(t.tools.map(l));e.push(this.model.actions.map(l)),e.push(this.model.inspectors.filter((t=>t.toggleable)).map(l));const s=e.filter((t=>0!=t.length)),n=()=>(0,c.div)({class:k.divider}),{bbox:a}=this.layout;let r=!1;this.root.el.appendChild(this._overflow_menu.el);const h=(0,c.div)({class:k.tool_overflow,tabIndex:0},t?"\u22ee":"\u22ef"),_=()=>{const t=(()=>{switch(this.model.toolbar_location){case"right":return{left_of:h};case"left":return{right_of:h};case"above":return{below:h};case"below":return{above:h}}})();this._overflow_menu.toggle(t)};h.addEventListener("click",(()=>{_()})),h.addEventListener("keydown",(t=>{t.keyCode==c.Keys.Enter&&_()}));for(const e of(0,d.join)(s,n))if(r)this._overflow_menu.items.push({content:e,class:t?k.right:k.above});else{this.el.appendChild(e);const{width:l,height:i}=e.getBoundingClientRect();if(o+=t?l:i,r=t?o>a.width-15:o>a.height-15,r){this.el.removeChild(e),this.el.appendChild(h);const{items:t}=this._overflow_menu;t.splice(0,t.length),t.push({content:e})}}}update_layout(){}update_position(){}after_layout(){this._has_finished=!0}export(t,o=!0){const e="png"==t?"canvas":"svg",l=new g.CanvasLayer(e,o);return l.resize(0,0),l}}function V(){return{pan:{tools:[],active:null},scroll:{tools:[],active:null},pinch:{tools:[],active:null},tap:{tools:[],active:null},doubletap:{tools:[],active:null},press:{tools:[],active:null},pressup:{tools:[],active:null},rotate:{tools:[],active:null},move:{tools:[],active:null},multi:{tools:[],active:null}}}e.ToolbarBaseView=$,$.__name__="ToolbarBaseView";class A extends m.Model{constructor(t){super(t)}initialize(){super.initialize(),this._init_tools()}_init_tools(){const t=function(t,o){if(t.length!=o.length)return!0;const e=new Set(o.map((t=>t.id)));return(0,v.some)(t,(t=>!e.has(t.id)))},o=this.tools.filter((t=>t instanceof x.InspectTool));t(this.inspectors,o)&&(this.inspectors=o);const e=this.tools.filter((t=>t instanceof z.HelpTool));t(this.help,e)&&(this.help=e);const l=this.tools.filter((t=>t instanceof T.ActionTool));t(this.actions,l)&&(this.actions=l);const i=(t,o)=>{t in this.gestures||r.logger.warn(`Toolbar: unknown event type '${t}' for tool: ${o}`)},s={pan:{tools:[],active:null},scroll:{tools:[],active:null},pinch:{tools:[],active:null},tap:{tools:[],active:null},doubletap:{tools:[],active:null},press:{tools:[],active:null},pressup:{tools:[],active:null},rotate:{tools:[],active:null},move:{tools:[],active:null},multi:{tools:[],active:null}};for(const t of this.tools)if(t instanceof y.GestureTool&&t.event_type)if((0,b.isString)(t.event_type))s[t.event_type].tools.push(t),i(t.event_type,t);else{s.multi.tools.push(t);for(const o of t.event_type)i(o,t)}for(const o of Object.keys(s)){const e=this.gestures[o];t(e.tools,s[o].tools)&&(e.tools=s[o].tools),e.active&&(0,v.every)(e.tools,(t=>t.id!=e.active.id))&&(e.active=null)}}get horizontal(){return"above"===this.toolbar_location||"below"===this.toolbar_location}get vertical(){return"left"===this.toolbar_location||"right"===this.toolbar_location}_active_change(t){const{event_type:o}=t;if(null==o)return;const e=(0,b.isString)(o)?[o]:o;for(const o of e)if(t.active){const e=this.gestures[o].active;null!=e&&t!=e&&(r.logger.debug(`Toolbar: deactivating tool: ${e} for event type '${o}'`),e.active=!1),this.gestures[o].active=t,r.logger.debug(`Toolbar: activating tool: ${t} for event type '${o}'`)}else this.gestures[o].active=null}}e.ToolbarBase=A,a=A,A.__name__="ToolbarBase",a.prototype.default_view=$,a.define((({Boolean:t,Array:o,Ref:e,Nullable:l})=>({tools:[o(e(w.Tool)),[]],logo:[l(u.Logo),"normal"],autohide:[t,!1]}))),a.internal((({Array:t,Struct:o,Ref:e,Nullable:l})=>{const i=o({tools:t(e(y.GestureTool)),active:l(e(w.Tool))});return{gestures:[o({pan:i,scroll:i,pinch:i,tap:i,doubletap:i,press:i,pressup:i,rotate:i,move:i,multi:i}),V],actions:[t(e(T.ActionTool)),[]],inspectors:[t(e(x.InspectTool)),[]],help:[t(e(z.HelpTool)),[]],toolbar_location:[u.Location,"right"]}}))},
function _(n,o,e,t,f){t();const r=n(9);function*i(n,o){const e=n.length;if(o>e)return;const t=(0,r.range)(o);for(yield t.map((o=>n[o]));;){let f;for(const n of(0,r.reversed)((0,r.range)(o)))if(t[n]!=n+e-o){f=n;break}if(null==f)return;t[f]+=1;for(const n of(0,r.range)(f+1,o))t[n]=t[n-1]+1;yield t.map((o=>n[o]))}}e.enumerate=function*(n){let o=0;for(const e of n)yield[e,o++]},e.join=function*(n,o){let e=!0;for(const t of n)e?e=!1:null!=o&&(yield o()),yield*t},e.combinations=i,e.subsets=function*(n){for(const o of(0,r.range)(n.length+1))yield*i(n,o)}},
function _(t,e,s,i,n){i();const o=t(236),a=t(65),r=t(43);function h(t){!function(t){void 0===t.lineDash&&Object.defineProperty(t,"lineDash",{get:()=>t.getLineDash(),set:e=>t.setLineDash(e)})}(t),function(t){t.setImageSmoothingEnabled=e=>{t.imageSmoothingEnabled=e,t.mozImageSmoothingEnabled=e,t.oImageSmoothingEnabled=e,t.webkitImageSmoothingEnabled=e,t.msImageSmoothingEnabled=e},t.getImageSmoothingEnabled=()=>{const e=t.imageSmoothingEnabled;return null==e||e}}(t),function(t){t.ellipse||(t.ellipse=function(e,s,i,n,o,a,r,h=!1){const l=.551784;t.translate(e,s),t.rotate(o);let c=i,g=n;h&&(c=-i,g=-n),t.moveTo(-c,0),t.bezierCurveTo(-c,g*l,-c*l,g,0,g),t.bezierCurveTo(c*l,g,c,g*l,c,0),t.bezierCurveTo(c,-g*l,c*l,-g,0,-g),t.bezierCurveTo(-c*l,-g,-c,-g*l,-c,0),t.rotate(-o),t.translate(-e,-s)})}(t)}const l={position:"absolute",top:"0",left:"0",width:"100%",height:"100%"};class c{constructor(t,e){switch(this.backend=t,this.hidpi=e,this.pixel_ratio=1,this.bbox=new a.BBox,t){case"webgl":case"canvas":{this._el=this._canvas=(0,r.canvas)({style:l});const t=this.canvas.getContext("2d");if(null==t)throw new Error("unable to obtain 2D rendering context");this._ctx=t,e&&(this.pixel_ratio=devicePixelRatio);break}case"svg":{const t=new o.SVGRenderingContext2D;this._ctx=t,this._canvas=t.get_svg(),this._el=(0,r.div)({style:l},this._canvas);break}}this._ctx.layer=this,h(this._ctx)}get canvas(){return this._canvas}get ctx(){return this._ctx}get el(){return this._el}resize(t,e){this.bbox=new a.BBox({left:0,top:0,width:t,height:e});const s=this._ctx instanceof o.SVGRenderingContext2D?this._ctx:this.canvas;s.width=t*this.pixel_ratio,s.height=e*this.pixel_ratio}undo_transform(t){const{ctx:e}=this;if(void 0===e.getTransform)t(e);else{const s=e.getTransform();e.setTransform(this._base_transform);try{t(e)}finally{e.setTransform(s)}}}prepare(){const{ctx:t,hidpi:e,pixel_ratio:s}=this;t.save(),e&&(t.scale(s,s),t.translate(.5,.5)),void 0!==t.getTransform&&(this._base_transform=t.getTransform()),this.clear()}clear(){const{x:t,y:e,width:s,height:i}=this.bbox;this.ctx.clearRect(t,e,s,i)}finish(){this.ctx.restore()}to_blob(){const{_canvas:t}=this;if(t instanceof HTMLCanvasElement)return null!=t.msToBlob?Promise.resolve(t.msToBlob()):new Promise(((e,s)=>{t.toBlob((t=>null!=t?e(t):s()),"image/png")}));{const t=this._ctx.get_serialized_svg(!0),e=new Blob([t],{type:"image/svg+xml"});return Promise.resolve(e)}}}s.CanvasLayer=c,c.__name__="CanvasLayer"},
function _(t,e,i,s,r){s();const n=t(122),a=t(8),o=t(237),l=t(10),h=t(43);function _(t){var e;const i={left:"start",right:"end",center:"middle",start:"start",end:"end"};return null!==(e=i[t])&&void 0!==e?e:i.start}function c(t){var e;const i={alphabetic:"alphabetic",hanging:"hanging",top:"text-before-edge",bottom:"text-after-edge",middle:"central"};return null!==(e=i[t])&&void 0!==e?e:i.alphabetic}const p=function(t,e){const i=new Map,s=t.split(",");e=null!=e?e:10;for(let t=0;t<s.length;t+=2){const r=`&${s[t+1]};`,n=parseInt(s[t],e);i.set(r,`&#${n};`)}return i.set("\\xa0","&#160;"),i}("50,nbsp,51,iexcl,52,cent,53,pound,54,curren,55,yen,56,brvbar,57,sect,58,uml,59,copy,5a,ordf,5b,laquo,5c,not,5d,shy,5e,reg,5f,macr,5g,deg,5h,plusmn,5i,sup2,5j,sup3,5k,acute,5l,micro,5m,para,5n,middot,5o,cedil,5p,sup1,5q,ordm,5r,raquo,5s,frac14,5t,frac12,5u,frac34,5v,iquest,60,Agrave,61,Aacute,62,Acirc,63,Atilde,64,Auml,65,Aring,66,AElig,67,Ccedil,68,Egrave,69,Eacute,6a,Ecirc,6b,Euml,6c,Igrave,6d,Iacute,6e,Icirc,6f,Iuml,6g,ETH,6h,Ntilde,6i,Ograve,6j,Oacute,6k,Ocirc,6l,Otilde,6m,Ouml,6n,times,6o,Oslash,6p,Ugrave,6q,Uacute,6r,Ucirc,6s,Uuml,6t,Yacute,6u,THORN,6v,szlig,70,agrave,71,aacute,72,acirc,73,atilde,74,auml,75,aring,76,aelig,77,ccedil,78,egrave,79,eacute,7a,ecirc,7b,euml,7c,igrave,7d,iacute,7e,icirc,7f,iuml,7g,eth,7h,ntilde,7i,ograve,7j,oacute,7k,ocirc,7l,otilde,7m,ouml,7n,divide,7o,oslash,7p,ugrave,7q,uacute,7r,ucirc,7s,uuml,7t,yacute,7u,thorn,7v,yuml,ci,fnof,sh,Alpha,si,Beta,sj,Gamma,sk,Delta,sl,Epsilon,sm,Zeta,sn,Eta,so,Theta,sp,Iota,sq,Kappa,sr,Lambda,ss,Mu,st,Nu,su,Xi,sv,Omicron,t0,Pi,t1,Rho,t3,Sigma,t4,Tau,t5,Upsilon,t6,Phi,t7,Chi,t8,Psi,t9,Omega,th,alpha,ti,beta,tj,gamma,tk,delta,tl,epsilon,tm,zeta,tn,eta,to,theta,tp,iota,tq,kappa,tr,lambda,ts,mu,tt,nu,tu,xi,tv,omicron,u0,pi,u1,rho,u2,sigmaf,u3,sigma,u4,tau,u5,upsilon,u6,phi,u7,chi,u8,psi,u9,omega,uh,thetasym,ui,upsih,um,piv,812,bull,816,hellip,81i,prime,81j,Prime,81u,oline,824,frasl,88o,weierp,88h,image,88s,real,892,trade,89l,alefsym,8cg,larr,8ch,uarr,8ci,rarr,8cj,darr,8ck,harr,8dl,crarr,8eg,lArr,8eh,uArr,8ei,rArr,8ej,dArr,8ek,hArr,8g0,forall,8g2,part,8g3,exist,8g5,empty,8g7,nabla,8g8,isin,8g9,notin,8gb,ni,8gf,prod,8gh,sum,8gi,minus,8gn,lowast,8gq,radic,8gt,prop,8gu,infin,8h0,ang,8h7,and,8h8,or,8h9,cap,8ha,cup,8hb,int,8hk,there4,8hs,sim,8i5,cong,8i8,asymp,8j0,ne,8j1,equiv,8j4,le,8j5,ge,8k2,sub,8k3,sup,8k4,nsub,8k6,sube,8k7,supe,8kl,oplus,8kn,otimes,8l5,perp,8m5,sdot,8o8,lceil,8o9,rceil,8oa,lfloor,8ob,rfloor,8p9,lang,8pa,rang,9ea,loz,9j0,spades,9j3,clubs,9j5,hearts,9j6,diams,ai,OElig,aj,oelig,b0,Scaron,b1,scaron,bo,Yuml,m6,circ,ms,tilde,802,ensp,803,emsp,809,thinsp,80c,zwnj,80d,zwj,80e,lrm,80f,rlm,80j,ndash,80k,mdash,80o,lsquo,80p,rsquo,80q,sbquo,80s,ldquo,80t,rdquo,80u,bdquo,810,dagger,811,Dagger,81g,permil,81p,lsaquo,81q,rsaquo,85c,euro",32),u={strokeStyle:{svgAttr:"stroke",canvas:"#000000",svg:"none",apply:"stroke"},fillStyle:{svgAttr:"fill",canvas:"#000000",svg:null,apply:"fill"},lineCap:{svgAttr:"stroke-linecap",canvas:"butt",svg:"butt",apply:"stroke"},lineJoin:{svgAttr:"stroke-linejoin",canvas:"miter",svg:"miter",apply:"stroke"},miterLimit:{svgAttr:"stroke-miterlimit",canvas:10,svg:4,apply:"stroke"},lineWidth:{svgAttr:"stroke-width",canvas:1,svg:1,apply:"stroke"},globalAlpha:{svgAttr:"opacity",canvas:1,svg:1,apply:"fill stroke"},font:{canvas:"10px sans-serif"},shadowColor:{canvas:"#000000"},shadowOffsetX:{canvas:0},shadowOffsetY:{canvas:0},shadowBlur:{canvas:0},textAlign:{canvas:"start"},textBaseline:{canvas:"alphabetic"},lineDash:{svgAttr:"stroke-dasharray",canvas:[],svg:null,apply:"stroke"},lineDashOffset:{svgAttr:"stroke-dashoffset",canvas:0,svg:0,apply:"stroke"}};class d{constructor(t,e){this.__root=t,this.__ctx=e}addColorStop(t,e){if("linearGradient"===this.__root.nodeName&&this.__root.getAttribute("x1")===this.__root.getAttribute("x2")&&this.__root.getAttribute("y1")===this.__root.getAttribute("y2"))return;if("radialGradient"===this.__root.nodeName&&this.__root.getAttribute("cx")===this.__root.getAttribute("fx")&&this.__root.getAttribute("cy")===this.__root.getAttribute("fy")&&this.__root.getAttribute("r")===this.__root.getAttribute("r0"))return;const i=this.__ctx.__createElement("stop");if(i.setAttribute("offset",`${t}`),-1!==e.indexOf("rgba")){const t=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi.exec(e),[,s,r,n,a]=t;i.setAttribute("stop-color",`rgb(${s},${r},${n})`),i.setAttribute("stop-opacity",a)}else i.setAttribute("stop-color",e);this.__root.appendChild(i)}}d.__name__="CanvasGradient";class m{constructor(t,e){this.__root=t,this.__ctx=e}setTransform(t){throw new Error("not implemented")}}m.__name__="CanvasPattern";class f{constructor(t){var e,i,s;this.__currentPosition=null,this._transform=new n.AffineTransform,this._clip_path=null,this.__document=null!==(e=null==t?void 0:t.document)&&void 0!==e?e:document,(null==t?void 0:t.ctx)?this.__ctx=t.ctx:(this.__canvas=this.__document.createElement("canvas"),this.__ctx=this.__canvas.getContext("2d")),this.__setDefaultStyles(),this.__stack=[],this.__root=this.__document.createElementNS("http://www.w3.org/2000/svg","svg"),this.__root.setAttribute("version","1.1"),this.__root.setAttribute("xmlns","http://www.w3.org/2000/svg"),this.width=null!==(i=null==t?void 0:t.width)&&void 0!==i?i:500,this.height=null!==(s=null==t?void 0:t.height)&&void 0!==s?s:500,this.__ids=new Set,this.__defs=this.__document.createElementNS("http://www.w3.org/2000/svg","defs"),this.__root.appendChild(this.__defs)}get canvas(){return this}get width(){return this._width}set width(t){this._width=t,this.__root.setAttribute("width",`${t}`)}get height(){return this._height}set height(t){this._height=t,this.__root.setAttribute("height",`${t}`)}_random_string(){let t;do{t=f.__random.choices(12,"ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz").join("")}while(this.__ids.has(t));return t}__createElement(t,e={},i=!1){const s=this.__document.createElementNS("http://www.w3.org/2000/svg",t);i&&(s.setAttribute("fill","none"),s.setAttribute("stroke","none"));const r=Object.keys(e);for(const t of r)s.setAttribute(t,`${e[t]}`);return s}__setDefaultStyles(){const t=Object.keys(u),e=this;for(let i=0;i<t.length;i++){const s=t[i];e[s]=u[s].canvas}}__applyStyleState(t){const e=Object.keys(t),i=this;for(let s=0;s<e.length;s++){const r=e[s];i[r]=t[r]}}__getStyleState(){const t=Object.keys(u),e={};for(let i=0;i<t.length;i++){const s=t[i];e[s]=this[s]}return e}__applyStyleToCurrentElement(t){var e;const i=this.__currentElement,s=Object.keys(u);for(let r=0;r<s.length;r++){const n=u[s[r]],o=this[s[r]];if(null===(e=n.apply)||void 0===e?void 0:e.includes(t))if(o instanceof m){for(const t of[...o.__ctx.__defs.childNodes])if(t instanceof Element){const e=t.getAttribute("id");this.__ids.add(e),this.__defs.appendChild(t)}const t=o.__root.getAttribute("id");i.setAttribute(n.apply,`url(#${t})`)}else if(o instanceof d){const t=o.__root.getAttribute("id");i.setAttribute(n.apply,`url(#${t})`)}else if(n.svg!==o)if("stroke"!==n.svgAttr&&"fill"!==n.svgAttr||!(0,a.isString)(o)||-1===o.indexOf("rgba")){let e=n.svgAttr;if("globalAlpha"===s[r]&&(e=`${t}-${n.svgAttr}`,i.getAttribute(e)))continue;i.setAttribute(e,`${o}`)}else{const t=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi.exec(o),[,e,s,r,a]=t;i.setAttribute(n.svgAttr,`rgb(${e},${s},${r})`);let l=parseFloat(a);const h=this.globalAlpha;null!=h&&(l*=h),i.setAttribute(`${n.svgAttr}-opacity`,`${l}`)}}}get_serialized_svg(t=!1){let e=(new XMLSerializer).serializeToString(this.__root);if(t)for(const[t,i]of p){const s=new RegExp(t,"gi");s.test(e)&&(e=e.replace(s,i))}return e}get_svg(){return this.__root}save(){this.__stack.push({transform:this._transform,clip_path:this._clip_path,attributes:this.__getStyleState()}),this._transform=this._transform.clone()}restore(){if(0==this.__stack.length)return;const{transform:t,clip_path:e,attributes:i}=this.__stack.pop();this._transform=t,this._clip_path=e,this.__applyStyleState(i)}_apply_transform(t,e=this._transform){e.is_identity||t.setAttribute("transform",e.toString())}scale(t,e){isFinite(t)&&(null==e||isFinite(e))&&this._transform.scale(t,null!=e?e:t)}rotate(t){isFinite(t)&&this._transform.rotate(t)}translate(t,e){isFinite(t+e)&&this._transform.translate(t,e)}transform(t,e,i,s,r,n){isFinite(t+e+i+s+r+n)&&this._transform.transform(t,e,i,s,r,n)}beginPath(){this.__currentDefaultPath="",this.__currentPosition=null,this.__init_element()}__init_element(){const t=this.__createElement("path",{},!0);this.__root.appendChild(t),this.__currentElement=t}__applyCurrentDefaultPath(){const t=this.__currentElement;"path"===t.nodeName?t.setAttribute("d",this.__currentDefaultPath):console.error("Attempted to apply path command to node",t.nodeName)}__addPathCommand(t,e,i){const s=this.__currentDefaultPath?" ":"";this.__currentDefaultPath+=s+i,this.__currentPosition={x:t,y:e}}get _hasCurrentDefaultPath(){return!!this.__currentDefaultPath}moveTo(t,e){if(!isFinite(t+e))return;const i=this.__currentElement;i&&"path"===i.nodeName||this.beginPath();const[s,r]=this._transform.apply(t,e);this.__addPathCommand(s,r,`M ${s} ${r}`)}closePath(){this._hasCurrentDefaultPath&&this.__addPathCommand(NaN,NaN,"Z")}lineTo(t,e){if(isFinite(t+e))if(this._hasCurrentDefaultPath){const[i,s]=this._transform.apply(t,e);this.__addPathCommand(i,s,`L ${i} ${s}`)}else this.moveTo(t,e)}bezierCurveTo(t,e,i,s,r,n){if(!isFinite(t+e+i+s+r+n))return;const[a,o]=this._transform.apply(r,n),[l,h]=this._transform.apply(t,e),[_,c]=this._transform.apply(i,s);this.__addPathCommand(a,o,`C ${l} ${h} ${_} ${c} ${a} ${o}`)}quadraticCurveTo(t,e,i,s){if(!isFinite(t+e+i+s))return;const[r,n]=this._transform.apply(i,s),[a,o]=this._transform.apply(t,e);this.__addPathCommand(r,n,`Q ${a} ${o} ${r} ${n}`)}arcTo(t,e,i,s,r){if(!isFinite(t+e+i+s+r))return;if(null==this.__currentPosition)return;const n=this.__currentPosition.x,a=this.__currentPosition.y;if(r<0)throw new Error(`IndexSizeError: The radius provided (${r}) is negative.`);if(n===t&&a===e||t===i&&e===s||0===r)return void this.lineTo(t,e);function o([t,e]){const i=Math.sqrt(t**2+e**2);return[t/i,e/i]}const l=o([n-t,a-e]),h=o([i-t,s-e]);if(l[0]*h[1]==l[1]*h[0])return void this.lineTo(t,e);const _=l[0]*h[0]+l[1]*h[1],c=Math.acos(Math.abs(_)),p=o([l[0]+h[0],l[1]+h[1]]),u=r/Math.sin(c/2),d=t+u*p[0],m=e+u*p[1],f=[-l[1],l[0]],g=[h[1],-h[0]];function b(t){const e=t[0];return t[1]>=0?Math.acos(e):-Math.acos(e)}const v=b(f),A=b(g);this.lineTo(d+f[0]*r,m+f[1]*r),this.arc(d,m,r,v,A)}stroke(){"path"===this.__currentElement.nodeName&&this.__currentElement.setAttribute("paint-order","fill"),this.__applyCurrentDefaultPath(),this.__applyStyleToCurrentElement("stroke"),null!=this._clip_path&&this.__currentElement.setAttribute("clip-path",this._clip_path)}fill(t,e){let i=null;if(t instanceof Path2D)i=t;else{if("evenodd"!=t&&"nonzero"!=t&&null!=t||null!=e)throw new Error("invalid arguments");e=t}if(null!=i)throw new Error("not implemented");"none"!=this.__currentElement.getAttribute("fill")&&this.__init_element(),"path"===this.__currentElement.nodeName&&this.__currentElement.setAttribute("paint-order","stroke"),this.__applyCurrentDefaultPath(),this.__applyStyleToCurrentElement("fill"),null!=e&&this.__currentElement.setAttribute("fill-rule",e),null!=this._clip_path&&this.__currentElement.setAttribute("clip-path",this._clip_path)}rect(t,e,i,s){isFinite(t+e+i+s)&&(this.moveTo(t,e),this.lineTo(t+i,e),this.lineTo(t+i,e+s),this.lineTo(t,e+s),this.lineTo(t,e))}fillRect(t,e,i,s){isFinite(t+e+i+s)&&(this.beginPath(),this.rect(t,e,i,s),this.fill())}strokeRect(t,e,i,s){isFinite(t+e+i+s)&&(this.beginPath(),this.rect(t,e,i,s),this.stroke())}__clearCanvas(){(0,h.empty)(this.__defs),(0,h.empty)(this.__root),this.__root.appendChild(this.__defs),this.__currentElement=this.__root}clearRect(t,e,i,s){if(!isFinite(t+e+i+s))return;if(0===t&&0===e&&i===this.width&&s===this.height)return void this.__clearCanvas();const r=this.__createElement("rect",{x:t,y:e,width:i,height:s,fill:"#FFFFFF"},!0);this._apply_transform(r),this.__root.appendChild(r)}createLinearGradient(t,e,i,s){if(!isFinite(t+e+i+s))throw new Error("The provided double value is non-finite");const[r,n]=this._transform.apply(t,e),[a,o]=this._transform.apply(i,s),l=this.__createElement("linearGradient",{id:this._random_string(),x1:`${r}px`,x2:`${a}px`,y1:`${n}px`,y2:`${o}px`,gradientUnits:"userSpaceOnUse"},!1);return this.__defs.appendChild(l),new d(l,this)}createRadialGradient(t,e,i,s,r,n){if(!isFinite(t+e+i+s+r+n))throw new Error("The provided double value is non-finite");const[a,o]=this._transform.apply(t,e),[l,h]=this._transform.apply(s,r),_=this.__createElement("radialGradient",{id:this._random_string(),cx:`${l}px`,cy:`${h}px`,r:`${n}px`,r0:`${i}px`,fx:`${a}px`,fy:`${o}px`,gradientUnits:"userSpaceOnUse"},!1);return this.__defs.appendChild(_),new d(_,this)}__parseFont(){var t,e,i,s,r;const n=/^\s*(?=(?:(?:[-a-z]+\s*){0,2}(italic|oblique))?)(?=(?:(?:[-a-z]+\s*){0,2}(small-caps))?)(?=(?:(?:[-a-z]+\s*){0,2}(bold(?:er)?|lighter|[1-9]00))?)(?:(?:normal|\1|\2|\3)\s*){0,3}((?:xx?-)?(?:small|large)|medium|smaller|larger|[.\d]+(?:\%|in|[cem]m|ex|p[ctx]))(?:\s*\/\s*(normal|[.\d]+(?:\%|in|[cem]m|ex|p[ctx])))?\s*([-,\'\"\sa-z0-9]+?)\s*$/i.exec(this.font);return{style:null!==(t=n[1])&&void 0!==t?t:"normal",size:null!==(e=n[4])&&void 0!==e?e:"10px",family:null!==(i=n[6])&&void 0!==i?i:"sans-serif",weight:null!==(s=n[3])&&void 0!==s?s:"normal",decoration:null!==(r=n[2])&&void 0!==r?r:"normal"}}__applyText(t,e,i,s){const r=this.__parseFont(),n=this.__createElement("text",{"font-family":r.family,"font-size":r.size,"font-style":r.style,"font-weight":r.weight,"text-decoration":r.decoration,x:e,y:i,"text-anchor":_(this.textAlign),"dominant-baseline":c(this.textBaseline)},!0);n.appendChild(this.__document.createTextNode(t)),this._apply_transform(n),this.__currentElement=n,this.__applyStyleToCurrentElement(s);const a=(()=>{if(null!=this._clip_path){const t=this.__createElement("g");return t.setAttribute("clip-path",this._clip_path),t.appendChild(n),t}return n})();this.__root.appendChild(a)}fillText(t,e,i){null!=t&&isFinite(e+i)&&this.__applyText(t,e,i,"fill")}strokeText(t,e,i){null!=t&&isFinite(e+i)&&this.__applyText(t,e,i,"stroke")}measureText(t){return this.__ctx.font=this.font,this.__ctx.measureText(t)}arc(t,e,i,s,r,n=!1){this.ellipse(t,e,i,i,0,s,r,n)}ellipse(t,e,i,s,r,n,a,o=!1){if(!isFinite(t+e+i+s+r+n+a))return;if(i<0||s<0)throw new DOMException("IndexSizeError, radius can't be negative");const h=o?a-n:n-a;n%=2*Math.PI,a%=2*Math.PI;const _=t+i*Math.cos(n),c=e+s*Math.sin(n);this.lineTo(_,c);const p=180*r/Math.PI,u=o?0:1;if(Math.abs(n-a)<2*l.float32_epsilon&&!(Math.abs(h)<2*l.float32_epsilon&&h<0)){const r=t+i*Math.cos(n+Math.PI),a=e+s*Math.sin(n+Math.PI),[o,l]=this._transform.apply(_,c),[h,d]=this._transform.apply(r,a);this.__addPathCommand(o,l,`A ${i} ${s} ${p} 0 ${u} ${h} ${d} A ${i} ${s} ${p} 0 ${u} ${o} ${l}`)}else{const r=t+i*Math.cos(a),l=e+s*Math.sin(a);let h=a-n;h<0&&(h+=2*Math.PI);const _=o!==h>Math.PI?1:0,[c,d]=this._transform.apply(r,l);this.__addPathCommand(c,d,`A ${i} ${s} ${p} ${_} ${u} ${c} ${d}`)}}clip(){const t=this.__createElement("clipPath"),e=this._random_string();this.__applyCurrentDefaultPath(),t.setAttribute("id",e),t.appendChild(this.__currentElement),this.__defs.appendChild(t),this._clip_path=`url(#${e})`}drawImage(t,...e){let i,s,r,n,a,o,l,h;if(2==e.length){if([i,s]=e,!isFinite(i+s))return;a=0,o=0,l=t.width,h=t.height,r=l,n=h}else if(4==e.length){if([i,s,r,n]=e,!isFinite(i+s+r+n))return;a=0,o=0,l=t.width,h=t.height}else{if(8!==e.length)throw new Error(`Inavlid number of arguments passed to drawImage: ${arguments.length}`);if([a,o,l,h,i,s,r,n]=e,!isFinite(a+o+l+h+i+s+r+n))return}const _=this.__root,c=this._transform.clone().translate(i,s);if(t instanceof f||t instanceof SVGSVGElement){const e=(t instanceof SVGSVGElement?t:t.get_svg()).cloneNode(!0);let i;c.is_identity&&1==this.globalAlpha&&null==this._clip_path?i=_:(i=this.__createElement("g"),c.is_identity||this._apply_transform(i,c),1!=this.globalAlpha&&i.setAttribute("opacity",`${this.globalAlpha}`),null!=this._clip_path&&i.setAttribute("clip-path",this._clip_path),_.appendChild(i));for(const t of[...e.childNodes])if(t instanceof SVGDefsElement){for(const e of[...t.childNodes])if(e instanceof Element){const t=e.getAttribute("id");this.__ids.add(t),this.__defs.appendChild(e.cloneNode(!0))}}else i.appendChild(t.cloneNode(!0))}else if(t instanceof HTMLImageElement||t instanceof SVGImageElement){const e=this.__createElement("image");if(e.setAttribute("width",`${r}`),e.setAttribute("height",`${n}`),e.setAttribute("preserveAspectRatio","none"),1!=this.globalAlpha&&e.setAttribute("opacity",`${this.globalAlpha}`),a||o||l!==t.width||h!==t.height){const e=this.__document.createElement("canvas");e.width=r,e.height=n;e.getContext("2d").drawImage(t,a,o,l,h,0,0,r,n),t=e}this._apply_transform(e,c);const i=t instanceof HTMLCanvasElement?t.toDataURL():t.getAttribute("src");if(e.setAttribute("href",i),null!=this._clip_path){const t=this.__createElement("g");t.setAttribute("clip-path",this._clip_path),t.appendChild(e),_.appendChild(t)}else _.appendChild(e)}else if(t instanceof HTMLCanvasElement){const e=this.__createElement("image");e.setAttribute("width",`${r}`),e.setAttribute("height",`${n}`),e.setAttribute("preserveAspectRatio","none"),1!=this.globalAlpha&&e.setAttribute("opacity",`${this.globalAlpha}`);const i=this.__document.createElement("canvas");i.width=r,i.height=n;const s=i.getContext("2d");if(s.imageSmoothingEnabled=!1,s.drawImage(t,a,o,l,h,0,0,r,n),t=i,this._apply_transform(e,c),e.setAttribute("href",t.toDataURL()),null!=this._clip_path){const t=this.__createElement("g");t.setAttribute("clip-path",this._clip_path),t.appendChild(e),_.appendChild(t)}else _.appendChild(e)}}createPattern(t,e){const i=this.__document.createElementNS("http://www.w3.org/2000/svg","pattern"),s=this._random_string();if(i.setAttribute("id",s),i.setAttribute("width",`${this._to_number(t.width)}`),i.setAttribute("height",`${this._to_number(t.height)}`),i.setAttribute("patternUnits","userSpaceOnUse"),t instanceof HTMLCanvasElement||t instanceof HTMLImageElement||t instanceof SVGImageElement){const e=this.__document.createElementNS("http://www.w3.org/2000/svg","image"),s=t instanceof HTMLCanvasElement?t.toDataURL():t.getAttribute("src");e.setAttribute("href",s),i.appendChild(e),this.__defs.appendChild(i)}else if(t instanceof f){for(const e of[...t.__root.childNodes])e instanceof SVGDefsElement||i.appendChild(e.cloneNode(!0));this.__defs.appendChild(i)}else{if(!(t instanceof SVGSVGElement))throw new Error("unsupported");for(const e of[...t.childNodes])e instanceof SVGDefsElement||i.appendChild(e.cloneNode(!0));this.__defs.appendChild(i)}return new m(i,this)}getLineDash(){const{lineDash:t}=this;return(0,a.isString)(t)?t.split(",").map((t=>parseInt(t))):null==t?[]:t}setLineDash(t){t&&t.length>0?this.lineDash=t.join(","):this.lineDash=null}_to_number(t){return(0,a.isNumber)(t)?t:t.baseVal.value}getTransform(){return this._transform.to_DOMMatrix()}setTransform(...t){let e;e=(0,a.isNumber)(t[0])?new DOMMatrix(t):t[0]instanceof DOMMatrix?t[0]:new DOMMatrix(Object.values(!t[0])),this._transform=n.AffineTransform.from_DOMMatrix(e)}resetTransform(){this._transform=new n.AffineTransform}isPointInPath(...t){throw new Error("not implemented")}isPointInStroke(...t){throw new Error("not implemented")}createImageData(...t){throw new Error("not implemented")}getImageData(t,e,i,s){throw new Error("not implemented")}putImageData(...t){throw new Error("not implemented")}drawFocusIfNeeded(...t){throw new Error("not implemented")}scrollPathIntoView(...t){throw new Error("not implemented")}}i.SVGRenderingContext2D=f,f.__name__="SVGRenderingContext2D",f.__random=o.random},
function _(e,t,s,n,r){n();const o=2147483647;class i{constructor(e){this.seed=e%o,this.seed<=0&&(this.seed+=2147483646)}integer(){return this.seed=48271*this.seed%o,this.seed}float(){return(this.integer()-1)/2147483646}floats(e,t=0,s=1){const n=new Array(e);for(let r=0;r<e;r++)n[r]=t+this.float()*(s-t);return n}choices(e,t){const s=t.length,n=new Array(e);for(let r=0;r<e;r++)n[r]=t[this.integer()%s];return n}}s.Random=i,i.__name__="Random",s.random=new i(Date.now())},
function _(o,t,n,i,e){i();const s=o(224),c=o(15);class l extends s.ButtonToolButtonView{_clicked(){this.model.do.emit(void 0)}}n.ActionToolButtonView=l,l.__name__="ActionToolButtonView";class _ extends s.ButtonToolView{connect_signals(){super.connect_signals(),this.connect(this.model.do,(o=>this.doit(o)))}}n.ActionToolView=_,_.__name__="ActionToolView";class d extends s.ButtonTool{constructor(o){super(o),this.button_view=l,this.do=new c.Signal(this,"do")}}n.ActionTool=d,d.__name__="ActionTool"},
function _(o,e,t,l,i){var s;l();const n=o(238),r=o(228);class c extends n.ActionToolView{doit(){window.open(this.model.redirect)}}t.HelpToolView=c,c.__name__="HelpToolView";class _ extends n.ActionTool{constructor(o){super(o),this.tool_name="Help",this.icon=r.tool_icon_help}}t.HelpTool=_,s=_,_.__name__="HelpTool",s.prototype.default_view=c,s.define((({String:o})=>({redirect:[o,"https://docs.bokeh.org/en/latest/docs/user_guide/tools.html"]}))),s.override({description:"Click the question mark to learn more about Bokeh plot tools."}),s.register_alias("help",(()=>new _))},
function _(o,l,g,A,r){A(),g.root="bk-root",g.logo="bk-logo",g.grey="bk-grey",g.logo_small="bk-logo-small",g.logo_notebook="bk-logo-notebook",g.default=".bk-root .bk-logo{margin:5px;position:relative;display:block;background-repeat:no-repeat;}.bk-root .bk-logo.bk-grey{filter:url(\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg'><filter id='grayscale'><feColorMatrix type='matrix' values='0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0 0 0 1 0'/></filter></svg>#grayscale\");filter:gray;-webkit-filter:grayscale(100%);}.bk-root .bk-logo-small{width:20px;height:20px;background-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAALEgAACxIB0t1+/AAAABx0RVh0U29mdHdhcmUAQWRvYmUgRmlyZXdvcmtzIENTNui8sowAAAOkSURBVDiNjZRtaJVlGMd/1/08zzln5zjP1LWcU9N0NkN8m2CYjpgQYQXqSs0I84OLIC0hkEKoPtiH3gmKoiJDU7QpLgoLjLIQCpEsNJ1vqUOdO7ppbuec5+V+rj4ctwzd8IIbbi6u+8f1539dt3A78eXC7QizUF7gyV1fD1Yqg4JWz84yffhm0qkFqBogB9rM8tZdtwVsPUhWhGcFJngGeWrPzHm5oaMmkfEg1usvLFyc8jLRqDOMru7AyC8saQr7GG7f5fvDeH7Ej8CM66nIF+8yngt6HWaKh7k49Soy9nXurCi1o3qUbS3zWfrYeQDTB/Qj6kX6Ybhw4B+bOYoLKCC9H3Nu/leUTZ1JdRWkkn2ldcCamzrcf47KKXdAJllSlxAOkRgyHsGC/zRday5Qld9DyoM4/q/rUoy/CXh3jzOu3bHUVZeU+DEn8FInkPBFlu3+nW3Nw0mk6vCDiWg8CeJaxEwuHS3+z5RgY+YBR6V1Z1nxSOfoaPa4LASWxxdNp+VWTk7+4vzaou8v8PN+xo+KY2xsw6une2frhw05CTYOmQvsEhjhWjn0bmXPjpE1+kplmmkP3suftwTubK9Vq22qKmrBhpY4jvd5afdRA3wGjFAgcnTK2s4hY0/GPNIb0nErGMCRxWOOX64Z8RAC4oCXdklmEvcL8o0BfkNK4lUg9HTl+oPlQxdNo3Mg4Nv175e/1LDGzZen30MEjRUtmXSfiTVu1kK8W4txyV6BMKlbgk3lMwYCiusNy9fVfvvwMxv8Ynl6vxoByANLTWplvuj/nF9m2+PDtt1eiHPBr1oIfhCChQMBw6Aw0UulqTKZdfVvfG7VcfIqLG9bcldL/+pdWTLxLUy8Qq38heUIjh4XlzZxzQm19lLFlr8vdQ97rjZVOLf8nclzckbcD4wxXMidpX30sFd37Fv/GtwwhzhxGVAprjbg0gCAEeIgwCZyTV2Z1REEW8O4py0wsjeloKoMr6iCY6dP92H6Vw/oTyICIthibxjm/DfN9lVz8IqtqKYLUXfoKVMVQVVJOElGjrnnUt9T9wbgp8AyYKaGlqingHZU/uG2NTZSVqwHQTWkx9hxjkpWDaCg6Ckj5qebgBVbT3V3NNXMSiWSDdGV3hrtzla7J+duwPOToIg42ChPQOQjspnSlp1V+Gjdged7+8UN5CRAV7a5EdFNwCjEaBR27b3W890TE7g24NAP/mMDXRWrGoFPQI9ls/MWO2dWFAar/xcOIImbbpA3zgAAAABJRU5ErkJggg==);}.bk-root .bk-logo-notebook{display:inline-block;vertical-align:middle;margin-right:5px;}"},
function _(e,t,s,i,l){i();const o=e(1);var n;const a=e(40),h=e(20),r=e(43),c=(0,o.__importStar)(e(242)),d=c;class p extends a.AnnotationView{initialize(){super.initialize(),this.el=(0,r.div)({class:d.tooltip}),(0,r.undisplay)(this.el),this.plot_view.canvas_view.add_overlay(this.el)}remove(){(0,r.remove)(this.el),super.remove()}connect_signals(){super.connect_signals(),this.connect(this.model.properties.content.change,(()=>this.render())),this.connect(this.model.properties.position.change,(()=>this._reposition()))}styles(){return[...super.styles(),c.default]}render(){this.model.visible||(0,r.undisplay)(this.el),super.render()}_render(){const{content:e}=this.model;null!=e?((0,r.empty)(this.el),(0,r.classes)(this.el).toggle("bk-tooltip-custom",this.model.custom),this.el.appendChild(e),this.model.show_arrow&&this.el.classList.add(d.tooltip_arrow)):(0,r.undisplay)(this.el)}_reposition(){const{position:e}=this.model;if(null==e)return void(0,r.undisplay)(this.el);const[t,s]=e,i=(()=>{const e=this.parent.layout.bbox.relative(),{attachment:i}=this.model;switch(i){case"horizontal":return t<e.hcenter?"right":"left";case"vertical":return s<e.vcenter?"below":"above";default:return i}})();let l;this.el.classList.remove(d.right),this.el.classList.remove(d.left),this.el.classList.remove(d.above),this.el.classList.remove(d.below),(0,r.display)(this.el);let o=null,n=null;switch(i){case"right":this.el.classList.add(d.left),o=t+(this.el.offsetWidth-this.el.clientWidth)+10,l=s-this.el.offsetHeight/2;break;case"left":this.el.classList.add(d.right),n=this.plot_view.layout.bbox.width-t+10,l=s-this.el.offsetHeight/2;break;case"below":this.el.classList.add(d.above),l=s+(this.el.offsetHeight-this.el.clientHeight)+10,o=Math.round(t-this.el.offsetWidth/2);break;case"above":this.el.classList.add(d.below),l=s-this.el.offsetHeight-10,o=Math.round(t-this.el.offsetWidth/2)}this.el.style.top=`${l}px`,this.el.style.left=null!=o?`${o}px`:"auto",this.el.style.right=null!=n?`${n}px`:"auto"}}s.TooltipView=p,p.__name__="TooltipView";class u extends a.Annotation{constructor(e){super(e)}clear(){this.position=null}}s.Tooltip=u,n=u,u.__name__="Tooltip",n.prototype.default_view=p,n.define((({Boolean:e})=>({attachment:[h.TooltipAttachment,"horizontal"],inner_only:[e,!0],show_arrow:[e,!0]}))),n.internal((({Boolean:e,Number:t,Tuple:s,Ref:i,Nullable:l})=>({position:[l(s(t,t)),null],content:[i(HTMLElement),()=>(0,r.div)()],custom:[e]}))),n.override({level:"overlay"})},
function _(o,t,r,e,l){e(),r.root="bk-root",r.tooltip="bk-tooltip",r.left="bk-left",r.tooltip_arrow="bk-tooltip-arrow",r.right="bk-right",r.above="bk-above",r.below="bk-below",r.tooltip_row_label="bk-tooltip-row-label",r.tooltip_row_value="bk-tooltip-row-value",r.tooltip_color_block="bk-tooltip-color-block",r.default='.bk-root{}.bk-root .bk-tooltip{font-weight:300;font-size:12px;position:absolute;padding:5px;border:1px solid #e5e5e5;color:#2f2f2f;background-color:white;pointer-events:none;opacity:0.95;z-index:100;}.bk-root .bk-tooltip > div:not(:first-child){margin-top:5px;border-top:#e5e5e5 1px dashed;}.bk-root .bk-tooltip.bk-left.bk-tooltip-arrow::before{position:absolute;margin:-7px 0 0 0;top:50%;width:0;height:0;border-style:solid;border-width:7px 0 7px 0;border-color:transparent;content:" ";display:block;left:-10px;border-right-width:10px;border-right-color:#909599;}.bk-root .bk-tooltip.bk-left::before{left:-10px;border-right-width:10px;border-right-color:#909599;}.bk-root .bk-tooltip.bk-right.bk-tooltip-arrow::after{position:absolute;margin:-7px 0 0 0;top:50%;width:0;height:0;border-style:solid;border-width:7px 0 7px 0;border-color:transparent;content:" ";display:block;right:-10px;border-left-width:10px;border-left-color:#909599;}.bk-root .bk-tooltip.bk-right::after{right:-10px;border-left-width:10px;border-left-color:#909599;}.bk-root .bk-tooltip.bk-above::before{position:absolute;margin:0 0 0 -7px;left:50%;width:0;height:0;border-style:solid;border-width:0 7px 0 7px;border-color:transparent;content:" ";display:block;top:-10px;border-bottom-width:10px;border-bottom-color:#909599;}.bk-root .bk-tooltip.bk-below::after{position:absolute;margin:0 0 0 -7px;left:50%;width:0;height:0;border-style:solid;border-width:0 7px 0 7px;border-color:transparent;content:" ";display:block;bottom:-10px;border-top-width:10px;border-top-color:#909599;}.bk-root .bk-tooltip-row-label{text-align:right;color:#26aae1;}.bk-root .bk-tooltip-row-value{color:default;}.bk-root .bk-tooltip-color-block{width:12px;height:12px;margin-left:5px;margin-right:5px;outline:#dddddd solid 1px;display:inline-block;}'},
function _(e,t,s,i,r){var a;i();const l=e(115),_=e(112),h=e(113),o=e(48);class n extends l.UpperLowerView{async lazy_initialize(){await super.lazy_initialize();const{lower_head:e,upper_head:t}=this.model;null!=e&&(this.lower_head=await(0,h.build_view)(e,{parent:this})),null!=t&&(this.upper_head=await(0,h.build_view)(t,{parent:this}))}set_data(e){var t,s;super.set_data(e),null===(t=this.lower_head)||void 0===t||t.set_data(e),null===(s=this.upper_head)||void 0===s||s.set_data(e)}paint(e){if(this.visuals.line.doit)for(let t=0,s=this._lower_sx.length;t<s;t++)this.visuals.line.set_vectorize(e,t),e.beginPath(),e.moveTo(this._lower_sx[t],this._lower_sy[t]),e.lineTo(this._upper_sx[t],this._upper_sy[t]),e.stroke();const t="height"==this.model.dimension?0:Math.PI/2;if(null!=this.lower_head)for(let s=0,i=this._lower_sx.length;s<i;s++)e.save(),e.translate(this._lower_sx[s],this._lower_sy[s]),e.rotate(t+Math.PI),this.lower_head.render(e,s),e.restore();if(null!=this.upper_head)for(let s=0,i=this._upper_sx.length;s<i;s++)e.save(),e.translate(this._upper_sx[s],this._upper_sy[s]),e.rotate(t),this.upper_head.render(e,s),e.restore()}}s.WhiskerView=n,n.__name__="WhiskerView";class d extends l.UpperLower{constructor(e){super(e)}}s.Whisker=d,a=d,d.__name__="Whisker",a.prototype.default_view=n,a.mixins(o.LineVector),a.define((({Ref:e,Nullable:t})=>({lower_head:[t(e(_.ArrowHead)),()=>new _.TeeHead({size:10})],upper_head:[t(e(_.ArrowHead)),()=>new _.TeeHead({size:10})]}))),a.override({level:"underlay"})},
function _(n,o,t,u,e){u(),e("CustomJS",n(245).CustomJS),e("OpenURL",n(247).OpenURL)},
function _(t,e,s,n,c){var a;n();const r=t(246),u=t(13),o=t(34);class i extends r.Callback{constructor(t){super(t)}get names(){return(0,u.keys)(this.args)}get values(){return(0,u.values)(this.args)}get func(){const t=(0,o.use_strict)(this.code);return new Function(...this.names,"cb_obj","cb_data",t)}execute(t,e={}){return this.func.apply(t,this.values.concat(t,e))}}s.CustomJS=i,a=i,i.__name__="CustomJS",a.define((({Unknown:t,String:e,Dict:s})=>({args:[s(t),{}],code:[e,""]})))},
function _(c,a,l,n,s){n();const e=c(53);class o extends e.Model{constructor(c){super(c)}}l.Callback=o,o.__name__="Callback"},
function _(e,t,n,o,i){var s;o();const c=e(246),r=e(152),a=e(8);class d extends c.Callback{constructor(e){super(e)}navigate(e){this.same_tab?window.location.href=e:window.open(e)}execute(e,{source:t}){const n=e=>{const n=(0,r.replace_placeholders)(this.url,t,e,void 0,void 0,encodeURI);if(!(0,a.isString)(n))throw new Error("HTML output is not supported in this context");this.navigate(n)},{selected:o}=t;for(const e of o.indices)n(e);for(const e of o.line_indices)n(e)}}n.OpenURL=d,s=d,d.__name__="OpenURL",s.define((({Boolean:e,String:t})=>({url:[t,"http://"],same_tab:[e,!1]})))},
function _(a,n,i,e,r){e(),r("Canvas",a(249).Canvas),r("CartesianFrame",a(126).CartesianFrame),r("CoordinateMapping",a(54).CoordinateMapping)},
function _(e,t,i,s,a){var l,r=this&&this.__createBinding||(Object.create?function(e,t,i,s){void 0===s&&(s=i),Object.defineProperty(e,s,{enumerable:!0,get:function(){return t[i]}})}:function(e,t,i,s){void 0===s&&(s=i),e[s]=t[i]}),n=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),o=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var i in e)"default"!==i&&Object.prototype.hasOwnProperty.call(e,i)&&r(t,e,i);return n(t,e),t};s();const h=e(14),c=e(28),u=e(226),_=e(19),d=e(43),p=e(20),b=e(13),v=e(250),g=e(65),w=e(138),y=e(235);const f=(()=>{let t;return async()=>void 0!==t?t:t=await async function(){const t=document.createElement("canvas"),i=t.getContext("webgl",{premultipliedAlpha:!0});if(null!=i){const s=await(0,w.load_module)(Promise.resolve().then((()=>o(e(410)))));if(null!=s){const e=s.get_regl(i);if(e.has_webgl)return{canvas:t,regl_wrapper:e};_.logger.trace("WebGL is supported, but not the required extensions")}else _.logger.trace("WebGL is supported, but bokehjs(.min).js bundle is not available")}else _.logger.trace("WebGL is not supported");return null}()})(),m={position:"absolute",top:"0",left:"0",width:"100%",height:"100%"};class x extends u.DOMView{constructor(){super(...arguments),this.bbox=new g.BBox,this.webgl=null}initialize(){super.initialize(),this.underlays_el=(0,d.div)({style:m}),this.primary=this.create_layer(),this.overlays=this.create_layer(),this.overlays_el=(0,d.div)({style:m}),this.events_el=(0,d.div)({class:"bk-canvas-events",style:m});const e=[this.underlays_el,this.primary.el,this.overlays.el,this.overlays_el,this.events_el];(0,b.extend)(this.el.style,m),(0,d.append)(this.el,...e),this.ui_event_bus=new v.UIEventBus(this)}async lazy_initialize(){if(await super.lazy_initialize(),"webgl"==this.model.output_backend&&(this.webgl=await f(),c.settings.force_webgl&&null==this.webgl))throw new Error("webgl is not available")}remove(){this.ui_event_bus.destroy(),super.remove()}add_underlay(e){this.underlays_el.appendChild(e)}add_overlay(e){this.overlays_el.appendChild(e)}add_event(e){this.events_el.appendChild(e)}get pixel_ratio(){return this.primary.pixel_ratio}resize(e,t){this.bbox=new g.BBox({left:0,top:0,width:e,height:t}),this.primary.resize(e,t),this.overlays.resize(e,t)}prepare_webgl(e){const{webgl:t}=this;if(null!=t){const{width:i,height:s}=this.bbox;t.canvas.width=this.pixel_ratio*i,t.canvas.height=this.pixel_ratio*s;const[a,l,r,n]=e,{xview:o,yview:h}=this.bbox,c=o.compute(a),u=h.compute(l+n),_=this.pixel_ratio;t.regl_wrapper.set_scissor(_*c,_*u,_*r,_*n),this._clear_webgl()}}blit_webgl(e){const{webgl:t}=this;if(null!=t){if(_.logger.debug("Blitting WebGL canvas"),e.restore(),e.drawImage(t.canvas,0,0),e.save(),this.model.hidpi){const t=this.pixel_ratio;e.scale(t,t),e.translate(.5,.5)}this._clear_webgl()}}_clear_webgl(){const{webgl:e}=this;if(null!=e){const{regl_wrapper:t,canvas:i}=e;t.clear(i.width,i.height)}}compose(){const e=this.create_layer(),{width:t,height:i}=this.bbox;return e.resize(t,i),e.ctx.drawImage(this.primary.canvas,0,0),e.ctx.drawImage(this.overlays.canvas,0,0),e}create_layer(){const{output_backend:e,hidpi:t}=this.model;return new y.CanvasLayer(e,t)}to_blob(){return this.compose().to_blob()}}i.CanvasView=x,x.__name__="CanvasView";class z extends h.HasProps{constructor(e){super(e)}}i.Canvas=z,l=z,z.__name__="Canvas",l.prototype.default_view=x,l.internal((({Boolean:e})=>({hidpi:[e,!0],output_backend:[p.OutputBackend,"canvas"]})))},
function _(t,e,s,n,i){n();const r=t(1),a=(0,r.__importDefault)(t(225)),_=t(15),h=t(19),o=t(43),l=(0,r.__importStar)(t(251)),c=t(252),p=t(9),u=t(8),v=t(27),d=t(230);class g{constructor(t){this.canvas_view=t,this.pan_start=new _.Signal(this,"pan:start"),this.pan=new _.Signal(this,"pan"),this.pan_end=new _.Signal(this,"pan:end"),this.pinch_start=new _.Signal(this,"pinch:start"),this.pinch=new _.Signal(this,"pinch"),this.pinch_end=new _.Signal(this,"pinch:end"),this.rotate_start=new _.Signal(this,"rotate:start"),this.rotate=new _.Signal(this,"rotate"),this.rotate_end=new _.Signal(this,"rotate:end"),this.tap=new _.Signal(this,"tap"),this.doubletap=new _.Signal(this,"doubletap"),this.press=new _.Signal(this,"press"),this.pressup=new _.Signal(this,"pressup"),this.move_enter=new _.Signal(this,"move:enter"),this.move=new _.Signal(this,"move"),this.move_exit=new _.Signal(this,"move:exit"),this.scroll=new _.Signal(this,"scroll"),this.keydown=new _.Signal(this,"keydown"),this.keyup=new _.Signal(this,"keyup"),this.hammer=new a.default(this.hit_area,{touchAction:"auto",inputClass:a.default.TouchMouseInput}),this._prev_move=null,this._curr_pan=null,this._curr_pinch=null,this._curr_rotate=null,this._configure_hammerjs(),this.hit_area.addEventListener("mousemove",(t=>this._mouse_move(t))),this.hit_area.addEventListener("mouseenter",(t=>this._mouse_enter(t))),this.hit_area.addEventListener("mouseleave",(t=>this._mouse_exit(t))),this.hit_area.addEventListener("contextmenu",(t=>this._context_menu(t))),this.hit_area.addEventListener("wheel",(t=>this._mouse_wheel(t))),document.addEventListener("keydown",this),document.addEventListener("keyup",this),this.menu=new d.ContextMenu([],{prevent_hide:t=>2==t.button&&t.target==this.hit_area}),this.hit_area.appendChild(this.menu.el)}get hit_area(){return this.canvas_view.events_el}destroy(){this.menu.remove(),this.hammer.destroy(),document.removeEventListener("keydown",this),document.removeEventListener("keyup",this)}handleEvent(t){"keydown"==t.type?this._key_down(t):"keyup"==t.type&&this._key_up(t)}_configure_hammerjs(){this.hammer.get("doubletap").recognizeWith("tap"),this.hammer.get("tap").requireFailure("doubletap"),this.hammer.get("doubletap").dropRequireFailure("tap"),this.hammer.on("doubletap",(t=>this._doubletap(t))),this.hammer.on("tap",(t=>this._tap(t))),this.hammer.on("press",(t=>this._press(t))),this.hammer.on("pressup",(t=>this._pressup(t))),this.hammer.get("pan").set({direction:a.default.DIRECTION_ALL}),this.hammer.on("panstart",(t=>this._pan_start(t))),this.hammer.on("pan",(t=>this._pan(t))),this.hammer.on("panend",(t=>this._pan_end(t))),this.hammer.get("pinch").set({enable:!0}),this.hammer.on("pinchstart",(t=>this._pinch_start(t))),this.hammer.on("pinch",(t=>this._pinch(t))),this.hammer.on("pinchend",(t=>this._pinch_end(t))),this.hammer.get("rotate").set({enable:!0}),this.hammer.on("rotatestart",(t=>this._rotate_start(t))),this.hammer.on("rotate",(t=>this._rotate(t))),this.hammer.on("rotateend",(t=>this._rotate_end(t)))}register_tool(t){const e=t.model.event_type;null!=e&&((0,u.isString)(e)?this._register_tool(t,e):e.forEach(((e,s)=>this._register_tool(t,e,s<1))))}_register_tool(t,e,s=!0){const n=t,{id:i}=n.model,r=t=>e=>{e.id==i&&t(e.e)},a=t=>e=>{t(e.e)};switch(e){case"pan":null!=n._pan_start&&n.connect(this.pan_start,r(n._pan_start.bind(n))),null!=n._pan&&n.connect(this.pan,r(n._pan.bind(n))),null!=n._pan_end&&n.connect(this.pan_end,r(n._pan_end.bind(n)));break;case"pinch":null!=n._pinch_start&&n.connect(this.pinch_start,r(n._pinch_start.bind(n))),null!=n._pinch&&n.connect(this.pinch,r(n._pinch.bind(n))),null!=n._pinch_end&&n.connect(this.pinch_end,r(n._pinch_end.bind(n)));break;case"rotate":null!=n._rotate_start&&n.connect(this.rotate_start,r(n._rotate_start.bind(n))),null!=n._rotate&&n.connect(this.rotate,r(n._rotate.bind(n))),null!=n._rotate_end&&n.connect(this.rotate_end,r(n._rotate_end.bind(n)));break;case"move":null!=n._move_enter&&n.connect(this.move_enter,r(n._move_enter.bind(n))),null!=n._move&&n.connect(this.move,r(n._move.bind(n))),null!=n._move_exit&&n.connect(this.move_exit,r(n._move_exit.bind(n)));break;case"tap":null!=n._tap&&n.connect(this.tap,r(n._tap.bind(n))),null!=n._doubletap&&n.connect(this.doubletap,r(n._doubletap.bind(n)));break;case"press":null!=n._press&&n.connect(this.press,r(n._press.bind(n))),null!=n._pressup&&n.connect(this.pressup,r(n._pressup.bind(n)));break;case"scroll":null!=n._scroll&&n.connect(this.scroll,r(n._scroll.bind(n)));break;default:throw new Error(`unsupported event_type: ${e}`)}s&&(null!=n._keydown&&n.connect(this.keydown,a(n._keydown.bind(n))),null!=n._keyup&&n.connect(this.keyup,a(n._keyup.bind(n))),v.is_mobile&&null!=n._scroll&&"pinch"==e&&(h.logger.debug("Registering scroll on touch screen"),n.connect(this.scroll,r(n._scroll.bind(n)))))}_hit_test_renderers(t,e,s){var n;const i=t.get_renderer_views();for(const t of(0,p.reversed)(i))if(null===(n=t.interactive_hit)||void 0===n?void 0:n.call(t,e,s))return t;return null}set_cursor(t="default"){this.hit_area.style.cursor=t}_hit_test_frame(t,e,s){return t.frame.bbox.contains(e,s)}_hit_test_canvas(t,e,s){return t.layout.bbox.contains(e,s)}_hit_test_plot(t,e){for(const s of this.canvas_view.plot_views)if(s.layout.bbox.relative().contains(t,e))return s;return null}_trigger(t,e,s){var n;const{sx:i,sy:r}=e,a=this._hit_test_plot(i,r),_=t=>{const[s,n]=[i,r];return Object.assign(Object.assign({},e),{sx:s,sy:n})};if("panstart"==e.type||"pan"==e.type||"panend"==e.type){let n;if("panstart"==e.type&&null!=a?(this._curr_pan={plot_view:a},n=a):"pan"==e.type&&null!=this._curr_pan?n=this._curr_pan.plot_view:"panend"==e.type&&null!=this._curr_pan?(n=this._curr_pan.plot_view,this._curr_pan=null):n=null,null!=n){const e=_();this.__trigger(n,t,e,s)}}else if("pinchstart"==e.type||"pinch"==e.type||"pinchend"==e.type){let n;if("pinchstart"==e.type&&null!=a?(this._curr_pinch={plot_view:a},n=a):"pinch"==e.type&&null!=this._curr_pinch?n=this._curr_pinch.plot_view:"pinchend"==e.type&&null!=this._curr_pinch?(n=this._curr_pinch.plot_view,this._curr_pinch=null):n=null,null!=n){const e=_();this.__trigger(n,t,e,s)}}else if("rotatestart"==e.type||"rotate"==e.type||"rotateend"==e.type){let n;if("rotatestart"==e.type&&null!=a?(this._curr_rotate={plot_view:a},n=a):"rotate"==e.type&&null!=this._curr_rotate?n=this._curr_rotate.plot_view:"rotateend"==e.type&&null!=this._curr_rotate?(n=this._curr_rotate.plot_view,this._curr_rotate=null):n=null,null!=n){const e=_();this.__trigger(n,t,e,s)}}else if("mouseenter"==e.type||"mousemove"==e.type||"mouseleave"==e.type){const h=null===(n=this._prev_move)||void 0===n?void 0:n.plot_view;if(null!=h&&("mouseleave"==e.type||h!=a)){const{sx:t,sy:e}=_();this.__trigger(h,this.move_exit,{type:"mouseleave",sx:t,sy:e,shiftKey:!1,ctrlKey:!1},s)}if(null!=a&&("mouseenter"==e.type||h!=a)){const{sx:t,sy:e}=_();this.__trigger(a,this.move_enter,{type:"mouseenter",sx:t,sy:e,shiftKey:!1,ctrlKey:!1},s)}if(null!=a&&"mousemove"==e.type){const e=_();this.__trigger(a,t,e,s)}this._prev_move={sx:i,sy:r,plot_view:a}}else if(null!=a){const e=_();this.__trigger(a,t,e,s)}}__trigger(t,e,s,n){var i,r,a;const _=t.model.toolbar.gestures,h=e.name.split(":")[0],o=this._hit_test_renderers(t,s.sx,s.sy),l=this._hit_test_canvas(t,s.sx,s.sy);switch(h){case"move":{const n=_.move.active;null!=n&&this.trigger(e,s,n.id);const r=t.model.toolbar.inspectors.filter((t=>t.active));let a="default";null!=o?(a=null!==(i=o.cursor(s.sx,s.sy))&&void 0!==i?i:a,(0,p.is_empty)(r)||(e=this.move_exit)):this._hit_test_frame(t,s.sx,s.sy)&&((0,p.is_empty)(r)||(a="crosshair")),this.set_cursor(a),t.set_toolbar_visibility(l),r.map((t=>this.trigger(e,s,t.id)));break}case"tap":{const{target:i}=n;if(null!=i&&i!=this.hit_area)return;if(null===(r=null==o?void 0:o.on_hit)||void 0===r||r.call(o,s.sx,s.sy),this._hit_test_frame(t,s.sx,s.sy)){const t=_.tap.active;null!=t&&this.trigger(e,s,t.id)}break}case"doubletap":if(this._hit_test_frame(t,s.sx,s.sy)){const t=null!==(a=_.doubletap.active)&&void 0!==a?a:_.tap.active;null!=t&&this.trigger(e,s,t.id)}break;case"scroll":{const t=_[v.is_mobile?"pinch":"scroll"].active;null!=t&&(n.preventDefault(),n.stopPropagation(),this.trigger(e,s,t.id));break}case"pan":{const t=_.pan.active;null!=t&&(n.preventDefault(),this.trigger(e,s,t.id));break}default:{const t=_[h].active;null!=t&&this.trigger(e,s,t.id)}}this._trigger_bokeh_event(t,s)}trigger(t,e,s=null){t.emit({id:s,e})}_trigger_bokeh_event(t,e){const s=(()=>{const{sx:s,sy:n}=e,i=t.frame.x_scale.invert(s),r=t.frame.y_scale.invert(n);switch(e.type){case"wheel":return new l.MouseWheel(s,n,i,r,e.delta);case"mousemove":return new l.MouseMove(s,n,i,r);case"mouseenter":return new l.MouseEnter(s,n,i,r);case"mouseleave":return new l.MouseLeave(s,n,i,r);case"tap":return new l.Tap(s,n,i,r);case"doubletap":return new l.DoubleTap(s,n,i,r);case"press":return new l.Press(s,n,i,r);case"pressup":return new l.PressUp(s,n,i,r);case"pan":return new l.Pan(s,n,i,r,e.deltaX,e.deltaY);case"panstart":return new l.PanStart(s,n,i,r);case"panend":return new l.PanEnd(s,n,i,r);case"pinch":return new l.Pinch(s,n,i,r,e.scale);case"pinchstart":return new l.PinchStart(s,n,i,r);case"pinchend":return new l.PinchEnd(s,n,i,r);case"rotate":return new l.Rotate(s,n,i,r,e.rotation);case"rotatestart":return new l.RotateStart(s,n,i,r);case"rotateend":return new l.RotateEnd(s,n,i,r);default:return}})();null!=s&&t.model.trigger_event(s)}_get_sxy(t){const{pageX:e,pageY:s}=function(t){return"undefined"!=typeof TouchEvent&&t instanceof TouchEvent}(t)?(0!=t.touches.length?t.touches:t.changedTouches)[0]:t,{left:n,top:i}=(0,o.offset)(this.hit_area);return{sx:e-n,sy:s-i}}_pan_event(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t.srcEvent)),{deltaX:t.deltaX,deltaY:t.deltaY,shiftKey:t.srcEvent.shiftKey,ctrlKey:t.srcEvent.ctrlKey})}_pinch_event(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t.srcEvent)),{scale:t.scale,shiftKey:t.srcEvent.shiftKey,ctrlKey:t.srcEvent.ctrlKey})}_rotate_event(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t.srcEvent)),{rotation:t.rotation,shiftKey:t.srcEvent.shiftKey,ctrlKey:t.srcEvent.ctrlKey})}_tap_event(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t.srcEvent)),{shiftKey:t.srcEvent.shiftKey,ctrlKey:t.srcEvent.ctrlKey})}_move_event(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t)),{shiftKey:t.shiftKey,ctrlKey:t.ctrlKey})}_scroll_event(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t)),{delta:(0,c.getDeltaY)(t),shiftKey:t.shiftKey,ctrlKey:t.ctrlKey})}_key_event(t){return{type:t.type,keyCode:t.keyCode}}_pan_start(t){const e=this._pan_event(t);e.sx-=t.deltaX,e.sy-=t.deltaY,this._trigger(this.pan_start,e,t.srcEvent)}_pan(t){this._trigger(this.pan,this._pan_event(t),t.srcEvent)}_pan_end(t){this._trigger(this.pan_end,this._pan_event(t),t.srcEvent)}_pinch_start(t){this._trigger(this.pinch_start,this._pinch_event(t),t.srcEvent)}_pinch(t){this._trigger(this.pinch,this._pinch_event(t),t.srcEvent)}_pinch_end(t){this._trigger(this.pinch_end,this._pinch_event(t),t.srcEvent)}_rotate_start(t){this._trigger(this.rotate_start,this._rotate_event(t),t.srcEvent)}_rotate(t){this._trigger(this.rotate,this._rotate_event(t),t.srcEvent)}_rotate_end(t){this._trigger(this.rotate_end,this._rotate_event(t),t.srcEvent)}_tap(t){this._trigger(this.tap,this._tap_event(t),t.srcEvent)}_doubletap(t){this._trigger(this.doubletap,this._tap_event(t),t.srcEvent)}_press(t){this._trigger(this.press,this._tap_event(t),t.srcEvent)}_pressup(t){this._trigger(this.pressup,this._tap_event(t),t.srcEvent)}_mouse_enter(t){this._trigger(this.move_enter,this._move_event(t),t)}_mouse_move(t){this._trigger(this.move,this._move_event(t),t)}_mouse_exit(t){this._trigger(this.move_exit,this._move_event(t),t)}_mouse_wheel(t){this._trigger(this.scroll,this._scroll_event(t),t)}_context_menu(t){!this.menu.is_open&&this.menu.can_open&&t.preventDefault();const{sx:e,sy:s}=this._get_sxy(t);this.menu.toggle({left:e,top:s})}_key_down(t){this.trigger(this.keydown,this._key_event(t))}_key_up(t){this.trigger(this.keyup,this._key_event(t))}}s.UIEventBus=g,g.__name__="UIEventBus"},
function _(e,t,s,n,_){n();var a=this&&this.__decorate||function(e,t,s,n){var _,a=arguments.length,o=a<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,s):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)o=Reflect.decorate(e,t,s,n);else for(var r=e.length-1;r>=0;r--)(_=e[r])&&(o=(a<3?_(o):a>3?_(t,s,o):_(t,s))||o);return a>3&&o&&Object.defineProperty(t,s,o),o};function o(e){return function(t){t.prototype.event_name=e}}class r{to_json(){const{event_name:e}=this;return{event_name:e,event_values:this._to_json()}}}s.BokehEvent=r,r.__name__="BokehEvent";class c extends r{constructor(){super(...arguments),this.origin=null}_to_json(){return{model:this.origin}}}s.ModelEvent=c,c.__name__="ModelEvent";let l=class extends r{_to_json(){return{}}};s.DocumentReady=l,l.__name__="DocumentReady",s.DocumentReady=l=a([o("document_ready")],l);let i=class extends c{};s.ButtonClick=i,i.__name__="ButtonClick",s.ButtonClick=i=a([o("button_click")],i);let u=class extends c{constructor(e){super(),this.item=e}_to_json(){const{item:e}=this;return Object.assign(Object.assign({},super._to_json()),{item:e})}};s.MenuItemClick=u,u.__name__="MenuItemClick",s.MenuItemClick=u=a([o("menu_item_click")],u);class d extends c{}s.UIEvent=d,d.__name__="UIEvent";let m=class extends d{};s.LODStart=m,m.__name__="LODStart",s.LODStart=m=a([o("lodstart")],m);let h=class extends d{};s.LODEnd=h,h.__name__="LODEnd",s.LODEnd=h=a([o("lodend")],h);let p=class extends d{constructor(e,t,s,n){super(),this.x0=e,this.x1=t,this.y0=s,this.y1=n}_to_json(){const{x0:e,x1:t,y0:s,y1:n}=this;return Object.assign(Object.assign({},super._to_json()),{x0:e,x1:t,y0:s,y1:n})}};s.RangesUpdate=p,p.__name__="RangesUpdate",s.RangesUpdate=p=a([o("rangesupdate")],p);let x=class extends d{constructor(e,t){super(),this.geometry=e,this.final=t}_to_json(){const{geometry:e,final:t}=this;return Object.assign(Object.assign({},super._to_json()),{geometry:e,final:t})}};s.SelectionGeometry=x,x.__name__="SelectionGeometry",s.SelectionGeometry=x=a([o("selectiongeometry")],x);let j=class extends d{};s.Reset=j,j.__name__="Reset",s.Reset=j=a([o("reset")],j);class y extends d{constructor(e,t,s,n){super(),this.sx=e,this.sy=t,this.x=s,this.y=n}_to_json(){const{sx:e,sy:t,x:s,y:n}=this;return Object.assign(Object.assign({},super._to_json()),{sx:e,sy:t,x:s,y:n})}}s.PointEvent=y,y.__name__="PointEvent";let g=class extends y{constructor(e,t,s,n,_,a){super(e,t,s,n),this.delta_x=_,this.delta_y=a}_to_json(){const{delta_x:e,delta_y:t}=this;return Object.assign(Object.assign({},super._to_json()),{delta_x:e,delta_y:t})}};s.Pan=g,g.__name__="Pan",s.Pan=g=a([o("pan")],g);let P=class extends y{constructor(e,t,s,n,_){super(e,t,s,n),this.scale=_}_to_json(){const{scale:e}=this;return Object.assign(Object.assign({},super._to_json()),{scale:e})}};s.Pinch=P,P.__name__="Pinch",s.Pinch=P=a([o("pinch")],P);let O=class extends y{constructor(e,t,s,n,_){super(e,t,s,n),this.rotation=_}_to_json(){const{rotation:e}=this;return Object.assign(Object.assign({},super._to_json()),{rotation:e})}};s.Rotate=O,O.__name__="Rotate",s.Rotate=O=a([o("rotate")],O);let b=class extends y{constructor(e,t,s,n,_){super(e,t,s,n),this.delta=_}_to_json(){const{delta:e}=this;return Object.assign(Object.assign({},super._to_json()),{delta:e})}};s.MouseWheel=b,b.__name__="MouseWheel",s.MouseWheel=b=a([o("wheel")],b);let v=class extends y{};s.MouseMove=v,v.__name__="MouseMove",s.MouseMove=v=a([o("mousemove")],v);let E=class extends y{};s.MouseEnter=E,E.__name__="MouseEnter",s.MouseEnter=E=a([o("mouseenter")],E);let R=class extends y{};s.MouseLeave=R,R.__name__="MouseLeave",s.MouseLeave=R=a([o("mouseleave")],R);let M=class extends y{};s.Tap=M,M.__name__="Tap",s.Tap=M=a([o("tap")],M);let f=class extends y{};s.DoubleTap=f,f.__name__="DoubleTap",s.DoubleTap=f=a([o("doubletap")],f);let S=class extends y{};s.Press=S,S.__name__="Press",s.Press=S=a([o("press")],S);let D=class extends y{};s.PressUp=D,D.__name__="PressUp",s.PressUp=D=a([o("pressup")],D);let k=class extends y{};s.PanStart=k,k.__name__="PanStart",s.PanStart=k=a([o("panstart")],k);let L=class extends y{};s.PanEnd=L,L.__name__="PanEnd",s.PanEnd=L=a([o("panend")],L);let U=class extends y{};s.PinchStart=U,U.__name__="PinchStart",s.PinchStart=U=a([o("pinchstart")],U);let C=class extends y{};s.PinchEnd=C,C.__name__="PinchEnd",s.PinchEnd=C=a([o("pinchend")],C);let T=class extends y{};s.RotateStart=T,T.__name__="RotateStart",s.RotateStart=T=a([o("rotatestart")],T);let B=class extends y{};s.RotateEnd=B,B.__name__="RotateEnd",s.RotateEnd=B=a([o("rotateend")],B)},
function _(t,e,n,l,o){
/*!
     * jQuery Mousewheel 3.1.13
     *
     * Copyright jQuery Foundation and other contributors
     * Released under the MIT license
     * http://jquery.org/license
     */
function u(t){const e=getComputedStyle(t).fontSize;return null!=e?parseInt(e,10):null}l(),n.getDeltaY=function(t){let e=-t.deltaY;if(t.target instanceof HTMLElement)switch(t.deltaMode){case t.DOM_DELTA_LINE:e*=(n=t.target,null!==(a=null!==(o=u(null!==(l=n.offsetParent)&&void 0!==l?l:document.body))&&void 0!==o?o:u(n))&&void 0!==a?a:16);break;case t.DOM_DELTA_PAGE:e*=function(t){return t.clientHeight}(t.target)}var n,l,o,a;return e}},
function _(m,o,n,r,a){r(),a("Expression",m(254).Expression),a("CustomJSExpr",m(255).CustomJSExpr),a("Stack",m(256).Stack),a("CumSum",m(257).CumSum),a("ScalarExpression",m(254).ScalarExpression),a("Minimum",m(258).Minimum),a("Maximum",m(259).Maximum);var s=m(260);a("XComponent",s.XComponent),a("YComponent",s.YComponent),a("PolarTransform",m(261).PolarTransform)},
function _(e,t,s,i,r){i();const n=e(53);class _ extends n.Model{constructor(e){super(e)}initialize(){super.initialize(),this._result=new Map}v_compute(e){let t=this._result.get(e);return(void 0===t||e.changed_for(this))&&(t=this._v_compute(e),this._result.set(e,t)),t}}s.Expression=_,_.__name__="Expression";class o extends n.Model{constructor(e){super(e)}initialize(){super.initialize(),this._result=new Map}compute(e){let t=this._result.get(e);return(void 0===t||e.changed_for(this))&&(t=this._compute(e),this._result.set(e,t)),t}}s.ScalarExpression=o,o.__name__="ScalarExpression"},
function _(e,s,t,n,r){var a;n();const o=e(14),c=e(254),i=e(24),u=e(9),l=e(13),h=e(34),g=e(8);class p extends c.Expression{constructor(e){super(e)}connect_signals(){super.connect_signals();for(const e of(0,l.values)(this.args))e instanceof o.HasProps&&e.change.connect((()=>{this._result.clear(),this.change.emit()}))}get names(){return(0,l.keys)(this.args)}get values(){return(0,l.values)(this.args)}get func(){const e=(0,h.use_strict)(this.code);return new i.GeneratorFunction(...this.names,e)}_v_compute(e){const s=this.func.apply(e,this.values);let t=s.next();if(t.done&&void 0!==t.value){const{value:s}=t;return(0,g.isArray)(s)||(0,g.isTypedArray)(s)?s:(0,g.isIterable)(s)?[...s]:(0,u.repeat)(s,e.length)}{const e=[];do{e.push(t.value),t=s.next()}while(!t.done);return e}}}t.CustomJSExpr=p,a=p,p.__name__="CustomJSExpr",a.define((({Unknown:e,String:s,Dict:t})=>({args:[t(e),{}],code:[s,""]})))},
function _(t,n,e,o,r){var s;o();const a=t(254);class c extends a.Expression{constructor(t){super(t)}_v_compute(t){var n;const e=null!==(n=t.get_length())&&void 0!==n?n:0,o=new Float64Array(e);for(const n of this.fields){const r=t.data[n];if(null!=r){const t=Math.min(e,r.length);for(let n=0;n<t;n++)o[n]+=r[n]}}return o}}e.Stack=c,s=c,c.__name__="Stack",s.define((({String:t,Array:n})=>({fields:[n(t),[]]})))},
function _(e,n,t,o,r){var i;o();const l=e(254);class u extends l.Expression{constructor(e){super(e)}_v_compute(e){var n;const t=new Float64Array(null!==(n=e.get_length())&&void 0!==n?n:0),o=e.data[this.field],r=this.include_zero?1:0;t[0]=this.include_zero?0:o[0];for(let e=1;e<t.length;e++)t[e]=t[e-1]+o[e-r];return t}}t.CumSum=u,i=u,u.__name__="CumSum",i.define((({Boolean:e,String:n})=>({field:[n],include_zero:[e,!1]})))},
function _(i,n,l,t,e){var a;t();const u=i(254),r=i(9);class s extends u.ScalarExpression{constructor(i){super(i)}_compute(i){var n,l;const t=null!==(n=i.data[this.field])&&void 0!==n?n:[];return Math.min(null!==(l=this.initial)&&void 0!==l?l:1/0,(0,r.min)(t))}}l.Minimum=s,a=s,s.__name__="Minimum",a.define((({Number:i,String:n,Nullable:l})=>({field:[n],initial:[l(i),null]})))},
function _(i,a,n,l,t){var e;l();const u=i(254),r=i(9);class s extends u.ScalarExpression{constructor(i){super(i)}_compute(i){var a,n;const l=null!==(a=i.data[this.field])&&void 0!==a?a:[];return Math.max(null!==(n=this.initial)&&void 0!==n?n:-1/0,(0,r.max)(l))}}n.Maximum=s,e=s,s.__name__="Maximum",e.define((({Number:i,String:a,Nullable:n})=>({field:[a],initial:[n(i),null]})))},
function _(n,e,t,o,r){var s;o();const _=n(254);class m extends _.Expression{constructor(n){super(n)}get x(){return new c({transform:this})}get y(){return new u({transform:this})}}t.CoordinateTransform=m,m.__name__="CoordinateTransform";class a extends _.Expression{constructor(n){super(n)}}t.XYComponent=a,s=a,a.__name__="XYComponent",s.define((({Ref:n})=>({transform:[n(m)]})));class c extends a{constructor(n){super(n)}_v_compute(n){return this.transform.v_compute(n).x}}t.XComponent=c,c.__name__="XComponent";class u extends a{constructor(n){super(n)}_v_compute(n){return this.transform.v_compute(n).y}}t.YComponent=u,u.__name__="YComponent"},
function _(r,t,n,e,o){e();const i=r(1);var a;const s=r(260),c=r(20),l=(0,i.__importStar)(r(18));class d extends s.CoordinateTransform{constructor(r){super(r)}_v_compute(r){const t=this.properties.radius.uniform(r),n=this.properties.angle.uniform(r),e="anticlock"==this.direction?-1:1,o=Math.min(t.length,n.length),i=new Float64Array(o),a=new Float64Array(o);for(let r=0;r<o;r++){const o=t.get(r),s=n.get(r)*e;i[r]=o*Math.cos(s),a[r]=o*Math.sin(s)}return{x:i,y:a}}}n.PolarTransform=d,a=d,d.__name__="PolarTransform",a.define((({})=>({radius:[l.DistanceSpec,{field:"radius"}],angle:[l.AngleSpec,{field:"angle"}],direction:[c.Direction,"anticlock"]})))},
function _(e,t,l,r,i){r(),i("BooleanFilter",e(263).BooleanFilter),i("CustomJSFilter",e(264).CustomJSFilter),i("Filter",e(191).Filter),i("GroupFilter",e(265).GroupFilter),i("IndexFilter",e(266).IndexFilter)},
function _(e,n,l,o,s){var t;o();const a=e(191),r=e(24);class c extends a.Filter{constructor(e){super(e)}compute_indices(e){const n=e.length,{booleans:l}=this;return null==l?r.Indices.all_set(n):r.Indices.from_booleans(n,l)}}l.BooleanFilter=c,t=c,c.__name__="BooleanFilter",t.define((({Boolean:e,Array:n,Nullable:l})=>({booleans:[l(n(e)),null]})))},
function _(e,n,r,s,t){var i;s();const o=e(191),c=e(24),u=e(13),a=e(8),l=e(34);class f extends o.Filter{constructor(e){super(e)}get names(){return(0,u.keys)(this.args)}get values(){return(0,u.values)(this.args)}get func(){const e=(0,l.use_strict)(this.code);return new Function(...this.names,"source",e)}compute_indices(e){const n=e.length,r=this.func(...this.values,e);if(null==r)return c.Indices.all_set(n);if((0,a.isArrayOf)(r,a.isInteger))return c.Indices.from_indices(n,r);if((0,a.isArrayOf)(r,a.isBoolean))return c.Indices.from_booleans(n,r);throw new Error(`expect an array of integers or booleans, or null, got ${r}`)}}r.CustomJSFilter=f,i=f,f.__name__="CustomJSFilter",i.define((({Unknown:e,String:n,Dict:r})=>({args:[r(e),{}],code:[n,""]})))},
function _(n,e,t,o,r){var u;o();const s=n(191),c=n(24),i=n(19);class l extends s.Filter{constructor(n){super(n)}compute_indices(n){const e=n.get_column(this.column_name);if(null==e)return i.logger.warn(`${this}: groupby column '${this.column_name}' not found in the data source`),new c.Indices(n.length,1);{const t=new c.Indices(n.length);for(let n=0;n<t.size;n++)e[n]===this.group&&t.set(n);return t}}}t.GroupFilter=l,u=l,l.__name__="GroupFilter",u.define((({String:n})=>({column_name:[n],group:[n]})))},
function _(e,n,i,s,t){var l;s();const c=e(191),r=e(24);class d extends c.Filter{constructor(e){super(e)}compute_indices(e){const n=e.length,{indices:i}=this;return null==i?r.Indices.all_set(n):r.Indices.from_indices(n,i)}}i.IndexFilter=d,l=d,d.__name__="IndexFilter",l.define((({Int:e,Array:n,Nullable:i})=>({indices:[i(n(e)),null]})))},
function _(e,a,l,i,t){i(),t("AnnularWedge",e(268).AnnularWedge),t("Annulus",e(269).Annulus),t("Arc",e(270).Arc),t("Bezier",e(271).Bezier),t("Circle",e(272).Circle),t("Ellipse",e(273).Ellipse),t("EllipseOval",e(274).EllipseOval),t("Glyph",e(179).Glyph),t("HArea",e(187).HArea),t("HBar",e(276).HBar),t("HexTile",e(278).HexTile),t("Image",e(279).Image),t("ImageRGBA",e(281).ImageRGBA),t("ImageURL",e(282).ImageURL),t("Line",e(177).Line),t("MultiLine",e(283).MultiLine),t("MultiPolygons",e(284).MultiPolygons),t("Oval",e(285).Oval),t("Patch",e(186).Patch),t("Patches",e(286).Patches),t("Quad",e(287).Quad),t("Quadratic",e(288).Quadratic),t("Ray",e(289).Ray),t("Rect",e(290).Rect),t("Scatter",e(291).Scatter),t("Segment",e(294).Segment),t("Spline",e(295).Spline),t("Step",e(297).Step),t("Text",e(298).Text),t("VArea",e(189).VArea),t("VBar",e(299).VBar),t("Wedge",e(300).Wedge)},
function _(e,s,t,i,r){i();const n=e(1);var a;const _=e(178),o=e(184),d=e(48),u=e(24),h=e(20),c=(0,n.__importStar)(e(18)),l=e(10),g=e(72),p=e(12);class x extends _.XYGlyphView{_map_data(){"data"==this.model.properties.inner_radius.units?this.sinner_radius=this.sdist(this.renderer.xscale,this._x,this.inner_radius):this.sinner_radius=(0,u.to_screen)(this.inner_radius),"data"==this.model.properties.outer_radius.units?this.souter_radius=this.sdist(this.renderer.xscale,this._x,this.outer_radius):this.souter_radius=(0,u.to_screen)(this.outer_radius),this.max_souter_radius=(0,p.max)(this.souter_radius)}_render(e,s,t){const{sx:i,sy:r,start_angle:n,end_angle:a,sinner_radius:_,souter_radius:o}=null!=t?t:this,d="anticlock"==this.model.direction;for(const t of s){const s=i[t],u=r[t],h=_[t],c=o[t],l=n.get(t),g=a.get(t);if(!isFinite(s+u+h+c+l+g))continue;const p=g-l;e.translate(s,u),e.rotate(l),e.beginPath(),e.moveTo(c,0),e.arc(0,0,c,0,p,d),e.rotate(p),e.lineTo(h,0),e.arc(0,0,h,0,-p,!d),e.closePath(),e.rotate(-p-l),e.translate(-s,-u),this.visuals.fill.apply(e,t),this.visuals.hatch.apply(e,t),this.visuals.line.apply(e,t)}}_hit_point(e){const{sx:s,sy:t}=e,i=this.renderer.xscale.invert(s),r=this.renderer.yscale.invert(t),n=s-this.max_souter_radius,a=s+this.max_souter_radius,[_,o]=this.renderer.xscale.r_invert(n,a),d=t-this.max_souter_radius,u=t+this.max_souter_radius,[h,c]=this.renderer.yscale.r_invert(d,u),p=[];for(const e of this.index.indices({x0:_,x1:o,y0:h,y1:c})){const s=this.souter_radius[e]**2,t=this.sinner_radius[e]**2,[n,a]=this.renderer.xscale.r_compute(i,this._x[e]),[_,o]=this.renderer.yscale.r_compute(r,this._y[e]),d=(n-a)**2+(_-o)**2;d<=s&&d>=t&&p.push(e)}const x="anticlock"==this.model.direction,m=[];for(const e of p){const i=Math.atan2(t-this.sy[e],s-this.sx[e]);(0,l.angle_between)(-i,-this.start_angle.get(e),-this.end_angle.get(e),x)&&m.push(e)}return new g.Selection({indices:m})}draw_legend_for_index(e,s,t){(0,o.generic_area_vector_legend)(this.visuals,e,s,t)}scenterxy(e){const s=(this.sinner_radius[e]+this.souter_radius[e])/2,t=(this.start_angle.get(e)+this.end_angle.get(e))/2;return[this.sx[e]+s*Math.cos(t),this.sy[e]+s*Math.sin(t)]}}t.AnnularWedgeView=x,x.__name__="AnnularWedgeView";class m extends _.XYGlyph{constructor(e){super(e)}}t.AnnularWedge=m,a=m,m.__name__="AnnularWedge",a.prototype.default_view=x,a.mixins([d.LineVector,d.FillVector,d.HatchVector]),a.define((({})=>({direction:[h.Direction,"anticlock"],inner_radius:[c.DistanceSpec,{field:"inner_radius"}],outer_radius:[c.DistanceSpec,{field:"outer_radius"}],start_angle:[c.AngleSpec,{field:"start_angle"}],end_angle:[c.AngleSpec,{field:"end_angle"}]})))},
function _(s,e,i,r,t){r();const n=s(1);var a;const u=s(178),o=s(24),_=s(48),d=(0,n.__importStar)(s(18)),h=s(27),c=s(72);class l extends u.XYGlyphView{_map_data(){"data"==this.model.properties.inner_radius.units?this.sinner_radius=this.sdist(this.renderer.xscale,this._x,this.inner_radius):this.sinner_radius=(0,o.to_screen)(this.inner_radius),"data"==this.model.properties.outer_radius.units?this.souter_radius=this.sdist(this.renderer.xscale,this._x,this.outer_radius):this.souter_radius=(0,o.to_screen)(this.outer_radius)}_render(s,e,i){const{sx:r,sy:t,sinner_radius:n,souter_radius:a}=null!=i?i:this;for(const i of e){const e=r[i],u=t[i],o=n[i],_=a[i];if(isFinite(e+u+o+_)){if(s.beginPath(),h.is_ie)for(const i of[!1,!0])s.moveTo(e,u),s.arc(e,u,o,0,Math.PI,i),s.moveTo(e+_,u),s.arc(e,u,_,Math.PI,0,!i);else s.arc(e,u,o,0,2*Math.PI,!0),s.moveTo(e+_,u),s.arc(e,u,_,2*Math.PI,0,!1);this.visuals.fill.apply(s,i),this.visuals.hatch.apply(s,i),this.visuals.line.apply(s,i)}}}_hit_point(s){const{sx:e,sy:i}=s,r=this.renderer.xscale.invert(e),t=this.renderer.yscale.invert(i);let n,a,u,o;if("data"==this.model.properties.outer_radius.units)n=r-this.max_outer_radius,u=r+this.max_outer_radius,a=t-this.max_outer_radius,o=t+this.max_outer_radius;else{const s=e-this.max_outer_radius,r=e+this.max_outer_radius;[n,u]=this.renderer.xscale.r_invert(s,r);const t=i-this.max_outer_radius,_=i+this.max_outer_radius;[a,o]=this.renderer.yscale.r_invert(t,_)}const _=[];for(const s of this.index.indices({x0:n,x1:u,y0:a,y1:o})){const e=this.souter_radius[s]**2,i=this.sinner_radius[s]**2,[n,a]=this.renderer.xscale.r_compute(r,this._x[s]),[u,o]=this.renderer.yscale.r_compute(t,this._y[s]),d=(n-a)**2+(u-o)**2;d<=e&&d>=i&&_.push(s)}return new c.Selection({indices:_})}draw_legend_for_index(s,{x0:e,y0:i,x1:r,y1:t},n){const a=n+1,u=new Array(a);u[n]=(e+r)/2;const o=new Array(a);o[n]=(i+t)/2;const _=.5*Math.min(Math.abs(r-e),Math.abs(t-i)),d=new Array(a);d[n]=.4*_;const h=new Array(a);h[n]=.8*_,this._render(s,[n],{sx:u,sy:o,sinner_radius:d,souter_radius:h})}}i.AnnulusView=l,l.__name__="AnnulusView";class x extends u.XYGlyph{constructor(s){super(s)}}i.Annulus=x,a=x,x.__name__="Annulus",a.prototype.default_view=l,a.mixins([_.LineVector,_.FillVector,_.HatchVector]),a.define((({})=>({inner_radius:[d.DistanceSpec,{field:"inner_radius"}],outer_radius:[d.DistanceSpec,{field:"outer_radius"}]})))},
function _(e,i,s,t,n){t();const r=e(1);var a;const c=e(178),d=e(184),l=e(48),_=e(24),o=e(20),u=(0,r.__importStar)(e(18));class h extends c.XYGlyphView{_map_data(){"data"==this.model.properties.radius.units?this.sradius=this.sdist(this.renderer.xscale,this._x,this.radius):this.sradius=(0,_.to_screen)(this.radius)}_render(e,i,s){if(this.visuals.line.doit){const{sx:t,sy:n,sradius:r,start_angle:a,end_angle:c}=null!=s?s:this,d="anticlock"==this.model.direction;for(const s of i){const i=t[s],l=n[s],_=r[s],o=a.get(s),u=c.get(s);isFinite(i+l+_+o+u)&&(e.beginPath(),e.arc(i,l,_,o,u,d),this.visuals.line.set_vectorize(e,s),e.stroke())}}}draw_legend_for_index(e,i,s){(0,d.generic_line_vector_legend)(this.visuals,e,i,s)}}s.ArcView=h,h.__name__="ArcView";class g extends c.XYGlyph{constructor(e){super(e)}}s.Arc=g,a=g,g.__name__="Arc",a.prototype.default_view=h,a.mixins(l.LineVector),a.define((({})=>({direction:[o.Direction,"anticlock"],radius:[u.DistanceSpec,{field:"radius"}],start_angle:[u.AngleSpec,{field:"start_angle"}],end_angle:[u.AngleSpec,{field:"end_angle"}]})))},
function _(e,t,i,n,s){n();const o=e(1);var c;const r=e(48),a=e(179),_=e(184),d=e(78),l=(0,o.__importStar)(e(18));function x(e,t,i,n,s,o,c,r){const a=[],_=[[],[]];for(let _=0;_<=2;_++){let d,l,x;if(0===_?(l=6*e-12*i+6*s,d=-3*e+9*i-9*s+3*c,x=3*i-3*e):(l=6*t-12*n+6*o,d=-3*t+9*n-9*o+3*r,x=3*n-3*t),Math.abs(d)<1e-12){if(Math.abs(l)<1e-12)continue;const e=-x/l;0<e&&e<1&&a.push(e);continue}const y=l*l-4*x*d,h=Math.sqrt(y);if(y<0)continue;const p=(-l+h)/(2*d);0<p&&p<1&&a.push(p);const f=(-l-h)/(2*d);0<f&&f<1&&a.push(f)}let d=a.length;const l=d;for(;d--;){const l=a[d],x=1-l,y=x*x*x*e+3*x*x*l*i+3*x*l*l*s+l*l*l*c;_[0][d]=y;const h=x*x*x*t+3*x*x*l*n+3*x*l*l*o+l*l*l*r;_[1][d]=h}return _[0][l]=e,_[1][l]=t,_[0][l+1]=c,_[1][l+1]=r,[Math.min(..._[0]),Math.max(..._[1]),Math.max(..._[0]),Math.min(..._[1])]}class y extends a.GlyphView{_project_data(){d.inplace.project_xy(this._x0,this._y0),d.inplace.project_xy(this._x1,this._y1)}_index_data(e){const{data_size:t,_x0:i,_y0:n,_x1:s,_y1:o,_cx0:c,_cy0:r,_cx1:a,_cy1:_}=this;for(let d=0;d<t;d++){const t=i[d],l=n[d],y=s[d],h=o[d],p=c[d],f=r[d],u=a[d],m=_[d];if(isFinite(t+y+l+h+p+f+u+m)){const[i,n,s,o]=x(t,l,y,h,p,f,u,m);e.add_rect(i,n,s,o)}else e.add_empty()}}_render(e,t,i){if(this.visuals.line.doit){const{sx0:n,sy0:s,sx1:o,sy1:c,scx0:r,scy0:a,scx1:_,scy1:d}=null!=i?i:this;for(const i of t){const t=n[i],l=s[i],x=o[i],y=c[i],h=r[i],p=a[i],f=_[i],u=d[i];isFinite(t+l+x+y+h+p+f+u)&&(e.beginPath(),e.moveTo(t,l),e.bezierCurveTo(h,p,f,u,x,y),this.visuals.line.set_vectorize(e,i),e.stroke())}}}draw_legend_for_index(e,t,i){(0,_.generic_line_vector_legend)(this.visuals,e,t,i)}scenterxy(){throw new Error(`${this}.scenterxy() is not implemented`)}}i.BezierView=y,y.__name__="BezierView";class h extends a.Glyph{constructor(e){super(e)}}i.Bezier=h,c=h,h.__name__="Bezier",c.prototype.default_view=y,c.define((({})=>({x0:[l.XCoordinateSpec,{field:"x0"}],y0:[l.YCoordinateSpec,{field:"y0"}],x1:[l.XCoordinateSpec,{field:"x1"}],y1:[l.YCoordinateSpec,{field:"y1"}],cx0:[l.XCoordinateSpec,{field:"cx0"}],cy0:[l.YCoordinateSpec,{field:"cy0"}],cx1:[l.XCoordinateSpec,{field:"cx1"}],cy1:[l.YCoordinateSpec,{field:"cy1"}]}))),c.mixins(r.LineVector)},
function _(s,i,e,t,r){t();const a=s(1);var n;const h=s(178),d=s(48),l=s(24),_=s(20),c=(0,a.__importStar)(s(185)),u=(0,a.__importStar)(s(18)),o=s(9),x=s(12),m=s(72);class p extends h.XYGlyphView{async lazy_initialize(){await super.lazy_initialize();const{webgl:i}=this.renderer.plot_view.canvas_view;if(null!=i&&i.regl_wrapper.has_webgl){const{CircleGL:e}=await Promise.resolve().then((()=>(0,a.__importStar)(s(423))));this.glglyph=new e(i.regl_wrapper,this)}}get use_radius(){return!(this.radius.is_Scalar()&&isNaN(this.radius.value))}_set_data(s){super._set_data(s);const i=(()=>{if(this.use_radius)return 2*this.max_radius;{const{size:s}=this;return s.is_Scalar()?s.value:(0,x.max)(s.array)}})();this._configure("max_size",{value:i})}_map_data(){if(this.use_radius)if("data"==this.model.properties.radius.units)switch(this.model.radius_dimension){case"x":this.sradius=this.sdist(this.renderer.xscale,this._x,this.radius);break;case"y":this.sradius=this.sdist(this.renderer.yscale,this._y,this.radius);break;case"max":{const s=this.sdist(this.renderer.xscale,this._x,this.radius),i=this.sdist(this.renderer.yscale,this._y,this.radius);this.sradius=(0,x.map)(s,((s,e)=>Math.max(s,i[e])));break}case"min":{const s=this.sdist(this.renderer.xscale,this._x,this.radius),i=this.sdist(this.renderer.yscale,this._y,this.radius);this.sradius=(0,x.map)(s,((s,e)=>Math.min(s,i[e])));break}}else this.sradius=(0,l.to_screen)(this.radius);else{const s=l.ScreenArray.from(this.size);this.sradius=(0,x.map)(s,(s=>s/2))}}_mask_data(){const{frame:s}=this.renderer.plot_view,i=s.x_target,e=s.y_target;let t,r;return this.use_radius&&"data"==this.model.properties.radius.units?(t=i.map((s=>this.renderer.xscale.invert(s))).widen(this.max_radius),r=e.map((s=>this.renderer.yscale.invert(s))).widen(this.max_radius)):(t=i.widen(this.max_size).map((s=>this.renderer.xscale.invert(s))),r=e.widen(this.max_size).map((s=>this.renderer.yscale.invert(s)))),this.index.indices({x0:t.start,x1:t.end,y0:r.start,y1:r.end})}_render(s,i,e){const{sx:t,sy:r,sradius:a}=null!=e?e:this;for(const e of i){const i=t[e],n=r[e],h=a[e];isFinite(i+n+h)&&(s.beginPath(),s.arc(i,n,h,0,2*Math.PI,!1),this.visuals.fill.apply(s,e),this.visuals.hatch.apply(s,e),this.visuals.line.apply(s,e))}}_hit_point(s){const{sx:i,sy:e}=s,t=this.renderer.xscale.invert(i),r=this.renderer.yscale.invert(e),{hit_dilation:a}=this.model;let n,h,d,l;if(this.use_radius&&"data"==this.model.properties.radius.units)n=t-this.max_radius*a,h=t+this.max_radius*a,d=r-this.max_radius*a,l=r+this.max_radius*a;else{const s=i-this.max_size*a,t=i+this.max_size*a;[n,h]=this.renderer.xscale.r_invert(s,t);const r=e-this.max_size*a,_=e+this.max_size*a;[d,l]=this.renderer.yscale.r_invert(r,_)}const _=this.index.indices({x0:n,x1:h,y0:d,y1:l}),c=[];if(this.use_radius&&"data"==this.model.properties.radius.units)for(const s of _){const i=(this.sradius[s]*a)**2,[e,n]=this.renderer.xscale.r_compute(t,this._x[s]),[h,d]=this.renderer.yscale.r_compute(r,this._y[s]);(e-n)**2+(h-d)**2<=i&&c.push(s)}else for(const s of _){const t=(this.sradius[s]*a)**2;(this.sx[s]-i)**2+(this.sy[s]-e)**2<=t&&c.push(s)}return new m.Selection({indices:c})}_hit_span(s){const{sx:i,sy:e}=s,t=this.bounds();let r,a,n,h;if("h"==s.direction){let s,e;if(n=t.y0,h=t.y1,this.use_radius&&"data"==this.model.properties.radius.units)s=i-this.max_radius,e=i+this.max_radius,[r,a]=this.renderer.xscale.r_invert(s,e);else{const t=this.max_size/2;s=i-t,e=i+t,[r,a]=this.renderer.xscale.r_invert(s,e)}}else{let s,i;if(r=t.x0,a=t.x1,this.use_radius&&"data"==this.model.properties.radius.units)s=e-this.max_radius,i=e+this.max_radius,[n,h]=this.renderer.yscale.r_invert(s,i);else{const t=this.max_size/2;s=e-t,i=e+t,[n,h]=this.renderer.yscale.r_invert(s,i)}}const d=[...this.index.indices({x0:r,x1:a,y0:n,y1:h})];return new m.Selection({indices:d})}_hit_rect(s){const{sx0:i,sx1:e,sy0:t,sy1:r}=s,[a,n]=this.renderer.xscale.r_invert(i,e),[h,d]=this.renderer.yscale.r_invert(t,r),l=[...this.index.indices({x0:a,x1:n,y0:h,y1:d})];return new m.Selection({indices:l})}_hit_poly(s){const{sx:i,sy:e}=s,t=(0,o.range)(0,this.sx.length),r=[];for(let s=0,a=t.length;s<a;s++){const a=t[s];c.point_in_poly(this.sx[s],this.sy[s],i,e)&&r.push(a)}return new m.Selection({indices:r})}draw_legend_for_index(s,{x0:i,y0:e,x1:t,y1:r},a){const n=a+1,h=new Array(n);h[a]=(i+t)/2;const d=new Array(n);d[a]=(e+r)/2;const l=new Array(n);l[a]=.2*Math.min(Math.abs(t-i),Math.abs(r-e)),this._render(s,[a],{sx:h,sy:d,sradius:l})}}e.CircleView=p,p.__name__="CircleView";class y extends h.XYGlyph{constructor(s){super(s)}}e.Circle=y,n=y,y.__name__="Circle",n.prototype.default_view=p,n.mixins([d.LineVector,d.FillVector,d.HatchVector]),n.define((({Number:s})=>({angle:[u.AngleSpec,0],size:[u.ScreenSizeSpec,{value:4}],radius:[u.NullDistanceSpec,null],radius_dimension:[_.RadiusDimension,"x"],hit_dilation:[s,1]})))},
function _(e,l,s,i,_){var p;i();const t=e(274);class a extends t.EllipseOvalView{}s.EllipseView=a,a.__name__="EllipseView";class n extends t.EllipseOval{constructor(e){super(e)}}s.Ellipse=n,p=n,n.__name__="Ellipse",p.prototype.default_view=a},
function _(t,s,e,i,h){i();const n=t(1),r=t(275),a=(0,n.__importStar)(t(185)),l=t(24),_=t(72),o=(0,n.__importStar)(t(18));class d extends r.CenterRotatableView{_map_data(){"data"==this.model.properties.width.units?this.sw=this.sdist(this.renderer.xscale,this._x,this.width,"center"):this.sw=(0,l.to_screen)(this.width),"data"==this.model.properties.height.units?this.sh=this.sdist(this.renderer.yscale,this._y,this.height,"center"):this.sh=(0,l.to_screen)(this.height)}_render(t,s,e){const{sx:i,sy:h,sw:n,sh:r,angle:a}=null!=e?e:this;for(const e of s){const s=i[e],l=h[e],_=n[e],o=r[e],d=a.get(e);isFinite(s+l+_+o+d)&&(t.beginPath(),t.ellipse(s,l,_/2,o/2,d,0,2*Math.PI),this.visuals.fill.apply(t,e),this.visuals.hatch.apply(t,e),this.visuals.line.apply(t,e))}}_hit_point(t){let s,e,i,h,n,r,l,o,d;const{sx:c,sy:p}=t,w=this.renderer.xscale.invert(c),x=this.renderer.yscale.invert(p);"data"==this.model.properties.width.units?(s=w-this.max_width,e=w+this.max_width):(r=c-this.max_width,l=c+this.max_width,[s,e]=this.renderer.xscale.r_invert(r,l)),"data"==this.model.properties.height.units?(i=x-this.max_height,h=x+this.max_height):(o=p-this.max_height,d=p+this.max_height,[i,h]=this.renderer.yscale.r_invert(o,d));const m=this.index.indices({x0:s,x1:e,y0:i,y1:h}),y=[];for(const t of m)n=a.point_in_ellipse(c,p,this.angle.get(t),this.sh[t]/2,this.sw[t]/2,this.sx[t],this.sy[t]),n&&y.push(t);return new _.Selection({indices:y})}draw_legend_for_index(t,{x0:s,y0:e,x1:i,y1:h},n){const r=n+1,a=new Array(r);a[n]=(s+i)/2;const l=new Array(r);l[n]=(e+h)/2;const _=this.sw[n]/this.sh[n],d=.8*Math.min(Math.abs(i-s),Math.abs(h-e)),c=new Array(r),p=new Array(r);_>1?(c[n]=d,p[n]=d/_):(c[n]=d*_,p[n]=d);const w=new o.UniformScalar(0,r);this._render(t,[n],{sx:a,sy:l,sw:c,sh:p,angle:w})}}e.EllipseOvalView=d,d.__name__="EllipseOvalView";class c extends r.CenterRotatable{constructor(t){super(t)}}e.EllipseOval=c,c.__name__="EllipseOval"},
function _(e,t,i,a,n){a();const s=e(1);var r;const h=e(178),o=e(48),_=(0,s.__importStar)(e(18));class c extends h.XYGlyphView{get max_w2(){return"data"==this.model.properties.width.units?this.max_width/2:0}get max_h2(){return"data"==this.model.properties.height.units?this.max_height/2:0}_bounds({x0:e,x1:t,y0:i,y1:a}){const{max_w2:n,max_h2:s}=this;return{x0:e-n,x1:t+n,y0:i-s,y1:a+s}}}i.CenterRotatableView=c,c.__name__="CenterRotatableView";class l extends h.XYGlyph{constructor(e){super(e)}}i.CenterRotatable=l,r=l,l.__name__="CenterRotatable",r.mixins([o.LineVector,o.FillVector,o.HatchVector]),r.define((({})=>({angle:[_.AngleSpec,0],width:[_.DistanceSpec,{field:"width"}],height:[_.DistanceSpec,{field:"height"}]})))},
function _(t,e,s,i,r){i();const h=t(1);var a;const n=t(277),_=t(24),o=(0,h.__importStar)(t(18));class l extends n.BoxView{async lazy_initialize(){await super.lazy_initialize();const{webgl:e}=this.renderer.plot_view.canvas_view;if(null!=e&&e.regl_wrapper.has_webgl){const{LRTBGL:s}=await Promise.resolve().then((()=>(0,h.__importStar)(t(427))));this.glglyph=new s(e.regl_wrapper,this)}}scenterxy(t){return[(this.sleft[t]+this.sright[t])/2,this.sy[t]]}_lrtb(t){const e=this._left[t],s=this._right[t],i=this._y[t],r=this.height.get(t)/2;return[Math.min(e,s),Math.max(e,s),i+r,i-r]}_map_data(){this.sy=this.renderer.yscale.v_compute(this._y),this.sh=this.sdist(this.renderer.yscale,this._y,this.height,"center"),this.sleft=this.renderer.xscale.v_compute(this._left),this.sright=this.renderer.xscale.v_compute(this._right);const t=this.sy.length;this.stop=new _.ScreenArray(t),this.sbottom=new _.ScreenArray(t);for(let e=0;e<t;e++)this.stop[e]=this.sy[e]-this.sh[e]/2,this.sbottom[e]=this.sy[e]+this.sh[e]/2;this._clamp_viewport()}}s.HBarView=l,l.__name__="HBarView";class c extends n.Box{constructor(t){super(t)}}s.HBar=c,a=c,c.__name__="HBar",a.prototype.default_view=l,a.define((({})=>({left:[o.XCoordinateSpec,{value:0}],y:[o.YCoordinateSpec,{field:"y"}],height:[o.NumberSpec,{value:1}],right:[o.XCoordinateSpec,{field:"right"}]})))},
function _(t,e,s,r,i){var n;r();const a=t(48),h=t(179),o=t(184),c=t(72);class _ extends h.GlyphView{get_anchor_point(t,e,s){const r=Math.min(this.sleft[e],this.sright[e]),i=Math.max(this.sright[e],this.sleft[e]),n=Math.min(this.stop[e],this.sbottom[e]),a=Math.max(this.sbottom[e],this.stop[e]);switch(t){case"top_left":return{x:r,y:n};case"top":case"top_center":return{x:(r+i)/2,y:n};case"top_right":return{x:i,y:n};case"bottom_left":return{x:r,y:a};case"bottom":case"bottom_center":return{x:(r+i)/2,y:a};case"bottom_right":return{x:i,y:a};case"left":case"center_left":return{x:r,y:(n+a)/2};case"center":case"center_center":return{x:(r+i)/2,y:(n+a)/2};case"right":case"center_right":return{x:i,y:(n+a)/2}}}_index_data(t){const{min:e,max:s}=Math,{data_size:r}=this;for(let i=0;i<r;i++){const[r,n,a,h]=this._lrtb(i);t.add_rect(e(r,n),e(a,h),s(n,r),s(a,h))}}_render(t,e,s){const{sleft:r,sright:i,stop:n,sbottom:a}=null!=s?s:this;for(const s of e){const e=r[s],h=n[s],o=i[s],c=a[s];isFinite(e+h+o+c)&&(t.beginPath(),t.rect(e,h,o-e,c-h),this.visuals.fill.apply(t,s),this.visuals.hatch.apply(t,s),this.visuals.line.apply(t,s))}}_clamp_viewport(){const t=this.renderer.plot_view.frame.bbox.h_range,e=this.renderer.plot_view.frame.bbox.v_range,s=this.stop.length;for(let r=0;r<s;r++)this.stop[r]=Math.max(this.stop[r],e.start),this.sbottom[r]=Math.min(this.sbottom[r],e.end),this.sleft[r]=Math.max(this.sleft[r],t.start),this.sright[r]=Math.min(this.sright[r],t.end)}_hit_rect(t){return this._hit_rect_against_index(t)}_hit_point(t){const{sx:e,sy:s}=t,r=this.renderer.xscale.invert(e),i=this.renderer.yscale.invert(s),n=[...this.index.indices({x0:r,y0:i,x1:r,y1:i})];return new c.Selection({indices:n})}_hit_span(t){const{sx:e,sy:s}=t;let r;if("v"==t.direction){const t=this.renderer.yscale.invert(s),e=this.renderer.plot_view.frame.bbox.h_range,[i,n]=this.renderer.xscale.r_invert(e.start,e.end);r=[...this.index.indices({x0:i,y0:t,x1:n,y1:t})]}else{const t=this.renderer.xscale.invert(e),s=this.renderer.plot_view.frame.bbox.v_range,[i,n]=this.renderer.yscale.r_invert(s.start,s.end);r=[...this.index.indices({x0:t,y0:i,x1:t,y1:n})]}return new c.Selection({indices:r})}draw_legend_for_index(t,e,s){(0,o.generic_area_vector_legend)(this.visuals,t,e,s)}}s.BoxView=_,_.__name__="BoxView";class l extends h.Glyph{constructor(t){super(t)}}s.Box=l,n=l,l.__name__="Box",n.mixins([a.LineVector,a.FillVector,a.HatchVector])},
function _(e,t,s,i,r){i();const n=e(1);var a;const l=e(179),o=(0,n.__importStar)(e(185)),c=(0,n.__importStar)(e(18)),h=e(48),_=e(20),d=e(78),p=e(184),x=e(72);class y extends l.GlyphView{async lazy_initialize(){await super.lazy_initialize();const{webgl:t}=this.renderer.plot_view.canvas_view;if(null!=t&&t.regl_wrapper.has_webgl){const{HexTileGL:s}=await Promise.resolve().then((()=>(0,n.__importStar)(e(425))));this.glglyph=new s(t.regl_wrapper,this)}}scenterxy(e){return[this.sx[e],this.sy[e]]}_set_data(){const{orientation:e,size:t,aspect_scale:s}=this.model,{q:i,r}=this,n=this.q.length;this._x=new Float64Array(n),this._y=new Float64Array(n);const{_x:a,_y:l}=this,o=Math.sqrt(3);if("pointytop"==e)for(let e=0;e<n;e++){const n=i.get(e),c=r.get(e)/2;a[e]=t*o*(n+c)/s,l[e]=-3*t*c}else for(let e=0;e<n;e++){const n=i.get(e)/2,c=r.get(e);a[e]=3*t*n,l[e]=-t*o*(c+n)*s}}_project_data(){d.inplace.project_xy(this._x,this._y)}_index_data(e){let t=this.model.size,s=Math.sqrt(3)*t/2;"flattop"==this.model.orientation?([s,t]=[t,s],t*=this.model.aspect_scale):s/=this.model.aspect_scale;const{data_size:i}=this;for(let r=0;r<i;r++){const i=this._x[r],n=this._y[r];e.add_rect(i-s,n-t,i+s,n+t)}}map_data(){var e;[this.sx,this.sy]=this.renderer.coordinates.map_to_screen(this._x,this._y),[this.svx,this.svy]=this._get_unscaled_vertices(),null===(e=this.glglyph)||void 0===e||e.set_data_changed()}_get_unscaled_vertices(){const e=this.model.size,t=this.model.aspect_scale;if("pointytop"==this.model.orientation){const s=this.renderer.yscale,i=this.renderer.xscale,r=Math.abs(s.compute(0)-s.compute(e)),n=Math.sqrt(3)/2*Math.abs(i.compute(0)-i.compute(e))/t,a=r/2;return[[0,-n,-n,0,n,n],[r,a,-a,-r,-a,a]]}{const s=this.renderer.xscale,i=this.renderer.yscale,r=Math.abs(s.compute(0)-s.compute(e)),n=Math.sqrt(3)/2*Math.abs(i.compute(0)-i.compute(e))*t,a=r/2;return[[r,a,-a,-r,-a,a],[0,-n,-n,0,n,n]]}}_render(e,t,s){const{sx:i,sy:r,svx:n,svy:a,scale:l}=null!=s?s:this;for(const s of t){const t=i[s],o=r[s],c=l.get(s);if(isFinite(t+o+c)){e.translate(t,o),e.beginPath();for(let t=0;t<6;t++)e.lineTo(n[t]*c,a[t]*c);e.closePath(),e.translate(-t,-o),this.visuals.fill.apply(e,s),this.visuals.hatch.apply(e,s),this.visuals.line.apply(e,s)}}}_hit_point(e){const{sx:t,sy:s}=e,i=this.renderer.xscale.invert(t),r=this.renderer.yscale.invert(s),n=this.index.indices({x0:i,y0:r,x1:i,y1:r}),a=[];for(const e of n)o.point_in_poly(t-this.sx[e],s-this.sy[e],this.svx,this.svy)&&a.push(e);return new x.Selection({indices:a})}_hit_span(e){const{sx:t,sy:s}=e;let i;if("v"==e.direction){const e=this.renderer.yscale.invert(s),t=this.renderer.plot_view.frame.bbox.h_range,[r,n]=this.renderer.xscale.r_invert(t.start,t.end);i=[...this.index.indices({x0:r,y0:e,x1:n,y1:e})]}else{const e=this.renderer.xscale.invert(t),s=this.renderer.plot_view.frame.bbox.v_range,[r,n]=this.renderer.yscale.r_invert(s.start,s.end);i=[...this.index.indices({x0:e,y0:r,x1:e,y1:n})]}return new x.Selection({indices:i})}_hit_rect(e){const{sx0:t,sx1:s,sy0:i,sy1:r}=e,[n,a]=this.renderer.xscale.r_invert(t,s),[l,o]=this.renderer.yscale.r_invert(i,r),c=[...this.index.indices({x0:n,x1:a,y0:l,y1:o})];return new x.Selection({indices:c})}draw_legend_for_index(e,t,s){(0,p.generic_area_vector_legend)(this.visuals,e,t,s)}}s.HexTileView=y,y.__name__="HexTileView";class u extends l.Glyph{constructor(e){super(e)}}s.HexTile=u,a=u,u.__name__="HexTile",a.prototype.default_view=y,a.mixins([h.LineVector,h.FillVector,h.HatchVector]),a.define((({Number:e})=>({r:[c.NumberSpec,{field:"r"}],q:[c.NumberSpec,{field:"q"}],scale:[c.NumberSpec,1],size:[e,1],aspect_scale:[e,1],orientation:[_.HexTileOrientation,"pointytop"]}))),a.override({line_color:null})},
function _(e,a,t,_,r){var n;_();const s=e(280),o=e(173),i=e(201);class p extends s.ImageBaseView{connect_signals(){super.connect_signals(),this.connect(this.model.color_mapper.change,(()=>this._update_image()))}_update_image(){null!=this.image_data&&(this._set_data(null),this.renderer.request_render())}_flat_img_to_buf8(e){return this.model.color_mapper.rgba_mapper.v_compute(e)}}t.ImageView=p,p.__name__="ImageView";class m extends s.ImageBase{constructor(e){super(e)}}t.Image=m,n=m,m.__name__="Image",n.prototype.default_view=p,n.define((({Ref:e})=>({color_mapper:[e(o.ColorMapper),()=>new i.LinearColorMapper({palette:["#000000","#252525","#525252","#737373","#969696","#bdbdbd","#d9d9d9","#f0f0f0","#ffffff"]})]})))},
function _(e,t,i,s,a){s();const h=e(1);var n;const r=e(178),_=e(24),d=(0,h.__importStar)(e(18)),l=e(72),g=e(9),o=e(29),c=e(11);class m extends r.XYGlyphView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.global_alpha.change,(()=>this.renderer.request_render()))}_render(e,t,i){const{image_data:s,sx:a,sy:h,sw:n,sh:r,global_alpha:_}=null!=i?i:this,d=e.getImageSmoothingEnabled();e.setImageSmoothingEnabled(!1);const l=_.is_Scalar();l&&(e.globalAlpha=_.value);for(const i of t){const t=s[i],_=a[i],d=h[i],g=n[i],o=r[i],c=this.global_alpha.get(i);if(null==t||!isFinite(_+d+g+o+c))continue;l||(e.globalAlpha=c);const m=d;e.translate(0,m),e.scale(1,-1),e.translate(0,-m),e.drawImage(t,0|_,0|d,g,o),e.translate(0,m),e.scale(1,-1),e.translate(0,-m)}e.setImageSmoothingEnabled(d)}_set_data(e){this._set_width_heigh_data();for(let t=0,i=this.image.length;t<i;t++){if(null!=e&&e.indexOf(t)<0)continue;const i=this.image.get(t);let s;(0,o.is_NDArray)(i)?((0,c.assert)(2==i.dimension,"expected a 2D array"),s=i,this._height[t]=i.shape[0],this._width[t]=i.shape[1]):(s=(0,g.concat)(i),this._height[t]=i.length,this._width[t]=i[0].length);const a=this._flat_img_to_buf8(s);this._set_image_data_from_buffer(t,a)}}_index_data(e){const{data_size:t}=this;for(let i=0;i<t;i++){const[t,s,a,h]=this._lrtb(i);e.add_rect(t,h,s,a)}}_lrtb(e){const t=this.dw.get(e),i=this.dh.get(e),s=this.renderer.xscale.source_range,a=this._x[e],h=s.is_reversed?a-t:a+t,n=this.renderer.yscale.source_range,r=this._y[e],_=n.is_reversed?r-i:r+i,[d,l]=a<h?[a,h]:[h,a],[g,o]=r<_?[r,_]:[_,r];return[d,l,o,g]}_set_width_heigh_data(){null!=this.image_data&&this.image_data.length==this.image.length||(this.image_data=new Array(this.image.length)),null!=this._width&&this._width.length==this.image.length||(this._width=new Uint32Array(this.image.length)),null!=this._height&&this._height.length==this.image.length||(this._height=new Uint32Array(this.image.length))}_get_or_create_canvas(e){const t=this.image_data[e];if(null!=t&&t.width==this._width[e]&&t.height==this._height[e])return t;{const t=document.createElement("canvas");return t.width=this._width[e],t.height=this._height[e],t}}_set_image_data_from_buffer(e,t){const i=this._get_or_create_canvas(e),s=i.getContext("2d"),a=s.getImageData(0,0,this._width[e],this._height[e]);a.data.set(t),s.putImageData(a,0,0),this.image_data[e]=i}_map_data(){"data"==this.model.properties.dw.units?this.sw=this.sdist(this.renderer.xscale,this._x,this.dw,"edge",this.model.dilate):this.sw=(0,_.to_screen)(this.dw),"data"==this.model.properties.dh.units?this.sh=this.sdist(this.renderer.yscale,this._y,this.dh,"edge",this.model.dilate):this.sh=(0,_.to_screen)(this.dh)}_image_index(e,t,i){const[s,a,h,n]=this._lrtb(e),r=this._width[e],_=this._height[e],d=(a-s)/r,l=(h-n)/_;let g=Math.floor((t-s)/d),o=Math.floor((i-n)/l);return this.renderer.xscale.source_range.is_reversed&&(g=r-g-1),this.renderer.yscale.source_range.is_reversed&&(o=_-o-1),{index:e,dim1:g,dim2:o,flat_index:o*r+g}}_hit_point(e){const{sx:t,sy:i}=e,s=this.renderer.xscale.invert(t),a=this.renderer.yscale.invert(i),h=this.index.indices({x0:s,x1:s,y0:a,y1:a}),n=new l.Selection;for(const e of h)t!=1/0&&i!=1/0&&n.image_indices.push(this._image_index(e,s,a));return n}}i.ImageBaseView=m,m.__name__="ImageBaseView";class u extends r.XYGlyph{constructor(e){super(e)}}i.ImageBase=u,n=u,u.__name__="ImageBase",n.define((({Boolean:e})=>({image:[d.NDArraySpec,{field:"image"}],dw:[d.DistanceSpec,{field:"dw"}],dh:[d.DistanceSpec,{field:"dh"}],global_alpha:[d.NumberSpec,{value:1}],dilate:[e,!1]})))},
function _(e,a,t,r,_){var n;r();const s=e(280),m=e(8);class i extends s.ImageBaseView{_flat_img_to_buf8(e){let a;return a=(0,m.isArray)(e)?new Uint32Array(e):e,new Uint8ClampedArray(a.buffer)}}t.ImageRGBAView=i,i.__name__="ImageRGBAView";class g extends s.ImageBase{constructor(e){super(e)}}t.ImageRGBA=g,n=g,g.__name__="ImageRGBA",n.prototype.default_view=i},
function _(e,t,s,r,a){r();const i=e(1);var n;const o=e(178),c=e(24),_=e(20),h=(0,i.__importStar)(e(18)),l=e(12),d=e(136);class m extends o.XYGlyphView{constructor(){super(...arguments),this._images_rendered=!1,this._set_data_iteration=0}connect_signals(){super.connect_signals(),this.connect(this.model.properties.global_alpha.change,(()=>this.renderer.request_render()))}_index_data(e){const{data_size:t}=this;for(let s=0;s<t;s++)e.add_empty()}_set_data(){this._set_data_iteration++;const e=this.url.length;this.image=new Array(e);const{retry_attempts:t,retry_timeout:s}=this.model,{_set_data_iteration:r}=this;for(let a=0;a<e;a++){const e=this.url.get(a);e&&new d.ImageLoader(e,{loaded:e=>{this._set_data_iteration==r&&(this.image[a]=e,this.renderer.request_render())},attempts:t+1,timeout:s})}const a="data"==this.model.properties.w.units,i="data"==this.model.properties.h.units,n=this._x.length,o=new c.ScreenArray(a?2*n:n),_=new c.ScreenArray(i?2*n:n),{anchor:h}=this.model;function m(e,t){switch(h){case"top_left":case"bottom_left":case"left":case"center_left":return[e,e+t];case"top":case"top_center":case"bottom":case"bottom_center":case"center":case"center_center":return[e-t/2,e+t/2];case"top_right":case"bottom_right":case"right":case"center_right":return[e-t,e]}}function g(e,t){switch(h){case"top_left":case"top":case"top_center":case"top_right":return[e,e-t];case"bottom_left":case"bottom":case"bottom_center":case"bottom_right":return[e+t,e];case"left":case"center_left":case"center":case"center_center":case"right":case"center_right":return[e+t/2,e-t/2]}}if(a)for(let e=0;e<n;e++)[o[e],o[n+e]]=m(this._x[e],this.w.get(e));else o.set(this._x,0);if(i)for(let e=0;e<n;e++)[_[e],_[n+e]]=g(this._y[e],this.h.get(e));else _.set(this._y,0);const[u,p]=(0,l.minmax)(o),[f,b]=(0,l.minmax)(_);this._bounds_rect={x0:u,x1:p,y0:f,y1:b}}has_finished(){return super.has_finished()&&1==this._images_rendered}_map_data(){"data"==this.model.properties.w.units?this.sw=this.sdist(this.renderer.xscale,this._x,this.w,"edge",this.model.dilate):this.sw=(0,c.to_screen)(this.w),"data"==this.model.properties.h.units?this.sh=this.sdist(this.renderer.yscale,this._y,this.h,"edge",this.model.dilate):this.sh=(0,c.to_screen)(this.h)}_render(e,t,s){const{image:r,sx:a,sy:i,sw:n,sh:o,angle:c,global_alpha:_}=null!=s?s:this,{frame:h}=this.renderer.plot_view;e.beginPath(),e.rect(h.bbox.left+1,h.bbox.top+1,h.bbox.width-2,h.bbox.height-2),e.clip();let l=!0;for(const s of t){if(!isFinite(a[s]+i[s]+c.get(s)+_.get(s)))continue;const t=r[s];null!=t?this._render_image(e,s,t,a,i,n,o,c,_):l=!1}l&&!this._images_rendered&&(this._images_rendered=!0,this.notify_finished())}_final_sx_sy(e,t,s,r,a){switch(e){case"top_left":return[t,s];case"top":case"top_center":return[t-r/2,s];case"top_right":return[t-r,s];case"right":case"center_right":return[t-r,s-a/2];case"bottom_right":return[t-r,s-a];case"bottom":case"bottom_center":return[t-r/2,s-a];case"bottom_left":return[t,s-a];case"left":case"center_left":return[t,s-a/2];case"center":case"center_center":return[t-r/2,s-a/2]}}_render_image(e,t,s,r,a,i,n,o,c){isFinite(i[t])||(i[t]=s.width),isFinite(n[t])||(n[t]=s.height);const _=i[t],h=n[t],{anchor:l}=this.model,[d,m]=this._final_sx_sy(l,r[t],a[t],_,h),g=o.get(t),u=c.get(t);e.save(),e.globalAlpha=u;const p=_/2,f=h/2;g?(e.translate(d,m),e.translate(p,f),e.rotate(g),e.translate(-p,-f),e.drawImage(s,0,0,_,h),e.translate(p,f),e.rotate(-g),e.translate(-p,-f),e.translate(-d,-m)):e.drawImage(s,d,m,_,h),e.restore()}bounds(){return this._bounds_rect}}s.ImageURLView=m,m.__name__="ImageURLView";class g extends o.XYGlyph{constructor(e){super(e)}}s.ImageURL=g,n=g,g.__name__="ImageURL",n.prototype.default_view=m,n.define((({Boolean:e,Int:t})=>({url:[h.StringSpec,{field:"url"}],anchor:[_.Anchor,"top_left"],global_alpha:[h.NumberSpec,{value:1}],angle:[h.AngleSpec,0],w:[h.NullDistanceSpec,null],h:[h.NullDistanceSpec,null],dilate:[e,!1],retry_attempts:[t,0],retry_timeout:[t,0]})))},
function _(e,t,s,i,n){i();const o=e(1);var r;const l=e(78),_=e(48),c=(0,o.__importStar)(e(185)),h=(0,o.__importStar)(e(18)),a=e(12),d=e(13),x=e(179),y=e(184),g=e(72);class p extends x.GlyphView{_project_data(){l.inplace.project_xy(this._xs.array,this._ys.array)}_index_data(e){const{data_size:t}=this;for(let s=0;s<t;s++){const t=this._xs.get(s),i=this._ys.get(s),[n,o,r,l]=(0,a.minmax2)(t,i);e.add_rect(n,r,o,l)}}_render(e,t,s){const{sxs:i,sys:n}=null!=s?s:this;for(const s of t){const t=i.get(s),o=n.get(s),r=Math.min(t.length,o.length);let l=!0;e.beginPath();for(let s=0;s<r;s++){const i=t[s],n=o[s];isFinite(i+n)?l?(e.moveTo(i,n),l=!1):e.lineTo(i,n):l=!0}this.visuals.line.set_vectorize(e,s),e.stroke()}}_hit_point(e){const t={x:e.sx,y:e.sy};let s=9999;const i=new Map;for(let e=0,n=this.sxs.length;e<n;e++){const n=Math.max(2,this.line_width.get(e)/2),o=this.sxs.get(e),r=this.sys.get(e);let l=null;for(let e=0,i=o.length-1;e<i;e++){const i={x:o[e],y:r[e]},_={x:o[e+1],y:r[e+1]},h=c.dist_to_segment(t,i,_);h<n&&h<s&&(s=h,l=[e])}null!=l&&i.set(e,l)}return new g.Selection({indices:[...i.keys()],multiline_indices:(0,d.to_object)(i)})}_hit_span(e){const{sx:t,sy:s}=e;let i,n;"v"==e.direction?(i=this.renderer.yscale.invert(s),n=this._ys):(i=this.renderer.xscale.invert(t),n=this._xs);const o=new Map;for(let e=0,t=n.length;e<t;e++){const t=n.get(e),s=[];for(let e=0,n=t.length-1;e<n;e++)t[e]<=i&&i<=t[e+1]&&s.push(e);s.length>0&&o.set(e,s)}return new g.Selection({indices:[...o.keys()],multiline_indices:(0,d.to_object)(o)})}get_interpolation_hit(e,t,s){const i=this._xs.get(e),n=this._ys.get(e),o=i[t],r=n[t],l=i[t+1],_=n[t+1];return(0,y.line_interpolation)(this.renderer,s,o,r,l,_)}draw_legend_for_index(e,t,s){(0,y.generic_line_vector_legend)(this.visuals,e,t,s)}scenterxy(){throw new Error(`${this}.scenterxy() is not implemented`)}}s.MultiLineView=p,p.__name__="MultiLineView";class u extends x.Glyph{constructor(e){super(e)}}s.MultiLine=u,r=u,u.__name__="MultiLine",r.prototype.default_view=p,r.define((({})=>({xs:[h.XCoordinateSeqSpec,{field:"xs"}],ys:[h.YCoordinateSeqSpec,{field:"ys"}]}))),r.mixins(_.LineVector)},
function _(t,e,s,n,i){n();const o=t(1);var r;const l=t(181),h=t(179),a=t(184),_=t(12),c=t(12),d=t(48),x=(0,o.__importStar)(t(185)),y=(0,o.__importStar)(t(18)),f=t(72),g=t(11);class p extends h.GlyphView{_project_data(){}_index_data(t){const{min:e,max:s}=Math,{data_size:n}=this;for(let i=0;i<n;i++){const n=this._xs[i],o=this._ys[i];if(0==n.length||0==o.length){t.add_empty();continue}let r=1/0,l=-1/0,h=1/0,a=-1/0;for(let t=0,i=n.length;t<i;t++){const i=n[t][0],c=o[t][0];if(0!=i.length&&0!=c.length){const[t,n]=(0,_.minmax)(i),[o,d]=(0,_.minmax)(c);r=e(r,t),l=s(l,n),h=e(h,o),a=s(a,d)}}t.add_rect(r,h,l,a)}this._hole_index=this._index_hole_data()}_index_hole_data(){const{min:t,max:e}=Math,{data_size:s}=this,n=new l.SpatialIndex(s);for(let i=0;i<s;i++){const s=this._xs[i],o=this._ys[i];if(0==s.length||0==o.length){n.add_empty();continue}let r=1/0,l=-1/0,h=1/0,a=-1/0;for(let n=0,i=s.length;n<i;n++){const i=s[n],c=o[n];if(i.length>1&&c.length>1)for(let s=1,n=i.length;s<n;s++){const[n,o]=(0,_.minmax)(i[s]),[d,x]=(0,_.minmax)(c[s]);r=t(r,n),l=e(l,o),h=t(h,d),a=e(a,x)}}n.add_rect(r,h,l,a)}return n.finish(),n}_mask_data(){const{x_range:t,y_range:e}=this.renderer.plot_view.frame;return this.index.indices({x0:t.min,x1:t.max,y0:e.min,y1:e.max})}_render(t,e,s){if(this.visuals.fill.doit||this.visuals.line.doit){const{sxs:n,sys:i}=null!=s?s:this;for(const s of e){t.beginPath();const e=n[s],o=i[s],r=Math.min(e.length,o.length);for(let s=0;s<r;s++){const n=e[s],i=o[s],r=Math.min(n.length,i.length);for(let e=0;e<r;e++){const s=n[e],o=i[e],r=Math.min(s.length,o.length);for(let e=0;e<r;e++){const n=s[e],i=o[e];0==e?t.moveTo(n,i):t.lineTo(n,i)}t.closePath()}}this.visuals.fill.apply(t,s,"evenodd"),this.visuals.hatch.apply(t,s,"evenodd"),this.visuals.line.apply(t,s)}}}_hit_rect(t){const{sx0:e,sx1:s,sy0:n,sy1:i}=t,o=[e,s,s,e],r=[n,n,i,i],[l,h]=this.renderer.xscale.r_invert(e,s),[a,_]=this.renderer.yscale.r_invert(n,i),c=this.index.indices({x0:l,x1:h,y0:a,y1:_}),d=[];for(const t of c){const e=this.sxs[t],s=this.sys[t];let n=!0;for(let t=0,i=e.length;t<i;t++){for(let i=0,l=e[t][0].length;i<l;i++){const l=e[t][0][i],h=s[t][0][i];if(!x.point_in_poly(l,h,o,r)){n=!1;break}}if(!n)break}n&&d.push(t)}return new f.Selection({indices:d})}_hit_point(t){const{sx:e,sy:s}=t,n=this.renderer.xscale.invert(e),i=this.renderer.yscale.invert(s),o=this.index.indices({x0:n,y0:i,x1:n,y1:i}),r=this._hole_index.indices({x0:n,y0:i,x1:n,y1:i}),l=[];for(const t of o){const n=this.sxs[t],i=this.sys[t];for(let o=0,h=n.length;o<h;o++){const h=n[o].length;if(x.point_in_poly(e,s,n[o][0],i[o][0]))if(1==h)l.push(t);else if(r.get(t)){if(h>1){let r=!1;for(let t=1;t<h;t++){const l=n[o][t],h=i[o][t];if(x.point_in_poly(e,s,l,h)){r=!0;break}}r||l.push(t)}}else l.push(t)}}return new f.Selection({indices:l})}_get_snap_coord(t){return(0,c.sum)(t)/t.length}scenterxy(t,e,s){if(1==this.sxs[t].length){return[this._get_snap_coord(this.sxs[t][0][0]),this._get_snap_coord(this.sys[t][0][0])]}{const n=this.sxs[t],i=this.sys[t];for(let t=0,o=n.length;t<o;t++)if(x.point_in_poly(e,s,n[t][0],i[t][0])){return[this._get_snap_coord(n[t][0]),this._get_snap_coord(i[t][0])]}}(0,g.unreachable)()}map_data(){const t=this._xs.length;this.sxs=new Array(t),this.sys=new Array(t);for(let e=0;e<t;e++){const t=this._xs[e].length;this.sxs[e]=new Array(t),this.sys[e]=new Array(t);for(let s=0;s<t;s++){const t=this._xs[e][s].length;this.sxs[e][s]=new Array(t),this.sys[e][s]=new Array(t);for(let n=0;n<t;n++){const[t,i]=this.renderer.coordinates.map_to_screen(this._xs[e][s][n],this._ys[e][s][n]);this.sxs[e][s][n]=t,this.sys[e][s][n]=i}}}}draw_legend_for_index(t,e,s){(0,a.generic_area_vector_legend)(this.visuals,t,e,s)}}s.MultiPolygonsView=p,p.__name__="MultiPolygonsView";class m extends h.Glyph{constructor(t){super(t)}}s.MultiPolygons=m,r=m,m.__name__="MultiPolygons",r.prototype.default_view=p,r.define((({})=>({xs:[y.XCoordinateSeqSeqSeqSpec,{field:"xs"}],ys:[y.YCoordinateSeqSeqSeqSpec,{field:"ys"}]}))),r.mixins([d.LineVector,d.FillVector,d.HatchVector])},
function _(a,e,l,s,_){var t;s();const i=a(274),n=a(12);class p extends i.EllipseOvalView{_map_data(){super._map_data(),(0,n.mul)(this.sw,.75)}}l.OvalView=p,p.__name__="OvalView";class v extends i.EllipseOval{constructor(a){super(a)}}l.Oval=v,t=v,v.__name__="Oval",t.prototype.default_view=p},
function _(e,t,s,i,n){i();const r=e(1);var a;const o=e(179),c=e(184),_=e(12),h=e(48),l=(0,r.__importStar)(e(185)),d=(0,r.__importStar)(e(18)),y=e(72),p=e(11),x=e(78);class f extends o.GlyphView{_project_data(){x.inplace.project_xy(this._xs.array,this._ys.array)}_index_data(e){const{data_size:t}=this;for(let s=0;s<t;s++){const t=this._xs.get(s),i=this._ys.get(s),[n,r,a,o]=(0,_.minmax2)(t,i);e.add_rect(n,a,r,o)}}_mask_data(){const{x_range:e,y_range:t}=this.renderer.plot_view.frame;return this.index.indices({x0:e.min,x1:e.max,y0:t.min,y1:t.max})}_render(e,t,s){const{sxs:i,sys:n}=null!=s?s:this;for(const s of t){const t=i.get(s),r=n.get(s);let a=!0;e.beginPath();const o=Math.min(t.length,r.length);for(let s=0;s<o;s++){const i=t[s],n=r[s];isFinite(i+n)?a?(e.moveTo(i,n),a=!1):e.lineTo(i,n):(e.closePath(),a=!0)}e.closePath(),this.visuals.fill.apply(e,s),this.visuals.hatch.apply(e,s),this.visuals.line.apply(e,s)}}_hit_rect(e){const{sx0:t,sx1:s,sy0:i,sy1:n}=e,r=[t,s,s,t],a=[i,i,n,n],[o,c]=this.renderer.xscale.r_invert(t,s),[_,h]=this.renderer.yscale.r_invert(i,n),d=this.index.indices({x0:o,x1:c,y0:_,y1:h}),p=[];for(const e of d){const t=this.sxs.get(e),s=this.sys.get(e);let i=!0;for(let e=0,n=t.length;e<n;e++){const n=t[e],o=s[e];if(!l.point_in_poly(n,o,r,a)){i=!1;break}}i&&p.push(e)}return new y.Selection({indices:p})}_hit_point(e){const{sx:t,sy:s}=e,i=this.renderer.xscale.invert(t),n=this.renderer.yscale.invert(s),r=this.index.indices({x0:i,y0:n,x1:i,y1:n}),a=[];for(const e of r){const i=this.sxs.get(e),n=this.sys.get(e),r=i.length;for(let o=0,c=0;;c++){if(isNaN(i[c])||c==r){const r=i.subarray(o,c),_=n.subarray(o,c);if(l.point_in_poly(t,s,r,_)){a.push(e);break}o=c+1}if(c==r)break}}return new y.Selection({indices:a})}_get_snap_coord(e){return(0,_.sum)(e)/e.length}scenterxy(e,t,s){const i=this.sxs.get(e),n=this.sys.get(e),r=i.length;let a=!1;for(let e=0,o=0;;o++){const c=isNaN(i[o]);if(a=a||c,o==r&&!a){return[this._get_snap_coord(i),this._get_snap_coord(n)]}if(c||o==r){const r=i.subarray(e,o),a=n.subarray(e,o);if(l.point_in_poly(t,s,r,a)){return[this._get_snap_coord(r),this._get_snap_coord(a)]}e=o+1}if(o==r)break}(0,p.unreachable)()}draw_legend_for_index(e,t,s){(0,c.generic_area_vector_legend)(this.visuals,e,t,s)}}s.PatchesView=f,f.__name__="PatchesView";class g extends o.Glyph{constructor(e){super(e)}}s.Patches=g,a=g,g.__name__="Patches",a.prototype.default_view=f,a.define((({})=>({xs:[d.XCoordinateSeqSpec,{field:"xs"}],ys:[d.YCoordinateSeqSpec,{field:"ys"}]}))),a.mixins([h.LineVector,h.FillVector,h.HatchVector])},
function _(t,e,i,o,r){o();const s=t(1);var a;const n=t(277),l=(0,s.__importStar)(t(18));class _ extends n.BoxView{async lazy_initialize(){await super.lazy_initialize();const{webgl:e}=this.renderer.plot_view.canvas_view;if(null!=e&&e.regl_wrapper.has_webgl){const{LRTBGL:i}=await Promise.resolve().then((()=>(0,s.__importStar)(t(427))));this.glglyph=new i(e.regl_wrapper,this)}}scenterxy(t){return[this.sleft[t]/2+this.sright[t]/2,this.stop[t]/2+this.sbottom[t]/2]}_lrtb(t){return[this._left[t],this._right[t],this._top[t],this._bottom[t]]}}i.QuadView=_,_.__name__="QuadView";class p extends n.Box{constructor(t){super(t)}}i.Quad=p,a=p,p.__name__="Quad",a.prototype.default_view=_,a.define((({})=>({right:[l.XCoordinateSpec,{field:"right"}],bottom:[l.YCoordinateSpec,{field:"bottom"}],left:[l.XCoordinateSpec,{field:"left"}],top:[l.YCoordinateSpec,{field:"top"}]})))},
function _(e,t,i,n,s){n();const c=e(1);var o;const r=e(48),a=e(78),_=e(179),d=e(184),l=(0,c.__importStar)(e(18));function x(e,t,i){if(t==(e+i)/2)return[e,i];{const n=(e-t)/(e-2*t+i),s=e*(1-n)**2+2*t*(1-n)*n+i*n**2;return[Math.min(e,i,s),Math.max(e,i,s)]}}class y extends _.GlyphView{_project_data(){a.inplace.project_xy(this._x0,this._y0),a.inplace.project_xy(this._x1,this._y1)}_index_data(e){const{_x0:t,_x1:i,_y0:n,_y1:s,_cx:c,_cy:o,data_size:r}=this;for(let a=0;a<r;a++){const r=t[a],_=i[a],d=n[a],l=s[a],y=c[a],p=o[a];if(isFinite(r+_+d+l+y+p)){const[t,i]=x(r,y,_),[n,s]=x(d,p,l);e.add_rect(t,n,i,s)}else e.add_empty()}}_render(e,t,i){if(this.visuals.line.doit){const{sx0:n,sy0:s,sx1:c,sy1:o,scx:r,scy:a}=null!=i?i:this;for(const i of t){const t=n[i],_=s[i],d=c[i],l=o[i],x=r[i],y=a[i];isFinite(t+_+d+l+x+y)&&(e.beginPath(),e.moveTo(t,_),e.quadraticCurveTo(x,y,d,l),this.visuals.line.set_vectorize(e,i),e.stroke())}}}draw_legend_for_index(e,t,i){(0,d.generic_line_vector_legend)(this.visuals,e,t,i)}scenterxy(){throw new Error(`${this}.scenterxy() is not implemented`)}}i.QuadraticView=y,y.__name__="QuadraticView";class p extends _.Glyph{constructor(e){super(e)}}i.Quadratic=p,o=p,p.__name__="Quadratic",o.prototype.default_view=y,o.define((({})=>({x0:[l.XCoordinateSpec,{field:"x0"}],y0:[l.YCoordinateSpec,{field:"y0"}],x1:[l.XCoordinateSpec,{field:"x1"}],y1:[l.YCoordinateSpec,{field:"y1"}],cx:[l.XCoordinateSpec,{field:"cx"}],cy:[l.YCoordinateSpec,{field:"cy"}]}))),o.mixins(r.LineVector)},
function _(e,t,s,i,n){i();const l=e(1);var a;const r=e(178),o=e(184),h=e(48),_=e(24),c=(0,l.__importStar)(e(18));class g extends r.XYGlyphView{_map_data(){"data"==this.model.properties.length.units?this.slength=this.sdist(this.renderer.xscale,this._x,this.length):this.slength=(0,_.to_screen)(this.length);const{width:e,height:t}=this.renderer.plot_view.frame.bbox,s=2*(e+t),{slength:i}=this;for(let e=0,t=i.length;e<t;e++)0==i[e]&&(i[e]=s)}_render(e,t,s){const{sx:i,sy:n,slength:l,angle:a}=null!=s?s:this;if(this.visuals.line.doit)for(const s of t){const t=i[s],r=n[s],o=a.get(s),h=l[s];isFinite(t+r+o+h)&&(e.translate(t,r),e.rotate(o),e.beginPath(),e.moveTo(0,0),e.lineTo(h,0),this.visuals.line.set_vectorize(e,s),e.stroke(),e.rotate(-o),e.translate(-t,-r))}}draw_legend_for_index(e,t,s){(0,o.generic_line_vector_legend)(this.visuals,e,t,s)}}s.RayView=g,g.__name__="RayView";class d extends r.XYGlyph{constructor(e){super(e)}}s.Ray=d,a=d,d.__name__="Ray",a.prototype.default_view=g,a.mixins(h.LineVector),a.define((({})=>({length:[c.DistanceSpec,0],angle:[c.AngleSpec,0]})))},
function _(t,e,s,i,r){var n,h=this&&this.__createBinding||(Object.create?function(t,e,s,i){void 0===i&&(i=s),Object.defineProperty(t,i,{enumerable:!0,get:function(){return e[s]}})}:function(t,e,s,i){void 0===i&&(i=s),t[i]=e[s]}),a=this&&this.__setModuleDefault||(Object.create?function(t,e){Object.defineProperty(t,"default",{enumerable:!0,value:e})}:function(t,e){t.default=e}),l=this&&this.__importStar||function(t){if(t&&t.__esModule)return t;var e={};if(null!=t)for(var s in t)"default"!==s&&Object.prototype.hasOwnProperty.call(t,s)&&h(e,t,s);return a(e,t),e};i();const o=t(275),c=t(184),_=t(24),d=t(12),f=t(72);class y extends o.CenterRotatableView{async lazy_initialize(){await super.lazy_initialize();const{webgl:e}=this.renderer.plot_view.canvas_view;if(null==e?void 0:e.regl_wrapper.has_webgl){const{RectGL:s}=await Promise.resolve().then((()=>l(t(429))));this.glglyph=new s(e.regl_wrapper,this)}}_map_data(){if("data"==this.model.properties.width.units)[this.sw,this.sx0]=this._map_dist_corner_for_data_side_length(this._x,this.width,this.renderer.xscale);else{this.sw=(0,_.to_screen)(this.width);const t=this.sx.length;this.sx0=new _.ScreenArray(t);for(let e=0;e<t;e++)this.sx0[e]=this.sx[e]-this.sw[e]/2}if("data"==this.model.properties.height.units)[this.sh,this.sy1]=this._map_dist_corner_for_data_side_length(this._y,this.height,this.renderer.yscale);else{this.sh=(0,_.to_screen)(this.height);const t=this.sy.length;this.sy1=new _.ScreenArray(t);for(let e=0;e<t;e++)this.sy1[e]=this.sy[e]-this.sh[e]/2}const t=this.sw.length;this.ssemi_diag=new _.ScreenArray(t);for(let e=0;e<t;e++)this.ssemi_diag[e]=Math.sqrt(this.sw[e]/2*this.sw[e]/2+this.sh[e]/2*this.sh[e]/2)}_render(t,e,s){const{sx:i,sy:r,sx0:n,sy1:h,sw:a,sh:l,angle:o}=null!=s?s:this;for(const s of e){const e=i[s],c=r[s],_=n[s],d=h[s],f=a[s],y=l[s],u=o.get(s);isFinite(e+c+_+d+f+y+u)&&(0!=f&&0!=y&&(t.beginPath(),u?(t.translate(e,c),t.rotate(u),t.rect(-f/2,-y/2,f,y),t.rotate(-u),t.translate(-e,-c)):t.rect(_,d,f,y),this.visuals.fill.apply(t,s),this.visuals.hatch.apply(t,s),this.visuals.line.apply(t,s)))}}_hit_rect(t){return this._hit_rect_against_index(t)}_hit_point(t){let{sx:e,sy:s}=t;const i=this.renderer.xscale.invert(e),r=this.renderer.yscale.invert(s),n=this.sx0.length,h=new _.ScreenArray(n);for(let t=0;t<n;t++)h[t]=this.sx0[t]+this.sw[t]/2;const a=new _.ScreenArray(n);for(let t=0;t<n;t++)a[t]=this.sy1[t]+this.sh[t]/2;const l=(0,d.max)(this._ddist(0,h,this.ssemi_diag)),o=(0,d.max)(this._ddist(1,a,this.ssemi_diag)),c=i-l,y=i+l,u=r-o,w=r+o;let g,p;const x=[];for(const t of this.index.indices({x0:c,x1:y,y0:u,y1:w})){const i=this.angle.get(t);if(i){const r=Math.sin(-i),n=Math.cos(-i),h=n*(e-this.sx[t])-r*(s-this.sy[t])+this.sx[t],a=r*(e-this.sx[t])+n*(s-this.sy[t])+this.sy[t];e=h,s=a,g=Math.abs(this.sx[t]-e)<=this.sw[t]/2,p=Math.abs(this.sy[t]-s)<=this.sh[t]/2}else{const i=e-this.sx0[t],r=s-this.sy1[t];g=0<=i&&i<=this.sw[t],p=0<=r&&r<=this.sh[t]}g&&p&&x.push(t)}return new f.Selection({indices:x})}_map_dist_corner_for_data_side_length(t,e,s){const i=t.length,r=new Float64Array(i),n=new Float64Array(i);for(let s=0;s<i;s++){const i=t[s],h=e.get(s)/2;r[s]=i-h,n[s]=i+h}const h=s.v_compute(r),a=s.v_compute(n),l=this.sdist(s,r,e,"edge",this.model.dilate);let o=h;for(let t=0;t<i;t++){const e=h[t],s=a[t];if(!isNaN(e+s)&&e!=s){o=e<s?h:a;break}}return[l,o]}_ddist(t,e,s){const i=(0,_.infer_type)(e,s),r=0==t?this.renderer.xscale:this.renderer.yscale,n=e,h=n.length,a=new i(h);for(let t=0;t<h;t++)a[t]=n[t]+s[t];const l=r.v_invert(n),o=r.v_invert(a),c=l.length,d=new i(c);for(let t=0;t<c;t++)d[t]=Math.abs(o[t]-l[t]);return d}draw_legend_for_index(t,e,s){(0,c.generic_area_vector_legend)(this.visuals,t,e,s)}}s.RectView=y,y.__name__="RectView";class u extends o.CenterRotatable{constructor(t){super(t)}}s.Rect=u,n=u,u.__name__="Rect",n.prototype.default_view=y,n.define((({Boolean:t})=>({dilate:[t,!1]})))},
function _(e,t,r,a,s){a();const i=e(1);var n;const l=e(292),_=e(293),c=(0,i.__importStar)(e(18));class o extends l.MarkerView{async lazy_initialize(){await super.lazy_initialize();const{webgl:t}=this.renderer.plot_view.canvas_view;if(null!=t&&t.regl_wrapper.has_webgl){const{MultiMarkerGL:r}=await Promise.resolve().then((()=>(0,i.__importStar)(e(428))));this.glglyph=new r(t.regl_wrapper,this)}}_render(e,t,r){const{sx:a,sy:s,size:i,angle:n,marker:l}=null!=r?r:this;for(const r of t){const t=a[r],c=s[r],o=i.get(r),g=n.get(r),w=l.get(r);if(!isFinite(t+c+o+g)||null==w)continue;const p=o/2;e.beginPath(),e.translate(t,c),g&&e.rotate(g),_.marker_funcs[w](e,r,p,this.visuals),g&&e.rotate(-g),e.translate(-t,-c)}}draw_legend_for_index(e,{x0:t,x1:r,y0:a,y1:s},i){const n=i+1,l=this.marker.get(i),_=Object.assign(Object.assign({},this._get_legend_args({x0:t,x1:r,y0:a,y1:s},i)),{marker:new c.UniformScalar(l,n)});this._render(e,[i],_)}}r.ScatterView=o,o.__name__="ScatterView";class g extends l.Marker{constructor(e){super(e)}}r.Scatter=g,n=g,g.__name__="Scatter",n.prototype.default_view=o,n.define((()=>({marker:[c.MarkerSpec,{value:"circle"}]})))},
function _(e,t,s,n,i){n();const r=e(1);var a;const c=e(178),o=e(48),_=(0,r.__importStar)(e(185)),h=(0,r.__importStar)(e(18)),l=e(9),x=e(72);class d extends c.XYGlyphView{_render(e,t,s){const{sx:n,sy:i,size:r,angle:a}=null!=s?s:this;for(const s of t){const t=n[s],c=i[s],o=r.get(s),_=a.get(s);if(!isFinite(t+c+o+_))continue;const h=o/2;e.beginPath(),e.translate(t,c),_&&e.rotate(_),this._render_one(e,s,h,this.visuals),_&&e.rotate(-_),e.translate(-t,-c)}}_mask_data(){const{x_target:e,y_target:t}=this.renderer.plot_view.frame,s=e.widen(this.max_size).map((e=>this.renderer.xscale.invert(e))),n=t.widen(this.max_size).map((e=>this.renderer.yscale.invert(e)));return this.index.indices({x0:s.start,x1:s.end,y0:n.start,y1:n.end})}_hit_point(e){const{sx:t,sy:s}=e,{max_size:n}=this,{hit_dilation:i}=this.model,r=t-n*i,a=t+n*i,[c,o]=this.renderer.xscale.r_invert(r,a),_=s-n*i,h=s+n*i,[l,d]=this.renderer.yscale.r_invert(_,h),y=this.index.indices({x0:c,x1:o,y0:l,y1:d}),g=[];for(const e of y){const n=this.size.get(e)/2*i;Math.abs(this.sx[e]-t)<=n&&Math.abs(this.sy[e]-s)<=n&&g.push(e)}return new x.Selection({indices:g})}_hit_span(e){const{sx:t,sy:s}=e,n=this.bounds(),i=this.max_size/2;let r,a,c,o;if("h"==e.direction){c=n.y0,o=n.y1;const e=t-i,s=t+i;[r,a]=this.renderer.xscale.r_invert(e,s)}else{r=n.x0,a=n.x1;const e=s-i,t=s+i;[c,o]=this.renderer.yscale.r_invert(e,t)}const _=[...this.index.indices({x0:r,x1:a,y0:c,y1:o})];return new x.Selection({indices:_})}_hit_rect(e){const{sx0:t,sx1:s,sy0:n,sy1:i}=e,[r,a]=this.renderer.xscale.r_invert(t,s),[c,o]=this.renderer.yscale.r_invert(n,i),_=[...this.index.indices({x0:r,x1:a,y0:c,y1:o})];return new x.Selection({indices:_})}_hit_poly(e){const{sx:t,sy:s}=e,n=(0,l.range)(0,this.sx.length),i=[];for(let e=0,r=n.length;e<r;e++){const r=n[e];_.point_in_poly(this.sx[e],this.sy[e],t,s)&&i.push(r)}return new x.Selection({indices:i})}_get_legend_args({x0:e,x1:t,y0:s,y1:n},i){const r=i+1,a=new Array(r),c=new Array(r);a[i]=(e+t)/2,c[i]=(s+n)/2;const o=.4*Math.min(Math.abs(t-e),Math.abs(n-s));return{sx:a,sy:c,size:new h.UniformScalar(o,r),angle:new h.UniformScalar(0,r)}}draw_legend_for_index(e,{x0:t,x1:s,y0:n,y1:i},r){const a=this._get_legend_args({x0:t,x1:s,y0:n,y1:i},r);this._render(e,[r],a)}}s.MarkerView=d,d.__name__="MarkerView";class y extends c.XYGlyph{constructor(e){super(e)}}s.Marker=y,a=y,y.__name__="Marker",a.mixins([o.LineVector,o.FillVector,o.HatchVector]),a.define((({Number:e})=>({size:[h.ScreenSizeSpec,{value:4}],angle:[h.AngleSpec,0],hit_dilation:[e,1]})))},
function _(l,o,n,t,i){t();const e=Math.sqrt(3),a=Math.sqrt(5),c=(a+1)/4,p=Math.sqrt((5-a)/8),r=(a-1)/4,h=Math.sqrt((5+a)/8);function u(l,o){l.rotate(Math.PI/4),s(l,o),l.rotate(-Math.PI/4)}function f(l,o){const n=o*e,t=n/3;l.moveTo(-n/2,-t),l.lineTo(0,0),l.lineTo(n/2,-t),l.lineTo(0,0),l.lineTo(0,o)}function s(l,o){l.moveTo(0,o),l.lineTo(0,-o),l.moveTo(-o,0),l.lineTo(o,0)}function T(l,o){l.moveTo(0,o),l.lineTo(o/1.5,0),l.lineTo(0,-o),l.lineTo(-o/1.5,0),l.closePath()}function y(l,o){const n=o*e,t=n/3;l.moveTo(-o,t),l.lineTo(o,t),l.lineTo(0,t-n),l.closePath()}function v(l,o,n,t){l.arc(0,0,n,0,2*Math.PI,!1),t.fill.apply(l,o),t.hatch.apply(l,o),t.line.apply(l,o)}function d(l,o,n,t){T(l,n),t.fill.apply(l,o),t.hatch.apply(l,o),t.line.apply(l,o)}function _(l,o,n,t){!function(l,o){l.beginPath(),l.arc(0,0,o/4,0,2*Math.PI,!1),l.closePath()}(l,n),t.line.set_vectorize(l,o),l.fillStyle=l.strokeStyle,l.fill()}function P(l,o,n,t){!function(l,o){const n=o/2,t=e*n;l.moveTo(o,0),l.lineTo(n,-t),l.lineTo(-n,-t),l.lineTo(-o,0),l.lineTo(-n,t),l.lineTo(n,t),l.closePath()}(l,n),t.fill.apply(l,o),t.hatch.apply(l,o),t.line.apply(l,o)}function m(l,o,n,t){const i=2*n;l.rect(-n,-n,i,i),t.fill.apply(l,o),t.hatch.apply(l,o),t.line.apply(l,o)}function q(l,o,n,t){!function(l,o){const n=Math.sqrt(5-2*a)*o;l.moveTo(0,-o),l.lineTo(n*r,n*h-o),l.lineTo(n*(1+r),n*h-o),l.lineTo(n*(1+r-c),n*(h+p)-o),l.lineTo(n*(1+2*r-c),n*(2*h+p)-o),l.lineTo(0,2*n*h-o),l.lineTo(-n*(1+2*r-c),n*(2*h+p)-o),l.lineTo(-n*(1+r-c),n*(h+p)-o),l.lineTo(-n*(1+r),n*h-o),l.lineTo(-n*r,n*h-o),l.closePath()}(l,n),t.fill.apply(l,o),t.hatch.apply(l,o),t.line.apply(l,o)}function M(l,o,n,t){y(l,n),t.fill.apply(l,o),t.hatch.apply(l,o),t.line.apply(l,o)}n.marker_funcs={asterisk:function(l,o,n,t){s(l,n),u(l,n),t.line.apply(l,o)},circle:v,circle_cross:function(l,o,n,t){l.arc(0,0,n,0,2*Math.PI,!1),t.fill.apply(l,o),t.hatch.apply(l,o),t.line.doit&&(t.line.set_vectorize(l,o),s(l,n),l.stroke())},circle_dot:function(l,o,n,t){v(l,o,n,t),_(l,o,n,t)},circle_y:function(l,o,n,t){l.arc(0,0,n,0,2*Math.PI,!1),t.fill.apply(l,o),t.hatch.apply(l,o),t.line.doit&&(t.line.set_vectorize(l,o),f(l,n),l.stroke())},circle_x:function(l,o,n,t){l.arc(0,0,n,0,2*Math.PI,!1),t.fill.apply(l,o),t.hatch.apply(l,o),t.line.doit&&(t.line.set_vectorize(l,o),u(l,n),l.stroke())},cross:function(l,o,n,t){s(l,n),t.line.apply(l,o)},diamond:d,diamond_dot:function(l,o,n,t){d(l,o,n,t),_(l,o,n,t)},diamond_cross:function(l,o,n,t){T(l,n),t.fill.apply(l,o),t.hatch.apply(l,o),t.line.doit&&(t.line.set_vectorize(l,o),l.moveTo(0,n),l.lineTo(0,-n),l.moveTo(-n/1.5,0),l.lineTo(n/1.5,0),l.stroke())},dot:_,hex:P,hex_dot:function(l,o,n,t){P(l,o,n,t),_(l,o,n,t)},inverted_triangle:function(l,o,n,t){l.rotate(Math.PI),y(l,n),l.rotate(-Math.PI),t.fill.apply(l,o),t.hatch.apply(l,o),t.line.apply(l,o)},plus:function(l,o,n,t){const i=3*n/8,e=[i,i,n,n,i,i,-i,-i,-n,-n,-i,-i],a=[n,i,i,-i,-i,-n,-n,-i,-i,i,i,n];l.beginPath();for(let o=0;o<12;o++)l.lineTo(e[o],a[o]);l.closePath(),t.fill.apply(l,o),t.hatch.apply(l,o),t.line.apply(l,o)},square:m,square_cross:function(l,o,n,t){const i=2*n;l.rect(-n,-n,i,i),t.fill.apply(l,o),t.hatch.apply(l,o),t.line.doit&&(t.line.set_vectorize(l,o),s(l,n),l.stroke())},square_dot:function(l,o,n,t){m(l,o,n,t),_(l,o,n,t)},square_pin:function(l,o,n,t){const i=3*n/8;l.moveTo(-n,-n),l.quadraticCurveTo(0,-i,n,-n),l.quadraticCurveTo(i,0,n,n),l.quadraticCurveTo(0,i,-n,n),l.quadraticCurveTo(-i,0,-n,-n),l.closePath(),t.fill.apply(l,o),t.hatch.apply(l,o),t.line.apply(l,o)},square_x:function(l,o,n,t){const i=2*n;l.rect(-n,-n,i,i),t.fill.apply(l,o),t.hatch.apply(l,o),t.line.doit&&(t.line.set_vectorize(l,o),l.moveTo(-n,n),l.lineTo(n,-n),l.moveTo(-n,-n),l.lineTo(n,n),l.stroke())},star:q,star_dot:function(l,o,n,t){q(l,o,n,t),_(l,o,n,t)},triangle:M,triangle_dot:function(l,o,n,t){M(l,o,n,t),_(l,o,n,t)},triangle_pin:function(l,o,n,t){const i=n*e,a=i/3,c=3*a/8;l.moveTo(-n,a),l.quadraticCurveTo(0,c,n,a),l.quadraticCurveTo(e*c/2,c/2,0,a-i),l.quadraticCurveTo(-e*c/2,c/2,-n,a),l.closePath(),t.fill.apply(l,o),t.hatch.apply(l,o),t.line.apply(l,o)},dash:function(l,o,n,t){!function(l,o){l.moveTo(-o,0),l.lineTo(o,0)}(l,n),t.line.apply(l,o)},x:function(l,o,n,t){u(l,n),t.line.apply(l,o)},y:function(l,o,n,t){f(l,n),t.line.apply(l,o)}}},
function _(e,t,s,i,n){i();const r=e(1);var o;const _=(0,r.__importStar)(e(185)),h=(0,r.__importStar)(e(18)),c=e(48),a=e(78),d=e(179),x=e(184),l=e(72);class y extends d.GlyphView{_project_data(){a.inplace.project_xy(this._x0,this._y0),a.inplace.project_xy(this._x1,this._y1)}_index_data(e){const{min:t,max:s}=Math,{_x0:i,_x1:n,_y0:r,_y1:o,data_size:_}=this;for(let h=0;h<_;h++){const _=i[h],c=n[h],a=r[h],d=o[h];e.add_rect(t(_,c),t(a,d),s(_,c),s(a,d))}}_render(e,t,s){if(this.visuals.line.doit){const{sx0:i,sy0:n,sx1:r,sy1:o}=null!=s?s:this;for(const s of t){const t=i[s],_=n[s],h=r[s],c=o[s];isFinite(t+_+h+c)&&(e.beginPath(),e.moveTo(t,_),e.lineTo(h,c),this.visuals.line.set_vectorize(e,s),e.stroke())}}}_hit_point(e){const{sx:t,sy:s}=e,i={x:t,y:s},[n,r]=this.renderer.xscale.r_invert(t-2,t+2),[o,h]=this.renderer.yscale.r_invert(s-2,s+2),c=this.index.indices({x0:n,y0:o,x1:r,y1:h}),a=[];for(const e of c){const t=Math.max(2,this.line_width.get(e)/2)**2,s={x:this.sx0[e],y:this.sy0[e]},n={x:this.sx1[e],y:this.sy1[e]};_.dist_to_segment_squared(i,s,n)<t&&a.push(e)}return new l.Selection({indices:a})}_hit_span(e){const[t,s]=this.renderer.plot_view.frame.bbox.ranges,{sx:i,sy:n}=e;let r,o,_;"v"==e.direction?(_=this.renderer.yscale.invert(n),[r,o]=[this._y0,this._y1]):(_=this.renderer.xscale.invert(i),[r,o]=[this._x0,this._x1]);const h=[],[c,a]=this.renderer.xscale.r_invert(t.start,t.end),[d,x]=this.renderer.yscale.r_invert(s.start,s.end),y=this.index.indices({x0:c,y0:d,x1:a,y1:x});for(const t of y){(r[t]<=_&&_<=o[t]||o[t]<=_&&_<=r[t])&&h.push(t);const s=1.5+this.line_width.get(t)/2;r[t]==o[t]&&("h"==e.direction?Math.abs(this.sx0[t]-i)<=s&&h.push(t):Math.abs(this.sy0[t]-n)<=s&&h.push(t))}return new l.Selection({indices:h})}scenterxy(e){return[this.sx0[e]/2+this.sx1[e]/2,this.sy0[e]/2+this.sy1[e]/2]}draw_legend_for_index(e,t,s){(0,x.generic_line_vector_legend)(this.visuals,e,t,s)}}s.SegmentView=y,y.__name__="SegmentView";class p extends d.Glyph{constructor(e){super(e)}}s.Segment=p,o=p,p.__name__="Segment",o.prototype.default_view=y,o.define((({})=>({x0:[h.XCoordinateSpec,{field:"x0"}],y0:[h.YCoordinateSpec,{field:"y0"}],x1:[h.XCoordinateSpec,{field:"x1"}],y1:[h.YCoordinateSpec,{field:"y1"}]}))),o.mixins(c.LineVector)},
function _(t,e,s,i,n){i();const o=t(1);var _;const l=t(178),a=(0,o.__importStar)(t(48)),c=t(296);class r extends l.XYGlyphView{_set_data(){const{tension:t,closed:e}=this.model;[this._xt,this._yt]=(0,c.catmullrom_spline)(this._x,this._y,20,t,e)}_map_data(){const{x_scale:t,y_scale:e}=this.renderer.coordinates;this.sxt=t.v_compute(this._xt),this.syt=e.v_compute(this._yt)}_render(t,e,s){const{sxt:i,syt:n}=null!=s?s:this;let o=!0;t.beginPath();const _=i.length;for(let e=0;e<_;e++){const s=i[e],_=n[e];isFinite(s+_)?o?(t.moveTo(s,_),o=!1):t.lineTo(s,_):o=!0}this.visuals.line.set_value(t),t.stroke()}}s.SplineView=r,r.__name__="SplineView";class h extends l.XYGlyph{constructor(t){super(t)}}s.Spline=h,_=h,h.__name__="Spline",_.prototype.default_view=r,_.mixins(a.LineScalar),_.define((({Boolean:t,Number:e})=>({tension:[e,.5],closed:[t,!1]})))},
function _(n,t,e,o,s){o();const c=n(24),l=n(11);e.catmullrom_spline=function(n,t,e=10,o=.5,s=!1){(0,l.assert)(n.length==t.length);const r=n.length,f=s?r+1:r,w=(0,c.infer_type)(n,t),i=new w(f+2),u=new w(f+2);i.set(n,1),u.set(t,1),s?(i[0]=n[r-1],u[0]=t[r-1],i[f]=n[0],u[f]=t[0],i[f+1]=n[1],u[f+1]=t[1]):(i[0]=n[0],u[0]=t[0],i[f+1]=n[r-1],u[f+1]=t[r-1]);const g=new w(4*(e+1));for(let n=0,t=0;n<=e;n++){const o=n/e,s=o**2,c=o*s;g[t++]=2*c-3*s+1,g[t++]=-2*c+3*s,g[t++]=c-2*s+o,g[t++]=c-s}const h=new w((f-1)*(e+1)),_=new w((f-1)*(e+1));for(let n=1,t=0;n<f;n++){const s=(i[n+1]-i[n-1])*o,c=(u[n+1]-u[n-1])*o,l=(i[n+2]-i[n])*o,r=(u[n+2]-u[n])*o;for(let o=0;o<=4*e;t++){const e=g[o++],f=g[o++],w=g[o++],a=g[o++];h[t]=e*i[n]+f*i[n+1]+w*s+a*l,_[t]=e*u[n]+f*u[n+1]+w*c+a*r}}return[h,_]}},
function _(e,t,n,s,i){s();const o=e(1);var l;const a=e(178),r=e(184),c=(0,o.__importStar)(e(48)),_=e(20),d=e(11);class f extends a.XYGlyphView{_render(e,t,n){const{sx:s,sy:i}=null!=n?n:this;let o=!1,l=null;this.visuals.line.set_value(e);const a=t.length;if(!(a<2)){e.beginPath(),e.moveTo(s[0],i[0]);for(const n of t){let t,a,r,c;switch(this.model.mode){case"before":[t,r]=[s[n-1],i[n]],[a,c]=[s[n],i[n]];break;case"after":[t,r]=[s[n],i[n-1]],[a,c]=[s[n],i[n]];break;case"center":{const e=(s[n-1]+s[n])/2;[t,r]=[e,i[n-1]],[a,c]=[e,i[n]];break}default:(0,d.unreachable)()}if(o){if(!isFinite(s[n]+i[n])){e.stroke(),e.beginPath(),o=!1,l=n;continue}null!=l&&n-l>1&&(e.stroke(),o=!1)}o?(e.lineTo(t,r),e.lineTo(a,c)):(e.beginPath(),e.moveTo(s[n],i[n]),o=!0),l=n}e.lineTo(s[a-1],i[a-1]),e.stroke()}}draw_legend_for_index(e,t,n){(0,r.generic_line_scalar_legend)(this.visuals,e,t)}}n.StepView=f,f.__name__="StepView";class u extends a.XYGlyph{constructor(e){super(e)}}n.Step=u,l=u,u.__name__="Step",l.prototype.default_view=f,l.mixins(c.LineScalar),l.define((()=>({mode:[_.StepMode,"before"]})))},
function _(t,e,s,i,n){i();const o=t(1);var _;const h=t(178),l=t(48),r=(0,o.__importStar)(t(185)),a=(0,o.__importStar)(t(18)),c=t(121),x=t(11),u=t(72);class f extends h.XYGlyphView{_rotate_point(t,e,s,i,n){return[(t-s)*Math.cos(n)-(e-i)*Math.sin(n)+s,(t-s)*Math.sin(n)+(e-i)*Math.cos(n)+i]}_text_bounds(t,e,s,i){return[[t,t+s,t+s,t,t],[e,e,e-i,e-i,e]]}_render(t,e,s){const{sx:i,sy:n,x_offset:o,y_offset:_,angle:h,text:l}=null!=s?s:this;this._sys=[],this._sxs=[];for(const s of e){const e=this._sxs[s]=[],r=this._sys[s]=[],a=i[s],x=n[s],u=o.get(s),f=_.get(s),p=h.get(s),g=l.get(s);if(isFinite(a+x+u+f+p)&&null!=g&&this.visuals.text.doit){const i=`${g}`;t.save(),t.translate(a+u,x+f),t.rotate(p),this.visuals.text.set_vectorize(t,s);const n=this.visuals.text.font_value(s),{height:o}=(0,c.font_metrics)(n),_=this.text_line_height.get(s)*o;if(-1==i.indexOf("\n")){t.fillText(i,0,0);const s=a+u,n=x+f,o=t.measureText(i).width,[h,l]=this._text_bounds(s,n,o,_);e.push(h),r.push(l)}else{const n=i.split("\n"),o=_*n.length,h=this.text_baseline.get(s);let l;switch(h){case"top":l=0;break;case"middle":l=-o/2+_/2;break;case"bottom":l=-o+_;break;default:l=0,console.warn(`'${h}' baseline not supported with multi line text`)}for(const s of n){t.fillText(s,0,l);const i=a+u,n=l+x+f,o=t.measureText(s).width,[h,c]=this._text_bounds(i,n,o,_);e.push(h),r.push(c),l+=_}}t.restore()}}}_hit_point(t){const{sx:e,sy:s}=t,i=[];for(let t=0;t<this._sxs.length;t++){const n=this._sxs[t],o=this._sys[t],_=n.length;for(let h=0,l=_;h<l;h++){const[l,a]=this._rotate_point(e,s,n[_-1][0],o[_-1][0],-this.angle.get(t));r.point_in_poly(l,a,n[h],o[h])&&i.push(t)}}return new u.Selection({indices:i})}scenterxy(t){const e=this._sxs[t],s=this._sys[t];(0,x.assert)(0!=e.length&&0!=s.length);const i=e[0][0],n=s[0][0],o=(e[0][2]+i)/2,_=(s[0][2]+n)/2,[h,l]=this._rotate_point(o,_,i,n,this.angle.get(t));return[h,l]}}s.TextView=f,f.__name__="TextView";class p extends h.XYGlyph{constructor(t){super(t)}}s.Text=p,_=p,p.__name__="Text",_.prototype.default_view=f,_.mixins(l.TextVector),_.define((({})=>({text:[a.NullStringSpec,{field:"text"}],angle:[a.AngleSpec,0],x_offset:[a.NumberSpec,0],y_offset:[a.NumberSpec,0]})))},
function _(t,e,s,i,r){i();const h=t(1);var o;const a=t(277),n=t(24),_=(0,h.__importStar)(t(18));class l extends a.BoxView{async lazy_initialize(){await super.lazy_initialize();const{webgl:e}=this.renderer.plot_view.canvas_view;if(null!=e&&e.regl_wrapper.has_webgl){const{LRTBGL:s}=await Promise.resolve().then((()=>(0,h.__importStar)(t(427))));this.glglyph=new s(e.regl_wrapper,this)}}scenterxy(t){return[this.sx[t],(this.stop[t]+this.sbottom[t])/2]}_lrtb(t){const e=this.width.get(t)/2,s=this._x[t],i=this._top[t],r=this._bottom[t];return[s-e,s+e,Math.max(i,r),Math.min(i,r)]}_map_data(){this.sx=this.renderer.xscale.v_compute(this._x),this.sw=this.sdist(this.renderer.xscale,this._x,this.width,"center"),this.stop=this.renderer.yscale.v_compute(this._top),this.sbottom=this.renderer.yscale.v_compute(this._bottom);const t=this.sx.length;this.sleft=new n.ScreenArray(t),this.sright=new n.ScreenArray(t);for(let e=0;e<t;e++)this.sleft[e]=this.sx[e]-this.sw[e]/2,this.sright[e]=this.sx[e]+this.sw[e]/2;this._clamp_viewport()}}s.VBarView=l,l.__name__="VBarView";class c extends a.Box{constructor(t){super(t)}}s.VBar=c,o=c,c.__name__="VBar",o.prototype.default_view=l,o.define((({})=>({x:[_.XCoordinateSpec,{field:"x"}],bottom:[_.YCoordinateSpec,{value:0}],width:[_.NumberSpec,{value:1}],top:[_.YCoordinateSpec,{field:"top"}]})))},
function _(e,s,t,i,n){i();const r=e(1);var a;const c=e(178),d=e(184),l=e(48),h=e(24),o=e(20),_=(0,r.__importStar)(e(18)),u=e(10),g=e(72),x=e(12);class p extends c.XYGlyphView{_map_data(){"data"==this.model.properties.radius.units?this.sradius=this.sdist(this.renderer.xscale,this._x,this.radius):this.sradius=(0,h.to_screen)(this.radius),this.max_sradius=(0,x.max)(this.sradius)}_render(e,s,t){const{sx:i,sy:n,sradius:r,start_angle:a,end_angle:c}=null!=t?t:this,d="anticlock"==this.model.direction;for(const t of s){const s=i[t],l=n[t],h=r[t],o=a.get(t),_=c.get(t);isFinite(s+l+h+o+_)&&(e.beginPath(),e.arc(s,l,h,o,_,d),e.lineTo(s,l),e.closePath(),this.visuals.fill.apply(e,t),this.visuals.hatch.apply(e,t),this.visuals.line.apply(e,t))}}_hit_point(e){let s,t,i,n,r;const{sx:a,sy:c}=e,d=this.renderer.xscale.invert(a),l=this.renderer.yscale.invert(c);t=a-this.max_sradius,i=a+this.max_sradius;const[h,o]=this.renderer.xscale.r_invert(t,i);n=c-this.max_sradius,r=c+this.max_sradius;const[_,x]=this.renderer.yscale.r_invert(n,r),p=[];for(const e of this.index.indices({x0:h,x1:o,y0:_,y1:x})){const a=this.sradius[e]**2;[t,i]=this.renderer.xscale.r_compute(d,this._x[e]),[n,r]=this.renderer.yscale.r_compute(l,this._y[e]),s=(t-i)**2+(n-r)**2,s<=a&&p.push(e)}const y="anticlock"==this.model.direction,m=[];for(const e of p){const s=Math.atan2(c-this.sy[e],a-this.sx[e]);(0,u.angle_between)(-s,-this.start_angle.get(e),-this.end_angle.get(e),y)&&m.push(e)}return new g.Selection({indices:m})}draw_legend_for_index(e,s,t){(0,d.generic_area_vector_legend)(this.visuals,e,s,t)}scenterxy(e){const s=this.sradius[e]/2,t=(this.start_angle.get(e)+this.end_angle.get(e))/2;return[this.sx[e]+s*Math.cos(t),this.sy[e]+s*Math.sin(t)]}}t.WedgeView=p,p.__name__="WedgeView";class y extends c.XYGlyph{constructor(e){super(e)}}t.Wedge=y,a=y,y.__name__="Wedge",a.prototype.default_view=p,a.mixins([l.LineVector,l.FillVector,l.HatchVector]),a.define((({})=>({direction:[o.Direction,"anticlock"],radius:[_.DistanceSpec,{field:"radius"}],start_angle:[_.AngleSpec,{field:"start_angle"}],end_angle:[_.AngleSpec,{field:"end_angle"}]})))},
function _(t,_,r,o,a){o();const e=t(1);(0,e.__exportStar)(t(302),r),(0,e.__exportStar)(t(303),r),(0,e.__exportStar)(t(304),r)},
function _(e,t,d,n,s){n();const o=e(53),r=e(12),_=e(9),i=e(72);class c extends o.Model{constructor(e){super(e)}_hit_test(e,t,d){if(!t.model.visible)return null;const n=d.glyph.hit_test(e);return null==n?null:d.model.view.convert_selection_from_subset(n)}}d.GraphHitTestPolicy=c,c.__name__="GraphHitTestPolicy";class a extends c{constructor(e){super(e)}hit_test(e,t){return this._hit_test(e,t,t.edge_view)}do_selection(e,t,d,n){if(null==e)return!1;const s=t.edge_renderer.data_source.selected;return s.update(e,d,n),t.edge_renderer.data_source._select.emit(),!s.is_empty()}do_inspection(e,t,d,n,s){if(null==e)return!1;const{edge_renderer:o}=d.model,r=o.get_selection_manager().get_or_create_inspector(d.edge_view.model);return r.update(e,n,s),d.edge_view.model.data_source.setv({inspected:r},{silent:!0}),d.edge_view.model.data_source.inspect.emit([d.edge_view.model,{geometry:t}]),!r.is_empty()}}d.EdgesOnly=a,a.__name__="EdgesOnly";class l extends c{constructor(e){super(e)}hit_test(e,t){return this._hit_test(e,t,t.node_view)}do_selection(e,t,d,n){if(null==e)return!1;const s=t.node_renderer.data_source.selected;return s.update(e,d,n),t.node_renderer.data_source._select.emit(),!s.is_empty()}do_inspection(e,t,d,n,s){if(null==e)return!1;const{node_renderer:o}=d.model,r=o.get_selection_manager().get_or_create_inspector(d.node_view.model);return r.update(e,n,s),d.node_view.model.data_source.setv({inspected:r},{silent:!0}),d.node_view.model.data_source.inspect.emit([d.node_view.model,{geometry:t}]),!r.is_empty()}}d.NodesOnly=l,l.__name__="NodesOnly";class u extends c{constructor(e){super(e)}hit_test(e,t){return this._hit_test(e,t,t.node_view)}get_linked_edges(e,t,d){let n=[];"selection"==d?n=e.selected.indices.map((t=>e.data.index[t])):"inspection"==d&&(n=e.inspected.indices.map((t=>e.data.index[t])));const s=[];for(let e=0;e<t.data.start.length;e++)((0,_.contains)(n,t.data.start[e])||(0,_.contains)(n,t.data.end[e]))&&s.push(e);const o=new i.Selection;for(const e of s)o.multiline_indices[e]=[0];return o.indices=s,o}do_selection(e,t,d,n){if(null==e)return!1;const s=t.node_renderer.data_source.selected;s.update(e,d,n);const o=t.edge_renderer.data_source.selected,r=this.get_linked_edges(t.node_renderer.data_source,t.edge_renderer.data_source,"selection");return o.update(r,d,n),t.node_renderer.data_source._select.emit(),!s.is_empty()}do_inspection(e,t,d,n,s){if(null==e)return!1;const o=d.node_view.model.data_source.selection_manager.get_or_create_inspector(d.node_view.model);o.update(e,n,s),d.node_view.model.data_source.setv({inspected:o},{silent:!0});const r=d.edge_view.model.data_source.selection_manager.get_or_create_inspector(d.edge_view.model),_=this.get_linked_edges(d.node_view.model.data_source,d.edge_view.model.data_source,"inspection");return r.update(_,n,s),d.edge_view.model.data_source.setv({inspected:r},{silent:!0}),d.node_view.model.data_source.inspect.emit([d.node_view.model,{geometry:t}]),!o.is_empty()}}d.NodesAndLinkedEdges=u,u.__name__="NodesAndLinkedEdges";class m extends c{constructor(e){super(e)}hit_test(e,t){return this._hit_test(e,t,t.edge_view)}get_linked_nodes(e,t,d){let n=[];"selection"==d?n=t.selected.indices:"inspection"==d&&(n=t.inspected.indices);const s=[];for(const e of n)s.push(t.data.start[e]),s.push(t.data.end[e]);const o=(0,_.uniq)(s).map((t=>(0,r.indexOf)(e.data.index,t)));return new i.Selection({indices:o})}do_selection(e,t,d,n){if(null==e)return!1;const s=t.edge_renderer.data_source.selected;s.update(e,d,n);const o=t.node_renderer.data_source.selected,r=this.get_linked_nodes(t.node_renderer.data_source,t.edge_renderer.data_source,"selection");return o.update(r,d,n),t.edge_renderer.data_source._select.emit(),!s.is_empty()}do_inspection(e,t,d,n,s){if(null==e)return!1;const o=d.edge_view.model.data_source.selection_manager.get_or_create_inspector(d.edge_view.model);o.update(e,n,s),d.edge_view.model.data_source.setv({inspected:o},{silent:!0});const r=d.node_view.model.data_source.selection_manager.get_or_create_inspector(d.node_view.model),_=this.get_linked_nodes(d.node_view.model.data_source,d.edge_view.model.data_source,"inspection");return r.update(_,n,s),d.node_view.model.data_source.setv({inspected:r},{silent:!0}),d.edge_view.model.data_source.inspect.emit([d.edge_view.model,{geometry:t}]),!o.is_empty()}}d.EdgesAndLinkedNodes=m,m.__name__="EdgesAndLinkedNodes"},
function _(e,o,t,r,n){var s;r();const a=e(53),d=e(260);class _ extends a.Model{constructor(e){super(e)}get node_coordinates(){return new u({layout:this})}get edge_coordinates(){return new i({layout:this})}}t.LayoutProvider=_,_.__name__="LayoutProvider";class c extends d.CoordinateTransform{constructor(e){super(e)}}t.GraphCoordinates=c,s=c,c.__name__="GraphCoordinates",s.define((({Ref:e})=>({layout:[e(_)]})));class u extends c{constructor(e){super(e)}_v_compute(e){const[o,t]=this.layout.get_node_coordinates(e);return{x:o,y:t}}}t.NodeCoordinates=u,u.__name__="NodeCoordinates";class i extends c{constructor(e){super(e)}_v_compute(e){const[o,t]=this.layout.get_edge_coordinates(e);return{x:o,y:t}}}t.EdgeCoordinates=i,i.__name__="EdgeCoordinates"},
function _(t,a,l,e,n){var o;e();const r=t(303);class u extends r.LayoutProvider{constructor(t){super(t)}get_node_coordinates(t){var a;const l=null!==(a=t.data.index)&&void 0!==a?a:[],e=l.length,n=new Float64Array(e),o=new Float64Array(e);for(let t=0;t<e;t++){const a=this.graph_layout[l[t]],[e,r]=null!=a?a:[NaN,NaN];n[t]=e,o[t]=r}return[n,o]}get_edge_coordinates(t){var a,l;const e=null!==(a=t.data.start)&&void 0!==a?a:[],n=null!==(l=t.data.end)&&void 0!==l?l:[],o=Math.min(e.length,n.length),r=[],u=[],s=null!=t.data.xs&&null!=t.data.ys;for(let a=0;a<o;a++){const l=null!=this.graph_layout[e[a]]&&null!=this.graph_layout[n[a]];if(s&&l)r.push(t.data.xs[a]),u.push(t.data.ys[a]);else{let t,o;l?(t=this.graph_layout[e[a]],o=this.graph_layout[n[a]]):(t=[NaN,NaN],o=[NaN,NaN]),r.push([t[0],o[0]]),u.push([t[1],o[1]])}}return[r,u]}}l.StaticLayoutProvider=u,o=u,u.__name__="StaticLayoutProvider",o.define((({Number:t,Tuple:a,Dict:l})=>({graph_layout:[l(a(t,t)),{}]})))},
function _(i,d,n,r,G){r(),G("Grid",i(306).Grid)},
function _(i,e,n,s,t){s();const r=i(1);var o;const d=i(127),_=i(129),a=i(130),l=(0,r.__importStar)(i(48)),h=i(8);class c extends _.GuideRendererView{_render(){const i=this.layer.ctx;i.save(),this._draw_regions(i),this._draw_minor_grids(i),this._draw_grids(i),i.restore()}connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>this.request_render()))}_draw_regions(i){if(!this.visuals.band_fill.doit&&!this.visuals.band_hatch.doit)return;const[e,n]=this.grid_coords("major",!1);for(let s=0;s<e.length-1;s++){if(s%2!=1)continue;const[t,r]=this.coordinates.map_to_screen(e[s],n[s]),[o,d]=this.coordinates.map_to_screen(e[s+1],n[s+1]);i.beginPath(),i.rect(t[0],r[0],o[1]-t[0],d[1]-r[0]),this.visuals.band_fill.apply(i),this.visuals.band_hatch.apply(i)}}_draw_grids(i){if(!this.visuals.grid_line.doit)return;const[e,n]=this.grid_coords("major");this._draw_grid_helper(i,this.visuals.grid_line,e,n)}_draw_minor_grids(i){if(!this.visuals.minor_grid_line.doit)return;const[e,n]=this.grid_coords("minor");this._draw_grid_helper(i,this.visuals.minor_grid_line,e,n)}_draw_grid_helper(i,e,n,s){e.set_value(i),i.beginPath();for(let e=0;e<n.length;e++){const[t,r]=this.coordinates.map_to_screen(n[e],s[e]);i.moveTo(Math.round(t[0]),Math.round(r[0]));for(let e=1;e<t.length;e++)i.lineTo(Math.round(t[e]),Math.round(r[e]))}i.stroke()}ranges(){const i=this.model.dimension,e=(i+1)%2,{ranges:n}=this.coordinates;return[n[i],n[e]]}computed_bounds(){const[i]=this.ranges(),e=this.model.bounds,n=[i.min,i.max];let s,t;if((0,h.isArray)(e))s=Math.min(e[0],e[1]),t=Math.max(e[0],e[1]),s<n[0]&&(s=n[0]),t>n[1]&&(t=n[1]);else{[s,t]=n;for(const i of this.plot_view.axis_views)i.dimension==this.model.dimension&&i.model.x_range_name==this.model.x_range_name&&i.model.y_range_name==this.model.y_range_name&&([s,t]=i.computed_bounds)}return[s,t]}grid_coords(i,e=!0){const n=this.model.dimension,s=(n+1)%2,[t,r]=this.ranges();let[o,d]=this.computed_bounds();[o,d]=[Math.min(o,d),Math.max(o,d)];const _=[[],[]],a=this.model.get_ticker();if(null==a)return _;const l=a.get_ticks(o,d,t,r.min)[i],h=t.min,c=t.max,u=r.min,m=r.max;e||(l[0]!=h&&l.splice(0,0,h),l[l.length-1]!=c&&l.push(c));for(let i=0;i<l.length;i++){if((l[i]==h||l[i]==c)&&e)continue;const t=[],r=[],o=2;for(let e=0;e<o;e++){const n=u+(m-u)/(o-1)*e;t.push(l[i]),r.push(n)}_[n].push(t),_[s].push(r)}return _}}n.GridView=c,c.__name__="GridView";class u extends _.GuideRenderer{constructor(i){super(i)}get_ticker(){return null!=this.ticker?this.ticker:null!=this.axis?this.axis.ticker:null}}n.Grid=u,o=u,u.__name__="Grid",o.prototype.default_view=c,o.mixins([["grid_",l.Line],["minor_grid_",l.Line],["band_",l.Fill],["band_",l.Hatch]]),o.define((({Number:i,Auto:e,Enum:n,Ref:s,Tuple:t,Or:r,Nullable:o})=>({bounds:[r(t(i,i),e),"auto"],dimension:[n(0,1),0],axis:[o(s(d.Axis)),null],ticker:[o(s(a.Ticker)),null]}))),o.override({level:"underlay",band_fill_color:null,band_fill_alpha:0,grid_line_color:"#e5e5e5",minor_grid_line_color:null})},
function _(o,a,x,B,e){B(),e("Box",o(308).Box),e("Column",o(310).Column),e("GridBox",o(311).GridBox),e("HTMLBox",o(312).HTMLBox),e("LayoutDOM",o(309).LayoutDOM),e("Panel",o(313).Panel),e("Row",o(314).Row),e("Spacer",o(315).Spacer),e("Tabs",o(316).Tabs),e("WidgetBox",o(319).WidgetBox)},
function _(e,n,s,t,c){var i;t();const o=e(309);class r extends o.LayoutDOMView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.children.change,(()=>this.rebuild()))}get child_models(){return this.model.children}}s.BoxView=r,r.__name__="BoxView";class a extends o.LayoutDOM{constructor(e){super(e)}}s.Box=a,i=a,a.__name__="Box",i.define((({Number:e,Array:n,Ref:s})=>({children:[n(s(o.LayoutDOM)),[]],spacing:[e,0]})))},
function _(t,i,e,s,o){var l;s();const n=t(53),h=t(20),a=t(43),r=t(19),_=t(8),c=t(22),u=t(121),d=t(113),p=t(226),m=t(207),g=t(44),w=t(235);class f extends p.DOMView{constructor(){super(...arguments),this._offset_parent=null,this._viewport={}}get is_layout_root(){return this.is_root||!(this.parent instanceof f)}get base_font_size(){const t=getComputedStyle(this.el).fontSize,i=(0,u.parse_css_font_size)(t);if(null!=i){const{value:t,unit:e}=i;if("px"==e)return t}return null}initialize(){super.initialize(),this.el.style.position=this.is_layout_root?"relative":"absolute",this._child_views=new Map}async lazy_initialize(){await super.lazy_initialize(),await this.build_child_views()}remove(){for(const t of this.child_views)t.remove();this._child_views.clear(),super.remove()}connect_signals(){super.connect_signals(),this.is_layout_root&&(this._on_resize=()=>this.resize_layout(),window.addEventListener("resize",this._on_resize),this._parent_observer=setInterval((()=>{const t=this.el.offsetParent;this._offset_parent!=t&&(this._offset_parent=t,null!=t&&(this.compute_viewport(),this.invalidate_layout()))}),250));const t=this.model.properties;this.on_change([t.width,t.height,t.min_width,t.min_height,t.max_width,t.max_height,t.margin,t.width_policy,t.height_policy,t.sizing_mode,t.aspect_ratio,t.visible],(()=>this.invalidate_layout())),this.on_change([t.background,t.css_classes],(()=>this.invalidate_render()))}disconnect_signals(){null!=this._parent_observer&&clearTimeout(this._parent_observer),null!=this._on_resize&&window.removeEventListener("resize",this._on_resize),super.disconnect_signals()}css_classes(){return super.css_classes().concat(this.model.css_classes)}get child_views(){return this.child_models.map((t=>this._child_views.get(t)))}async build_child_views(){await(0,d.build_views)(this._child_views,this.child_models,{parent:this})}render(){super.render(),(0,a.empty)(this.el);const{background:t}=this.model;this.el.style.backgroundColor=null!=t?(0,c.color2css)(t):"",(0,a.classes)(this.el).clear().add(...this.css_classes());for(const t of this.child_views)this.el.appendChild(t.el),t.render()}update_layout(){for(const t of this.child_views)t.update_layout();this._update_layout()}update_position(){this.el.style.display=this.model.visible?"block":"none";const t=this.is_layout_root?this.layout.sizing.margin:void 0;(0,a.position)(this.el,this.layout.bbox,t);for(const t of this.child_views)t.update_position()}after_layout(){for(const t of this.child_views)t.after_layout();this._has_finished=!0}compute_viewport(){this._viewport=this._viewport_size()}renderTo(t){t.appendChild(this.el),this._offset_parent=this.el.offsetParent,this.compute_viewport(),this.build(),this.notify_finished()}build(){if(!this.is_layout_root)throw new Error(`${this.toString()} is not a root layout`);return this.render(),this.update_layout(),this.compute_layout(),this}async rebuild(){await this.build_child_views(),this.invalidate_render()}compute_layout(){const t=Date.now();this.layout.compute(this._viewport),this.update_position(),this.after_layout(),r.logger.debug(`layout computed in ${Date.now()-t} ms`)}resize_layout(){this.root.compute_viewport(),this.root.compute_layout()}invalidate_layout(){this.root.update_layout(),this.root.compute_layout()}invalidate_render(){this.render(),this.invalidate_layout()}has_finished(){if(!super.has_finished())return!1;for(const t of this.child_views)if(!t.has_finished())return!1;return!0}_width_policy(){return null!=this.model.width?"fixed":"fit"}_height_policy(){return null!=this.model.height?"fixed":"fit"}box_sizing(){let{width_policy:t,height_policy:i,aspect_ratio:e}=this.model;"auto"==t&&(t=this._width_policy()),"auto"==i&&(i=this._height_policy());const{sizing_mode:s}=this.model;if(null!=s)if("fixed"==s)t=i="fixed";else if("stretch_both"==s)t=i="max";else if("stretch_width"==s)t="max";else if("stretch_height"==s)i="max";else switch(null==e&&(e="auto"),s){case"scale_width":t="max",i="min";break;case"scale_height":t="min",i="max";break;case"scale_both":t="max",i="max"}const o={width_policy:t,height_policy:i},{min_width:l,min_height:n}=this.model;null!=l&&(o.min_width=l),null!=n&&(o.min_height=n);const{width:h,height:a}=this.model;null!=h&&(o.width=h),null!=a&&(o.height=a);const{max_width:r,max_height:c}=this.model;null!=r&&(o.max_width=r),null!=c&&(o.max_height=c),"auto"==e&&null!=h&&null!=a?o.aspect=h/a:(0,_.isNumber)(e)&&(o.aspect=e);const{margin:u}=this.model;if(null!=u)if((0,_.isNumber)(u))o.margin={top:u,right:u,bottom:u,left:u};else if(2==u.length){const[t,i]=u;o.margin={top:t,right:i,bottom:t,left:i}}else{const[t,i,e,s]=u;o.margin={top:t,right:i,bottom:e,left:s}}o.visible=this.model.visible;const{align:d}=this.model;return(0,_.isArray)(d)?[o.halign,o.valign]=d:o.halign=o.valign=d,o}_viewport_size(){return(0,a.undisplayed)(this.el,(()=>{let t=this.el;for(;t=t.parentElement;){if(t.classList.contains(g.root))continue;if(t==document.body){const{margin:{left:t,right:i,top:e,bottom:s}}=(0,a.extents)(document.body);return{width:Math.ceil(document.documentElement.clientWidth-t-i),height:Math.ceil(document.documentElement.clientHeight-e-s)}}const{padding:{left:i,right:e,top:s,bottom:o}}=(0,a.extents)(t),{width:l,height:n}=t.getBoundingClientRect(),h=Math.ceil(l-i-e),r=Math.ceil(n-s-o);if(h>0||r>0)return{width:h>0?h:void 0,height:r>0?r:void 0}}return{}}))}export(t,i=!0){const e="png"==t?"canvas":"svg",s=new w.CanvasLayer(e,i),{width:o,height:l}=this.layout.bbox;s.resize(o,l);for(const e of this.child_views){const o=e.export(t,i),{x:l,y:n}=e.layout.bbox;s.ctx.drawImage(o.canvas,l,n)}return s}serializable_state(){return Object.assign(Object.assign({},super.serializable_state()),{bbox:this.layout.bbox.box,children:this.child_views.map((t=>t.serializable_state()))})}}e.LayoutDOMView=f,f.__name__="LayoutDOMView";class y extends n.Model{constructor(t){super(t)}}e.LayoutDOM=y,l=y,y.__name__="LayoutDOM",l.define((t=>{const{Boolean:i,Number:e,String:s,Auto:o,Color:l,Array:n,Tuple:a,Or:r,Null:_,Nullable:c}=t,u=a(e,e),d=a(e,e,e,e);return{width:[c(e),null],height:[c(e),null],min_width:[c(e),null],min_height:[c(e),null],max_width:[c(e),null],max_height:[c(e),null],margin:[c(r(e,u,d)),[0,0,0,0]],width_policy:[r(m.SizingPolicy,o),"auto"],height_policy:[r(m.SizingPolicy,o),"auto"],aspect_ratio:[r(e,o,_),null],sizing_mode:[c(h.SizingMode),null],visible:[i,!0],disabled:[i,!1],align:[r(h.Align,a(h.Align,h.Align)),"start"],background:[c(l),null],css_classes:[n(s),[]]}}))},
function _(o,s,t,i,e){var n;i();const a=o(308),l=o(209);class u extends a.BoxView{_update_layout(){const o=this.child_views.map((o=>o.layout));this.layout=new l.Column(o),this.layout.rows=this.model.rows,this.layout.spacing=[this.model.spacing,0],this.layout.set_sizing(this.box_sizing())}}t.ColumnView=u,u.__name__="ColumnView";class _ extends a.Box{constructor(o){super(o)}}t.Column=_,n=_,_.__name__="Column",n.prototype.default_view=u,n.define((({Any:o})=>({rows:[o,"auto"]})))},
function _(s,o,t,i,e){var n;i();const l=s(309),a=s(209);class r extends l.LayoutDOMView{connect_signals(){super.connect_signals();const{children:s,rows:o,cols:t,spacing:i}=this.model.properties;this.on_change([s,o,t,i],(()=>this.rebuild()))}get child_models(){return this.model.children.map((([s])=>s))}_update_layout(){this.layout=new a.Grid,this.layout.rows=this.model.rows,this.layout.cols=this.model.cols,this.layout.spacing=this.model.spacing;for(const[s,o,t,i,e]of this.model.children){const n=this._child_views.get(s);this.layout.items.push({layout:n.layout,row:o,col:t,row_span:i,col_span:e})}this.layout.set_sizing(this.box_sizing())}}t.GridBoxView=r,r.__name__="GridBoxView";class c extends l.LayoutDOM{constructor(s){super(s)}}t.GridBox=c,n=c,c.__name__="GridBox",n.prototype.default_view=r,n.define((({Any:s,Int:o,Number:t,Tuple:i,Array:e,Ref:n,Or:a,Opt:r})=>({children:[e(i(n(l.LayoutDOM),o,o,r(o),r(o))),[]],rows:[s,"auto"],cols:[s,"auto"],spacing:[a(t,i(t,t)),0]})))},
function _(t,e,o,s,n){s();const _=t(309),i=t(207);class a extends _.LayoutDOMView{get child_models(){return[]}_update_layout(){this.layout=new i.ContentBox(this.el),this.layout.set_sizing(this.box_sizing())}}o.HTMLBoxView=a,a.__name__="HTMLBoxView";class u extends _.LayoutDOM{constructor(t){super(t)}}o.HTMLBox=u,u.__name__="HTMLBox"},
function _(e,n,l,a,o){var t;a();const s=e(53),c=e(309);class d extends s.Model{constructor(e){super(e)}}l.Panel=d,t=d,d.__name__="Panel",t.define((({Boolean:e,String:n,Ref:l})=>({title:[n,""],child:[l(c.LayoutDOM)],closable:[e,!1],disabled:[e,!1]})))},
function _(o,s,t,i,e){var a;i();const n=o(308),l=o(209);class _ extends n.BoxView{_update_layout(){const o=this.child_views.map((o=>o.layout));this.layout=new l.Row(o),this.layout.cols=this.model.cols,this.layout.spacing=[0,this.model.spacing],this.layout.set_sizing(this.box_sizing())}}t.RowView=_,_.__name__="RowView";class c extends n.Box{constructor(o){super(o)}}t.Row=c,a=c,c.__name__="Row",a.prototype.default_view=_,a.define((({Any:o})=>({cols:[o,"auto"]})))},
function _(e,t,a,s,_){var o;s();const i=e(309),n=e(207);class u extends i.LayoutDOMView{get child_models(){return[]}_update_layout(){this.layout=new n.LayoutItem,this.layout.set_sizing(this.box_sizing())}}a.SpacerView=u,u.__name__="SpacerView";class c extends i.LayoutDOM{constructor(e){super(e)}}a.Spacer=c,o=c,c.__name__="Spacer",o.prototype.default_view=u},
function _(e,t,s,i,l){i();const h=e(1);var a;const o=e(207),d=e(43),r=e(9),c=e(10),n=e(20),_=e(309),p=e(313),b=(0,h.__importStar)(e(317)),m=b,u=(0,h.__importStar)(e(318)),g=u,v=(0,h.__importStar)(e(229)),w=v;class f extends _.LayoutDOMView{constructor(){super(...arguments),this._scroll_index=0}connect_signals(){super.connect_signals(),this.connect(this.model.properties.tabs.change,(()=>this.rebuild())),this.connect(this.model.properties.active.change,(()=>this.on_active_change()))}styles(){return[...super.styles(),u.default,v.default,b.default]}get child_models(){return this.model.tabs.map((e=>e.child))}_update_layout(){const e=this.model.tabs_location,t="above"==e||"below"==e,{scroll_el:s,headers_el:i}=this;this.header=new class extends o.ContentBox{_measure(e){const l=(0,d.size)(s),h=(0,d.children)(i).slice(0,3).map((e=>(0,d.size)(e))),{width:a,height:o}=super._measure(e);if(t){const t=l.width+(0,r.sum)(h.map((e=>e.width)));return{width:e.width!=1/0?e.width:t,height:o}}{const t=l.height+(0,r.sum)(h.map((e=>e.height)));return{width:a,height:e.height!=1/0?e.height:t}}}}(this.header_el),t?this.header.set_sizing({width_policy:"fit",height_policy:"fixed"}):this.header.set_sizing({width_policy:"fixed",height_policy:"fit"});let l=1,h=1;switch(e){case"above":l-=1;break;case"below":l+=1;break;case"left":h-=1;break;case"right":h+=1}const a={layout:this.header,row:l,col:h},c=this.child_views.map((e=>({layout:e.layout,row:1,col:1})));this.layout=new o.Grid([a,...c]),this.layout.set_sizing(this.box_sizing())}update_position(){super.update_position(),this.header_el.style.position="absolute",(0,d.position)(this.header_el,this.header.bbox);const e=this.model.tabs_location,t="above"==e||"below"==e,s=(0,d.size)(this.scroll_el),i=(0,d.scroll_size)(this.headers_el);if(t){const{width:e}=this.header.bbox;i.width>e?(this.wrapper_el.style.maxWidth=e-s.width+"px",(0,d.display)(this.scroll_el),this.do_scroll(this.model.active)):(this.wrapper_el.style.maxWidth="",(0,d.undisplay)(this.scroll_el))}else{const{height:e}=this.header.bbox;i.height>e?(this.wrapper_el.style.maxHeight=e-s.height+"px",(0,d.display)(this.scroll_el),this.do_scroll(this.model.active)):(this.wrapper_el.style.maxHeight="",(0,d.undisplay)(this.scroll_el))}const{child_views:l}=this;for(const e of l)(0,d.hide)(e.el);const h=l[this.model.active];null!=h&&(0,d.show)(h.el)}render(){super.render();const{active:e}=this.model,t=this.model.tabs.map(((t,s)=>{const i=(0,d.div)({class:[m.tab,s==e?m.active:null]},t.title);if(i.addEventListener("click",(e=>{this.model.disabled||e.target==e.currentTarget&&this.change_active(s)})),t.closable){const e=(0,d.div)({class:m.close});e.addEventListener("click",(e=>{if(e.target==e.currentTarget){this.model.tabs=(0,r.remove_at)(this.model.tabs,s);const e=this.model.tabs.length;this.model.active>e-1&&(this.model.active=e-1)}})),i.appendChild(e)}return(this.model.disabled||t.disabled)&&i.classList.add(m.disabled),i}));this.headers_el=(0,d.div)({class:[m.headers]},t),this.wrapper_el=(0,d.div)({class:m.headers_wrapper},this.headers_el),this.left_el=(0,d.div)({class:[g.btn,g.btn_default],disabled:""},(0,d.div)({class:[w.caret,m.left]})),this.right_el=(0,d.div)({class:[g.btn,g.btn_default]},(0,d.div)({class:[w.caret,m.right]})),this.left_el.addEventListener("click",(()=>this.do_scroll("left"))),this.right_el.addEventListener("click",(()=>this.do_scroll("right"))),this.scroll_el=(0,d.div)({class:g.btn_group},this.left_el,this.right_el);const s=this.model.tabs_location;this.header_el=(0,d.div)({class:[m.tabs_header,m[s]]},this.scroll_el,this.wrapper_el),this.el.appendChild(this.header_el)}do_scroll(e){const t=this.model.tabs.length;"left"==e?this._scroll_index-=1:"right"==e?this._scroll_index+=1:this._scroll_index=e,this._scroll_index=(0,c.clamp)(this._scroll_index,0,t-1),0==this._scroll_index?this.left_el.setAttribute("disabled",""):this.left_el.removeAttribute("disabled"),this._scroll_index==t-1?this.right_el.setAttribute("disabled",""):this.right_el.removeAttribute("disabled");const s=(0,d.children)(this.headers_el).slice(0,this._scroll_index).map((e=>e.getBoundingClientRect())),i=this.model.tabs_location;if("above"==i||"below"==i){const e=-(0,r.sum)(s.map((e=>e.width)));this.headers_el.style.left=`${e}px`}else{const e=-(0,r.sum)(s.map((e=>e.height)));this.headers_el.style.top=`${e}px`}}change_active(e){e!=this.model.active&&(this.model.active=e)}on_active_change(){const e=this.model.active,t=(0,d.children)(this.headers_el);for(const e of t)e.classList.remove(m.active);t[e].classList.add(m.active);const{child_views:s}=this;for(const e of s)(0,d.hide)(e.el);(0,d.show)(s[e].el)}}s.TabsView=f,f.__name__="TabsView";class x extends _.LayoutDOM{constructor(e){super(e)}}s.Tabs=x,a=x,x.__name__="Tabs",a.prototype.default_view=f,a.define((({Int:e,Array:t,Ref:s})=>({tabs:[t(s(p.Panel)),[]],tabs_location:[n.Location,"above"],active:[e,0]})))},
function _(e,r,b,o,t){o(),b.root="bk-root",b.tabs_header="bk-tabs-header",b.btn_group="bk-btn-group",b.btn="bk-btn",b.headers_wrapper="bk-headers-wrapper",b.above="bk-above",b.right="bk-right",b.below="bk-below",b.left="bk-left",b.headers="bk-headers",b.tab="bk-tab",b.active="bk-active",b.close="bk-close",b.disabled="bk-disabled",b.default='.bk-root .bk-tabs-header{display:flex;flex-wrap:nowrap;align-items:center;overflow:hidden;user-select:none;-ms-user-select:none;-moz-user-select:none;-webkit-user-select:none;}.bk-root .bk-tabs-header .bk-btn-group{height:auto;margin-right:5px;}.bk-root .bk-tabs-header .bk-btn-group > .bk-btn{flex-grow:0;height:auto;padding:4px 4px;}.bk-root .bk-tabs-header .bk-headers-wrapper{flex-grow:1;overflow:hidden;color:#666666;}.bk-root .bk-tabs-header.bk-above .bk-headers-wrapper{border-bottom:1px solid #e6e6e6;}.bk-root .bk-tabs-header.bk-right .bk-headers-wrapper{border-left:1px solid #e6e6e6;}.bk-root .bk-tabs-header.bk-below .bk-headers-wrapper{border-top:1px solid #e6e6e6;}.bk-root .bk-tabs-header.bk-left .bk-headers-wrapper{border-right:1px solid #e6e6e6;}.bk-root .bk-tabs-header.bk-above,.bk-root .bk-tabs-header.bk-below{flex-direction:row;}.bk-root .bk-tabs-header.bk-above .bk-headers,.bk-root .bk-tabs-header.bk-below .bk-headers{flex-direction:row;}.bk-root .bk-tabs-header.bk-left,.bk-root .bk-tabs-header.bk-right{flex-direction:column;}.bk-root .bk-tabs-header.bk-left .bk-headers,.bk-root .bk-tabs-header.bk-right .bk-headers{flex-direction:column;}.bk-root .bk-tabs-header .bk-headers{position:relative;display:flex;flex-wrap:nowrap;align-items:center;}.bk-root .bk-tabs-header .bk-tab{padding:4px 8px;border:solid transparent;white-space:nowrap;cursor:pointer;}.bk-root .bk-tabs-header .bk-tab:hover{background-color:#f2f2f2;}.bk-root .bk-tabs-header .bk-tab.bk-active{color:#4d4d4d;background-color:white;border-color:#e6e6e6;}.bk-root .bk-tabs-header .bk-tab .bk-close{margin-left:10px;}.bk-root .bk-tabs-header .bk-tab.bk-disabled{cursor:not-allowed;pointer-events:none;opacity:0.65;}.bk-root .bk-tabs-header.bk-above .bk-tab{border-width:3px 1px 0px 1px;border-radius:4px 4px 0 0;}.bk-root .bk-tabs-header.bk-right .bk-tab{border-width:1px 3px 1px 0px;border-radius:0 4px 4px 0;}.bk-root .bk-tabs-header.bk-below .bk-tab{border-width:0px 1px 3px 1px;border-radius:0 0 4px 4px;}.bk-root .bk-tabs-header.bk-left .bk-tab{border-width:1px 0px 1px 3px;border-radius:4px 0 0 4px;}.bk-root .bk-close{display:inline-block;width:10px;height:10px;vertical-align:middle;background-image:url(\'data:image/svg+xml;utf8,      <svg viewPort="0 0 10 10" version="1.1" xmlns="http://www.w3.org/2000/svg">        <line x1="1" y1="9" x2="9" y2="1" stroke="gray" stroke-width="2"/>        <line x1="1" y1="1" x2="9" y2="9" stroke="gray" stroke-width="2"/>      </svg>\');}.bk-root .bk-close:hover{background-image:url(\'data:image/svg+xml;utf8,      <svg viewPort="0 0 10 10" version="1.1" xmlns="http://www.w3.org/2000/svg">        <line x1="1" y1="9" x2="9" y2="1" stroke="red" stroke-width="2"/>        <line x1="1" y1="1" x2="9" y2="9" stroke="red" stroke-width="2"/>      </svg>\');}'},
function _(o,b,r,t,e){t(),r.root="bk-root",r.btn="bk-btn",r.active="bk-active",r.btn_default="bk-btn-default",r.btn_primary="bk-btn-primary",r.btn_success="bk-btn-success",r.btn_warning="bk-btn-warning",r.btn_danger="bk-btn-danger",r.btn_light="bk-btn-light",r.btn_group="bk-btn-group",r.vertical="bk-vertical",r.horizontal="bk-horizontal",r.dropdown_toggle="bk-dropdown-toggle",r.default=".bk-root .bk-btn{height:100%;display:inline-block;text-align:center;vertical-align:middle;white-space:nowrap;cursor:pointer;padding:6px 12px;font-size:12px;border:1px solid transparent;border-radius:4px;outline:0;user-select:none;-ms-user-select:none;-moz-user-select:none;-webkit-user-select:none;}.bk-root .bk-btn:hover,.bk-root .bk-btn:focus{text-decoration:none;}.bk-root .bk-btn:active,.bk-root .bk-btn.bk-active{background-image:none;box-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);}.bk-root .bk-btn[disabled]{cursor:not-allowed;pointer-events:none;opacity:0.65;box-shadow:none;}.bk-root .bk-btn-default{color:#333;background-color:#fff;border-color:#ccc;}.bk-root .bk-btn-default:hover{background-color:#f5f5f5;border-color:#b8b8b8;}.bk-root .bk-btn-default.bk-active{background-color:#ebebeb;border-color:#adadad;}.bk-root .bk-btn-default[disabled],.bk-root .bk-btn-default[disabled]:hover,.bk-root .bk-btn-default[disabled]:focus,.bk-root .bk-btn-default[disabled]:active,.bk-root .bk-btn-default[disabled].bk-active{background-color:#e6e6e6;border-color:#ccc;}.bk-root .bk-btn-primary{color:#fff;background-color:#428bca;border-color:#357ebd;}.bk-root .bk-btn-primary:hover{background-color:#3681c1;border-color:#2c699e;}.bk-root .bk-btn-primary.bk-active{background-color:#3276b1;border-color:#285e8e;}.bk-root .bk-btn-primary[disabled],.bk-root .bk-btn-primary[disabled]:hover,.bk-root .bk-btn-primary[disabled]:focus,.bk-root .bk-btn-primary[disabled]:active,.bk-root .bk-btn-primary[disabled].bk-active{background-color:#506f89;border-color:#357ebd;}.bk-root .bk-btn-success{color:#fff;background-color:#5cb85c;border-color:#4cae4c;}.bk-root .bk-btn-success:hover{background-color:#4eb24e;border-color:#409240;}.bk-root .bk-btn-success.bk-active{background-color:#47a447;border-color:#398439;}.bk-root .bk-btn-success[disabled],.bk-root .bk-btn-success[disabled]:hover,.bk-root .bk-btn-success[disabled]:focus,.bk-root .bk-btn-success[disabled]:active,.bk-root .bk-btn-success[disabled].bk-active{background-color:#667b66;border-color:#4cae4c;}.bk-root .bk-btn-warning{color:#fff;background-color:#f0ad4e;border-color:#eea236;}.bk-root .bk-btn-warning:hover{background-color:#eea43b;border-color:#e89014;}.bk-root .bk-btn-warning.bk-active{background-color:#ed9c28;border-color:#d58512;}.bk-root .bk-btn-warning[disabled],.bk-root .bk-btn-warning[disabled]:hover,.bk-root .bk-btn-warning[disabled]:focus,.bk-root .bk-btn-warning[disabled]:active,.bk-root .bk-btn-warning[disabled].bk-active{background-color:#c89143;border-color:#eea236;}.bk-root .bk-btn-danger{color:#fff;background-color:#d9534f;border-color:#d43f3a;}.bk-root .bk-btn-danger:hover{background-color:#d5433e;border-color:#bd2d29;}.bk-root .bk-btn-danger.bk-active{background-color:#d2322d;border-color:#ac2925;}.bk-root .bk-btn-danger[disabled],.bk-root .bk-btn-danger[disabled]:hover,.bk-root .bk-btn-danger[disabled]:focus,.bk-root .bk-btn-danger[disabled]:active,.bk-root .bk-btn-danger[disabled].bk-active{background-color:#a55350;border-color:#d43f3a;}.bk-root .bk-btn-light{color:#333;background-color:#fff;border-color:#ccc;border-color:transparent;}.bk-root .bk-btn-light:hover{background-color:#f5f5f5;border-color:#b8b8b8;}.bk-root .bk-btn-light.bk-active{background-color:#ebebeb;border-color:#adadad;}.bk-root .bk-btn-light[disabled],.bk-root .bk-btn-light[disabled]:hover,.bk-root .bk-btn-light[disabled]:focus,.bk-root .bk-btn-light[disabled]:active,.bk-root .bk-btn-light[disabled].bk-active{background-color:#e6e6e6;border-color:#ccc;}.bk-root .bk-btn-group{height:100%;display:flex;flex-wrap:nowrap;align-items:center;}.bk-root .bk-btn-group:not(.bk-vertical),.bk-root .bk-btn-group.bk-horizontal{flex-direction:row;}.bk-root .bk-btn-group.bk-vertical{flex-direction:column;}.bk-root .bk-btn-group > .bk-btn{flex-grow:1;}.bk-root .bk-btn-group:not(.bk-vertical) > .bk-btn + .bk-btn{margin-left:-1px;}.bk-root .bk-btn-group.bk-vertical > .bk-btn + .bk-btn{margin-top:-1px;}.bk-root .bk-btn-group:not(.bk-vertical) > .bk-btn:first-child:not(:last-child){border-bottom-right-radius:0;border-top-right-radius:0;}.bk-root .bk-btn-group.bk-vertical > .bk-btn:first-child:not(:last-child){border-bottom-left-radius:0;border-bottom-right-radius:0;}.bk-root .bk-btn-group:not(.bk-vertical) > .bk-btn:not(:first-child):last-child{border-bottom-left-radius:0;border-top-left-radius:0;}.bk-root .bk-btn-group.bk-vertical > .bk-btn:not(:first-child):last-child{border-top-left-radius:0;border-top-right-radius:0;}.bk-root .bk-btn-group > .bk-btn:not(:first-child):not(:last-child){border-radius:0;}.bk-root .bk-btn-group.bk-vertical > .bk-btn{width:100%;}.bk-root .bk-btn-group .bk-dropdown-toggle{flex:0 0 0;padding:6px 6px;}"},
function _(e,t,o,n,_){var i;n();const s=e(310);class d extends s.ColumnView{}o.WidgetBoxView=d,d.__name__="WidgetBoxView";class a extends s.Column{constructor(e){super(e)}}o.WidgetBox=a,i=a,a.__name__="WidgetBox",i.prototype.default_view=d},
function _(t,a,i,e,M){e();var T=t(135);M("MathText",T.MathText),M("Ascii",T.Ascii),M("MathML",T.MathML),M("TeX",T.TeX),M("PlainText",t(139).PlainText)},
function _(r,o,t,e,n){e(),n("CustomJSTransform",r(322).CustomJSTransform),n("Dodge",r(323).Dodge),n("Interpolator",r(325).Interpolator),n("Jitter",r(326).Jitter),n("LinearInterpolator",r(327).LinearInterpolator),n("StepInterpolator",r(328).StepInterpolator),n("Transform",r(56).Transform)},
function _(r,t,s,n,e){var a;n();const u=r(56),o=r(13),m=r(34);class _ extends u.Transform{constructor(r){super(r)}get names(){return(0,o.keys)(this.args)}get values(){return(0,o.values)(this.args)}_make_transform(r,t){return new Function(...this.names,r,(0,m.use_strict)(t))}get scalar_transform(){return this._make_transform("x",this.func)}get vector_transform(){return this._make_transform("xs",this.v_func)}compute(r){return this.scalar_transform(...this.values,r)}v_compute(r){return this.vector_transform(...this.values,r)}}s.CustomJSTransform=_,a=_,_.__name__="CustomJSTransform",a.define((({Unknown:r,String:t,Dict:s})=>({args:[s(r),{}],func:[t,""],v_func:[t,""]})))},
function _(e,n,r,o,s){var t;o();const u=e(324);class a extends u.RangeTransform{constructor(e){super(e)}_compute(e){return e+this.value}}r.Dodge=a,t=a,a.__name__="Dodge",t.define((({Number:e})=>({value:[e,0]})))},
function _(e,n,t,r,a){var s;r();const c=e(56),o=e(57),i=e(67),u=e(24),h=e(8),l=e(11);class g extends c.Transform{constructor(e){super(e)}v_compute(e){let n;this.range instanceof i.FactorRange?n=this.range.v_synthetic(e):(0,h.isArrayableOf)(e,h.isNumber)?n=e:(0,l.unreachable)();const t=new((0,u.infer_type)(n))(n.length);for(let e=0;e<n.length;e++){const r=n[e];t[e]=this._compute(r)}return t}compute(e){return this.range instanceof i.FactorRange?this._compute(this.range.synthetic(e)):(0,h.isNumber)(e)?this._compute(e):void(0,l.unreachable)()}}t.RangeTransform=g,s=g,g.__name__="RangeTransform",s.define((({Ref:e,Nullable:n})=>({range:[n(e(o.Range)),null]})))},
function _(t,e,r,n,s){var o;n();const i=t(56),a=t(70),h=t(24),l=t(9),d=t(8);class c extends i.Transform{constructor(t){super(t),this._sorted_dirty=!0}connect_signals(){super.connect_signals(),this.connect(this.change,(()=>this._sorted_dirty=!0))}v_compute(t){const e=new((0,h.infer_type)(t))(t.length);for(let r=0;r<t.length;r++){const n=t[r];e[r]=this.compute(n)}return e}sort(t=!1){if(!this._sorted_dirty)return;let e,r;if((0,d.isString)(this.x)&&(0,d.isString)(this.y)&&null!=this.data){const t=this.data.columns();if(!(0,l.includes)(t,this.x))throw new Error("The x parameter does not correspond to a valid column name defined in the data parameter");if(!(0,l.includes)(t,this.y))throw new Error("The y parameter does not correspond to a valid column name defined in the data parameter");e=this.data.get_column(this.x),r=this.data.get_column(this.y)}else{if(!(0,d.isArray)(this.x)||!(0,d.isArray)(this.y))throw new Error("parameters 'x' and 'y' must be both either string fields or arrays");e=this.x,r=this.y}if(e.length!==r.length)throw new Error("The length for x and y do not match");if(e.length<2)throw new Error("x and y must have at least two elements to support interpolation");const n=e.length,s=new Uint32Array(n);for(let t=0;t<n;t++)s[t]=t;const o=t?-1:1;s.sort(((t,r)=>o*(e[t]-e[r]))),this._x_sorted=new((0,h.infer_type)(e))(n),this._y_sorted=new((0,h.infer_type)(r))(n);for(let t=0;t<n;t++)this._x_sorted[t]=e[s[t]],this._y_sorted[t]=r[s[t]];this._sorted_dirty=!1}}r.Interpolator=c,o=c,c.__name__="Interpolator",o.define((({Boolean:t,Number:e,String:r,Ref:n,Array:s,Or:o,Nullable:i})=>({x:[o(r,s(e))],y:[o(r,s(e))],data:[i(n(a.ColumnarDataSource)),null],clip:[t,!0]})))},
function _(t,s,e,i,r){i();const n=t(1);var o;const a=t(324),u=t(67),h=t(20),c=t(8),m=t(12),f=(0,n.__importStar)(t(10)),_=t(11);class p extends a.RangeTransform{constructor(t){super(t)}v_compute(t){var s;let e;this.range instanceof u.FactorRange?e=this.range.v_synthetic(t):(0,c.isArrayableOf)(t,c.isNumber)?e=t:(0,_.unreachable)();const i=e.length;(null===(s=this.previous_offsets)||void 0===s?void 0:s.length)!=i&&(this.previous_offsets=new Array(i),this.previous_offsets=(0,m.map)(this.previous_offsets,(()=>this._compute())));const r=this.previous_offsets;return(0,m.map)(e,((t,s)=>r[s]+t))}_compute(){switch(this.distribution){case"uniform":return this.mean+(f.random()-.5)*this.width;case"normal":return f.rnorm(this.mean,this.width)}}}e.Jitter=p,o=p,p.__name__="Jitter",o.define((({Number:t})=>({mean:[t,0],width:[t,1],distribution:[h.Distribution,"uniform"]})))},
function _(t,s,_,r,e){r();const i=t(9),o=t(325);class n extends o.Interpolator{constructor(t){super(t)}compute(t){if(this.sort(!1),this.clip){if(t<this._x_sorted[0]||t>this._x_sorted[this._x_sorted.length-1])return NaN}else{if(t<this._x_sorted[0])return this._y_sorted[0];if(t>this._x_sorted[this._x_sorted.length-1])return this._y_sorted[this._y_sorted.length-1]}if(t==this._x_sorted[0])return this._y_sorted[0];const s=(0,i.find_last_index)(this._x_sorted,(s=>s<t)),_=this._x_sorted[s],r=this._x_sorted[s+1],e=this._y_sorted[s],o=this._y_sorted[s+1];return e+(t-_)/(r-_)*(o-e)}}_.LinearInterpolator=n,n.__name__="LinearInterpolator"},
function _(t,e,s,r,o){var _;r();const i=t(325),n=t(20),d=t(9);class h extends i.Interpolator{constructor(t){super(t)}compute(t){if(this.sort(!1),this.clip){if(t<this._x_sorted[0]||t>this._x_sorted[this._x_sorted.length-1])return NaN}else{if(t<this._x_sorted[0])return this._y_sorted[0];if(t>this._x_sorted[this._x_sorted.length-1])return this._y_sorted[this._y_sorted.length-1]}let e;switch(this.mode){case"after":e=(0,d.find_last_index)(this._x_sorted,(e=>t>=e));break;case"before":e=(0,d.find_index)(this._x_sorted,(e=>t<=e));break;case"center":{const s=(0,d.map)(this._x_sorted,(e=>Math.abs(e-t))),r=(0,d.min)(s);e=(0,d.find_index)(s,(t=>r===t));break}default:throw new Error(`unknown mode: ${this.mode}`)}return-1!=e?this._y_sorted[e]:NaN}}s.StepInterpolator=h,_=h,h.__name__="StepInterpolator",_.define((()=>({mode:[n.StepMode,"after"]})))},
function _(p,o,t,a,n){a(),n("MapOptions",p(330).MapOptions),n("GMapOptions",p(330).GMapOptions),n("GMapPlot",p(330).GMapPlot),n("Plot",p(331).Plot)},
function _(e,t,n,o,a){var s,p,_;o();const i=e(331),r=e(53),l=e(58),c=e(336);a("GMapPlotView",c.GMapPlotView);class d extends r.Model{constructor(e){super(e)}}n.MapOptions=d,s=d,d.__name__="MapOptions",s.define((({Int:e,Number:t})=>({lat:[t],lng:[t],zoom:[e,12]})));class u extends d{constructor(e){super(e)}}n.GMapOptions=u,p=u,u.__name__="GMapOptions",p.define((({Boolean:e,Int:t,String:n})=>({map_type:[n,"roadmap"],scale_control:[e,!1],styles:[n],tilt:[t,45]})));class M extends i.Plot{constructor(e){super(e),this.use_map=!0}}n.GMapPlot=M,_=M,M.__name__="GMapPlot",_.prototype.default_view=c.GMapPlotView,_.define((({String:e,Ref:t})=>({map_options:[t(u)],api_key:[e],api_version:[e,"weekly"]}))),_.override({x_range:()=>new l.Range1d,y_range:()=>new l.Range1d})},
function _(e,t,r,n,i){n();const o=e(1);var a;const s=(0,o.__importStar)(e(48)),l=(0,o.__importStar)(e(18)),_=e(15),c=e(20),h=e(9),d=e(13),u=e(8),g=e(309),p=e(128),f=e(306),b=e(40),w=e(118),y=e(59),m=e(221),x=e(57),v=e(55),A=e(75),S=e(41),R=e(176),D=e(175),L=e(63),P=e(332);i("PlotView",P.PlotView);class k extends g.LayoutDOM{constructor(e){super(e),this.use_map=!1}_doc_attached(){super._doc_attached(),this._push_changes([[this.properties.inner_height,null,this.inner_height],[this.properties.inner_width,null,this.inner_width]])}initialize(){super.initialize(),this.reset=new _.Signal0(this,"reset");for(const e of(0,d.values)(this.extra_x_ranges).concat(this.x_range)){let t=e.plots;(0,u.isArray)(t)&&(t=t.concat(this),e.setv({plots:t},{silent:!0}))}for(const e of(0,d.values)(this.extra_y_ranges).concat(this.y_range)){let t=e.plots;(0,u.isArray)(t)&&(t=t.concat(this),e.setv({plots:t},{silent:!0}))}}add_layout(e,t="center"){const r=this.properties[t].get_value();this.setv({[t]:[...r,e]})}remove_layout(e){const t=t=>{(0,h.remove_by)(t,(t=>t==e))};t(this.left),t(this.right),t(this.above),t(this.below),t(this.center)}get data_renderers(){return this.renderers.filter((e=>e instanceof R.DataRenderer))}add_renderers(...e){this.renderers=this.renderers.concat(e)}add_glyph(e,t=new A.ColumnDataSource,r={}){const n=new D.GlyphRenderer(Object.assign(Object.assign({},r),{data_source:t,glyph:e}));return this.add_renderers(n),n}add_tools(...e){this.toolbar.tools=this.toolbar.tools.concat(e)}get panels(){return[...this.side_panels,...this.center]}get side_panels(){const{above:e,below:t,left:r,right:n}=this;return(0,h.concat)([e,t,r,n])}}r.Plot=k,a=k,k.__name__="Plot",a.prototype.default_view=P.PlotView,a.mixins([["outline_",s.Line],["background_",s.Fill],["border_",s.Fill]]),a.define((({Boolean:e,Number:t,String:r,Array:n,Dict:i,Or:o,Ref:a,Null:s,Nullable:_})=>({toolbar:[a(m.Toolbar),()=>new m.Toolbar],toolbar_location:[_(c.Location),"right"],toolbar_sticky:[e,!0],plot_width:[l.Alias("width")],plot_height:[l.Alias("height")],frame_width:[_(t),null],frame_height:[_(t),null],title:[o(a(w.Title),r,s),"",{convert:e=>(0,u.isString)(e)?new w.Title({text:e}):e}],title_location:[_(c.Location),"above"],above:[n(o(a(b.Annotation),a(p.Axis))),[]],below:[n(o(a(b.Annotation),a(p.Axis))),[]],left:[n(o(a(b.Annotation),a(p.Axis))),[]],right:[n(o(a(b.Annotation),a(p.Axis))),[]],center:[n(o(a(b.Annotation),a(f.Grid))),[]],renderers:[n(a(S.Renderer)),[]],x_range:[a(x.Range),()=>new L.DataRange1d],y_range:[a(x.Range),()=>new L.DataRange1d],x_scale:[a(v.Scale),()=>new y.LinearScale],y_scale:[a(v.Scale),()=>new y.LinearScale],extra_x_ranges:[i(a(x.Range)),{}],extra_y_ranges:[i(a(x.Range)),{}],extra_x_scales:[i(a(v.Scale)),{}],extra_y_scales:[i(a(v.Scale)),{}],lod_factor:[t,10],lod_interval:[t,300],lod_threshold:[_(t),2e3],lod_timeout:[t,500],hidpi:[e,!0],output_backend:[c.OutputBackend,"canvas"],min_border:[_(t),5],min_border_top:[_(t),null],min_border_left:[_(t),null],min_border_bottom:[_(t),null],min_border_right:[_(t),null],inner_width:[t,0],inner_height:[t,0],outer_width:[t,0],outer_height:[t,0],match_aspect:[e,!1],aspect_scale:[t,1],reset_policy:[c.ResetPolicy,"standard"]}))),a.override({width:600,height:600,outline_line_color:"#e5e5e5",border_fill_color:"#ffffff",background_fill_color:"#ffffff"})},
function _(e,t,i,s,a){s();const n=e(1),o=e(126),l=e(249),r=e(309),_=e(40),h=e(118),d=e(128),u=e(220),c=e(251),p=e(113),v=e(45),g=e(19),b=e(251),m=e(333),y=e(8),w=e(9),f=e(235),x=e(208),z=e(211),k=e(209),q=e(123),M=e(65),R=e(334),V=e(335),S=e(28);class O extends r.LayoutDOMView{constructor(){super(...arguments),this._outer_bbox=new M.BBox,this._inner_bbox=new M.BBox,this._needs_paint=!0,this._needs_layout=!1,this._invalidated_painters=new Set,this._invalidate_all=!0,this._needs_notify=!1}get canvas(){return this.canvas_view}get state(){return this._state_manager}set invalidate_dataranges(e){this._range_manager.invalidate_dataranges=e}renderer_view(e){const t=this.renderer_views.get(e);if(null==t)for(const[,t]of this.renderer_views){const i=t.renderer_view(e);if(null!=i)return i}return t}get is_paused(){return null!=this._is_paused&&0!==this._is_paused}get child_models(){return[]}pause(){null==this._is_paused?this._is_paused=1:this._is_paused+=1}unpause(e=!1){if(null==this._is_paused)throw new Error("wasn't paused");this._is_paused-=1,0!=this._is_paused||e||this.request_paint("everything")}notify_finished_after_paint(){this._needs_notify=!0}request_render(){this.request_paint("everything")}request_paint(e){this.invalidate_painters(e),this.schedule_paint()}invalidate_painters(e){if("everything"==e)this._invalidate_all=!0;else if((0,y.isArray)(e))for(const t of e)this._invalidated_painters.add(t);else this._invalidated_painters.add(e)}schedule_paint(){if(!this.is_paused){const e=this.throttled_paint();this._ready=this._ready.then((()=>e))}}request_layout(){this._needs_layout=!0,this.request_paint("everything")}reset(){"standard"==this.model.reset_policy&&(this.state.clear(),this.reset_range(),this.reset_selection()),this.model.trigger_event(new c.Reset)}remove(){(0,p.remove_views)(this.renderer_views),(0,p.remove_views)(this.tool_views),this.canvas_view.remove(),super.remove()}render(){super.render(),this.el.appendChild(this.canvas_view.el),this.canvas_view.render()}initialize(){this.pause(),super.initialize(),this.lod_started=!1,this.visuals=new v.Visuals(this),this._initial_state={selection:new Map,dimensions:{width:0,height:0}},this.visibility_callbacks=[],this.renderer_views=new Map,this.tool_views=new Map,this.frame=new o.CartesianFrame(this.model.x_scale,this.model.y_scale,this.model.x_range,this.model.y_range,this.model.extra_x_ranges,this.model.extra_y_ranges,this.model.extra_x_scales,this.model.extra_y_scales),this._range_manager=new R.RangeManager(this),this._state_manager=new V.StateManager(this,this._initial_state),this.throttled_paint=(0,m.throttle)((()=>this.repaint()),1e3/60);const{title_location:e,title:t}=this.model;null!=e&&null!=t&&(this._title=t instanceof h.Title?t:new h.Title({text:t}));const{toolbar_location:i,toolbar:s}=this.model;null!=i&&null!=s&&(this._toolbar=new u.ToolbarPanel({toolbar:s}),s.toolbar_location=i)}async lazy_initialize(){await super.lazy_initialize();const{hidpi:e,output_backend:t}=this.model,i=new l.Canvas({hidpi:e,output_backend:t});this.canvas_view=await(0,p.build_view)(i,{parent:this}),this.canvas_view.plot_views=[this],await this.build_renderer_views(),await this.build_tool_views(),this._range_manager.update_dataranges(),this.unpause(!0),g.logger.debug("PlotView initialized")}_width_policy(){return null==this.model.frame_width?super._width_policy():"min"}_height_policy(){return null==this.model.frame_height?super._height_policy():"min"}_update_layout(){var e,t,i,s,a;this.layout=new z.BorderLayout,this.layout.set_sizing(this.box_sizing());const n=(0,w.copy)(this.model.above),o=(0,w.copy)(this.model.below),l=(0,w.copy)(this.model.left),r=(0,w.copy)(this.model.right),d=e=>{switch(e){case"above":return n;case"below":return o;case"left":return l;case"right":return r}},{title_location:c,title:p}=this.model;null!=c&&null!=p&&d(c).push(this._title);const{toolbar_location:v,toolbar:g}=this.model;if(null!=v&&null!=g){const e=d(v);let t=!0;if(this.model.toolbar_sticky)for(let i=0;i<e.length;i++){const s=e[i];if(s instanceof h.Title){e[i]="above"==v||"below"==v?[s,this._toolbar]:[this._toolbar,s],t=!1;break}}t&&e.push(this._toolbar)}const b=(e,t)=>{var i;const s=this.renderer_view(t);return s.panel=new q.Panel(e),null===(i=s.update_layout)||void 0===i||i.call(s),s.layout},m=(e,t)=>{const i="above"==e||"below"==e,s=[];for(const a of t)if((0,y.isArray)(a)){const t=a.map((t=>{const s=b(e,t);if(t instanceof u.ToolbarPanel){const e=i?"width_policy":"height_policy";s.set_sizing(Object.assign(Object.assign({},s.sizing),{[e]:"min"}))}return s}));let n;i?(n=new k.Row(t),n.set_sizing({width_policy:"max",height_policy:"min"})):(n=new k.Column(t),n.set_sizing({width_policy:"min",height_policy:"max"})),n.absolute=!0,s.push(n)}else s.push(b(e,a));return s},f=null!==(e=this.model.min_border)&&void 0!==e?e:0;this.layout.min_border={left:null!==(t=this.model.min_border_left)&&void 0!==t?t:f,top:null!==(i=this.model.min_border_top)&&void 0!==i?i:f,right:null!==(s=this.model.min_border_right)&&void 0!==s?s:f,bottom:null!==(a=this.model.min_border_bottom)&&void 0!==a?a:f};const M=new x.NodeLayout,R=new x.VStack,V=new x.VStack,S=new x.HStack,O=new x.HStack;M.absolute=!0,R.absolute=!0,V.absolute=!0,S.absolute=!0,O.absolute=!0,M.children=this.model.center.filter((e=>e instanceof _.Annotation)).map((e=>{var t;const i=this.renderer_view(e);return null===(t=i.update_layout)||void 0===t||t.call(i),i.layout})).filter((e=>null!=e));const{frame_width:P,frame_height:j}=this.model;M.set_sizing(Object.assign(Object.assign({},null!=P?{width_policy:"fixed",width:P}:{width_policy:"fit"}),null!=j?{height_policy:"fixed",height:j}:{height_policy:"fit"})),M.on_resize((e=>this.frame.set_geometry(e))),R.children=(0,w.reversed)(m("above",n)),V.children=m("below",o),S.children=(0,w.reversed)(m("left",l)),O.children=m("right",r),R.set_sizing({width_policy:"fit",height_policy:"min"}),V.set_sizing({width_policy:"fit",height_policy:"min"}),S.set_sizing({width_policy:"min",height_policy:"fit"}),O.set_sizing({width_policy:"min",height_policy:"fit"}),this.layout.center_panel=M,this.layout.top_panel=R,this.layout.bottom_panel=V,this.layout.left_panel=S,this.layout.right_panel=O}get axis_views(){const e=[];for(const[,t]of this.renderer_views)t instanceof d.AxisView&&e.push(t);return e}set_toolbar_visibility(e){for(const t of this.visibility_callbacks)t(e)}update_range(e,t){this.pause(),this._range_manager.update(e,t),this.unpause()}reset_range(){this.update_range(null),this.trigger_ranges_update_event()}trigger_ranges_update_event(){const{x_range:e,y_range:t}=this.model;this.model.trigger_event(new b.RangesUpdate(e.start,e.end,t.start,t.end))}get_selection(){const e=new Map;for(const t of this.model.data_renderers){const{selected:i}=t.selection_manager.source;e.set(t,i)}return e}update_selection(e){for(const t of this.model.data_renderers){const i=t.selection_manager.source;if(null!=e){const s=e.get(t);null!=s&&i.selected.update(s,!0)}else i.selection_manager.clear()}}reset_selection(){this.update_selection(null)}_invalidate_layout(){(()=>{var e;for(const t of this.model.side_panels){const i=this.renderer_views.get(t);if(null===(e=i.layout)||void 0===e?void 0:e.has_size_changed())return this.invalidate_painters(i),!0}return!1})()&&this.root.compute_layout()}get_renderer_views(){return this.computed_renderers.map((e=>this.renderer_views.get(e)))}*_compute_renderers(){const{above:e,below:t,left:i,right:s,center:a,renderers:n}=this.model;yield*n,yield*e,yield*t,yield*i,yield*s,yield*a,null!=this._title&&(yield this._title),null!=this._toolbar&&(yield this._toolbar);for(const e of this.model.toolbar.tools)null!=e.overlay&&(yield e.overlay),yield*e.synthetic_renderers}async build_renderer_views(){this.computed_renderers=[...this._compute_renderers()],await(0,p.build_views)(this.renderer_views,this.computed_renderers,{parent:this})}async build_tool_views(){const e=this.model.toolbar.tools;(await(0,p.build_views)(this.tool_views,e,{parent:this})).map((e=>this.canvas_view.ui_event_bus.register_tool(e)))}connect_signals(){super.connect_signals();const{x_ranges:e,y_ranges:t}=this.frame;for(const[,t]of e)this.connect(t.change,(()=>{this._needs_layout=!0,this.request_paint("everything")}));for(const[,e]of t)this.connect(e.change,(()=>{this._needs_layout=!0,this.request_paint("everything")}));const{above:i,below:s,left:a,right:n,center:o,renderers:l}=this.model.properties;this.on_change([i,s,a,n,o,l],(async()=>await this.build_renderer_views())),this.connect(this.model.toolbar.properties.tools.change,(async()=>{await this.build_renderer_views(),await this.build_tool_views()})),this.connect(this.model.change,(()=>this.request_paint("everything"))),this.connect(this.model.reset,(()=>this.reset()))}has_finished(){if(!super.has_finished())return!1;if(this.model.visible)for(const[,e]of this.renderer_views)if(!e.has_finished())return!1;return!0}after_layout(){var e;super.after_layout();for(const[,t]of this.renderer_views)t instanceof _.AnnotationView&&(null===(e=t.after_layout)||void 0===e||e.call(t));if(this._needs_layout=!1,this.model.setv({inner_width:Math.round(this.frame.bbox.width),inner_height:Math.round(this.frame.bbox.height),outer_width:Math.round(this.layout.bbox.width),outer_height:Math.round(this.layout.bbox.height)},{no_change:!0}),!1!==this.model.match_aspect&&(this.pause(),this._range_manager.update_dataranges(),this.unpause(!0)),!this._outer_bbox.equals(this.layout.bbox)){const{width:e,height:t}=this.layout.bbox;this.canvas_view.resize(e,t),this._outer_bbox=this.layout.bbox,this._invalidate_all=!0,this._needs_paint=!0}const{inner_bbox:t}=this.layout;this._inner_bbox.equals(t)||(this._inner_bbox=t,this._needs_paint=!0),this._needs_paint&&this.paint()}repaint(){this._needs_layout&&this._invalidate_layout(),this.paint()}paint(){this.is_paused||(this.model.visible&&(g.logger.trace(`${this.toString()}.paint()`),this._actual_paint()),this._needs_notify&&(this._needs_notify=!1,this.notify_finished()))}_actual_paint(){var e;const{document:t}=this.model;if(null!=t){const e=t.interactive_duration();e>=0&&e<this.model.lod_interval?setTimeout((()=>{t.interactive_duration()>this.model.lod_timeout&&t.interactive_stop(),this.request_paint("everything")}),this.model.lod_timeout):t.interactive_stop()}this._range_manager.invalidate_dataranges&&(this._range_manager.update_dataranges(),this._invalidate_layout());let i=!1,s=!1;if(this._invalidate_all)i=!0,s=!0;else for(const e of this._invalidated_painters){const{level:t}=e.model;if("overlay"!=t?i=!0:s=!0,i&&s)break}this._invalidated_painters.clear(),this._invalidate_all=!1;const a=[this.frame.bbox.left,this.frame.bbox.top,this.frame.bbox.width,this.frame.bbox.height],{primary:n,overlays:o}=this.canvas_view;i&&(n.prepare(),this.canvas_view.prepare_webgl(a),this._map_hook(n.ctx,a),this._paint_empty(n.ctx,a),this._paint_outline(n.ctx,a),this._paint_levels(n.ctx,"image",a,!0),this._paint_levels(n.ctx,"underlay",a,!0),this._paint_levels(n.ctx,"glyph",a,!0),this._paint_levels(n.ctx,"guide",a,!1),this._paint_levels(n.ctx,"annotation",a,!1),n.finish()),(s||S.settings.wireframe)&&(o.prepare(),this._paint_levels(o.ctx,"overlay",a,!1),S.settings.wireframe&&this._paint_layout(o.ctx,this.layout),o.finish()),null==this._initial_state.range&&(this._initial_state.range=null!==(e=this._range_manager.compute_initial())&&void 0!==e?e:void 0),this._needs_paint=!1}_paint_levels(e,t,i,s){for(const a of this.computed_renderers){if(a.level!=t)continue;const n=this.renderer_views.get(a);e.save(),(s||n.needs_clip)&&(e.beginPath(),e.rect(...i),e.clip()),n.render(),e.restore(),n.has_webgl&&n.needs_webgl_blit&&this.canvas_view.blit_webgl(e)}}_paint_layout(e,t){const{x:i,y:s,width:a,height:n}=t.bbox;e.strokeStyle="blue",e.strokeRect(i,s,a,n);for(const a of t)e.save(),t.absolute||e.translate(i,s),this._paint_layout(e,a),e.restore()}_map_hook(e,t){}_paint_empty(e,t){const[i,s,a,n]=[0,0,this.layout.bbox.width,this.layout.bbox.height],[o,l,r,_]=t;this.visuals.border_fill.doit&&(this.visuals.border_fill.set_value(e),e.fillRect(i,s,a,n),e.clearRect(o,l,r,_)),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(e),e.fillRect(o,l,r,_))}_paint_outline(e,t){if(this.visuals.outline_line.doit){e.save(),this.visuals.outline_line.set_value(e);let[i,s,a,n]=t;i+a==this.layout.bbox.width&&(a-=1),s+n==this.layout.bbox.height&&(n-=1),e.strokeRect(i,s,a,n),e.restore()}}to_blob(){return this.canvas_view.to_blob()}export(e,t=!0){const i="png"==e?"canvas":"svg",s=new f.CanvasLayer(i,t),{width:a,height:n}=this.layout.bbox;s.resize(a,n);const{canvas:o}=this.canvas_view.compose();return s.ctx.drawImage(o,0,0),s}serializable_state(){const e=super.serializable_state(),{children:t}=e,i=(0,n.__rest)(e,["children"]),s=this.get_renderer_views().map((e=>e.serializable_state())).filter((e=>null!=e.bbox));return Object.assign(Object.assign({},i),{children:[...null!=t?t:[],...s]})}}i.PlotView=O,O.__name__="PlotView"},
function _(t,n,e,o,u){o(),e.throttle=function(t,n){let e=null,o=0,u=!1;return function(){return new Promise(((r,i)=>{const l=function(){o=Date.now(),e=null,u=!1;try{t(),r()}catch(t){i(t)}},a=Date.now(),c=n-(a-o);c<=0&&!u?(null!=e&&clearTimeout(e),u=!0,requestAnimationFrame(l)):e||u?r():e=setTimeout((()=>requestAnimationFrame(l)),c)}))}}},
function _(t,n,e,a,s){a();const o=t(63),r=t(19);class l{constructor(t){this.parent=t,this.invalidate_dataranges=!0}get frame(){return this.parent.frame}update(t,n){const{x_ranges:e,y_ranges:a}=this.frame;if(null==t){for(const[,t]of e)t.reset();for(const[,t]of a)t.reset();this.update_dataranges()}else{const s=[];for(const[n,a]of e)s.push([a,t.xrs.get(n)]);for(const[n,e]of a)s.push([e,t.yrs.get(n)]);(null==n?void 0:n.scrolling)&&this._update_ranges_together(s),this._update_ranges_individually(s,n)}}reset(){this.update(null)}_update_dataranges(t){const n=new Map,e=new Map;let a=!1;for(const[,n]of t.x_ranges)n instanceof o.DataRange1d&&"log"==n.scale_hint&&(a=!0);for(const[,n]of t.y_ranges)n instanceof o.DataRange1d&&"log"==n.scale_hint&&(a=!0);for(const t of this.parent.model.data_renderers){const s=this.parent.renderer_view(t);if(null==s)continue;const o=s.glyph_view.bounds();if(null!=o&&n.set(t,o),a){const n=s.glyph_view.log_bounds();null!=n&&e.set(t,n)}}let s=!1,l=!1;const i=t.x_target.span,d=t.y_target.span;let u;!1!==this.parent.model.match_aspect&&0!=i&&0!=d&&(u=1/this.parent.model.aspect_scale*(i/d));for(const[,a]of t.x_ranges){if(a instanceof o.DataRange1d){const t="log"==a.scale_hint?e:n;a.update(t,0,this.parent.model,u),a.follow&&(s=!0)}null!=a.bounds&&(l=!0)}for(const[,a]of t.y_ranges){if(a instanceof o.DataRange1d){const t="log"==a.scale_hint?e:n;a.update(t,1,this.parent.model,u),a.follow&&(s=!0)}null!=a.bounds&&(l=!0)}if(s&&l){r.logger.warn("Follow enabled so bounds are unset.");for(const[,n]of t.x_ranges)n.bounds=null;for(const[,n]of t.y_ranges)n.bounds=null}}update_dataranges(){this._update_dataranges(this.frame);for(const t of this.parent.model.renderers){const{coordinates:n}=t;null!=n&&this._update_dataranges(n)}null!=this.compute_initial()&&(this.invalidate_dataranges=!1)}compute_initial(){let t=!0;const{x_ranges:n,y_ranges:e}=this.frame,a=new Map,s=new Map;for(const[e,s]of n){const{start:n,end:o}=s;if(null==n||null==o||isNaN(n+o)){t=!1;break}a.set(e,{start:n,end:o})}if(t)for(const[n,a]of e){const{start:e,end:o}=a;if(null==e||null==o||isNaN(e+o)){t=!1;break}s.set(n,{start:e,end:o})}return t?{xrs:a,yrs:s}:(r.logger.warn("could not set initial ranges"),null)}_update_ranges_together(t){let n=1;for(const[e,a]of t)n=Math.min(n,this._get_weight_to_constrain_interval(e,a));if(n<1)for(const[e,a]of t)a.start=n*a.start+(1-n)*e.start,a.end=n*a.end+(1-n)*e.end}_update_ranges_individually(t,n){const e=!!(null==n?void 0:n.panning),a=!!(null==n?void 0:n.scrolling);let s=!1;for(const[n,o]of t){if(!a){const t=this._get_weight_to_constrain_interval(n,o);t<1&&(o.start=t*o.start+(1-t)*n.start,o.end=t*o.end+(1-t)*n.end)}if(null!=n.bounds&&"auto"!=n.bounds){const[t,r]=n.bounds,l=Math.abs(o.end-o.start);n.is_reversed?(null!=t&&t>o.end&&(s=!0,o.end=t,(e||a)&&(o.start=t+l)),null!=r&&r<o.start&&(s=!0,o.start=r,(e||a)&&(o.end=r-l))):(null!=t&&t>o.start&&(s=!0,o.start=t,(e||a)&&(o.end=t+l)),null!=r&&r<o.end&&(s=!0,o.end=r,(e||a)&&(o.start=r-l)))}}if(!(a&&s&&(null==n?void 0:n.maintain_focus)))for(const[n,e]of t)n.have_updated_interactively=!0,n.start==e.start&&n.end==e.end||n.setv(e)}_get_weight_to_constrain_interval(t,n){const{min_interval:e}=t;let{max_interval:a}=t;if(null!=t.bounds&&"auto"!=t.bounds){const[n,e]=t.bounds;if(null!=n&&null!=e){const t=Math.abs(e-n);a=null!=a?Math.min(a,t):t}}let s=1;if(null!=e||null!=a){const o=Math.abs(t.end-t.start),r=Math.abs(n.end-n.start);null!=e&&e>0&&r<e&&(s=(o-e)/(o-r)),null!=a&&a>0&&r>a&&(s=(a-o)/(r-o)),s=Math.max(0,Math.min(1,s))}return s}}e.RangeManager=l,l.__name__="RangeManager"},
function _(t,i,s,e,n){e();const h=t(15);class a{constructor(t,i){this.parent=t,this.initial_state=i,this.changed=new h.Signal0(this.parent,"state_changed"),this.history=[],this.index=-1}_do_state_change(t){const i=null!=this.history[t]?this.history[t].state:this.initial_state;return null!=i.range&&this.parent.update_range(i.range),null!=i.selection&&this.parent.update_selection(i.selection),i}push(t,i){const{history:s,index:e}=this,n=null!=s[e]?s[e].state:{},h=Object.assign(Object.assign(Object.assign({},this.initial_state),n),i);this.history=this.history.slice(0,this.index+1),this.history.push({type:t,state:h}),this.index=this.history.length-1,this.changed.emit()}clear(){this.history=[],this.index=-1,this.changed.emit()}undo(){if(this.can_undo){this.index-=1;const t=this._do_state_change(this.index);return this.changed.emit(),t}return null}redo(){if(this.can_redo){this.index+=1;const t=this._do_state_change(this.index);return this.changed.emit(),t}return null}get can_undo(){return this.index>=0}get can_redo(){return this.index<this.history.length-1}}s.StateManager=a,a.__name__="StateManager"},
function _(t,e,s,o,i){o();const a=t(19),n=t(15),p=t(43),l=t(78),_=t(22),h=t(332),m=new n.Signal0({},"gmaps_ready");class d extends h.PlotView{initialize(){this.pause(),super.initialize(),this._tiles_loaded=!1,this.zoom_count=0;const{zoom:t,lat:e,lng:s}=this.model.map_options;if(this.initial_zoom=t,this.initial_lat=e,this.initial_lng=s,!this.model.api_key){const t="https://developers.google.com/maps/documentation/javascript/get-api-key";a.logger.error(`api_key is required. See ${t} for more information on how to obtain your own.`)}if("undefined"==typeof google||null==google.maps){if(void 0===window._bokeh_gmaps_callback){const{api_key:t,api_version:e}=this.model;!function(t,e){window._bokeh_gmaps_callback=()=>m.emit();const s=encodeURIComponent,o=document.createElement("script");o.type="text/javascript",o.src=`https://maps.googleapis.com/maps/api/js?v=${s(e)}&key=${s(t)}&callback=_bokeh_gmaps_callback`,document.body.appendChild(o)}(t,e)}m.connect((()=>this.request_paint("everything")))}this.unpause()}remove(){(0,p.remove)(this.map_el),super.remove()}update_range(t,e){var s,o;if(null==t)this.map.setCenter({lat:this.initial_lat,lng:this.initial_lng}),this.map.setOptions({zoom:this.initial_zoom}),super.update_range(null,e);else if(null!=t.sdx||null!=t.sdy)this.map.panBy(null!==(s=t.sdx)&&void 0!==s?s:0,null!==(o=t.sdy)&&void 0!==o?o:0),super.update_range(t,e);else if(null!=t.factor){if(10!==this.zoom_count)return void(this.zoom_count+=1);this.zoom_count=0,this.pause(),super.update_range(t,e);const s=t.factor<0?-1:1,o=this.map.getZoom();if(null!=o){const t=o+s;if(t>=2){this.map.setZoom(t);const[e,s]=this._get_projected_bounds();s-e<0&&this.map.setZoom(o)}}this.unpause()}this._set_bokeh_ranges()}_build_map(){const{maps:t}=google;this.map_types={satellite:t.MapTypeId.SATELLITE,terrain:t.MapTypeId.TERRAIN,roadmap:t.MapTypeId.ROADMAP,hybrid:t.MapTypeId.HYBRID};const e=this.model.map_options,s={center:new t.LatLng(e.lat,e.lng),zoom:e.zoom,disableDefaultUI:!0,mapTypeId:this.map_types[e.map_type],scaleControl:e.scale_control,tilt:e.tilt};null!=e.styles&&(s.styles=JSON.parse(e.styles)),this.map_el=(0,p.div)({style:{position:"absolute"}}),this.canvas_view.add_underlay(this.map_el),this.map=new t.Map(this.map_el,s),t.event.addListener(this.map,"idle",(()=>this._set_bokeh_ranges())),t.event.addListener(this.map,"bounds_changed",(()=>this._set_bokeh_ranges())),t.event.addListenerOnce(this.map,"tilesloaded",(()=>this._render_finished())),this.connect(this.model.properties.map_options.change,(()=>this._update_options())),this.connect(this.model.map_options.properties.styles.change,(()=>this._update_styles())),this.connect(this.model.map_options.properties.lat.change,(()=>this._update_center("lat"))),this.connect(this.model.map_options.properties.lng.change,(()=>this._update_center("lng"))),this.connect(this.model.map_options.properties.zoom.change,(()=>this._update_zoom())),this.connect(this.model.map_options.properties.map_type.change,(()=>this._update_map_type())),this.connect(this.model.map_options.properties.scale_control.change,(()=>this._update_scale_control())),this.connect(this.model.map_options.properties.tilt.change,(()=>this._update_tilt()))}_render_finished(){this._tiles_loaded=!0,this.notify_finished()}has_finished(){return super.has_finished()&&!0===this._tiles_loaded}_get_latlon_bounds(){const t=this.map.getBounds(),e=t.getNorthEast(),s=t.getSouthWest();return[s.lng(),e.lng(),s.lat(),e.lat()]}_get_projected_bounds(){const[t,e,s,o]=this._get_latlon_bounds(),[i,a]=l.wgs84_mercator.compute(t,s),[n,p]=l.wgs84_mercator.compute(e,o);return[i,n,a,p]}_set_bokeh_ranges(){const[t,e,s,o]=this._get_projected_bounds();this.frame.x_range.setv({start:t,end:e}),this.frame.y_range.setv({start:s,end:o})}_update_center(t){var e;const s=null===(e=this.map.getCenter())||void 0===e?void 0:e.toJSON();null!=s&&(s[t]=this.model.map_options[t],this.map.setCenter(s),this._set_bokeh_ranges())}_update_map_type(){this.map.setOptions({mapTypeId:this.map_types[this.model.map_options.map_type]})}_update_scale_control(){this.map.setOptions({scaleControl:this.model.map_options.scale_control})}_update_tilt(){this.map.setOptions({tilt:this.model.map_options.tilt})}_update_options(){this._update_styles(),this._update_center("lat"),this._update_center("lng"),this._update_zoom(),this._update_map_type()}_update_styles(){this.map.setOptions({styles:JSON.parse(this.model.map_options.styles)})}_update_zoom(){this.map.setOptions({zoom:this.model.map_options.zoom}),this._set_bokeh_ranges()}_map_hook(t,e){if(null==this.map&&"undefined"!=typeof google&&null!=google.maps&&this._build_map(),null!=this.map_el){const[t,s,o,i]=e;this.map_el.style.top=`${s}px`,this.map_el.style.left=`${t}px`,this.map_el.style.width=`${o}px`,this.map_el.style.height=`${i}px`}}_paint_empty(t,e){const s=this.layout.bbox.width,o=this.layout.bbox.height,[i,a,n,p]=e;t.clearRect(0,0,s,o),t.beginPath(),t.moveTo(0,0),t.lineTo(0,o),t.lineTo(s,o),t.lineTo(s,0),t.lineTo(0,0),t.moveTo(i,a),t.lineTo(i+n,a),t.lineTo(i+n,a+p),t.lineTo(i,a+p),t.lineTo(i,a),t.closePath(),null!=this.model.border_fill_color&&(t.fillStyle=(0,_.color2css)(this.model.border_fill_color),t.fill())}}s.GMapPlotView=d,d.__name__="GMapPlotView"},
function _(t,_,n,o,r){o();(0,t(1).__exportStar)(t(132),n)},
function _(e,r,d,n,R){n(),R("GlyphRenderer",e(175).GlyphRenderer),R("GraphRenderer",e(339).GraphRenderer),R("GuideRenderer",e(129).GuideRenderer);var G=e(41);R("Renderer",G.Renderer),R("RendererGroup",G.RendererGroup)},
function _(e,r,i,n,t){var o;n();const s=e(176),d=e(175),a=e(303),p=e(302),l=e(113),_=e(178),h=e(283),y=e(286);class c extends s.DataRendererView{get glyph_view(){return this.node_view.glyph}async lazy_initialize(){await super.lazy_initialize(),this.apply_coordinates();const{parent:e}=this,{edge_renderer:r,node_renderer:i}=this.model;this.edge_view=await(0,l.build_view)(r,{parent:e}),this.node_view=await(0,l.build_view)(i,{parent:e})}connect_signals(){super.connect_signals(),this.connect(this.model.layout_provider.change,(()=>{this.apply_coordinates(),this.edge_view.set_data(),this.node_view.set_data(),this.request_render()}))}apply_coordinates(){const{edge_renderer:e,node_renderer:r}=this.model;if(!(e.glyph instanceof h.MultiLine||e.glyph instanceof y.Patches))throw new Error(`${this}.edge_renderer.glyph must be a MultiLine glyph`);if(!(r.glyph instanceof _.XYGlyph))throw new Error(`${this}.node_renderer.glyph must be a XYGlyph glyph`);const i=this.model.layout_provider.edge_coordinates,n=this.model.layout_provider.node_coordinates;e.glyph.properties.xs.internal=!0,e.glyph.properties.ys.internal=!0,r.glyph.properties.x.internal=!0,r.glyph.properties.y.internal=!0,e.glyph.xs={expr:i.x},e.glyph.ys={expr:i.y},r.glyph.x={expr:n.x},r.glyph.y={expr:n.y}}remove(){this.edge_view.remove(),this.node_view.remove(),super.remove()}_render(){this.edge_view.render(),this.node_view.render()}renderer_view(e){if(e instanceof d.GlyphRenderer){if(e==this.edge_view.model)return this.edge_view;if(e==this.node_view.model)return this.node_view}return super.renderer_view(e)}}i.GraphRendererView=c,c.__name__="GraphRendererView";class g extends s.DataRenderer{constructor(e){super(e)}get_selection_manager(){return this.node_renderer.data_source.selection_manager}}i.GraphRenderer=g,o=g,g.__name__="GraphRenderer",o.prototype.default_view=c,o.define((({Ref:e})=>({layout_provider:[e(a.LayoutProvider)],node_renderer:[e(d.GlyphRenderer)],edge_renderer:[e(d.GlyphRenderer)],selection_policy:[e(p.GraphHitTestPolicy),()=>new p.NodesOnly],inspection_policy:[e(p.GraphHitTestPolicy),()=>new p.NodesOnly]})))},
function _(e,t,n,o,c){o();(0,e(1).__exportStar)(e(74),n),c("Selection",e(72).Selection)},
function _(a,e,S,o,r){o(),r("ServerSentDataSource",a(342).ServerSentDataSource),r("AjaxDataSource",a(344).AjaxDataSource),r("ColumnDataSource",a(75).ColumnDataSource),r("ColumnarDataSource",a(70).ColumnarDataSource),r("CDSView",a(190).CDSView),r("DataSource",a(71).DataSource),r("GeoJSONDataSource",a(345).GeoJSONDataSource),r("WebDataSource",a(343).WebDataSource)},
function _(e,t,i,a,s){a();const n=e(343);class r extends n.WebDataSource{constructor(e){super(e),this.initialized=!1}setup(){if(!this.initialized){this.initialized=!0;new EventSource(this.data_url).onmessage=e=>{var t;this.load_data(JSON.parse(e.data),this.mode,null!==(t=this.max_size)&&void 0!==t?t:void 0)}}}}i.ServerSentDataSource=r,r.__name__="ServerSentDataSource"},
function _(e,t,a,n,r){var s;n();const l=e(75),o=e(20);class c extends l.ColumnDataSource{constructor(e){super(e)}get_column(e){const t=this.data[e];return null!=t?t:[]}get_length(){var e;return null!==(e=super.get_length())&&void 0!==e?e:0}initialize(){super.initialize(),this.setup()}load_data(e,t,a){const{adapter:n}=this;let r;switch(r=null!=n?n.execute(this,{response:e}):e,t){case"replace":this.data=r;break;case"append":{const e=this.data;for(const t of this.columns()){const n=Array.from(e[t]),s=Array.from(r[t]),l=n.concat(s);r[t]=null!=a?l.slice(-a):l}this.data=r;break}}}}a.WebDataSource=c,s=c,c.__name__="WebDataSource",s.define((({Any:e,Int:t,String:a,Nullable:n})=>({max_size:[n(t),null],mode:[o.UpdateMode,"replace"],adapter:[n(e),null],data_url:[a]})))},
function _(t,e,i,s,a){var n;s();const r=t(343),o=t(20),l=t(19),d=t(13);class h extends r.WebDataSource{constructor(t){super(t),this.interval=null,this.initialized=!1}destroy(){null!=this.interval&&clearInterval(this.interval),super.destroy()}setup(){if(!this.initialized&&(this.initialized=!0,this.get_data(this.mode),null!=this.polling_interval)){const t=()=>this.get_data(this.mode,this.max_size,this.if_modified);this.interval=setInterval(t,this.polling_interval)}}get_data(t,e=null,i=!1){const s=this.prepare_request();s.addEventListener("load",(()=>this.do_load(s,t,null!=e?e:void 0))),s.addEventListener("error",(()=>this.do_error(s))),s.send()}prepare_request(){const t=new XMLHttpRequest;t.open(this.method,this.data_url,!0),t.withCredentials=!1,t.setRequestHeader("Content-Type",this.content_type);const e=this.http_headers;for(const[i,s]of(0,d.entries)(e))t.setRequestHeader(i,s);return t}do_load(t,e,i){if(200===t.status){const s=JSON.parse(t.responseText);this.load_data(s,e,i)}}do_error(t){l.logger.error(`Failed to fetch JSON from ${this.data_url} with code ${t.status}`)}}i.AjaxDataSource=h,n=h,h.__name__="AjaxDataSource",n.define((({Boolean:t,Int:e,String:i,Dict:s,Nullable:a})=>({polling_interval:[a(e),null],content_type:[i,"application/json"],http_headers:[s(i),{}],method:[o.HTTPMethod,"POST"],if_modified:[t,!1]})))},
function _(e,t,o,r,n){var s;r();const a=e(70),i=e(19),l=e(9),c=e(13);function _(e){return null!=e?e:NaN}const{hasOwnProperty:g}=Object.prototype;class u extends a.ColumnarDataSource{constructor(e){super(e)}initialize(){super.initialize(),this._update_data()}connect_signals(){super.connect_signals(),this.connect(this.properties.geojson.change,(()=>this._update_data()))}_update_data(){this.data=this.geojson_to_column_data()}_get_new_list_array(e){return(0,l.range)(0,e).map((e=>[]))}_get_new_nan_array(e){return(0,l.range)(0,e).map((e=>NaN))}_add_properties(e,t,o,r){var n;const s=null!==(n=e.properties)&&void 0!==n?n:{};for(const[e,n]of(0,c.entries)(s))g.call(t,e)||(t[e]=this._get_new_nan_array(r)),t[e][o]=_(n)}_add_geometry(e,t,o){function r(e,t){return e.concat([[NaN,NaN,NaN]]).concat(t)}switch(e.type){case"Point":{const[r,n,s]=e.coordinates;t.x[o]=r,t.y[o]=n,t.z[o]=_(s);break}case"LineString":{const{coordinates:r}=e;for(let e=0;e<r.length;e++){const[n,s,a]=r[e];t.xs[o][e]=n,t.ys[o][e]=s,t.zs[o][e]=_(a)}break}case"Polygon":{e.coordinates.length>1&&i.logger.warn("Bokeh does not support Polygons with holes in, only exterior ring used.");const r=e.coordinates[0];for(let e=0;e<r.length;e++){const[n,s,a]=r[e];t.xs[o][e]=n,t.ys[o][e]=s,t.zs[o][e]=_(a)}break}case"MultiPoint":i.logger.warn("MultiPoint not supported in Bokeh");break;case"MultiLineString":{const n=e.coordinates.reduce(r);for(let e=0;e<n.length;e++){const[r,s,a]=n[e];t.xs[o][e]=r,t.ys[o][e]=s,t.zs[o][e]=_(a)}break}case"MultiPolygon":{const n=[];for(const t of e.coordinates)t.length>1&&i.logger.warn("Bokeh does not support Polygons with holes in, only exterior ring used."),n.push(t[0]);const s=n.reduce(r);for(let e=0;e<s.length;e++){const[r,n,a]=s[e];t.xs[o][e]=r,t.ys[o][e]=n,t.zs[o][e]=_(a)}break}default:throw new Error(`Invalid GeoJSON geometry type: ${e.type}`)}}geojson_to_column_data(){const e=JSON.parse(this.geojson);let t;switch(e.type){case"GeometryCollection":if(null==e.geometries)throw new Error("No geometries found in GeometryCollection");if(0===e.geometries.length)throw new Error("geojson.geometries must have one or more items");t=e.geometries;break;case"FeatureCollection":if(null==e.features)throw new Error("No features found in FeaturesCollection");if(0==e.features.length)throw new Error("geojson.features must have one or more items");t=e.features;break;default:throw new Error("Bokeh only supports type GeometryCollection and FeatureCollection at top level")}let o=0;for(const e of t){const t="Feature"===e.type?e.geometry:e;"GeometryCollection"==t.type?o+=t.geometries.length:o+=1}const r={x:this._get_new_nan_array(o),y:this._get_new_nan_array(o),z:this._get_new_nan_array(o),xs:this._get_new_list_array(o),ys:this._get_new_list_array(o),zs:this._get_new_list_array(o)};let n=0;for(const e of t){const t="Feature"==e.type?e.geometry:e;if("GeometryCollection"==t.type)for(const s of t.geometries)this._add_geometry(s,r,n),"Feature"===e.type&&this._add_properties(e,r,n,o),n+=1;else this._add_geometry(t,r,n),"Feature"===e.type&&this._add_properties(e,r,n,o),n+=1}return r}}o.GeoJSONDataSource=u,s=u,u.__name__="GeoJSONDataSource",s.define((({String:e})=>({geojson:[e]}))),s.internal((({Dict:e,Arrayable:t})=>({data:[e(t),{}]})))},
function _(e,r,T,o,S){o(),S("BBoxTileSource",e(347).BBoxTileSource),S("MercatorTileSource",e(348).MercatorTileSource),S("QUADKEYTileSource",e(351).QUADKEYTileSource),S("TileRenderer",e(352).TileRenderer),S("TileSource",e(349).TileSource),S("TMSTileSource",e(355).TMSTileSource),S("WMTSTileSource",e(353).WMTSTileSource)},
function _(e,t,r,o,l){var i;o();const n=e(348);class s extends n.MercatorTileSource{constructor(e){super(e)}get_image_url(e,t,r){const o=this.string_lookup_replace(this.url,this.extra_url_vars);let l,i,n,s;return this.use_latlon?[i,s,l,n]=this.get_tile_geographic_bounds(e,t,r):[i,s,l,n]=this.get_tile_meter_bounds(e,t,r),o.replace("{XMIN}",i.toString()).replace("{YMIN}",s.toString()).replace("{XMAX}",l.toString()).replace("{YMAX}",n.toString())}}r.BBoxTileSource=s,i=s,s.__name__="BBoxTileSource",i.define((({Boolean:e})=>({use_latlon:[e,!1]})))},
function _(t,e,i,_,s){var r;_();const o=t(349),n=t(9),l=t(350);class u extends o.TileSource{constructor(t){super(t)}initialize(){super.initialize(),this._resolutions=(0,n.range)(this.min_zoom,this.max_zoom+1).map((t=>this.get_resolution(t)))}_computed_initial_resolution(){return null!=this.initial_resolution?this.initial_resolution:2*Math.PI*6378137/this.tile_size}is_valid_tile(t,e,i){return!(!this.wrap_around&&(t<0||t>=2**i))&&!(e<0||e>=2**i)}parent_by_tile_xyz(t,e,i){const _=this.tile_xyz_to_quadkey(t,e,i),s=_.substring(0,_.length-1);return this.quadkey_to_tile_xyz(s)}get_resolution(t){return this._computed_initial_resolution()/2**t}get_resolution_by_extent(t,e,i){return[(t[2]-t[0])/i,(t[3]-t[1])/e]}get_level_by_extent(t,e,i){const _=(t[2]-t[0])/i,s=(t[3]-t[1])/e,r=Math.max(_,s);let o=0;for(const t of this._resolutions){if(r>t){if(0==o)return 0;if(o>0)return o-1}o+=1}return o-1}get_closest_level_by_extent(t,e,i){const _=(t[2]-t[0])/i,s=(t[3]-t[1])/e,r=Math.max(_,s),o=this._resolutions.reduce((function(t,e){return Math.abs(e-r)<Math.abs(t-r)?e:t}));return this._resolutions.indexOf(o)}snap_to_zoom_level(t,e,i,_){const[s,r,o,n]=t,l=this._resolutions[_];let u=i*l,a=e*l;if(!this.snap_to_zoom){const t=(o-s)/u,e=(n-r)/a;t>e?(u=o-s,a*=t):(u*=e,a=n-r)}const h=(u-(o-s))/2,c=(a-(n-r))/2;return[s-h,r-c,o+h,n+c]}tms_to_wmts(t,e,i){return[t,2**i-1-e,i]}wmts_to_tms(t,e,i){return[t,2**i-1-e,i]}pixels_to_meters(t,e,i){const _=this.get_resolution(i);return[t*_-this.x_origin_offset,e*_-this.y_origin_offset]}meters_to_pixels(t,e,i){const _=this.get_resolution(i);return[(t+this.x_origin_offset)/_,(e+this.y_origin_offset)/_]}pixels_to_tile(t,e){let i=Math.ceil(t/this.tile_size);i=0===i?i:i-1;return[i,Math.max(Math.ceil(e/this.tile_size)-1,0)]}pixels_to_raster(t,e,i){return[t,(this.tile_size<<i)-e]}meters_to_tile(t,e,i){const[_,s]=this.meters_to_pixels(t,e,i);return this.pixels_to_tile(_,s)}get_tile_meter_bounds(t,e,i){const[_,s]=this.pixels_to_meters(t*this.tile_size,e*this.tile_size,i),[r,o]=this.pixels_to_meters((t+1)*this.tile_size,(e+1)*this.tile_size,i);return[_,s,r,o]}get_tile_geographic_bounds(t,e,i){const _=this.get_tile_meter_bounds(t,e,i),[s,r,o,n]=(0,l.meters_extent_to_geographic)(_);return[s,r,o,n]}get_tiles_by_extent(t,e,i=1){const[_,s,r,o]=t;let[n,l]=this.meters_to_tile(_,s,e),[u,a]=this.meters_to_tile(r,o,e);n-=i,l-=i,u+=i,a+=i;const h=[];for(let t=a;t>=l;t--)for(let i=n;i<=u;i++)this.is_valid_tile(i,t,e)&&h.push([i,t,e,this.get_tile_meter_bounds(i,t,e)]);return this.sort_tiles_from_center(h,[n,l,u,a]),h}quadkey_to_tile_xyz(t){let e=0,i=0;const _=t.length;for(let s=_;s>0;s--){const r=1<<s-1;switch(t.charAt(_-s)){case"0":continue;case"1":e|=r;break;case"2":i|=r;break;case"3":e|=r,i|=r;break;default:throw new TypeError(`Invalid Quadkey: ${t}`)}}return[e,i,_]}tile_xyz_to_quadkey(t,e,i){let _="";for(let s=i;s>0;s--){const i=1<<s-1;let r=0;0!=(t&i)&&(r+=1),0!=(e&i)&&(r+=2),_+=r.toString()}return _}children_by_tile_xyz(t,e,i){const _=this.tile_xyz_to_quadkey(t,e,i),s=[];for(let t=0;t<=3;t++){const[e,i,r]=this.quadkey_to_tile_xyz(_+t.toString()),o=this.get_tile_meter_bounds(e,i,r);s.push([e,i,r,o])}return s}get_closest_parent_by_tile_xyz(t,e,i){const _=this.calculate_world_x_by_tile_xyz(t,e,i);[t,e,i]=this.normalize_xyz(t,e,i);let s=this.tile_xyz_to_quadkey(t,e,i);for(;s.length>0;)if(s=s.substring(0,s.length-1),[t,e,i]=this.quadkey_to_tile_xyz(s),[t,e,i]=this.denormalize_xyz(t,e,i,_),this.tiles.has(this.tile_xyz_to_key(t,e,i)))return[t,e,i];return[0,0,0]}normalize_xyz(t,e,i){if(this.wrap_around){const _=2**i;return[(t%_+_)%_,e,i]}return[t,e,i]}denormalize_xyz(t,e,i,_){return[t+_*2**i,e,i]}denormalize_meters(t,e,i,_){return[t+2*_*Math.PI*6378137,e]}calculate_world_x_by_tile_xyz(t,e,i){return Math.floor(t/2**i)}}i.MercatorTileSource=u,r=u,u.__name__="MercatorTileSource",r.define((({Boolean:t})=>({snap_to_zoom:[t,!1],wrap_around:[t,!0]}))),r.override({x_origin_offset:20037508.34,y_origin_offset:20037508.34,initial_resolution:156543.03392804097})},
function _(e,t,r,i,n){var l;i();const a=e(53),s=e(13);class c extends a.Model{constructor(e){super(e)}initialize(){super.initialize(),this.tiles=new Map,this._normalize_case()}connect_signals(){super.connect_signals(),this.connect(this.change,(()=>this._clear_cache()))}string_lookup_replace(e,t){let r=e;for(const[e,i]of(0,s.entries)(t))r=r.replace(`{${e}}`,i);return r}_normalize_case(){const e=this.url.replace("{x}","{X}").replace("{y}","{Y}").replace("{z}","{Z}").replace("{q}","{Q}").replace("{xmin}","{XMIN}").replace("{ymin}","{YMIN}").replace("{xmax}","{XMAX}").replace("{ymax}","{YMAX}");this.url=e}_clear_cache(){this.tiles=new Map}tile_xyz_to_key(e,t,r){return`${e}:${t}:${r}`}key_to_tile_xyz(e){const[t,r,i]=e.split(":").map((e=>parseInt(e)));return[t,r,i]}sort_tiles_from_center(e,t){const[r,i,n,l]=t,a=(n-r)/2+r,s=(l-i)/2+i;e.sort((function(e,t){return Math.sqrt((a-e[0])**2+(s-e[1])**2)-Math.sqrt((a-t[0])**2+(s-t[1])**2)}))}get_image_url(e,t,r){return this.string_lookup_replace(this.url,this.extra_url_vars).replace("{X}",e.toString()).replace("{Y}",t.toString()).replace("{Z}",r.toString())}}r.TileSource=c,l=c,c.__name__="TileSource",l.define((({Number:e,String:t,Dict:r,Nullable:i})=>({url:[t,""],tile_size:[e,256],max_zoom:[e,30],min_zoom:[e,0],extra_url_vars:[r(t),{}],attribution:[t,""],x_origin_offset:[e],y_origin_offset:[e],initial_resolution:[i(e),null]})))},
function _(t,e,r,n,o){n();const c=t(78);function _(t,e){return c.wgs84_mercator.compute(t,e)}function g(t,e){return c.wgs84_mercator.invert(t,e)}r.geographic_to_meters=_,r.meters_to_geographic=g,r.geographic_extent_to_meters=function(t){const[e,r,n,o]=t,[c,g]=_(e,r),[i,u]=_(n,o);return[c,g,i,u]},r.meters_extent_to_geographic=function(t){const[e,r,n,o]=t,[c,_]=g(e,r),[i,u]=g(n,o);return[c,_,i,u]}},
function _(e,t,r,s,_){s();const o=e(348);class c extends o.MercatorTileSource{constructor(e){super(e)}get_image_url(e,t,r){const s=this.string_lookup_replace(this.url,this.extra_url_vars),[_,o,c]=this.tms_to_wmts(e,t,r),i=this.tile_xyz_to_quadkey(_,o,c);return s.replace("{Q}",i)}}r.QUADKEYTileSource=c,c.__name__="QUADKEYTileSource"},
function _(t,e,i,s,_){s();const n=t(1);var a;const o=t(349),r=t(353),h=t(41),l=t(58),d=t(43),m=t(136),c=t(9),u=t(8),p=(0,n.__importStar)(t(354));class g extends h.RendererView{initialize(){this._tiles=[],super.initialize()}connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>this.request_render())),this.connect(this.model.tile_source.change,(()=>this.request_render()))}remove(){null!=this.attribution_el&&(0,d.removeElement)(this.attribution_el),super.remove()}styles(){return[...super.styles(),p.default]}get_extent(){return[this.x_range.start,this.y_range.start,this.x_range.end,this.y_range.end]}get map_plot(){return this.plot_model}get map_canvas(){return this.layer.ctx}get map_frame(){return this.plot_view.frame}get x_range(){return this.map_plot.x_range}get y_range(){return this.map_plot.y_range}_set_data(){this.extent=this.get_extent(),this._last_height=void 0,this._last_width=void 0}_update_attribution(){null!=this.attribution_el&&(0,d.removeElement)(this.attribution_el);const{attribution:t}=this.model.tile_source;if((0,u.isString)(t)&&t.length>0){const{layout:e,frame:i}=this.plot_view,s=e.bbox.width-i.bbox.right,_=e.bbox.height-i.bbox.bottom,n=i.bbox.width;this.attribution_el=(0,d.div)({class:p.tile_attribution,style:{position:"absolute",right:`${s}px`,bottom:`${_}px`,"max-width":n-4+"px",padding:"2px","background-color":"rgba(255,255,255,0.5)","font-size":"9px","line-height":"1.05","white-space":"nowrap",overflow:"hidden","text-overflow":"ellipsis"}}),this.plot_view.canvas_view.add_event(this.attribution_el),this.attribution_el.innerHTML=t,this.attribution_el.title=this.attribution_el.textContent.replace(/\s*\n\s*/g," ")}}_map_data(){this.initial_extent=this.get_extent();const t=this.model.tile_source.get_level_by_extent(this.initial_extent,this.map_frame.bbox.height,this.map_frame.bbox.width),e=this.model.tile_source.snap_to_zoom_level(this.initial_extent,this.map_frame.bbox.height,this.map_frame.bbox.width,t);this.x_range.start=e[0],this.y_range.start=e[1],this.x_range.end=e[2],this.y_range.end=e[3],this.x_range instanceof l.Range1d&&(this.x_range.reset_start=e[0],this.x_range.reset_end=e[2]),this.y_range instanceof l.Range1d&&(this.y_range.reset_start=e[1],this.y_range.reset_end=e[3]),this._update_attribution()}_create_tile(t,e,i,s,_=!1){const n=this.model.tile_source.tile_xyz_to_quadkey(t,e,i),a=this.model.tile_source.tile_xyz_to_key(t,e,i);if(this.model.tile_source.tiles.has(a))return;const[o,r,h]=this.model.tile_source.normalize_xyz(t,e,i),l=this.model.tile_source.get_image_url(o,r,h),d={img:void 0,tile_coords:[t,e,i],normalized_coords:[o,r,h],quadkey:n,cache_key:a,bounds:s,loaded:!1,finished:!1,x_coord:s[0],y_coord:s[3]};this.model.tile_source.tiles.set(a,d),this._tiles.push(d),new m.ImageLoader(l,{loaded:t=>{Object.assign(d,{img:t,loaded:!0}),_?(d.finished=!0,this.notify_finished()):this.request_render()},failed(){d.finished=!0}})}_enforce_aspect_ratio(){if(this._last_height!==this.map_frame.bbox.height||this._last_width!==this.map_frame.bbox.width){const t=this.get_extent(),e=this.model.tile_source.get_level_by_extent(t,this.map_frame.bbox.height,this.map_frame.bbox.width),i=this.model.tile_source.snap_to_zoom_level(t,this.map_frame.bbox.height,this.map_frame.bbox.width,e);this.x_range.setv({start:i[0],end:i[2]}),this.y_range.setv({start:i[1],end:i[3]}),this.extent=i,this._last_height=this.map_frame.bbox.height,this._last_width=this.map_frame.bbox.width}}has_finished(){if(!super.has_finished())return!1;if(0==this._tiles.length)return!1;for(const t of this._tiles)if(!t.finished)return!1;return!0}_render(){null==this.map_initialized&&(this._set_data(),this._map_data(),this.map_initialized=!0),this._enforce_aspect_ratio(),this._update(),null!=this.prefetch_timer&&clearTimeout(this.prefetch_timer),this.prefetch_timer=setTimeout(this._prefetch_tiles.bind(this),500),this.has_finished()&&this.notify_finished()}_draw_tile(t){const e=this.model.tile_source.tiles.get(t);if(null!=e&&e.loaded){const[[t],[i]]=this.coordinates.map_to_screen([e.bounds[0]],[e.bounds[3]]),[[s],[_]]=this.coordinates.map_to_screen([e.bounds[2]],[e.bounds[1]]),n=s-t,a=_-i,o=t,r=i,h=this.map_canvas.getImageSmoothingEnabled();this.map_canvas.setImageSmoothingEnabled(this.model.smoothing),this.map_canvas.drawImage(e.img,o,r,n,a),this.map_canvas.setImageSmoothingEnabled(h),e.finished=!0}}_set_rect(){const t=this.plot_model.outline_line_width,e=this.map_frame.bbox.left+t/2,i=this.map_frame.bbox.top+t/2,s=this.map_frame.bbox.width-t,_=this.map_frame.bbox.height-t;this.map_canvas.rect(e,i,s,_),this.map_canvas.clip()}_render_tiles(t){this.map_canvas.save(),this._set_rect(),this.map_canvas.globalAlpha=this.model.alpha;for(const e of t)this._draw_tile(e);this.map_canvas.restore()}_prefetch_tiles(){const{tile_source:t}=this.model,e=this.get_extent(),i=this.map_frame.bbox.height,s=this.map_frame.bbox.width,_=this.model.tile_source.get_level_by_extent(e,i,s),n=this.model.tile_source.get_tiles_by_extent(e,_);for(let e=0,i=Math.min(10,n.length);e<i;e++){const[i,s,_]=n[e],a=this.model.tile_source.children_by_tile_xyz(i,s,_);for(const e of a){const[i,s,_,n]=e;t.tiles.has(t.tile_xyz_to_key(i,s,_))||this._create_tile(i,s,_,n,!0)}}}_fetch_tiles(t){for(const e of t){const[t,i,s,_]=e;this._create_tile(t,i,s,_)}}_update(){const{tile_source:t}=this.model,{min_zoom:e}=t,{max_zoom:i}=t;let s=this.get_extent();const _=this.extent[2]-this.extent[0]<s[2]-s[0],n=this.map_frame.bbox.height,a=this.map_frame.bbox.width;let o=t.get_level_by_extent(s,n,a),r=!1;o<e?(s=this.extent,o=e,r=!0):o>i&&(s=this.extent,o=i,r=!0),r&&(this.x_range.setv({start:s[0],end:s[2]}),this.y_range.setv({start:s[1],end:s[3]})),this.extent=s;const h=t.get_tiles_by_extent(s,o),l=[],d=[],m=[],u=[];for(const e of h){const[i,s,n]=e,a=t.tile_xyz_to_key(i,s,n),o=t.tiles.get(a);if(null!=o&&o.loaded)d.push(a);else if(this.model.render_parents){const[e,a,o]=t.get_closest_parent_by_tile_xyz(i,s,n),r=t.tile_xyz_to_key(e,a,o),h=t.tiles.get(r);if(null!=h&&h.loaded&&!(0,c.includes)(m,r)&&m.push(r),_){const e=t.children_by_tile_xyz(i,s,n);for(const[i,s,_]of e){const e=t.tile_xyz_to_key(i,s,_);t.tiles.has(e)&&u.push(e)}}}null==o&&l.push(e)}this._render_tiles(m),this._render_tiles(u),this._render_tiles(d),null!=this.render_timer&&clearTimeout(this.render_timer),this.render_timer=setTimeout((()=>this._fetch_tiles(l)),65)}}i.TileRendererView=g,g.__name__="TileRendererView";class b extends h.Renderer{constructor(t){super(t)}}i.TileRenderer=b,a=b,b.__name__="TileRenderer",a.prototype.default_view=g,a.define((({Boolean:t,Number:e,Ref:i})=>({alpha:[e,1],smoothing:[t,!0],tile_source:[i(o.TileSource),()=>new r.WMTSTileSource],render_parents:[t,!0]}))),a.override({level:"image"})},
function _(t,e,r,o,s){o();const c=t(348);class i extends c.MercatorTileSource{constructor(t){super(t)}get_image_url(t,e,r){const o=this.string_lookup_replace(this.url,this.extra_url_vars),[s,c,i]=this.tms_to_wmts(t,e,r);return o.replace("{X}",s.toString()).replace("{Y}",c.toString()).replace("{Z}",i.toString())}}r.WMTSTileSource=i,i.__name__="WMTSTileSource"},
function _(t,o,i,b,r){b(),i.root="bk-root",i.tile_attribution="bk-tile-attribution",i.default=".bk-root .bk-tile-attribution a{color:black;}"},
function _(e,r,t,c,o){c();const i=e(348);class l extends i.MercatorTileSource{constructor(e){super(e)}get_image_url(e,r,t){return this.string_lookup_replace(this.url,this.extra_url_vars).replace("{X}",e.toString()).replace("{Y}",r.toString()).replace("{Z}",t.toString())}}t.TMSTileSource=l,l.__name__="TMSTileSource"},
function _(e,t,u,a,r){a(),r("CanvasTexture",e(357).CanvasTexture),r("ImageURLTexture",e(359).ImageURLTexture),r("Texture",e(358).Texture)},
function _(t,e,n,c,s){var r;c();const o=t(358),a=t(34);class u extends o.Texture{constructor(t){super(t)}get func(){const t=(0,a.use_strict)(this.code);return new Function("ctx","color","scale","weight",t)}get_pattern(t,e,n){const c=document.createElement("canvas");c.width=e,c.height=e;const s=c.getContext("2d");return this.func.call(this,s,t,e,n),c}}n.CanvasTexture=u,r=u,u.__name__="CanvasTexture",r.define((({String:t})=>({code:[t]})))},
function _(e,t,n,r,o){var i;r();const s=e(53),u=e(20);class c extends s.Model{constructor(e){super(e)}}n.Texture=c,i=c,c.__name__="Texture",i.define((()=>({repetition:[u.TextureRepetition,"repeat"]})))},
function _(e,t,i,r,n){var a;r();const s=e(358),o=e(136);class u extends s.Texture{constructor(e){super(e)}initialize(){super.initialize(),this._loader=new o.ImageLoader(this.url)}get_pattern(e,t,i){const{_loader:r}=this;return this._loader.finished?r.image:r.promise}}i.ImageURLTexture=u,a=u,u.__name__="ImageURLTexture",a.define((({String:e})=>({url:[e]})))},
function _(o,l,T,e,t){e(),t("ActionTool",o(238).ActionTool),t("CustomAction",o(361).CustomAction),t("HelpTool",o(239).HelpTool),t("RedoTool",o(362).RedoTool),t("ResetTool",o(363).ResetTool),t("SaveTool",o(364).SaveTool),t("UndoTool",o(365).UndoTool),t("ZoomInTool",o(366).ZoomInTool),t("ZoomOutTool",o(369).ZoomOutTool),t("ButtonTool",o(224).ButtonTool),t("EditTool",o(370).EditTool),t("BoxEditTool",o(371).BoxEditTool),t("FreehandDrawTool",o(372).FreehandDrawTool),t("PointDrawTool",o(373).PointDrawTool),t("PolyDrawTool",o(374).PolyDrawTool),t("PolyTool",o(375).PolyTool),t("PolyEditTool",o(376).PolyEditTool),t("BoxSelectTool",o(377).BoxSelectTool),t("BoxZoomTool",o(379).BoxZoomTool),t("GestureTool",o(223).GestureTool),t("LassoSelectTool",o(380).LassoSelectTool),t("LineEditTool",o(382).LineEditTool),t("PanTool",o(384).PanTool),t("PolySelectTool",o(381).PolySelectTool),t("RangeTool",o(385).RangeTool),t("SelectTool",o(378).SelectTool),t("TapTool",o(386).TapTool),t("WheelPanTool",o(387).WheelPanTool),t("WheelZoomTool",o(388).WheelZoomTool),t("CrosshairTool",o(389).CrosshairTool),t("CustomJSHover",o(390).CustomJSHover),t("HoverTool",o(391).HoverTool),t("InspectTool",o(232).InspectTool),t("Tool",o(222).Tool),t("ToolProxy",o(394).ToolProxy),t("Toolbar",o(221).Toolbar),t("ToolbarBase",o(233).ToolbarBase),t("ProxyToolbar",o(395).ProxyToolbar),t("ToolbarBox",o(395).ToolbarBox)},
function _(t,o,e,s,n){var c;s();const i=t(238);class u extends i.ActionToolButtonView{css_classes(){return super.css_classes().concat("bk-toolbar-button-custom-action")}}e.CustomActionButtonView=u,u.__name__="CustomActionButtonView";class l extends i.ActionToolView{doit(){var t;null===(t=this.model.callback)||void 0===t||t.execute(this.model)}}e.CustomActionView=l,l.__name__="CustomActionView";class a extends i.ActionTool{constructor(t){super(t),this.tool_name="Custom Action",this.button_view=u}}e.CustomAction=a,c=a,a.__name__="CustomAction",c.prototype.default_view=l,c.define((({Any:t,String:o,Nullable:e})=>({callback:[e(t)],icon:[o]}))),c.override({description:"Perform a Custom Action"})},
function _(e,o,t,i,s){var n;i();const l=e(238),_=e(228);class d extends l.ActionToolView{connect_signals(){super.connect_signals(),this.connect(this.plot_view.state.changed,(()=>this.model.disabled=!this.plot_view.state.can_redo))}doit(){const e=this.plot_view.state.redo();null!=(null==e?void 0:e.range)&&this.plot_view.trigger_ranges_update_event()}}t.RedoToolView=d,d.__name__="RedoToolView";class a extends l.ActionTool{constructor(e){super(e),this.tool_name="Redo",this.icon=_.tool_icon_redo}}t.RedoTool=a,n=a,a.__name__="RedoTool",n.prototype.default_view=d,n.override({disabled:!0}),n.register_alias("redo",(()=>new a))},
function _(e,o,t,s,i){var _;s();const n=e(238),l=e(228);class c extends n.ActionToolView{doit(){this.plot_view.reset()}}t.ResetToolView=c,c.__name__="ResetToolView";class r extends n.ActionTool{constructor(e){super(e),this.tool_name="Reset",this.icon=l.tool_icon_reset}}t.ResetTool=r,_=r,r.__name__="ResetTool",_.prototype.default_view=c,_.register_alias("reset",(()=>new r))},
function _(e,o,t,a,i){var s;a();const c=e(238),n=e(228);class l extends c.ActionToolView{async copy(){const e=await this.plot_view.to_blob(),o=new ClipboardItem({[e.type]:Promise.resolve(e)});await navigator.clipboard.write([o])}async save(e){const o=await this.plot_view.to_blob(),t=document.createElement("a");t.href=URL.createObjectURL(o),t.download=e,t.target="_blank",t.dispatchEvent(new MouseEvent("click"))}doit(e="save"){switch(e){case"save":this.save("bokeh_plot");break;case"copy":this.copy()}}}t.SaveToolView=l,l.__name__="SaveToolView";class r extends c.ActionTool{constructor(e){super(e),this.tool_name="Save",this.icon=n.tool_icon_save}get menu(){return[{icon:"bk-tool-icon-copy-to-clipboard",tooltip:"Copy image to clipboard",if:()=>"undefined"!=typeof ClipboardItem,handler:()=>{this.do.emit("copy")}}]}}t.SaveTool=r,s=r,r.__name__="SaveTool",s.prototype.default_view=l,s.register_alias("save",(()=>new r))},
function _(o,e,t,n,i){var s;n();const l=o(238),_=o(228);class d extends l.ActionToolView{connect_signals(){super.connect_signals(),this.connect(this.plot_view.state.changed,(()=>this.model.disabled=!this.plot_view.state.can_undo))}doit(){const o=this.plot_view.state.undo();null!=(null==o?void 0:o.range)&&this.plot_view.trigger_ranges_update_event()}}t.UndoToolView=d,d.__name__="UndoToolView";class a extends l.ActionTool{constructor(o){super(o),this.tool_name="Undo",this.icon=_.tool_icon_undo}}t.UndoTool=a,s=a,a.__name__="UndoTool",s.prototype.default_view=d,s.override({disabled:!0}),s.register_alias("undo",(()=>new a))},
function _(o,n,e,i,s){var t;i();const _=o(367),m=o(228);class a extends _.ZoomBaseToolView{}e.ZoomInToolView=a,a.__name__="ZoomInToolView";class l extends _.ZoomBaseTool{constructor(o){super(o),this.sign=1,this.tool_name="Zoom In",this.icon=m.tool_icon_zoom_in}}e.ZoomInTool=l,t=l,l.__name__="ZoomInTool",t.prototype.default_view=a,t.register_alias("zoom_in",(()=>new l({dimensions:"both"}))),t.register_alias("xzoom_in",(()=>new l({dimensions:"width"}))),t.register_alias("yzoom_in",(()=>new l({dimensions:"height"})))},
function _(o,t,e,i,s){var n;i();const a=o(238),_=o(20),l=o(368);class m extends a.ActionToolView{doit(){var o;const t=this.plot_view.frame,e=this.model.dimensions,i="width"==e||"both"==e,s="height"==e||"both"==e,n=(0,l.scale_range)(t,this.model.sign*this.model.factor,i,s);this.plot_view.state.push("zoom_out",{range:n}),this.plot_view.update_range(n,{scrolling:!0,maintain_focus:this.model.maintain_focus}),null===(o=this.model.document)||void 0===o||o.interactive_start(this.plot_model),this.plot_view.trigger_ranges_update_event()}}e.ZoomBaseToolView=m,m.__name__="ZoomBaseToolView";class h extends a.ActionTool{constructor(o){super(o),this.maintain_focus=!0}get tooltip(){return this._get_dim_tooltip(this.dimensions)}}e.ZoomBaseTool=h,n=h,h.__name__="ZoomBaseTool",n.define((({Percent:o})=>({factor:[o,.1],dimensions:[_.Dimensions,"both"]})))},
function _(n,t,o,r,s){r();const c=n(10);function e(n,t,o){const[r,s]=[n.start,n.end],c=null!=o?o:(s+r)/2;return[r-(r-c)*t,s-(s-c)*t]}function a(n,[t,o]){const r=new Map;for(const[s,c]of n){const[n,e]=c.r_invert(t,o);r.set(s,{start:n,end:e})}return r}o.scale_highlow=e,o.get_info=a,o.scale_range=function(n,t,o=!0,r=!0,s){t=(0,c.clamp)(t,-.9,.9);const l=o?t:0,[u,i]=e(n.bbox.h_range,l,null!=s?s.x:void 0),_=a(n.x_scales,[u,i]),f=r?t:0,[g,x]=e(n.bbox.v_range,f,null!=s?s.y:void 0);return{xrs:_,yrs:a(n.y_scales,[g,x]),factor:t}}},
function _(o,e,t,i,s){var n;i();const _=o(367),a=o(228);class m extends _.ZoomBaseToolView{}t.ZoomOutToolView=m,m.__name__="ZoomOutToolView";class l extends _.ZoomBaseTool{constructor(o){super(o),this.sign=-1,this.tool_name="Zoom Out",this.icon=a.tool_icon_zoom_out}}t.ZoomOutTool=l,n=l,l.__name__="ZoomOutTool",n.prototype.default_view=m,n.define((({Boolean:o})=>({maintain_focus:[o,!0]}))),n.register_alias("zoom_out",(()=>new l({dimensions:"both"}))),n.register_alias("xzoom_out",(()=>new l({dimensions:"width"}))),n.register_alias("yzoom_out",(()=>new l({dimensions:"height"})))},
function _(e,t,s,o,n){var r;o();const i=e(9),c=e(8),a=e(11),_=e(175),l=e(223);class d extends l.GestureToolView{constructor(){super(...arguments),this._mouse_in_frame=!0}_select_mode(e){const{shiftKey:t,ctrlKey:s}=e;return t||s?t&&!s?"append":!t&&s?"intersect":t&&s?"subtract":void(0,a.unreachable)():"replace"}_move_enter(e){this._mouse_in_frame=!0}_move_exit(e){this._mouse_in_frame=!1}_map_drag(e,t,s){if(!this.plot_view.frame.bbox.contains(e,t))return null;const o=this.plot_view.renderer_view(s);if(null==o)return null;return[o.coordinates.x_scale.invert(e),o.coordinates.y_scale.invert(t)]}_delete_selected(e){const t=e.data_source,s=t.selected.indices;s.sort();for(const e of t.columns()){const o=t.get_array(e);for(let e=0;e<s.length;e++){const t=s[e];o.splice(t-e,1)}}this._emit_cds_changes(t)}_pop_glyphs(e,t){const s=e.columns();if(t&&s.length)for(const o of s){let s=e.get_array(o);const n=s.length-t+1;n<1||((0,c.isArray)(s)||(s=Array.from(s),e.data[o]=s),s.splice(0,n))}}_emit_cds_changes(e,t=!0,s=!0,o=!0){s&&e.selection_manager.clear(),t&&e.change.emit(),o&&(e.data=e.data,e.properties.data.change.emit())}_drag_points(e,t,s="both"){if(null==this._basepoint)return;const[o,n]=this._basepoint;for(const r of t){const t=this._map_drag(o,n,r),i=this._map_drag(e.sx,e.sy,r);if(null==i||null==t)continue;const[c,a]=i,[_,l]=t,[d,u]=[c-_,a-l],h=r.glyph,m=r.data_source,[p,f]=[h.x.field,h.y.field];for(const e of m.selected.indices)!p||"width"!=s&&"both"!=s||(m.data[p][e]+=d),!f||"height"!=s&&"both"!=s||(m.data[f][e]+=u);m.change.emit()}this._basepoint=[e.sx,e.sy]}_pad_empty_columns(e,t){for(const s of e.columns())(0,i.includes)(t,s)||e.get_array(s).push(this.model.empty_value)}_select_event(e,t,s){const o=this.plot_view.frame,{sx:n,sy:r}=e;if(!o.bbox.contains(n,r))return[];const i={type:"point",sx:n,sy:r},c=[];for(const e of s){const s=e.get_selection_manager(),o=e.data_source,n=this.plot_view.renderer_view(e);if(null!=n){s.select([n],i,!0,t)&&c.push(e),o.properties.selected.change.emit()}}return c}}s.EditToolView=d,d.__name__="EditToolView";class u extends l.GestureTool{constructor(e){super(e)}get computed_icon(){var e;return null!==(e=this.custom_icon)&&void 0!==e?e:this.icon}}s.EditTool=u,r=u,u.__name__="EditTool",r.define((({Unknown:e,String:t,Array:s,Ref:o,Nullable:n})=>({custom_icon:[n(t),null],empty_value:[e],renderers:[s(o(_.GlyphRenderer)),[]]})))},
function _(e,t,s,i,_){var o;i();const n=e(43),a=e(20),d=e(370),l=e(228);class r extends d.EditToolView{_tap(e){null==this._draw_basepoint&&null==this._basepoint&&this._select_event(e,this._select_mode(e),this.model.renderers)}_keyup(e){if(this.model.active&&this._mouse_in_frame)for(const t of this.model.renderers)if(e.keyCode===n.Keys.Backspace)this._delete_selected(t);else if(e.keyCode==n.Keys.Esc){t.data_source.selection_manager.clear()}}_set_extent([e,t],[s,i],_,o=!1){const n=this.model.renderers[0],a=this.plot_view.renderer_view(n);if(null==a)return;const d=n.glyph,l=n.data_source,[r,h]=a.coordinates.x_scale.r_invert(e,t),[p,u]=a.coordinates.y_scale.r_invert(s,i),[c,m]=[(r+h)/2,(p+u)/2],[f,b]=[h-r,u-p],[y,x]=[d.x.field,d.y.field],[w,v]=[d.width.field,d.height.field];if(_)this._pop_glyphs(l,this.model.num_objects),y&&l.get_array(y).push(c),x&&l.get_array(x).push(m),w&&l.get_array(w).push(f),v&&l.get_array(v).push(b),this._pad_empty_columns(l,[y,x,w,v]);else{const e=l.data[y].length-1;y&&(l.data[y][e]=c),x&&(l.data[x][e]=m),w&&(l.data[w][e]=f),v&&(l.data[v][e]=b)}this._emit_cds_changes(l,!0,!1,o)}_update_box(e,t=!1,s=!1){if(null==this._draw_basepoint)return;const i=[e.sx,e.sy],_=this.plot_view.frame,o=this.model.dimensions,n=this.model._get_dim_limits(this._draw_basepoint,i,_,o);if(null!=n){const[e,i]=n;this._set_extent(e,i,t,s)}}_doubletap(e){this.model.active&&(null!=this._draw_basepoint?(this._update_box(e,!1,!0),this._draw_basepoint=null):(this._draw_basepoint=[e.sx,e.sy],this._select_event(e,"append",this.model.renderers),this._update_box(e,!0,!1)))}_move(e){this._update_box(e,!1,!1)}_pan_start(e){if(e.shiftKey){if(null!=this._draw_basepoint)return;this._draw_basepoint=[e.sx,e.sy],this._update_box(e,!0,!1)}else{if(null!=this._basepoint)return;this._select_event(e,"append",this.model.renderers),this._basepoint=[e.sx,e.sy]}}_pan(e,t=!1,s=!1){if(e.shiftKey){if(null==this._draw_basepoint)return;this._update_box(e,t,s)}else{if(null==this._basepoint)return;this._drag_points(e,this.model.renderers)}}_pan_end(e){if(this._pan(e,!1,!0),e.shiftKey)this._draw_basepoint=null;else{this._basepoint=null;for(const e of this.model.renderers)this._emit_cds_changes(e.data_source,!1,!0,!0)}}}s.BoxEditToolView=r,r.__name__="BoxEditToolView";class h extends d.EditTool{constructor(e){super(e),this.tool_name="Box Edit Tool",this.icon=l.tool_icon_box_edit,this.event_type=["tap","pan","move"],this.default_order=1}}s.BoxEditTool=h,o=h,h.__name__="BoxEditTool",o.prototype.default_view=r,o.define((({Int:e})=>({dimensions:[a.Dimensions,"both"],num_objects:[e,0]})))},
function _(e,t,a,s,r){var _;s();const d=e(43),o=e(8),n=e(370),i=e(228);class l extends n.EditToolView{_draw(e,t,a=!1){if(!this.model.active)return;const s=this.model.renderers[0],r=this._map_drag(e.sx,e.sy,s);if(null==r)return;const[_,d]=r,n=s.data_source,i=s.glyph,[l,h]=[i.xs.field,i.ys.field];if("new"==t)this._pop_glyphs(n,this.model.num_objects),l&&n.get_array(l).push([_]),h&&n.get_array(h).push([d]),this._pad_empty_columns(n,[l,h]);else if("add"==t){if(l){const e=n.data[l].length-1;let t=n.get_array(l)[e];(0,o.isArray)(t)||(t=Array.from(t),n.data[l][e]=t),t.push(_)}if(h){const e=n.data[h].length-1;let t=n.get_array(h)[e];(0,o.isArray)(t)||(t=Array.from(t),n.data[h][e]=t),t.push(d)}}this._emit_cds_changes(n,!0,!0,a)}_pan_start(e){this._draw(e,"new")}_pan(e){this._draw(e,"add")}_pan_end(e){this._draw(e,"add",!0)}_tap(e){this._select_event(e,this._select_mode(e),this.model.renderers)}_keyup(e){if(this.model.active&&this._mouse_in_frame)for(const t of this.model.renderers)e.keyCode===d.Keys.Esc?t.data_source.selection_manager.clear():e.keyCode===d.Keys.Backspace&&this._delete_selected(t)}}a.FreehandDrawToolView=l,l.__name__="FreehandDrawToolView";class h extends n.EditTool{constructor(e){super(e),this.tool_name="Freehand Draw Tool",this.icon=i.tool_icon_freehand_draw,this.event_type=["pan","tap"],this.default_order=3}}a.FreehandDrawTool=h,_=h,h.__name__="FreehandDrawTool",_.prototype.default_view=l,_.define((({Int:e})=>({num_objects:[e,0]}))),_.register_alias("freehand_draw",(()=>new h))},
function _(e,t,s,o,a){var i;o();const n=e(43),_=e(370),r=e(228);class d extends _.EditToolView{_tap(e){if(this._select_event(e,this._select_mode(e),this.model.renderers).length||!this.model.add)return;const t=this.model.renderers[0],s=this._map_drag(e.sx,e.sy,t);if(null==s)return;const o=t.glyph,a=t.data_source,[i,n]=[o.x.field,o.y.field],[_,r]=s;this._pop_glyphs(a,this.model.num_objects),i&&a.get_array(i).push(_),n&&a.get_array(n).push(r),this._pad_empty_columns(a,[i,n]),a.change.emit(),a.data=a.data,a.properties.data.change.emit()}_keyup(e){if(this.model.active&&this._mouse_in_frame)for(const t of this.model.renderers)e.keyCode===n.Keys.Backspace?this._delete_selected(t):e.keyCode==n.Keys.Esc&&t.data_source.selection_manager.clear()}_pan_start(e){this.model.drag&&(this._select_event(e,"append",this.model.renderers),this._basepoint=[e.sx,e.sy])}_pan(e){this.model.drag&&null!=this._basepoint&&this._drag_points(e,this.model.renderers)}_pan_end(e){if(this.model.drag){this._pan(e);for(const e of this.model.renderers)this._emit_cds_changes(e.data_source,!1,!0,!0);this._basepoint=null}}}s.PointDrawToolView=d,d.__name__="PointDrawToolView";class l extends _.EditTool{constructor(e){super(e),this.tool_name="Point Draw Tool",this.icon=r.tool_icon_point_draw,this.event_type=["tap","pan","move"],this.default_order=2}}s.PointDrawTool=l,i=l,l.__name__="PointDrawTool",i.prototype.default_view=d,i.define((({Boolean:e,Int:t})=>({add:[e,!0],drag:[e,!0],num_objects:[t,0]})))},
function _(e,t,s,i,a){var r;i();const o=e(43),n=e(8),d=e(375),_=e(228);class h extends d.PolyToolView{constructor(){super(...arguments),this._drawing=!1,this._initialized=!1}_tap(e){this._drawing?this._draw(e,"add",!0):this._select_event(e,this._select_mode(e),this.model.renderers)}_draw(e,t,s=!1){const i=this.model.renderers[0],a=this._map_drag(e.sx,e.sy,i);if(this._initialized||this.activate(),null==a)return;const[r,o]=this._snap_to_vertex(e,...a),d=i.data_source,_=i.glyph,[h,l]=[_.xs.field,_.ys.field];if("new"==t)this._pop_glyphs(d,this.model.num_objects),h&&d.get_array(h).push([r,r]),l&&d.get_array(l).push([o,o]),this._pad_empty_columns(d,[h,l]);else if("edit"==t){if(h){const e=d.data[h][d.data[h].length-1];e[e.length-1]=r}if(l){const e=d.data[l][d.data[l].length-1];e[e.length-1]=o}}else if("add"==t){if(h){const e=d.data[h].length-1;let t=d.get_array(h)[e];const s=t[t.length-1];t[t.length-1]=r,(0,n.isArray)(t)||(t=Array.from(t),d.data[h][e]=t),t.push(s)}if(l){const e=d.data[l].length-1;let t=d.get_array(l)[e];const s=t[t.length-1];t[t.length-1]=o,(0,n.isArray)(t)||(t=Array.from(t),d.data[l][e]=t),t.push(s)}}this._emit_cds_changes(d,!0,!1,s)}_show_vertices(){if(!this.model.active)return;const e=[],t=[];for(let s=0;s<this.model.renderers.length;s++){const i=this.model.renderers[s],a=i.data_source,r=i.glyph,[o,n]=[r.xs.field,r.ys.field];if(o)for(const t of a.get_array(o))e.push(...t);if(n)for(const e of a.get_array(n))t.push(...e);this._drawing&&s==this.model.renderers.length-1&&(e.splice(e.length-1,1),t.splice(t.length-1,1))}this._set_vertices(e,t)}_doubletap(e){this.model.active&&(this._drawing?(this._drawing=!1,this._draw(e,"edit",!0)):(this._drawing=!0,this._draw(e,"new",!0)))}_move(e){this._drawing&&this._draw(e,"edit")}_remove(){const e=this.model.renderers[0],t=e.data_source,s=e.glyph,[i,a]=[s.xs.field,s.ys.field];if(i){const e=t.data[i].length-1,s=t.get_array(i)[e];s.splice(s.length-1,1)}if(a){const e=t.data[a].length-1,s=t.get_array(a)[e];s.splice(s.length-1,1)}this._emit_cds_changes(t)}_keyup(e){if(this.model.active&&this._mouse_in_frame)for(const t of this.model.renderers)e.keyCode===o.Keys.Backspace?this._delete_selected(t):e.keyCode==o.Keys.Esc&&(this._drawing&&(this._remove(),this._drawing=!1),t.data_source.selection_manager.clear())}_pan_start(e){this.model.drag&&(this._select_event(e,"append",this.model.renderers),this._basepoint=[e.sx,e.sy])}_pan(e){if(null==this._basepoint||!this.model.drag)return;const[t,s]=this._basepoint;for(const i of this.model.renderers){const a=this._map_drag(t,s,i),r=this._map_drag(e.sx,e.sy,i);if(null==r||null==a)continue;const o=i.data_source,n=i.glyph,[d,_]=[n.xs.field,n.ys.field];if(!d&&!_)continue;const[h,l]=r,[c,g]=a,[f,p]=[h-c,l-g];for(const e of o.selected.indices){let t,s,i;d&&(s=o.data[d][e]),_?(i=o.data[_][e],t=i.length):t=s.length;for(let e=0;e<t;e++)s&&(s[e]+=f),i&&(i[e]+=p)}o.change.emit()}this._basepoint=[e.sx,e.sy]}_pan_end(e){if(this.model.drag){this._pan(e);for(const e of this.model.renderers)this._emit_cds_changes(e.data_source);this._basepoint=null}}activate(){if(this.model.vertex_renderer&&this.model.active){if(this._show_vertices(),!this._initialized)for(const e of this.model.renderers){const t=e.data_source;t.connect(t.properties.data.change,(()=>this._show_vertices()))}this._initialized=!0}}deactivate(){this._drawing&&(this._remove(),this._drawing=!1),this.model.vertex_renderer&&this._hide_vertices()}}s.PolyDrawToolView=h,h.__name__="PolyDrawToolView";class l extends d.PolyTool{constructor(e){super(e),this.tool_name="Polygon Draw Tool",this.icon=_.tool_icon_poly_draw,this.event_type=["pan","tap","move"],this.default_order=3}}s.PolyDrawTool=l,r=l,l.__name__="PolyDrawTool",r.prototype.default_view=h,r.define((({Boolean:e,Int:t})=>({drag:[e,!0],num_objects:[t,0]})))},
function _(e,r,t,s,o){var _;s();const d=e(8),i=e(370);class l extends i.EditToolView{_set_vertices(e,r){const t=this.model.vertex_renderer.glyph,s=this.model.vertex_renderer.data_source,[o,_]=[t.x.field,t.y.field];o&&((0,d.isArray)(e)?s.data[o]=e:t.x={value:e}),_&&((0,d.isArray)(r)?s.data[_]=r:t.y={value:r}),this._emit_cds_changes(s,!0,!0,!1)}_hide_vertices(){this._set_vertices([],[])}_snap_to_vertex(e,r,t){if(this.model.vertex_renderer){const s=this._select_event(e,"replace",[this.model.vertex_renderer]),o=this.model.vertex_renderer.data_source,_=this.model.vertex_renderer.glyph,[d,i]=[_.x.field,_.y.field];if(s.length){const e=o.selected.indices[0];d&&(r=o.data[d][e]),i&&(t=o.data[i][e]),o.selection_manager.clear()}}return[r,t]}}t.PolyToolView=l,l.__name__="PolyToolView";class n extends i.EditTool{constructor(e){super(e)}}t.PolyTool=n,_=n,n.__name__="PolyTool",_.define((({AnyRef:e})=>({vertex_renderer:[e()]})))},
function _(e,t,s,r,i){var _;r();const d=e(43),n=e(8),l=e(375),a=e(228);class c extends l.PolyToolView{constructor(){super(...arguments),this._drawing=!1,this._cur_index=null}_doubletap(e){if(!this.model.active)return;const t=this._map_drag(e.sx,e.sy,this.model.vertex_renderer);if(null==t)return;const[s,r]=t,i=this._select_event(e,"replace",[this.model.vertex_renderer]),_=this.model.vertex_renderer.data_source,d=this.model.vertex_renderer.glyph,[n,l]=[d.x.field,d.y.field];if(i.length&&null!=this._selected_renderer){const e=_.selected.indices[0];this._drawing?(this._drawing=!1,_.selection_manager.clear()):(_.selected.indices=[e+1],n&&_.get_array(n).splice(e+1,0,s),l&&_.get_array(l).splice(e+1,0,r),this._drawing=!0),_.change.emit(),this._emit_cds_changes(this._selected_renderer.data_source)}else this._show_vertices(e)}_show_vertices(e){if(!this.model.active)return;const t=this.model.renderers[0],s=()=>this._update_vertices(t),r=null==t?void 0:t.data_source,i=this._select_event(e,"replace",this.model.renderers);if(!i.length)return this._set_vertices([],[]),this._selected_renderer=null,this._drawing=!1,this._cur_index=null,void(null!=r&&r.disconnect(r.properties.data.change,s));null!=r&&r.connect(r.properties.data.change,s),this._cur_index=i[0].data_source.selected.indices[0],this._update_vertices(i[0])}_update_vertices(e){const t=e.glyph,s=e.data_source,r=this._cur_index,[i,_]=[t.xs.field,t.ys.field];if(this._drawing)return;if(null==r&&(i||_))return;let d,l;i&&null!=r?(d=s.data[i][r],(0,n.isArray)(d)||(s.data[i][r]=d=Array.from(d))):d=t.xs.value,_&&null!=r?(l=s.data[_][r],(0,n.isArray)(l)||(s.data[_][r]=l=Array.from(l))):l=t.ys.value,this._selected_renderer=e,this._set_vertices(d,l)}_move(e){if(this._drawing&&null!=this._selected_renderer){const t=this.model.vertex_renderer,s=t.data_source,r=t.glyph,i=this._map_drag(e.sx,e.sy,t);if(null==i)return;let[_,d]=i;const n=s.selected.indices;[_,d]=this._snap_to_vertex(e,_,d),s.selected.indices=n;const[l,a]=[r.x.field,r.y.field],c=n[0];l&&(s.data[l][c]=_),a&&(s.data[a][c]=d),s.change.emit(),this._selected_renderer.data_source.change.emit()}}_tap(e){const t=this.model.vertex_renderer,s=this._map_drag(e.sx,e.sy,t);if(null==s)return;if(this._drawing&&this._selected_renderer){let[r,i]=s;const _=t.data_source,d=t.glyph,[n,l]=[d.x.field,d.y.field],a=_.selected.indices;[r,i]=this._snap_to_vertex(e,r,i);const c=a[0];if(_.selected.indices=[c+1],n){const e=_.get_array(n),t=e[c];e[c]=r,e.splice(c+1,0,t)}if(l){const e=_.get_array(l),t=e[c];e[c]=i,e.splice(c+1,0,t)}return _.change.emit(),void this._emit_cds_changes(this._selected_renderer.data_source,!0,!1,!0)}const r=this._select_mode(e);this._select_event(e,r,[t]),this._select_event(e,r,this.model.renderers)}_remove_vertex(){if(!this._drawing||!this._selected_renderer)return;const e=this.model.vertex_renderer,t=e.data_source,s=e.glyph,r=t.selected.indices[0],[i,_]=[s.x.field,s.y.field];i&&t.get_array(i).splice(r,1),_&&t.get_array(_).splice(r,1),t.change.emit(),this._emit_cds_changes(this._selected_renderer.data_source)}_pan_start(e){this._select_event(e,"append",[this.model.vertex_renderer]),this._basepoint=[e.sx,e.sy]}_pan(e){null!=this._basepoint&&(this._drag_points(e,[this.model.vertex_renderer]),this._selected_renderer&&this._selected_renderer.data_source.change.emit())}_pan_end(e){null!=this._basepoint&&(this._drag_points(e,[this.model.vertex_renderer]),this._emit_cds_changes(this.model.vertex_renderer.data_source,!1,!0,!0),this._selected_renderer&&this._emit_cds_changes(this._selected_renderer.data_source),this._basepoint=null)}_keyup(e){if(!this.model.active||!this._mouse_in_frame)return;let t;t=this._selected_renderer?[this.model.vertex_renderer]:this.model.renderers;for(const s of t)e.keyCode===d.Keys.Backspace?(this._delete_selected(s),this._selected_renderer&&this._emit_cds_changes(this._selected_renderer.data_source)):e.keyCode==d.Keys.Esc&&(this._drawing?(this._remove_vertex(),this._drawing=!1):this._selected_renderer&&this._hide_vertices(),s.data_source.selection_manager.clear())}deactivate(){this._selected_renderer&&(this._drawing&&(this._remove_vertex(),this._drawing=!1),this._hide_vertices())}}s.PolyEditToolView=c,c.__name__="PolyEditToolView";class o extends l.PolyTool{constructor(e){super(e),this.tool_name="Poly Edit Tool",this.icon=a.tool_icon_poly_edit,this.event_type=["tap","pan","move"],this.default_order=4}}s.PolyEditTool=o,_=o,o.__name__="PolyEditTool",_.prototype.default_view=c},
function _(e,t,o,s,i){var l;s();const n=e(378),_=e(116),c=e(20),r=e(228);class a extends n.SelectToolView{_compute_limits(e){const t=this.plot_view.frame,o=this.model.dimensions;let s=this._base_point;if("center"==this.model.origin){const[t,o]=s,[i,l]=e;s=[t-(i-t),o-(l-o)]}return this.model._get_dim_limits(s,e,t,o)}_pan_start(e){const{sx:t,sy:o}=e;this._base_point=[t,o]}_pan(e){const{sx:t,sy:o}=e,s=[t,o],[i,l]=this._compute_limits(s);this.model.overlay.update({left:i[0],right:i[1],top:l[0],bottom:l[1]}),this.model.select_every_mousemove&&this._do_select(i,l,!1,this._select_mode(e))}_pan_end(e){const{sx:t,sy:o}=e,s=[t,o],[i,l]=this._compute_limits(s);this._do_select(i,l,!0,this._select_mode(e)),this.model.overlay.update({left:null,right:null,top:null,bottom:null}),this._base_point=null,this.plot_view.state.push("box_select",{selection:this.plot_view.get_selection()})}_do_select([e,t],[o,s],i,l="replace"){const n={type:"rect",sx0:e,sx1:t,sy0:o,sy1:s};this._select(n,i,l)}}o.BoxSelectToolView=a,a.__name__="BoxSelectToolView";const h=()=>new _.BoxAnnotation({level:"overlay",top_units:"screen",left_units:"screen",bottom_units:"screen",right_units:"screen",fill_color:"lightgrey",fill_alpha:.5,line_color:"black",line_alpha:1,line_width:2,line_dash:[4,4]});class m extends n.SelectTool{constructor(e){super(e),this.tool_name="Box Select",this.icon=r.tool_icon_box_select,this.event_type="pan",this.default_order=30}get tooltip(){return this._get_dim_tooltip(this.dimensions)}}o.BoxSelectTool=m,l=m,m.__name__="BoxSelectTool",l.prototype.default_view=a,l.define((({Boolean:e,Ref:t})=>({dimensions:[c.Dimensions,"both"],select_every_mousemove:[e,!1],overlay:[t(_.BoxAnnotation),h],origin:[c.BoxOrigin,"corner"]}))),l.register_alias("box_select",(()=>new m)),l.register_alias("xbox_select",(()=>new m({dimensions:"width"}))),l.register_alias("ybox_select",(()=>new m({dimensions:"height"})))},
function _(e,t,s,n,r){var o;n();const c=e(223),i=e(175),a=e(339),l=e(176),d=e(66),_=e(20),h=e(43),p=e(251),u=e(15),m=e(11);class v extends c.GestureToolView{connect_signals(){super.connect_signals(),this.model.clear.connect((()=>this._clear()))}get computed_renderers(){const{renderers:e,names:t}=this.model,s=this.plot_model.data_renderers;return(0,d.compute_renderers)(e,s,t)}_computed_renderers_by_data_source(){var e;const t=new Map;for(const s of this.computed_renderers){let n;if(s instanceof i.GlyphRenderer)n=s.data_source;else{if(!(s instanceof a.GraphRenderer))continue;n=s.node_renderer.data_source}const r=null!==(e=t.get(n))&&void 0!==e?e:[];t.set(n,[...r,s])}return t}_select_mode(e){const{shiftKey:t,ctrlKey:s}=e;return t||s?t&&!s?"append":!t&&s?"intersect":t&&s?"subtract":void(0,m.unreachable)():this.model.mode}_keyup(e){e.keyCode==h.Keys.Esc&&this._clear()}_clear(){for(const e of this.computed_renderers)e.get_selection_manager().clear();const e=this.computed_renderers.map((e=>this.plot_view.renderer_view(e)));this.plot_view.request_paint(e)}_select(e,t,s){const n=this._computed_renderers_by_data_source();for(const[,r]of n){const n=r[0].get_selection_manager(),o=[];for(const e of r){const t=this.plot_view.renderer_view(e);null!=t&&o.push(t)}n.select(o,e,t,s)}null!=this.model.callback&&this._emit_callback(e),this._emit_selection_event(e,t)}_emit_selection_event(e,t=!0){const{x_scale:s,y_scale:n}=this.plot_view.frame;let r;switch(e.type){case"point":{const{sx:t,sy:o}=e,c=s.invert(t),i=n.invert(o);r=Object.assign(Object.assign({},e),{x:c,y:i});break}case"span":{const{sx:t,sy:o}=e,c=s.invert(t),i=n.invert(o);r=Object.assign(Object.assign({},e),{x:c,y:i});break}case"rect":{const{sx0:t,sx1:o,sy0:c,sy1:i}=e,[a,l]=s.r_invert(t,o),[d,_]=n.r_invert(c,i);r=Object.assign(Object.assign({},e),{x0:a,y0:d,x1:l,y1:_});break}case"poly":{const{sx:t,sy:o}=e,c=s.v_invert(t),i=n.v_invert(o);r=Object.assign(Object.assign({},e),{x:c,y:i});break}}this.plot_model.trigger_event(new p.SelectionGeometry(r,t))}}s.SelectToolView=v,v.__name__="SelectToolView";class b extends c.GestureTool{constructor(e){super(e)}initialize(){super.initialize(),this.clear=new u.Signal0(this,"clear")}get menu(){return[{icon:"bk-tool-icon-replace-mode",tooltip:"Replace the current selection",active:()=>"replace"==this.mode,handler:()=>{this.mode="replace",this.active=!0}},{icon:"bk-tool-icon-append-mode",tooltip:"Append to the current selection (Shift)",active:()=>"append"==this.mode,handler:()=>{this.mode="append",this.active=!0}},{icon:"bk-tool-icon-intersect-mode",tooltip:"Intersect with the current selection (Ctrl)",active:()=>"intersect"==this.mode,handler:()=>{this.mode="intersect",this.active=!0}},{icon:"bk-tool-icon-subtract-mode",tooltip:"Subtract from the current selection (Shift+Ctrl)",active:()=>"subtract"==this.mode,handler:()=>{this.mode="subtract",this.active=!0}},null,{icon:"bk-tool-icon-clear-selection",tooltip:"Clear the current selection (Esc)",handler:()=>{this.clear.emit()}}]}}s.SelectTool=b,o=b,b.__name__="SelectTool",o.define((({String:e,Array:t,Ref:s,Or:n,Auto:r})=>({renderers:[n(t(s(l.DataRenderer)),r),"auto"],names:[t(e),[]],mode:[_.SelectionMode,"replace"]})))},
function _(t,o,e,s,i){var n;s();const _=t(223),a=t(116),l=t(20),r=t(228);class h extends _.GestureToolView{_match_aspect(t,o,e){const s=e.bbox.aspect,i=e.bbox.h_range.end,n=e.bbox.h_range.start,_=e.bbox.v_range.end,a=e.bbox.v_range.start;let l=Math.abs(t[0]-o[0]),r=Math.abs(t[1]-o[1]);const h=0==r?0:l/r,[c]=h>=s?[1,h/s]:[s/h,1];let m,p,d,b;return t[0]<=o[0]?(m=t[0],p=t[0]+l*c,p>i&&(p=i)):(p=t[0],m=t[0]-l*c,m<n&&(m=n)),l=Math.abs(p-m),t[1]<=o[1]?(b=t[1],d=t[1]+l/s,d>_&&(d=_)):(d=t[1],b=t[1]-l/s,b<a&&(b=a)),r=Math.abs(d-b),t[0]<=o[0]?p=t[0]+s*r:m=t[0]-s*r,[[m,p],[b,d]]}_compute_limits(t){const o=this.plot_view.frame,e=this.model.dimensions;let s,i,n=this._base_point;if("center"==this.model.origin){const[o,e]=n,[s,i]=t;n=[o-(s-o),e-(i-e)]}return this.model.match_aspect&&"both"==e?[s,i]=this._match_aspect(n,t,o):[s,i]=this.model._get_dim_limits(n,t,o,e),[s,i]}_pan_start(t){this._base_point=[t.sx,t.sy]}_pan(t){const o=[t.sx,t.sy],[e,s]=this._compute_limits(o);this.model.overlay.update({left:e[0],right:e[1],top:s[0],bottom:s[1]})}_pan_end(t){const o=[t.sx,t.sy],[e,s]=this._compute_limits(o);this._update(e,s),this.model.overlay.update({left:null,right:null,top:null,bottom:null}),this._base_point=null,this.plot_view.trigger_ranges_update_event()}_update([t,o],[e,s]){if(Math.abs(o-t)<=5||Math.abs(s-e)<=5)return;const{x_scales:i,y_scales:n}=this.plot_view.frame,_=new Map;for(const[e,s]of i){const[i,n]=s.r_invert(t,o);_.set(e,{start:i,end:n})}const a=new Map;for(const[t,o]of n){const[i,n]=o.r_invert(e,s);a.set(t,{start:i,end:n})}const l={xrs:_,yrs:a};this.plot_view.state.push("box_zoom",{range:l}),this.plot_view.update_range(l)}}e.BoxZoomToolView=h,h.__name__="BoxZoomToolView";const c=()=>new a.BoxAnnotation({level:"overlay",top_units:"screen",left_units:"screen",bottom_units:"screen",right_units:"screen",fill_color:"lightgrey",fill_alpha:.5,line_color:"black",line_alpha:1,line_width:2,line_dash:[4,4]});class m extends _.GestureTool{constructor(t){super(t),this.tool_name="Box Zoom",this.icon=r.tool_icon_box_zoom,this.event_type="pan",this.default_order=20}get tooltip(){return this._get_dim_tooltip(this.dimensions)}}e.BoxZoomTool=m,n=m,m.__name__="BoxZoomTool",n.prototype.default_view=h,n.define((({Boolean:t,Ref:o})=>({dimensions:[l.Dimensions,"both"],overlay:[o(a.BoxAnnotation),c],match_aspect:[t,!1],origin:[l.BoxOrigin,"corner"]}))),n.register_alias("box_zoom",(()=>new m({dimensions:"both"}))),n.register_alias("xbox_zoom",(()=>new m({dimensions:"width"}))),n.register_alias("ybox_zoom",(()=>new m({dimensions:"height"})))},
function _(s,e,t,o,_){var l;o();const i=s(378),a=s(217),c=s(381),n=s(43),h=s(228);class r extends i.SelectToolView{constructor(){super(...arguments),this.sxs=[],this.sys=[]}connect_signals(){super.connect_signals(),this.connect(this.model.properties.active.change,(()=>this._active_change()))}_active_change(){this.model.active||this._clear_overlay()}_keyup(s){s.keyCode==n.Keys.Enter&&this._clear_overlay()}_pan_start(s){this.sxs=[],this.sys=[];const{sx:e,sy:t}=s;this._append_overlay(e,t)}_pan(s){const[e,t]=this.plot_view.frame.bbox.clip(s.sx,s.sy);this._append_overlay(e,t),this.model.select_every_mousemove&&this._do_select(this.sxs,this.sys,!1,this._select_mode(s))}_pan_end(s){const{sxs:e,sys:t}=this;this._clear_overlay(),this._do_select(e,t,!0,this._select_mode(s)),this.plot_view.state.push("lasso_select",{selection:this.plot_view.get_selection()})}_append_overlay(s,e){const{sxs:t,sys:o}=this;t.push(s),o.push(e),this.model.overlay.update({xs:t,ys:o})}_clear_overlay(){this.sxs=[],this.sys=[],this.model.overlay.update({xs:this.sxs,ys:this.sys})}_do_select(s,e,t,o){const _={type:"poly",sx:s,sy:e};this._select(_,t,o)}}t.LassoSelectToolView=r,r.__name__="LassoSelectToolView";class y extends i.SelectTool{constructor(s){super(s),this.tool_name="Lasso Select",this.icon=h.tool_icon_lasso_select,this.event_type="pan",this.default_order=12}}t.LassoSelectTool=y,l=y,y.__name__="LassoSelectTool",l.prototype.default_view=r,l.define((({Boolean:s,Ref:e})=>({select_every_mousemove:[s,!0],overlay:[e(a.PolyAnnotation),c.DEFAULT_POLY_OVERLAY]}))),l.register_alias("lasso_select",(()=>new y))},
function _(e,t,s,l,o){var i;l();const a=e(378),_=e(217),c=e(43),n=e(9),h=e(228);class y extends a.SelectToolView{initialize(){super.initialize(),this.data={sx:[],sy:[]}}connect_signals(){super.connect_signals(),this.connect(this.model.properties.active.change,(()=>this._active_change()))}_active_change(){this.model.active||this._clear_data()}_keyup(e){e.keyCode==c.Keys.Enter&&this._clear_data()}_doubletap(e){this._do_select(this.data.sx,this.data.sy,!0,this._select_mode(e)),this.plot_view.state.push("poly_select",{selection:this.plot_view.get_selection()}),this._clear_data()}_clear_data(){this.data={sx:[],sy:[]},this.model.overlay.update({xs:[],ys:[]})}_tap(e){const{sx:t,sy:s}=e;this.plot_view.frame.bbox.contains(t,s)&&(this.data.sx.push(t),this.data.sy.push(s),this.model.overlay.update({xs:(0,n.copy)(this.data.sx),ys:(0,n.copy)(this.data.sy)}))}_do_select(e,t,s,l){const o={type:"poly",sx:e,sy:t};this._select(o,s,l)}}s.PolySelectToolView=y,y.__name__="PolySelectToolView";s.DEFAULT_POLY_OVERLAY=()=>new _.PolyAnnotation({level:"overlay",xs_units:"screen",ys_units:"screen",fill_color:"lightgrey",fill_alpha:.5,line_color:"black",line_alpha:1,line_width:2,line_dash:[4,4]});class d extends a.SelectTool{constructor(e){super(e),this.tool_name="Poly Select",this.icon=h.tool_icon_polygon_select,this.event_type="tap",this.default_order=11}}s.PolySelectTool=d,i=d,d.__name__="PolySelectTool",i.prototype.default_view=y,i.define((({Ref:e})=>({overlay:[e(_.PolyAnnotation),s.DEFAULT_POLY_OVERLAY]}))),i.register_alias("poly_select",(()=>new d))},
function _(e,t,s,i,r){var n;i();const _=e(20),d=e(383),o=e(228);class l extends d.LineToolView{constructor(){super(...arguments),this._drawing=!1}_doubletap(e){if(!this.model.active)return;const t=this.model.renderers;for(const s of t){1==this._select_event(e,"replace",[s]).length&&(this._selected_renderer=s)}this._show_intersections(),this._update_line_cds()}_show_intersections(){if(!this.model.active)return;if(null==this._selected_renderer)return;if(!this.model.renderers.length)return this._set_intersection([],[]),this._selected_renderer=null,void(this._drawing=!1);const e=this._selected_renderer.data_source,t=this._selected_renderer.glyph,[s,i]=[t.x.field,t.y.field],r=e.get_array(s),n=e.get_array(i);this._set_intersection(r,n)}_tap(e){const t=this.model.intersection_renderer;if(null==this._map_drag(e.sx,e.sy,t))return;if(this._drawing&&this._selected_renderer){const s=this._select_mode(e);if(0==this._select_event(e,s,[t]).length)return}const s=this._select_mode(e);this._select_event(e,s,[t]),this._select_event(e,s,this.model.renderers)}_update_line_cds(){if(null==this._selected_renderer)return;const e=this.model.intersection_renderer.glyph,t=this.model.intersection_renderer.data_source,[s,i]=[e.x.field,e.y.field];if(s&&i){const e=t.data[s],r=t.data[i];this._selected_renderer.data_source.data[s]=e,this._selected_renderer.data_source.data[i]=r}this._emit_cds_changes(this._selected_renderer.data_source,!0,!0,!1)}_pan_start(e){this._select_event(e,"append",[this.model.intersection_renderer]),this._basepoint=[e.sx,e.sy]}_pan(e){null!=this._basepoint&&(this._drag_points(e,[this.model.intersection_renderer],this.model.dimensions),this._selected_renderer&&this._selected_renderer.data_source.change.emit())}_pan_end(e){null!=this._basepoint&&(this._drag_points(e,[this.model.intersection_renderer]),this._emit_cds_changes(this.model.intersection_renderer.data_source,!1,!0,!0),this._selected_renderer&&this._emit_cds_changes(this._selected_renderer.data_source),this._basepoint=null)}activate(){this._drawing=!0}deactivate(){this._selected_renderer&&(this._drawing&&(this._drawing=!1),this._hide_intersections())}}s.LineEditToolView=l,l.__name__="LineEditToolView";class h extends d.LineTool{constructor(e){super(e),this.tool_name="Line Edit Tool",this.icon=o.tool_icon_line_edit,this.event_type=["tap","pan","move"],this.default_order=4}get tooltip(){return this._get_dim_tooltip(this.dimensions)}}s.LineEditTool=h,n=h,h.__name__="LineEditTool",n.prototype.default_view=l,n.define((()=>({dimensions:[_.Dimensions,"both"]})))},
function _(e,i,n,t,s){var o;t();const r=e(8),_=e(370);class d extends _.EditToolView{_set_intersection(e,i){const n=this.model.intersection_renderer.glyph,t=this.model.intersection_renderer.data_source,[s,o]=[n.x.field,n.y.field];s&&((0,r.isArray)(e)?t.data[s]=e:n.x={value:e}),o&&((0,r.isArray)(i)?t.data[o]=i:n.y={value:i}),this._emit_cds_changes(t,!0,!0,!1)}_hide_intersections(){this._set_intersection([],[])}}n.LineToolView=d,d.__name__="LineToolView";class a extends _.EditTool{constructor(e){super(e)}}n.LineTool=a,o=a,a.__name__="LineTool",o.define((({AnyRef:e})=>({intersection_renderer:[e()]})))},
function _(t,s,n,e,i){e();const o=t(1);var a;const _=t(223),l=t(20),r=(0,o.__importStar)(t(228));function h(t,s,n){const e=new Map;for(const[i,o]of t){const[t,a]=o.r_invert(s,n);e.set(i,{start:t,end:a})}return e}n.update_ranges=h;class d extends _.GestureToolView{_pan_start(t){var s;this.last_dx=0,this.last_dy=0;const{sx:n,sy:e}=t,i=this.plot_view.frame.bbox;if(!i.contains(n,e)){const t=i.h_range,s=i.v_range;(n<t.start||n>t.end)&&(this.v_axis_only=!0),(e<s.start||e>s.end)&&(this.h_axis_only=!0)}null===(s=this.model.document)||void 0===s||s.interactive_start(this.plot_model)}_pan(t){var s;this._update(t.deltaX,t.deltaY),null===(s=this.model.document)||void 0===s||s.interactive_start(this.plot_model)}_pan_end(t){this.h_axis_only=!1,this.v_axis_only=!1,null!=this.pan_info&&this.plot_view.state.push("pan",{range:this.pan_info}),this.plot_view.trigger_ranges_update_event()}_update(t,s){const n=this.plot_view.frame,e=t-this.last_dx,i=s-this.last_dy,o=n.bbox.h_range,a=o.start-e,_=o.end-e,l=n.bbox.v_range,r=l.start-i,d=l.end-i,p=this.model.dimensions;let c,u,m,v,x,g;"width"!=p&&"both"!=p||this.v_axis_only?(c=o.start,u=o.end,m=0):(c=a,u=_,m=-e),"height"!=p&&"both"!=p||this.h_axis_only?(v=l.start,x=l.end,g=0):(v=r,x=d,g=-i),this.last_dx=t,this.last_dy=s;const{x_scales:w,y_scales:y}=n,f=h(w,c,u),b=h(y,v,x);this.pan_info={xrs:f,yrs:b,sdx:m,sdy:g},this.plot_view.update_range(this.pan_info,{panning:!0})}}n.PanToolView=d,d.__name__="PanToolView";class p extends _.GestureTool{constructor(t){super(t),this.tool_name="Pan",this.event_type="pan",this.default_order=10}get tooltip(){return this._get_dim_tooltip(this.dimensions)}}n.PanTool=p,a=p,p.__name__="PanTool",a.prototype.default_view=d,a.define((()=>({dimensions:[l.Dimensions,"both",{on_update(t,s){switch(t){case"both":s.icon=r.tool_icon_pan;break;case"width":s.icon=r.tool_icon_xpan;break;case"height":s.icon=r.tool_icon_ypan}}}]}))),a.register_alias("pan",(()=>new p({dimensions:"both"}))),a.register_alias("xpan",(()=>new p({dimensions:"width"}))),a.register_alias("ypan",(()=>new p({dimensions:"height"})))},
function _(e,t,i,s,n){var l;s();const a=e(116),r=e(58),o=e(19),_=e(223),h=e(228);function d(e){switch(e){case 1:return 2;case 2:return 1;case 4:return 5;case 5:return 4;default:return e}}function u(e,t,i,s){if(null==t)return!1;const n=i.compute(t);return Math.abs(e-n)<s}function c(e,t,i,s,n){let l=!0;if(null!=n.left&&null!=n.right){const t=i.invert(e);(t<n.left||t>n.right)&&(l=!1)}if(null!=n.bottom&&null!=n.top){const e=s.invert(t);(e<n.bottom||e>n.top)&&(l=!1)}return l}function g(e,t,i){let s=0;return e>=i.start&&e<=i.end&&(s+=1),t>=i.start&&t<=i.end&&(s+=1),s}function y(e,t,i,s){const n=t.compute(e),l=t.invert(n+i);return l>=s.start&&l<=s.end?l:e}function f(e,t,i){return e>t.start?(t.end=e,i):(t.end=t.start,t.start=e,d(i))}function v(e,t,i){return e<t.end?(t.start=e,i):(t.start=t.end,t.end=e,d(i))}function m(e,t,i,s){const[n,l]=t.r_compute(e.start,e.end),[a,r]=t.r_invert(n+i,l+i),o=g(e.start,e.end,s);g(a,r,s)>=o&&(e.start=a,e.end=r)}i.flip_side=d,i.is_near=u,i.is_inside=c,i.sides_inside=g,i.compute_value=y,i.update_range_end_side=f,i.update_range_start_side=v,i.update_range=m;class p extends _.GestureToolView{initialize(){super.initialize(),this.side=0,this.model.update_overlay_from_ranges()}connect_signals(){super.connect_signals(),null!=this.model.x_range&&this.connect(this.model.x_range.change,(()=>this.model.update_overlay_from_ranges())),null!=this.model.y_range&&this.connect(this.model.y_range.change,(()=>this.model.update_overlay_from_ranges()))}_pan_start(e){this.last_dx=0,this.last_dy=0;const t=this.model.x_range,i=this.model.y_range,{frame:s}=this.plot_view,n=s.x_scale,l=s.y_scale,r=this.model.overlay,{left:o,right:_,top:h,bottom:d}=r,g=this.model.overlay.line_width+a.EDGE_TOLERANCE;null!=t&&this.model.x_interaction&&(u(e.sx,o,n,g)?this.side=1:u(e.sx,_,n,g)?this.side=2:c(e.sx,e.sy,n,l,r)&&(this.side=3)),null!=i&&this.model.y_interaction&&(0==this.side&&u(e.sy,d,l,g)&&(this.side=4),0==this.side&&u(e.sy,h,l,g)?this.side=5:c(e.sx,e.sy,n,l,this.model.overlay)&&(3==this.side?this.side=7:this.side=6))}_pan(e){const t=this.plot_view.frame,i=e.deltaX-this.last_dx,s=e.deltaY-this.last_dy,n=this.model.x_range,l=this.model.y_range,a=t.x_scale,r=t.y_scale;if(null!=n)if(3==this.side||7==this.side)m(n,a,i,t.x_range);else if(1==this.side){const e=y(n.start,a,i,t.x_range);this.side=v(e,n,this.side)}else if(2==this.side){const e=y(n.end,a,i,t.x_range);this.side=f(e,n,this.side)}if(null!=l)if(6==this.side||7==this.side)m(l,r,s,t.y_range);else if(4==this.side){const e=y(l.start,r,s,t.y_range);this.side=v(e,l,this.side)}else if(5==this.side){const e=y(l.end,r,s,t.y_range);this.side=f(e,l,this.side)}this.last_dx=e.deltaX,this.last_dy=e.deltaY}_pan_end(e){this.side=0,this.plot_view.trigger_ranges_update_event()}}i.RangeToolView=p,p.__name__="RangeToolView";const x=()=>new a.BoxAnnotation({level:"overlay",fill_color:"lightgrey",fill_alpha:.5,line_color:"black",line_alpha:1,line_width:.5,line_dash:[2,2]});class w extends _.GestureTool{constructor(e){super(e),this.tool_name="Range Tool",this.icon=h.tool_icon_range,this.event_type="pan",this.default_order=1}initialize(){super.initialize(),this.overlay.in_cursor="grab",this.overlay.ew_cursor=null!=this.x_range&&this.x_interaction?"ew-resize":null,this.overlay.ns_cursor=null!=this.y_range&&this.y_interaction?"ns-resize":null}update_overlay_from_ranges(){null==this.x_range&&null==this.y_range&&(this.overlay.left=null,this.overlay.right=null,this.overlay.bottom=null,this.overlay.top=null,o.logger.warn("RangeTool not configured with any Ranges.")),null==this.x_range?(this.overlay.left=null,this.overlay.right=null):(this.overlay.left=this.x_range.start,this.overlay.right=this.x_range.end),null==this.y_range?(this.overlay.bottom=null,this.overlay.top=null):(this.overlay.bottom=this.y_range.start,this.overlay.top=this.y_range.end)}}i.RangeTool=w,l=w,w.__name__="RangeTool",l.prototype.default_view=p,l.define((({Boolean:e,Ref:t,Nullable:i})=>({x_range:[i(t(r.Range1d)),null],x_interaction:[e,!0],y_range:[i(t(r.Range1d)),null],y_interaction:[e,!0],overlay:[t(a.BoxAnnotation),x]})))},
function _(e,t,s,o,i){var l;o();const a=e(378),n=e(20),c=e(228);class _ extends a.SelectToolView{_tap(e){"tap"==this.model.gesture&&this._handle_tap(e)}_doubletap(e){"doubletap"==this.model.gesture&&this._handle_tap(e)}_handle_tap(e){const{sx:t,sy:s}=e,o={type:"point",sx:t,sy:s};this._select(o,!0,this._select_mode(e))}_select(e,t,s){const{callback:o}=this.model;if("select"==this.model.behavior){const i=this._computed_renderers_by_data_source();for(const[,l]of i){const i=l[0].get_selection_manager(),a=l.map((e=>this.plot_view.renderer_view(e))).filter((e=>null!=e));if(i.select(a,e,t,s)&&null!=o){const t=a[0].coordinates.x_scale.invert(e.sx),s=a[0].coordinates.y_scale.invert(e.sy),l={geometries:Object.assign(Object.assign({},e),{x:t,y:s}),source:i.source};o.execute(this.model,l)}}this._emit_selection_event(e),this.plot_view.state.push("tap",{selection:this.plot_view.get_selection()})}else for(const t of this.computed_renderers){const s=this.plot_view.renderer_view(t);if(null==s)continue;const i=t.get_selection_manager();if(i.inspect(s,e)&&null!=o){const t=s.coordinates.x_scale.invert(e.sx),l=s.coordinates.y_scale.invert(e.sy),a={geometries:Object.assign(Object.assign({},e),{x:t,y:l}),source:i.source};o.execute(this.model,a)}}}}s.TapToolView=_,_.__name__="TapToolView";class r extends a.SelectTool{constructor(e){super(e),this.tool_name="Tap",this.icon=c.tool_icon_tap_select,this.event_type="tap",this.default_order=10}}s.TapTool=r,l=r,r.__name__="TapTool",l.prototype.default_view=_,l.define((({Any:e,Enum:t,Nullable:s})=>({behavior:[n.TapBehavior,"select"],gesture:[t("tap","doubletap"),"tap"],callback:[s(e)]}))),l.register_alias("click",(()=>new r({behavior:"inspect"}))),l.register_alias("tap",(()=>new r)),l.register_alias("doubletap",(()=>new r({gesture:"doubletap"})))},
function _(e,t,s,n,i){var a;n();const o=e(223),l=e(20),_=e(228),r=e(384);class h extends o.GestureToolView{_scroll(e){let t=this.model.speed*e.delta;t>.9?t=.9:t<-.9&&(t=-.9),this._update_ranges(t)}_update_ranges(e){var t;const{frame:s}=this.plot_view,n=s.bbox.h_range,i=s.bbox.v_range,[a,o]=[n.start,n.end],[l,_]=[i.start,i.end];let h,d,p,c;switch(this.model.dimension){case"height":{const t=Math.abs(_-l);h=a,d=o,p=l-t*e,c=_-t*e;break}case"width":{const t=Math.abs(o-a);h=a-t*e,d=o-t*e,p=l,c=_;break}}const{x_scales:g,y_scales:u}=s,w={xrs:(0,r.update_ranges)(g,h,d),yrs:(0,r.update_ranges)(u,p,c),factor:e};this.plot_view.state.push("wheel_pan",{range:w}),this.plot_view.update_range(w,{scrolling:!0}),null===(t=this.model.document)||void 0===t||t.interactive_start(this.plot_model,(()=>this.plot_view.trigger_ranges_update_event()))}}s.WheelPanToolView=h,h.__name__="WheelPanToolView";class d extends o.GestureTool{constructor(e){super(e),this.tool_name="Wheel Pan",this.icon=_.tool_icon_wheel_pan,this.event_type="scroll",this.default_order=12}get tooltip(){return this._get_dim_tooltip(this.dimension)}}s.WheelPanTool=d,a=d,d.__name__="WheelPanTool",a.prototype.default_view=h,a.define((()=>({dimension:[l.Dimension,"width"]}))),a.internal((({Number:e})=>({speed:[e,.001]}))),a.register_alias("xwheel_pan",(()=>new d({dimension:"width"}))),a.register_alias("ywheel_pan",(()=>new d({dimension:"height"})))},
function _(e,o,t,s,i){var n;s();const l=e(223),_=e(368),h=e(20),a=e(27),r=e(228);class m extends l.GestureToolView{_pinch(e){const{sx:o,sy:t,scale:s,ctrlKey:i,shiftKey:n}=e;let l;l=s>=1?20*(s-1):-20/s,this._scroll({type:"wheel",sx:o,sy:t,delta:l,ctrlKey:i,shiftKey:n})}_scroll(e){var o;const{frame:t}=this.plot_view,s=t.bbox.h_range,i=t.bbox.v_range,{sx:n,sy:l}=e,h=this.model.dimensions,a=("width"==h||"both"==h)&&s.start<n&&n<s.end,r=("height"==h||"both"==h)&&i.start<l&&l<i.end;if(!(a&&r||this.model.zoom_on_axis))return;const m=this.model.speed*e.delta,d=(0,_.scale_range)(t,m,a,r,{x:n,y:l});this.plot_view.state.push("wheel_zoom",{range:d});const{maintain_focus:c}=this.model;this.plot_view.update_range(d,{scrolling:!0,maintain_focus:c}),null===(o=this.model.document)||void 0===o||o.interactive_start(this.plot_model,(()=>this.plot_view.trigger_ranges_update_event()))}}t.WheelZoomToolView=m,m.__name__="WheelZoomToolView";class d extends l.GestureTool{constructor(e){super(e),this.tool_name="Wheel Zoom",this.icon=r.tool_icon_wheel_zoom,this.event_type=a.is_mobile?"pinch":"scroll",this.default_order=10}get tooltip(){return this._get_dim_tooltip(this.dimensions)}}t.WheelZoomTool=d,n=d,d.__name__="WheelZoomTool",n.prototype.default_view=m,n.define((({Boolean:e,Number:o})=>({dimensions:[h.Dimensions,"both"],maintain_focus:[e,!0],zoom_on_axis:[e,!0],speed:[o,1/600]}))),n.register_alias("wheel_zoom",(()=>new d({dimensions:"both"}))),n.register_alias("xwheel_zoom",(()=>new d({dimensions:"width"}))),n.register_alias("ywheel_zoom",(()=>new d({dimensions:"height"})))},
function _(i,e,s,t,o){var n;t();const l=i(232),a=i(219),h=i(20),r=i(13),_=i(228);class c extends l.InspectToolView{_move(i){if(!this.model.active)return;const{sx:e,sy:s}=i;this.plot_view.frame.bbox.contains(e,s)?this._update_spans(e,s):this._update_spans(null,null)}_move_exit(i){this._update_spans(null,null)}_update_spans(i,e){const s=this.model.dimensions;"width"!=s&&"both"!=s||(this.model.spans.width.location=e),"height"!=s&&"both"!=s||(this.model.spans.height.location=i)}}s.CrosshairToolView=c,c.__name__="CrosshairToolView";class p extends l.InspectTool{constructor(i){super(i),this.tool_name="Crosshair",this.icon=_.tool_icon_crosshair}get tooltip(){return this._get_dim_tooltip(this.dimensions)}get synthetic_renderers(){return(0,r.values)(this.spans)}}s.CrosshairTool=p,n=p,p.__name__="CrosshairTool",(()=>{function i(i,e){return new a.Span({for_hover:!0,dimension:e,location_units:"screen",level:"overlay",line_color:i.line_color,line_width:i.line_width,line_alpha:i.line_alpha})}n.prototype.default_view=c,n.define((({Alpha:i,Number:e,Color:s})=>({dimensions:[h.Dimensions,"both"],line_color:[s,"black"],line_width:[e,1],line_alpha:[i,1]}))),n.internal((({Struct:e,Ref:s})=>({spans:[e({width:s(a.Span),height:s(a.Span)}),e=>({width:i(e,"width"),height:i(e,"height")})]}))),n.register_alias("crosshair",(()=>new p))})()},
function _(e,s,t,r,n){var o;r();const a=e(53),u=e(13),c=e(34);class i extends a.Model{constructor(e){super(e)}get values(){return(0,u.values)(this.args)}_make_code(e,s,t,r){return new Function(...(0,u.keys)(this.args),e,s,t,(0,c.use_strict)(r))}format(e,s,t){return this._make_code("value","format","special_vars",this.code)(...this.values,e,s,t)}}t.CustomJSHover=i,o=i,i.__name__="CustomJSHover",o.define((({Unknown:e,String:s,Dict:t})=>({args:[t(e),{}],code:[s,""]})))},
function _(e,t,n,s,i){s();const o=e(1);var r;const l=e(232),a=e(390),c=e(241),_=e(175),d=e(339),p=e(176),h=e(177),u=e(283),m=e(186),y=e(187),f=e(189),x=(0,o.__importStar)(e(185)),v=e(152),w=e(43),g=e(22),b=e(13),k=e(234),C=e(8),S=e(113),T=e(20),$=e(228),R=e(15),A=e(66),M=(0,o.__importStar)(e(242)),V=e(392);function G(e,t,n,s,i,o){const r={x:i[e],y:o[e]},l={x:i[e+1],y:o[e+1]};let a,c;if("span"==t.type)"h"==t.direction?(a=Math.abs(r.x-n),c=Math.abs(l.x-n)):(a=Math.abs(r.y-s),c=Math.abs(l.y-s));else{const e={x:n,y:s};a=x.dist_2_pts(r,e),c=x.dist_2_pts(l,e)}return a<c?[[r.x,r.y],e]:[[l.x,l.y],e+1]}function H(e,t,n){return[[e[n],t[n]],n]}n._nearest_line_hit=G,n._line_hit=H;class z extends l.InspectToolView{initialize(){super.initialize(),this._ttmodels=new Map,this._ttviews=new Map}async lazy_initialize(){await super.lazy_initialize(),await this._update_ttmodels();const{tooltips:e}=this.model;e instanceof V.Template&&(this._template_view=await(0,S.build_view)(e,{parent:this}),this._template_view.render())}remove(){var e;null===(e=this._template_view)||void 0===e||e.remove(),(0,S.remove_views)(this._ttviews),super.remove()}connect_signals(){super.connect_signals();const e=this.plot_model.properties.renderers,{renderers:t,tooltips:n}=this.model.properties;this.on_change(n,(()=>delete this._template_el)),this.on_change([e,t,n],(async()=>await this._update_ttmodels()))}async _update_ttmodels(){const{_ttmodels:e,computed_renderers:t}=this;e.clear();const{tooltips:n}=this.model;if(null!=n)for(const t of this.computed_renderers){const s=new c.Tooltip({custom:(0,C.isString)(n)||(0,C.isFunction)(n),attachment:this.model.attachment,show_arrow:this.model.show_arrow});t instanceof _.GlyphRenderer?e.set(t,s):t instanceof d.GraphRenderer&&(e.set(t.node_renderer,s),e.set(t.edge_renderer,s))}const s=await(0,S.build_views)(this._ttviews,[...e.values()],{parent:this.plot_view});for(const e of s)e.render();const i=[...function*(){for(const e of t)e instanceof _.GlyphRenderer?yield e:e instanceof d.GraphRenderer&&(yield e.node_renderer,yield e.edge_renderer)}()],o=this._slots.get(this._update);if(null!=o){const e=new Set(i.map((e=>e.data_source)));R.Signal.disconnect_receiver(this,o,e)}for(const e of i)this.connect(e.data_source.inspect,this._update)}get computed_renderers(){const{renderers:e,names:t}=this.model,n=this.plot_model.data_renderers;return(0,A.compute_renderers)(e,n,t)}get ttmodels(){return this._ttmodels}_clear(){this._inspect(1/0,1/0);for(const[,e]of this.ttmodels)e.clear()}_move(e){if(!this.model.active)return;const{sx:t,sy:n}=e;this.plot_view.frame.bbox.contains(t,n)?this._inspect(t,n):this._clear()}_move_exit(){this._clear()}_inspect(e,t){let n;if("mouse"==this.model.mode)n={type:"point",sx:e,sy:t};else{n={type:"span",direction:"vline"==this.model.mode?"h":"v",sx:e,sy:t}}for(const e of this.computed_renderers){const t=e.get_selection_manager(),s=this.plot_view.renderer_view(e);null!=s&&t.inspect(s,n)}this._emit_callback(n)}_update([e,{geometry:t}]){var n,s;if(!this.model.active)return;if("point"!=t.type&&"span"!=t.type)return;if(!(e instanceof _.GlyphRenderer))return;if("ignore"==this.model.muted_policy&&e.muted)return;const i=this.ttmodels.get(e);if(null==i)return;const o=e.get_selection_manager(),r=o.inspectors.get(e),l=e.view.convert_selection_to_subset(r);if(r.is_empty()&&null==r.view)return void i.clear();const a=o.source,c=this.plot_view.renderer_view(e);if(null==c)return;const{sx:d,sy:p}=t,x=c.coordinates.x_scale,v=c.coordinates.y_scale,g=x.invert(d),k=v.invert(p),{glyph:C}=c,S=[];if(C instanceof m.PatchView){const[t,n]=[d,p],s={x:g,y:k,sx:d,sy:p,rx:t,ry:n,name:e.name};S.push([t,n,this._render_tooltips(a,-1,s)])}if(C instanceof y.HAreaView)for(const t of l.line_indices){const n=C._x1,s=C._x2,i=C._y,[o,r]=[d,p],c={index:t,x:g,y:k,sx:d,sy:p,data_x1:n,data_x2:s,data_y:i,rx:o,ry:r,indices:l.line_indices,name:e.name};S.push([o,r,this._render_tooltips(a,t,c)])}if(C instanceof f.VAreaView)for(const t of l.line_indices){const n=C._x,s=C._y1,i=C._y2,[o,r]=[d,p],c={index:t,x:g,y:k,sx:d,sy:p,data_x:n,data_y1:s,data_y2:i,rx:o,ry:r,indices:l.line_indices,name:e.name};S.push([o,r,this._render_tooltips(a,t,c)])}if(C instanceof h.LineView)for(const n of l.line_indices){let s,i,o=C._x[n+1],r=C._y[n+1],c=n;switch(this.model.line_policy){case"interp":[o,r]=C.get_interpolation_hit(n,t),s=x.compute(o),i=v.compute(r);break;case"prev":[[s,i],c]=H(C.sx,C.sy,n);break;case"next":[[s,i],c]=H(C.sx,C.sy,n+1);break;case"nearest":[[s,i],c]=G(n,t,d,p,C.sx,C.sy),o=C._x[c],r=C._y[c];break;default:[s,i]=[d,p]}const _={index:c,x:g,y:k,sx:d,sy:p,data_x:o,data_y:r,rx:s,ry:i,indices:l.line_indices,name:e.name};S.push([s,i,this._render_tooltips(a,c,_)])}for(const t of r.image_indices){const n={index:t.index,x:g,y:k,sx:d,sy:p,name:e.name},s=this._render_tooltips(a,t,n);S.push([d,p,s])}for(const i of l.indices)if(C instanceof u.MultiLineView&&!(0,b.isEmpty)(l.multiline_indices))for(const n of l.multiline_indices[i.toString()]){let s,o,r,c=C._xs.get(i)[n],h=C._ys.get(i)[n],u=n;switch(this.model.line_policy){case"interp":[c,h]=C.get_interpolation_hit(i,n,t),s=x.compute(c),o=v.compute(h);break;case"prev":[[s,o],u]=H(C.sxs.get(i),C.sys.get(i),n);break;case"next":[[s,o],u]=H(C.sxs.get(i),C.sys.get(i),n+1);break;case"nearest":[[s,o],u]=G(n,t,d,p,C.sxs.get(i),C.sys.get(i)),c=C._xs.get(i)[u],h=C._ys.get(i)[u];break;default:throw new Error("shouldn't have happened")}r=e instanceof _.GlyphRenderer?e.view.convert_indices_from_subset([i])[0]:i;const m={index:r,x:g,y:k,sx:d,sy:p,data_x:c,data_y:h,segment_index:u,indices:l.multiline_indices,name:e.name};S.push([s,o,this._render_tooltips(a,r,m)])}else{const t=null===(n=C._x)||void 0===n?void 0:n[i],o=null===(s=C._y)||void 0===s?void 0:s[i];let r,c,h;if("snap_to_data"==this.model.point_policy){let e=C.get_anchor_point(this.model.anchor,i,[d,p]);if(null==e&&(e=C.get_anchor_point("center",i,[d,p]),null==e))continue;r=e.x,c=e.y}else[r,c]=[d,p];h=e instanceof _.GlyphRenderer?e.view.convert_indices_from_subset([i])[0]:i;const u={index:h,x:g,y:k,sx:d,sy:p,data_x:t,data_y:o,indices:l.indices,name:e.name};S.push([r,c,this._render_tooltips(a,h,u)])}if(0==S.length)i.clear();else{const{content:e}=i;(0,w.empty)(i.content);for(const[,,t]of S)null!=t&&e.appendChild(t);const[t,n]=S[S.length-1];i.setv({position:[t,n]},{check_eq:!1})}}_emit_callback(e){const{callback:t}=this.model;if(null!=t)for(const n of this.computed_renderers){if(!(n instanceof _.GlyphRenderer))continue;const s=this.plot_view.renderer_view(n);if(null==s)continue;const{x_scale:i,y_scale:o}=s.coordinates,r=i.invert(e.sx),l=o.invert(e.sy),a=n.data_source.inspected;t.execute(this.model,{geometry:Object.assign({x:r,y:l},e),renderer:n,index:a})}}_create_template(e){const t=(0,w.div)({style:{display:"table",borderSpacing:"2px"}});for(const[n]of e){const e=(0,w.div)({style:{display:"table-row"}});t.appendChild(e);const s=(0,w.div)({style:{display:"table-cell"},class:M.tooltip_row_label},0!=n.length?`${n}: `:"");e.appendChild(s);const i=(0,w.span)();i.dataset.value="";const o=(0,w.span)({class:M.tooltip_color_block}," ");o.dataset.swatch="",(0,w.undisplay)(o);const r=(0,w.div)({style:{display:"table-cell"},class:M.tooltip_row_value},i,o);e.appendChild(r)}return t}_render_template(e,t,n,s,i){const o=e.cloneNode(!0),r=o.querySelectorAll("[data-value]"),l=o.querySelectorAll("[data-swatch]"),a=/\$color(\[.*\])?:(\w*)/,c=/\$swatch:(\w*)/;for(const[[,e],o]of(0,k.enumerate)(t)){const t=e.match(c),_=e.match(a);if(null!=t||null!=_){if(null!=t){const[,e]=t,i=n.get_column(e);if(null==i)r[o].textContent=`${e} unknown`;else{const e=(0,C.isNumber)(s)?i[s]:null;null!=e&&(l[o].style.backgroundColor=(0,g.color2css)(e),(0,w.display)(l[o]))}}if(null!=_){const[,e="",t]=_,i=n.get_column(t);if(null==i){r[o].textContent=`${t} unknown`;continue}const a=e.indexOf("hex")>=0,c=e.indexOf("swatch")>=0,d=(0,C.isNumber)(s)?i[s]:null;if(null==d){r[o].textContent="(null)";continue}r[o].textContent=a?(0,g.color2hex)(d):(0,g.color2css)(d),c&&(l[o].style.backgroundColor=(0,g.color2css)(d),(0,w.display)(l[o]))}}else{const t=(0,v.replace_placeholders)(e.replace("$~","$data_"),n,s,this.model.formatters,i);if((0,C.isString)(t))r[o].textContent=t;else for(const e of t)r[o].appendChild(e)}}return o}_render_tooltips(e,t,n){var s;const{tooltips:i}=this.model;if((0,C.isString)(i)){const s=(0,v.replace_placeholders)({html:i},e,t,this.model.formatters,n);return(0,w.div)(s)}if((0,C.isFunction)(i))return i(e,n);if(i instanceof V.Template)return this._template_view.update(e,t,n),this._template_view.el;if(null!=i){const o=null!==(s=this._template_el)&&void 0!==s?s:this._template_el=this._create_template(i);return this._render_template(o,i,e,t,n)}return null}}n.HoverToolView=z,z.__name__="HoverToolView";class P extends l.InspectTool{constructor(e){super(e),this.tool_name="Hover",this.icon=$.tool_icon_hover}}n.HoverTool=P,r=P,P.__name__="HoverTool",r.prototype.default_view=z,r.define((({Any:e,Boolean:t,String:n,Array:s,Tuple:i,Dict:o,Or:r,Ref:l,Function:c,Auto:_,Nullable:d})=>({tooltips:[d(r(l(V.Template),n,s(i(n,n)),c())),[["index","$index"],["data (x, y)","($x, $y)"],["screen (x, y)","($sx, $sy)"]]],formatters:[o(r(l(a.CustomJSHover),v.FormatterType)),{}],renderers:[r(s(l(p.DataRenderer)),_),"auto"],names:[s(n),[]],mode:[T.HoverMode,"mouse"],muted_policy:[T.MutedPolicy,"show"],point_policy:[T.PointPolicy,"snap_to_data"],line_policy:[T.LinePolicy,"nearest"],show_arrow:[t,!0],anchor:[T.Anchor,"center"],attachment:[T.TooltipAttachment,"horizontal"],callback:[d(e)]}))),r.register_alias("hover",(()=>new P))},
function _(e,t,s,n,a){n();const l=e(1);var i,_,o,r,c,d,p,u,m,w,f,h,x;const v=e(53),y=e(309),V=e(393);a("Styles",V.Styles);const g=e(43),T=e(42),b=e(226),R=e(113),D=e(8),M=e(13),S=(0,l.__importStar)(e(242)),O=e(152);class C extends b.DOMView{}s.DOMNodeView=C,C.__name__="DOMNodeView";class z extends v.Model{constructor(e){super(e)}}s.DOMNode=z,z.__name__="DOMNode",z.__module__="bokeh.models.dom";class P extends C{render(){super.render(),this.el.textContent=this.model.content}_createElement(){return document.createTextNode("")}}s.TextView=P,P.__name__="TextView";class A extends z{constructor(e){super(e)}}s.Text=A,i=A,A.__name__="Text",i.prototype.default_view=P,i.define((({String:e})=>({content:[e,""]})));class N extends C{}s.PlaceholderView=N,N.__name__="PlaceholderView",N.tag_name="span";class E extends z{constructor(e){super(e)}}s.Placeholder=E,_=E,E.__name__="Placeholder",_.define((({})=>({})));class G extends N{update(e,t,s){this.el.textContent=t.toString()}}s.IndexView=G,G.__name__="IndexView";class I extends E{constructor(e){super(e)}}s.Index=I,o=I,I.__name__="Index",o.prototype.default_view=G,o.define((({})=>({})));class k extends N{update(e,t,s){const n=(0,O._get_column_value)(this.model.field,e,t),a=null==n?"???":`${n}`;this.el.textContent=a}}s.ValueRefView=k,k.__name__="ValueRefView";class $ extends E{constructor(e){super(e)}}s.ValueRef=$,r=$,$.__name__="ValueRef",r.prototype.default_view=k,r.define((({String:e})=>({field:[e]})));class B extends k{render(){super.render(),this.value_el=(0,g.span)(),this.swatch_el=(0,g.span)({class:S.tooltip_color_block}," "),this.el.appendChild(this.value_el),this.el.appendChild(this.swatch_el)}update(e,t,s){const n=(0,O._get_column_value)(this.model.field,e,t),a=null==n?"???":`${n}`;this.el.textContent=a}}s.ColorRefView=B,B.__name__="ColorRefView";class L extends ${constructor(e){super(e)}}s.ColorRef=L,c=L,L.__name__="ColorRef",c.prototype.default_view=B,c.define((({Boolean:e})=>({hex:[e,!0],swatch:[e,!0]})));class j extends C{constructor(){super(...arguments),this.child_views=new Map}async lazy_initialize(){await super.lazy_initialize();const e=this.model.children.filter((e=>e instanceof v.Model));await(0,R.build_views)(this.child_views,e,{parent:this})}render(){super.render();const{style:e}=this.model;if(null!=e)if(e instanceof V.Styles)for(const t of e){const e=t.get_value();if((0,D.isString)(e)){const s=t.attr.replace(/_/g,"-");this.el.style.hasOwnProperty(s)&&this.el.style.setProperty(s,e)}}else for(const[t,s]of(0,M.entries)(e)){const e=t.replace(/_/g,"-");this.el.style.hasOwnProperty(e)&&this.el.style.setProperty(e,s)}for(const e of this.model.children)if((0,D.isString)(e)){const t=document.createTextNode(e);this.el.appendChild(t)}else{this.child_views.get(e).renderTo(this.el)}}}s.DOMElementView=j,j.__name__="DOMElementView";class q extends z{constructor(e){super(e)}}s.DOMElement=q,d=q,q.__name__="DOMElement",d.define((({String:e,Array:t,Dict:s,Or:n,Nullable:a,Ref:l})=>({style:[a(n(l(V.Styles),s(e))),null],children:[t(n(e,l(z),l(y.LayoutDOM))),[]]})));class F extends T.View{}s.ActionView=F,F.__name__="ActionView";class H extends v.Model{constructor(e){super(e)}}s.Action=H,p=H,H.__name__="Action",H.__module__="bokeh.models.dom",p.define((({})=>({})));class J extends j{constructor(){super(...arguments),this.action_views=new Map}async lazy_initialize(){await super.lazy_initialize(),await(0,R.build_views)(this.action_views,this.model.actions,{parent:this})}remove(){(0,R.remove_views)(this.action_views),super.remove()}update(e,t,s={}){!function n(a){for(const l of a.child_views.values())l instanceof N?l.update(e,t,s):l instanceof j&&n(l)}(this);for(const n of this.action_views.values())n.update(e,t,s)}}s.TemplateView=J,J.__name__="TemplateView",J.tag_name="div";class K extends q{}s.Template=K,u=K,K.__name__="Template",u.prototype.default_view=J,u.define((({Array:e,Ref:t})=>({actions:[e(t(H)),[]]})));class Q extends j{}s.SpanView=Q,Q.__name__="SpanView",Q.tag_name="span";class U extends q{}s.Span=U,m=U,U.__name__="Span",m.prototype.default_view=Q;class W extends j{}s.DivView=W,W.__name__="DivView",W.tag_name="div";class X extends q{}s.Div=X,w=X,X.__name__="Div",w.prototype.default_view=W;class Y extends j{}s.TableView=Y,Y.__name__="TableView",Y.tag_name="table";class Z extends q{}s.Table=Z,f=Z,Z.__name__="Table",f.prototype.default_view=Y;class ee extends j{}s.TableRowView=ee,ee.__name__="TableRowView",ee.tag_name="tr";class te extends q{}s.TableRow=te,h=te,te.__name__="TableRow",h.prototype.default_view=ee;const se=e(41),ne=e(234);class ae extends F{update(e,t,s){for(const[e,s]of(0,ne.enumerate)(this.model.groups))e.visible=t==s}}s.ToggleGroupView=ae,ae.__name__="ToggleGroupView";class le extends H{constructor(e){super(e)}}s.ToggleGroup=le,x=le,le.__name__="ToggleGroup",x.prototype.default_view=ae,x.define((({Array:e,Ref:t})=>({groups:[e(t(se.RendererGroup)),[]]})))},
function _(l,n,u,_,e){var t;_();const o=l(53);class r extends o.Model{constructor(l){super(l)}}u.Styles=r,t=r,r.__name__="Styles",r.__module__="bokeh.models.css",t.define((({String:l,Nullable:n})=>({align_content:[n(l),null],align_items:[n(l),null],align_self:[n(l),null],alignment_baseline:[n(l),null],all:[n(l),null],animation:[n(l),null],animation_delay:[n(l),null],animation_direction:[n(l),null],animation_duration:[n(l),null],animation_fill_mode:[n(l),null],animation_iteration_count:[n(l),null],animation_name:[n(l),null],animation_play_state:[n(l),null],animation_timing_function:[n(l),null],backface_visibility:[n(l),null],background:[n(l),null],background_attachment:[n(l),null],background_clip:[n(l),null],background_color:[n(l),null],background_image:[n(l),null],background_origin:[n(l),null],background_position:[n(l),null],background_position_x:[n(l),null],background_position_y:[n(l),null],background_repeat:[n(l),null],background_size:[n(l),null],baseline_shift:[n(l),null],block_size:[n(l),null],border:[n(l),null],border_block_end:[n(l),null],border_block_end_color:[n(l),null],border_block_end_style:[n(l),null],border_block_end_width:[n(l),null],border_block_start:[n(l),null],border_block_start_color:[n(l),null],border_block_start_style:[n(l),null],border_block_start_width:[n(l),null],border_bottom:[n(l),null],border_bottom_color:[n(l),null],border_bottom_left_radius:[n(l),null],border_bottom_right_radius:[n(l),null],border_bottom_style:[n(l),null],border_bottom_width:[n(l),null],border_collapse:[n(l),null],border_color:[n(l),null],border_image:[n(l),null],border_image_outset:[n(l),null],border_image_repeat:[n(l),null],border_image_slice:[n(l),null],border_image_source:[n(l),null],border_image_width:[n(l),null],border_inline_end:[n(l),null],border_inline_end_color:[n(l),null],border_inline_end_style:[n(l),null],border_inline_end_width:[n(l),null],border_inline_start:[n(l),null],border_inline_start_color:[n(l),null],border_inline_start_style:[n(l),null],border_inline_start_width:[n(l),null],border_left:[n(l),null],border_left_color:[n(l),null],border_left_style:[n(l),null],border_left_width:[n(l),null],border_radius:[n(l),null],border_right:[n(l),null],border_right_color:[n(l),null],border_right_style:[n(l),null],border_right_width:[n(l),null],border_spacing:[n(l),null],border_style:[n(l),null],border_top:[n(l),null],border_top_color:[n(l),null],border_top_left_radius:[n(l),null],border_top_right_radius:[n(l),null],border_top_style:[n(l),null],border_top_width:[n(l),null],border_width:[n(l),null],bottom:[n(l),null],box_shadow:[n(l),null],box_sizing:[n(l),null],break_after:[n(l),null],break_before:[n(l),null],break_inside:[n(l),null],caption_side:[n(l),null],caret_color:[n(l),null],clear:[n(l),null],clip:[n(l),null],clip_path:[n(l),null],clip_rule:[n(l),null],color:[n(l),null],color_interpolation:[n(l),null],color_interpolation_filters:[n(l),null],column_count:[n(l),null],column_fill:[n(l),null],column_gap:[n(l),null],column_rule:[n(l),null],column_rule_color:[n(l),null],column_rule_style:[n(l),null],column_rule_width:[n(l),null],column_span:[n(l),null],column_width:[n(l),null],columns:[n(l),null],content:[n(l),null],counter_increment:[n(l),null],counter_reset:[n(l),null],css_float:[n(l),null],css_text:[n(l),null],cursor:[n(l),null],direction:[n(l),null],display:[n(l),null],dominant_baseline:[n(l),null],empty_cells:[n(l),null],fill:[n(l),null],fill_opacity:[n(l),null],fill_rule:[n(l),null],filter:[n(l),null],flex:[n(l),null],flex_basis:[n(l),null],flex_direction:[n(l),null],flex_flow:[n(l),null],flex_grow:[n(l),null],flex_shrink:[n(l),null],flex_wrap:[n(l),null],float:[n(l),null],flood_color:[n(l),null],flood_opacity:[n(l),null],font:[n(l),null],font_family:[n(l),null],font_feature_settings:[n(l),null],font_kerning:[n(l),null],font_size:[n(l),null],font_size_adjust:[n(l),null],font_stretch:[n(l),null],font_style:[n(l),null],font_synthesis:[n(l),null],font_variant:[n(l),null],font_variant_caps:[n(l),null],font_variant_east_asian:[n(l),null],font_variant_ligatures:[n(l),null],font_variant_numeric:[n(l),null],font_variant_position:[n(l),null],font_weight:[n(l),null],gap:[n(l),null],glyph_orientation_vertical:[n(l),null],grid:[n(l),null],grid_area:[n(l),null],grid_auto_columns:[n(l),null],grid_auto_flow:[n(l),null],grid_auto_rows:[n(l),null],grid_column:[n(l),null],grid_column_end:[n(l),null],grid_column_gap:[n(l),null],grid_column_start:[n(l),null],grid_gap:[n(l),null],grid_row:[n(l),null],grid_row_end:[n(l),null],grid_row_gap:[n(l),null],grid_row_start:[n(l),null],grid_template:[n(l),null],grid_template_areas:[n(l),null],grid_template_columns:[n(l),null],grid_template_rows:[n(l),null],height:[n(l),null],hyphens:[n(l),null],image_orientation:[n(l),null],image_rendering:[n(l),null],inline_size:[n(l),null],justify_content:[n(l),null],justify_items:[n(l),null],justify_self:[n(l),null],left:[n(l),null],letter_spacing:[n(l),null],lighting_color:[n(l),null],line_break:[n(l),null],line_height:[n(l),null],list_style:[n(l),null],list_style_image:[n(l),null],list_style_position:[n(l),null],list_style_type:[n(l),null],margin:[n(l),null],margin_block_end:[n(l),null],margin_block_start:[n(l),null],margin_bottom:[n(l),null],margin_inline_end:[n(l),null],margin_inline_start:[n(l),null],margin_left:[n(l),null],margin_right:[n(l),null],margin_top:[n(l),null],marker:[n(l),null],marker_end:[n(l),null],marker_mid:[n(l),null],marker_start:[n(l),null],mask:[n(l),null],mask_composite:[n(l),null],mask_image:[n(l),null],mask_position:[n(l),null],mask_repeat:[n(l),null],mask_size:[n(l),null],mask_type:[n(l),null],max_block_size:[n(l),null],max_height:[n(l),null],max_inline_size:[n(l),null],max_width:[n(l),null],min_block_size:[n(l),null],min_height:[n(l),null],min_inline_size:[n(l),null],min_width:[n(l),null],object_fit:[n(l),null],object_position:[n(l),null],opacity:[n(l),null],order:[n(l),null],orphans:[n(l),null],outline:[n(l),null],outline_color:[n(l),null],outline_offset:[n(l),null],outline_style:[n(l),null],outline_width:[n(l),null],overflow:[n(l),null],overflow_anchor:[n(l),null],overflow_wrap:[n(l),null],overflow_x:[n(l),null],overflow_y:[n(l),null],overscroll_behavior:[n(l),null],overscroll_behavior_block:[n(l),null],overscroll_behavior_inline:[n(l),null],overscroll_behavior_x:[n(l),null],overscroll_behavior_y:[n(l),null],padding:[n(l),null],padding_block_end:[n(l),null],padding_block_start:[n(l),null],padding_bottom:[n(l),null],padding_inline_end:[n(l),null],padding_inline_start:[n(l),null],padding_left:[n(l),null],padding_right:[n(l),null],padding_top:[n(l),null],page_break_after:[n(l),null],page_break_before:[n(l),null],page_break_inside:[n(l),null],paint_order:[n(l),null],perspective:[n(l),null],perspective_origin:[n(l),null],place_content:[n(l),null],place_items:[n(l),null],place_self:[n(l),null],pointer_events:[n(l),null],position:[n(l),null],quotes:[n(l),null],resize:[n(l),null],right:[n(l),null],rotate:[n(l),null],row_gap:[n(l),null],ruby_align:[n(l),null],ruby_position:[n(l),null],scale:[n(l),null],scroll_behavior:[n(l),null],shape_rendering:[n(l),null],stop_color:[n(l),null],stop_opacity:[n(l),null],stroke:[n(l),null],stroke_dasharray:[n(l),null],stroke_dashoffset:[n(l),null],stroke_linecap:[n(l),null],stroke_linejoin:[n(l),null],stroke_miterlimit:[n(l),null],stroke_opacity:[n(l),null],stroke_width:[n(l),null],tab_size:[n(l),null],table_layout:[n(l),null],text_align:[n(l),null],text_align_last:[n(l),null],text_anchor:[n(l),null],text_combine_upright:[n(l),null],text_decoration:[n(l),null],text_decoration_color:[n(l),null],text_decoration_line:[n(l),null],text_decoration_style:[n(l),null],text_emphasis:[n(l),null],text_emphasis_color:[n(l),null],text_emphasis_position:[n(l),null],text_emphasis_style:[n(l),null],text_indent:[n(l),null],text_justify:[n(l),null],text_orientation:[n(l),null],text_overflow:[n(l),null],text_rendering:[n(l),null],text_shadow:[n(l),null],text_transform:[n(l),null],text_underline_position:[n(l),null],top:[n(l),null],touch_action:[n(l),null],transform:[n(l),null],transform_box:[n(l),null],transform_origin:[n(l),null],transform_style:[n(l),null],transition:[n(l),null],transition_delay:[n(l),null],transition_duration:[n(l),null],transition_property:[n(l),null],transition_timing_function:[n(l),null],translate:[n(l),null],unicode_bidi:[n(l),null],user_select:[n(l),null],vertical_align:[n(l),null],visibility:[n(l),null],white_space:[n(l),null],widows:[n(l),null],width:[n(l),null],will_change:[n(l),null],word_break:[n(l),null],word_spacing:[n(l),null],word_wrap:[n(l),null],writing_mode:[n(l),null],z_index:[n(l),null]})))},
function _(t,o,e,n,s){var i;n();const l=t(15),c=t(53),r=t(224),a=t(232),u=t(234);class h extends c.Model{constructor(t){super(t)}get button_view(){return this.tools[0].button_view}get event_type(){return this.tools[0].event_type}get tooltip(){return this.tools[0].tooltip}get tool_name(){return this.tools[0].tool_name}get icon(){return this.tools[0].computed_icon}get computed_icon(){return this.icon}get toggleable(){const t=this.tools[0];return t instanceof a.InspectTool&&t.toggleable}initialize(){super.initialize(),this.do=new l.Signal0(this,"do")}connect_signals(){super.connect_signals(),this.connect(this.do,(()=>this.doit())),this.connect(this.properties.active.change,(()=>this.set_active()));for(const t of this.tools)this.connect(t.properties.active.change,(()=>{this.active=t.active}))}doit(){for(const t of this.tools)t.do.emit()}set_active(){for(const t of this.tools)t.active=this.active}get menu(){const{menu:t}=this.tools[0];if(null==t)return null;const o=[];for(const[e,n]of(0,u.enumerate)(t))if(null==e)o.push(null);else{const t=()=>{var t,o,e;for(const s of this.tools)null===(e=null===(o=null===(t=s.menu)||void 0===t?void 0:t[n])||void 0===o?void 0:o.handler)||void 0===e||e.call(o)};o.push(Object.assign(Object.assign({},e),{handler:t}))}return o}}e.ToolProxy=h,i=h,h.__name__="ToolProxy",i.define((({Boolean:t,Array:o,Ref:e})=>({tools:[o(e(r.ButtonTool)),[]],active:[t,!1],disabled:[t,!1]})))},
function _(o,t,s,e,i){var n,r;e();const l=o(20),c=o(9),h=o(13),a=o(233),_=o(221),p=o(394),u=o(309),f=o(207);class y extends a.ToolbarBase{constructor(o){super(o)}initialize(){super.initialize(),this._merge_tools()}_merge_tools(){this._proxied_tools=[];const o={},t={},s={},e=[],i=[];for(const o of this.help)(0,c.includes)(i,o.redirect)||(e.push(o),i.push(o.redirect));this._proxied_tools.push(...e),this.help=e;for(const[o,t]of(0,h.entries)(this.gestures)){o in s||(s[o]={});for(const e of t.tools)e.type in s[o]||(s[o][e.type]=[]),s[o][e.type].push(e)}for(const t of this.inspectors)t.type in o||(o[t.type]=[]),o[t.type].push(t);for(const o of this.actions)o.type in t||(t[o.type]=[]),t[o.type].push(o);const n=(o,t=!1)=>{const s=new p.ToolProxy({tools:o,active:t});return this._proxied_tools.push(s),s};for(const o of(0,h.keys)(s)){const t=this.gestures[o];t.tools=[];for(const e of(0,h.keys)(s[o])){const i=s[o][e];if(i.length>0)if("multi"==o)for(const o of i){const s=n([o]);t.tools.push(s),this.connect(s.properties.active.change,(()=>this._active_change(s)))}else{const o=n(i);t.tools.push(o),this.connect(o.properties.active.change,(()=>this._active_change(o)))}}}this.actions=[];for(const[o,s]of(0,h.entries)(t))if("CustomAction"==o)for(const o of s)this.actions.push(n([o]));else s.length>0&&this.actions.push(n(s));this.inspectors=[];for(const t of(0,h.values)(o))t.length>0&&this.inspectors.push(n(t,!0));for(const[o,t]of(0,h.entries)(this.gestures))0!=t.tools.length&&(t.tools=(0,c.sort_by)(t.tools,(o=>o.default_order)),"pinch"!=o&&"scroll"!=o&&"multi"!=o&&(t.tools[0].active=!0))}}s.ProxyToolbar=y,n=y,y.__name__="ProxyToolbar",n.define((({Array:o,Ref:t})=>({toolbars:[o(t(_.Toolbar)),[]]})));class d extends u.LayoutDOMView{initialize(){this.model.toolbar.toolbar_location=this.model.toolbar_location,super.initialize()}get child_models(){return[this.model.toolbar]}_update_layout(){this.layout=new f.ContentBox(this.child_views[0].el);const{toolbar:o}=this.model;o.horizontal?this.layout.set_sizing({width_policy:"fit",min_width:100,height_policy:"fixed"}):this.layout.set_sizing({width_policy:"fixed",height_policy:"fit",min_height:100})}after_layout(){super.after_layout();const o=this.child_views[0];o.layout.bbox=this.layout.bbox,o.render()}}s.ToolbarBoxView=d,d.__name__="ToolbarBoxView";class b extends u.LayoutDOM{constructor(o){super(o)}}s.ToolbarBox=b,r=b,b.__name__="ToolbarBox",r.prototype.default_view=d,r.define((({Ref:o})=>({toolbar:[o(a.ToolbarBase)],toolbar_location:[l.Location,"right"]})))},
function _(e,n,r,t,o){t();const s=e(1),u=e(53),c=(0,s.__importStar)(e(21)),a=e(8),l=e(13);r.resolve_defs=function(e,n){var r,t,o,s;function i(e){return null!=e.module?`${e.module}.${e.name}`:e.name}function f(e){if((0,a.isString)(e))switch(e){case"Any":return c.Any;case"Unknown":return c.Unknown;case"Boolean":return c.Boolean;case"Number":return c.Number;case"Int":return c.Int;case"String":return c.String;case"Null":return c.Null}else switch(e[0]){case"Nullable":{const[,n]=e;return c.Nullable(f(n))}case"Or":{const[,...n]=e;return c.Or(...n.map(f))}case"Tuple":{const[,n,...r]=e;return c.Tuple(f(n),...r.map(f))}case"Array":{const[,n]=e;return c.Array(f(n))}case"Struct":{const[,...n]=e,r=n.map((([e,n])=>[e,f(n)]));return c.Struct((0,l.to_object)(r))}case"Dict":{const[,n]=e;return c.Dict(f(n))}case"Map":{const[,n,r]=e;return c.Map(f(n),f(r))}case"Enum":{const[,...n]=e;return c.Enum(...n)}case"Ref":{const[,r]=e,t=n.get(i(r));if(null!=t)return c.Ref(t);throw new Error(`${i(r)} wasn't defined before referencing it`)}case"AnyRef":return c.AnyRef()}}for(const c of e){const e=(()=>{if(null==c.extends)return u.Model;{const e=n.get(i(c.extends));if(null!=e)return e;throw new Error(`base model ${i(c.extends)} of ${i(c)} is not defined`)}})(),a=((s=class extends e{}).__name__=c.name,s.__module__=c.module,s);for(const e of null!==(r=c.properties)&&void 0!==r?r:[]){const n=f(null!==(t=e.kind)&&void 0!==t?t:"Unknown");a.define({[e.name]:[n,e.default]})}for(const e of null!==(o=c.overrides)&&void 0!==o?o:[])a.override({[e.name]:e.default});n.register(a)}}},
function _(n,e,t,o,i){o();const d=n(5),c=n(226),s=n(113),a=n(43),l=n(398);t.index={},t.add_document_standalone=async function(n,e,o=[],i=!1){const u=new Map;async function f(i){let d;const f=n.roots().indexOf(i),r=o[f];null!=r?d=r:e.classList.contains(l.BOKEH_ROOT)?d=e:(d=(0,a.div)({class:l.BOKEH_ROOT}),e.appendChild(d));const w=await(0,s.build_view)(i,{parent:null});return w instanceof c.DOMView&&w.renderTo(d),u.set(i,w),t.index[i.id]=w,w}for(const e of n.roots())await f(e);return i&&(window.document.title=n.title()),n.on_change((n=>{n instanceof d.RootAddedEvent?f(n.model):n instanceof d.RootRemovedEvent?function(n){const e=u.get(n);null!=e&&(e.remove(),u.delete(n),delete t.index[n.id])}(n.model):i&&n instanceof d.TitleChangedEvent&&(window.document.title=n.title)})),[...u.values()]}},
function _(o,e,n,t,r){t();const l=o(43),d=o(44);function u(o){let e=document.getElementById(o);if(null==e)throw new Error(`Error rendering Bokeh model: could not find #${o} HTML tag`);if(!document.body.contains(e))throw new Error(`Error rendering Bokeh model: element #${o} must be under <body>`);if("SCRIPT"==e.tagName){const o=(0,l.div)({class:n.BOKEH_ROOT});(0,l.replaceWith)(e,o),e=o}return e}n.BOKEH_ROOT=d.root,n._resolve_element=function(o){const{elementid:e}=o;return null!=e?u(e):document.body},n._resolve_root_elements=function(o){const e=[];if(null!=o.root_ids&&null!=o.roots)for(const n of o.root_ids)e.push(u(o.roots[n]));return e}},
function _(n,o,t,s,e){s();const c=n(400),r=n(19),a=n(397);t._get_ws_url=function(n,o){let t,s="ws:";return"https:"==window.location.protocol&&(s="wss:"),null!=o?(t=document.createElement("a"),t.href=o):t=window.location,null!=n?"/"==n&&(n=""):n=t.pathname.replace(/\/+$/,""),`${s}//${t.host}${n}/ws`};const i={};t.add_document_from_session=async function(n,o,t,s=[],e=!1){const l=window.location.search.substr(1);let d;try{d=await function(n,o,t){const s=(0,c.parse_token)(o).session_id;n in i||(i[n]={});const e=i[n];return s in e||(e[s]=(0,c.pull_session)(n,o,t)),e[s]}(n,o,l)}catch(n){const t=(0,c.parse_token)(o).session_id;throw r.logger.error(`Failed to load Bokeh session ${t}: ${n}`),n}return(0,a.add_document_standalone)(d.document,t,s,e)}},
function _(e,s,n,t,o){t();const r=e(19),i=e(5),c=e(401),l=e(402),_=e(403);n.DEFAULT_SERVER_WEBSOCKET_URL="ws://localhost:5006/ws",n.DEFAULT_TOKEN="eyJzZXNzaW9uX2lkIjogImRlZmF1bHQifQ";let h=0;function a(e){let s=e.split(".")[0];const n=s.length%4;return 0!=n&&(s+="=".repeat(4-n)),JSON.parse(atob(s.replace(/_/g,"/").replace(/-/g,"+")))}n.parse_token=a;class d{constructor(e=n.DEFAULT_SERVER_WEBSOCKET_URL,s=n.DEFAULT_TOKEN,t=null){this.url=e,this.token=s,this.args_string=t,this._number=h++,this.socket=null,this.session=null,this.closed_permanently=!1,this._current_handler=null,this._pending_replies=new Map,this._pending_messages=[],this._receiver=new l.Receiver,this.id=a(s).session_id.split(".")[0],r.logger.debug(`Creating websocket ${this._number} to '${this.url}' session '${this.id}'`)}async connect(){if(this.closed_permanently)throw new Error("Cannot connect() a closed ClientConnection");if(null!=this.socket)throw new Error("Already connected");this._current_handler=null,this._pending_replies.clear(),this._pending_messages=[];try{let e=`${this.url}`;return null!=this.args_string&&this.args_string.length>0&&(e+=`?${this.args_string}`),this.socket=new WebSocket(e,["bokeh",this.token]),new Promise(((e,s)=>{this.socket.binaryType="arraybuffer",this.socket.onopen=()=>this._on_open(e,s),this.socket.onmessage=e=>this._on_message(e),this.socket.onclose=e=>this._on_close(e,s),this.socket.onerror=()=>this._on_error(s)}))}catch(e){throw r.logger.error(`websocket creation failed to url: ${this.url}`),r.logger.error(` - ${e}`),e}}close(){this.closed_permanently||(r.logger.debug(`Permanently closing websocket connection ${this._number}`),this.closed_permanently=!0,null!=this.socket&&this.socket.close(1e3,`close method called on ClientConnection ${this._number}`),this.session._connection_closed())}_schedule_reconnect(e){setTimeout((()=>{this.closed_permanently||r.logger.info(`Websocket connection ${this._number} disconnected, will not attempt to reconnect`)}),e)}send(e){if(null==this.socket)throw new Error(`not connected so cannot send ${e}`);e.send(this.socket)}async send_with_reply(e){const s=await new Promise(((s,n)=>{this._pending_replies.set(e.msgid(),{resolve:s,reject:n}),this.send(e)}));if("ERROR"===s.msgtype())throw new Error(`Error reply ${s.content.text}`);return s}async _pull_doc_json(){const e=c.Message.create("PULL-DOC-REQ",{}),s=await this.send_with_reply(e);if(!("doc"in s.content))throw new Error("No 'doc' field in PULL-DOC-REPLY");return s.content.doc}async _repull_session_doc(e,s){var n;r.logger.debug(this.session?"Repulling session":"Pulling session for first time");try{const n=await this._pull_doc_json();if(null==this.session)if(this.closed_permanently)r.logger.debug("Got new document after connection was already closed"),s(new Error("The connection has been closed"));else{const s=i.Document.from_json(n),t=i.Document._compute_patch_since_json(n,s);if(t.events.length>0){r.logger.debug(`Sending ${t.events.length} changes from model construction back to server`);const e=c.Message.create("PATCH-DOC",{},t);this.send(e)}this.session=new _.ClientSession(this,s,this.id);for(const e of this._pending_messages)this.session.handle(e);this._pending_messages=[],r.logger.debug("Created a new session from new pulled doc"),e(this.session)}else this.session.document.replace_with_json(n),r.logger.debug("Updated existing session with new pulled doc")}catch(e){null===(n=console.trace)||void 0===n||n.call(console,e),r.logger.error(`Failed to repull session ${e}`),s(e instanceof Error?e:`${e}`)}}_on_open(e,s){r.logger.info(`Websocket connection ${this._number} is now open`),this._current_handler=n=>{this._awaiting_ack_handler(n,e,s)}}_on_message(e){null==this._current_handler&&r.logger.error("Got a message with no current handler set");try{this._receiver.consume(e.data)}catch(e){this._close_bad_protocol(`${e}`)}const s=this._receiver.message;if(null!=s){const e=s.problem();null!=e&&this._close_bad_protocol(e),this._current_handler(s)}}_on_close(e,s){r.logger.info(`Lost websocket ${this._number} connection, ${e.code} (${e.reason})`),this.socket=null,this._pending_replies.forEach((e=>e.reject("Disconnected"))),this._pending_replies.clear(),this.closed_permanently||this._schedule_reconnect(2e3),s(new Error(`Lost websocket connection, ${e.code} (${e.reason})`))}_on_error(e){r.logger.debug(`Websocket error on socket ${this._number}`);const s="Could not open websocket";r.logger.error(`Failed to connect to Bokeh server: ${s}`),e(new Error(s))}_close_bad_protocol(e){r.logger.error(`Closing connection: ${e}`),null!=this.socket&&this.socket.close(1002,e)}_awaiting_ack_handler(e,s,n){"ACK"===e.msgtype()?(this._current_handler=e=>this._steady_state_handler(e),this._repull_session_doc(s,n)):this._close_bad_protocol("First message was not an ACK")}_steady_state_handler(e){const s=e.reqid(),n=this._pending_replies.get(s);n?(this._pending_replies.delete(s),n.resolve(e)):this.session?this.session.handle(e):"PATCH-DOC"!=e.msgtype()&&this._pending_messages.push(e)}}n.ClientConnection=d,d.__name__="ClientConnection",n.pull_session=function(e,s,n){return new d(e,s,n).connect()}},
function _(e,s,t,r,n){r();const i=e(34);class a{constructor(e,s,t){this.header=e,this.metadata=s,this.content=t,this.buffers=new Map}static assemble(e,s,t){const r=JSON.parse(e),n=JSON.parse(s),i=JSON.parse(t);return new a(r,n,i)}assemble_buffer(e,s){const t=null!=this.header.num_buffers?this.header.num_buffers:0;if(t<=this.buffers.size)throw new Error(`too many buffers received, expecting ${t}`);const{id:r}=JSON.parse(e);this.buffers.set(r,s)}static create(e,s,t={}){const r=a.create_header(e);return new a(r,s,t)}static create_header(e){return{msgid:(0,i.uniqueId)(),msgtype:e}}complete(){return null!=this.header&&null!=this.metadata&&null!=this.content&&(null==this.header.num_buffers||this.buffers.size==this.header.num_buffers)}send(e){if((null!=this.header.num_buffers?this.header.num_buffers:0)>0)throw new Error("BokehJS only supports receiving buffers, not sending");const s=JSON.stringify(this.header),t=JSON.stringify(this.metadata),r=JSON.stringify(this.content);e.send(s),e.send(t),e.send(r)}msgid(){return this.header.msgid}msgtype(){return this.header.msgtype}reqid(){return this.header.reqid}problem(){return"msgid"in this.header?"msgtype"in this.header?null:"No msgtype in header":"No msgid in header"}}t.Message=a,a.__name__="Message"},
function _(e,t,s,_,r){_();const i=e(401),h=e(8);class a{constructor(){this.message=null,this._partial=null,this._fragments=[],this._buf_header=null,this._current_consumer=this._HEADER}consume(e){this._current_consumer(e)}_HEADER(e){this._assume_text(e),this.message=null,this._partial=null,this._fragments=[e],this._buf_header=null,this._current_consumer=this._METADATA}_METADATA(e){this._assume_text(e),this._fragments.push(e),this._current_consumer=this._CONTENT}_CONTENT(e){this._assume_text(e),this._fragments.push(e);const[t,s,_]=this._fragments.slice(0,3);this._partial=i.Message.assemble(t,s,_),this._check_complete()}_BUFFER_HEADER(e){this._assume_text(e),this._buf_header=e,this._current_consumer=this._BUFFER_PAYLOAD}_BUFFER_PAYLOAD(e){this._assume_binary(e),this._partial.assemble_buffer(this._buf_header,e),this._check_complete()}_assume_text(e){if(!(0,h.isString)(e))throw new Error("Expected text fragment but received binary fragment")}_assume_binary(e){if(!(e instanceof ArrayBuffer))throw new Error("Expected binary fragment but received text fragment")}_check_complete(){this._partial.complete()?(this.message=this._partial,this._current_consumer=this._HEADER):this._current_consumer=this._BUFFER_HEADER}}s.Receiver=a,a.__name__="Receiver"},
function _(e,t,n,s,o){s();const c=e(5),i=e(401),_=e(19);class r{constructor(e,t,n){this._connection=e,this.document=t,this.id=n,this._document_listener=e=>{this._document_changed(e)},this.document.on_change(this._document_listener,!0)}handle(e){const t=e.msgtype();"PATCH-DOC"===t?this._handle_patch(e):"OK"===t?this._handle_ok(e):"ERROR"===t?this._handle_error(e):_.logger.debug(`Doing nothing with message ${e.msgtype()}`)}close(){this._connection.close()}_connection_closed(){this.document.remove_on_change(this._document_listener)}async request_server_info(){const e=i.Message.create("SERVER-INFO-REQ",{});return(await this._connection.send_with_reply(e)).content}async force_roundtrip(){await this.request_server_info()}_document_changed(e){if(e.setter_id===this.id)return;const t=e instanceof c.DocumentEventBatch?e.events:[e],n=this.document.create_json_patch(t),s=i.Message.create("PATCH-DOC",{},n);this._connection.send(s)}_handle_patch(e){this.document.apply_json_patch(e.content,e.buffers,this.id)}_handle_ok(e){_.logger.trace(`Unhandled OK reply to ${e.reqid()}`)}_handle_error(e){_.logger.error(`Unhandled ERROR reply to ${e.reqid()}: ${e.content.text}`)}}n.ClientSession=r,r.__name__="ClientSession"},
function _(e,o,t,n,r){n();const s=e(1),l=e(5),i=e(402),a=e(19),c=e(43),g=e(13),f=e(397),u=e(398),m=(0,s.__importDefault)(e(44)),p=(0,s.__importDefault)(e(240)),d=(0,s.__importDefault)(e(405));function _(e,o){o.buffers.length>0?e.consume(o.buffers[0].buffer):e.consume(o.content.data);const t=e.message;null!=t&&this.apply_json_patch(t.content,t.buffers)}function b(e,o){if("undefined"!=typeof Jupyter&&null!=Jupyter.notebook.kernel){a.logger.info(`Registering Jupyter comms for target ${e}`);const t=Jupyter.notebook.kernel.comm_manager;try{t.register_target(e,(t=>{a.logger.info(`Registering Jupyter comms for target ${e}`);const n=new i.Receiver;t.on_msg(_.bind(o,n))}))}catch(e){a.logger.warn(`Jupyter comms failed to register. push_notebook() will not function. (exception reported: ${e})`)}}else if(o.roots()[0].id in t.kernels){a.logger.info(`Registering JupyterLab comms for target ${e}`);const n=t.kernels[o.roots()[0].id];try{n.registerCommTarget(e,(t=>{a.logger.info(`Registering JupyterLab comms for target ${e}`);const n=new i.Receiver;t.onMsg=_.bind(o,n)}))}catch(e){a.logger.warn(`Jupyter comms failed to register. push_notebook() will not function. (exception reported: ${e})`)}}else if("undefined"!=typeof google&&null!=google.colab.kernel){a.logger.info(`Registering Google Colab comms for target ${e}`);const t=google.colab.kernel.comms;try{t.registerTarget(e,(async t=>{var n,r,l;a.logger.info(`Registering Google Colab comms for target ${e}`);const c=new i.Receiver;try{for(var g,f=(0,s.__asyncValues)(t.messages);!(g=await f.next()).done;){const e=g.value,t={data:e.data},n=[];for(const o of null!==(l=e.buffers)&&void 0!==l?l:[])n.push(new DataView(o));const r={content:t,buffers:n};_.bind(o)(c,r)}}catch(e){n={error:e}}finally{try{g&&!g.done&&(r=f.return)&&await r.call(f)}finally{if(n)throw n.error}}}))}catch(e){a.logger.warn(`Google Colab comms failed to register. push_notebook() will not function. (exception reported: ${e})`)}}else console.warn("Jupyter notebooks comms not available. push_notebook() will not function. If running JupyterLab ensure the latest @bokeh/jupyter_bokeh extension is installed. In an exported notebook this warning is expected.")}c.stylesheet.append(m.default),c.stylesheet.append(p.default),c.stylesheet.append(d.default),t.kernels={},t.embed_items_notebook=function(e,o){if(1!=(0,g.size)(e))throw new Error("embed_items_notebook expects exactly one document in docs_json");const t=l.Document.from_json((0,g.values)(e)[0]);for(const e of o){null!=e.notebook_comms_target&&b(e.notebook_comms_target,t);const o=(0,u._resolve_element)(e),n=(0,u._resolve_root_elements)(e);(0,f.add_document_standalone)(t,o,n)}}},
function _(t,o,r,e,d){e(),r.root="bk-root",r.tooltip="bk-tooltip",r.default=".rendered_html .bk-root .bk-tooltip table,.rendered_html .bk-root .bk-tooltip tr,.rendered_html .bk-root .bk-tooltip th,.rendered_html .bk-root .bk-tooltip td{border:none;padding:1px;}"},
function _(t,_,o,r,n){r();const a=t(1);(0,a.__exportStar)(t(401),o),(0,a.__exportStar)(t(402),o)},
function _(e,t,n,s,o){function l(){const e=document.getElementsByTagName("body")[0],t=document.getElementsByClassName("bokeh-test-div");1==t.length&&(e.removeChild(t[0]),delete t[0]);const n=document.createElement("div");n.classList.add("bokeh-test-div"),n.style.display="none",e.insertBefore(n,e.firstChild)}s(),n.results={},n.init=function(){l()},n.record0=function(e,t){n.results[e]=t},n.record=function(e,t){n.results[e]=t,l()},n.count=function(e){null==n.results[e]&&(n.results[e]=0),n.results[e]+=1,l()}},
function _(e,t,o,n,l){n(),o.safely=function(e,t=!1){try{return e()}catch(e){if(function(e){const t=document.createElement("div");t.style.backgroundColor="#f2dede",t.style.border="1px solid #a94442",t.style.borderRadius="4px",t.style.display="inline-block",t.style.fontFamily="sans-serif",t.style.marginTop="5px",t.style.minWidth="200px",t.style.padding="5px 5px 5px 10px",t.classList.add("bokeh-error-box-into-flames");const o=document.createElement("span");o.style.backgroundColor="#a94442",o.style.borderRadius="0px 4px 0px 0px",o.style.color="white",o.style.cursor="pointer",o.style.cssFloat="right",o.style.fontSize="0.8em",o.style.margin="-6px -6px 0px 0px",o.style.padding="2px 5px 4px 5px",o.title="close",o.setAttribute("aria-label","close"),o.appendChild(document.createTextNode("x")),o.addEventListener("click",(()=>s.removeChild(t)));const n=document.createElement("h3");n.style.color="#a94442",n.style.margin="8px 0px 0px 0px",n.style.padding="0px",n.appendChild(document.createTextNode("Bokeh Error"));const l=document.createElement("pre");l.style.whiteSpace="unset",l.style.overflowX="auto",l.appendChild(document.createTextNode(e)),t.appendChild(o),t.appendChild(n),t.appendChild(l);const s=document.getElementsByTagName("body")[0];s.insertBefore(t,s.firstChild)}(e instanceof Error&&e.stack?e.stack:`${e}`),t)return;throw e}}},
], 0, {"main":0,"tslib":1,"index":2,"version":3,"embed/index":4,"document/index":5,"document/document":6,"base":7,"core/util/types":8,"core/util/array":9,"core/util/math":10,"core/util/assert":11,"core/util/arrayable":12,"core/util/object":13,"core/has_props":14,"core/signaling":15,"core/util/defer":16,"core/util/refs":17,"core/properties":18,"core/logging":19,"core/enums":20,"core/kinds":21,"core/util/color":22,"core/util/svg_colors":23,"core/types":24,"core/util/bitset":25,"core/util/eq":26,"core/util/platform":27,"core/settings":28,"core/util/ndarray":29,"core/serializer":30,"core/util/serialization":31,"core/util/buffer":32,"core/uniforms":33,"core/util/string":34,"document/events":35,"core/util/pretty":36,"core/util/cloneable":37,"models/index":38,"models/annotations/index":39,"models/annotations/annotation":40,"models/renderers/renderer":41,"core/view":42,"core/dom":43,"styles/root.css":44,"core/visuals/index":45,"core/visuals/line":46,"core/visuals/visual":47,"core/property_mixins":48,"core/visuals/fill":49,"core/visuals/text":50,"core/visuals/hatch":51,"core/visuals/patterns":52,"model":53,"models/canvas/coordinates":54,"models/scales/scale":55,"models/transforms/transform":56,"models/ranges/range":57,"models/ranges/range1d":58,"models/scales/linear_scale":59,"models/scales/continuous_scale":60,"models/scales/log_scale":61,"models/scales/categorical_scale":62,"models/ranges/data_range1d":63,"models/ranges/data_range":64,"core/util/bbox":65,"models/util":66,"models/ranges/factor_range":67,"models/annotations/arrow":68,"models/annotations/data_annotation":69,"models/sources/columnar_data_source":70,"models/sources/data_source":71,"models/selections/selection":72,"core/selection_manager":73,"models/selections/interaction_policy":74,"models/sources/column_data_source":75,"core/util/typed_array":76,"core/util/set":77,"core/util/projections":78,"models/annotations/arrow_head":112,"core/build_views":113,"models/annotations/band":114,"models/annotations/upper_lower":115,"models/annotations/box_annotation":116,"models/annotations/color_bar":117,"models/annotations/title":118,"models/annotations/text_annotation":119,"core/graphics":120,"core/util/text":121,"core/util/affine":122,"core/layout/side_panel":123,"core/layout/types":124,"core/layout/layoutable":125,"models/canvas/cartesian_frame":126,"models/axes/index":127,"models/axes/axis":128,"models/renderers/guide_renderer":129,"models/tickers/ticker":130,"models/formatters/tick_formatter":131,"models/policies/labeling":132,"models/text/base_text":133,"models/text/utils":134,"models/text/math_text":135,"core/util/image":136,"models/text/providers":137,"core/util/modules":138,"models/text/plain_text":139,"models/axes/categorical_axis":140,"models/tickers/categorical_ticker":141,"models/formatters/categorical_tick_formatter":142,"models/axes/continuous_axis":143,"models/axes/datetime_axis":144,"models/axes/linear_axis":145,"models/formatters/basic_tick_formatter":146,"models/tickers/basic_ticker":147,"models/tickers/adaptive_ticker":148,"models/tickers/continuous_ticker":149,"models/formatters/datetime_tick_formatter":150,"core/util/templating":152,"models/tickers/datetime_ticker":155,"models/tickers/composite_ticker":156,"models/tickers/days_ticker":157,"models/tickers/single_interval_ticker":158,"models/tickers/util":159,"models/tickers/months_ticker":160,"models/tickers/years_ticker":161,"models/axes/log_axis":162,"models/formatters/log_tick_formatter":163,"models/tickers/log_ticker":164,"models/axes/mercator_axis":165,"models/formatters/mercator_tick_formatter":166,"models/tickers/mercator_ticker":167,"models/tickers/index":168,"models/tickers/fixed_ticker":169,"models/tickers/binned_ticker":170,"models/mappers/scanning_color_mapper":171,"models/mappers/continuous_color_mapper":172,"models/mappers/color_mapper":173,"models/mappers/mapper":174,"models/renderers/glyph_renderer":175,"models/renderers/data_renderer":176,"models/glyphs/line":177,"models/glyphs/xy_glyph":178,"models/glyphs/glyph":179,"core/util/ragged_array":180,"core/util/spatial":181,"models/glyphs/utils":184,"core/hittest":185,"models/glyphs/patch":186,"models/glyphs/harea":187,"models/glyphs/area":188,"models/glyphs/varea":189,"models/sources/cds_view":190,"models/filters/filter":191,"models/formatters/index":192,"models/formatters/func_tick_formatter":193,"models/formatters/numeral_tick_formatter":194,"models/formatters/printf_tick_formatter":195,"models/mappers/index":196,"models/mappers/categorical_color_mapper":197,"models/mappers/categorical_mapper":198,"models/mappers/categorical_marker_mapper":199,"models/mappers/categorical_pattern_mapper":200,"models/mappers/linear_color_mapper":201,"models/mappers/log_color_mapper":202,"models/mappers/eqhist_color_mapper":203,"models/scales/index":204,"models/scales/linear_interpolation_scale":205,"models/ranges/index":206,"core/layout/index":207,"core/layout/alignments":208,"core/layout/grid":209,"core/layout/html":210,"core/layout/border":211,"models/annotations/label":212,"models/annotations/label_set":213,"models/annotations/legend":214,"models/annotations/legend_item":215,"core/vectorization":216,"models/annotations/poly_annotation":217,"models/annotations/slope":218,"models/annotations/span":219,"models/annotations/toolbar_panel":220,"models/tools/toolbar":221,"models/tools/tool":222,"models/tools/gestures/gesture_tool":223,"models/tools/button_tool":224,"core/dom_view":226,"styles/toolbar.css":227,"styles/icons.css":228,"styles/menus.css":229,"core/util/menus":230,"models/tools/on_off_button":231,"models/tools/inspectors/inspect_tool":232,"models/tools/toolbar_base":233,"core/util/iterator":234,"core/util/canvas":235,"core/util/svg":236,"core/util/random":237,"models/tools/actions/action_tool":238,"models/tools/actions/help_tool":239,"styles/logo.css":240,"models/annotations/tooltip":241,"styles/tooltips.css":242,"models/annotations/whisker":243,"models/callbacks/index":244,"models/callbacks/customjs":245,"models/callbacks/callback":246,"models/callbacks/open_url":247,"models/canvas/index":248,"models/canvas/canvas":249,"core/ui_events":250,"core/bokeh_events":251,"core/util/wheel":252,"models/expressions/index":253,"models/expressions/expression":254,"models/expressions/customjs_expr":255,"models/expressions/stack":256,"models/expressions/cumsum":257,"models/expressions/minimum":258,"models/expressions/maximum":259,"models/expressions/coordinate_transform":260,"models/expressions/polar":261,"models/filters/index":262,"models/filters/boolean_filter":263,"models/filters/customjs_filter":264,"models/filters/group_filter":265,"models/filters/index_filter":266,"models/glyphs/index":267,"models/glyphs/annular_wedge":268,"models/glyphs/annulus":269,"models/glyphs/arc":270,"models/glyphs/bezier":271,"models/glyphs/circle":272,"models/glyphs/ellipse":273,"models/glyphs/ellipse_oval":274,"models/glyphs/center_rotatable":275,"models/glyphs/hbar":276,"models/glyphs/box":277,"models/glyphs/hex_tile":278,"models/glyphs/image":279,"models/glyphs/image_base":280,"models/glyphs/image_rgba":281,"models/glyphs/image_url":282,"models/glyphs/multi_line":283,"models/glyphs/multi_polygons":284,"models/glyphs/oval":285,"models/glyphs/patches":286,"models/glyphs/quad":287,"models/glyphs/quadratic":288,"models/glyphs/ray":289,"models/glyphs/rect":290,"models/glyphs/scatter":291,"models/glyphs/marker":292,"models/glyphs/defs":293,"models/glyphs/segment":294,"models/glyphs/spline":295,"core/util/interpolation":296,"models/glyphs/step":297,"models/glyphs/text":298,"models/glyphs/vbar":299,"models/glyphs/wedge":300,"models/graphs/index":301,"models/graphs/graph_hit_test_policy":302,"models/graphs/layout_provider":303,"models/graphs/static_layout_provider":304,"models/grids/index":305,"models/grids/grid":306,"models/layouts/index":307,"models/layouts/box":308,"models/layouts/layout_dom":309,"models/layouts/column":310,"models/layouts/grid_box":311,"models/layouts/html_box":312,"models/layouts/panel":313,"models/layouts/row":314,"models/layouts/spacer":315,"models/layouts/tabs":316,"styles/tabs.css":317,"styles/buttons.css":318,"models/layouts/widget_box":319,"models/text/index":320,"models/transforms/index":321,"models/transforms/customjs_transform":322,"models/transforms/dodge":323,"models/transforms/range_transform":324,"models/transforms/interpolator":325,"models/transforms/jitter":326,"models/transforms/linear_interpolator":327,"models/transforms/step_interpolator":328,"models/plots/index":329,"models/plots/gmap_plot":330,"models/plots/plot":331,"models/plots/plot_canvas":332,"core/util/throttle":333,"models/plots/range_manager":334,"models/plots/state_manager":335,"models/plots/gmap_plot_canvas":336,"models/policies/index":337,"models/renderers/index":338,"models/renderers/graph_renderer":339,"models/selections/index":340,"models/sources/index":341,"models/sources/server_sent_data_source":342,"models/sources/web_data_source":343,"models/sources/ajax_data_source":344,"models/sources/geojson_data_source":345,"models/tiles/index":346,"models/tiles/bbox_tile_source":347,"models/tiles/mercator_tile_source":348,"models/tiles/tile_source":349,"models/tiles/tile_utils":350,"models/tiles/quadkey_tile_source":351,"models/tiles/tile_renderer":352,"models/tiles/wmts_tile_source":353,"styles/tiles.css":354,"models/tiles/tms_tile_source":355,"models/textures/index":356,"models/textures/canvas_texture":357,"models/textures/texture":358,"models/textures/image_url_texture":359,"models/tools/index":360,"models/tools/actions/custom_action":361,"models/tools/actions/redo_tool":362,"models/tools/actions/reset_tool":363,"models/tools/actions/save_tool":364,"models/tools/actions/undo_tool":365,"models/tools/actions/zoom_in_tool":366,"models/tools/actions/zoom_base_tool":367,"core/util/zoom":368,"models/tools/actions/zoom_out_tool":369,"models/tools/edit/edit_tool":370,"models/tools/edit/box_edit_tool":371,"models/tools/edit/freehand_draw_tool":372,"models/tools/edit/point_draw_tool":373,"models/tools/edit/poly_draw_tool":374,"models/tools/edit/poly_tool":375,"models/tools/edit/poly_edit_tool":376,"models/tools/gestures/box_select_tool":377,"models/tools/gestures/select_tool":378,"models/tools/gestures/box_zoom_tool":379,"models/tools/gestures/lasso_select_tool":380,"models/tools/gestures/poly_select_tool":381,"models/tools/edit/line_edit_tool":382,"models/tools/edit/line_tool":383,"models/tools/gestures/pan_tool":384,"models/tools/gestures/range_tool":385,"models/tools/gestures/tap_tool":386,"models/tools/gestures/wheel_pan_tool":387,"models/tools/gestures/wheel_zoom_tool":388,"models/tools/inspectors/crosshair_tool":389,"models/tools/inspectors/customjs_hover":390,"models/tools/inspectors/hover_tool":391,"models/dom/index":392,"models/dom/styles":393,"models/tools/tool_proxy":394,"models/tools/toolbar_box":395,"document/defs":396,"embed/standalone":397,"embed/dom":398,"embed/server":399,"client/connection":400,"protocol/message":401,"protocol/receiver":402,"client/session":403,"embed/notebook":404,"styles/notebook.css":405,"protocol/index":406,"testing":407,"safely":408}, {});});
