import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServicePipelinesEmailConfig extends cdktf.TerraformMetaArguments {
    /**
    * Branches to send notifications for. Valid options are `all`, `default`, `protected`, and `default_and_protected`. Default is `default`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_pipelines_email#branches_to_be_notified ServicePipelinesEmail#branches_to_be_notified}
    */
    readonly branchesToBeNotified?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_pipelines_email#id ServicePipelinesEmail#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Notify only broken pipelines. Default is true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_pipelines_email#notify_only_broken_pipelines ServicePipelinesEmail#notify_only_broken_pipelines}
    */
    readonly notifyOnlyBrokenPipelines?: boolean | cdktf.IResolvable;
    /**
    * ID of the project you want to activate integration on.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_pipelines_email#project ServicePipelinesEmail#project}
    */
    readonly project: string;
    /**
    * ) email addresses where notifications are sent.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/service_pipelines_email#recipients ServicePipelinesEmail#recipients}
    */
    readonly recipients: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/service_pipelines_email gitlab_service_pipelines_email}
*/
export declare class ServicePipelinesEmail extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_service_pipelines_email";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/service_pipelines_email gitlab_service_pipelines_email} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServicePipelinesEmailConfig
    */
    constructor(scope: Construct, id: string, config: ServicePipelinesEmailConfig);
    private _branchesToBeNotified?;
    get branchesToBeNotified(): string;
    set branchesToBeNotified(value: string);
    resetBranchesToBeNotified(): void;
    get branchesToBeNotifiedInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _notifyOnlyBrokenPipelines?;
    get notifyOnlyBrokenPipelines(): boolean | cdktf.IResolvable;
    set notifyOnlyBrokenPipelines(value: boolean | cdktf.IResolvable);
    resetNotifyOnlyBrokenPipelines(): void;
    get notifyOnlyBrokenPipelinesInput(): boolean | cdktf.IResolvable | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    private _recipients?;
    get recipients(): string[];
    set recipients(value: string[]);
    get recipientsInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
