# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FunctionArgs', 'Function']

@pulumi.input_type
class FunctionArgs:
    def __init__(__self__, *,
                 runtime: pulumi.Input[str],
                 available_memory_mb: Optional[pulumi.Input[int]] = None,
                 build_environment_variables: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 entry_point: Optional[pulumi.Input[str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 event_trigger: Optional[pulumi.Input['FunctionEventTriggerArgs']] = None,
                 https_trigger_url: Optional[pulumi.Input[str]] = None,
                 ingress_settings: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 max_instances: Optional[pulumi.Input[int]] = None,
                 min_instances: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 service_account_email: Optional[pulumi.Input[str]] = None,
                 source_archive_bucket: Optional[pulumi.Input[str]] = None,
                 source_archive_object: Optional[pulumi.Input[str]] = None,
                 source_repository: Optional[pulumi.Input['FunctionSourceRepositoryArgs']] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 trigger_http: Optional[pulumi.Input[bool]] = None,
                 vpc_connector: Optional[pulumi.Input[str]] = None,
                 vpc_connector_egress_settings: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Function resource.
        :param pulumi.Input[str] runtime: The runtime in which the function is going to run.
               Eg. `"nodejs10"`, `"nodejs12"`, `"nodejs14"`, `"python37"`, `"python38"`, `"python39"`, `"dotnet3"`, `"go113"`, `"java11"`, `"ruby27"`, etc. Check the [official doc](https://cloud.google.com/functions/docs/concepts/exec#runtimes) for the up-to-date list.
        :param pulumi.Input[int] available_memory_mb: Memory (in MB), available to the function. Default value is `256`. Possible values include `128`, `256`, `512`, `1024`, etc.
        :param pulumi.Input[Mapping[str, Any]] build_environment_variables: A set of key/value environment variable pairs available during build time.
        :param pulumi.Input[str] description: Description of the function.
        :param pulumi.Input[str] entry_point: Name of the function that will be executed when the Google Cloud Function is triggered.
        :param pulumi.Input[Mapping[str, Any]] environment_variables: A set of key/value environment variable pairs to assign to the function.
        :param pulumi.Input['FunctionEventTriggerArgs'] event_trigger: A source that fires events in response to a condition in another service. Structure is documented below. Cannot be used with `trigger_http`.
        :param pulumi.Input[str] https_trigger_url: URL which triggers function execution. Returned only if `trigger_http` is used.
        :param pulumi.Input[str] ingress_settings: String value that controls what traffic can reach the function. Allowed values are `ALLOW_ALL`, `ALLOW_INTERNAL_AND_GCLB` and `ALLOW_INTERNAL_ONLY`. Check [ingress documentation](https://cloud.google.com/functions/docs/networking/network-settings#ingress_settings) to see the impact of each settings value. Changes to this field will recreate the cloud function.
        :param pulumi.Input[Mapping[str, Any]] labels: A set of key/value label pairs to assign to the function. Label keys must follow the requirements at https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements.
        :param pulumi.Input[int] max_instances: The limit on the maximum number of function instances that may coexist at a given time.
        :param pulumi.Input[int] min_instances: The limit on the minimum number of function instances that may coexist at a given time.
        :param pulumi.Input[str] name: A user-defined name of the function. Function names must be unique globally.
        :param pulumi.Input[str] project: Project of the function. If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: Region of function. If it is not provided, the provider region is used.
        :param pulumi.Input[str] service_account_email: If provided, the self-provided service account to run the function with.
        :param pulumi.Input[str] source_archive_bucket: The GCS bucket containing the zip archive which contains the function.
        :param pulumi.Input[str] source_archive_object: The source archive object (file) in archive bucket.
        :param pulumi.Input['FunctionSourceRepositoryArgs'] source_repository: Represents parameters related to source repository where a function is hosted.
               Cannot be set alongside `source_archive_bucket` or `source_archive_object`. Structure is documented below.
        :param pulumi.Input[int] timeout: Timeout (in seconds) for the function. Default value is 60 seconds. Cannot be more than 540 seconds.
        :param pulumi.Input[bool] trigger_http: Boolean variable. Any HTTP request (of a supported type) to the endpoint will trigger function execution. Supported HTTP request types are: POST, PUT, GET, DELETE, and OPTIONS. Endpoint is returned as `https_trigger_url`. Cannot be used with `event_trigger`.
        :param pulumi.Input[str] vpc_connector: The VPC Network Connector that this cloud function can connect to. It should be set up as fully-qualified URI. The format of this field is `projects/*/locations/*/connectors/*`.
        :param pulumi.Input[str] vpc_connector_egress_settings: The egress settings for the connector, controlling what traffic is diverted through it. Allowed values are `ALL_TRAFFIC` and `PRIVATE_RANGES_ONLY`. Defaults to `PRIVATE_RANGES_ONLY`. If unset, this field preserves the previously set value.
        """
        pulumi.set(__self__, "runtime", runtime)
        if available_memory_mb is not None:
            pulumi.set(__self__, "available_memory_mb", available_memory_mb)
        if build_environment_variables is not None:
            pulumi.set(__self__, "build_environment_variables", build_environment_variables)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entry_point is not None:
            pulumi.set(__self__, "entry_point", entry_point)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if event_trigger is not None:
            pulumi.set(__self__, "event_trigger", event_trigger)
        if https_trigger_url is not None:
            pulumi.set(__self__, "https_trigger_url", https_trigger_url)
        if ingress_settings is not None:
            pulumi.set(__self__, "ingress_settings", ingress_settings)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_instances is not None:
            pulumi.set(__self__, "max_instances", max_instances)
        if min_instances is not None:
            pulumi.set(__self__, "min_instances", min_instances)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if service_account_email is not None:
            pulumi.set(__self__, "service_account_email", service_account_email)
        if source_archive_bucket is not None:
            pulumi.set(__self__, "source_archive_bucket", source_archive_bucket)
        if source_archive_object is not None:
            pulumi.set(__self__, "source_archive_object", source_archive_object)
        if source_repository is not None:
            pulumi.set(__self__, "source_repository", source_repository)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if trigger_http is not None:
            pulumi.set(__self__, "trigger_http", trigger_http)
        if vpc_connector is not None:
            pulumi.set(__self__, "vpc_connector", vpc_connector)
        if vpc_connector_egress_settings is not None:
            pulumi.set(__self__, "vpc_connector_egress_settings", vpc_connector_egress_settings)

    @property
    @pulumi.getter
    def runtime(self) -> pulumi.Input[str]:
        """
        The runtime in which the function is going to run.
        Eg. `"nodejs10"`, `"nodejs12"`, `"nodejs14"`, `"python37"`, `"python38"`, `"python39"`, `"dotnet3"`, `"go113"`, `"java11"`, `"ruby27"`, etc. Check the [official doc](https://cloud.google.com/functions/docs/concepts/exec#runtimes) for the up-to-date list.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: pulumi.Input[str]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter(name="availableMemoryMb")
    def available_memory_mb(self) -> Optional[pulumi.Input[int]]:
        """
        Memory (in MB), available to the function. Default value is `256`. Possible values include `128`, `256`, `512`, `1024`, etc.
        """
        return pulumi.get(self, "available_memory_mb")

    @available_memory_mb.setter
    def available_memory_mb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "available_memory_mb", value)

    @property
    @pulumi.getter(name="buildEnvironmentVariables")
    def build_environment_variables(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A set of key/value environment variable pairs available during build time.
        """
        return pulumi.get(self, "build_environment_variables")

    @build_environment_variables.setter
    def build_environment_variables(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "build_environment_variables", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the function.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="entryPoint")
    def entry_point(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the function that will be executed when the Google Cloud Function is triggered.
        """
        return pulumi.get(self, "entry_point")

    @entry_point.setter
    def entry_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entry_point", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A set of key/value environment variable pairs to assign to the function.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="eventTrigger")
    def event_trigger(self) -> Optional[pulumi.Input['FunctionEventTriggerArgs']]:
        """
        A source that fires events in response to a condition in another service. Structure is documented below. Cannot be used with `trigger_http`.
        """
        return pulumi.get(self, "event_trigger")

    @event_trigger.setter
    def event_trigger(self, value: Optional[pulumi.Input['FunctionEventTriggerArgs']]):
        pulumi.set(self, "event_trigger", value)

    @property
    @pulumi.getter(name="httpsTriggerUrl")
    def https_trigger_url(self) -> Optional[pulumi.Input[str]]:
        """
        URL which triggers function execution. Returned only if `trigger_http` is used.
        """
        return pulumi.get(self, "https_trigger_url")

    @https_trigger_url.setter
    def https_trigger_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "https_trigger_url", value)

    @property
    @pulumi.getter(name="ingressSettings")
    def ingress_settings(self) -> Optional[pulumi.Input[str]]:
        """
        String value that controls what traffic can reach the function. Allowed values are `ALLOW_ALL`, `ALLOW_INTERNAL_AND_GCLB` and `ALLOW_INTERNAL_ONLY`. Check [ingress documentation](https://cloud.google.com/functions/docs/networking/network-settings#ingress_settings) to see the impact of each settings value. Changes to this field will recreate the cloud function.
        """
        return pulumi.get(self, "ingress_settings")

    @ingress_settings.setter
    def ingress_settings(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ingress_settings", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A set of key/value label pairs to assign to the function. Label keys must follow the requirements at https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="maxInstances")
    def max_instances(self) -> Optional[pulumi.Input[int]]:
        """
        The limit on the maximum number of function instances that may coexist at a given time.
        """
        return pulumi.get(self, "max_instances")

    @max_instances.setter
    def max_instances(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_instances", value)

    @property
    @pulumi.getter(name="minInstances")
    def min_instances(self) -> Optional[pulumi.Input[int]]:
        """
        The limit on the minimum number of function instances that may coexist at a given time.
        """
        return pulumi.get(self, "min_instances")

    @min_instances.setter
    def min_instances(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_instances", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A user-defined name of the function. Function names must be unique globally.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        Project of the function. If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Region of function. If it is not provided, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> Optional[pulumi.Input[str]]:
        """
        If provided, the self-provided service account to run the function with.
        """
        return pulumi.get(self, "service_account_email")

    @service_account_email.setter
    def service_account_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account_email", value)

    @property
    @pulumi.getter(name="sourceArchiveBucket")
    def source_archive_bucket(self) -> Optional[pulumi.Input[str]]:
        """
        The GCS bucket containing the zip archive which contains the function.
        """
        return pulumi.get(self, "source_archive_bucket")

    @source_archive_bucket.setter
    def source_archive_bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_archive_bucket", value)

    @property
    @pulumi.getter(name="sourceArchiveObject")
    def source_archive_object(self) -> Optional[pulumi.Input[str]]:
        """
        The source archive object (file) in archive bucket.
        """
        return pulumi.get(self, "source_archive_object")

    @source_archive_object.setter
    def source_archive_object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_archive_object", value)

    @property
    @pulumi.getter(name="sourceRepository")
    def source_repository(self) -> Optional[pulumi.Input['FunctionSourceRepositoryArgs']]:
        """
        Represents parameters related to source repository where a function is hosted.
        Cannot be set alongside `source_archive_bucket` or `source_archive_object`. Structure is documented below.
        """
        return pulumi.get(self, "source_repository")

    @source_repository.setter
    def source_repository(self, value: Optional[pulumi.Input['FunctionSourceRepositoryArgs']]):
        pulumi.set(self, "source_repository", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Timeout (in seconds) for the function. Default value is 60 seconds. Cannot be more than 540 seconds.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="triggerHttp")
    def trigger_http(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean variable. Any HTTP request (of a supported type) to the endpoint will trigger function execution. Supported HTTP request types are: POST, PUT, GET, DELETE, and OPTIONS. Endpoint is returned as `https_trigger_url`. Cannot be used with `event_trigger`.
        """
        return pulumi.get(self, "trigger_http")

    @trigger_http.setter
    def trigger_http(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "trigger_http", value)

    @property
    @pulumi.getter(name="vpcConnector")
    def vpc_connector(self) -> Optional[pulumi.Input[str]]:
        """
        The VPC Network Connector that this cloud function can connect to. It should be set up as fully-qualified URI. The format of this field is `projects/*/locations/*/connectors/*`.
        """
        return pulumi.get(self, "vpc_connector")

    @vpc_connector.setter
    def vpc_connector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_connector", value)

    @property
    @pulumi.getter(name="vpcConnectorEgressSettings")
    def vpc_connector_egress_settings(self) -> Optional[pulumi.Input[str]]:
        """
        The egress settings for the connector, controlling what traffic is diverted through it. Allowed values are `ALL_TRAFFIC` and `PRIVATE_RANGES_ONLY`. Defaults to `PRIVATE_RANGES_ONLY`. If unset, this field preserves the previously set value.
        """
        return pulumi.get(self, "vpc_connector_egress_settings")

    @vpc_connector_egress_settings.setter
    def vpc_connector_egress_settings(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_connector_egress_settings", value)


@pulumi.input_type
class _FunctionState:
    def __init__(__self__, *,
                 available_memory_mb: Optional[pulumi.Input[int]] = None,
                 build_environment_variables: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 entry_point: Optional[pulumi.Input[str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 event_trigger: Optional[pulumi.Input['FunctionEventTriggerArgs']] = None,
                 https_trigger_url: Optional[pulumi.Input[str]] = None,
                 ingress_settings: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 max_instances: Optional[pulumi.Input[int]] = None,
                 min_instances: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 service_account_email: Optional[pulumi.Input[str]] = None,
                 source_archive_bucket: Optional[pulumi.Input[str]] = None,
                 source_archive_object: Optional[pulumi.Input[str]] = None,
                 source_repository: Optional[pulumi.Input['FunctionSourceRepositoryArgs']] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 trigger_http: Optional[pulumi.Input[bool]] = None,
                 vpc_connector: Optional[pulumi.Input[str]] = None,
                 vpc_connector_egress_settings: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Function resources.
        :param pulumi.Input[int] available_memory_mb: Memory (in MB), available to the function. Default value is `256`. Possible values include `128`, `256`, `512`, `1024`, etc.
        :param pulumi.Input[Mapping[str, Any]] build_environment_variables: A set of key/value environment variable pairs available during build time.
        :param pulumi.Input[str] description: Description of the function.
        :param pulumi.Input[str] entry_point: Name of the function that will be executed when the Google Cloud Function is triggered.
        :param pulumi.Input[Mapping[str, Any]] environment_variables: A set of key/value environment variable pairs to assign to the function.
        :param pulumi.Input['FunctionEventTriggerArgs'] event_trigger: A source that fires events in response to a condition in another service. Structure is documented below. Cannot be used with `trigger_http`.
        :param pulumi.Input[str] https_trigger_url: URL which triggers function execution. Returned only if `trigger_http` is used.
        :param pulumi.Input[str] ingress_settings: String value that controls what traffic can reach the function. Allowed values are `ALLOW_ALL`, `ALLOW_INTERNAL_AND_GCLB` and `ALLOW_INTERNAL_ONLY`. Check [ingress documentation](https://cloud.google.com/functions/docs/networking/network-settings#ingress_settings) to see the impact of each settings value. Changes to this field will recreate the cloud function.
        :param pulumi.Input[Mapping[str, Any]] labels: A set of key/value label pairs to assign to the function. Label keys must follow the requirements at https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements.
        :param pulumi.Input[int] max_instances: The limit on the maximum number of function instances that may coexist at a given time.
        :param pulumi.Input[int] min_instances: The limit on the minimum number of function instances that may coexist at a given time.
        :param pulumi.Input[str] name: A user-defined name of the function. Function names must be unique globally.
        :param pulumi.Input[str] project: Project of the function. If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: Region of function. If it is not provided, the provider region is used.
        :param pulumi.Input[str] runtime: The runtime in which the function is going to run.
               Eg. `"nodejs10"`, `"nodejs12"`, `"nodejs14"`, `"python37"`, `"python38"`, `"python39"`, `"dotnet3"`, `"go113"`, `"java11"`, `"ruby27"`, etc. Check the [official doc](https://cloud.google.com/functions/docs/concepts/exec#runtimes) for the up-to-date list.
        :param pulumi.Input[str] service_account_email: If provided, the self-provided service account to run the function with.
        :param pulumi.Input[str] source_archive_bucket: The GCS bucket containing the zip archive which contains the function.
        :param pulumi.Input[str] source_archive_object: The source archive object (file) in archive bucket.
        :param pulumi.Input['FunctionSourceRepositoryArgs'] source_repository: Represents parameters related to source repository where a function is hosted.
               Cannot be set alongside `source_archive_bucket` or `source_archive_object`. Structure is documented below.
        :param pulumi.Input[int] timeout: Timeout (in seconds) for the function. Default value is 60 seconds. Cannot be more than 540 seconds.
        :param pulumi.Input[bool] trigger_http: Boolean variable. Any HTTP request (of a supported type) to the endpoint will trigger function execution. Supported HTTP request types are: POST, PUT, GET, DELETE, and OPTIONS. Endpoint is returned as `https_trigger_url`. Cannot be used with `event_trigger`.
        :param pulumi.Input[str] vpc_connector: The VPC Network Connector that this cloud function can connect to. It should be set up as fully-qualified URI. The format of this field is `projects/*/locations/*/connectors/*`.
        :param pulumi.Input[str] vpc_connector_egress_settings: The egress settings for the connector, controlling what traffic is diverted through it. Allowed values are `ALL_TRAFFIC` and `PRIVATE_RANGES_ONLY`. Defaults to `PRIVATE_RANGES_ONLY`. If unset, this field preserves the previously set value.
        """
        if available_memory_mb is not None:
            pulumi.set(__self__, "available_memory_mb", available_memory_mb)
        if build_environment_variables is not None:
            pulumi.set(__self__, "build_environment_variables", build_environment_variables)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entry_point is not None:
            pulumi.set(__self__, "entry_point", entry_point)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if event_trigger is not None:
            pulumi.set(__self__, "event_trigger", event_trigger)
        if https_trigger_url is not None:
            pulumi.set(__self__, "https_trigger_url", https_trigger_url)
        if ingress_settings is not None:
            pulumi.set(__self__, "ingress_settings", ingress_settings)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_instances is not None:
            pulumi.set(__self__, "max_instances", max_instances)
        if min_instances is not None:
            pulumi.set(__self__, "min_instances", min_instances)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if service_account_email is not None:
            pulumi.set(__self__, "service_account_email", service_account_email)
        if source_archive_bucket is not None:
            pulumi.set(__self__, "source_archive_bucket", source_archive_bucket)
        if source_archive_object is not None:
            pulumi.set(__self__, "source_archive_object", source_archive_object)
        if source_repository is not None:
            pulumi.set(__self__, "source_repository", source_repository)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if trigger_http is not None:
            pulumi.set(__self__, "trigger_http", trigger_http)
        if vpc_connector is not None:
            pulumi.set(__self__, "vpc_connector", vpc_connector)
        if vpc_connector_egress_settings is not None:
            pulumi.set(__self__, "vpc_connector_egress_settings", vpc_connector_egress_settings)

    @property
    @pulumi.getter(name="availableMemoryMb")
    def available_memory_mb(self) -> Optional[pulumi.Input[int]]:
        """
        Memory (in MB), available to the function. Default value is `256`. Possible values include `128`, `256`, `512`, `1024`, etc.
        """
        return pulumi.get(self, "available_memory_mb")

    @available_memory_mb.setter
    def available_memory_mb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "available_memory_mb", value)

    @property
    @pulumi.getter(name="buildEnvironmentVariables")
    def build_environment_variables(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A set of key/value environment variable pairs available during build time.
        """
        return pulumi.get(self, "build_environment_variables")

    @build_environment_variables.setter
    def build_environment_variables(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "build_environment_variables", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the function.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="entryPoint")
    def entry_point(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the function that will be executed when the Google Cloud Function is triggered.
        """
        return pulumi.get(self, "entry_point")

    @entry_point.setter
    def entry_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entry_point", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A set of key/value environment variable pairs to assign to the function.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="eventTrigger")
    def event_trigger(self) -> Optional[pulumi.Input['FunctionEventTriggerArgs']]:
        """
        A source that fires events in response to a condition in another service. Structure is documented below. Cannot be used with `trigger_http`.
        """
        return pulumi.get(self, "event_trigger")

    @event_trigger.setter
    def event_trigger(self, value: Optional[pulumi.Input['FunctionEventTriggerArgs']]):
        pulumi.set(self, "event_trigger", value)

    @property
    @pulumi.getter(name="httpsTriggerUrl")
    def https_trigger_url(self) -> Optional[pulumi.Input[str]]:
        """
        URL which triggers function execution. Returned only if `trigger_http` is used.
        """
        return pulumi.get(self, "https_trigger_url")

    @https_trigger_url.setter
    def https_trigger_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "https_trigger_url", value)

    @property
    @pulumi.getter(name="ingressSettings")
    def ingress_settings(self) -> Optional[pulumi.Input[str]]:
        """
        String value that controls what traffic can reach the function. Allowed values are `ALLOW_ALL`, `ALLOW_INTERNAL_AND_GCLB` and `ALLOW_INTERNAL_ONLY`. Check [ingress documentation](https://cloud.google.com/functions/docs/networking/network-settings#ingress_settings) to see the impact of each settings value. Changes to this field will recreate the cloud function.
        """
        return pulumi.get(self, "ingress_settings")

    @ingress_settings.setter
    def ingress_settings(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ingress_settings", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A set of key/value label pairs to assign to the function. Label keys must follow the requirements at https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="maxInstances")
    def max_instances(self) -> Optional[pulumi.Input[int]]:
        """
        The limit on the maximum number of function instances that may coexist at a given time.
        """
        return pulumi.get(self, "max_instances")

    @max_instances.setter
    def max_instances(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_instances", value)

    @property
    @pulumi.getter(name="minInstances")
    def min_instances(self) -> Optional[pulumi.Input[int]]:
        """
        The limit on the minimum number of function instances that may coexist at a given time.
        """
        return pulumi.get(self, "min_instances")

    @min_instances.setter
    def min_instances(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_instances", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A user-defined name of the function. Function names must be unique globally.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        Project of the function. If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Region of function. If it is not provided, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input[str]]:
        """
        The runtime in which the function is going to run.
        Eg. `"nodejs10"`, `"nodejs12"`, `"nodejs14"`, `"python37"`, `"python38"`, `"python39"`, `"dotnet3"`, `"go113"`, `"java11"`, `"ruby27"`, etc. Check the [official doc](https://cloud.google.com/functions/docs/concepts/exec#runtimes) for the up-to-date list.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> Optional[pulumi.Input[str]]:
        """
        If provided, the self-provided service account to run the function with.
        """
        return pulumi.get(self, "service_account_email")

    @service_account_email.setter
    def service_account_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account_email", value)

    @property
    @pulumi.getter(name="sourceArchiveBucket")
    def source_archive_bucket(self) -> Optional[pulumi.Input[str]]:
        """
        The GCS bucket containing the zip archive which contains the function.
        """
        return pulumi.get(self, "source_archive_bucket")

    @source_archive_bucket.setter
    def source_archive_bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_archive_bucket", value)

    @property
    @pulumi.getter(name="sourceArchiveObject")
    def source_archive_object(self) -> Optional[pulumi.Input[str]]:
        """
        The source archive object (file) in archive bucket.
        """
        return pulumi.get(self, "source_archive_object")

    @source_archive_object.setter
    def source_archive_object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_archive_object", value)

    @property
    @pulumi.getter(name="sourceRepository")
    def source_repository(self) -> Optional[pulumi.Input['FunctionSourceRepositoryArgs']]:
        """
        Represents parameters related to source repository where a function is hosted.
        Cannot be set alongside `source_archive_bucket` or `source_archive_object`. Structure is documented below.
        """
        return pulumi.get(self, "source_repository")

    @source_repository.setter
    def source_repository(self, value: Optional[pulumi.Input['FunctionSourceRepositoryArgs']]):
        pulumi.set(self, "source_repository", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Timeout (in seconds) for the function. Default value is 60 seconds. Cannot be more than 540 seconds.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="triggerHttp")
    def trigger_http(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean variable. Any HTTP request (of a supported type) to the endpoint will trigger function execution. Supported HTTP request types are: POST, PUT, GET, DELETE, and OPTIONS. Endpoint is returned as `https_trigger_url`. Cannot be used with `event_trigger`.
        """
        return pulumi.get(self, "trigger_http")

    @trigger_http.setter
    def trigger_http(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "trigger_http", value)

    @property
    @pulumi.getter(name="vpcConnector")
    def vpc_connector(self) -> Optional[pulumi.Input[str]]:
        """
        The VPC Network Connector that this cloud function can connect to. It should be set up as fully-qualified URI. The format of this field is `projects/*/locations/*/connectors/*`.
        """
        return pulumi.get(self, "vpc_connector")

    @vpc_connector.setter
    def vpc_connector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_connector", value)

    @property
    @pulumi.getter(name="vpcConnectorEgressSettings")
    def vpc_connector_egress_settings(self) -> Optional[pulumi.Input[str]]:
        """
        The egress settings for the connector, controlling what traffic is diverted through it. Allowed values are `ALL_TRAFFIC` and `PRIVATE_RANGES_ONLY`. Defaults to `PRIVATE_RANGES_ONLY`. If unset, this field preserves the previously set value.
        """
        return pulumi.get(self, "vpc_connector_egress_settings")

    @vpc_connector_egress_settings.setter
    def vpc_connector_egress_settings(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_connector_egress_settings", value)


class Function(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 available_memory_mb: Optional[pulumi.Input[int]] = None,
                 build_environment_variables: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 entry_point: Optional[pulumi.Input[str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 event_trigger: Optional[pulumi.Input[pulumi.InputType['FunctionEventTriggerArgs']]] = None,
                 https_trigger_url: Optional[pulumi.Input[str]] = None,
                 ingress_settings: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 max_instances: Optional[pulumi.Input[int]] = None,
                 min_instances: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 service_account_email: Optional[pulumi.Input[str]] = None,
                 source_archive_bucket: Optional[pulumi.Input[str]] = None,
                 source_archive_object: Optional[pulumi.Input[str]] = None,
                 source_repository: Optional[pulumi.Input[pulumi.InputType['FunctionSourceRepositoryArgs']]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 trigger_http: Optional[pulumi.Input[bool]] = None,
                 vpc_connector: Optional[pulumi.Input[str]] = None,
                 vpc_connector_egress_settings: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates a new Cloud Function. For more information see:

        * [API documentation](https://cloud.google.com/functions/docs/reference/rest/v1/projects.locations.functions)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/functions/docs)

        > **Warning:** As of November 1, 2019, newly created Functions are
        private-by-default and will require [appropriate IAM permissions](https://cloud.google.com/functions/docs/reference/iam/roles)
        to be invoked. See below examples for how to set up the appropriate permissions,
        or view the [Cloud Functions IAM resources](https://www.terraform.io/docs/providers/google/r/cloudfunctions_cloud_function_iam.html)
        for Cloud Functions.

        ## Example Usage
        ### Public Function

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bucket = gcp.storage.Bucket("bucket", location="US")
        archive = gcp.storage.BucketObject("archive",
            bucket=bucket.name,
            source=pulumi.FileAsset("./path/to/zip/file/which/contains/code"))
        function = gcp.cloudfunctions.Function("function",
            description="My function",
            runtime="nodejs14",
            available_memory_mb=128,
            source_archive_bucket=bucket.name,
            source_archive_object=archive.name,
            trigger_http=True,
            entry_point="helloGET")
        # IAM entry for all users to invoke the function
        invoker = gcp.cloudfunctions.FunctionIamMember("invoker",
            project=function.project,
            region=function.region,
            cloud_function=function.name,
            role="roles/cloudfunctions.invoker",
            member="allUsers")
        ```
        ### Single User

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bucket = gcp.storage.Bucket("bucket", location="US")
        archive = gcp.storage.BucketObject("archive",
            bucket=bucket.name,
            source=pulumi.FileAsset("./path/to/zip/file/which/contains/code"))
        function = gcp.cloudfunctions.Function("function",
            description="My function",
            runtime="nodejs14",
            available_memory_mb=128,
            source_archive_bucket=bucket.name,
            source_archive_object=archive.name,
            trigger_http=True,
            timeout=60,
            entry_point="helloGET",
            labels={
                "my-label": "my-label-value",
            },
            environment_variables={
                "MY_ENV_VAR": "my-env-var-value",
            })
        # IAM entry for a single user to invoke the function
        invoker = gcp.cloudfunctions.FunctionIamMember("invoker",
            project=function.project,
            region=function.region,
            cloud_function=function.name,
            role="roles/cloudfunctions.invoker",
            member="user:myFunctionInvoker@example.com")
        ```

        ## Import

        Functions can be imported using the `name` or `{{project}}/{{region}}/name`, e.g.

        ```sh
         $ pulumi import gcp:cloudfunctions/function:Function default function-test
        ```

        ```sh
         $ pulumi import gcp:cloudfunctions/function:Function default {{project}}/{{region}}/function-test
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] available_memory_mb: Memory (in MB), available to the function. Default value is `256`. Possible values include `128`, `256`, `512`, `1024`, etc.
        :param pulumi.Input[Mapping[str, Any]] build_environment_variables: A set of key/value environment variable pairs available during build time.
        :param pulumi.Input[str] description: Description of the function.
        :param pulumi.Input[str] entry_point: Name of the function that will be executed when the Google Cloud Function is triggered.
        :param pulumi.Input[Mapping[str, Any]] environment_variables: A set of key/value environment variable pairs to assign to the function.
        :param pulumi.Input[pulumi.InputType['FunctionEventTriggerArgs']] event_trigger: A source that fires events in response to a condition in another service. Structure is documented below. Cannot be used with `trigger_http`.
        :param pulumi.Input[str] https_trigger_url: URL which triggers function execution. Returned only if `trigger_http` is used.
        :param pulumi.Input[str] ingress_settings: String value that controls what traffic can reach the function. Allowed values are `ALLOW_ALL`, `ALLOW_INTERNAL_AND_GCLB` and `ALLOW_INTERNAL_ONLY`. Check [ingress documentation](https://cloud.google.com/functions/docs/networking/network-settings#ingress_settings) to see the impact of each settings value. Changes to this field will recreate the cloud function.
        :param pulumi.Input[Mapping[str, Any]] labels: A set of key/value label pairs to assign to the function. Label keys must follow the requirements at https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements.
        :param pulumi.Input[int] max_instances: The limit on the maximum number of function instances that may coexist at a given time.
        :param pulumi.Input[int] min_instances: The limit on the minimum number of function instances that may coexist at a given time.
        :param pulumi.Input[str] name: A user-defined name of the function. Function names must be unique globally.
        :param pulumi.Input[str] project: Project of the function. If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: Region of function. If it is not provided, the provider region is used.
        :param pulumi.Input[str] runtime: The runtime in which the function is going to run.
               Eg. `"nodejs10"`, `"nodejs12"`, `"nodejs14"`, `"python37"`, `"python38"`, `"python39"`, `"dotnet3"`, `"go113"`, `"java11"`, `"ruby27"`, etc. Check the [official doc](https://cloud.google.com/functions/docs/concepts/exec#runtimes) for the up-to-date list.
        :param pulumi.Input[str] service_account_email: If provided, the self-provided service account to run the function with.
        :param pulumi.Input[str] source_archive_bucket: The GCS bucket containing the zip archive which contains the function.
        :param pulumi.Input[str] source_archive_object: The source archive object (file) in archive bucket.
        :param pulumi.Input[pulumi.InputType['FunctionSourceRepositoryArgs']] source_repository: Represents parameters related to source repository where a function is hosted.
               Cannot be set alongside `source_archive_bucket` or `source_archive_object`. Structure is documented below.
        :param pulumi.Input[int] timeout: Timeout (in seconds) for the function. Default value is 60 seconds. Cannot be more than 540 seconds.
        :param pulumi.Input[bool] trigger_http: Boolean variable. Any HTTP request (of a supported type) to the endpoint will trigger function execution. Supported HTTP request types are: POST, PUT, GET, DELETE, and OPTIONS. Endpoint is returned as `https_trigger_url`. Cannot be used with `event_trigger`.
        :param pulumi.Input[str] vpc_connector: The VPC Network Connector that this cloud function can connect to. It should be set up as fully-qualified URI. The format of this field is `projects/*/locations/*/connectors/*`.
        :param pulumi.Input[str] vpc_connector_egress_settings: The egress settings for the connector, controlling what traffic is diverted through it. Allowed values are `ALL_TRAFFIC` and `PRIVATE_RANGES_ONLY`. Defaults to `PRIVATE_RANGES_ONLY`. If unset, this field preserves the previously set value.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FunctionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new Cloud Function. For more information see:

        * [API documentation](https://cloud.google.com/functions/docs/reference/rest/v1/projects.locations.functions)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/functions/docs)

        > **Warning:** As of November 1, 2019, newly created Functions are
        private-by-default and will require [appropriate IAM permissions](https://cloud.google.com/functions/docs/reference/iam/roles)
        to be invoked. See below examples for how to set up the appropriate permissions,
        or view the [Cloud Functions IAM resources](https://www.terraform.io/docs/providers/google/r/cloudfunctions_cloud_function_iam.html)
        for Cloud Functions.

        ## Example Usage
        ### Public Function

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bucket = gcp.storage.Bucket("bucket", location="US")
        archive = gcp.storage.BucketObject("archive",
            bucket=bucket.name,
            source=pulumi.FileAsset("./path/to/zip/file/which/contains/code"))
        function = gcp.cloudfunctions.Function("function",
            description="My function",
            runtime="nodejs14",
            available_memory_mb=128,
            source_archive_bucket=bucket.name,
            source_archive_object=archive.name,
            trigger_http=True,
            entry_point="helloGET")
        # IAM entry for all users to invoke the function
        invoker = gcp.cloudfunctions.FunctionIamMember("invoker",
            project=function.project,
            region=function.region,
            cloud_function=function.name,
            role="roles/cloudfunctions.invoker",
            member="allUsers")
        ```
        ### Single User

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bucket = gcp.storage.Bucket("bucket", location="US")
        archive = gcp.storage.BucketObject("archive",
            bucket=bucket.name,
            source=pulumi.FileAsset("./path/to/zip/file/which/contains/code"))
        function = gcp.cloudfunctions.Function("function",
            description="My function",
            runtime="nodejs14",
            available_memory_mb=128,
            source_archive_bucket=bucket.name,
            source_archive_object=archive.name,
            trigger_http=True,
            timeout=60,
            entry_point="helloGET",
            labels={
                "my-label": "my-label-value",
            },
            environment_variables={
                "MY_ENV_VAR": "my-env-var-value",
            })
        # IAM entry for a single user to invoke the function
        invoker = gcp.cloudfunctions.FunctionIamMember("invoker",
            project=function.project,
            region=function.region,
            cloud_function=function.name,
            role="roles/cloudfunctions.invoker",
            member="user:myFunctionInvoker@example.com")
        ```

        ## Import

        Functions can be imported using the `name` or `{{project}}/{{region}}/name`, e.g.

        ```sh
         $ pulumi import gcp:cloudfunctions/function:Function default function-test
        ```

        ```sh
         $ pulumi import gcp:cloudfunctions/function:Function default {{project}}/{{region}}/function-test
        ```

        :param str resource_name: The name of the resource.
        :param FunctionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FunctionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 available_memory_mb: Optional[pulumi.Input[int]] = None,
                 build_environment_variables: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 entry_point: Optional[pulumi.Input[str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 event_trigger: Optional[pulumi.Input[pulumi.InputType['FunctionEventTriggerArgs']]] = None,
                 https_trigger_url: Optional[pulumi.Input[str]] = None,
                 ingress_settings: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 max_instances: Optional[pulumi.Input[int]] = None,
                 min_instances: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 service_account_email: Optional[pulumi.Input[str]] = None,
                 source_archive_bucket: Optional[pulumi.Input[str]] = None,
                 source_archive_object: Optional[pulumi.Input[str]] = None,
                 source_repository: Optional[pulumi.Input[pulumi.InputType['FunctionSourceRepositoryArgs']]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 trigger_http: Optional[pulumi.Input[bool]] = None,
                 vpc_connector: Optional[pulumi.Input[str]] = None,
                 vpc_connector_egress_settings: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FunctionArgs.__new__(FunctionArgs)

            __props__.__dict__["available_memory_mb"] = available_memory_mb
            __props__.__dict__["build_environment_variables"] = build_environment_variables
            __props__.__dict__["description"] = description
            __props__.__dict__["entry_point"] = entry_point
            __props__.__dict__["environment_variables"] = environment_variables
            __props__.__dict__["event_trigger"] = event_trigger
            __props__.__dict__["https_trigger_url"] = https_trigger_url
            __props__.__dict__["ingress_settings"] = ingress_settings
            __props__.__dict__["labels"] = labels
            __props__.__dict__["max_instances"] = max_instances
            __props__.__dict__["min_instances"] = min_instances
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["region"] = region
            if runtime is None and not opts.urn:
                raise TypeError("Missing required property 'runtime'")
            __props__.__dict__["runtime"] = runtime
            __props__.__dict__["service_account_email"] = service_account_email
            __props__.__dict__["source_archive_bucket"] = source_archive_bucket
            __props__.__dict__["source_archive_object"] = source_archive_object
            __props__.__dict__["source_repository"] = source_repository
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["trigger_http"] = trigger_http
            __props__.__dict__["vpc_connector"] = vpc_connector
            __props__.__dict__["vpc_connector_egress_settings"] = vpc_connector_egress_settings
        super(Function, __self__).__init__(
            'gcp:cloudfunctions/function:Function',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            available_memory_mb: Optional[pulumi.Input[int]] = None,
            build_environment_variables: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            entry_point: Optional[pulumi.Input[str]] = None,
            environment_variables: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            event_trigger: Optional[pulumi.Input[pulumi.InputType['FunctionEventTriggerArgs']]] = None,
            https_trigger_url: Optional[pulumi.Input[str]] = None,
            ingress_settings: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            max_instances: Optional[pulumi.Input[int]] = None,
            min_instances: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            runtime: Optional[pulumi.Input[str]] = None,
            service_account_email: Optional[pulumi.Input[str]] = None,
            source_archive_bucket: Optional[pulumi.Input[str]] = None,
            source_archive_object: Optional[pulumi.Input[str]] = None,
            source_repository: Optional[pulumi.Input[pulumi.InputType['FunctionSourceRepositoryArgs']]] = None,
            timeout: Optional[pulumi.Input[int]] = None,
            trigger_http: Optional[pulumi.Input[bool]] = None,
            vpc_connector: Optional[pulumi.Input[str]] = None,
            vpc_connector_egress_settings: Optional[pulumi.Input[str]] = None) -> 'Function':
        """
        Get an existing Function resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] available_memory_mb: Memory (in MB), available to the function. Default value is `256`. Possible values include `128`, `256`, `512`, `1024`, etc.
        :param pulumi.Input[Mapping[str, Any]] build_environment_variables: A set of key/value environment variable pairs available during build time.
        :param pulumi.Input[str] description: Description of the function.
        :param pulumi.Input[str] entry_point: Name of the function that will be executed when the Google Cloud Function is triggered.
        :param pulumi.Input[Mapping[str, Any]] environment_variables: A set of key/value environment variable pairs to assign to the function.
        :param pulumi.Input[pulumi.InputType['FunctionEventTriggerArgs']] event_trigger: A source that fires events in response to a condition in another service. Structure is documented below. Cannot be used with `trigger_http`.
        :param pulumi.Input[str] https_trigger_url: URL which triggers function execution. Returned only if `trigger_http` is used.
        :param pulumi.Input[str] ingress_settings: String value that controls what traffic can reach the function. Allowed values are `ALLOW_ALL`, `ALLOW_INTERNAL_AND_GCLB` and `ALLOW_INTERNAL_ONLY`. Check [ingress documentation](https://cloud.google.com/functions/docs/networking/network-settings#ingress_settings) to see the impact of each settings value. Changes to this field will recreate the cloud function.
        :param pulumi.Input[Mapping[str, Any]] labels: A set of key/value label pairs to assign to the function. Label keys must follow the requirements at https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements.
        :param pulumi.Input[int] max_instances: The limit on the maximum number of function instances that may coexist at a given time.
        :param pulumi.Input[int] min_instances: The limit on the minimum number of function instances that may coexist at a given time.
        :param pulumi.Input[str] name: A user-defined name of the function. Function names must be unique globally.
        :param pulumi.Input[str] project: Project of the function. If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: Region of function. If it is not provided, the provider region is used.
        :param pulumi.Input[str] runtime: The runtime in which the function is going to run.
               Eg. `"nodejs10"`, `"nodejs12"`, `"nodejs14"`, `"python37"`, `"python38"`, `"python39"`, `"dotnet3"`, `"go113"`, `"java11"`, `"ruby27"`, etc. Check the [official doc](https://cloud.google.com/functions/docs/concepts/exec#runtimes) for the up-to-date list.
        :param pulumi.Input[str] service_account_email: If provided, the self-provided service account to run the function with.
        :param pulumi.Input[str] source_archive_bucket: The GCS bucket containing the zip archive which contains the function.
        :param pulumi.Input[str] source_archive_object: The source archive object (file) in archive bucket.
        :param pulumi.Input[pulumi.InputType['FunctionSourceRepositoryArgs']] source_repository: Represents parameters related to source repository where a function is hosted.
               Cannot be set alongside `source_archive_bucket` or `source_archive_object`. Structure is documented below.
        :param pulumi.Input[int] timeout: Timeout (in seconds) for the function. Default value is 60 seconds. Cannot be more than 540 seconds.
        :param pulumi.Input[bool] trigger_http: Boolean variable. Any HTTP request (of a supported type) to the endpoint will trigger function execution. Supported HTTP request types are: POST, PUT, GET, DELETE, and OPTIONS. Endpoint is returned as `https_trigger_url`. Cannot be used with `event_trigger`.
        :param pulumi.Input[str] vpc_connector: The VPC Network Connector that this cloud function can connect to. It should be set up as fully-qualified URI. The format of this field is `projects/*/locations/*/connectors/*`.
        :param pulumi.Input[str] vpc_connector_egress_settings: The egress settings for the connector, controlling what traffic is diverted through it. Allowed values are `ALL_TRAFFIC` and `PRIVATE_RANGES_ONLY`. Defaults to `PRIVATE_RANGES_ONLY`. If unset, this field preserves the previously set value.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FunctionState.__new__(_FunctionState)

        __props__.__dict__["available_memory_mb"] = available_memory_mb
        __props__.__dict__["build_environment_variables"] = build_environment_variables
        __props__.__dict__["description"] = description
        __props__.__dict__["entry_point"] = entry_point
        __props__.__dict__["environment_variables"] = environment_variables
        __props__.__dict__["event_trigger"] = event_trigger
        __props__.__dict__["https_trigger_url"] = https_trigger_url
        __props__.__dict__["ingress_settings"] = ingress_settings
        __props__.__dict__["labels"] = labels
        __props__.__dict__["max_instances"] = max_instances
        __props__.__dict__["min_instances"] = min_instances
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["region"] = region
        __props__.__dict__["runtime"] = runtime
        __props__.__dict__["service_account_email"] = service_account_email
        __props__.__dict__["source_archive_bucket"] = source_archive_bucket
        __props__.__dict__["source_archive_object"] = source_archive_object
        __props__.__dict__["source_repository"] = source_repository
        __props__.__dict__["timeout"] = timeout
        __props__.__dict__["trigger_http"] = trigger_http
        __props__.__dict__["vpc_connector"] = vpc_connector
        __props__.__dict__["vpc_connector_egress_settings"] = vpc_connector_egress_settings
        return Function(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="availableMemoryMb")
    def available_memory_mb(self) -> pulumi.Output[Optional[int]]:
        """
        Memory (in MB), available to the function. Default value is `256`. Possible values include `128`, `256`, `512`, `1024`, etc.
        """
        return pulumi.get(self, "available_memory_mb")

    @property
    @pulumi.getter(name="buildEnvironmentVariables")
    def build_environment_variables(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        A set of key/value environment variable pairs available during build time.
        """
        return pulumi.get(self, "build_environment_variables")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the function.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="entryPoint")
    def entry_point(self) -> pulumi.Output[Optional[str]]:
        """
        Name of the function that will be executed when the Google Cloud Function is triggered.
        """
        return pulumi.get(self, "entry_point")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        A set of key/value environment variable pairs to assign to the function.
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter(name="eventTrigger")
    def event_trigger(self) -> pulumi.Output['outputs.FunctionEventTrigger']:
        """
        A source that fires events in response to a condition in another service. Structure is documented below. Cannot be used with `trigger_http`.
        """
        return pulumi.get(self, "event_trigger")

    @property
    @pulumi.getter(name="httpsTriggerUrl")
    def https_trigger_url(self) -> pulumi.Output[str]:
        """
        URL which triggers function execution. Returned only if `trigger_http` is used.
        """
        return pulumi.get(self, "https_trigger_url")

    @property
    @pulumi.getter(name="ingressSettings")
    def ingress_settings(self) -> pulumi.Output[Optional[str]]:
        """
        String value that controls what traffic can reach the function. Allowed values are `ALLOW_ALL`, `ALLOW_INTERNAL_AND_GCLB` and `ALLOW_INTERNAL_ONLY`. Check [ingress documentation](https://cloud.google.com/functions/docs/networking/network-settings#ingress_settings) to see the impact of each settings value. Changes to this field will recreate the cloud function.
        """
        return pulumi.get(self, "ingress_settings")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        A set of key/value label pairs to assign to the function. Label keys must follow the requirements at https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="maxInstances")
    def max_instances(self) -> pulumi.Output[Optional[int]]:
        """
        The limit on the maximum number of function instances that may coexist at a given time.
        """
        return pulumi.get(self, "max_instances")

    @property
    @pulumi.getter(name="minInstances")
    def min_instances(self) -> pulumi.Output[Optional[int]]:
        """
        The limit on the minimum number of function instances that may coexist at a given time.
        """
        return pulumi.get(self, "min_instances")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A user-defined name of the function. Function names must be unique globally.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        Project of the function. If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Region of function. If it is not provided, the provider region is used.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def runtime(self) -> pulumi.Output[str]:
        """
        The runtime in which the function is going to run.
        Eg. `"nodejs10"`, `"nodejs12"`, `"nodejs14"`, `"python37"`, `"python38"`, `"python39"`, `"dotnet3"`, `"go113"`, `"java11"`, `"ruby27"`, etc. Check the [official doc](https://cloud.google.com/functions/docs/concepts/exec#runtimes) for the up-to-date list.
        """
        return pulumi.get(self, "runtime")

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> pulumi.Output[str]:
        """
        If provided, the self-provided service account to run the function with.
        """
        return pulumi.get(self, "service_account_email")

    @property
    @pulumi.getter(name="sourceArchiveBucket")
    def source_archive_bucket(self) -> pulumi.Output[Optional[str]]:
        """
        The GCS bucket containing the zip archive which contains the function.
        """
        return pulumi.get(self, "source_archive_bucket")

    @property
    @pulumi.getter(name="sourceArchiveObject")
    def source_archive_object(self) -> pulumi.Output[Optional[str]]:
        """
        The source archive object (file) in archive bucket.
        """
        return pulumi.get(self, "source_archive_object")

    @property
    @pulumi.getter(name="sourceRepository")
    def source_repository(self) -> pulumi.Output[Optional['outputs.FunctionSourceRepository']]:
        """
        Represents parameters related to source repository where a function is hosted.
        Cannot be set alongside `source_archive_bucket` or `source_archive_object`. Structure is documented below.
        """
        return pulumi.get(self, "source_repository")

    @property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[Optional[int]]:
        """
        Timeout (in seconds) for the function. Default value is 60 seconds. Cannot be more than 540 seconds.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="triggerHttp")
    def trigger_http(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean variable. Any HTTP request (of a supported type) to the endpoint will trigger function execution. Supported HTTP request types are: POST, PUT, GET, DELETE, and OPTIONS. Endpoint is returned as `https_trigger_url`. Cannot be used with `event_trigger`.
        """
        return pulumi.get(self, "trigger_http")

    @property
    @pulumi.getter(name="vpcConnector")
    def vpc_connector(self) -> pulumi.Output[Optional[str]]:
        """
        The VPC Network Connector that this cloud function can connect to. It should be set up as fully-qualified URI. The format of this field is `projects/*/locations/*/connectors/*`.
        """
        return pulumi.get(self, "vpc_connector")

    @property
    @pulumi.getter(name="vpcConnectorEgressSettings")
    def vpc_connector_egress_settings(self) -> pulumi.Output[str]:
        """
        The egress settings for the connector, controlling what traffic is diverted through it. Allowed values are `ALL_TRAFFIC` and `PRIVATE_RANGES_ONLY`. Defaults to `PRIVATE_RANGES_ONLY`. If unset, this field preserves the previously set value.
        """
        return pulumi.get(self, "vpc_connector_egress_settings")

