"use strict";
var _a, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClientAttributes = exports.DateTimeAttribute = exports.BooleanAttribute = exports.NumberAttribute = exports.StringAttribute = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const attr_names_1 = require("./private/attr-names");
/**
 * The String custom attribute type.
 *
 * @stability stable
 */
class StringAttribute {
    /**
     * @stability stable
     */
    constructor(props = {}) {
        if (props.minLen && !core_1.Token.isUnresolved(props.minLen) && props.minLen < 0) {
            throw new Error(`minLen cannot be less than 0 (value: ${props.minLen}).`);
        }
        if (props.maxLen && !core_1.Token.isUnresolved(props.maxLen) && props.maxLen > 2048) {
            throw new Error(`maxLen cannot be greater than 2048 (value: ${props.maxLen}).`);
        }
        this.minLen = props === null || props === void 0 ? void 0 : props.minLen;
        this.maxLen = props === null || props === void 0 ? void 0 : props.maxLen;
        this.mutable = props === null || props === void 0 ? void 0 : props.mutable;
    }
    /**
     * Bind this custom attribute type to the values as expected by CloudFormation.
     *
     * @stability stable
     */
    bind() {
        let stringConstraints;
        if (this.minLen || this.maxLen) {
            stringConstraints = {
                minLen: this.minLen,
                maxLen: this.maxLen,
            };
        }
        return {
            dataType: 'String',
            stringConstraints,
            mutable: this.mutable,
        };
    }
}
exports.StringAttribute = StringAttribute;
_a = JSII_RTTI_SYMBOL_1;
StringAttribute[_a] = { fqn: "@aws-cdk/aws-cognito.StringAttribute", version: "1.101.0" };
/**
 * The Number custom attribute type.
 *
 * @stability stable
 */
class NumberAttribute {
    /**
     * @stability stable
     */
    constructor(props = {}) {
        this.min = props === null || props === void 0 ? void 0 : props.min;
        this.max = props === null || props === void 0 ? void 0 : props.max;
        this.mutable = props === null || props === void 0 ? void 0 : props.mutable;
    }
    /**
     * Bind this custom attribute type to the values as expected by CloudFormation.
     *
     * @stability stable
     */
    bind() {
        let numberConstraints;
        if (this.min || this.max) {
            numberConstraints = {
                min: this.min,
                max: this.max,
            };
        }
        return {
            dataType: 'Number',
            numberConstraints,
            mutable: this.mutable,
        };
    }
}
exports.NumberAttribute = NumberAttribute;
_b = JSII_RTTI_SYMBOL_1;
NumberAttribute[_b] = { fqn: "@aws-cdk/aws-cognito.NumberAttribute", version: "1.101.0" };
/**
 * The Boolean custom attribute type.
 *
 * @stability stable
 */
class BooleanAttribute {
    /**
     * @stability stable
     */
    constructor(props = {}) {
        this.mutable = props === null || props === void 0 ? void 0 : props.mutable;
    }
    /**
     * Bind this custom attribute type to the values as expected by CloudFormation.
     *
     * @stability stable
     */
    bind() {
        return {
            dataType: 'Boolean',
            mutable: this.mutable,
        };
    }
}
exports.BooleanAttribute = BooleanAttribute;
_c = JSII_RTTI_SYMBOL_1;
BooleanAttribute[_c] = { fqn: "@aws-cdk/aws-cognito.BooleanAttribute", version: "1.101.0" };
/**
 * The DateTime custom attribute type.
 *
 * @stability stable
 */
class DateTimeAttribute {
    /**
     * @stability stable
     */
    constructor(props = {}) {
        this.mutable = props === null || props === void 0 ? void 0 : props.mutable;
    }
    /**
     * Bind this custom attribute type to the values as expected by CloudFormation.
     *
     * @stability stable
     */
    bind() {
        return {
            dataType: 'DateTime',
            mutable: this.mutable,
        };
    }
}
exports.DateTimeAttribute = DateTimeAttribute;
_d = JSII_RTTI_SYMBOL_1;
DateTimeAttribute[_d] = { fqn: "@aws-cdk/aws-cognito.DateTimeAttribute", version: "1.101.0" };
/**
 * A set of attributes, useful to set Read and Write attributes.
 *
 * @stability stable
 */
class ClientAttributes {
    /**
     * Creates a ClientAttributes with the specified attributes.
     *
     * @default - a ClientAttributes object without any attributes
     * @stability stable
     */
    constructor() {
        this.attributesSet = new Set();
    }
    /**
     * Creates a custom ClientAttributes with the specified attributes.
     *
     * @param attributes a list of standard attributes to add to the set.
     * @stability stable
     */
    withStandardAttributes(attributes) {
        let attributesSet = new Set(this.attributesSet);
        // iterate through key-values in the `StandardAttributeNames` constant
        // to get the value for all attributes
        for (const attributeKey in attr_names_1.StandardAttributeNames) {
            if (attributes[attributeKey] === true) {
                const attributeName = attr_names_1.StandardAttributeNames[attributeKey];
                attributesSet.add(attributeName);
            }
        }
        let aux = new ClientAttributes();
        aux.attributesSet = attributesSet;
        return aux;
    }
    /**
     * Creates a custom ClientAttributes with the specified attributes.
     *
     * @param attributes a list of custom attributes to add to the set.
     * @stability stable
     */
    withCustomAttributes(...attributes) {
        let attributesSet = new Set(this.attributesSet);
        for (let attribute of attributes) {
            // custom attributes MUST begin with `custom:`, so add the string if not present
            if (!attribute.startsWith('custom:')) {
                attribute = 'custom:' + attribute;
            }
            attributesSet.add(attribute);
        }
        let aux = new ClientAttributes();
        aux.attributesSet = attributesSet;
        return aux;
    }
    /**
     * The list of attributes represented by this ClientAttributes.
     *
     * @stability stable
     */
    attributes() {
        // sorting is unnecessary but it simplify testing
        return Array.from(this.attributesSet).sort();
    }
}
exports.ClientAttributes = ClientAttributes;
_e = JSII_RTTI_SYMBOL_1;
ClientAttributes[_e] = { fqn: "@aws-cdk/aws-cognito.ClientAttributes", version: "1.101.0" };
//# sourceMappingURL=data:application/json;base64,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