# Democritus Converters

[![PyPI](https://img.shields.io/pypi/v/d8s-converters.svg)](https://pypi.python.org/pypi/d8s-converters)
[![CI](https://github.com/democritus-project/d8s-converters/workflows/CI/badge.svg)](https://github.com/democritus-project/d8s-converters/actions)
[![Lint](https://github.com/democritus-project/d8s-converters/workflows/Lint/badge.svg)](https://github.com/democritus-project/d8s-converters/actions)
[![codecov](https://codecov.io/gh/democritus-project/d8s-converters/branch/main/graph/badge.svg?token=V0WOIXRGMM)](https://codecov.io/gh/democritus-project/d8s-converters)
[![The Democritus Project uses semver version 2.0.0](https://img.shields.io/badge/-semver%20v2.0.0-22bfda)](https://semver.org/spec/v2.0.0.html)
[![The Democritus Project uses black to format code](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)
[![License: LGPL v3](https://img.shields.io/badge/License-LGPL%20v3-blue.svg)](https://choosealicense.com/licenses/lgpl-3.0/)

Democritus functions<sup>[1]</sup> for easily converting dates, times, temperatures, and distances.

[1] Democritus functions are <i>simple, effective, modular, well-tested, and well-documented</i> Python functions.

We use `d8s` as an abbreviation for `democritus` (you can read more about this [here](https://github.com/democritus-project/roadmap#what-is-d8s)).

## Functions

  - ```python
    def convert(quantity: Union[int, float], starting_unit: str, converted_unit: str):
        """Convert the quantity from the starting_unit to the converted_unit."""
    ```
  - ```python
    def seconds_to_minutes(seconds):
        """."""
    ```
  - ```python
    def seconds_to_hours(seconds):
        """."""
    ```
  - ```python
    def seconds_to_days(seconds):
        """."""
    ```
  - ```python
    def seconds_to_weeks(seconds):
        """."""
    ```
  - ```python
    def seconds_to_fortnights(seconds):
        """."""
    ```
  - ```python
    def seconds_to_years(seconds):
        """."""
    ```
  - ```python
    def seconds_to_months(seconds):
        """."""
    ```
  - ```python
    def seconds_to_centuries(seconds):
        """."""
    ```
  - ```python
    def seconds_to_millenniums(seconds):
        """."""
    ```
  - ```python
    def minutes_to_seconds(minutes):
        """."""
    ```
  - ```python
    def minutes_to_hours(minutes):
        """."""
    ```
  - ```python
    def minutes_to_days(minutes):
        """."""
    ```
  - ```python
    def minutes_to_weeks(minutes):
        """."""
    ```
  - ```python
    def minutes_to_fortnights(minutes):
        """."""
    ```
  - ```python
    def minutes_to_years(minutes):
        """."""
    ```
  - ```python
    def minutes_to_months(minutes):
        """."""
    ```
  - ```python
    def minutes_to_centuries(minutes):
        """."""
    ```
  - ```python
    def minutes_to_millenniums(minutes):
        """."""
    ```
  - ```python
    def hours_to_seconds(hours):
        """."""
    ```
  - ```python
    def hours_to_minutes(hours):
        """."""
    ```
  - ```python
    def hours_to_days(hours):
        """."""
    ```
  - ```python
    def hours_to_weeks(hours):
        """."""
    ```
  - ```python
    def hours_to_fortnights(hours):
        """."""
    ```
  - ```python
    def hours_to_years(hours):
        """."""
    ```
  - ```python
    def hours_to_months(hours):
        """."""
    ```
  - ```python
    def hours_to_centuries(hours):
        """."""
    ```
  - ```python
    def hours_to_millenniums(hours):
        """."""
    ```
  - ```python
    def days_to_seconds(days):
        """."""
    ```
  - ```python
    def days_to_minutes(days):
        """."""
    ```
  - ```python
    def days_to_hours(days):
        """."""
    ```
  - ```python
    def days_to_weeks(days):
        """."""
    ```
  - ```python
    def days_to_fortnights(days):
        """."""
    ```
  - ```python
    def days_to_years(days):
        """."""
    ```
  - ```python
    def days_to_months(days):
        """."""
    ```
  - ```python
    def days_to_centuries(days):
        """."""
    ```
  - ```python
    def days_to_millenniums(days):
        """."""
    ```
  - ```python
    def weeks_to_seconds(weeks):
        """."""
    ```
  - ```python
    def weeks_to_minutes(weeks):
        """."""
    ```
  - ```python
    def weeks_to_hours(weeks):
        """."""
    ```
  - ```python
    def weeks_to_days(weeks):
        """."""
    ```
  - ```python
    def weeks_to_fortnights(weeks):
        """."""
    ```
  - ```python
    def weeks_to_years(weeks):
        """."""
    ```
  - ```python
    def weeks_to_months(weeks):
        """."""
    ```
  - ```python
    def weeks_to_centuries(weeks):
        """."""
    ```
  - ```python
    def weeks_to_millenniums(weeks):
        """."""
    ```
  - ```python
    def fortnights_to_seconds(fortnights):
        """."""
    ```
  - ```python
    def fortnights_to_minutes(fortnights):
        """."""
    ```
  - ```python
    def fortnights_to_hours(fortnights):
        """."""
    ```
  - ```python
    def fortnights_to_days(fortnights):
        """."""
    ```
  - ```python
    def fortnights_to_weeks(fortnights):
        """."""
    ```
  - ```python
    def fortnights_to_years(fortnights):
        """."""
    ```
  - ```python
    def fortnights_to_months(fortnights):
        """."""
    ```
  - ```python
    def fortnights_to_centuries(fortnights):
        """."""
    ```
  - ```python
    def fortnights_to_millenniums(fortnights):
        """."""
    ```
  - ```python
    def years_to_seconds(years):
        """."""
    ```
  - ```python
    def years_to_minutes(years):
        """."""
    ```
  - ```python
    def years_to_hours(years):
        """."""
    ```
  - ```python
    def years_to_days(years):
        """."""
    ```
  - ```python
    def years_to_weeks(years):
        """."""
    ```
  - ```python
    def years_to_fortnights(years):
        """."""
    ```
  - ```python
    def years_to_months(years):
        """."""
    ```
  - ```python
    def years_to_centuries(years):
        """."""
    ```
  - ```python
    def years_to_millenniums(years):
        """."""
    ```
  - ```python
    def months_to_seconds(months):
        """."""
    ```
  - ```python
    def months_to_minutes(months):
        """."""
    ```
  - ```python
    def months_to_hours(months):
        """."""
    ```
  - ```python
    def months_to_days(months):
        """."""
    ```
  - ```python
    def months_to_weeks(months):
        """."""
    ```
  - ```python
    def months_to_fortnights(months):
        """."""
    ```
  - ```python
    def months_to_years(months):
        """."""
    ```
  - ```python
    def months_to_centuries(months):
        """."""
    ```
  - ```python
    def months_to_millenniums(months):
        """."""
    ```
  - ```python
    def centuries_to_seconds(centuries):
        """."""
    ```
  - ```python
    def centuries_to_minutes(centuries):
        """."""
    ```
  - ```python
    def centuries_to_hours(centuries):
        """."""
    ```
  - ```python
    def centuries_to_days(centuries):
        """."""
    ```
  - ```python
    def centuries_to_weeks(centuries):
        """."""
    ```
  - ```python
    def centuries_to_fortnights(centuries):
        """."""
    ```
  - ```python
    def centuries_to_years(centuries):
        """."""
    ```
  - ```python
    def centuries_to_months(centuries):
        """."""
    ```
  - ```python
    def centuries_to_millenniums(centuries):
        """."""
    ```
  - ```python
    def millenniums_to_seconds(millenniums):
        """."""
    ```
  - ```python
    def millenniums_to_minutes(millenniums):
        """."""
    ```
  - ```python
    def millenniums_to_hours(millenniums):
        """."""
    ```
  - ```python
    def millenniums_to_days(millenniums):
        """."""
    ```
  - ```python
    def millenniums_to_weeks(millenniums):
        """."""
    ```
  - ```python
    def millenniums_to_fortnights(millenniums):
        """."""
    ```
  - ```python
    def millenniums_to_years(millenniums):
        """."""
    ```
  - ```python
    def millenniums_to_months(millenniums):
        """."""
    ```
  - ```python
    def millenniums_to_centuries(millenniums):
        """."""
    ```
  - ```python
    def meters_to_centimeters(meters):
        """."""
    ```
  - ```python
    def meters_to_millimeters(meters):
        """."""
    ```
  - ```python
    def meters_to_kilometers(meters):
        """."""
    ```
  - ```python
    def meters_to_inches(meters):
        """."""
    ```
  - ```python
    def meters_to_hands(meters):
        """."""
    ```
  - ```python
    def meters_to_feet(meters):
        """."""
    ```
  - ```python
    def meters_to_yards(meters):
        """."""
    ```
  - ```python
    def meters_to_miles(meters):
        """."""
    ```
  - ```python
    def meters_to_light_years(meters):
        """."""
    ```
  - ```python
    def meters_to_astronomical_units(meters):
        """."""
    ```
  - ```python
    def meters_to_parsecs(meters):
        """."""
    ```
  - ```python
    def meters_to_nautical_miles(meters):
        """."""
    ```
  - ```python
    def meters_to_angstroms(meters):
        """."""
    ```
  - ```python
    def meters_to_microns(meters):
        """."""
    ```
  - ```python
    def meters_to_planck_lengths(meters):
        """."""
    ```
  - ```python
    def centimeters_to_meters(centimeters):
        """."""
    ```
  - ```python
    def centimeters_to_millimeters(centimeters):
        """."""
    ```
  - ```python
    def centimeters_to_kilometers(centimeters):
        """."""
    ```
  - ```python
    def centimeters_to_inches(centimeters):
        """."""
    ```
  - ```python
    def centimeters_to_hands(centimeters):
        """."""
    ```
  - ```python
    def centimeters_to_feet(centimeters):
        """."""
    ```
  - ```python
    def centimeters_to_yards(centimeters):
        """."""
    ```
  - ```python
    def centimeters_to_miles(centimeters):
        """."""
    ```
  - ```python
    def centimeters_to_light_years(centimeters):
        """."""
    ```
  - ```python
    def centimeters_to_astronomical_units(centimeters):
        """."""
    ```
  - ```python
    def centimeters_to_parsecs(centimeters):
        """."""
    ```
  - ```python
    def centimeters_to_nautical_miles(centimeters):
        """."""
    ```
  - ```python
    def centimeters_to_angstroms(centimeters):
        """."""
    ```
  - ```python
    def centimeters_to_microns(centimeters):
        """."""
    ```
  - ```python
    def centimeters_to_planck_lengths(centimeters):
        """."""
    ```
  - ```python
    def millimeters_to_meters(millimeters):
        """."""
    ```
  - ```python
    def millimeters_to_centimeters(millimeters):
        """."""
    ```
  - ```python
    def millimeters_to_kilometers(millimeters):
        """."""
    ```
  - ```python
    def millimeters_to_inches(millimeters):
        """."""
    ```
  - ```python
    def millimeters_to_hands(millimeters):
        """."""
    ```
  - ```python
    def millimeters_to_feet(millimeters):
        """."""
    ```
  - ```python
    def millimeters_to_yards(millimeters):
        """."""
    ```
  - ```python
    def millimeters_to_miles(millimeters):
        """."""
    ```
  - ```python
    def millimeters_to_light_years(millimeters):
        """."""
    ```
  - ```python
    def millimeters_to_astronomical_units(millimeters):
        """."""
    ```
  - ```python
    def millimeters_to_parsecs(millimeters):
        """."""
    ```
  - ```python
    def millimeters_to_nautical_miles(millimeters):
        """."""
    ```
  - ```python
    def millimeters_to_angstroms(millimeters):
        """."""
    ```
  - ```python
    def millimeters_to_microns(millimeters):
        """."""
    ```
  - ```python
    def millimeters_to_planck_lengths(millimeters):
        """."""
    ```
  - ```python
    def kilometers_to_meters(kilometers):
        """."""
    ```
  - ```python
    def kilometers_to_centimeters(kilometers):
        """."""
    ```
  - ```python
    def kilometers_to_millimeters(kilometers):
        """."""
    ```
  - ```python
    def kilometers_to_inches(kilometers):
        """."""
    ```
  - ```python
    def kilometers_to_hands(kilometers):
        """."""
    ```
  - ```python
    def kilometers_to_feet(kilometers):
        """."""
    ```
  - ```python
    def kilometers_to_yards(kilometers):
        """."""
    ```
  - ```python
    def kilometers_to_miles(kilometers):
        """."""
    ```
  - ```python
    def kilometers_to_light_years(kilometers):
        """."""
    ```
  - ```python
    def kilometers_to_astronomical_units(kilometers):
        """."""
    ```
  - ```python
    def kilometers_to_parsecs(kilometers):
        """."""
    ```
  - ```python
    def kilometers_to_nautical_miles(kilometers):
        """."""
    ```
  - ```python
    def kilometers_to_angstroms(kilometers):
        """."""
    ```
  - ```python
    def kilometers_to_microns(kilometers):
        """."""
    ```
  - ```python
    def kilometers_to_planck_lengths(kilometers):
        """."""
    ```
  - ```python
    def inches_to_meters(inches):
        """."""
    ```
  - ```python
    def inches_to_centimeters(inches):
        """."""
    ```
  - ```python
    def inches_to_millimeters(inches):
        """."""
    ```
  - ```python
    def inches_to_kilometers(inches):
        """."""
    ```
  - ```python
    def inches_to_hands(inches):
        """."""
    ```
  - ```python
    def inches_to_feet(inches):
        """."""
    ```
  - ```python
    def inches_to_yards(inches):
        """."""
    ```
  - ```python
    def inches_to_miles(inches):
        """."""
    ```
  - ```python
    def inches_to_light_years(inches):
        """."""
    ```
  - ```python
    def inches_to_astronomical_units(inches):
        """."""
    ```
  - ```python
    def inches_to_parsecs(inches):
        """."""
    ```
  - ```python
    def inches_to_nautical_miles(inches):
        """."""
    ```
  - ```python
    def inches_to_angstroms(inches):
        """."""
    ```
  - ```python
    def inches_to_microns(inches):
        """."""
    ```
  - ```python
    def inches_to_planck_lengths(inches):
        """."""
    ```
  - ```python
    def hands_to_meters(hands):
        """."""
    ```
  - ```python
    def hands_to_centimeters(hands):
        """."""
    ```
  - ```python
    def hands_to_millimeters(hands):
        """."""
    ```
  - ```python
    def hands_to_kilometers(hands):
        """."""
    ```
  - ```python
    def hands_to_inches(hands):
        """."""
    ```
  - ```python
    def hands_to_feet(hands):
        """."""
    ```
  - ```python
    def hands_to_yards(hands):
        """."""
    ```
  - ```python
    def hands_to_miles(hands):
        """."""
    ```
  - ```python
    def hands_to_light_years(hands):
        """."""
    ```
  - ```python
    def hands_to_astronomical_units(hands):
        """."""
    ```
  - ```python
    def hands_to_parsecs(hands):
        """."""
    ```
  - ```python
    def hands_to_nautical_miles(hands):
        """."""
    ```
  - ```python
    def hands_to_angstroms(hands):
        """."""
    ```
  - ```python
    def hands_to_microns(hands):
        """."""
    ```
  - ```python
    def hands_to_planck_lengths(hands):
        """."""
    ```
  - ```python
    def feet_to_meters(feet):
        """."""
    ```
  - ```python
    def feet_to_centimeters(feet):
        """."""
    ```
  - ```python
    def feet_to_millimeters(feet):
        """."""
    ```
  - ```python
    def feet_to_kilometers(feet):
        """."""
    ```
  - ```python
    def feet_to_inches(feet):
        """."""
    ```
  - ```python
    def feet_to_hands(feet):
        """."""
    ```
  - ```python
    def feet_to_yards(feet):
        """."""
    ```
  - ```python
    def feet_to_miles(feet):
        """."""
    ```
  - ```python
    def feet_to_light_years(feet):
        """."""
    ```
  - ```python
    def feet_to_astronomical_units(feet):
        """."""
    ```
  - ```python
    def feet_to_parsecs(feet):
        """."""
    ```
  - ```python
    def feet_to_nautical_miles(feet):
        """."""
    ```
  - ```python
    def feet_to_angstroms(feet):
        """."""
    ```
  - ```python
    def feet_to_microns(feet):
        """."""
    ```
  - ```python
    def feet_to_planck_lengths(feet):
        """."""
    ```
  - ```python
    def yards_to_meters(yards):
        """."""
    ```
  - ```python
    def yards_to_centimeters(yards):
        """."""
    ```
  - ```python
    def yards_to_millimeters(yards):
        """."""
    ```
  - ```python
    def yards_to_kilometers(yards):
        """."""
    ```
  - ```python
    def yards_to_inches(yards):
        """."""
    ```
  - ```python
    def yards_to_hands(yards):
        """."""
    ```
  - ```python
    def yards_to_feet(yards):
        """."""
    ```
  - ```python
    def yards_to_miles(yards):
        """."""
    ```
  - ```python
    def yards_to_light_years(yards):
        """."""
    ```
  - ```python
    def yards_to_astronomical_units(yards):
        """."""
    ```
  - ```python
    def yards_to_parsecs(yards):
        """."""
    ```
  - ```python
    def yards_to_nautical_miles(yards):
        """."""
    ```
  - ```python
    def yards_to_angstroms(yards):
        """."""
    ```
  - ```python
    def yards_to_microns(yards):
        """."""
    ```
  - ```python
    def yards_to_planck_lengths(yards):
        """."""
    ```
  - ```python
    def miles_to_meters(miles):
        """."""
    ```
  - ```python
    def miles_to_centimeters(miles):
        """."""
    ```
  - ```python
    def miles_to_millimeters(miles):
        """."""
    ```
  - ```python
    def miles_to_kilometers(miles):
        """."""
    ```
  - ```python
    def miles_to_inches(miles):
        """."""
    ```
  - ```python
    def miles_to_hands(miles):
        """."""
    ```
  - ```python
    def miles_to_feet(miles):
        """."""
    ```
  - ```python
    def miles_to_yards(miles):
        """."""
    ```
  - ```python
    def miles_to_light_years(miles):
        """."""
    ```
  - ```python
    def miles_to_astronomical_units(miles):
        """."""
    ```
  - ```python
    def miles_to_parsecs(miles):
        """."""
    ```
  - ```python
    def miles_to_nautical_miles(miles):
        """."""
    ```
  - ```python
    def miles_to_angstroms(miles):
        """."""
    ```
  - ```python
    def miles_to_microns(miles):
        """."""
    ```
  - ```python
    def miles_to_planck_lengths(miles):
        """."""
    ```
  - ```python
    def light_years_to_meters(light_years):
        """."""
    ```
  - ```python
    def light_years_to_centimeters(light_years):
        """."""
    ```
  - ```python
    def light_years_to_millimeters(light_years):
        """."""
    ```
  - ```python
    def light_years_to_kilometers(light_years):
        """."""
    ```
  - ```python
    def light_years_to_inches(light_years):
        """."""
    ```
  - ```python
    def light_years_to_hands(light_years):
        """."""
    ```
  - ```python
    def light_years_to_feet(light_years):
        """."""
    ```
  - ```python
    def light_years_to_yards(light_years):
        """."""
    ```
  - ```python
    def light_years_to_miles(light_years):
        """."""
    ```
  - ```python
    def light_years_to_astronomical_units(light_years):
        """."""
    ```
  - ```python
    def light_years_to_parsecs(light_years):
        """."""
    ```
  - ```python
    def light_years_to_nautical_miles(light_years):
        """."""
    ```
  - ```python
    def light_years_to_angstroms(light_years):
        """."""
    ```
  - ```python
    def light_years_to_microns(light_years):
        """."""
    ```
  - ```python
    def light_years_to_planck_lengths(light_years):
        """."""
    ```
  - ```python
    def astronomical_units_to_meters(astronomical_units):
        """."""
    ```
  - ```python
    def astronomical_units_to_centimeters(astronomical_units):
        """."""
    ```
  - ```python
    def astronomical_units_to_millimeters(astronomical_units):
        """."""
    ```
  - ```python
    def astronomical_units_to_kilometers(astronomical_units):
        """."""
    ```
  - ```python
    def astronomical_units_to_inches(astronomical_units):
        """."""
    ```
  - ```python
    def astronomical_units_to_hands(astronomical_units):
        """."""
    ```
  - ```python
    def astronomical_units_to_feet(astronomical_units):
        """."""
    ```
  - ```python
    def astronomical_units_to_yards(astronomical_units):
        """."""
    ```
  - ```python
    def astronomical_units_to_miles(astronomical_units):
        """."""
    ```
  - ```python
    def astronomical_units_to_light_years(astronomical_units):
        """."""
    ```
  - ```python
    def astronomical_units_to_parsecs(astronomical_units):
        """."""
    ```
  - ```python
    def astronomical_units_to_nautical_miles(astronomical_units):
        """."""
    ```
  - ```python
    def astronomical_units_to_angstroms(astronomical_units):
        """."""
    ```
  - ```python
    def astronomical_units_to_microns(astronomical_units):
        """."""
    ```
  - ```python
    def astronomical_units_to_planck_lengths(astronomical_units):
        """."""
    ```
  - ```python
    def parsecs_to_meters(parsecs):
        """."""
    ```
  - ```python
    def parsecs_to_centimeters(parsecs):
        """."""
    ```
  - ```python
    def parsecs_to_millimeters(parsecs):
        """."""
    ```
  - ```python
    def parsecs_to_kilometers(parsecs):
        """."""
    ```
  - ```python
    def parsecs_to_inches(parsecs):
        """."""
    ```
  - ```python
    def parsecs_to_hands(parsecs):
        """."""
    ```
  - ```python
    def parsecs_to_feet(parsecs):
        """."""
    ```
  - ```python
    def parsecs_to_yards(parsecs):
        """."""
    ```
  - ```python
    def parsecs_to_miles(parsecs):
        """."""
    ```
  - ```python
    def parsecs_to_light_years(parsecs):
        """."""
    ```
  - ```python
    def parsecs_to_astronomical_units(parsecs):
        """."""
    ```
  - ```python
    def parsecs_to_nautical_miles(parsecs):
        """."""
    ```
  - ```python
    def parsecs_to_angstroms(parsecs):
        """."""
    ```
  - ```python
    def parsecs_to_microns(parsecs):
        """."""
    ```
  - ```python
    def parsecs_to_planck_lengths(parsecs):
        """."""
    ```
  - ```python
    def nautical_miles_to_meters(nautical_miles):
        """."""
    ```
  - ```python
    def nautical_miles_to_centimeters(nautical_miles):
        """."""
    ```
  - ```python
    def nautical_miles_to_millimeters(nautical_miles):
        """."""
    ```
  - ```python
    def nautical_miles_to_kilometers(nautical_miles):
        """."""
    ```
  - ```python
    def nautical_miles_to_inches(nautical_miles):
        """."""
    ```
  - ```python
    def nautical_miles_to_hands(nautical_miles):
        """."""
    ```
  - ```python
    def nautical_miles_to_feet(nautical_miles):
        """."""
    ```
  - ```python
    def nautical_miles_to_yards(nautical_miles):
        """."""
    ```
  - ```python
    def nautical_miles_to_miles(nautical_miles):
        """."""
    ```
  - ```python
    def nautical_miles_to_light_years(nautical_miles):
        """."""
    ```
  - ```python
    def nautical_miles_to_astronomical_units(nautical_miles):
        """."""
    ```
  - ```python
    def nautical_miles_to_parsecs(nautical_miles):
        """."""
    ```
  - ```python
    def nautical_miles_to_angstroms(nautical_miles):
        """."""
    ```
  - ```python
    def nautical_miles_to_microns(nautical_miles):
        """."""
    ```
  - ```python
    def nautical_miles_to_planck_lengths(nautical_miles):
        """."""
    ```
  - ```python
    def angstroms_to_meters(angstroms):
        """."""
    ```
  - ```python
    def angstroms_to_centimeters(angstroms):
        """."""
    ```
  - ```python
    def angstroms_to_millimeters(angstroms):
        """."""
    ```
  - ```python
    def angstroms_to_kilometers(angstroms):
        """."""
    ```
  - ```python
    def angstroms_to_inches(angstroms):
        """."""
    ```
  - ```python
    def angstroms_to_hands(angstroms):
        """."""
    ```
  - ```python
    def angstroms_to_feet(angstroms):
        """."""
    ```
  - ```python
    def angstroms_to_yards(angstroms):
        """."""
    ```
  - ```python
    def angstroms_to_miles(angstroms):
        """."""
    ```
  - ```python
    def angstroms_to_light_years(angstroms):
        """."""
    ```
  - ```python
    def angstroms_to_astronomical_units(angstroms):
        """."""
    ```
  - ```python
    def angstroms_to_parsecs(angstroms):
        """."""
    ```
  - ```python
    def angstroms_to_nautical_miles(angstroms):
        """."""
    ```
  - ```python
    def angstroms_to_microns(angstroms):
        """."""
    ```
  - ```python
    def angstroms_to_planck_lengths(angstroms):
        """."""
    ```
  - ```python
    def microns_to_meters(microns):
        """."""
    ```
  - ```python
    def microns_to_centimeters(microns):
        """."""
    ```
  - ```python
    def microns_to_millimeters(microns):
        """."""
    ```
  - ```python
    def microns_to_kilometers(microns):
        """."""
    ```
  - ```python
    def microns_to_inches(microns):
        """."""
    ```
  - ```python
    def microns_to_hands(microns):
        """."""
    ```
  - ```python
    def microns_to_feet(microns):
        """."""
    ```
  - ```python
    def microns_to_yards(microns):
        """."""
    ```
  - ```python
    def microns_to_miles(microns):
        """."""
    ```
  - ```python
    def microns_to_light_years(microns):
        """."""
    ```
  - ```python
    def microns_to_astronomical_units(microns):
        """."""
    ```
  - ```python
    def microns_to_parsecs(microns):
        """."""
    ```
  - ```python
    def microns_to_nautical_miles(microns):
        """."""
    ```
  - ```python
    def microns_to_angstroms(microns):
        """."""
    ```
  - ```python
    def microns_to_planck_lengths(microns):
        """."""
    ```
  - ```python
    def planck_lengths_to_meters(planck_lengths):
        """."""
    ```
  - ```python
    def planck_lengths_to_centimeters(planck_lengths):
        """."""
    ```
  - ```python
    def planck_lengths_to_millimeters(planck_lengths):
        """."""
    ```
  - ```python
    def planck_lengths_to_kilometers(planck_lengths):
        """."""
    ```
  - ```python
    def planck_lengths_to_inches(planck_lengths):
        """."""
    ```
  - ```python
    def planck_lengths_to_hands(planck_lengths):
        """."""
    ```
  - ```python
    def planck_lengths_to_feet(planck_lengths):
        """."""
    ```
  - ```python
    def planck_lengths_to_yards(planck_lengths):
        """."""
    ```
  - ```python
    def planck_lengths_to_miles(planck_lengths):
        """."""
    ```
  - ```python
    def planck_lengths_to_light_years(planck_lengths):
        """."""
    ```
  - ```python
    def planck_lengths_to_astronomical_units(planck_lengths):
        """."""
    ```
  - ```python
    def planck_lengths_to_parsecs(planck_lengths):
        """."""
    ```
  - ```python
    def planck_lengths_to_nautical_miles(planck_lengths):
        """."""
    ```
  - ```python
    def planck_lengths_to_angstroms(planck_lengths):
        """."""
    ```
  - ```python
    def planck_lengths_to_microns(planck_lengths):
        """."""
    ```
  - ```python
    def celsius_to_fahrenheit(celsius_temperature):
        """Convert Celsius to Fahrenheit."""
    ```
  - ```python
    def celsius_to_kelvin(celsius_temperature):
        """Convert Celsius to Kelvin."""
    ```
  - ```python
    def fahrenheit_to_celsius(fahrenheit_temperature):
        """Convert Fahrenheit to Celsius."""
    ```
  - ```python
    def fahrenheit_to_kelvin(fahrenheit_temperature):
        """Convert Fahrenheit to Kelvin."""
    ```
  - ```python
    def kelvin_to_celsius(kelvin_temperature):
        """Convert Kelvin to Celsius."""
    ```
  - ```python
    def kelvin_to_fahrenheit(kelvin_temperature):
        """Convert Kelvin to Fahrenheit."""
    ```
  - ```python
    def celsius_to_felsius(celsius_temperature):
        """Convert the celsius_temperature into the Felsius temperature (see https://xkcd.com/1923/)."""
    ```
  - ```python
    def fahrenheit_to_felsius(fahrenheit_temperature):
        """Convert the fahrenheit_temperature into the Felsius temperature (see https://xkcd.com/1923/)."""
    ```
  - ```python
    def kelvin_to_felsius(kelvin_temperature):
        """Convert the kelvin_temperature into the Felsius temperature (see https://xkcd.com/1923/)."""
    ```

## Development

👋 &nbsp;If you want to get involved in this project, we have some short, helpful guides below:

- [contribute to this project 🥇][contributing]
- [test it 🧪][local-dev]
- [lint it 🧹][local-dev]
- [explore it 🔭][local-dev]

If you have any questions or there is anything we did not cover, please raise an issue and we'll be happy to help.

## Credits

This package was created with [Cookiecutter](https://github.com/audreyr/cookiecutter) and Floyd Hightower's [Python project template](https://github.com/fhightower-templates/python-project-template).

[contributing]: https://github.com/democritus-project/.github/blob/main/CONTRIBUTING.md#contributing-a-pr-
[local-dev]: https://github.com/democritus-project/.github/blob/main/CONTRIBUTING.md#local-development-
