"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Workmail = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [workmail](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonworkmail.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Workmail extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [workmail](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonworkmail.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'workmail';
        this.accessLevelList = {
            Write: [
                'AddMembersToGroup',
                'AssociateDelegateToResource',
                'AssociateMemberToGroup',
                'CancelMailboxExportJob',
                'CreateAlias',
                'CreateGroup',
                'CreateInboundMailFlowRule',
                'CreateMailDomain',
                'CreateMailUser',
                'CreateMobileDeviceAccessRule',
                'CreateOrganization',
                'CreateOutboundMailFlowRule',
                'CreateResource',
                'CreateSmtpGateway',
                'CreateUser',
                'DeleteAccessControlRule',
                'DeleteAlias',
                'DeleteEmailMonitoringConfiguration',
                'DeleteGroup',
                'DeleteInboundMailFlowRule',
                'DeleteMailDomain',
                'DeleteMailboxPermissions',
                'DeleteMobileDevice',
                'DeleteMobileDeviceAccessOverride',
                'DeleteMobileDeviceAccessRule',
                'DeleteOrganization',
                'DeleteOutboundMailFlowRule',
                'DeleteResource',
                'DeleteRetentionPolicy',
                'DeleteSmtpGateway',
                'DeleteUser',
                'DeregisterFromWorkMail',
                'DeregisterMailDomain',
                'DisableMailGroups',
                'DisableMailUsers',
                'DisassociateDelegateFromResource',
                'DisassociateMemberFromGroup',
                'EnableMailDomain',
                'EnableMailGroups',
                'EnableMailUsers',
                'PutAccessControlRule',
                'PutEmailMonitoringConfiguration',
                'PutInboundDmarcSettings',
                'PutMailboxPermissions',
                'PutMobileDeviceAccessOverride',
                'PutRetentionPolicy',
                'RegisterMailDomain',
                'RegisterToWorkMail',
                'RemoveMembersFromGroup',
                'ResetPassword',
                'ResetUserPassword',
                'SetAdmin',
                'SetDefaultMailDomain',
                'SetJournalingRules',
                'SetMailGroupDetails',
                'SetMailUserDetails',
                'SetMobilePolicyDetails',
                'StartMailboxExportJob',
                'TestInboundMailFlowRules',
                'TestOutboundMailFlowRules',
                'UpdateDefaultMailDomain',
                'UpdateInboundMailFlowRule',
                'UpdateMailboxQuota',
                'UpdateMobileDeviceAccessRule',
                'UpdateOutboundMailFlowRule',
                'UpdatePrimaryEmailAddress',
                'UpdateResource',
                'UpdateSmtpGateway',
                'WipeMobileDevice'
            ],
            List: [
                'DescribeDirectories',
                'DescribeGroup',
                'DescribeKmsKeys',
                'DescribeMailDomains',
                'DescribeMailGroups',
                'DescribeMailUsers',
                'DescribeOrganization',
                'DescribeOrganizations',
                'DescribeResource',
                'DescribeUser',
                'ListAliases',
                'ListGroupMembers',
                'ListGroups',
                'ListInboundMailFlowRules',
                'ListMailDomains',
                'ListMailboxExportJobs',
                'ListMailboxPermissions',
                'ListOrganizations',
                'ListOutboundMailFlowRules',
                'ListResourceDelegates',
                'ListResources',
                'ListSmtpGateways',
                'ListTagsForResource',
                'ListUsers'
            ],
            Read: [
                'DescribeEmailMonitoringConfiguration',
                'DescribeInboundDmarcSettings',
                'DescribeInboundMailFlowRule',
                'DescribeMailboxExportJob',
                'DescribeOutboundMailFlowRule',
                'DescribeSmtpGateway',
                'GetAccessControlEffect',
                'GetDefaultRetentionPolicy',
                'GetJournalingRules',
                'GetMailDomain',
                'GetMailDomainDetails',
                'GetMailGroupDetails',
                'GetMailUserDetails',
                'GetMailboxDetails',
                'GetMobileDeviceAccessEffect',
                'GetMobileDeviceAccessOverride',
                'GetMobileDeviceDetails',
                'GetMobileDevicesForUser',
                'GetMobilePolicyDetails',
                'ListAccessControlRules',
                'ListMembersInMailGroup',
                'ListMobileDeviceAccessOverrides',
                'ListMobileDeviceAccessRules',
                'SearchMembers'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to add a list of members (users or groups) to a group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/groups_overview.html
     */
    toAddMembersToGroup() {
        return this.to('AddMembersToGroup');
    }
    /**
     * Grants permission to add a member (user or group) to the resource's set of delegates
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_AssociateDelegateToResource.html
     */
    toAssociateDelegateToResource() {
        return this.to('AssociateDelegateToResource');
    }
    /**
     * Grants permission to add a member (user or group) to the group's set
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_AssociateMemberToGroup.html
     */
    toAssociateMemberToGroup() {
        return this.to('AssociateMemberToGroup');
    }
    /**
     * Grants permission to cancel a currently running mailbox export job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_CancelMailboxExportJob.html
     */
    toCancelMailboxExportJob() {
        return this.to('CancelMailboxExportJob');
    }
    /**
     * Grants permission to add an alias to the set of a given member (user or group) of WorkMail
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_CreateAlias.html
     */
    toCreateAlias() {
        return this.to('CreateAlias');
    }
    /**
     * Grants permission to create a group that can be used in WorkMail by calling the RegisterToWorkMail operation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_CreateGroup.html
     */
    toCreateGroup() {
        return this.to('CreateGroup');
    }
    /**
     * Grants permission to create an inbound email flow rule which will apply to all email sent to an organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/create-email-rules.html
     */
    toCreateInboundMailFlowRule() {
        return this.to('CreateInboundMailFlowRule');
    }
    /**
     * Grants permission to create a mail domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/add_domain.html
     */
    toCreateMailDomain() {
        return this.to('CreateMailDomain');
    }
    /**
     * Grants permission to create a user in the directory
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/manage-users.html
     */
    toCreateMailUser() {
        return this.to('CreateMailUser');
    }
    /**
     * Grants permission to create a new mobile device access rule
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_CreateMobileDeviceAccessRule.html
     */
    toCreateMobileDeviceAccessRule() {
        return this.to('CreateMobileDeviceAccessRule');
    }
    /**
     * Grants permission to create a new Amazon WorkMail organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_CreateOrganization.html
     */
    toCreateOrganization() {
        return this.to('CreateOrganization');
    }
    /**
     * Grants permission to create an outbound email flow rule which will apply to all email sent from an organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/create-email-rules.html
     */
    toCreateOutboundMailFlowRule() {
        return this.to('CreateOutboundMailFlowRule');
    }
    /**
     * Grants permission to create a new WorkMail resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_CreateResource.html
     */
    toCreateResource() {
        return this.to('CreateResource');
    }
    /**
     * Grants permission to register an SMTP gateway to a WorkMail organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/smtp-gateway.html
     */
    toCreateSmtpGateway() {
        return this.to('CreateSmtpGateway');
    }
    /**
     * Grants permission to create a user, which can be enabled afterwards by calling the RegisterToWorkMail operation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_CreateUser.html
     */
    toCreateUser() {
        return this.to('CreateUser');
    }
    /**
     * Grants permission to delete an access control rule
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeleteAccessControlRule.html
     */
    toDeleteAccessControlRule() {
        return this.to('DeleteAccessControlRule');
    }
    /**
     * Grants permission to remove one or more specified aliases from a set of aliases for a given user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeleteAlias.html
     */
    toDeleteAlias() {
        return this.to('DeleteAlias');
    }
    /**
     * Grants permission to delete the email monitoring configuration for an organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeleteEmailMonitoringConfiguration.html
     */
    toDeleteEmailMonitoringConfiguration() {
        return this.to('DeleteEmailMonitoringConfiguration');
    }
    /**
     * Grants permission to delete a group from WorkMail
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeleteGroup.html
     */
    toDeleteGroup() {
        return this.to('DeleteGroup');
    }
    /**
     * Grants permission to remove an inbound email flow rule to no longer apply to emails sent to an organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/remove-email-flow-rule.html
     */
    toDeleteInboundMailFlowRule() {
        return this.to('DeleteInboundMailFlowRule');
    }
    /**
     * Grants permission to remove an unused mail domain from an organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/remove_domain.html
     */
    toDeleteMailDomain() {
        return this.to('DeleteMailDomain');
    }
    /**
     * Grants permission to delete permissions granted to a member (user or group)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeleteMailboxPermissions.html
     */
    toDeleteMailboxPermissions() {
        return this.to('DeleteMailboxPermissions');
    }
    /**
     * Grants permission to remove a mobile device from a user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/manage-devices.html#remove_mobile_device
     */
    toDeleteMobileDevice() {
        return this.to('DeleteMobileDevice');
    }
    /**
     * Grants permission to delete a mobile device access override
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeleteMobileDeviceAccessOverride.html
     */
    toDeleteMobileDeviceAccessOverride() {
        return this.to('DeleteMobileDeviceAccessOverride');
    }
    /**
     * Grants permission to delete a mobile device access rule
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeleteMobileDeviceAccessRule.html
     */
    toDeleteMobileDeviceAccessRule() {
        return this.to('DeleteMobileDeviceAccessRule');
    }
    /**
     * Grants permission to delete an Amazon WorkMail organization and all underlying AWS resources managed by Amazon WorkMail as part of the organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeleteOrganization.html
     */
    toDeleteOrganization() {
        return this.to('DeleteOrganization');
    }
    /**
     * Grants permission to remove an outbound email flow rule so that it no longer applies to emails sent from an organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/remove-email-flow-rule.html
     */
    toDeleteOutboundMailFlowRule() {
        return this.to('DeleteOutboundMailFlowRule');
    }
    /**
     * Grants permission to delete the specified resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeleteResource.html
     */
    toDeleteResource() {
        return this.to('DeleteResource');
    }
    /**
     * Grants permission to delete the retention policy based on the supplied organization and policy identifiers
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeleteRetentionPolicy.html
     */
    toDeleteRetentionPolicy() {
        return this.to('DeleteRetentionPolicy');
    }
    /**
     * Grants permission to remove an SMTP gateway from an organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/smtp-gateway.html
     */
    toDeleteSmtpGateway() {
        return this.to('DeleteSmtpGateway');
    }
    /**
     * Grants permission to delete a user from WorkMail and all subsequent systems
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeleteUser.html
     */
    toDeleteUser() {
        return this.to('DeleteUser');
    }
    /**
     * Grants permission to mark a user, group, or resource as no longer used in WorkMail
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeregisterFromWorkMail.html
     */
    toDeregisterFromWorkMail() {
        return this.to('DeregisterFromWorkMail');
    }
    /**
     * Grants permission to deregister a mail domain from an organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DeregisterMailDomain.html
     */
    toDeregisterMailDomain() {
        return this.to('DeregisterMailDomain');
    }
    /**
     * Grants permission to show a list of directories available for use in creating an organization
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/add_new_organization.html
     */
    toDescribeDirectories() {
        return this.to('DescribeDirectories');
    }
    /**
     * Grants permission to retrieve the email monitoring configuration for an organization
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DescribeEmailMonitoringConfiguration.html
     */
    toDescribeEmailMonitoringConfiguration() {
        return this.to('DescribeEmailMonitoringConfiguration');
    }
    /**
     * Grants permission to read the details for a group
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DescribeGroup.html
     */
    toDescribeGroup() {
        return this.to('DescribeGroup');
    }
    /**
     * Grants permission to read the settings in a DMARC policy for a specified organization
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DescribeInboundDmarcSettings.html
     */
    toDescribeInboundDmarcSettings() {
        return this.to('DescribeInboundDmarcSettings');
    }
    /**
     * Grants permission to read the details of an inbound mail flow rule configured for an organization
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/email-flows.html#email-flows-rule-actions
     */
    toDescribeInboundMailFlowRule() {
        return this.to('DescribeInboundMailFlowRule');
    }
    /**
     * Grants permission to show a list of KMS Keys available for use in creating an organization
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/add_new_organization.html
     */
    toDescribeKmsKeys() {
        return this.to('DescribeKmsKeys');
    }
    /**
     * Grants permission to show the details of all mail domains associated with the organization
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/domains_overview.html
     */
    toDescribeMailDomains() {
        return this.to('DescribeMailDomains');
    }
    /**
     * Grants permission to show the details of all groups associated with the organization
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/groups_overview.html
     */
    toDescribeMailGroups() {
        return this.to('DescribeMailGroups');
    }
    /**
     * Grants permission to show the details of all users associated with the organization
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/users_overview.html
     */
    toDescribeMailUsers() {
        return this.to('DescribeMailUsers');
    }
    /**
     * Grants permission to retrieve details of a mailbox export job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DescribeMailboxExportJob.html
     */
    toDescribeMailboxExportJob() {
        return this.to('DescribeMailboxExportJob');
    }
    /**
     * Grants permission to read details of an organization
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DescribeOrganization.html
     */
    toDescribeOrganization() {
        return this.to('DescribeOrganization');
    }
    /**
     * Grants permission to show a summary of all organizations associated with the account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/organizations_overview.html
     */
    toDescribeOrganizations() {
        return this.to('DescribeOrganizations');
    }
    /**
     * Grants permission to read the details of an outbound mail flow rule configured for an organization
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/email-flows.html#email-flows-rule-outbound
     */
    toDescribeOutboundMailFlowRule() {
        return this.to('DescribeOutboundMailFlowRule');
    }
    /**
     * Grants permission to read the details for a resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DescribeResource.html
     */
    toDescribeResource() {
        return this.to('DescribeResource');
    }
    /**
     * Grants permission to read the details of an SMTP gateway registered to an organization
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/smtp-gateway.html
     */
    toDescribeSmtpGateway() {
        return this.to('DescribeSmtpGateway');
    }
    /**
     * Grants permission to read details for a user
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DescribeUser.html
     */
    toDescribeUser() {
        return this.to('DescribeUser');
    }
    /**
     * Grants permission to disable a mail group when it is not being used, in order to allow it to be deleted
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/remove_group.html
     */
    toDisableMailGroups() {
        return this.to('DisableMailGroups');
    }
    /**
     * Grants permission to disable a user mailbox when it is no longer being used, in order to allow it to be deleted
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/manage-mailboxes.html#delete_user_mailbox
     */
    toDisableMailUsers() {
        return this.to('DisableMailUsers');
    }
    /**
     * Grants permission to remove a member from the resource's set of delegates
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DisassociateDelegateFromResource.html
     */
    toDisassociateDelegateFromResource() {
        return this.to('DisassociateDelegateFromResource');
    }
    /**
     * Grants permission to remove a member from a group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_DisassociateMemberFromGroup.html
     */
    toDisassociateMemberFromGroup() {
        return this.to('DisassociateMemberFromGroup');
    }
    /**
     * Grants permission to enable a mail domain in the organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/add_domain.html
     */
    toEnableMailDomain() {
        return this.to('EnableMailDomain');
    }
    /**
     * Grants permission to enable a mail group after it has been created to allow it to receive mail
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/enable_existing_group.html
     */
    toEnableMailGroups() {
        return this.to('EnableMailGroups');
    }
    /**
     * Grants permission to enable a user's mailbox after it has been created to allow it to receive mail
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/manage-users.html#enable_existing_user
     */
    toEnableMailUsers() {
        return this.to('EnableMailUsers');
    }
    /**
     * Grants permission to get the effects of access control rules as they apply to a specified IPv4 address, access protocol action, or user ID
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_GetAccessControlEffect.html
     */
    toGetAccessControlEffect() {
        return this.to('GetAccessControlEffect');
    }
    /**
     * Grants permission to retrieve the retention policy associated at an organizational level
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_GetDefaultRetentionPolicy.html
     */
    toGetDefaultRetentionPolicy() {
        return this.to('GetDefaultRetentionPolicy');
    }
    /**
     * Grants permission to read the configured journaling and fallback email addresses for email journaling
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/journaling_overview.html
     */
    toGetJournalingRules() {
        return this.to('GetJournalingRules');
    }
    /**
     * Grants permission to retrieve details of a given mail domain in an organization
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_GetMailDomain.html
     */
    toGetMailDomain() {
        return this.to('GetMailDomain');
    }
    /**
     * Grants permission to get the details of the mail domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/domains_overview.html
     */
    toGetMailDomainDetails() {
        return this.to('GetMailDomainDetails');
    }
    /**
     * Grants permission to get the details of the mail group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/groups_overview.html
     */
    toGetMailGroupDetails() {
        return this.to('GetMailGroupDetails');
    }
    /**
     * Grants permission to get the details of the user's mailbox and account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/users_overview.html
     */
    toGetMailUserDetails() {
        return this.to('GetMailUserDetails');
    }
    /**
     * Grants permission to read the details of the user's mailbox
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_GetMailboxDetails.html
     */
    toGetMailboxDetails() {
        return this.to('GetMailboxDetails');
    }
    /**
     * Grants permission to simulate the effect of the mobile device access rules for the given attributes of a sample access event
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_GetMobileDeviceAccessEffect.html
     */
    toGetMobileDeviceAccessEffect() {
        return this.to('GetMobileDeviceAccessEffect');
    }
    /**
     * Grants permission to retrieve a mobile device access override
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_GetMobileDeviceAccessOverride.html
     */
    toGetMobileDeviceAccessOverride() {
        return this.to('GetMobileDeviceAccessOverride');
    }
    /**
     * Grants permission to get the details of the mobile device
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/manage-devices.html
     */
    toGetMobileDeviceDetails() {
        return this.to('GetMobileDeviceDetails');
    }
    /**
     * Grants permission to get a list of the mobile devices associated with the user
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/manage-devices.html
     */
    toGetMobileDevicesForUser() {
        return this.to('GetMobileDevicesForUser');
    }
    /**
     * Grants permission to get the details of the mobile device policy associated with the organization
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/edit_organization_mobile_policy.html
     */
    toGetMobilePolicyDetails() {
        return this.to('GetMobilePolicyDetails');
    }
    /**
     * Grants permission to list the access control rules
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListAccessControlRules.html
     */
    toListAccessControlRules() {
        return this.to('ListAccessControlRules');
    }
    /**
     * Grants permission to list the aliases associated with a given entity
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListAliases.html
     */
    toListAliases() {
        return this.to('ListAliases');
    }
    /**
     * Grants permission to read an overview of the members of a group. Users and groups can be members of a group
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListGroupMembers.html
     */
    toListGroupMembers() {
        return this.to('ListGroupMembers');
    }
    /**
     * Grants permission to list summaries of the organization's groups
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListGroups.html
     */
    toListGroups() {
        return this.to('ListGroups');
    }
    /**
     * Grants permission to list inbound mail flow rules configured for an organization
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/email-flows.html#email-flows-rule-actions
     */
    toListInboundMailFlowRules() {
        return this.to('ListInboundMailFlowRules');
    }
    /**
     * Grants permission to list the mail domains for a given organization
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListMailDomains.html
     */
    toListMailDomains() {
        return this.to('ListMailDomains');
    }
    /**
     * Grants permission to list mailbox export jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListMailboxExportJobs.html
     */
    toListMailboxExportJobs() {
        return this.to('ListMailboxExportJobs');
    }
    /**
     * Grants permission to list the mailbox permissions associated with a user, group, or resource mailbox
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListMailboxPermissions.html
     */
    toListMailboxPermissions() {
        return this.to('ListMailboxPermissions');
    }
    /**
     * Grants permission to get a list of all the members in a mail group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/groups_overview.html
     */
    toListMembersInMailGroup() {
        return this.to('ListMembersInMailGroup');
    }
    /**
     * Grants permission to list the mobile device access overrides
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListMobileDeviceAccessOverrides.html
     */
    toListMobileDeviceAccessOverrides() {
        return this.to('ListMobileDeviceAccessOverrides');
    }
    /**
     * Grants permission to list the mobile device access rules
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListMobileDeviceAccessRules.html
     */
    toListMobileDeviceAccessRules() {
        return this.to('ListMobileDeviceAccessRules');
    }
    /**
     * Grants permission to list the non-deleted organizations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListOrganizations.html
     */
    toListOrganizations() {
        return this.to('ListOrganizations');
    }
    /**
     * Grants permission to list outbound mail flow rules configured for an organization
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/email-flows.html#email-flows-rule-outbound
     */
    toListOutboundMailFlowRules() {
        return this.to('ListOutboundMailFlowRules');
    }
    /**
     * Grants permission to list the delegates associated with a resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListResourceDelegates.html
     */
    toListResourceDelegates() {
        return this.to('ListResourceDelegates');
    }
    /**
     * Grants permission to list the organization's resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListResources.html
     */
    toListResources() {
        return this.to('ListResources');
    }
    /**
     * Grants permission to list SMTP gateways registered to the organization
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/smtp-gateway.html
     */
    toListSmtpGateways() {
        return this.to('ListSmtpGateways');
    }
    /**
     * Grants permission to list the tags applied to an Amazon WorkMail organization resource
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to list the organization's users
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ListUsers.html
     */
    toListUsers() {
        return this.to('ListUsers');
    }
    /**
     * Grants permission to add a new access control rule
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_PutAccessControlRule.html
     */
    toPutAccessControlRule() {
        return this.to('PutAccessControlRule');
    }
    /**
     * Grants permission to add or update the email monitoring configuration for an organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_PutEmailMonitoringConfiguration.html
     */
    toPutEmailMonitoringConfiguration() {
        return this.to('PutEmailMonitoringConfiguration');
    }
    /**
     * Grants permission to enable or disable a DMARC policy for a given organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_PutInboundDmarcSettings.html
     */
    toPutInboundDmarcSettings() {
        return this.to('PutInboundDmarcSettings');
    }
    /**
     * Grants permission to set permissions for a user, group, or resource, replacing any existing permissions
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_PutMailboxPermissions.html
     */
    toPutMailboxPermissions() {
        return this.to('PutMailboxPermissions');
    }
    /**
     * Grants permission to add or update a mobile device access override
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_PutMobileDeviceAccessOverride.html
     */
    toPutMobileDeviceAccessOverride() {
        return this.to('PutMobileDeviceAccessOverride');
    }
    /**
     * Grants permission to add or update the retention policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_PutRetentionPolicy.html
     */
    toPutRetentionPolicy() {
        return this.to('PutRetentionPolicy');
    }
    /**
     * Grants permission to register a new mail domain in an organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_RegisterMailDomain.html
     */
    toRegisterMailDomain() {
        return this.to('RegisterMailDomain');
    }
    /**
     * Grants permission to register an existing and disabled user, group, or resource for use by associating a mailbox and calendaring capabilities
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_RegisterToWorkMail.html
     */
    toRegisterToWorkMail() {
        return this.to('RegisterToWorkMail');
    }
    /**
     * Grants permission to remove members from a mail group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/groups_overview.html
     */
    toRemoveMembersFromGroup() {
        return this.to('RemoveMembersFromGroup');
    }
    /**
     * Grants permission to allow the administrator to reset the password for a user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_ResetPassword.html
     */
    toResetPassword() {
        return this.to('ResetPassword');
    }
    /**
     * Grants permission to reset the password for a user's account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/manage-users.html#reset_user_password
     */
    toResetUserPassword() {
        return this.to('ResetUserPassword');
    }
    /**
     * Grants permission to perform a prefix search to find a specific user in a mail group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/groups_overview.html
     */
    toSearchMembers() {
        return this.to('SearchMembers');
    }
    /**
     * Grants permission to mark a user as being an administrator
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/users_overview.html
     */
    toSetAdmin() {
        return this.to('SetAdmin');
    }
    /**
     * Grants permission to set the default mail domain for the organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/default_domain.html
     */
    toSetDefaultMailDomain() {
        return this.to('SetDefaultMailDomain');
    }
    /**
     * Grants permission to set journaling and fallback email addresses for email journaling
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/journaling_overview.html
     */
    toSetJournalingRules() {
        return this.to('SetJournalingRules');
    }
    /**
     * Grants permission to set the details of the mail group which has just been created
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/add_new_group.html
     */
    toSetMailGroupDetails() {
        return this.to('SetMailGroupDetails');
    }
    /**
     * Grants permission to set the details for the user account which has just been created
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/manage-users.html
     */
    toSetMailUserDetails() {
        return this.to('SetMailUserDetails');
    }
    /**
     * Grants permission to set the details of a mobile policy associated with the organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/edit_organization_mobile_policy.html
     */
    toSetMobilePolicyDetails() {
        return this.to('SetMobilePolicyDetails');
    }
    /**
     * Grants permission to start a new mailbox export job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_StartMailboxExportJob.html
     */
    toStartMailboxExportJob() {
        return this.to('StartMailboxExportJob');
    }
    /**
     * Grants permission to tag the specified Amazon WorkMail organization resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to test what inbound rules will apply to an email with a given sender and recipient
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/test-email-flow-rule.html
     */
    toTestInboundMailFlowRules() {
        return this.to('TestInboundMailFlowRules');
    }
    /**
     * Grants permission to test what outbound rules will apply to an email with a given sender and recipient
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/test-email-flow-rule.html
     */
    toTestOutboundMailFlowRules() {
        return this.to('TestOutboundMailFlowRules');
    }
    /**
     * Grants permission to untag the specified Amazon WorkMail organization resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update which domain is the default domain for an organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_UpdateDefaultMailDomain.html
     */
    toUpdateDefaultMailDomain() {
        return this.to('UpdateDefaultMailDomain');
    }
    /**
     * Grants permission to update the details of an inbound email flow rule which will apply to all email sent to an organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/modify-email-flow-rule.html
     */
    toUpdateInboundMailFlowRule() {
        return this.to('UpdateInboundMailFlowRule');
    }
    /**
     * Grants permission to update the maximum size (in MB) of the user's mailbox
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_UpdateMailboxQuota.html
     */
    toUpdateMailboxQuota() {
        return this.to('UpdateMailboxQuota');
    }
    /**
     * Grants permission to update a mobile device access rule
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_UpdateMobileDeviceAccessRule.html
     */
    toUpdateMobileDeviceAccessRule() {
        return this.to('UpdateMobileDeviceAccessRule');
    }
    /**
     * Grants permission to update the details of an outbound email flow rule which will apply to all email sent from an organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/modify-email-flow-rule.html
     */
    toUpdateOutboundMailFlowRule() {
        return this.to('UpdateOutboundMailFlowRule');
    }
    /**
     * Grants permission to update the primary email for a user, group, or resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_UpdatePrimaryEmailAddress.html
     */
    toUpdatePrimaryEmailAddress() {
        return this.to('UpdatePrimaryEmailAddress');
    }
    /**
     * Grants permission to update details for the resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/APIReference/API_UpdateResource.html
     */
    toUpdateResource() {
        return this.to('UpdateResource');
    }
    /**
     * Grants permission to update the details of an existing SMTP gateway registered to an organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/smtp-gateway.html
     */
    toUpdateSmtpGateway() {
        return this.to('UpdateSmtpGateway');
    }
    /**
     * Grants permission to remotely wipe the mobile device associated with a user's account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/manage-devices.html#remote_wipe_device
     */
    toWipeMobileDevice() {
        return this.to('WipeMobileDevice');
    }
    /**
     * Adds a resource of type organization to the statement
     *
     * https://docs.aws.amazon.com/workmail/latest/adminguide/organizations_overview.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onOrganization(resourceId, account, region, partition) {
        return this.on(`arn:${partition || Workmail.defaultPartition}:workmail:${region || '*'}:${account || '*'}:organization/${resourceId}`);
    }
}
exports.Workmail = Workmail;
_a = JSII_RTTI_SYMBOL_1;
Workmail[_a] = { fqn: "iam-floyd.Workmail", version: "0.358.0" };
//# sourceMappingURL=data:application/json;base64,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