# AUTOGENERATED - modify shared_anyscale_util in root directory to make changes
from typing import Union


def ray_semver_compare(a: str, b: str) -> int:
    """
    A dumb implementation of semver comparison because ray versions
    don't actually follow the semver standard.
    """
    a_parts = a.split(".")
    b_parts = b.split(".")
    for i, a_part in enumerate(a_parts):
        if i > len(b_parts):
            # No value in part is always less than any string in a part
            return 1

        try:
            parsed_a_part: Union[str, int] = int(a_part)
            parsed_b_part: Union[str, int] = int(b_parts[i])
        except ValueError:
            parsed_a_part = a_part
            parsed_b_part = b_parts[i]

        if parsed_a_part > parsed_b_part:  # type: ignore
            return 1
        elif parsed_a_part < parsed_b_part:  # type: ignore
            return -1
    if len(b_parts) > len(a_parts):
        # B still has parts, it must be bigger
        return -1

    return 0
