import * as iam from '@aws-cdk/aws-iam';
import * as cdk from '@aws-cdk/core';
import { Construct } from 'constructs';
import { ILogGroup } from './log-group';
import { ILogSubscriptionDestination, LogSubscriptionDestinationConfig } from './subscription-filter';
/**
 * Properties for a CrossAccountDestination.
 *
 * @stability stable
 */
export interface CrossAccountDestinationProps {
    /**
     * The name of the log destination.
     *
     * @default Automatically generated
     * @stability stable
     */
    readonly destinationName?: string;
    /**
     * The role to assume that grants permissions to write to 'target'.
     *
     * The role must be assumable by 'logs.{REGION}.amazonaws.com'.
     *
     * @stability stable
     */
    readonly role: iam.IRole;
    /**
     * The log destination target's ARN.
     *
     * @stability stable
     */
    readonly targetArn: string;
}
/**
 * A new CloudWatch Logs Destination for use in cross-account scenarios.
 *
 * CrossAccountDestinations are used to subscribe a Kinesis stream in a
 * different account to a CloudWatch Subscription.
 *
 * Consumers will hardly ever need to use this class. Instead, directly
 * subscribe a Kinesis stream using the integration class in the
 * `@aws-cdk/aws-logs-destinations` package; if necessary, a
 * `CrossAccountDestination` will be created automatically.
 *
 * @stability stable
 * @resource AWS::Logs::Destination
 */
export declare class CrossAccountDestination extends cdk.Resource implements ILogSubscriptionDestination {
    /**
     * Policy object of this CrossAccountDestination object.
     *
     * @stability stable
     */
    readonly policyDocument: iam.PolicyDocument;
    /**
     * The name of this CrossAccountDestination object.
     *
     * @stability stable
     * @attribute true
     */
    readonly destinationName: string;
    /**
     * The ARN of this CrossAccountDestination object.
     *
     * @stability stable
     * @attribute true
     */
    readonly destinationArn: string;
    /**
     * The inner resource
     */
    private readonly resource;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: CrossAccountDestinationProps);
    /**
     * @stability stable
     */
    addToPolicy(statement: iam.PolicyStatement): void;
    /**
     * Return the properties required to send subscription events to this destination.
     *
     * If necessary, the destination can use the properties of the SubscriptionFilter
     * object itself to configure its permissions to allow the subscription to write
     * to it.
     *
     * The destination may reconfigure its own permissions in response to this
     * function call.
     *
     * @stability stable
     */
    bind(_scope: cdk.Construct, _sourceLogGroup: ILogGroup): LogSubscriptionDestinationConfig;
    /**
     * Generate a unique Destination name in case the user didn't supply one
     */
    private generateUniqueName;
    /**
     * Return a stringified JSON version of the PolicyDocument
     */
    private lazyStringifiedPolicyDocument;
}
