import * as iam from '@aws-cdk/aws-iam';
import * as cdk from '@aws-cdk/core';
import { Construct } from 'constructs';
import { RetentionDays } from './log-group';
/**
 * Construction properties for a LogRetention.
 *
 * @stability stable
 */
export interface LogRetentionProps {
    /**
     * The log group name.
     *
     * @stability stable
     */
    readonly logGroupName: string;
    /**
     * The region where the log group should be created.
     *
     * @default - same region as the stack
     * @stability stable
     */
    readonly logGroupRegion?: string;
    /**
     * The number of days log events are kept in CloudWatch Logs.
     *
     * @stability stable
     */
    readonly retention: RetentionDays;
    /**
     * The IAM role for the Lambda function associated with the custom resource.
     *
     * @default - A new role is created
     * @stability stable
     */
    readonly role?: iam.IRole;
    /**
     * Retry options for all AWS API calls.
     *
     * @default - AWS SDK default retry options
     * @stability stable
     */
    readonly logRetentionRetryOptions?: LogRetentionRetryOptions;
}
/**
 * Retry options for all AWS API calls.
 *
 * @stability stable
 */
export interface LogRetentionRetryOptions {
    /**
     * The maximum amount of retries.
     *
     * @default 3 (AWS SDK default)
     * @stability stable
     */
    readonly maxRetries?: number;
    /**
     * The base duration to use in the exponential backoff for operation retries.
     *
     * @default Duration.millis(100) (AWS SDK default)
     * @stability stable
     */
    readonly base?: cdk.Duration;
}
/**
 * Creates a custom resource to control the retention policy of a CloudWatch Logs log group.
 *
 * The log group is created if it doesn't already exist. The policy
 * is removed when `retentionDays` is `undefined` or equal to `Infinity`.
 * Log group can be created in the region that is different from stack region by
 * specifying `logGroupRegion`
 *
 * @stability stable
 */
export declare class LogRetention extends cdk.Construct {
    /**
     * The ARN of the LogGroup.
     *
     * @stability stable
     */
    readonly logGroupArn: string;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: LogRetentionProps);
    /**
     * Helper method to ensure that only one instance of LogRetentionFunction resources are in the stack mimicking the
     * behaviour of @aws-cdk/aws-lambda's SingletonFunction to prevent circular dependencies
     */
    private ensureSingletonLogRetentionFunction;
}
