from alira.instance import Instance
from alira.modules.module import Module


class Map(Module):
    def __init__(
        self,
        function: str = None,
        **kwargs,
    ):
        super().__init__(
            module_id=function,
            **kwargs,
        )

        self.function = function

    def run(self, instance: Instance):
        fn = self._load_function(self.function)
        if fn is None:
            raise RuntimeError(f"Unable to load function {self.function}")

        result = fn(instance=instance)

        if not isinstance(result, dict):
            raise RuntimeError("The result of the map operation must be a dictionary")

        return result
