# cartotool-cartotool_dev
Cartotool api project for using the cartotool.com application with Python scripts

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.4
- Package version: 1.0.4
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [http://cartotool.com](http://cartotool.com)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import cartotool
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import cartotool
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import cartotool
from cartotool.rest import ApiException
from pprint import pprint


# Defining host is optional and default to http://cartotool.com
configuration.host = "http://cartotool.com"
# Enter a context with an instance of the API client
with cartotool.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cartotool.DataCellControllerApi(api_client)
    code = 'code_example' # str | 
data_cell_form = [cartotool.DataCellForm()] # list[DataCellForm] | 

    try:
        api_response = api_instance.create_data(code, data_cell_form)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling DataCellControllerApi->create_data: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *http://cartotool.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DataCellControllerApi* | [**create_data**](docs/DataCellControllerApi.md#create_data) | **POST** /api/collections/{code}/data | 
*DataCellControllerApi* | [**get_field**](docs/DataCellControllerApi.md#get_field) | **GET** /api/collections/{code}/data/{row}/{col} | 
*DataCellControllerApi* | [**get_row**](docs/DataCellControllerApi.md#get_row) | **GET** /api/collections/{code}/data/{row} | 
*DataCellControllerApi* | [**get_table**](docs/DataCellControllerApi.md#get_table) | **GET** /api/collections/{code}/data | 
*DataCollectionControllerApi* | [**create_collection**](docs/DataCollectionControllerApi.md#create_collection) | **POST** /api/collections | 
*DataCollectionControllerApi* | [**delete_by_code**](docs/DataCollectionControllerApi.md#delete_by_code) | **DELETE** /api/collections/{code} | 
*DataCollectionControllerApi* | [**find_all**](docs/DataCollectionControllerApi.md#find_all) | **GET** /api/collections | 
*DataCollectionControllerApi* | [**find_by_code**](docs/DataCollectionControllerApi.md#find_by_code) | **GET** /api/collections/{code} | 
*DataCollectionControllerApi* | [**find_data_collection_by_code**](docs/DataCollectionControllerApi.md#find_data_collection_by_code) | **GET** /api/collections/{code}/layers | 
*DataTileControllerApi* | [**get_tile**](docs/DataTileControllerApi.md#get_tile) | **GET** /api/collections/{code}/tile/{z}/{x}/{y} | 
*IconControllerApi* | [**find_all1**](docs/IconControllerApi.md#find_all1) | **GET** /api/icons | 
*IconControllerApi* | [**find_all_by_key**](docs/IconControllerApi.md#find_all_by_key) | **GET** /api/icons/{key}.svg | 
*LayerBitmapControllerApi* | [**get_tiles**](docs/LayerBitmapControllerApi.md#get_tiles) | **GET** /api/layers-bitmap/{code}/tiles/{z}/{x}/{y} | 
*LayerBitmapControllerApi* | [**post**](docs/LayerBitmapControllerApi.md#post) | **POST** /api/layers-bitmap | 
*LayerBitmapControllerApi* | [**put**](docs/LayerBitmapControllerApi.md#put) | **PUT** /api/layers-bitmap/{code} | 
*LayerBitmapControllerApi* | [**upload_chunk**](docs/LayerBitmapControllerApi.md#upload_chunk) | **POST** /api/layers-bitmap/{code}/chunk | 
*LayerBitmapControllerApi* | [**upload_complete**](docs/LayerBitmapControllerApi.md#upload_complete) | **POST** /api/layers-bitmap/{code}/complete | 
*LayerControllerApi* | [**delete**](docs/LayerControllerApi.md#delete) | **DELETE** /api/layers/{code} | 
*LayerControllerApi* | [**find_all2**](docs/LayerControllerApi.md#find_all2) | **GET** /api/layers | 
*LayerControllerApi* | [**find_by_code1**](docs/LayerControllerApi.md#find_by_code1) | **GET** /api/layers/{code} | 
*LayerControllerApi* | [**move**](docs/LayerControllerApi.md#move) | **POST** /api/layers/{code}/move | 
*LayerGroupControllerApi* | [**delete1**](docs/LayerGroupControllerApi.md#delete1) | **DELETE** /api/layer-groups/{id} | 
*LayerGroupControllerApi* | [**find_all3**](docs/LayerGroupControllerApi.md#find_all3) | **GET** /api/layer-groups | 
*LayerGroupControllerApi* | [**post1**](docs/LayerGroupControllerApi.md#post1) | **POST** /api/layer-groups | 
*LayerGroupControllerApi* | [**put1**](docs/LayerGroupControllerApi.md#put1) | **PUT** /api/layer-groups/{id} | 
*LayerLinkedControllerApi* | [**post2**](docs/LayerLinkedControllerApi.md#post2) | **POST** /api/layers-linked | 
*LayerLinkedControllerApi* | [**put2**](docs/LayerLinkedControllerApi.md#put2) | **PUT** /api/layers-linked/{code} | 
*LayerTmsControllerApi* | [**post3**](docs/LayerTmsControllerApi.md#post3) | **POST** /api/layers-tms | 
*LayerTmsControllerApi* | [**put3**](docs/LayerTmsControllerApi.md#put3) | **PUT** /api/layers-tms/{code} | 
*LayerVectorControllerApi* | [**post4**](docs/LayerVectorControllerApi.md#post4) | **POST** /api/layers-vector | 
*LayerVectorControllerApi* | [**put4**](docs/LayerVectorControllerApi.md#put4) | **PUT** /api/layers-vector/{code} | 
*LayerWmsControllerApi* | [**post5**](docs/LayerWmsControllerApi.md#post5) | **POST** /api/layers-wms | 
*LayerWmsControllerApi* | [**put5**](docs/LayerWmsControllerApi.md#put5) | **PUT** /api/layers-wms/{code} | 
*MapControllerApi* | [**find_all4**](docs/MapControllerApi.md#find_all4) | **GET** /api/map/layers | 
*MapControllerApi* | [**find_by_code2**](docs/MapControllerApi.md#find_by_code2) | **GET** /api/map/layers/{code} | 
*ProjectControllerApi* | [**delete_project**](docs/ProjectControllerApi.md#delete_project) | **DELETE** /api/projects/{projectCode} | 
*ProjectControllerApi* | [**get_project**](docs/ProjectControllerApi.md#get_project) | **GET** /api/projects/{projectCode} | 
*ProjectControllerApi* | [**get_projects**](docs/ProjectControllerApi.md#get_projects) | **GET** /api/projects | 
*ProjectControllerApi* | [**post_projects**](docs/ProjectControllerApi.md#post_projects) | **POST** /api/projects | 
*ProjectControllerApi* | [**update_project**](docs/ProjectControllerApi.md#update_project) | **PUT** /api/projects/{projectCode} | 
*StoryControllerApi* | [**delete2**](docs/StoryControllerApi.md#delete2) | **DELETE** /api/stories/{storyCode} | 
*StoryControllerApi* | [**find_all5**](docs/StoryControllerApi.md#find_all5) | **GET** /api/stories | 
*StoryControllerApi* | [**get_story**](docs/StoryControllerApi.md#get_story) | **GET** /api/stories/{storyCode} | 
*StoryControllerApi* | [**post6**](docs/StoryControllerApi.md#post6) | **POST** /api/stories | 
*StoryControllerApi* | [**put6**](docs/StoryControllerApi.md#put6) | **PUT** /api/stories/{storyCode} | 
*UserAccountControllerApi* | [**find_all_accounts**](docs/UserAccountControllerApi.md#find_all_accounts) | **GET** /api/user-accounts | 
*UserAccountControllerApi* | [**generate_key**](docs/UserAccountControllerApi.md#generate_key) | **POST** /api/user-accounts/generate-key | 
*UserAccountControllerApi* | [**reset_password_with_reset_code**](docs/UserAccountControllerApi.md#reset_password_with_reset_code) | **PUT** /api/user-accounts/reset-password | 
*UserAccountControllerApi* | [**revoke_account_key**](docs/UserAccountControllerApi.md#revoke_account_key) | **POST** /api/user-accounts/revoke-key | 
*UserAuthorityControllerApi* | [**find_me_user_authority**](docs/UserAuthorityControllerApi.md#find_me_user_authority) | **GET** /api/authorities | 
*UserControllerApi* | [**create_user**](docs/UserControllerApi.md#create_user) | **POST** /api/users | 
*UserControllerApi* | [**delete_user1**](docs/UserControllerApi.md#delete_user1) | **DELETE** /api/users/{code} | 
*UserControllerApi* | [**find_all_users**](docs/UserControllerApi.md#find_all_users) | **GET** /api/users | 
*UserControllerApi* | [**find_all_users_by_codes**](docs/UserControllerApi.md#find_all_users_by_codes) | **POST** /api/users/search | 
*UserControllerApi* | [**find_me_user**](docs/UserControllerApi.md#find_me_user) | **GET** /api/users/me | 
*UserControllerApi* | [**find_me_user_accounts**](docs/UserControllerApi.md#find_me_user_accounts) | **GET** /api/users/me/accounts | 
*UserControllerApi* | [**find_user_by_id**](docs/UserControllerApi.md#find_user_by_id) | **GET** /api/users/{code} | 
*UserControllerApi* | [**generate_user_reset_code**](docs/UserControllerApi.md#generate_user_reset_code) | **PUT** /api/users/reset-password | 
*UserControllerApi* | [**generate_user_reset_code_for_user_code**](docs/UserControllerApi.md#generate_user_reset_code_for_user_code) | **PUT** /api/users/{code}/reset-password | 
*UserControllerApi* | [**update_user**](docs/UserControllerApi.md#update_user) | **PUT** /api/users/{code} | 
*UserGroupControllerApi* | [**create_user_group**](docs/UserGroupControllerApi.md#create_user_group) | **POST** /api/user-groups | 
*UserGroupControllerApi* | [**delete_user_group**](docs/UserGroupControllerApi.md#delete_user_group) | **DELETE** /api/user-groups/{code} | 
*UserGroupControllerApi* | [**find_all_user_groups**](docs/UserGroupControllerApi.md#find_all_user_groups) | **GET** /api/user-groups | 
*UserGroupControllerApi* | [**find_user_group_by_id**](docs/UserGroupControllerApi.md#find_user_group_by_id) | **GET** /api/user-groups/{code} | 
*UserGroupControllerApi* | [**update_user_group**](docs/UserGroupControllerApi.md#update_user_group) | **PUT** /api/user-groups/{code} | 
*UserStatusControllerApi* | [**index**](docs/UserStatusControllerApi.md#index) | **GET** /login/status | 
*WorkspaceControllerApi* | [**delete3**](docs/WorkspaceControllerApi.md#delete3) | **DELETE** /api/workspaces/{code} | 
*WorkspaceControllerApi* | [**delete_user**](docs/WorkspaceControllerApi.md#delete_user) | **DELETE** /api/workspaces/{workspaceCode}/users/{userCode} | 
*WorkspaceControllerApi* | [**get**](docs/WorkspaceControllerApi.md#get) | **GET** /api/workspaces/{code} | 
*WorkspaceControllerApi* | [**get_all**](docs/WorkspaceControllerApi.md#get_all) | **GET** /api/workspaces | 
*WorkspaceControllerApi* | [**get_projects1**](docs/WorkspaceControllerApi.md#get_projects1) | **GET** /api/workspaces/{code}/projects | 
*WorkspaceControllerApi* | [**get_users**](docs/WorkspaceControllerApi.md#get_users) | **GET** /api/workspaces/{code}/users | 
*WorkspaceControllerApi* | [**post7**](docs/WorkspaceControllerApi.md#post7) | **POST** /api/workspaces | 
*WorkspaceControllerApi* | [**post_user**](docs/WorkspaceControllerApi.md#post_user) | **POST** /api/workspaces/{workspaceCode}/users | 


## Documentation For Models

 - [DataCellForm](docs/DataCellForm.md)
 - [DataCollection](docs/DataCollection.md)
 - [DataCollectionForm](docs/DataCollectionForm.md)
 - [DataCollectionGeometry](docs/DataCollectionGeometry.md)
 - [InlineObject](docs/InlineObject.md)
 - [KeyRevokeForm](docs/KeyRevokeForm.md)
 - [Layer](docs/Layer.md)
 - [LayerBitmap](docs/LayerBitmap.md)
 - [LayerBitmapForm](docs/LayerBitmapForm.md)
 - [LayerDashboard](docs/LayerDashboard.md)
 - [LayerGroup](docs/LayerGroup.md)
 - [LayerGroupForm](docs/LayerGroupForm.md)
 - [LayerLinkedForm](docs/LayerLinkedForm.md)
 - [LayerMoveForm](docs/LayerMoveForm.md)
 - [LayerStylePoint](docs/LayerStylePoint.md)
 - [LayerStylePolygon](docs/LayerStylePolygon.md)
 - [LayerTMSForm](docs/LayerTMSForm.md)
 - [LayerVectorForm](docs/LayerVectorForm.md)
 - [LayerWmsForm](docs/LayerWmsForm.md)
 - [LayerWrapper](docs/LayerWrapper.md)
 - [Pageable](docs/Pageable.md)
 - [PasswordResetForm](docs/PasswordResetForm.md)
 - [Project](docs/Project.md)
 - [ProjectForm](docs/ProjectForm.md)
 - [ProjectImage](docs/ProjectImage.md)
 - [RequestPasswordReset](docs/RequestPasswordReset.md)
 - [Status](docs/Status.md)
 - [Story](docs/Story.md)
 - [StoryForm](docs/StoryForm.md)
 - [User](docs/User.md)
 - [UserAccount](docs/UserAccount.md)
 - [UserAccountKey](docs/UserAccountKey.md)
 - [UserAccountKeyAllOf](docs/UserAccountKeyAllOf.md)
 - [UserForm](docs/UserForm.md)
 - [UserGroup](docs/UserGroup.md)
 - [UserGroupForm](docs/UserGroupForm.md)
 - [UserKeyForm](docs/UserKeyForm.md)
 - [Workspace](docs/Workspace.md)
 - [WorkspaceForm](docs/WorkspaceForm.md)
 - [WorkspaceUser](docs/WorkspaceUser.md)
 - [WorkspaceUserForm](docs/WorkspaceUserForm.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author

info@cartotool.com


