# -*- coding: utf-8 -*-
# Copyright 2011-2022 Rumma & Ko Ltd
# License: GNU Affero General Public License v3 (see file COPYING for details)

from pathlib import Path
from rstgen import sphinxconf
from rstgen.utils import srcref_url_template
from atelier.projects import get_project_from_path
import atelier
import rstgen


def configure(globals_dict, project=None, **kwargs):

    docs_root = Path(globals_dict['__file__']).parent.absolute()
    if project is None:
        project = get_project_from_path(docs_root.parent)
    atelier.current_project = project
    project.load_info()

    rstgen.set_config_var(public_url= project.get_public_docs_url('docs'))
    rstgen.set_config_var(use_dirhtml=project.get_xconfig('use_dirhtml'))

    sphinxconf.configure(globals_dict, **kwargs)

    globals_dict['html_context'].update(SETUP_INFO=project.SETUP_INFO)

    version = project.SETUP_INFO.get('version', None)
    if version:
        globals_dict.update(release=version)
        globals_dict.update(version='.'.join(version.split('.')[:2]))

    if 'name' in project.SETUP_INFO:
        globals_dict['extensions'] += [
            'sphinx.ext.autodoc', 'sphinx.ext.autosummary']

    if project.main_package:
        root_mod, tpl = srcref_url_template(project.main_package)
        if tpl:
            globals_dict['extlinks'].update(srcref=(tpl, ''))
