#    Copyright 2020-2022 AIBharata Emerging Technologies Pvt. Ltd.

#    Licensed under the Apache License, Version 2.0 (the "License");
#    you may not use this file except in compliance with the License.
#    You may obtain a copy of the License at

#        http://www.apache.org/licenses/LICENSE-2.0

#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS,
#    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#    See the License for the specific language governing permissions and
#    limitations under the License.
from __future__ import absolute_import
import pandas as pd
import numpy as np
from PIL import Image
import os
from albumentations import Compose

class aiDataLoader(object):
    """Base class for aiDataLoader.
    """
    def __call__(self, targetDim, color_mode,class_mode, batch_size,shuffle,seed,augmentations, **kwargs):
        return self.call(targetDim, color_mode,class_mode, batch_size,shuffle,seed,augmentations, **kwargs)

    def call(self, targetDim, color_mode,class_mode, batch_size,shuffle,seed,augmentations, **kwargs):
        raise NotImplementedError()

    def __str__(self):
        return self.__class__.__name__