# Signald python bindings

Most of the content here is generated by `util/generate_api.py` that uses
the output of the 'protocol' request of the [signald](https://gitlab.com/signald/signald) [API](https://docs.signald.org/).

Since this output is incomplete, a few manual additions are present in `pysignald_async/api.py`.

## Install

`pip install pysignald-async`

## Usage

An example can be found in [this signal/XMPP gateway](https://gitlab.com/nicocool84/spectrum2_signald/-/blob/master/spectrum2_signald/signald.py).


```py
import asyncio

from pysignald_async import SignaldAPI

async def main():
    loop = asyncio.get_running_loop()
    _, signald = await loop.create_unix_connection(
        SignaldAPI, path=SIGNALD_SOCKET_PATH)
    await signald.register(username="+XXXXXX")
    # Some async code to get the SMS code
    await signald.verify(username="+XXXXXX", code=code)
    await signald.on_con_lost

SIGNALD_SOCKET_PATH = "/var/run/signald/signald.sock"

asyncio.run(main())

```

`TODO: Write a better README`
