import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [vendor-insights](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplacevendorinsights.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class VendorInsights extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [vendor-insights](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplacevendorinsights.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to activate the security profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-security-iam-config-vend-insights.html
     */
    toActivateSecurityProfile(): this;
    /**
     * Grants permission to associate security profile with a data source
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - vendor-insights:GetDataSource
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-security-iam-config-vend-insights.html
     */
    toAssociateDataSource(): this;
    /**
     * Grants permission to create a new data source
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-security-iam-config-vend-insights.html
     */
    toCreateDataSource(): this;
    /**
     * Grants permission to create a new security profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-security-iam-config-vend-insights.html
     */
    toCreateSecurityProfile(): this;
    /**
     * Grants permission to deactivate the security profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-security-iam-config-vend-insights.html
     */
    toDeactivateSecurityProfile(): this;
    /**
     * Grants permission to delete a data source
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-security-iam-config-vend-insights.html
     */
    toDeleteDataSource(): this;
    /**
     * Grants permission to disassociate security profile from a data source
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - vendor-insights:GetDataSource
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-security-iam-config-vend-insights.html
     */
    toDisassociateDataSource(): this;
    /**
     * Grants permission to retrieve the details of an existing data source
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-security-iam-config-vend-insights.html
     */
    toGetDataSource(): this;
    /**
     * Grants permission to return the details of a security profile snapshot that requester is entitled to read
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-security-iam-config-vend-insights.html
     */
    toGetEntitledSecurityProfileSnapshot(): this;
    /**
     * Grants permission to get the access terms for a vendor insights profile
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-security-iam-config-vend-insights.html
     */
    toGetProfileAccessTerms(): this;
    /**
     * Grants permission to return the details of an existing security profile
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-security-iam-config-vend-insights.html
     */
    toGetSecurityProfile(): this;
    /**
     * Grants permission to return the details of a security profile snapshot
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-security-iam-config-vend-insights.html
     */
    toGetSecurityProfileSnapshot(): this;
    /**
     * Grants permission to list existing data sources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-security-iam-config-vend-insights.html
     */
    toListDataSources(): this;
    /**
     * Grants permission to return the snapshot summary list for an existing security profile that requester is entitled to list
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-security-iam-config-vend-insights.html
     */
    toListEntitledSecurityProfileSnapshots(): this;
    /**
     * Grants permission to list entitled security profiles
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-security-iam-config-vend-insights.html
     */
    toListEntitledSecurityProfiles(): this;
    /**
     * Grants permission to return the snapshot summary list for an existing security profile
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-security-iam-config-vend-insights.html
     */
    toListSecurityProfileSnapshots(): this;
    /**
     * Grants permission to list existing security profiles
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-security-iam-config-vend-insights.html
     */
    toListSecurityProfiles(): this;
    /**
     * Grants permission to update the security profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-security-iam-config-vend-insights.html
     */
    toUpdateSecurityProfile(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type DataSource to the statement
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-security-iam-config-vend-insights.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onDataSource(resourceId: string, partition?: string): this;
    /**
     * Adds a resource of type SecurityProfile to the statement
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-security-iam-config-vend-insights.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onSecurityProfile(resourceId: string, partition?: string): this;
}
