"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PrivateNetworks = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [private-networks](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsserviceprovidingmanagedprivatenetworks.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class PrivateNetworks extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [private-networks](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsserviceprovidingmanagedprivatenetworks.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'private-networks';
        this.accessLevelList = {
            Write: [
                'AcknowledgeOrderReceipt',
                'ActivateDeviceIdentifier',
                'ActivateNetworkSite',
                'ConfigureAccessPoint',
                'CreateNetwork',
                'CreateNetworkSite',
                'DeactivateDeviceIdentifier',
                'DeleteNetwork',
                'DeleteNetworkSite',
                'UpdateNetworkSite',
                'UpdateNetworkSitePlan'
            ],
            Read: [
                'GetDeviceIdentifier',
                'GetNetwork',
                'GetNetworkResource',
                'GetNetworkSite',
                'GetOrder'
            ],
            List: [
                'ListDeviceIdentifiers',
                'ListNetworkResources',
                'ListNetworkSites',
                'ListNetworks',
                'ListOrders'
            ]
        };
    }
    /**
     * Grants permission to acknowledge that an order has been received
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_AcknowledgeOrderReceipt.html
     */
    toAcknowledgeOrderReceipt() {
        return this.to('AcknowledgeOrderReceipt');
    }
    /**
     * Grants permission to activate a device identifier
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_ActivateDeviceIdentifier.html
     */
    toActivateDeviceIdentifier() {
        return this.to('ActivateDeviceIdentifier');
    }
    /**
     * Grants permission to activate a network site
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_ActivateNetworkSite.html
     */
    toActivateNetworkSite() {
        return this.to('ActivateNetworkSite');
    }
    /**
     * Grants permission to configure an access point
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_ConfigureAccessPoint.html
     */
    toConfigureAccessPoint() {
        return this.to('ConfigureAccessPoint');
    }
    /**
     * Grants permission to create a network
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_CreateNetwork.html
     */
    toCreateNetwork() {
        return this.to('CreateNetwork');
    }
    /**
     * Grants permission to create a network site
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_CreateNetworkSite.html
     */
    toCreateNetworkSite() {
        return this.to('CreateNetworkSite');
    }
    /**
     * Grants permission to deactivate a device identifier
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_DeactivateDeviceIdentifier.html
     */
    toDeactivateDeviceIdentifier() {
        return this.to('DeactivateDeviceIdentifier');
    }
    /**
     * Grants permission to delete a network
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_DeleteNetwork.html
     */
    toDeleteNetwork() {
        return this.to('DeleteNetwork');
    }
    /**
     * Grants permission to delete a network site
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_DeleteNetworkSite.html
     */
    toDeleteNetworkSite() {
        return this.to('DeleteNetworkSite');
    }
    /**
     * Grants permission to get a device identifier
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_GetDeviceIdentifier.html
     */
    toGetDeviceIdentifier() {
        return this.to('GetDeviceIdentifier');
    }
    /**
     * Grants permission to get a network
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_GetNetwork.html
     */
    toGetNetwork() {
        return this.to('GetNetwork');
    }
    /**
     * Grants permission to get a network resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_GetNetworkResource.html
     */
    toGetNetworkResource() {
        return this.to('GetNetworkResource');
    }
    /**
     * Grants permission to get a network site
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_GetNetworkSite.html
     */
    toGetNetworkSite() {
        return this.to('GetNetworkSite');
    }
    /**
     * Grants permission to get a network order
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_GetOrder.html
     */
    toGetOrder() {
        return this.to('GetOrder');
    }
    /**
     * Grants permission to list device identifiers
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_ListDeviceIdentifiers.html
     */
    toListDeviceIdentifiers() {
        return this.to('ListDeviceIdentifiers');
    }
    /**
     * Grants permission to list network resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_ListNetworkResources.html
     */
    toListNetworkResources() {
        return this.to('ListNetworkResources');
    }
    /**
     * Grants permission to list network sites
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_ListNetworkSites.html
     */
    toListNetworkSites() {
        return this.to('ListNetworkSites');
    }
    /**
     * Grants permission to list networks
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_ListNetworks.html
     */
    toListNetworks() {
        return this.to('ListNetworks');
    }
    /**
     * Grants permission to list network orders
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_ListOrders.html
     */
    toListOrders() {
        return this.to('ListOrders');
    }
    /**
     * Grants permission to update a network site
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_UpdateNetworkSite.html
     */
    toUpdateNetworkSite() {
        return this.to('UpdateNetworkSite');
    }
    /**
     * Grants permission to update a plan at a network site
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/private-networks/latest/APIReference/API_UpdateNetworkSitePlan.html
     */
    toUpdateNetworkSitePlan() {
        return this.to('UpdateNetworkSitePlan');
    }
    /**
     * Adds a resource of type network to the statement
     *
     * https://docs.aws.amazon.com/private-networks/latest/userguide/identity-access-management.html
     *
     * @param networkName - Identifier for the networkName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onNetwork(networkName, account, region, partition) {
        return this.on(`arn:${partition || PrivateNetworks.defaultPartition}:private-networks:${region || '*'}:${account || '*'}:network/${networkName}`);
    }
    /**
     * Adds a resource of type network-site to the statement
     *
     * https://docs.aws.amazon.com/private-networks/latest/userguide/identity-access-management.html
     *
     * @param networkName - Identifier for the networkName.
     * @param networkSiteName - Identifier for the networkSiteName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onNetworkSite(networkName, networkSiteName, account, region, partition) {
        return this.on(`arn:${partition || PrivateNetworks.defaultPartition}:private-networks:${region || '*'}:${account || '*'}:network-site/${networkName}/${networkSiteName}`);
    }
    /**
     * Adds a resource of type network-resource to the statement
     *
     * https://docs.aws.amazon.com/private-networks/latest/userguide/identity-access-management.html
     *
     * @param networkName - Identifier for the networkName.
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onNetworkResource(networkName, resourceId, account, region, partition) {
        return this.on(`arn:${partition || PrivateNetworks.defaultPartition}:private-networks:${region || '*'}:${account || '*'}:network-resource/${networkName}/${resourceId}`);
    }
    /**
     * Adds a resource of type order to the statement
     *
     * https://docs.aws.amazon.com/private-networks/latest/userguide/identity-access-management.html
     *
     * @param networkName - Identifier for the networkName.
     * @param orderId - Identifier for the orderId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onOrder(networkName, orderId, account, region, partition) {
        return this.on(`arn:${partition || PrivateNetworks.defaultPartition}:private-networks:${region || '*'}:${account || '*'}:order/${networkName}/${orderId}`);
    }
    /**
     * Adds a resource of type device-identifier to the statement
     *
     * https://docs.aws.amazon.com/private-networks/latest/userguide/identity-access-management.html
     *
     * @param networkName - Identifier for the networkName.
     * @param deviceId - Identifier for the deviceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onDeviceIdentifier(networkName, deviceId, account, region, partition) {
        return this.on(`arn:${partition || PrivateNetworks.defaultPartition}:private-networks:${region || '*'}:${account || '*'}:device-identifier/${networkName}/${deviceId}`);
    }
}
exports.PrivateNetworks = PrivateNetworks;
_a = JSII_RTTI_SYMBOL_1;
PrivateNetworks[_a] = { fqn: "iam-floyd.PrivateNetworks", version: "0.458.0" };
//# sourceMappingURL=data:application/json;base64,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