"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.JobDefinitionImageConfig = void 0;
const ecs = require("@aws-cdk/aws-ecs");
const iam = require("@aws-cdk/aws-iam");
/**
 * Batch Job Task Definition
 *
 * Defines a Batch Job Task Definition. The properties of this task definition mirrors
 * those of an {@link ecs.ContainerDefinition}. This class is a wrapper on that structure.
 */
class TaskDefinition {
    constructor(props) {
        this.executionRole = props.executionRole;
    }
    /**
     * Internal function to allow the Batch Job task defintion
     * to match the CDK requirements of an EC2 task definition.
     *
     * @internal
     */
    _linkContainer() { }
    /**
     * Retrieves the execution role for this task definition
     */
    obtainExecutionRole() {
        return this.executionRole;
    }
}
/**
 * The configuration for creating a batch container image.
 */
class JobDefinitionImageConfig {
    constructor(scope, container) {
        const config = this.bindImageConfig(scope, container);
        this.imageName = config.imageName;
    }
    bindImageConfig(scope, container) {
        return container.image.bind(scope, new ecs.ContainerDefinition(scope, 'Resource-Batch-Job-Container-Definition', {
            command: container.command,
            cpu: container.vcpus,
            image: container.image,
            environment: container.environment,
            linuxParameters: container.linuxParams,
            memoryLimitMiB: container.memoryLimitMiB,
            privileged: container.privileged,
            readonlyRootFilesystem: container.readOnly,
            gpuCount: container.gpuCount,
            user: container.user,
            taskDefinition: new TaskDefinition({
                executionRole: container.jobRole || new iam.LazyRole(scope, 'Resource-Batch-Task-Definition-Role', {
                    assumedBy: new iam.ServicePrincipal('batch.amazonaws.com'),
                }),
            }),
        }));
    }
}
exports.JobDefinitionImageConfig = JobDefinitionImageConfig;
//# sourceMappingURL=data:application/json;base64,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