"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const assert_1 = require("@aws-cdk/assert");
require("@aws-cdk/assert/jest");
const cdk = require("@aws-cdk/core");
const batch = require("../lib");
describe('Batch Job Queue', () => {
    let stack;
    let computeEnvironment;
    beforeEach(() => {
        stack = new cdk.Stack();
        computeEnvironment = new batch.ComputeEnvironment(stack, 'test-compute-env', {
            managed: false,
        });
    });
    it('can be imported from an ARN', () => {
        // WHEN
        const existingJobQ = new batch.JobQueue(stack, 'test-job-queue', {
            priority: 1,
            enabled: false,
            computeEnvironments: [
                {
                    computeEnvironment,
                    order: 1,
                },
            ],
        });
        const jobQFromArn = batch.JobQueue.fromJobQueueArn(stack, 'test-job-queue-from-arn', existingJobQ.jobQueueArn);
        // THEN
        expect(jobQFromArn.jobQueueArn).toEqual(existingJobQ.jobQueueArn);
    });
    it('renders the correct CloudFormation properties', () => {
        // WHEN
        const props = {
            priority: 1,
            enabled: false,
            computeEnvironments: [
                {
                    computeEnvironment,
                    order: 1,
                },
            ],
            jobQueueName: 'test-job-queue-name',
        };
        new batch.JobQueue(stack, 'test-job-queue', props);
        // THEN
        expect(stack).toHaveResourceLike('AWS::Batch::JobQueue', {
            JobQueueName: props.jobQueueName,
            State: props.enabled ? 'ENABLED' : 'DISABLED',
            Priority: props.priority,
            ComputeEnvironmentOrder: [
                {
                    ComputeEnvironment: {
                        Ref: 'testcomputeenv547FFD1A',
                    },
                    Order: 1,
                },
            ],
        }, assert_1.ResourcePart.Properties);
    });
    it('should have a default queue priority of 1', () => {
        // WHEN
        new batch.JobQueue(stack, 'test-job-queue', {
            enabled: false,
            computeEnvironments: [
                {
                    computeEnvironment,
                    order: 1,
                },
            ],
        });
        // THEN
        expect(stack).toHaveResourceLike('AWS::Batch::JobQueue', {
            Priority: 1,
        }, assert_1.ResourcePart.Properties);
    });
});
//# sourceMappingURL=data:application/json;base64,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