# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['volttron', 'volttron.driver.interfaces.fake']

package_data = \
{'': ['*']}

install_requires = \
['volttron-lib-base-driver>=0.1.1a3,<0.2.0']

setup_kwargs = {
    'name': 'volttron-lib-fake-driver',
    'version': '0.1.1a6',
    'description': 'Fake Driver supported and maintained by the Volttron team.',
    'long_description': '# volttron-lib-fake-driver\n\n![Passing?](https://github.com/VOLTTRON/volttron-lib-fake-driver/actions/workflows/run-tests.yml/badge.svg)\n[![pypi version](https://img.shields.io/pypi/v/volttron-lib-fake-driver.svg)](https://pypi.org/project/volttron-lib-fake-driver/)\n\nThe FakeDriver is a way to quickly see data published to the message bus in a format that mimics what a true Driver would produce. This is an extremely simple implementation of the [VOLTTRON driver framework](https://volttron.readthedocs.io/en/develop/agent-framework/driver-framework/drivers-overview.html#driver-framework). This driver does not connect to any actual device and instead produces random and or pre-configured values.\n\n# Prerequisites\n\n* Python 3.8\n\n## Python\n\n<details>\n<summary>To install Python 3.8, we recommend using <a href="https://github.com/pyenv/pyenv"><code>pyenv</code></a>.</summary>\n\n```bash\n# install pyenv\ngit clone https://github.com/pyenv/pyenv ~/.pyenv\n\n# setup pyenv (you should also put these three lines in .bashrc or similar)\nexport PATH="${HOME}/.pyenv/bin:${PATH}"\nexport PYENV_ROOT="${HOME}/.pyenv"\neval "$(pyenv init -)"\n\n# install Python 3.8\npyenv install 3.8.10\n\n# make it available globally\npyenv global system 3.8.10\n```\n</details>\n\n# Installation\n\n1. Create and activate a virtual environment.\n\n```shell\npython -m venv env\nsource env/bin/activate\n```\n\n2. Install volttron and start the platform.\n\n```shell\npip install volttron\n\n# Start platform with output going to volttron.log\nvolttron -vv -l volttron.log &\n```\n\n3. Install the volttron platform driver:\n\n```shell\nvctl install volttron-platform-driver --vip-identity platform.driver --start\n```\n\n4. Install the volttron fake driver library.\n\n You have two options. You can install this library using the version on PyPi:\n\n```shell\npip install volttron-lib-fake-driver\n```\n\n5. Install a Fake Driver onto the Platform Driver.\n\nInstalling a Fake driver in the Platform Driver Agent requires adding copies of the device configuration and registry configuration files to the Platform Driver’s configuration store\n\nCreate a config directory and navigate to it:\n\n```shell\nmkdir config\ncd config\n```\n\nNavigate to the config directory and create a file called `fake.config` and add the following JSON to it:\n\n```json\n{\n    "driver_config": {},\n    "registry_config": "config://fake.csv",\n    "interval": 5,\n    "timezone": "US/Pacific",\n    "heart_beat_point": "Heartbeat",\n    "driver_type": "fake",\n    "publish_breadth_first_all": false,\n    "publish_depth_first": false,\n    "publish_breadth_first": false\n    }\n```\n\nCreate another file called `fake.csv` and add the following contents to it:\n\n```csv\nPoint Name,Volttron Point Name,Units,Units Details,Writable,Starting Value,Type,Notes\nEKG,EKG,waveform,waveform,TRUE,sin,float,Sine wave for baseline output\nHeartbeat,Heartbeat,On/Off,On/Off,TRUE,0,boolean,Point for heartbeat toggle\nOutsideAirTemperature1,OutsideAirTemperature1,F,-100 to 300,FALSE,50,float,CO2 Reading 0.00-2000.0 ppm\nSampleWritableFloat1,SampleWritableFloat1,PPM,1000.00 (default),TRUE,10,float,Setpoint to enable demand control ventilation\nSampleLong1,SampleLong1,Enumeration,1 through 13,FALSE,50,int,Status indicator of service switch\nSampleWritableShort1,SampleWritableShort1,%,0.00 to 100.00 (20 default),TRUE,20,int,Minimum damper position during the standard mode\nSampleBool1,SampleBool1,On / Off,on/off,FALSE,TRUE,boolean,Status indidcator of cooling stage 1\nSampleWritableBool1,SampleWritableBool1,On / Off,on/off,TRUE,TRUE,boolean,Status indicator\nOutsideAirTemperature2,OutsideAirTemperature2,F,-100 to 300,FALSE,50,float,CO2 Reading 0.00-2000.0 ppm\nSampleWritableFloat2,SampleWritableFloat2,PPM,1000.00 (default),TRUE,10,float,Setpoint to enable demand control ventilation\nSampleLong2,SampleLong2,Enumeration,1 through 13,FALSE,50,int,Status indicator of service switch\nSampleWritableShort2,SampleWritableShort2,%,0.00 to 100.00 (20 default),TRUE,20,int,Minimum damper position during the standard mode\nSampleBool2,SampleBool2,On / Off,on/off,FALSE,TRUE,boolean,Status indidcator of cooling stage 1\nSampleWritableBool2,SampleWritableBool2,On / Off,on/off,TRUE,TRUE,boolean,Status indicator\nOutsideAirTemperature3,OutsideAirTemperature3,F,-100 to 300,FALSE,50,float,CO2 Reading 0.00-2000.0 ppm\nSampleWritableFloat3,SampleWritableFloat3,PPM,1000.00 (default),TRUE,10,float,Setpoint to enable demand control ventilation\nSampleLong3,SampleLong3,Enumeration,1 through 13,FALSE,50,int,Status indicator of service switch\nSampleWritableShort3,SampleWritableShort3,%,0.00 to 100.00 (20 default),TRUE,20,int,Minimum damper position during the standard mode\nSampleBool3,SampleBool3,On / Off,on/off,FALSE,TRUE,boolean,Status indidcator of cooling stage 1\nSampleWritableBool3,SampleWritableBool3,On / Off,on/off,TRUE,TRUE,boolean,Status indicator\nHPWH_Phy0_PowerState,PowerState,1/0,1/0,TRUE,0,int,Power on off status\nERWH_Phy0_ValveState,ValveState,1/0,1/0,TRUE,0,int,power on off status\nEKG_Sin,EKG_Sin,1-0,SIN Wave,TRUE,sin,float,SIN wave\nEKG_Cos,EKG_Cos,1-0,COS Wave,TRUE,sin,float,COS wave\n```\n\nAdd fake.csv and fake.config to the configuration store:\n\n```\nvctl config store platform.driver devices/campus/building/fake fake.config\nvctl config store platform.driver fake.csv fake.csv --csv\n```\n\n6. Observe Data\n\nTo see data being published to the bus, install a [Listener Agent](https://pypi.org/project/volttron-listener/):\n\n```\nvctl install volttron-listener --start\n```\n\nOnce installed, you should see the data being published by viewing the Volttron logs file that was created in step 2.\nTo watch the logs, open a separate terminal and run the following command:\n\n```\ntail -f <path to folder containing volttron.log>/volttron.log\n```\n\n# Development\n\nPlease see the following for contributing guidelines [contributing](https://github.com/eclipse-volttron/volttron-core/blob/develop/CONTRIBUTING.md).\n\nPlease see the following helpful guide about [developing modular VOLTTRON agents](https://github.com/eclipse-volttron/volttron-core/blob/develop/DEVELOPING_ON_MODULAR.md)\n\n\n# Disclaimer Notice\n\nThis material was prepared as an account of work sponsored by an agency of the\nUnited States Government.  Neither the United States Government nor the United\nStates Department of Energy, nor Battelle, nor any of their employees, nor any\njurisdiction or organization that has cooperated in the development of these\nmaterials, makes any warranty, express or implied, or assumes any legal\nliability or responsibility for the accuracy, completeness, or usefulness or any\ninformation, apparatus, product, software, or process disclosed, or represents\nthat its use would not infringe privately owned rights.\n\nReference herein to any specific commercial product, process, or service by\ntrade name, trademark, manufacturer, or otherwise does not necessarily\nconstitute or imply its endorsement, recommendation, or favoring by the United\nStates Government or any agency thereof, or Battelle Memorial Institute. The\nviews and opinions of authors expressed herein do not necessarily state or\nreflect those of the United States Government or any agency thereof.\n',
    'author': 'Mark Bonicillo',
    'author_email': 'volttron@pnnl.gov',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/eclipse-volttron/volttron-lib-fake-driver',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
