# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['DashboardArgs', 'Dashboard']

@pulumi.input_type
class DashboardArgs:
    def __init__(__self__, *,
                 custom_url: pulumi.Input[str],
                 checks_per_page: Optional[pulumi.Input[int]] = None,
                 custom_domain: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 favicon: Optional[pulumi.Input[str]] = None,
                 header: Optional[pulumi.Input[str]] = None,
                 hide_tags: Optional[pulumi.Input[bool]] = None,
                 link: Optional[pulumi.Input[str]] = None,
                 logo: Optional[pulumi.Input[str]] = None,
                 paginate: Optional[pulumi.Input[bool]] = None,
                 pagination_rate: Optional[pulumi.Input[int]] = None,
                 refresh_rate: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 use_tags_and_operator: Optional[pulumi.Input[bool]] = None,
                 width: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Dashboard resource.
        :param pulumi.Input[str] custom_url: A subdomain name under 'checklyhq.com'. Needs to be unique across all users.
        :param pulumi.Input[int] checks_per_page: Determines how many checks to show per page.
        :param pulumi.Input[str] custom_domain: A custom user domain, e.g. 'status.example.com'. See the docs on updating your DNS and SSL usage.
        :param pulumi.Input[str] description: HTML <meta> description for the dashboard.
        :param pulumi.Input[str] favicon: A URL pointing to an image file to use as browser favicon.
        :param pulumi.Input[str] header: A piece of text displayed at the top of your dashboard.
        :param pulumi.Input[bool] hide_tags: Show or hide the tags on the dashboard.
        :param pulumi.Input[str] link: A link to for the dashboard logo.
        :param pulumi.Input[str] logo: A URL pointing to an image file to use for the dashboard logo.
        :param pulumi.Input[bool] paginate: Determines if pagination is on or off.
        :param pulumi.Input[int] pagination_rate: How often to trigger pagination in seconds. Possible values `30`, `60` and `300`.
        :param pulumi.Input[int] refresh_rate: How often to refresh the dashboard in seconds. Possible values `60`, '300' and `600`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of one or more tags that filter which checks to display on the dashboard.
        :param pulumi.Input[bool] use_tags_and_operator: Set when to use AND operator for fetching dashboard tags.
        :param pulumi.Input[str] width: Determines whether to use the full screen or focus in the center. Possible values `FULL` and `960PX`.
        """
        pulumi.set(__self__, "custom_url", custom_url)
        if checks_per_page is not None:
            pulumi.set(__self__, "checks_per_page", checks_per_page)
        if custom_domain is not None:
            pulumi.set(__self__, "custom_domain", custom_domain)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if favicon is not None:
            pulumi.set(__self__, "favicon", favicon)
        if header is not None:
            pulumi.set(__self__, "header", header)
        if hide_tags is not None:
            pulumi.set(__self__, "hide_tags", hide_tags)
        if link is not None:
            pulumi.set(__self__, "link", link)
        if logo is not None:
            pulumi.set(__self__, "logo", logo)
        if paginate is not None:
            pulumi.set(__self__, "paginate", paginate)
        if pagination_rate is not None:
            pulumi.set(__self__, "pagination_rate", pagination_rate)
        if refresh_rate is not None:
            pulumi.set(__self__, "refresh_rate", refresh_rate)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if use_tags_and_operator is not None:
            pulumi.set(__self__, "use_tags_and_operator", use_tags_and_operator)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter(name="customUrl")
    def custom_url(self) -> pulumi.Input[str]:
        """
        A subdomain name under 'checklyhq.com'. Needs to be unique across all users.
        """
        return pulumi.get(self, "custom_url")

    @custom_url.setter
    def custom_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "custom_url", value)

    @property
    @pulumi.getter(name="checksPerPage")
    def checks_per_page(self) -> Optional[pulumi.Input[int]]:
        """
        Determines how many checks to show per page.
        """
        return pulumi.get(self, "checks_per_page")

    @checks_per_page.setter
    def checks_per_page(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "checks_per_page", value)

    @property
    @pulumi.getter(name="customDomain")
    def custom_domain(self) -> Optional[pulumi.Input[str]]:
        """
        A custom user domain, e.g. 'status.example.com'. See the docs on updating your DNS and SSL usage.
        """
        return pulumi.get(self, "custom_domain")

    @custom_domain.setter
    def custom_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_domain", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        HTML <meta> description for the dashboard.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def favicon(self) -> Optional[pulumi.Input[str]]:
        """
        A URL pointing to an image file to use as browser favicon.
        """
        return pulumi.get(self, "favicon")

    @favicon.setter
    def favicon(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "favicon", value)

    @property
    @pulumi.getter
    def header(self) -> Optional[pulumi.Input[str]]:
        """
        A piece of text displayed at the top of your dashboard.
        """
        return pulumi.get(self, "header")

    @header.setter
    def header(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "header", value)

    @property
    @pulumi.getter(name="hideTags")
    def hide_tags(self) -> Optional[pulumi.Input[bool]]:
        """
        Show or hide the tags on the dashboard.
        """
        return pulumi.get(self, "hide_tags")

    @hide_tags.setter
    def hide_tags(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "hide_tags", value)

    @property
    @pulumi.getter
    def link(self) -> Optional[pulumi.Input[str]]:
        """
        A link to for the dashboard logo.
        """
        return pulumi.get(self, "link")

    @link.setter
    def link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "link", value)

    @property
    @pulumi.getter
    def logo(self) -> Optional[pulumi.Input[str]]:
        """
        A URL pointing to an image file to use for the dashboard logo.
        """
        return pulumi.get(self, "logo")

    @logo.setter
    def logo(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logo", value)

    @property
    @pulumi.getter
    def paginate(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if pagination is on or off.
        """
        return pulumi.get(self, "paginate")

    @paginate.setter
    def paginate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "paginate", value)

    @property
    @pulumi.getter(name="paginationRate")
    def pagination_rate(self) -> Optional[pulumi.Input[int]]:
        """
        How often to trigger pagination in seconds. Possible values `30`, `60` and `300`.
        """
        return pulumi.get(self, "pagination_rate")

    @pagination_rate.setter
    def pagination_rate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "pagination_rate", value)

    @property
    @pulumi.getter(name="refreshRate")
    def refresh_rate(self) -> Optional[pulumi.Input[int]]:
        """
        How often to refresh the dashboard in seconds. Possible values `60`, '300' and `600`.
        """
        return pulumi.get(self, "refresh_rate")

    @refresh_rate.setter
    def refresh_rate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "refresh_rate", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of one or more tags that filter which checks to display on the dashboard.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="useTagsAndOperator")
    def use_tags_and_operator(self) -> Optional[pulumi.Input[bool]]:
        """
        Set when to use AND operator for fetching dashboard tags.
        """
        return pulumi.get(self, "use_tags_and_operator")

    @use_tags_and_operator.setter
    def use_tags_and_operator(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_tags_and_operator", value)

    @property
    @pulumi.getter
    def width(self) -> Optional[pulumi.Input[str]]:
        """
        Determines whether to use the full screen or focus in the center. Possible values `FULL` and `960PX`.
        """
        return pulumi.get(self, "width")

    @width.setter
    def width(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "width", value)


@pulumi.input_type
class _DashboardState:
    def __init__(__self__, *,
                 checks_per_page: Optional[pulumi.Input[int]] = None,
                 custom_domain: Optional[pulumi.Input[str]] = None,
                 custom_url: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 favicon: Optional[pulumi.Input[str]] = None,
                 header: Optional[pulumi.Input[str]] = None,
                 hide_tags: Optional[pulumi.Input[bool]] = None,
                 link: Optional[pulumi.Input[str]] = None,
                 logo: Optional[pulumi.Input[str]] = None,
                 paginate: Optional[pulumi.Input[bool]] = None,
                 pagination_rate: Optional[pulumi.Input[int]] = None,
                 refresh_rate: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 use_tags_and_operator: Optional[pulumi.Input[bool]] = None,
                 width: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Dashboard resources.
        :param pulumi.Input[int] checks_per_page: Determines how many checks to show per page.
        :param pulumi.Input[str] custom_domain: A custom user domain, e.g. 'status.example.com'. See the docs on updating your DNS and SSL usage.
        :param pulumi.Input[str] custom_url: A subdomain name under 'checklyhq.com'. Needs to be unique across all users.
        :param pulumi.Input[str] description: HTML <meta> description for the dashboard.
        :param pulumi.Input[str] favicon: A URL pointing to an image file to use as browser favicon.
        :param pulumi.Input[str] header: A piece of text displayed at the top of your dashboard.
        :param pulumi.Input[bool] hide_tags: Show or hide the tags on the dashboard.
        :param pulumi.Input[str] link: A link to for the dashboard logo.
        :param pulumi.Input[str] logo: A URL pointing to an image file to use for the dashboard logo.
        :param pulumi.Input[bool] paginate: Determines if pagination is on or off.
        :param pulumi.Input[int] pagination_rate: How often to trigger pagination in seconds. Possible values `30`, `60` and `300`.
        :param pulumi.Input[int] refresh_rate: How often to refresh the dashboard in seconds. Possible values `60`, '300' and `600`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of one or more tags that filter which checks to display on the dashboard.
        :param pulumi.Input[bool] use_tags_and_operator: Set when to use AND operator for fetching dashboard tags.
        :param pulumi.Input[str] width: Determines whether to use the full screen or focus in the center. Possible values `FULL` and `960PX`.
        """
        if checks_per_page is not None:
            pulumi.set(__self__, "checks_per_page", checks_per_page)
        if custom_domain is not None:
            pulumi.set(__self__, "custom_domain", custom_domain)
        if custom_url is not None:
            pulumi.set(__self__, "custom_url", custom_url)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if favicon is not None:
            pulumi.set(__self__, "favicon", favicon)
        if header is not None:
            pulumi.set(__self__, "header", header)
        if hide_tags is not None:
            pulumi.set(__self__, "hide_tags", hide_tags)
        if link is not None:
            pulumi.set(__self__, "link", link)
        if logo is not None:
            pulumi.set(__self__, "logo", logo)
        if paginate is not None:
            pulumi.set(__self__, "paginate", paginate)
        if pagination_rate is not None:
            pulumi.set(__self__, "pagination_rate", pagination_rate)
        if refresh_rate is not None:
            pulumi.set(__self__, "refresh_rate", refresh_rate)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if use_tags_and_operator is not None:
            pulumi.set(__self__, "use_tags_and_operator", use_tags_and_operator)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter(name="checksPerPage")
    def checks_per_page(self) -> Optional[pulumi.Input[int]]:
        """
        Determines how many checks to show per page.
        """
        return pulumi.get(self, "checks_per_page")

    @checks_per_page.setter
    def checks_per_page(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "checks_per_page", value)

    @property
    @pulumi.getter(name="customDomain")
    def custom_domain(self) -> Optional[pulumi.Input[str]]:
        """
        A custom user domain, e.g. 'status.example.com'. See the docs on updating your DNS and SSL usage.
        """
        return pulumi.get(self, "custom_domain")

    @custom_domain.setter
    def custom_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_domain", value)

    @property
    @pulumi.getter(name="customUrl")
    def custom_url(self) -> Optional[pulumi.Input[str]]:
        """
        A subdomain name under 'checklyhq.com'. Needs to be unique across all users.
        """
        return pulumi.get(self, "custom_url")

    @custom_url.setter
    def custom_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_url", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        HTML <meta> description for the dashboard.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def favicon(self) -> Optional[pulumi.Input[str]]:
        """
        A URL pointing to an image file to use as browser favicon.
        """
        return pulumi.get(self, "favicon")

    @favicon.setter
    def favicon(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "favicon", value)

    @property
    @pulumi.getter
    def header(self) -> Optional[pulumi.Input[str]]:
        """
        A piece of text displayed at the top of your dashboard.
        """
        return pulumi.get(self, "header")

    @header.setter
    def header(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "header", value)

    @property
    @pulumi.getter(name="hideTags")
    def hide_tags(self) -> Optional[pulumi.Input[bool]]:
        """
        Show or hide the tags on the dashboard.
        """
        return pulumi.get(self, "hide_tags")

    @hide_tags.setter
    def hide_tags(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "hide_tags", value)

    @property
    @pulumi.getter
    def link(self) -> Optional[pulumi.Input[str]]:
        """
        A link to for the dashboard logo.
        """
        return pulumi.get(self, "link")

    @link.setter
    def link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "link", value)

    @property
    @pulumi.getter
    def logo(self) -> Optional[pulumi.Input[str]]:
        """
        A URL pointing to an image file to use for the dashboard logo.
        """
        return pulumi.get(self, "logo")

    @logo.setter
    def logo(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logo", value)

    @property
    @pulumi.getter
    def paginate(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if pagination is on or off.
        """
        return pulumi.get(self, "paginate")

    @paginate.setter
    def paginate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "paginate", value)

    @property
    @pulumi.getter(name="paginationRate")
    def pagination_rate(self) -> Optional[pulumi.Input[int]]:
        """
        How often to trigger pagination in seconds. Possible values `30`, `60` and `300`.
        """
        return pulumi.get(self, "pagination_rate")

    @pagination_rate.setter
    def pagination_rate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "pagination_rate", value)

    @property
    @pulumi.getter(name="refreshRate")
    def refresh_rate(self) -> Optional[pulumi.Input[int]]:
        """
        How often to refresh the dashboard in seconds. Possible values `60`, '300' and `600`.
        """
        return pulumi.get(self, "refresh_rate")

    @refresh_rate.setter
    def refresh_rate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "refresh_rate", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of one or more tags that filter which checks to display on the dashboard.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="useTagsAndOperator")
    def use_tags_and_operator(self) -> Optional[pulumi.Input[bool]]:
        """
        Set when to use AND operator for fetching dashboard tags.
        """
        return pulumi.get(self, "use_tags_and_operator")

    @use_tags_and_operator.setter
    def use_tags_and_operator(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_tags_and_operator", value)

    @property
    @pulumi.getter
    def width(self) -> Optional[pulumi.Input[str]]:
        """
        Determines whether to use the full screen or focus in the center. Possible values `FULL` and `960PX`.
        """
        return pulumi.get(self, "width")

    @width.setter
    def width(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "width", value)


class Dashboard(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 checks_per_page: Optional[pulumi.Input[int]] = None,
                 custom_domain: Optional[pulumi.Input[str]] = None,
                 custom_url: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 favicon: Optional[pulumi.Input[str]] = None,
                 header: Optional[pulumi.Input[str]] = None,
                 hide_tags: Optional[pulumi.Input[bool]] = None,
                 link: Optional[pulumi.Input[str]] = None,
                 logo: Optional[pulumi.Input[str]] = None,
                 paginate: Optional[pulumi.Input[bool]] = None,
                 pagination_rate: Optional[pulumi.Input[int]] = None,
                 refresh_rate: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 use_tags_and_operator: Optional[pulumi.Input[bool]] = None,
                 width: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_checkly as checkly

        dashboard1 = checkly.Dashboard("dashboard1",
            custom_domain="status.example.com",
            custom_url="checkly",
            header="Public dashboard",
            hide_tags=False,
            logo="https://www.checklyhq.com/logo.png",
            paginate=False,
            pagination_rate=30,
            refresh_rate=60,
            tags=["production"],
            width="FULL")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] checks_per_page: Determines how many checks to show per page.
        :param pulumi.Input[str] custom_domain: A custom user domain, e.g. 'status.example.com'. See the docs on updating your DNS and SSL usage.
        :param pulumi.Input[str] custom_url: A subdomain name under 'checklyhq.com'. Needs to be unique across all users.
        :param pulumi.Input[str] description: HTML <meta> description for the dashboard.
        :param pulumi.Input[str] favicon: A URL pointing to an image file to use as browser favicon.
        :param pulumi.Input[str] header: A piece of text displayed at the top of your dashboard.
        :param pulumi.Input[bool] hide_tags: Show or hide the tags on the dashboard.
        :param pulumi.Input[str] link: A link to for the dashboard logo.
        :param pulumi.Input[str] logo: A URL pointing to an image file to use for the dashboard logo.
        :param pulumi.Input[bool] paginate: Determines if pagination is on or off.
        :param pulumi.Input[int] pagination_rate: How often to trigger pagination in seconds. Possible values `30`, `60` and `300`.
        :param pulumi.Input[int] refresh_rate: How often to refresh the dashboard in seconds. Possible values `60`, '300' and `600`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of one or more tags that filter which checks to display on the dashboard.
        :param pulumi.Input[bool] use_tags_and_operator: Set when to use AND operator for fetching dashboard tags.
        :param pulumi.Input[str] width: Determines whether to use the full screen or focus in the center. Possible values `FULL` and `960PX`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DashboardArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_checkly as checkly

        dashboard1 = checkly.Dashboard("dashboard1",
            custom_domain="status.example.com",
            custom_url="checkly",
            header="Public dashboard",
            hide_tags=False,
            logo="https://www.checklyhq.com/logo.png",
            paginate=False,
            pagination_rate=30,
            refresh_rate=60,
            tags=["production"],
            width="FULL")
        ```

        :param str resource_name: The name of the resource.
        :param DashboardArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DashboardArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 checks_per_page: Optional[pulumi.Input[int]] = None,
                 custom_domain: Optional[pulumi.Input[str]] = None,
                 custom_url: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 favicon: Optional[pulumi.Input[str]] = None,
                 header: Optional[pulumi.Input[str]] = None,
                 hide_tags: Optional[pulumi.Input[bool]] = None,
                 link: Optional[pulumi.Input[str]] = None,
                 logo: Optional[pulumi.Input[str]] = None,
                 paginate: Optional[pulumi.Input[bool]] = None,
                 pagination_rate: Optional[pulumi.Input[int]] = None,
                 refresh_rate: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 use_tags_and_operator: Optional[pulumi.Input[bool]] = None,
                 width: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DashboardArgs.__new__(DashboardArgs)

            __props__.__dict__["checks_per_page"] = checks_per_page
            __props__.__dict__["custom_domain"] = custom_domain
            if custom_url is None and not opts.urn:
                raise TypeError("Missing required property 'custom_url'")
            __props__.__dict__["custom_url"] = custom_url
            __props__.__dict__["description"] = description
            __props__.__dict__["favicon"] = favicon
            __props__.__dict__["header"] = header
            __props__.__dict__["hide_tags"] = hide_tags
            __props__.__dict__["link"] = link
            __props__.__dict__["logo"] = logo
            __props__.__dict__["paginate"] = paginate
            __props__.__dict__["pagination_rate"] = pagination_rate
            __props__.__dict__["refresh_rate"] = refresh_rate
            __props__.__dict__["tags"] = tags
            __props__.__dict__["use_tags_and_operator"] = use_tags_and_operator
            __props__.__dict__["width"] = width
        super(Dashboard, __self__).__init__(
            'checkly:index/dashboard:Dashboard',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            checks_per_page: Optional[pulumi.Input[int]] = None,
            custom_domain: Optional[pulumi.Input[str]] = None,
            custom_url: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            favicon: Optional[pulumi.Input[str]] = None,
            header: Optional[pulumi.Input[str]] = None,
            hide_tags: Optional[pulumi.Input[bool]] = None,
            link: Optional[pulumi.Input[str]] = None,
            logo: Optional[pulumi.Input[str]] = None,
            paginate: Optional[pulumi.Input[bool]] = None,
            pagination_rate: Optional[pulumi.Input[int]] = None,
            refresh_rate: Optional[pulumi.Input[int]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            use_tags_and_operator: Optional[pulumi.Input[bool]] = None,
            width: Optional[pulumi.Input[str]] = None) -> 'Dashboard':
        """
        Get an existing Dashboard resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] checks_per_page: Determines how many checks to show per page.
        :param pulumi.Input[str] custom_domain: A custom user domain, e.g. 'status.example.com'. See the docs on updating your DNS and SSL usage.
        :param pulumi.Input[str] custom_url: A subdomain name under 'checklyhq.com'. Needs to be unique across all users.
        :param pulumi.Input[str] description: HTML <meta> description for the dashboard.
        :param pulumi.Input[str] favicon: A URL pointing to an image file to use as browser favicon.
        :param pulumi.Input[str] header: A piece of text displayed at the top of your dashboard.
        :param pulumi.Input[bool] hide_tags: Show or hide the tags on the dashboard.
        :param pulumi.Input[str] link: A link to for the dashboard logo.
        :param pulumi.Input[str] logo: A URL pointing to an image file to use for the dashboard logo.
        :param pulumi.Input[bool] paginate: Determines if pagination is on or off.
        :param pulumi.Input[int] pagination_rate: How often to trigger pagination in seconds. Possible values `30`, `60` and `300`.
        :param pulumi.Input[int] refresh_rate: How often to refresh the dashboard in seconds. Possible values `60`, '300' and `600`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of one or more tags that filter which checks to display on the dashboard.
        :param pulumi.Input[bool] use_tags_and_operator: Set when to use AND operator for fetching dashboard tags.
        :param pulumi.Input[str] width: Determines whether to use the full screen or focus in the center. Possible values `FULL` and `960PX`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DashboardState.__new__(_DashboardState)

        __props__.__dict__["checks_per_page"] = checks_per_page
        __props__.__dict__["custom_domain"] = custom_domain
        __props__.__dict__["custom_url"] = custom_url
        __props__.__dict__["description"] = description
        __props__.__dict__["favicon"] = favicon
        __props__.__dict__["header"] = header
        __props__.__dict__["hide_tags"] = hide_tags
        __props__.__dict__["link"] = link
        __props__.__dict__["logo"] = logo
        __props__.__dict__["paginate"] = paginate
        __props__.__dict__["pagination_rate"] = pagination_rate
        __props__.__dict__["refresh_rate"] = refresh_rate
        __props__.__dict__["tags"] = tags
        __props__.__dict__["use_tags_and_operator"] = use_tags_and_operator
        __props__.__dict__["width"] = width
        return Dashboard(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="checksPerPage")
    def checks_per_page(self) -> pulumi.Output[Optional[int]]:
        """
        Determines how many checks to show per page.
        """
        return pulumi.get(self, "checks_per_page")

    @property
    @pulumi.getter(name="customDomain")
    def custom_domain(self) -> pulumi.Output[Optional[str]]:
        """
        A custom user domain, e.g. 'status.example.com'. See the docs on updating your DNS and SSL usage.
        """
        return pulumi.get(self, "custom_domain")

    @property
    @pulumi.getter(name="customUrl")
    def custom_url(self) -> pulumi.Output[str]:
        """
        A subdomain name under 'checklyhq.com'. Needs to be unique across all users.
        """
        return pulumi.get(self, "custom_url")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        HTML <meta> description for the dashboard.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def favicon(self) -> pulumi.Output[Optional[str]]:
        """
        A URL pointing to an image file to use as browser favicon.
        """
        return pulumi.get(self, "favicon")

    @property
    @pulumi.getter
    def header(self) -> pulumi.Output[Optional[str]]:
        """
        A piece of text displayed at the top of your dashboard.
        """
        return pulumi.get(self, "header")

    @property
    @pulumi.getter(name="hideTags")
    def hide_tags(self) -> pulumi.Output[Optional[bool]]:
        """
        Show or hide the tags on the dashboard.
        """
        return pulumi.get(self, "hide_tags")

    @property
    @pulumi.getter
    def link(self) -> pulumi.Output[Optional[str]]:
        """
        A link to for the dashboard logo.
        """
        return pulumi.get(self, "link")

    @property
    @pulumi.getter
    def logo(self) -> pulumi.Output[Optional[str]]:
        """
        A URL pointing to an image file to use for the dashboard logo.
        """
        return pulumi.get(self, "logo")

    @property
    @pulumi.getter
    def paginate(self) -> pulumi.Output[Optional[bool]]:
        """
        Determines if pagination is on or off.
        """
        return pulumi.get(self, "paginate")

    @property
    @pulumi.getter(name="paginationRate")
    def pagination_rate(self) -> pulumi.Output[Optional[int]]:
        """
        How often to trigger pagination in seconds. Possible values `30`, `60` and `300`.
        """
        return pulumi.get(self, "pagination_rate")

    @property
    @pulumi.getter(name="refreshRate")
    def refresh_rate(self) -> pulumi.Output[Optional[int]]:
        """
        How often to refresh the dashboard in seconds. Possible values `60`, '300' and `600`.
        """
        return pulumi.get(self, "refresh_rate")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of one or more tags that filter which checks to display on the dashboard.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="useTagsAndOperator")
    def use_tags_and_operator(self) -> pulumi.Output[Optional[bool]]:
        """
        Set when to use AND operator for fetching dashboard tags.
        """
        return pulumi.get(self, "use_tags_and_operator")

    @property
    @pulumi.getter
    def width(self) -> pulumi.Output[Optional[str]]:
        """
        Determines whether to use the full screen or focus in the center. Possible values `FULL` and `960PX`.
        """
        return pulumi.get(self, "width")

