# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['SnippetArgs', 'Snippet']

@pulumi.input_type
class SnippetArgs:
    def __init__(__self__, *,
                 script: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Snippet resource.
        :param pulumi.Input[str] script: Your Node.js code that interacts with the API check lifecycle, or functions as a partial for browser checks.
        :param pulumi.Input[str] name: The name of the snippet
        """
        pulumi.set(__self__, "script", script)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def script(self) -> pulumi.Input[str]:
        """
        Your Node.js code that interacts with the API check lifecycle, or functions as a partial for browser checks.
        """
        return pulumi.get(self, "script")

    @script.setter
    def script(self, value: pulumi.Input[str]):
        pulumi.set(self, "script", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the snippet
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _SnippetState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 script: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Snippet resources.
        :param pulumi.Input[str] name: The name of the snippet
        :param pulumi.Input[str] script: Your Node.js code that interacts with the API check lifecycle, or functions as a partial for browser checks.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if script is not None:
            pulumi.set(__self__, "script", script)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the snippet
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def script(self) -> Optional[pulumi.Input[str]]:
        """
        Your Node.js code that interacts with the API check lifecycle, or functions as a partial for browser checks.
        """
        return pulumi.get(self, "script")

    @script.setter
    def script(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "script", value)


class Snippet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 script: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a Snippet resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: The name of the snippet
        :param pulumi.Input[str] script: Your Node.js code that interacts with the API check lifecycle, or functions as a partial for browser checks.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SnippetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Snippet resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param SnippetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SnippetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 script: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SnippetArgs.__new__(SnippetArgs)

            __props__.__dict__["name"] = name
            if script is None and not opts.urn:
                raise TypeError("Missing required property 'script'")
            __props__.__dict__["script"] = script
        super(Snippet, __self__).__init__(
            'checkly:index/snippet:Snippet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[str]] = None,
            script: Optional[pulumi.Input[str]] = None) -> 'Snippet':
        """
        Get an existing Snippet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: The name of the snippet
        :param pulumi.Input[str] script: Your Node.js code that interacts with the API check lifecycle, or functions as a partial for browser checks.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SnippetState.__new__(_SnippetState)

        __props__.__dict__["name"] = name
        __props__.__dict__["script"] = script
        return Snippet(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the snippet
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def script(self) -> pulumi.Output[str]:
        """
        Your Node.js code that interacts with the API check lifecycle, or functions as a partial for browser checks.
        """
        return pulumi.get(self, "script")

