import { aws_iam as iam } from 'aws-cdk-lib';
import { Construct } from 'constructs';
export interface ManagedInstanceRoleProps {
    /**
     * The managed policies to apply to the role in addition to the default policies.
     */
    readonly managedPolicies?: iam.ManagedPolicy[];
    /**
     * Should the role include directory service access with SSM.
     */
    readonly domainJoinEnabled?: boolean;
    /**
     * Should the role include SSM management. By default if domainJoinEnabled is true then this role is always included.
     */
    readonly ssmManagementEnabled?: boolean;
    /**
     * The retention policy for this role
     */
    readonly retentionPolicy?: boolean;
    /**
     * Whether or not to associate the role with an instance profile
     *
     * @default true
     */
    readonly createInstanceProfile?: boolean;
}
export declare class ManagedInstanceRole extends Construct {
    /**
     * The CfnInstanceProfile automatically created for this role.
     */
    readonly instanceProfile?: iam.CfnInstanceProfile;
    /**
     * The role
     */
    readonly role: iam.Role;
    /**
     * The role name
     */
    readonly name: string;
    /**
     * The role arn
     */
    readonly arn: string;
    constructor(scope: Construct, id: string, props: ManagedInstanceRoleProps);
}
//# sourceMappingURL=index.d.ts.map