# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("p2pgraph.dll")
prototypes = \
    {
        # 
        'PeerGraphStartup': SimTypeFunction([SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimStruct({"wVersion": SimTypeShort(signed=False, label="UInt16"), "wHighestVersion": SimTypeShort(signed=False, label="UInt16")}, name="PEER_VERSION_DATA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["wVersionRequested", "pVersionData"]),
        # 
        'PeerGraphShutdown': SimTypeFunction([], SimTypeInt(signed=True, label="Int32")),
        # 
        'PeerGraphFreeData': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pvData"]),
        # 
        'PeerGraphGetItemCount': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPeerEnum", "pCount"]),
        # 
        'PeerGraphGetNextItem': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPeerEnum", "pCount", "pppvItems"]),
        # 
        'PeerGraphEndEnumeration': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPeerEnum"]),
        # 
        'PeerGraphCreate': SimTypeFunction([SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "dwScope": SimTypeInt(signed=False, label="UInt32"), "dwMaxRecordSize": SimTypeInt(signed=False, label="UInt32"), "pwzGraphId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzCreatorId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzFriendlyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ulPresenceLifetime": SimTypeInt(signed=False, label="UInt32"), "cPresenceMax": SimTypeInt(signed=False, label="UInt32")}, name="PEER_GRAPH_PROPERTIES", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "pwzSspFilename": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzPackageName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cbSecurityInfo": SimTypeInt(signed=False, label="UInt32"), "pbSecurityInfo": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pvContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pfnValidateRecord": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "type": SimTypeBottom(label="Guid"), "id": SimTypeBottom(label="Guid"), "dwVersion": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "pwzCreatorId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzModifiedById": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzAttributes": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ftCreation": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ftExpiration": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ftLastModified": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "securityData": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None), "data": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None)}, name="PEER_RECORD", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="PEER_RECORD_CHANGE_TYPE")], SimTypeInt(signed=True, label="Int32"), arg_names=["hGraph", "pvContext", "pRecord", "changeType"]), offset=0), "pfnSecureRecord": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "type": SimTypeBottom(label="Guid"), "id": SimTypeBottom(label="Guid"), "dwVersion": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "pwzCreatorId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzModifiedById": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzAttributes": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ftCreation": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ftExpiration": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ftLastModified": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "securityData": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None), "data": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None)}, name="PEER_RECORD", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="PEER_RECORD_CHANGE_TYPE"), SimTypePointer(SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGraph", "pvContext", "pRecord", "changeType", "ppSecurityData"]), offset=0), "pfnFreeSecurityData": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGraph", "pvContext", "pSecurityData"]), offset=0), "pfnAuthFailed": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGraph", "pvContext"]), offset=0)}, name="PEER_SECURITY_INTERFACE", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pGraphProperties", "pwzDatabaseName", "pSecurityInterface", "phGraph"]),
        # 
        'PeerGraphOpen': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "pwzSspFilename": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzPackageName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cbSecurityInfo": SimTypeInt(signed=False, label="UInt32"), "pbSecurityInfo": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pvContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pfnValidateRecord": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "type": SimTypeBottom(label="Guid"), "id": SimTypeBottom(label="Guid"), "dwVersion": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "pwzCreatorId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzModifiedById": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzAttributes": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ftCreation": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ftExpiration": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ftLastModified": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "securityData": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None), "data": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None)}, name="PEER_RECORD", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="PEER_RECORD_CHANGE_TYPE")], SimTypeInt(signed=True, label="Int32"), arg_names=["hGraph", "pvContext", "pRecord", "changeType"]), offset=0), "pfnSecureRecord": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "type": SimTypeBottom(label="Guid"), "id": SimTypeBottom(label="Guid"), "dwVersion": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "pwzCreatorId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzModifiedById": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzAttributes": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ftCreation": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ftExpiration": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ftLastModified": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "securityData": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None), "data": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None)}, name="PEER_RECORD", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="PEER_RECORD_CHANGE_TYPE"), SimTypePointer(SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGraph", "pvContext", "pRecord", "changeType", "ppSecurityData"]), offset=0), "pfnFreeSecurityData": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGraph", "pvContext", "pSecurityData"]), offset=0), "pfnAuthFailed": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGraph", "pvContext"]), offset=0)}, name="PEER_SECURITY_INTERFACE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Guid"), label="LPArray", offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pwzGraphId", "pwzPeerId", "pwzDatabaseName", "pSecurityInterface", "cRecordTypeSyncPrecedence", "pRecordTypeSyncPrecedence", "phGraph"]),
        # 
        'PeerGraphListen': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeShort(signed=False, label="UInt16")], SimTypeInt(signed=True, label="Int32"), arg_names=["hGraph", "dwScope", "dwScopeId", "wPort"]),
        # 
        'PeerGraphConnect': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "sin6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None)}, name="PEER_ADDRESS", pack=False, align=None), offset=0), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGraph", "pwzPeerId", "pAddress", "pullConnectionId"]),
        # 
        'PeerGraphClose': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGraph"]),
        # 
        'PeerGraphDelete': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pwzGraphId", "pwzPeerId", "pwzDatabaseName"]),
        # 
        'PeerGraphGetStatus': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGraph", "pdwStatus"]),
        # 
        'PeerGraphGetProperties': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "dwScope": SimTypeInt(signed=False, label="UInt32"), "dwMaxRecordSize": SimTypeInt(signed=False, label="UInt32"), "pwzGraphId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzCreatorId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzFriendlyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ulPresenceLifetime": SimTypeInt(signed=False, label="UInt32"), "cPresenceMax": SimTypeInt(signed=False, label="UInt32")}, name="PEER_GRAPH_PROPERTIES", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGraph", "ppGraphProperties"]),
        # 
        'PeerGraphSetProperties': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "dwScope": SimTypeInt(signed=False, label="UInt32"), "dwMaxRecordSize": SimTypeInt(signed=False, label="UInt32"), "pwzGraphId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzCreatorId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzFriendlyName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ulPresenceLifetime": SimTypeInt(signed=False, label="UInt32"), "cPresenceMax": SimTypeInt(signed=False, label="UInt32")}, name="PEER_GRAPH_PROPERTIES", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGraph", "pGraphProperties"]),
        # 
        'PeerGraphRegisterEvent': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"eventType": SimTypeInt(signed=False, label="PEER_GRAPH_EVENT_TYPE"), "pType": SimTypePointer(SimTypeBottom(label="Guid"), offset=0)}, name="PEER_GRAPH_EVENT_REGISTRATION", pack=False, align=None), label="LPArray", offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGraph", "hEvent", "cEventRegistrations", "pEventRegistrations", "phPeerEvent"]),
        # 
        'PeerGraphUnregisterEvent': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPeerEvent"]),
        # 
        'PeerGraphGetEventData': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"eventType": SimTypeInt(signed=False, label="PEER_GRAPH_EVENT_TYPE"), "Anonymous": SimUnion({"dwStatus": SimTypeInt(signed=False, label="PEER_GRAPH_STATUS_FLAGS"), "incomingData": SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "ullConnectionId": SimTypeLongLong(signed=False, label="UInt64"), "type": SimTypeBottom(label="Guid"), "data": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None)}, name="PEER_EVENT_INCOMING_DATA", pack=False, align=None), "recordChangeData": SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "changeType": SimTypeInt(signed=False, label="PEER_RECORD_CHANGE_TYPE"), "recordId": SimTypeBottom(label="Guid"), "recordType": SimTypeBottom(label="Guid")}, name="PEER_EVENT_RECORD_CHANGE_DATA", pack=False, align=None), "connectionChangeData": SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "status": SimTypeInt(signed=False, label="PEER_CONNECTION_STATUS"), "ullConnectionId": SimTypeLongLong(signed=False, label="UInt64"), "ullNodeId": SimTypeLongLong(signed=False, label="UInt64"), "ullNextConnectionId": SimTypeLongLong(signed=False, label="UInt64"), "hrConnectionFailedReason": SimTypeInt(signed=True, label="Int32")}, name="PEER_EVENT_CONNECTION_CHANGE_DATA", pack=False, align=None), "nodeChangeData": SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "changeType": SimTypeInt(signed=False, label="PEER_NODE_CHANGE_TYPE"), "ullNodeId": SimTypeLongLong(signed=False, label="UInt64"), "pwzPeerId": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="PEER_EVENT_NODE_CHANGE_DATA", pack=False, align=None), "synchronizedData": SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "recordType": SimTypeBottom(label="Guid")}, name="PEER_EVENT_SYNCHRONIZED_DATA", pack=False, align=None)}, name="<anon>", label="None")}, name="PEER_GRAPH_EVENT_DATA", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hPeerEvent", "ppEventData"]),
        # 
        'PeerGraphGetRecord': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "type": SimTypeBottom(label="Guid"), "id": SimTypeBottom(label="Guid"), "dwVersion": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "pwzCreatorId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzModifiedById": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzAttributes": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ftCreation": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ftExpiration": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ftLastModified": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "securityData": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None), "data": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None)}, name="PEER_RECORD", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGraph", "pRecordId", "ppRecord"]),
        # 
        'PeerGraphAddRecord': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "type": SimTypeBottom(label="Guid"), "id": SimTypeBottom(label="Guid"), "dwVersion": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "pwzCreatorId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzModifiedById": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzAttributes": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ftCreation": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ftExpiration": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ftLastModified": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "securityData": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None), "data": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None)}, name="PEER_RECORD", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGraph", "pRecord", "pRecordId"]),
        # 
        'PeerGraphUpdateRecord': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "type": SimTypeBottom(label="Guid"), "id": SimTypeBottom(label="Guid"), "dwVersion": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "pwzCreatorId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzModifiedById": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwzAttributes": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ftCreation": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ftExpiration": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ftLastModified": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "securityData": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None), "data": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="PEER_DATA", pack=False, align=None)}, name="PEER_RECORD", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGraph", "pRecord"]),
        # 
        'PeerGraphDeleteRecord': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hGraph", "pRecordId", "fLocal"]),
        # 
        'PeerGraphEnumRecords': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGraph", "pRecordType", "pwzPeerId", "phPeerEnum"]),
        # 
        'PeerGraphSearchRecords': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGraph", "pwzCriteria", "phPeerEnum"]),
        # 
        'PeerGraphExportDatabase': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGraph", "pwzFilePath"]),
        # 
        'PeerGraphImportDatabase': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGraph", "pwzFilePath"]),
        # 
        'PeerGraphValidateDeferredRecords': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Guid"), label="LPArray", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGraph", "cRecordIds", "pRecordIds"]),
        # 
        'PeerGraphOpenDirectConnection': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "sin6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None)}, name="PEER_ADDRESS", pack=False, align=None), offset=0), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGraph", "pwzPeerId", "pAddress", "pullConnectionId"]),
        # 
        'PeerGraphSendData': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGraph", "ullConnectionId", "pType", "cbData", "pvData"]),
        # 
        'PeerGraphCloseDirectConnection': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeLongLong(signed=False, label="UInt64")], SimTypeInt(signed=True, label="Int32"), arg_names=["hGraph", "ullConnectionId"]),
        # 
        'PeerGraphEnumConnections': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGraph", "dwFlags", "phPeerEnum"]),
        # 
        'PeerGraphEnumNodes': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGraph", "pwzPeerId", "phPeerEnum"]),
        # 
        'PeerGraphSetPresence': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hGraph", "fPresent"]),
        # 
        'PeerGraphGetNodeInfo': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "ullNodeId": SimTypeLongLong(signed=False, label="UInt64"), "pwzPeerId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cAddresses": SimTypeInt(signed=False, label="UInt32"), "pAddresses": SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "sin6": SimStruct({"sin6_family": SimTypeShort(signed=False, label="UInt16"), "sin6_port": SimTypeShort(signed=False, label="UInt16"), "sin6_flowinfo": SimTypeInt(signed=False, label="UInt32"), "sin6_addr": SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), "Anonymous": SimUnion({"sin6_scope_id": SimTypeInt(signed=False, label="UInt32"), "sin6_scope_struct": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Value": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="SCOPE_ID", pack=False, align=None)}, name="<anon>", label="None")}, name="SOCKADDR_IN6", pack=False, align=None)}, name="PEER_ADDRESS", pack=False, align=None), offset=0), "pwzAttributes": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="PEER_NODE_INFO", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGraph", "ullNodeId", "ppNodeInfo"]),
        # 
        'PeerGraphSetNodeAttributes': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGraph", "pwzAttributes"]),
        # 
        'PeerGraphPeerTimeToUniversalTime': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGraph", "pftPeerTime", "pftUniversalTime"]),
        # 
        'PeerGraphUniversalTimeToPeerTime': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hGraph", "pftUniversalTime", "pftPeerTime"]),
    }

lib.set_prototypes(prototypes)
