# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("winmm.dll")
prototypes = \
    {
        # 
        'joyConfigChanged': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["dwFlags"]),
        # 
        'mciSendCommandA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["mciId", "uMsg", "dwParam1", "dwParam2"]),
        # 
        'mciSendCommandW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["mciId", "uMsg", "dwParam1", "dwParam2"]),
        # 
        'mciSendStringA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpstrCommand", "lpstrReturnString", "uReturnLength", "hwndCallback"]),
        # 
        'mciSendStringW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpstrCommand", "lpstrReturnString", "uReturnLength", "hwndCallback"]),
        # 
        'mciGetDeviceIDA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pszDevice"]),
        # 
        'mciGetDeviceIDW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pszDevice"]),
        # 
        'mciGetDeviceIDFromElementIDA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["dwElementID", "lpstrType"]),
        # 
        'mciGetDeviceIDFromElementIDW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["dwElementID", "lpstrType"]),
        # 
        'mciGetErrorStringA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["mcierr", "pszText", "cchText"]),
        # 
        'mciGetErrorStringW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["mcierr", "pszText", "cchText"]),
        # 
        'mciSetYieldProc': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["mciId", "dwYieldData"]), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["mciId", "fpYieldProc", "dwYieldData"]),
        # 
        'mciGetCreatorTask': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["mciId"]),
        # 
        'mciGetYieldProc': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["mciId", "dwYieldData"]), offset=0), arg_names=["mciId", "pdwYieldData"]),
        # 
        'mciGetDriverData': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), arg_names=["wDeviceID"]),
        # 
        'mciLoadCommandResource': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hInstance", "lpResName", "wType"]),
        # 
        'mciSetDriverData': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["wDeviceID", "dwData"]),
        # 
        'mciDriverYield': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["wDeviceID"]),
        # 
        'mciDriverNotify': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hwndCallback", "wDeviceID", "uStatus"]),
        # 
        'mciFreeCommandResource': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["wTable"]),
        # 
        'CloseDriver': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hDriver", "lParam1", "lParam2"]),
        # 
        'OpenDriver': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["szDriverName", "szSectionName", "lParam2"]),
        # 
        'SendDriverMessage': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hDriver", "message", "lParam1", "lParam2"]),
        # 
        'DrvGetModuleHandle': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hDriver"]),
        # 
        'GetDriverModuleHandle': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hDriver"]),
        # 
        'DefDriverProc': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["dwDriverIdentifier", "hdrvr", "uMsg", "lParam1", "lParam2"]),
        # 
        'DriverCallback': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwCallback", "dwFlags", "hDevice", "dwMsg", "dwUser", "dwParam1", "dwParam2"]),
        # 
        'mmDrvInstall': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["param0", "param1", "param2", "param3", "param4"]), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hDriver", "wszDrvEntry", "drvMessage", "wFlags"]),
        # 
        'mmioStringToFOURCCA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["sz", "uFlags"]),
        # 
        'mmioStringToFOURCCW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["sz", "uFlags"]),
        # 
        'mmioInstallIOProcA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["lpmmioinfo", "uMsg", "lParam1", "lParam2"]), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["lpmmioinfo", "uMsg", "lParam1", "lParam2"]), offset=0), arg_names=["fccIOProc", "pIOProc", "dwFlags"]),
        # 
        'mmioInstallIOProcW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["lpmmioinfo", "uMsg", "lParam1", "lParam2"]), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["lpmmioinfo", "uMsg", "lParam1", "lParam2"]), offset=0), arg_names=["fccIOProc", "pIOProc", "dwFlags"]),
        # 
        'mmioOpenA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimStruct({"dwFlags": SimTypeInt(signed=False, label="UInt32"), "fccIOProc": SimTypeInt(signed=False, label="UInt32"), "pIOProc": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["lpmmioinfo", "uMsg", "lParam1", "lParam2"]), offset=0), "wErrorRet": SimTypeInt(signed=False, label="UInt32"), "htask": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "cchBuffer": SimTypeInt(signed=True, label="Int32"), "pchBuffer": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "pchNext": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "pchEndRead": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "pchEndWrite": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "lBufOffset": SimTypeInt(signed=True, label="Int32"), "lDiskOffset": SimTypeInt(signed=True, label="Int32"), "adwInfo": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 3), "dwReserved1": SimTypeInt(signed=False, label="UInt32"), "dwReserved2": SimTypeInt(signed=False, label="UInt32"), "hmmio": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MMIOINFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["pszFileName", "pmmioinfo", "fdwOpen"]),
        # 
        'mmioOpenW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimStruct({"dwFlags": SimTypeInt(signed=False, label="UInt32"), "fccIOProc": SimTypeInt(signed=False, label="UInt32"), "pIOProc": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["lpmmioinfo", "uMsg", "lParam1", "lParam2"]), offset=0), "wErrorRet": SimTypeInt(signed=False, label="UInt32"), "htask": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "cchBuffer": SimTypeInt(signed=True, label="Int32"), "pchBuffer": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "pchNext": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "pchEndRead": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "pchEndWrite": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "lBufOffset": SimTypeInt(signed=True, label="Int32"), "lDiskOffset": SimTypeInt(signed=True, label="Int32"), "adwInfo": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 3), "dwReserved1": SimTypeInt(signed=False, label="UInt32"), "dwReserved2": SimTypeInt(signed=False, label="UInt32"), "hmmio": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MMIOINFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["pszFileName", "pmmioinfo", "fdwOpen"]),
        # 
        'mmioRenameA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"dwFlags": SimTypeInt(signed=False, label="UInt32"), "fccIOProc": SimTypeInt(signed=False, label="UInt32"), "pIOProc": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["lpmmioinfo", "uMsg", "lParam1", "lParam2"]), offset=0), "wErrorRet": SimTypeInt(signed=False, label="UInt32"), "htask": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "cchBuffer": SimTypeInt(signed=True, label="Int32"), "pchBuffer": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "pchNext": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "pchEndRead": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "pchEndWrite": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "lBufOffset": SimTypeInt(signed=True, label="Int32"), "lDiskOffset": SimTypeInt(signed=True, label="Int32"), "adwInfo": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 3), "dwReserved1": SimTypeInt(signed=False, label="UInt32"), "dwReserved2": SimTypeInt(signed=False, label="UInt32"), "hmmio": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MMIOINFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["pszFileName", "pszNewFileName", "pmmioinfo", "fdwRename"]),
        # 
        'mmioRenameW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dwFlags": SimTypeInt(signed=False, label="UInt32"), "fccIOProc": SimTypeInt(signed=False, label="UInt32"), "pIOProc": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["lpmmioinfo", "uMsg", "lParam1", "lParam2"]), offset=0), "wErrorRet": SimTypeInt(signed=False, label="UInt32"), "htask": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "cchBuffer": SimTypeInt(signed=True, label="Int32"), "pchBuffer": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "pchNext": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "pchEndRead": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "pchEndWrite": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "lBufOffset": SimTypeInt(signed=True, label="Int32"), "lDiskOffset": SimTypeInt(signed=True, label="Int32"), "adwInfo": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 3), "dwReserved1": SimTypeInt(signed=False, label="UInt32"), "dwReserved2": SimTypeInt(signed=False, label="UInt32"), "hmmio": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MMIOINFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["pszFileName", "pszNewFileName", "pmmioinfo", "fdwRename"]),
        # 
        'mmioClose': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hmmio", "fuClose"]),
        # 
        'mmioRead': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hmmio", "pch", "cch"]),
        # 
        'mmioWrite': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hmmio", "pch", "cch"]),
        # 
        'mmioSeek': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hmmio", "lOffset", "iOrigin"]),
        # 
        'mmioGetInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"dwFlags": SimTypeInt(signed=False, label="UInt32"), "fccIOProc": SimTypeInt(signed=False, label="UInt32"), "pIOProc": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["lpmmioinfo", "uMsg", "lParam1", "lParam2"]), offset=0), "wErrorRet": SimTypeInt(signed=False, label="UInt32"), "htask": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "cchBuffer": SimTypeInt(signed=True, label="Int32"), "pchBuffer": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "pchNext": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "pchEndRead": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "pchEndWrite": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "lBufOffset": SimTypeInt(signed=True, label="Int32"), "lDiskOffset": SimTypeInt(signed=True, label="Int32"), "adwInfo": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 3), "dwReserved1": SimTypeInt(signed=False, label="UInt32"), "dwReserved2": SimTypeInt(signed=False, label="UInt32"), "hmmio": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MMIOINFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hmmio", "pmmioinfo", "fuInfo"]),
        # 
        'mmioSetInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"dwFlags": SimTypeInt(signed=False, label="UInt32"), "fccIOProc": SimTypeInt(signed=False, label="UInt32"), "pIOProc": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["lpmmioinfo", "uMsg", "lParam1", "lParam2"]), offset=0), "wErrorRet": SimTypeInt(signed=False, label="UInt32"), "htask": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "cchBuffer": SimTypeInt(signed=True, label="Int32"), "pchBuffer": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "pchNext": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "pchEndRead": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "pchEndWrite": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "lBufOffset": SimTypeInt(signed=True, label="Int32"), "lDiskOffset": SimTypeInt(signed=True, label="Int32"), "adwInfo": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 3), "dwReserved1": SimTypeInt(signed=False, label="UInt32"), "dwReserved2": SimTypeInt(signed=False, label="UInt32"), "hmmio": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MMIOINFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hmmio", "pmmioinfo", "fuInfo"]),
        # 
        'mmioSetBuffer': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hmmio", "pchBuffer", "cchBuffer", "fuBuffer"]),
        # 
        'mmioFlush': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hmmio", "fuFlush"]),
        # 
        'mmioAdvance': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"dwFlags": SimTypeInt(signed=False, label="UInt32"), "fccIOProc": SimTypeInt(signed=False, label="UInt32"), "pIOProc": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["lpmmioinfo", "uMsg", "lParam1", "lParam2"]), offset=0), "wErrorRet": SimTypeInt(signed=False, label="UInt32"), "htask": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "cchBuffer": SimTypeInt(signed=True, label="Int32"), "pchBuffer": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "pchNext": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "pchEndRead": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "pchEndWrite": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "lBufOffset": SimTypeInt(signed=True, label="Int32"), "lDiskOffset": SimTypeInt(signed=True, label="Int32"), "adwInfo": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 3), "dwReserved1": SimTypeInt(signed=False, label="UInt32"), "dwReserved2": SimTypeInt(signed=False, label="UInt32"), "hmmio": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="MMIOINFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hmmio", "pmmioinfo", "fuAdvance"]),
        # 
        'mmioSendMessage': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hmmio", "uMsg", "lParam1", "lParam2"]),
        # 
        'mmioDescend': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"ckid": SimTypeInt(signed=False, label="UInt32"), "cksize": SimTypeInt(signed=False, label="UInt32"), "fccType": SimTypeInt(signed=False, label="UInt32"), "dwDataOffset": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32")}, name="MMCKINFO", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"ckid": SimTypeInt(signed=False, label="UInt32"), "cksize": SimTypeInt(signed=False, label="UInt32"), "fccType": SimTypeInt(signed=False, label="UInt32"), "dwDataOffset": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32")}, name="MMCKINFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hmmio", "pmmcki", "pmmckiParent", "fuDescend"]),
        # 
        'mmioAscend': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"ckid": SimTypeInt(signed=False, label="UInt32"), "cksize": SimTypeInt(signed=False, label="UInt32"), "fccType": SimTypeInt(signed=False, label="UInt32"), "dwDataOffset": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32")}, name="MMCKINFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hmmio", "pmmcki", "fuAscend"]),
        # 
        'mmioCreateChunk': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"ckid": SimTypeInt(signed=False, label="UInt32"), "cksize": SimTypeInt(signed=False, label="UInt32"), "fccType": SimTypeInt(signed=False, label="UInt32"), "dwDataOffset": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32")}, name="MMCKINFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hmmio", "pmmcki", "fuCreate"]),
        # 
        'sndPlaySoundA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pszSound", "fuSound"]),
        # 
        'sndPlaySoundW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pszSound", "fuSound"]),
        # 
        'PlaySoundA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pszSound", "hmod", "fdwSound"]),
        # 
        'PlaySoundW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pszSound", "hmod", "fdwSound"]),
        # 
        'waveOutGetNumDevs': SimTypeFunction([], SimTypeInt(signed=False, label="UInt32")),
        # 
        'waveOutGetDevCapsA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"wMid": SimTypeShort(signed=False, label="UInt16"), "wPid": SimTypeShort(signed=False, label="UInt16"), "vDriverVersion": SimTypeInt(signed=False, label="UInt32"), "szPname": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 32), "dwFormats": SimTypeInt(signed=False, label="UInt32"), "wChannels": SimTypeShort(signed=False, label="UInt16"), "wReserved1": SimTypeShort(signed=False, label="UInt16"), "dwSupport": SimTypeInt(signed=False, label="UInt32")}, name="WAVEOUTCAPSA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["uDeviceID", "pwoc", "cbwoc"]),
        # 
        'waveOutGetDevCapsW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"wMid": SimTypeShort(signed=False, label="UInt16"), "wPid": SimTypeShort(signed=False, label="UInt16"), "vDriverVersion": SimTypeInt(signed=False, label="UInt32"), "szPname": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32), "dwFormats": SimTypeInt(signed=False, label="UInt32"), "wChannels": SimTypeShort(signed=False, label="UInt16"), "wReserved1": SimTypeShort(signed=False, label="UInt16"), "dwSupport": SimTypeInt(signed=False, label="UInt32")}, name="WAVEOUTCAPSW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["uDeviceID", "pwoc", "cbwoc"]),
        # 
        'waveOutGetVolume': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwo", "pdwVolume"]),
        # 
        'waveOutSetVolume': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwo", "dwVolume"]),
        # 
        'waveOutGetErrorTextA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["mmrError", "pszText", "cchText"]),
        # 
        'waveOutGetErrorTextW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["mmrError", "pszText", "cchText"]),
        # 
        'waveOutOpen': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"wFormatTag": SimTypeShort(signed=False, label="UInt16"), "nChannels": SimTypeShort(signed=False, label="UInt16"), "nSamplesPerSec": SimTypeInt(signed=False, label="UInt32"), "nAvgBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "nBlockAlign": SimTypeShort(signed=False, label="UInt16"), "wBitsPerSample": SimTypeShort(signed=False, label="UInt16"), "cbSize": SimTypeShort(signed=False, label="UInt16")}, name="WAVEFORMATEX", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="MIDI_WAVE_OPEN_TYPE")], SimTypeInt(signed=False, label="UInt32"), arg_names=["phwo", "uDeviceID", "pwfx", "dwCallback", "dwInstance", "fdwOpen"]),
        # 
        'waveOutClose': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwo"]),
        # 
        'waveOutPrepareHeader': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"lpData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwBufferLength": SimTypeInt(signed=False, label="UInt32"), "dwBytesRecorded": SimTypeInt(signed=False, label="UInt32"), "dwUser": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "dwLoops": SimTypeInt(signed=False, label="UInt32"), "lpNext": SimTypePointer(SimTypeBottom(label="WAVEHDR"), offset=0), "reserved": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="WAVEHDR", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwo", "pwh", "cbwh"]),
        # 
        'waveOutUnprepareHeader': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"lpData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwBufferLength": SimTypeInt(signed=False, label="UInt32"), "dwBytesRecorded": SimTypeInt(signed=False, label="UInt32"), "dwUser": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "dwLoops": SimTypeInt(signed=False, label="UInt32"), "lpNext": SimTypePointer(SimTypeBottom(label="WAVEHDR"), offset=0), "reserved": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="WAVEHDR", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwo", "pwh", "cbwh"]),
        # 
        'waveOutWrite': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"lpData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwBufferLength": SimTypeInt(signed=False, label="UInt32"), "dwBytesRecorded": SimTypeInt(signed=False, label="UInt32"), "dwUser": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "dwLoops": SimTypeInt(signed=False, label="UInt32"), "lpNext": SimTypePointer(SimTypeBottom(label="WAVEHDR"), offset=0), "reserved": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="WAVEHDR", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwo", "pwh", "cbwh"]),
        # 
        'waveOutPause': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwo"]),
        # 
        'waveOutRestart': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwo"]),
        # 
        'waveOutReset': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwo"]),
        # 
        'waveOutBreakLoop': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwo"]),
        # 
        'waveOutGetPosition': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"wType": SimTypeInt(signed=False, label="UInt32"), "u": SimUnion({"ms": SimTypeInt(signed=False, label="UInt32"), "sample": SimTypeInt(signed=False, label="UInt32"), "cb": SimTypeInt(signed=False, label="UInt32"), "ticks": SimTypeInt(signed=False, label="UInt32"), "smpte": SimStruct({"hour": SimTypeChar(label="Byte"), "min": SimTypeChar(label="Byte"), "sec": SimTypeChar(label="Byte"), "frame": SimTypeChar(label="Byte"), "fps": SimTypeChar(label="Byte"), "dummy": SimTypeChar(label="Byte"), "pad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2)}, name="_smpte_e__Struct", pack=False, align=None), "midi": SimStruct({"songptrpos": SimTypeInt(signed=False, label="UInt32")}, name="_midi_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="MMTIME", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwo", "pmmt", "cbmmt"]),
        # 
        'waveOutGetPitch': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwo", "pdwPitch"]),
        # 
        'waveOutSetPitch': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwo", "dwPitch"]),
        # 
        'waveOutGetPlaybackRate': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwo", "pdwRate"]),
        # 
        'waveOutSetPlaybackRate': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwo", "dwRate"]),
        # 
        'waveOutGetID': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwo", "puDeviceID"]),
        # 
        'waveOutMessage': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwo", "uMsg", "dw1", "dw2"]),
        # 
        'waveInGetNumDevs': SimTypeFunction([], SimTypeInt(signed=False, label="UInt32")),
        # 
        'waveInGetDevCapsA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"wMid": SimTypeShort(signed=False, label="UInt16"), "wPid": SimTypeShort(signed=False, label="UInt16"), "vDriverVersion": SimTypeInt(signed=False, label="UInt32"), "szPname": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 32), "dwFormats": SimTypeInt(signed=False, label="UInt32"), "wChannels": SimTypeShort(signed=False, label="UInt16"), "wReserved1": SimTypeShort(signed=False, label="UInt16")}, name="WAVEINCAPSA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["uDeviceID", "pwic", "cbwic"]),
        # 
        'waveInGetDevCapsW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"wMid": SimTypeShort(signed=False, label="UInt16"), "wPid": SimTypeShort(signed=False, label="UInt16"), "vDriverVersion": SimTypeInt(signed=False, label="UInt32"), "szPname": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32), "dwFormats": SimTypeInt(signed=False, label="UInt32"), "wChannels": SimTypeShort(signed=False, label="UInt16"), "wReserved1": SimTypeShort(signed=False, label="UInt16")}, name="WAVEINCAPSW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["uDeviceID", "pwic", "cbwic"]),
        # 
        'waveInGetErrorTextA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["mmrError", "pszText", "cchText"]),
        # 
        'waveInGetErrorTextW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["mmrError", "pszText", "cchText"]),
        # 
        'waveInOpen': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"wFormatTag": SimTypeShort(signed=False, label="UInt16"), "nChannels": SimTypeShort(signed=False, label="UInt16"), "nSamplesPerSec": SimTypeInt(signed=False, label="UInt32"), "nAvgBytesPerSec": SimTypeInt(signed=False, label="UInt32"), "nBlockAlign": SimTypeShort(signed=False, label="UInt16"), "wBitsPerSample": SimTypeShort(signed=False, label="UInt16"), "cbSize": SimTypeShort(signed=False, label="UInt16")}, name="WAVEFORMATEX", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="MIDI_WAVE_OPEN_TYPE")], SimTypeInt(signed=False, label="UInt32"), arg_names=["phwi", "uDeviceID", "pwfx", "dwCallback", "dwInstance", "fdwOpen"]),
        # 
        'waveInClose': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwi"]),
        # 
        'waveInPrepareHeader': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"lpData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwBufferLength": SimTypeInt(signed=False, label="UInt32"), "dwBytesRecorded": SimTypeInt(signed=False, label="UInt32"), "dwUser": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "dwLoops": SimTypeInt(signed=False, label="UInt32"), "lpNext": SimTypePointer(SimTypeBottom(label="WAVEHDR"), offset=0), "reserved": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="WAVEHDR", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwi", "pwh", "cbwh"]),
        # 
        'waveInUnprepareHeader': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"lpData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwBufferLength": SimTypeInt(signed=False, label="UInt32"), "dwBytesRecorded": SimTypeInt(signed=False, label="UInt32"), "dwUser": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "dwLoops": SimTypeInt(signed=False, label="UInt32"), "lpNext": SimTypePointer(SimTypeBottom(label="WAVEHDR"), offset=0), "reserved": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="WAVEHDR", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwi", "pwh", "cbwh"]),
        # 
        'waveInAddBuffer': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"lpData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwBufferLength": SimTypeInt(signed=False, label="UInt32"), "dwBytesRecorded": SimTypeInt(signed=False, label="UInt32"), "dwUser": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "dwLoops": SimTypeInt(signed=False, label="UInt32"), "lpNext": SimTypePointer(SimTypeBottom(label="WAVEHDR"), offset=0), "reserved": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="WAVEHDR", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwi", "pwh", "cbwh"]),
        # 
        'waveInStart': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwi"]),
        # 
        'waveInStop': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwi"]),
        # 
        'waveInReset': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwi"]),
        # 
        'waveInGetPosition': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"wType": SimTypeInt(signed=False, label="UInt32"), "u": SimUnion({"ms": SimTypeInt(signed=False, label="UInt32"), "sample": SimTypeInt(signed=False, label="UInt32"), "cb": SimTypeInt(signed=False, label="UInt32"), "ticks": SimTypeInt(signed=False, label="UInt32"), "smpte": SimStruct({"hour": SimTypeChar(label="Byte"), "min": SimTypeChar(label="Byte"), "sec": SimTypeChar(label="Byte"), "frame": SimTypeChar(label="Byte"), "fps": SimTypeChar(label="Byte"), "dummy": SimTypeChar(label="Byte"), "pad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2)}, name="_smpte_e__Struct", pack=False, align=None), "midi": SimStruct({"songptrpos": SimTypeInt(signed=False, label="UInt32")}, name="_midi_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="MMTIME", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwi", "pmmt", "cbmmt"]),
        # 
        'waveInGetID': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwi", "puDeviceID"]),
        # 
        'waveInMessage': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwi", "uMsg", "dw1", "dw2"]),
        # 
        'midiOutGetNumDevs': SimTypeFunction([], SimTypeInt(signed=False, label="UInt32")),
        # 
        'midiStreamOpen': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["phms", "puDeviceID", "cMidi", "dwCallback", "dwInstance", "fdwOpen"]),
        # 
        'midiStreamClose': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hms"]),
        # 
        'midiStreamProperty': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hms", "lppropdata", "dwProperty"]),
        # 
        'midiStreamPosition': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"wType": SimTypeInt(signed=False, label="UInt32"), "u": SimUnion({"ms": SimTypeInt(signed=False, label="UInt32"), "sample": SimTypeInt(signed=False, label="UInt32"), "cb": SimTypeInt(signed=False, label="UInt32"), "ticks": SimTypeInt(signed=False, label="UInt32"), "smpte": SimStruct({"hour": SimTypeChar(label="Byte"), "min": SimTypeChar(label="Byte"), "sec": SimTypeChar(label="Byte"), "frame": SimTypeChar(label="Byte"), "fps": SimTypeChar(label="Byte"), "dummy": SimTypeChar(label="Byte"), "pad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2)}, name="_smpte_e__Struct", pack=False, align=None), "midi": SimStruct({"songptrpos": SimTypeInt(signed=False, label="UInt32")}, name="_midi_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="MMTIME", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hms", "lpmmt", "cbmmt"]),
        # 
        'midiStreamOut': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"lpData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwBufferLength": SimTypeInt(signed=False, label="UInt32"), "dwBytesRecorded": SimTypeInt(signed=False, label="UInt32"), "dwUser": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "lpNext": SimTypePointer(SimTypeBottom(label="MIDIHDR"), offset=0), "reserved": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwOffset": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeFixedSizeArray(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), 8)}, name="MIDIHDR", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hms", "pmh", "cbmh"]),
        # 
        'midiStreamPause': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hms"]),
        # 
        'midiStreamRestart': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hms"]),
        # 
        'midiStreamStop': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hms"]),
        # 
        'midiConnect': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hmi", "hmo", "pReserved"]),
        # 
        'midiDisconnect': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hmi", "hmo", "pReserved"]),
        # 
        'midiOutGetDevCapsA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"wMid": SimTypeShort(signed=False, label="UInt16"), "wPid": SimTypeShort(signed=False, label="UInt16"), "vDriverVersion": SimTypeInt(signed=False, label="UInt32"), "szPname": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 32), "wTechnology": SimTypeShort(signed=False, label="UInt16"), "wVoices": SimTypeShort(signed=False, label="UInt16"), "wNotes": SimTypeShort(signed=False, label="UInt16"), "wChannelMask": SimTypeShort(signed=False, label="UInt16"), "dwSupport": SimTypeInt(signed=False, label="UInt32")}, name="MIDIOUTCAPSA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["uDeviceID", "pmoc", "cbmoc"]),
        # 
        'midiOutGetDevCapsW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"wMid": SimTypeShort(signed=False, label="UInt16"), "wPid": SimTypeShort(signed=False, label="UInt16"), "vDriverVersion": SimTypeInt(signed=False, label="UInt32"), "szPname": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32), "wTechnology": SimTypeShort(signed=False, label="UInt16"), "wVoices": SimTypeShort(signed=False, label="UInt16"), "wNotes": SimTypeShort(signed=False, label="UInt16"), "wChannelMask": SimTypeShort(signed=False, label="UInt16"), "dwSupport": SimTypeInt(signed=False, label="UInt32")}, name="MIDIOUTCAPSW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["uDeviceID", "pmoc", "cbmoc"]),
        # 
        'midiOutGetVolume': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hmo", "pdwVolume"]),
        # 
        'midiOutSetVolume': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hmo", "dwVolume"]),
        # 
        'midiOutGetErrorTextA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["mmrError", "pszText", "cchText"]),
        # 
        'midiOutGetErrorTextW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["mmrError", "pszText", "cchText"]),
        # 
        'midiOutOpen': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="MIDI_WAVE_OPEN_TYPE")], SimTypeInt(signed=False, label="UInt32"), arg_names=["phmo", "uDeviceID", "dwCallback", "dwInstance", "fdwOpen"]),
        # 
        'midiOutClose': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hmo"]),
        # 
        'midiOutPrepareHeader': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"lpData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwBufferLength": SimTypeInt(signed=False, label="UInt32"), "dwBytesRecorded": SimTypeInt(signed=False, label="UInt32"), "dwUser": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "lpNext": SimTypePointer(SimTypeBottom(label="MIDIHDR"), offset=0), "reserved": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwOffset": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeFixedSizeArray(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), 8)}, name="MIDIHDR", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hmo", "pmh", "cbmh"]),
        # 
        'midiOutUnprepareHeader': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"lpData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwBufferLength": SimTypeInt(signed=False, label="UInt32"), "dwBytesRecorded": SimTypeInt(signed=False, label="UInt32"), "dwUser": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "lpNext": SimTypePointer(SimTypeBottom(label="MIDIHDR"), offset=0), "reserved": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwOffset": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeFixedSizeArray(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), 8)}, name="MIDIHDR", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hmo", "pmh", "cbmh"]),
        # 
        'midiOutShortMsg': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hmo", "dwMsg"]),
        # 
        'midiOutLongMsg': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"lpData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwBufferLength": SimTypeInt(signed=False, label="UInt32"), "dwBytesRecorded": SimTypeInt(signed=False, label="UInt32"), "dwUser": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "lpNext": SimTypePointer(SimTypeBottom(label="MIDIHDR"), offset=0), "reserved": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwOffset": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeFixedSizeArray(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), 8)}, name="MIDIHDR", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hmo", "pmh", "cbmh"]),
        # 
        'midiOutReset': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hmo"]),
        # 
        'midiOutCachePatches': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hmo", "uBank", "pwpa", "fuCache"]),
        # 
        'midiOutCacheDrumPatches': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hmo", "uPatch", "pwkya", "fuCache"]),
        # 
        'midiOutGetID': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hmo", "puDeviceID"]),
        # 
        'midiOutMessage': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hmo", "uMsg", "dw1", "dw2"]),
        # 
        'midiInGetNumDevs': SimTypeFunction([], SimTypeInt(signed=False, label="UInt32")),
        # 
        'midiInGetDevCapsA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"wMid": SimTypeShort(signed=False, label="UInt16"), "wPid": SimTypeShort(signed=False, label="UInt16"), "vDriverVersion": SimTypeInt(signed=False, label="UInt32"), "szPname": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 32), "dwSupport": SimTypeInt(signed=False, label="UInt32")}, name="MIDIINCAPSA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["uDeviceID", "pmic", "cbmic"]),
        # 
        'midiInGetDevCapsW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"wMid": SimTypeShort(signed=False, label="UInt16"), "wPid": SimTypeShort(signed=False, label="UInt16"), "vDriverVersion": SimTypeInt(signed=False, label="UInt32"), "szPname": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32), "dwSupport": SimTypeInt(signed=False, label="UInt32")}, name="MIDIINCAPSW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["uDeviceID", "pmic", "cbmic"]),
        # 
        'midiInGetErrorTextA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["mmrError", "pszText", "cchText"]),
        # 
        'midiInGetErrorTextW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["mmrError", "pszText", "cchText"]),
        # 
        'midiInOpen': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="MIDI_WAVE_OPEN_TYPE")], SimTypeInt(signed=False, label="UInt32"), arg_names=["phmi", "uDeviceID", "dwCallback", "dwInstance", "fdwOpen"]),
        # 
        'midiInClose': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hmi"]),
        # 
        'midiInPrepareHeader': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"lpData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwBufferLength": SimTypeInt(signed=False, label="UInt32"), "dwBytesRecorded": SimTypeInt(signed=False, label="UInt32"), "dwUser": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "lpNext": SimTypePointer(SimTypeBottom(label="MIDIHDR"), offset=0), "reserved": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwOffset": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeFixedSizeArray(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), 8)}, name="MIDIHDR", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hmi", "pmh", "cbmh"]),
        # 
        'midiInUnprepareHeader': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"lpData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwBufferLength": SimTypeInt(signed=False, label="UInt32"), "dwBytesRecorded": SimTypeInt(signed=False, label="UInt32"), "dwUser": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "lpNext": SimTypePointer(SimTypeBottom(label="MIDIHDR"), offset=0), "reserved": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwOffset": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeFixedSizeArray(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), 8)}, name="MIDIHDR", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hmi", "pmh", "cbmh"]),
        # 
        'midiInAddBuffer': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"lpData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwBufferLength": SimTypeInt(signed=False, label="UInt32"), "dwBytesRecorded": SimTypeInt(signed=False, label="UInt32"), "dwUser": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "lpNext": SimTypePointer(SimTypeBottom(label="MIDIHDR"), offset=0), "reserved": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwOffset": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeFixedSizeArray(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), 8)}, name="MIDIHDR", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hmi", "pmh", "cbmh"]),
        # 
        'midiInStart': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hmi"]),
        # 
        'midiInStop': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hmi"]),
        # 
        'midiInReset': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hmi"]),
        # 
        'midiInGetID': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hmi", "puDeviceID"]),
        # 
        'midiInMessage': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hmi", "uMsg", "dw1", "dw2"]),
        # 
        'auxGetNumDevs': SimTypeFunction([], SimTypeInt(signed=False, label="UInt32")),
        # 
        'auxGetDevCapsA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"wMid": SimTypeShort(signed=False, label="UInt16"), "wPid": SimTypeShort(signed=False, label="UInt16"), "vDriverVersion": SimTypeInt(signed=False, label="UInt32"), "szPname": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 32), "wTechnology": SimTypeShort(signed=False, label="UInt16"), "wReserved1": SimTypeShort(signed=False, label="UInt16"), "dwSupport": SimTypeInt(signed=False, label="UInt32")}, name="AUXCAPSA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["uDeviceID", "pac", "cbac"]),
        # 
        'auxGetDevCapsW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"wMid": SimTypeShort(signed=False, label="UInt16"), "wPid": SimTypeShort(signed=False, label="UInt16"), "vDriverVersion": SimTypeInt(signed=False, label="UInt32"), "szPname": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32), "wTechnology": SimTypeShort(signed=False, label="UInt16"), "wReserved1": SimTypeShort(signed=False, label="UInt16"), "dwSupport": SimTypeInt(signed=False, label="UInt32")}, name="AUXCAPSW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["uDeviceID", "pac", "cbac"]),
        # 
        'auxSetVolume': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["uDeviceID", "dwVolume"]),
        # 
        'auxGetVolume': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["uDeviceID", "pdwVolume"]),
        # 
        'auxOutMessage': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["uDeviceID", "uMsg", "dw1", "dw2"]),
        # 
        'mixerGetNumDevs': SimTypeFunction([], SimTypeInt(signed=False, label="UInt32")),
        # 
        'mixerGetDevCapsA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"wMid": SimTypeShort(signed=False, label="UInt16"), "wPid": SimTypeShort(signed=False, label="UInt16"), "vDriverVersion": SimTypeInt(signed=False, label="UInt32"), "szPname": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 32), "fdwSupport": SimTypeInt(signed=False, label="UInt32"), "cDestinations": SimTypeInt(signed=False, label="UInt32")}, name="MIXERCAPSA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["uMxId", "pmxcaps", "cbmxcaps"]),
        # 
        'mixerGetDevCapsW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"wMid": SimTypeShort(signed=False, label="UInt16"), "wPid": SimTypeShort(signed=False, label="UInt16"), "vDriverVersion": SimTypeInt(signed=False, label="UInt32"), "szPname": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32), "fdwSupport": SimTypeInt(signed=False, label="UInt32"), "cDestinations": SimTypeInt(signed=False, label="UInt32")}, name="MIXERCAPSW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["uMxId", "pmxcaps", "cbmxcaps"]),
        # 
        'mixerOpen': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["phmx", "uMxId", "dwCallback", "dwInstance", "fdwOpen"]),
        # 
        'mixerClose': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hmx"]),
        # 
        'mixerMessage': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hmx", "uMsg", "dwParam1", "dwParam2"]),
        # 
        'mixerGetLineInfoA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwDestination": SimTypeInt(signed=False, label="UInt32"), "dwSource": SimTypeInt(signed=False, label="UInt32"), "dwLineID": SimTypeInt(signed=False, label="UInt32"), "fdwLine": SimTypeInt(signed=False, label="UInt32"), "dwUser": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwComponentType": SimTypeInt(signed=False, label="MIXERLINE_COMPONENTTYPE"), "cChannels": SimTypeInt(signed=False, label="UInt32"), "cConnections": SimTypeInt(signed=False, label="UInt32"), "cControls": SimTypeInt(signed=False, label="UInt32"), "szShortName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 16), "szName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 64), "Target": SimStruct({"dwType": SimTypeInt(signed=False, label="UInt32"), "dwDeviceID": SimTypeInt(signed=False, label="UInt32"), "wMid": SimTypeShort(signed=False, label="UInt16"), "wPid": SimTypeShort(signed=False, label="UInt16"), "vDriverVersion": SimTypeInt(signed=False, label="UInt32"), "szPname": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 32)}, name="_Target_e__Struct", pack=False, align=None)}, name="MIXERLINEA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hmxobj", "pmxl", "fdwInfo"]),
        # 
        'mixerGetLineInfoW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwDestination": SimTypeInt(signed=False, label="UInt32"), "dwSource": SimTypeInt(signed=False, label="UInt32"), "dwLineID": SimTypeInt(signed=False, label="UInt32"), "fdwLine": SimTypeInt(signed=False, label="UInt32"), "dwUser": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "dwComponentType": SimTypeInt(signed=False, label="MIXERLINE_COMPONENTTYPE"), "cChannels": SimTypeInt(signed=False, label="UInt32"), "cConnections": SimTypeInt(signed=False, label="UInt32"), "cControls": SimTypeInt(signed=False, label="UInt32"), "szShortName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 16), "szName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 64), "Target": SimStruct({"dwType": SimTypeInt(signed=False, label="UInt32"), "dwDeviceID": SimTypeInt(signed=False, label="UInt32"), "wMid": SimTypeShort(signed=False, label="UInt16"), "wPid": SimTypeShort(signed=False, label="UInt16"), "vDriverVersion": SimTypeInt(signed=False, label="UInt32"), "szPname": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32)}, name="_Target_e__Struct", pack=False, align=None)}, name="MIXERLINEW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hmxobj", "pmxl", "fdwInfo"]),
        # 
        'mixerGetID': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hmxobj", "puMxId", "fdwId"]),
        # 
        'mixerGetLineControlsA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwLineID": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"dwControlID": SimTypeInt(signed=False, label="UInt32"), "dwControlType": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "cControls": SimTypeInt(signed=False, label="UInt32"), "cbmxctrl": SimTypeInt(signed=False, label="UInt32"), "pamxctrl": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwControlID": SimTypeInt(signed=False, label="UInt32"), "dwControlType": SimTypeInt(signed=False, label="UInt32"), "fdwControl": SimTypeInt(signed=False, label="UInt32"), "cMultipleItems": SimTypeInt(signed=False, label="UInt32"), "szShortName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 16), "szName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 64), "Bounds": SimUnion({"Anonymous1": SimStruct({"lMinimum": SimTypeInt(signed=True, label="Int32"), "lMaximum": SimTypeInt(signed=True, label="Int32")}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"dwMinimum": SimTypeInt(signed=False, label="UInt32"), "dwMaximum": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous2_e__Struct", pack=False, align=None), "dwReserved": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 6)}, name="<anon>", label="None"), "Metrics": SimUnion({"cSteps": SimTypeInt(signed=False, label="UInt32"), "cbCustomData": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 6)}, name="<anon>", label="None")}, name="MIXERCONTROLA", pack=False, align=None), offset=0)}, name="MIXERLINECONTROLSA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hmxobj", "pmxlc", "fdwControls"]),
        # 
        'mixerGetLineControlsW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwLineID": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"dwControlID": SimTypeInt(signed=False, label="UInt32"), "dwControlType": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "cControls": SimTypeInt(signed=False, label="UInt32"), "cbmxctrl": SimTypeInt(signed=False, label="UInt32"), "pamxctrl": SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwControlID": SimTypeInt(signed=False, label="UInt32"), "dwControlType": SimTypeInt(signed=False, label="UInt32"), "fdwControl": SimTypeInt(signed=False, label="UInt32"), "cMultipleItems": SimTypeInt(signed=False, label="UInt32"), "szShortName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 16), "szName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 64), "Bounds": SimUnion({"Anonymous1": SimStruct({"lMinimum": SimTypeInt(signed=True, label="Int32"), "lMaximum": SimTypeInt(signed=True, label="Int32")}, name="_Anonymous1_e__Struct", pack=False, align=None), "Anonymous2": SimStruct({"dwMinimum": SimTypeInt(signed=False, label="UInt32"), "dwMaximum": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous2_e__Struct", pack=False, align=None), "dwReserved": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 6)}, name="<anon>", label="None"), "Metrics": SimUnion({"cSteps": SimTypeInt(signed=False, label="UInt32"), "cbCustomData": SimTypeInt(signed=False, label="UInt32"), "dwReserved": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 6)}, name="<anon>", label="None")}, name="MIXERCONTROLW", pack=False, align=None), offset=0)}, name="MIXERLINECONTROLSW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hmxobj", "pmxlc", "fdwControls"]),
        # 
        'mixerGetControlDetailsA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwControlID": SimTypeInt(signed=False, label="UInt32"), "cChannels": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"hwndOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "cMultipleItems": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "cbDetails": SimTypeInt(signed=False, label="UInt32"), "paDetails": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="MIXERCONTROLDETAILS", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hmxobj", "pmxcd", "fdwDetails"]),
        # 
        'mixerGetControlDetailsW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwControlID": SimTypeInt(signed=False, label="UInt32"), "cChannels": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"hwndOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "cMultipleItems": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "cbDetails": SimTypeInt(signed=False, label="UInt32"), "paDetails": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="MIXERCONTROLDETAILS", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hmxobj", "pmxcd", "fdwDetails"]),
        # 
        'mixerSetControlDetails': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbStruct": SimTypeInt(signed=False, label="UInt32"), "dwControlID": SimTypeInt(signed=False, label="UInt32"), "cChannels": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"hwndOwner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "cMultipleItems": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "cbDetails": SimTypeInt(signed=False, label="UInt32"), "paDetails": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="MIXERCONTROLDETAILS", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hmxobj", "pmxcd", "fdwDetails"]),
        # 
        'timeGetSystemTime': SimTypeFunction([SimTypePointer(SimStruct({"wType": SimTypeInt(signed=False, label="UInt32"), "u": SimUnion({"ms": SimTypeInt(signed=False, label="UInt32"), "sample": SimTypeInt(signed=False, label="UInt32"), "cb": SimTypeInt(signed=False, label="UInt32"), "ticks": SimTypeInt(signed=False, label="UInt32"), "smpte": SimStruct({"hour": SimTypeChar(label="Byte"), "min": SimTypeChar(label="Byte"), "sec": SimTypeChar(label="Byte"), "frame": SimTypeChar(label="Byte"), "fps": SimTypeChar(label="Byte"), "dummy": SimTypeChar(label="Byte"), "pad": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2)}, name="_smpte_e__Struct", pack=False, align=None), "midi": SimStruct({"songptrpos": SimTypeInt(signed=False, label="UInt32")}, name="_midi_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="MMTIME", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["pmmt", "cbmmt"]),
        # 
        'timeGetTime': SimTypeFunction([], SimTypeInt(signed=False, label="UInt32")),
        # 
        'timeGetDevCaps': SimTypeFunction([SimTypePointer(SimStruct({"wPeriodMin": SimTypeInt(signed=False, label="UInt32"), "wPeriodMax": SimTypeInt(signed=False, label="UInt32")}, name="TIMECAPS", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["ptc", "cbtc"]),
        # 
        'timeBeginPeriod': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["uPeriod"]),
        # 
        'timeEndPeriod': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["uPeriod"]),
        # 
        'joyGetPosEx': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "dwXpos": SimTypeInt(signed=False, label="UInt32"), "dwYpos": SimTypeInt(signed=False, label="UInt32"), "dwZpos": SimTypeInt(signed=False, label="UInt32"), "dwRpos": SimTypeInt(signed=False, label="UInt32"), "dwUpos": SimTypeInt(signed=False, label="UInt32"), "dwVpos": SimTypeInt(signed=False, label="UInt32"), "dwButtons": SimTypeInt(signed=False, label="UInt32"), "dwButtonNumber": SimTypeInt(signed=False, label="UInt32"), "dwPOV": SimTypeInt(signed=False, label="UInt32"), "dwReserved1": SimTypeInt(signed=False, label="UInt32"), "dwReserved2": SimTypeInt(signed=False, label="UInt32")}, name="JOYINFOEX", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["uJoyID", "pji"]),
        # 
        'joyGetNumDevs': SimTypeFunction([], SimTypeInt(signed=False, label="UInt32")),
        # 
        'joyGetDevCapsA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"wMid": SimTypeShort(signed=False, label="UInt16"), "wPid": SimTypeShort(signed=False, label="UInt16"), "szPname": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 32), "wXmin": SimTypeInt(signed=False, label="UInt32"), "wXmax": SimTypeInt(signed=False, label="UInt32"), "wYmin": SimTypeInt(signed=False, label="UInt32"), "wYmax": SimTypeInt(signed=False, label="UInt32"), "wZmin": SimTypeInt(signed=False, label="UInt32"), "wZmax": SimTypeInt(signed=False, label="UInt32"), "wNumButtons": SimTypeInt(signed=False, label="UInt32"), "wPeriodMin": SimTypeInt(signed=False, label="UInt32"), "wPeriodMax": SimTypeInt(signed=False, label="UInt32"), "wRmin": SimTypeInt(signed=False, label="UInt32"), "wRmax": SimTypeInt(signed=False, label="UInt32"), "wUmin": SimTypeInt(signed=False, label="UInt32"), "wUmax": SimTypeInt(signed=False, label="UInt32"), "wVmin": SimTypeInt(signed=False, label="UInt32"), "wVmax": SimTypeInt(signed=False, label="UInt32"), "wCaps": SimTypeInt(signed=False, label="UInt32"), "wMaxAxes": SimTypeInt(signed=False, label="UInt32"), "wNumAxes": SimTypeInt(signed=False, label="UInt32"), "wMaxButtons": SimTypeInt(signed=False, label="UInt32"), "szRegKey": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 32), "szOEMVxD": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 260)}, name="JOYCAPSA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["uJoyID", "pjc", "cbjc"]),
        # 
        'joyGetDevCapsW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"wMid": SimTypeShort(signed=False, label="UInt16"), "wPid": SimTypeShort(signed=False, label="UInt16"), "szPname": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32), "wXmin": SimTypeInt(signed=False, label="UInt32"), "wXmax": SimTypeInt(signed=False, label="UInt32"), "wYmin": SimTypeInt(signed=False, label="UInt32"), "wYmax": SimTypeInt(signed=False, label="UInt32"), "wZmin": SimTypeInt(signed=False, label="UInt32"), "wZmax": SimTypeInt(signed=False, label="UInt32"), "wNumButtons": SimTypeInt(signed=False, label="UInt32"), "wPeriodMin": SimTypeInt(signed=False, label="UInt32"), "wPeriodMax": SimTypeInt(signed=False, label="UInt32"), "wRmin": SimTypeInt(signed=False, label="UInt32"), "wRmax": SimTypeInt(signed=False, label="UInt32"), "wUmin": SimTypeInt(signed=False, label="UInt32"), "wUmax": SimTypeInt(signed=False, label="UInt32"), "wVmin": SimTypeInt(signed=False, label="UInt32"), "wVmax": SimTypeInt(signed=False, label="UInt32"), "wCaps": SimTypeInt(signed=False, label="UInt32"), "wMaxAxes": SimTypeInt(signed=False, label="UInt32"), "wNumAxes": SimTypeInt(signed=False, label="UInt32"), "wMaxButtons": SimTypeInt(signed=False, label="UInt32"), "szRegKey": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 32), "szOEMVxD": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 260)}, name="JOYCAPSW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["uJoyID", "pjc", "cbjc"]),
        # 
        'joyGetPos': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"wXpos": SimTypeInt(signed=False, label="UInt32"), "wYpos": SimTypeInt(signed=False, label="UInt32"), "wZpos": SimTypeInt(signed=False, label="UInt32"), "wButtons": SimTypeInt(signed=False, label="UInt32")}, name="JOYINFO", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["uJoyID", "pji"]),
        # 
        'joyGetThreshold': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["uJoyID", "puThreshold"]),
        # 
        'joyReleaseCapture': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["uJoyID"]),
        # 
        'joySetCapture': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwnd", "uJoyID", "uPeriod", "fChanged"]),
        # 
        'joySetThreshold': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["uJoyID", "uThreshold"]),
        # 
        'mmTaskCreate': SimTypeFunction([SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeBottom(label="Void"), arg_names=["dwInst"]), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpfn", "lph", "dwInst"]),
        # 
        'mmTaskBlock': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["h"]),
        # 
        'mmTaskSignal': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["h"]),
        # 
        'mmTaskYield': SimTypeFunction([], SimTypeBottom(label="Void")),
        # 
        'mmGetCurrentTask': SimTypeFunction([], SimTypeInt(signed=False, label="UInt32")),
        # 
        'timeSetEvent': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeBottom(label="Void"), arg_names=["uTimerID", "uMsg", "dwUser", "dw1", "dw2"]), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["uDelay", "uResolution", "fptc", "dwUser", "fuEvent"]),
        # 
        'timeKillEvent': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["uTimerID"]),
    }

lib.set_prototypes(prototypes)
