/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
import { IdentityPool, IdentityPoolProps } from "@aws-cdk/aws-cognito-identitypool-alpha";
import { UserPool, UserPoolClient } from "aws-cdk-lib/aws-cognito";
import { Construct } from "constructs";
/**
 * Properties which configures the Identity Pool.
 */
export interface UserIdentityProps {
    /**
     * User provided Cognito UserPool.
     *
     * @default - a userpool with mfa will be created.
     */
    readonly userPool?: UserPool;
    /**
     * Configuration for the Identity Pool.
     */
    readonly identityPoolOptions?: IdentityPoolProps;
}
/**
 * Creates a UserPool and Identity Pool with sane defaults configured intended for usage from a web client.
 */
export declare class UserIdentity extends Construct {
    readonly identityPool: IdentityPool;
    readonly userPool: UserPool;
    readonly userPoolClient: UserPoolClient;
    constructor(scope: Construct, id: string, props?: UserIdentityProps);
}
