/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
import { PythonProject } from "projen/lib/python";
import { CodeGenerationSourceOptions, GeneratedPythonRuntimeOptions } from "../../types";
/**
 * Configuration for the generated python types project
 */
export interface GeneratedPythonTypesProjectOptions extends GeneratedPythonRuntimeOptions, CodeGenerationSourceOptions {
}
/**
 * Python project containing types generated using OpenAPI Generator CLI
 */
export declare class GeneratedPythonRuntimeProject extends PythonProject {
    /**
     * Patterns that are excluded from code generation
     */
    static openApiIgnorePatterns: string[];
    /**
     * Options configured for the project
     * @private
     */
    private readonly options;
    constructor(options: GeneratedPythonTypesProjectOptions);
    buildGenerateCommandArgs: () => string;
}
