"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PRICING_SLUGS = exports.PRICING_MANIFEST = void 0;
// AUTO-GENERATED - DO NOT EDIT
/* eslint-disable */
exports.PRICING_MANIFEST = {
    "awsApplicationMigrationSvc": {
        "name": " AWS Application Migration Service",
        "serviceCode": "awsApplicationMigrationSvc",
        "description": "AWS Application Migration Service minimizes time-intensive, error-prone manual processes by automatically converting your source servers from physical, virtual, and cloud infrastructure to run natively on AWS. It further simplifies your migration by allowing you to use the same automated process for a wide range of applications.",
        "searchKeywords": [
            "Application Migration Service",
            "migrating applications",
            "migration",
            "SAP",
            "Oracle",
            "SQL Server",
            "CloudEndure Migration"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/application-migration-service/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsApplicationMigrationSvc/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsApplicationMigrationSvc/en_US.json",
        "slug": "appmigrationsvc",
        "mvpSupport": false,
        "comparableTerms": [
            "applicationmigration",
            "applicationmigrationservice",
            "applicationmigrationsvc",
            "appmigration",
            "appmigrationsvc"
        ]
    },
    "activeCustomBatchTranslation": {
        "name": "Active Custom Batch Translation",
        "serviceCode": "activeCustomBatchTranslation",
        "description": "Amazon Translate is a neural machine translation service that delivers fast, high-quality, and affordable language translation. Neural machine translation is a form of language translation automation that uses deep learning models to deliver more accurate and more natural sounding translation than traditional statistical and rule-based translation algorithms.",
        "searchKeywords": [
            "NLP",
            "Natural language processing",
            "language transalation",
            "Text analytics",
            "Language translation",
            "Amazon translate",
            "Translate"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "eu-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/translate/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/activeCustomBatchTranslation/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/activeCustomBatchTranslation/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "activecustombatchtranslation"
        ],
        "parentServiceCode": "amazonTranslate"
    },
    "amazonApiGateway": {
        "name": "Amazon API Gateway",
        "serviceCode": "amazonApiGateway",
        "description": "Amazon API Gateway is a fully managed service that makes it easy for developers to create, publish, maintain, monitor, and secure APIs at any scale. APIs act as the front door for applications to access data, business logic, or functionality from your backend services.",
        "searchKeywords": [
            "API",
            "api",
            "Rest",
            "websocket",
            "messages"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/api-gateway/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonApiGateway/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonApiGateway/en_US.json",
        "slug": "APIGateway",
        "mvpSupport": false,
        "comparableTerms": [
            "apigateway"
        ]
    },
    "amazonAppFlow": {
        "name": "Amazon AppFlow",
        "serviceCode": "amazonAppFlow",
        "description": "Amazon AppFlow offers significant cost-savings advantage compared to building connectors in-house or using other application integration services. There are no upfront charges or fees to use AppFlow, and customers only pay for the number of flows they run and the volume of data processed.",
        "searchKeywords": [
            "appflow",
            "Amazon AppFlow",
            "App Flow",
            "AWS appflow"
        ],
        "type": "AWSService",
        "regions": [
            "ap-south-1",
            "af-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/appflow/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonAppFlow/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonAppFlow/en_US.json",
        "slug": "Appflow",
        "mvpSupport": false,
        "comparableTerms": [
            "appflow"
        ]
    },
    "amazonAppStream": {
        "name": "Amazon AppStream 2.0",
        "serviceCode": "amazonAppStream",
        "description": "Amazon AppStream 2.0 is a fully managed service that provides secure, reliable, and scalable access to applications and non-persistent desktops from any location.",
        "searchKeywords": [
            "streaming",
            "app"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "ap-south-1",
            "us-west-2",
            "us-gov-west-1",
            "ap-southeast-2",
            "eu-west-1",
            "ap-northeast-2",
            "eu-central-1",
            "ap-northeast-1",
            "eu-west-2",
            "ap-southeast-1",
            "ca-central-1"
        ],
        "linkUrl": "https://aws.amazon.com/appstream2/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonAppStream/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/amazonAppStream/en_US.json",
        "slug": "AppStream",
        "mvpSupport": false,
        "comparableTerms": [
            "appstream",
            "appstream2",
            "appstream20"
        ]
    },
    "amazonAthena": {
        "name": "Amazon Athena",
        "serviceCode": "amazonAthena",
        "description": "Amazon Athena is a serverless, interactive analytics service built on open-source frameworks. Athena provides a simplified, flexible way to analyze petabytes of data where it lives. With Athena, you pay only for what you use. There are no upfront fees and no long-term commitments.",
        "searchKeywords": [
            "Analytics",
            "SQL",
            "query",
            "S3",
            "big data",
            "Presto",
            "serverless",
            "ad-hoc analysis",
            "log processing",
            "bigquery",
            "big query",
            "query S3 data",
            "spark",
            "spark session",
            "code execustion"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "sa-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/athena/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonAthena/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonAthena/en_US.json",
        "slug": "Athena",
        "mvpSupport": false,
        "comparableTerms": [
            "athena"
        ]
    },
    "amazonAugmentedAi": {
        "name": "Amazon Augmented AI",
        "serviceCode": "amazonAugmentedAi",
        "description": "Amazon Augmented AI (Amazon A2I) allows humans and machine learning models to work together to increase the speed and accuracy of machine learning (ML) models. When human review is needed, Amazon A2I guides a human reviewer step-by-step in a process called a workflow.",
        "searchKeywords": [
            "textract",
            "text",
            "custom images",
            "images",
            "rekognition"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/augmented-ai/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonAugmentedAi/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonAugmentedAi/en_US.json",
        "slug": "a2i",
        "mvpSupport": false,
        "comparableTerms": [
            "a2i",
            "augmentedai"
        ]
    },
    "amazonAuroraMySQLCompatible": {
        "name": "Amazon Aurora MySQL-Compatible",
        "serviceCode": "amazonAuroraMySQLCompatible",
        "description": "Amazon Aurora MySQL Compatible relational database is built for the cloud, that combines  performance and availability of traditional enterprise databases with the simplicity and cost-effectiveness of open source databases.",
        "searchKeywords": [
            "Database",
            "Aurora",
            "MySQL",
            "MariaDB",
            "Postgres",
            "Oracle",
            "SQL Server",
            "Database",
            "PostgreSQL",
            "Microsoft SQL Server",
            "Relational Database Service",
            "Database",
            "database hosting",
            "hosted database",
            "Managed database"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/rds/aurora/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonAuroraMySQLCompatible/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonAuroraMySQLCompatible/en_US.json",
        "slug": "AuroraMySQL",
        "mvpSupport": false,
        "comparableTerms": [
            "auroramysql",
            "auroramysqlcompatible",
            "rdsaurora"
        ]
    },
    "amazonRDSAuroraPostgreSQLCompatibleDB": {
        "name": "Amazon Aurora PostgreSQL-Compatible DB",
        "serviceCode": "amazonRDSAuroraPostgreSQLCompatibleDB",
        "description": "Amazon Aurora is a MySQL and PostgreSQL-compatible relational database built for the cloud, that combines the performance and availability of traditional enterprise databases with the simplicity and cost-effectiveness of open source databases.",
        "searchKeywords": [
            "Database",
            "PostgreSQL",
            "Aurora",
            "database hosting",
            "hosted database",
            "Managed database"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/aurora/",
        "isActive": "true",
        "hasDataTransfer": false,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRDSAuroraPostgreSQLCompatibleDB/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonRDSAuroraPostgreSQLCompatibleDB/en_US.json",
        "slug": "AuroraPostgreSQL",
        "mvpSupport": false,
        "comparableTerms": [
            "aurora",
            "aurorapostgresql",
            "aurorapostgresqlcompatibledb",
            "rdsaurorapostgresqlcompatibledb"
        ]
    },
    "amazonBraket": {
        "name": "Amazon Braket",
        "serviceCode": "amazonBraket",
        "description": "Amazon Braket is a fully managed quantum computing service that helps researchers and developers get started with the technology to accelerate research and discovery. Amazon Braket provides a development environment for you to explore and build quantum algorithms, test them on quantum circuit simulators, and run them on different quantum hardware technologies.",
        "searchKeywords": [
            "quantum",
            "compute",
            "computing",
            "simulators",
            "algorithms",
            "Sagemaker",
            "notebooks"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-west-1",
            "us-west-2",
            "eu-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/braket/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonBraket/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/amazonBraket/en_US.json",
        "slug": "Braket",
        "mvpSupport": false,
        "comparableTerms": [
            "braket"
        ]
    },
    "amazonCarrierIp": {
        "name": "Amazon Carrier IP",
        "serviceCode": "amazonCarrierIp",
        "description": "A Carrier IP address is the address that you assign to a network interface, which resides in a subnet in a Wavelength Zone (for example an EC2 instance)",
        "searchKeywords": [
            "Compute",
            "Carrier",
            "Elastic Compute Cloud",
            "spot instance",
            "load balancing",
            "elb",
            "elastic load balancer",
            "auto scaling",
            "auto scaling groups",
            "application load balancer",
            "ALB",
            "spot requests",
            "reserved instances",
            "scheduled instances",
            "dedicated hosts",
            "AMIs",
            "CIPs",
            "Bundle tasks",
            "Volumes",
            "Snapshots",
            "Images",
            "Elastic Block Store",
            "block storage",
            "Security groups",
            "Elastic IP",
            "placement groups",
            "key pairs",
            "network interfaces",
            "load balancers",
            "target groups",
            "auto scaler",
            "launch configurations",
            "EBS",
            "ASG",
            "commands",
            "command history",
            "managed instances",
            "activations"
        ],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1-wl1-kix1",
            "ap-northeast-1-wl1-nrt1",
            "ap-northeast-2-wl1-cjj1",
            "ap-northeast-2-wl1-sel1",
            "ca-central-1-wl1-yto1",
            "eu-west-2-wl1-lon1",
            "eu-central-1-wl1-ber1",
            "eu-central-1-wl1-dtm1",
            "eu-central-1-wl1-muc1",
            "us-east-1-wl1",
            "us-east-1-wl1-atl1",
            "us-east-1-wl1-clt1",
            "us-east-1-wl1-chi1",
            "us-east-1-wl1-dfw1",
            "us-east-1-wl1-dtw1",
            "us-east-1-wl1-iah1",
            "us-east-1-wl1-mia1",
            "us-east-1-wl1-msp1",
            "us-east-1-wl1-bna1",
            "us-east-1-wl1-nyc1",
            "us-east-1-wl1-tpa1",
            "us-east-1-wl1-was1",
            "us-west-2-wl1-den1",
            "us-west-2-wl1-las1",
            "us-west-2-wl1-lax1",
            "us-west-2-wl1-phx1",
            "us-west-2-wl1-sea1",
            "us-west-2-wl1"
        ],
        "linkUrl": "https://aws.amazon.com/ec2/pricing/on-demand/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonCarrierIp/en_US.json",
        "c2e": false,
        "slug": "CarrierIP",
        "mvpSupport": false,
        "comparableTerms": [
            "carrierip"
        ]
    },
    "amazonChime": {
        "name": "Amazon Chime",
        "serviceCode": "amazonChime",
        "description": "Amazon Chime is a communications service that lets you meet, chat, and place business calls inside and outside your organization, all using a single application.",
        "searchKeywords": [
            "Chime",
            "Business Calling"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/chime/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonChime/en_US.json",
        "c2e": false,
        "templates": [
            "chimeCostAnalysis",
            "chimeBusinessCallingAnalysis"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonChime/en_US.json",
        "slug": "Chime",
        "mvpSupport": false,
        "comparableTerms": [
            "chime"
        ]
    },
    "chimeBusinessCallingAnalysis": {
        "name": "Amazon Chime Business Calling analysis",
        "serviceCode": "chimeBusinessCallingAnalysis",
        "description": "Amazon Chime lets you meet, chat, and collaborate with the security of AWS. You can work seamlessly on your devices, and meet from your desk or on the go - ensuring you always stay connected.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/chime/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/chimeBusinessCallingAnalysis/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/chimeBusinessCallingAnalysis/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "chimebusinesscallinganalysis"
        ],
        "parentServiceCode": "amazonChime"
    },
    "amazonChimeTCO": {
        "name": "Amazon Chime cost comparison tool",
        "serviceCode": "amazonChimeTCO",
        "description": "Amazon Chime lets you meet, chat, and collaborate with the security of AWS. You can work seamlessly on your devices, and meet from your desk or on the go - ensuring you always stay connected.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/chime/",
        "isActive": "true",
        "subType": "TCOCalculator",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonChimeTCO/en_US.json",
        "c2e": false,
        "comparableTerms": [
            "chimecostcomparisontool",
            "chimetco"
        ]
    },
    "chimeCostAnalysis": {
        "name": "Amazon Chime Meetings App",
        "serviceCode": "chimeCostAnalysis",
        "description": "Amazon Chime lets you meet, chat, and collaborate with the security of AWS. You can work seamlessly on your devices, and meet from your desk or on the go - ensuring you always stay connected.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/chime/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/chimeCostAnalysis/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/chimeCostAnalysis/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "chimecostanalysis",
            "chimemeetingsapp"
        ],
        "parentServiceCode": "amazonChime"
    },
    "amazonChimeSdk": {
        "name": "Amazon Chime SDK",
        "serviceCode": "amazonChimeSdk",
        "description": "With the Amazon Chime SDK, builders can easily add real-time voice, video, and messaging powered by machine learning into their applications.",
        "searchKeywords": [
            "Chimesdk",
            "messaging",
            "SIP trunking",
            "webrtc media",
            "proxy phone session"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/chime/chime-sdk/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonChimeSdk/en_US.json",
        "c2e": false,
        "templates": [
            "webRtcMedia",
            "ptsnAudio",
            "sipTrunking",
            "chimeSdkMessaging",
            "proxyPhoneSession",
            "chimeSdkCallAnalyticsAndRecording"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonChimeSdk/en_US.json",
        "slug": "ChimeSDK",
        "mvpSupport": false,
        "comparableTerms": [
            "chimechimesdk",
            "chimesdk"
        ]
    },
    "amazonCloudFront": {
        "name": "Amazon CloudFront",
        "serviceCode": "amazonCloudFront",
        "description": "Amazon CloudFront is a fast content delivery network (CDN) service that securely delivers data, videos, applications, and APIs to customers globally with low latency, high transfer speeds, all within a developer-friendly environment.",
        "searchKeywords": [
            "cloudfront",
            "CDN"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/cloudfront/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonCloudFront/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonCloudFront/en_US.json",
        "slug": "CloudFront",
        "mvpSupport": false,
        "comparableTerms": [
            "cloudfront"
        ]
    },
    "amazonCloudWatch": {
        "name": "Amazon CloudWatch",
        "serviceCode": "amazonCloudWatch",
        "description": "Amazon CloudWatch is a monitoring and management service that provides data and actionable insights for AWS, hybrid, and on-premises applications and infrastructure resources.",
        "searchKeywords": [
            "Management Tools",
            "CW",
            "monitoring",
            "metrics",
            "graphs",
            "logs",
            "dashboard",
            "events",
            "alarms",
            "monitoring scripts",
            "management tools",
            "monitoring service",
            "network monitoring"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/cloudwatch/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonCloudWatch/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonCloudWatch/en_US.json",
        "slug": "CloudWatch",
        "mvpSupport": false,
        "comparableTerms": [
            "cloudwatch"
        ]
    },
    "amazonCodeGuru": {
        "name": "Amazon CodeGuru Reviewer",
        "serviceCode": "amazonCodeGuru",
        "description": "Amazon CodeGuru Reviewer is a service that uses program analysis and machine learning to detect potential defects that are difficult for developers to find and recommends fixes in your Java code.",
        "searchKeywords": [
            "CodeGuru",
            "Reviewer",
            "code reviews",
            "package scan",
            "pull request",
            "code analysis",
            "code quality"
        ],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/codeguru/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonCodeGuru/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonCodeGuru/en_US.json",
        "slug": "CodeGuruReviewer",
        "mvpSupport": false,
        "comparableTerms": [
            "codeguru",
            "codegurureviewer"
        ]
    },
    "codeGuruReviewer": {
        "name": "Amazon CodeGuru Reviewer Test",
        "serviceCode": "codeGuruReviewer",
        "description": "Amazon CodeGuru Reviewer is a service that uses program analysis and machine learning to detect potential defects that are difficult for developers to find and recommends fixes in your Java code.",
        "searchKeywords": [
            "CodeGuru",
            "Reviewer",
            "code reviews",
            "package scan",
            "pull request",
            "code analysis",
            "code quality"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "eu-west-1",
            "ap-southeast-2"
        ],
        "linkUrl": "https://docs.aws.amazon.com/codeguru/index.html",
        "isActive": "false",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/codeGuruReviewer/en_US.json",
        "c2e": false,
        "slug": "CodeGuruReviewerv2",
        "comparableTerms": [
            "codeguru",
            "codegurureviewer",
            "codegurureviewertest"
        ]
    },
    "amazonCodeWhisperer": {
        "name": "Amazon CodeWhisperer",
        "serviceCode": "amazonCodeWhisperer",
        "description": "Amazon CodeWhisperer provides developers with real-time code suggestions directly in the integrated development environment (IDE).",
        "searchKeywords": [
            "codewhisperer",
            "code whisperer"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/codewhisperer/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonCodeWhisperer/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonCodeWhisperer/en_US.json",
        "slug": "codewhisperer",
        "mvpSupport": false,
        "comparableTerms": [
            "codewhisperer"
        ]
    },
    "amazonCognito": {
        "name": "Amazon Cognito",
        "serviceCode": "amazonCognito",
        "description": "Amazon Cognito lets you add user sign-up, sign-in, and access control to your web and mobile apps quickly and easily. Amazon Cognito scales to millions of users and supports sign-in with social identity providers, such as Facebook, Google, and Amazon, and enterprise identity providers via SAML 2.0.",
        "searchKeywords": [
            "apps",
            "security",
            "access",
            "control",
            "cognito",
            "MAU",
            "SMAL",
            "OIDC"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "eu-north-1",
            "sa-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/cognito/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonCognito/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonCognito/en_US.json",
        "slug": "Cognito",
        "mvpSupport": false,
        "comparableTerms": [
            "cognito"
        ]
    },
    "amazonComprehend": {
        "name": "Amazon Comprehend",
        "serviceCode": "amazonComprehend",
        "description": "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/comprehend",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonComprehend/en_US.json",
        "c2e": false,
        "templates": [
            "piiDetection",
            "containsPii",
            "entityRecognition",
            "sentimentAnalysis",
            "targetedSentiment",
            "comprehendCustomClassification",
            "comprehendCustomEntities",
            "keyPhraseExtraction",
            "languageDetection",
            "syntaxAnalysis",
            "comprehendTopicModeling",
            "eventDetectionPerEventType"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonComprehend/en_US.json",
        "slug": "Comprehend",
        "mvpSupport": false,
        "comparableTerms": [
            "comprehend"
        ]
    },
    "amazonComprehendMedical": {
        "name": "Amazon Comprehend Medical",
        "serviceCode": "amazonComprehendMedical",
        "description": "Amazon Comprehend Medical is a HIPAA-eligible natural language processing (NLP) service that uses machine learning to extract health data from medical text–no machine learning experience is required.",
        "searchKeywords": [
            "Comprehend Medical",
            "NLP",
            "Natural language processing"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/comprehend/medical/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonComprehendMedical/en_US.json",
        "c2e": false,
        "templates": [
            "medicalNamedEntityAndRelationshipExtractionNeReApi",
            "medicalProtectedHealthInformationDataExtractionAndIdentificationPhIdApi",
            "medicalIcd10CmOntologyLinkingApi",
            "medicalSystematizedNomenclatureOfMedicineClinicalTermsSnomedCtApi",
            "medicalRxNormOntologyLinkingApi"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonComprehendMedical/en_US.json",
        "slug": "ComprehendMedical",
        "mvpSupport": false,
        "comparableTerms": [
            "comprehendmedical"
        ]
    },
    "amazonDetective": {
        "name": "Amazon Detective",
        "serviceCode": "amazonDetective",
        "description": "Amazon Detective makes it easy to analyze, investigate, and quickly identify the root cause of potential security issues or suspicious activities. Amazon Detective automatically collects log data from your AWS resources and uses machine learning, statistical analysis, and graph theory to build a linked set of data that enables you to easily conduct faster and more efficient security investigations.",
        "searchKeywords": [
            "detective",
            "amazon Detective"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/detective/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonDetective/en_US.json",
        "c2e": false,
        "slug": "detective",
        "mvpSupport": false,
        "comparableTerms": [
            "detective"
        ]
    },
    "amazonDevOpsGuru": {
        "name": "Amazon DevOps Guru",
        "serviceCode": "amazonDevOpsGuru",
        "description": "Amazon DevOps Guru is a Machine Learning (ML) powered service that makes it easy to improve an application’s operational performance and availability. DevOps Guru detects behaviors that deviate from normal operating patterns so you can identify operational issues long before they impact your customers.",
        "searchKeywords": [
            "devops",
            "guru",
            "devopsguru"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/devops-guru/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonDevOpsGuru/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": true,
        "serviceDefinitionUrlPath": "/data/amazonDevOpsGuru/en_US.json",
        "slug": "DevOpsGuru",
        "mvpSupport": false,
        "comparableTerms": [
            "devopsguru"
        ]
    },
    "amazonDocumentDB": {
        "name": "Amazon DocumentDB (with MongoDB compatibility)",
        "serviceCode": "amazonDocumentDB",
        "description": "Amazon DocumentDB (with MongoDB compatibility) is a fast, scalable, highly available, and fully managed document database service that supports MongoDB workloads.",
        "searchKeywords": [
            "docdb",
            "MongoDB",
            "mongodb",
            "document database",
            "DocumentDB"
        ],
        "type": "AWSService",
        "regions": [
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/documentdb/",
        "isActive": "true",
        "hasDataTransfer": true,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonDocumentDB/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonDocumentDB/en_US.json",
        "slug": "DocumentDB",
        "mvpSupport": false,
        "comparableTerms": [
            "documentdb",
            "documentdbwithmongodbcompatibility",
            "withmongodbcompatibility"
        ]
    },
    "amazonDynamoDb": {
        "name": "Amazon DynamoDB",
        "serviceCode": "amazonDynamoDb",
        "description": "Amazon DynamoDB is a key-value and document database that delivers single-digit millisecond performance at any scale. It's a fully managed, multiregion, multimaster, durable database with built-in security, backup and restore, and in-memory caching for internet-scale applications.",
        "searchKeywords": [
            "DynamoDB",
            "Serverless",
            "key-value",
            "Database",
            "DDB",
            "NoSQL",
            "SQL",
            "Table",
            "nosql databases",
            "database schema",
            "database software",
            "cloud database",
            "document database",
            "key value store",
            "database as a service",
            "database scheme",
            "nosql hosting",
            "hosted nosql",
            "data store",
            "unstructured database",
            "Accelerator",
            "DAX"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/dynamodb/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonDynamoDb/en_US.json",
        "c2e": false,
        "templates": [
            "dynamoDbOnDemand",
            "amazonDynamoDbProvisionedThroughputCapacity",
            "amazonDynamoDbDaxClusters",
            "amazonDynamoDbStreams",
            "dynamoDbBackup",
            "dynamoDbChangeDateCapture",
            "dynamoDbDataExportToAmazonS3",
            "dynamoDbDataImportFromAmazonS3"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonDynamoDb/en_US.json",
        "slug": "DynamoDB",
        "mvpSupport": false,
        "comparableTerms": [
            "dynamodb"
        ]
    },
    "eC2Next": {
        "name": "Amazon EC2",
        "serviceCode": "eC2Next",
        "description": "Amazon EC2 offers the broadest and deepest compute platform with choice of processor, storage, networking, operating system, and purchase model.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-1-wl1-nrt1",
            "ap-northeast-2",
            "ap-northeast-2-wl1-cjj1",
            "ap-northeast-2-wl1-sel1",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "eu-central-1-wl1-dtm1",
            "eu-central-1-wl1-ber1",
            "eu-central-1-wl1-muc1",
            "ca-central-1",
            "ca-central-1-wl1-yto1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-2-wl1-lon1",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-1-atl-1",
            "us-east-1-bos-1",
            "us-east-1-chi-1",
            "us-east-1-dfw-1",
            "us-west-2-den-1",
            "us-east-1-iah-1",
            "us-east-1-mci-1",
            "us-east-1-mia-1",
            "us-east-1-msp-1",
            "us-east-1-nyc-1",
            "us-east-1-phl-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2",
            "us-west-2-las-1",
            "us-west-2-lax-1",
            "us-west-2-phx-1",
            "us-west-2-pdx-1",
            "us-west-2-sea-1",
            "us-east-1-wl1",
            "us-east-1-wl1-was1",
            "us-west-2-wl1",
            "us-west-2-wl1-las1",
            "us-west-2-wl1-lax1",
            "us-east-1-wl1-atl1",
            "us-east-1-wl1-chi1",
            "us-east-1-wl1-dfw1",
            "us-east-1-wl1-iah1",
            "us-east-1-wl1-mia1",
            "us-east-1-wl1-nyc1",
            "us-east-1-wl1-clt1",
            "us-east-1-wl1-dtw1",
            "us-east-1-wl1-msp1",
            "us-east-1-wl1-bna1",
            "us-east-1-wl1-tpa1",
            "us-west-2-wl1-den1",
            "us-west-2-wl1-phx1",
            "us-west-2-wl1-sea1"
        ],
        "linkUrl": "https://aws.amazon.com/ec2/",
        "isActive": "false",
        "hasDataTransfer": true,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/eC2Next/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/eC2Next/en_US.json",
        "slug": "EC2",
        "mvpSupport": false,
        "comparableTerms": [
            "ec2",
            "ec2next"
        ]
    },
    "ec2Enhancement": {
        "name": "Amazon EC2 ",
        "serviceCode": "ec2Enhancement",
        "description": "Amazon EC2 provides a wide selection of instance types optimized to fit different use cases. Instance types comprise varying combinations of CPU, memory, storage, and networking capacity and give you the flexibility to choose the appropriate mix of resources for your applications.",
        "searchKeywords": [
            "EC2 Dedicated Hosts",
            "Dedicated Hosts",
            "EC2"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/ec2/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/ec2Enhancement/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": [
            {
                "label": "EC2 Instances",
                "filename": "Amazon_EC2_Instances_BulkUpload_Template_Commercial.xlsx"
            },
            {
                "label": "EC2 Dedicated Hosts",
                "filename": "Amazon_EC2_DedicatedHosts_BulkUpload_Template_Commercial.xlsx"
            }
        ],
        "serviceDefinitionUrlPath": "/data/ec2Enhancement/en_US.json",
        "slug": "ec2-enhancement",
        "mvpSupport": false,
        "comparableTerms": [
            "ec2",
            "ec2enhancement"
        ]
    },
    "amazonEc2DedicatedHosts": {
        "name": "Amazon EC2 Dedicated Hosts",
        "serviceCode": "amazonEc2DedicatedHosts",
        "description": "Amazon EC2 Dedicated Hosts allow you to use your eligible software licenses on Amazon EC2, so that you get the flexibility and cost effectiveness of using your own licenses, but with the resiliency, simplicity and elasticity of AWS. Includes support for EC2 High Memory and EC2 Mac instances.",
        "searchKeywords": [
            "Mac",
            "High memory"
        ],
        "type": "AWSService",
        "regions": [
            "us-west-2",
            "us-west-2-lax-1",
            "us-west-1",
            "us-east-1",
            "us-east-2",
            "sa-east-1",
            "me-south-1",
            "me-central-1",
            "af-south-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-south-1",
            "eu-central-1",
            "ca-central-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-south-1",
            "ap-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/ec2/dedicated-hosts",
        "isActive": "false",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonEc2DedicatedHosts/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": [],
        "serviceDefinitionUrlPath": "/data/amazonEc2DedicatedHosts/en_US.json",
        "slug": "EC2DedicatedHosts",
        "mvpSupport": false,
        "comparableTerms": [
            "ec2dedicatedhosts"
        ]
    },
    "awsEks": {
        "name": "Amazon EKS",
        "serviceCode": "awsEks",
        "description": "Amazon Elastic Kubernetes Service (Amazon EKS) is a fully managed Kubernetes service. Customers such as Intel, Snap, Intuit, GoDaddy, and Autodesk trust EKS to run their most sensitive and mission critical applications because of its security, reliability, and scalability..",
        "searchKeywords": [
            "eks",
            "elastic",
            "kubernetes"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ap-northeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/eks/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsEks/en_US.json",
        "c2e": false,
        "slug": "EKS",
        "mvpSupport": false,
        "comparableTerms": [
            "eks"
        ]
    },
    "amazonElasticBlockStore": {
        "name": "Amazon Elastic Block Store (EBS)",
        "serviceCode": "amazonElasticBlockStore",
        "description": "Amazon Elastic Block Storage (EBS) allows you to create persistent block storage volumes and attach them to Amazon EC2 instances.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-1-wl1-nrt1",
            "ap-northeast-2",
            "ap-northeast-2-wl1-cjj1",
            "ap-northeast-2-wl1-sel1",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "ca-central-1-wl1-yto1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-2-wl1-lon1",
            "eu-central-1-wl1-dtm1",
            "eu-central-1-wl1-ber1",
            "eu-central-1-wl1-muc1",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-1-atl-1",
            "us-east-1-bos-1",
            "us-east-1-chi-1",
            "us-east-1-dfw-1",
            "us-west-2-den-1",
            "us-east-1-iah-1",
            "us-east-1-mci-1",
            "us-east-1-mia-1",
            "us-east-1-msp-1",
            "us-east-1-nyc-1",
            "us-east-1-phl-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2",
            "us-west-2-las-1",
            "us-west-2-lax-1",
            "us-west-2-phx-1",
            "us-west-2-pdx-1",
            "us-west-2-sea-1",
            "us-east-1-wl1",
            "us-east-1-wl1-atl1",
            "us-east-1-wl1-chi1",
            "us-east-1-wl1-dfw1",
            "us-east-1-wl1-iah1",
            "us-east-1-wl1-mia1",
            "us-east-1-wl1-nyc1",
            "us-east-1-wl1-clt1",
            "us-east-1-wl1-dtw1",
            "us-east-1-wl1-msp1",
            "us-east-1-wl1-was1",
            "us-east-1-wl1-tpa1",
            "us-east-1-wl1-bna1",
            "us-west-2-wl1",
            "us-west-2-wl1-den1",
            "us-west-2-wl1-las1",
            "us-west-2-wl1-lax1",
            "us-west-2-wl1-phx1",
            "us-west-2-wl1-sea1"
        ],
        "linkUrl": "https://aws.amazon.com/ebs/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonElasticBlockStore/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": [
            {
                "label": "Elastic Block Store (EBS)",
                "filename": "Amazon_Elastic_Block_Store_EBS_BulkUpload_Template_Commercial.xlsx"
            }
        ],
        "serviceDefinitionUrlPath": "/data/amazonElasticBlockStore/en_US.json",
        "slug": "EBS",
        "mvpSupport": false,
        "comparableTerms": [
            "ebs",
            "elasticblockstore",
            "elasticblockstoreebs"
        ]
    },
    "amazonElasticContainerRegistry": {
        "name": "Amazon Elastic Container Registry",
        "serviceCode": "amazonElasticContainerRegistry",
        "description": "Amazon Elastic Container Registry (ECR) is a fully-managed Docker container registry that makes it easy for developers to store, manage, and deploy Docker container images. Amazon ECR eliminates the need to operate your own container repositories or worry about scaling the underlying infrastructure. With Amazon ECR, there are no upfront fees or commitments. You pay only for the amount of data you store in your repositories and data transferred to the Internet.",
        "searchKeywords": [
            "ECR",
            "ecr",
            "Elastic Container Registry",
            "Amazon ECR",
            "container registry",
            "container",
            "registry"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ap-northeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/ecr/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonElasticContainerRegistry/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonElasticContainerRegistry/en_US.json",
        "slug": "ECR",
        "mvpSupport": false,
        "comparableTerms": [
            "ecr",
            "elasticcontainerregistry"
        ]
    },
    "amazonEFS": {
        "name": "Amazon Elastic File System (EFS)",
        "serviceCode": "amazonEFS",
        "description": "Amazon Elastic File System (EFS) provides a simple, serverless, set-and-forget elastic file system for use with AWS Cloud services and on-premises resources.",
        "searchKeywords": [
            "Storage",
            "Elastic file system",
            "elastic file service",
            "cloud file system",
            "cloud based file",
            "system",
            "file system",
            "NFS",
            "network file system",
            "fully managed file system",
            "NAS",
            "managed file system",
            "network attached storage",
            "network storage",
            "SAN",
            "storage area network",
            "cloud storage",
            "shared",
            "shared file system",
            "RAID",
            "cloud file storage",
            "file system storage",
            "file management"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/efs/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonEFS/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonEFS/en_US.json",
        "slug": "EFS",
        "mvpSupport": false,
        "comparableTerms": [
            "efs",
            "elasticfilesystemefs"
        ]
    },
    "amazonElasticGraphics": {
        "name": "Amazon Elastic Graphics",
        "serviceCode": "amazonElasticGraphics",
        "description": "Amazon Elastic Graphics allows you to easily attach low-cost graphics acceleration to a wide range of EC2 instances over the network.",
        "searchKeywords": [
            "Compute",
            "Elastic Compute Cloud",
            "spot instance",
            "load balancing",
            "elb",
            "elastic load balancer",
            "auto scaling",
            "auto scaling groups",
            "application load balancer",
            "ALB",
            "spot requests",
            "reserved instances",
            "scheduled instances",
            "dedicated hosts",
            "AMIs",
            "Bundle tasks",
            "Volumes",
            "Snapshots",
            "Images",
            "Elastic Block Store",
            "block storage",
            "Security groups",
            "Elastic IP",
            "placement groups",
            "key pairs",
            "network interfaces",
            "load balancers",
            "target groups",
            "auto scaler",
            "launch configurations",
            "EBS",
            "ASG",
            "commands",
            "Elastic Graphics",
            "command history",
            "managed instances",
            "activations"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/ec2/elastic-graphics/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonElasticGraphics/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "ElasticGraphics",
        "mvpSupport": false,
        "comparableTerms": [
            "ec2elasticgraphics",
            "elasticgraphics"
        ]
    },
    "amazonElasticIP": {
        "name": "Amazon Elastic IP",
        "serviceCode": "amazonElasticIP",
        "description": "An Elastic IP address is a static IPv4 address designed for dynamic cloud computing. An Elastic IP address is associated with your AWS account. With an Elastic IP address, you can mask the failure of an instance or software by rapidly remapping the address to another instance in your account.",
        "searchKeywords": [
            "Compute",
            "Elastic Compute Cloud",
            "spot instance",
            "load balancing",
            "elb",
            "elastic load balancer",
            "auto scaling",
            "auto scaling groups",
            "application load balancer",
            "ALB",
            "spot requests",
            "reserved instances",
            "scheduled instances",
            "dedicated hosts",
            "AMIs",
            "Bundle tasks",
            "Volumes",
            "Snapshots",
            "Images",
            "Elastic Block Store",
            "block storage",
            "Security groups",
            "Elastic IP",
            "placement groups",
            "key pairs",
            "network interfaces",
            "load balancers",
            "target groups",
            "auto scaler",
            "launch configurations",
            "EBS",
            "ASG",
            "commands",
            "command history",
            "managed instances",
            "activations"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/ec2/pricing/on-demand/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonElasticIP/en_US.json",
        "c2e": false,
        "slug": "ElasticIP",
        "comparableTerms": [
            "elasticip"
        ]
    },
    "amazonElasticTranscoder": {
        "name": "Amazon Elastic Transcoder",
        "serviceCode": "amazonElasticTranscoder",
        "description": "Amazon Elastic Transcoder is media transcoding in the cloud. It is designed to be a highly scalable, easy to use and a cost effective way for developers and businesses to convert (or “transcode”) media files from their source format into versions that will playback on devices like smartphones, tablets and PCs.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "eu-west-1",
            "us-east-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/elastictranscoder/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonElasticTranscoder/en_US.json",
        "c2e": false,
        "slug": "ElasticTranscoder",
        "comparableTerms": [
            "elastictranscoder"
        ]
    },
    "amazonElastiCache": {
        "name": "Amazon ElastiCache",
        "serviceCode": "amazonElastiCache",
        "description": "Amazon ElastiCache offers fully managed Redis and Memcached. Seamlessly deploy, run, and scale popular open source compatible in-memory data stores. Build data-intensive apps or improve the performance of your existing apps by retrieving data from high throughput and low latency in-memory data stores.",
        "searchKeywords": [
            "Database",
            "Database",
            "Cache",
            "Memcached",
            "Redis",
            "Caching",
            "in memory data store",
            "in memory caching",
            "auto discovery",
            "elasticache cluster",
            "replication",
            "adtech",
            "gaming",
            "media sharing",
            "Q&A",
            "social networking"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/elasticache/",
        "isActive": "true",
        "hasDataTransfer": true,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonElastiCache/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonElastiCache/en_US.json",
        "slug": "ElastiCache",
        "mvpSupport": false,
        "comparableTerms": [
            "elasticache"
        ]
    },
    "amazonEMR": {
        "name": "Amazon EMR",
        "serviceCode": "amazonEMR",
        "description": "Amazon EMR is the industry-leading cloud big data platform for processing vast amounts of data using open source tools such as Apache Spark, Apache Hive, Apache HBase, Apache Flink, Apache Hudi, and Presto. Amazon EMR makes it easy to set up, operate, and scale your big data environments by automating time-consuming tasks like provisioning capacity and tuning clusters. With EMR you can run petabyte-scale analysis at less than half of the cost of traditional on-premises solutions and over 3x faster than standard Apache Spark. You can run workloads on Amazon EC2 instances, on Amazon Elastic Kubernetes Service (EKS) clusters, or on-premises using EMR on AWS Outposts.",
        "searchKeywords": [
            "EMR",
            "elastic map reduce",
            "map reduce",
            "spark",
            "hadoop",
            "hbase",
            "hive",
            "hudi",
            "presto",
            "notebooks",
            "flink",
            "hue"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/emr/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonEMR/en_US.json",
        "c2e": false,
        "templates": [
            "amazonEmrMasterNode",
            "amazonEmrCoreNode",
            "amazonEmrTaskNode",
            "amazonEmrOnEks",
            "amazonEmrServerless"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonEMR/en_US.json",
        "slug": "EMR",
        "mvpSupport": false,
        "comparableTerms": [
            "emr"
        ]
    },
    "amazonEmrCoreNode": {
        "name": "Amazon EMR core node on EC2",
        "serviceCode": "amazonEmrCoreNode",
        "description": "",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-south-1",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-west-2-lax-1"
        ],
        "linkUrl": "https://aws.amazon.com/emr/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonEmrCoreNode/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonEmrCoreNode/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "emrcorenode",
            "emrcorenodeec2"
        ],
        "parentServiceCode": "amazonEMR"
    },
    "amazonEmrMasterNode": {
        "name": "Amazon EMR master node on EC2",
        "serviceCode": "amazonEmrMasterNode",
        "description": "",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-south-1",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-west-2-lax-1"
        ],
        "linkUrl": "https://aws.amazon.com/emr/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonEmrMasterNode/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonEmrMasterNode/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "emrmasternode",
            "emrmasternodeec2"
        ],
        "parentServiceCode": "amazonEMR"
    },
    "amazonEmrOnEks": {
        "name": "Amazon EMR on EKS",
        "serviceCode": "amazonEmrOnEks",
        "description": "",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/emr/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonEmrOnEks/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonEmrOnEks/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "emreks",
            "emroneks"
        ],
        "parentServiceCode": "amazonEMR"
    },
    "amazonEmrServerless": {
        "name": "Amazon EMR Serverless",
        "serviceCode": "amazonEmrServerless",
        "description": "",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1",
            "eu-west-1",
            "us-east-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/emr/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonEmrServerless/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/amazonEmrServerless/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "emrserverless"
        ],
        "parentServiceCode": "amazonEMR"
    },
    "amazonEmrTaskNode": {
        "name": "Amazon EMR task node on EC2",
        "serviceCode": "amazonEmrTaskNode",
        "description": "",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-south-1",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-west-2-lax-1"
        ],
        "linkUrl": "https://aws.amazon.com/emr/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonEmrTaskNode/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonEmrTaskNode/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "emrtasknode",
            "emrtasknodeec2"
        ],
        "parentServiceCode": "amazonEMR"
    },
    "amazonEventBridge": {
        "name": "Amazon EventBridge",
        "serviceCode": "amazonEventBridge",
        "description": "Amazon EventBridge is a serverless event bus that makes it easier to build event-driven applications at scale using events generated from your applications, integrated Software-as-a-Service (SaaS) applications, and AWS services.",
        "searchKeywords": [
            "amazon event bridge",
            "events",
            "Schema Registry",
            "SaaS"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/eventbridge/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonEventBridge/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonEventBridge/en_US.json",
        "slug": "eventbridge",
        "mvpSupport": false,
        "comparableTerms": [
            "eventbridge"
        ]
    },
    "amazonFileCache": {
        "name": "Amazon File Cache",
        "serviceCode": "amazonFileCache",
        "description": "Amazon File Cache provides a high-speed cache on AWS that makes it easier to process file data, regardless of where the data is stored.",
        "searchKeywords": [
            "file cache",
            "amazon file cache"
        ],
        "type": "AWSService",
        "regions": [
            " "
        ],
        "linkUrl": "https://aws.amazon.com/filecache/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonFileCache/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonFileCache/en_US.json",
        "slug": "filecache",
        "mvpSupport": false,
        "comparableTerms": [
            "filecache"
        ]
    },
    "awsFinSpace": {
        "name": "Amazon FinSpace",
        "serviceCode": "awsFinSpace",
        "description": "Amazon FinSpace is a data management and analytics service for financial services industry (FSI) customers such as hedge funds, asset management firms, insurance companies, and investment banks to store, catalog, prepare, and analyze data at petabyte scale. Using the FinSpace web application and APIs, customers can set up users, add data, and create data views that are optimized for querying. Amazon FinSpace provides scalable clusters to prepare and analyze the data.",
        "searchKeywords": [
            "data management",
            "analytics",
            "clusters",
            "users",
            "data",
            "storage",
            "financial"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "ca-central-1",
            "eu-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/finspace/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsFinSpace/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "FinSpace",
        "mvpSupport": false,
        "comparableTerms": [
            "finspace"
        ]
    },
    "amazonForecast": {
        "name": "Amazon Forecast",
        "serviceCode": "amazonForecast",
        "description": "Amazon Forecast uses machine learning (ML) to generate more accurate demand forecasts with just a few clicks, without requiring any prior ML experience. Amazon Forecast includes algorithms that are based on over twenty years of forecasting experience and developed expertise used by Amazon.com bringing the same technology used at Amazon to developers as a fully managed service, removing the need to manage resources. Amazon Forecast uses ML to learn not only the best algorithm for each item, but the best ensemble of algorithms for each item, automatically creating the best model for your data.",
        "searchKeywords": [
            "forecast",
            "amazon Forecast"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/forecast/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonForecast/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonForecast/en_US.json",
        "slug": "forecast",
        "mvpSupport": false,
        "comparableTerms": [
            "forecast"
        ]
    },
    "amazonFraudDetector": {
        "name": "Amazon Fraud Detector",
        "serviceCode": "amazonFraudDetector",
        "description": "Amazon Fraud Detector, a fully managed service built on over 20 years of insights from Amazon, helps customers identify potentially fraudulent activities and catch more online fraud faster. With Amazon Fraud Detector, you pay only for what you use, and there are no minimum fees or upfront commitments. You are charged based on the compute hours used to train and host your models, the amount of storage you use, and the quantity of fraud predictions you make.",
        "searchKeywords": [
            "fraud",
            "fraud detector",
            "detector"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/fraud-detector/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonFraudDetector/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonFraudDetector/en_US.json",
        "slug": "frauddetector",
        "mvpSupport": false,
        "comparableTerms": [
            "frauddetector"
        ]
    },
    "amazonFSxForLustre": {
        "name": "Amazon FSx for Lustre",
        "serviceCode": "amazonFSxForLustre",
        "description": "Amazon FSx for Lustre provides a simple, high-performance file system integrated with S3 for fast processing of workloads such as machine learning, high performance computing (HPC), video processing, financial modeling, and electronic design automation (EDA).",
        "searchKeywords": [
            "storage",
            "file storage",
            "windows",
            "lustre",
            "hpc",
            "enterprise applications",
            "file shares",
            "file system",
            "cloud storage",
            "smb",
            "ntfs",
            "posix",
            "managed storage"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ca-central-1",
            "ap-southeast-2",
            "af-south-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "eu-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2",
            "us-west-2-lax-1"
        ],
        "linkUrl": "https://aws.amazon.com/fsx/lustre/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonFSxForLustre/en_US.json",
        "c2e": false,
        "slug": "FSxForLustre",
        "mvpSupport": false,
        "comparableTerms": [
            "fsxforlustre",
            "fsxlustre"
        ]
    },
    "amazonFSxForNetAppOntap": {
        "name": "Amazon FSx for NetApp ONTAP",
        "serviceCode": "amazonFSxForNetAppOntap",
        "description": "Amazon FSx for NetApp ONTAP provides fully managed shared storage in the AWS Cloud with the popular data access and management capabilities of ONTAP.",
        "searchKeywords": [
            "storage",
            "file storage",
            "windows",
            "lustre",
            "hpc",
            "enterprise applications",
            "file shares",
            "file system",
            "cloud storage",
            "smb",
            "ntfs",
            "posix",
            "managed storage",
            "microsoft",
            "file",
            "msft",
            "shared storage",
            "shared",
            "win",
            "ontap",
            "snaplock"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/fsx/netapp-ontap/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonFSxForNetAppOntap/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonFSxForNetAppOntap/en_US.json",
        "slug": "FSxForNetAppOntap",
        "mvpSupport": false,
        "comparableTerms": [
            "fsxfornetappontap",
            "fsxnetappontap"
        ]
    },
    "amazonFSxForOpenZfs": {
        "name": "Amazon FSx for OpenZFS",
        "serviceCode": "amazonFSxForOpenZfs",
        "description": "Amazon FSx for OpenZFS provides fully managed shared file storage built on the OpenZFS file system and accessible through the NFS protocol (v3, v4, v4.1, and v4.2).",
        "searchKeywords": [
            "storage",
            "file storage",
            "windows",
            "openzfs",
            "hpc",
            "enterprise applications",
            "file shares",
            "file system",
            "cloud storage",
            "smb",
            "ntfs",
            "posix",
            "managed storage"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/fsx/openzfs/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonFSxForOpenZfs/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonFSxForOpenZfs/en_US.json",
        "slug": "FSxForOpenZFS",
        "mvpSupport": false,
        "comparableTerms": [
            "fsxforopenzfs",
            "fsxopenzfs"
        ]
    },
    "amazonFSx": {
        "name": "Amazon FSx for Windows File Server",
        "serviceCode": "amazonFSx",
        "description": "Amazon FSx for Windows provides a simple, fully managed native Microsoft Windows file system so you can easily move your Windows based applications that require file storage to AWS.",
        "searchKeywords": [
            "storage",
            "file storage",
            "windows",
            "lustre",
            "hpc",
            "enterprise applications",
            "file shares",
            "file system",
            "cloud storage",
            "smb",
            "ntfs",
            "posix",
            "managed storage",
            "microsoft",
            "file",
            "msft",
            "shared storage",
            "shared",
            "win",
            "provisioned IOPS"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/fsx/windows/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonFSx/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonFSx/en_US.json",
        "slug": "FSx",
        "mvpSupport": false,
        "comparableTerms": [
            "fsx",
            "fsxwindows",
            "fsxwindowsfileserver"
        ]
    },
    "amazonGameLift": {
        "name": "Amazon GameLift",
        "serviceCode": "amazonGameLift",
        "description": "Amazon GameLift is a dedicated game server hosting solution that deploys, operates, and scales cloud servers for multiplayer games. Whether you’re looking for a fully managed solution, or just the feature you need, GameLift leverages the power of AWS to deliver the best latency possible, low player wait times, and maximum cost savings.",
        "searchKeywords": [
            "AAA game engine",
            "anywhere",
            "auto scaling",
            "custom location",
            "device sdk",
            "ec2",
            "ec2 game server",
            "fleet management",
            "fleetIQ",
            "FlexMatch",
            "game backend",
            "game dev",
            "Game development",
            "game engine",
            "game hosting",
            "game placement",
            "game player",
            "game scaling",
            "game server",
            "game server alias",
            "game server management",
            "game server queue",
            "game servers",
            "game session placement",
            "game session queue",
            "game sessions",
            "gamedev",
            "gamelift",
            "games",
            "gaming",
            "gaming platform",
            "global game hosting",
            "instances",
            "lightweight game server",
            "lumber yard",
            "lumberjack",
            "lumberyard",
            "lumberyard download",
            "lumberyard game",
            "lumberyard game engine",
            "lumberyard games",
            "managed game hosting",
            "managed game server",
            "managed server",
            "matchmaker",
            "matchmaking",
            "matchmaking configuration",
            "matchmaking rule",
            "mobile game engine",
            "multiplayer backend",
            "multiplayer game",
            "multiplayer game server",
            "on demand",
            "real time game server",
            "real time servers",
            "remote",
            "rts",
            "rule set",
            "rules engine",
            "spot"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "af-south-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-east-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-south-1",
            "ca-central-1",
            "eu-north-1",
            "eu-central-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1",
            "us-east-1-atl-1",
            "us-east-1-chi-1",
            "us-east-1-dfw-1",
            "us-west-2-den-1",
            "us-east-1-iah-1",
            "us-east-1-mci-1",
            "us-west-2-lax-1",
            "us-west-2-phx-1"
        ],
        "linkUrl": "https://aws.amazon.com/gamelift/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonGameLift/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/amazonGameLift/en_US.json",
        "slug": "GameLift",
        "mvpSupport": false,
        "comparableTerms": [
            "gamelift"
        ]
    },
    "amazonGuardDuty": {
        "name": "Amazon GuardDuty",
        "serviceCode": "amazonGuardDuty",
        "description": "Amazon GuardDuty is a threat detection service that continuously monitors for malicious activity and unauthorized behavior to protect your AWS accounts, workloads, and data stored in Amazon S3.",
        "searchKeywords": [
            "guard duty",
            "amazon GuardDuty"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/guardduty/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonGuardDuty/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonGuardDuty/en_US.json",
        "slug": "guardduty",
        "mvpSupport": false,
        "comparableTerms": [
            "guardduty"
        ]
    },
    "amazonHealthlake": {
        "name": "Amazon Healthlake",
        "serviceCode": "amazonHealthlake",
        "description": "Amazon HealthLake is a HIPAA-eligible service offering healthcare and life sciences companies a complete view of individual or patient population health data for query and analytics at scale.",
        "searchKeywords": [
            "FHIR",
            "HIPAA",
            "NLP"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/healthlake/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonHealthlake/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonHealthlake/en_US.json",
        "slug": "HealthLake",
        "mvpSupport": false,
        "comparableTerms": [
            "healthlake"
        ]
    },
    "amazonInspector": {
        "name": "Amazon Inspector",
        "serviceCode": "amazonInspector",
        "description": "Amazon Inspector is an automated and continual vulnerability scanning service that assesses Amazon Elastic Compute Cloud (EC2) instances and container images to improve the security and compliance of infrastructure workloads.",
        "searchKeywords": [
            "Analytics",
            "SQL",
            "query",
            "S3",
            "big data",
            "Presto",
            "serverless",
            "ad-hoc analysis",
            "log processing",
            "bigquery",
            "big query",
            "query S3 data"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-southeast-1",
            "ap-southeast-2",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "af-south-1",
            "sa-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/inspector/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonInspector/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonInspector/en_US.json",
        "slug": "Inspector",
        "mvpSupport": false,
        "comparableTerms": [
            "inspector"
        ]
    },
    "amazonKendra": {
        "name": "Amazon Kendra",
        "serviceCode": "amazonKendra",
        "description": "Amazon Kendra is an intelligent search service powered by machine learning. Kendra reimagines enterprise search for your websites and applications so your employees and customers can easily find the content they are looking for, even when it’s scattered across multiple locations and content repositories within your organization.",
        "searchKeywords": [
            "kendra"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-west-2",
            "eu-west-1",
            "ap-southeast-2"
        ],
        "linkUrl": "https://aws.amazon.com/kendra",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonKendra/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonKendra/en_US.json",
        "slug": "Kendra",
        "mvpSupport": false,
        "comparableTerms": [
            "kendra"
        ]
    },
    "amazonKeyspaces": {
        "name": "Amazon Keyspaces",
        "serviceCode": "amazonKeyspaces",
        "description": " Amazon Keyspaces (for Apache Cassandra) is a scalable, highly available, and managed Apache Cassandra–compatible database service. With Amazon Keyspaces, you can run your Cassandra workloads of any scale on AWS using the same Cassandra application code and developer tools that you use today.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/keyspaces/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonKeyspaces/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonKeyspaces/en_US.json",
        "slug": "keyspaces",
        "mvpSupport": false,
        "comparableTerms": [
            "keyspaces"
        ]
    },
    "amazonKinesisFirehose": {
        "name": "Amazon Kinesis Data Firehose",
        "serviceCode": "amazonKinesisFirehose",
        "description": "With Amazon Kinesis Data Firehose, you pay for the volume of data you ingest into the service. There are no set up fees or upfront commitments. You are billed for the volume of data ingested into Kinesis Data Firehose, and if applicable, for data format conversion to Apache Parquet or ORC.",
        "searchKeywords": [
            "Analytics",
            "kinesis analytics",
            "kinesis streams",
            "kinesis firehose",
            "firehose",
            "VPC",
            "data format conversion",
            "streaming",
            "data streaming",
            "real-time",
            "analysis",
            "kafka",
            "spark",
            "put records",
            "kcl",
            "kpl",
            "sql",
            "ORC",
            "stream processing",
            "sql on streams",
            "stream ingestion",
            "IoT analytics",
            "real-time bidding",
            "RTB",
            "log analytics",
            "clickstream analytics",
            "real time alerts",
            "real time dashboards",
            "real time monitoring",
            "dynamic partitioning"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/kinesis/data-firehose/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonKinesisFirehose/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonKinesisFirehose/en_US.json",
        "slug": "KinesisDataFirehose",
        "mvpSupport": false,
        "comparableTerms": [
            "kinesisdatafirehose",
            "kinesisfirehose"
        ]
    },
    "amazonKinesisDataStreams": {
        "name": "Amazon Kinesis Data Streams",
        "serviceCode": "amazonKinesisDataStreams",
        "description": "Amazon Kinesis Data Streams (KDS) is a massively scalable and durable real-time data streaming service.",
        "searchKeywords": [
            "Analytics",
            "kinesis analytics",
            "kinesis streams",
            "kinesis firehose",
            "streaming",
            "data streaming",
            "real-time",
            "analysis",
            "kafka",
            "spark",
            "put records",
            "kcl",
            "kpl",
            "sql",
            "stream processing",
            "sql on streams",
            "stream ingestion",
            "IoT analytics",
            "real-time bidding",
            "RTB",
            "log analytics",
            "clickstream analytics",
            "real time alerts",
            "real time dashboards",
            "real time monitoring"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/kinesis/data-streams/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonKinesisDataStreams/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonKinesisDataStreams/en_US.json",
        "slug": "KinesisDataStreams",
        "mvpSupport": false,
        "comparableTerms": [
            "kinesisdatastreams"
        ]
    },
    "amazonKinesisVideoStreams": {
        "name": "Amazon Kinesis Video Streams",
        "serviceCode": "amazonKinesisVideoStreams",
        "description": "Amazon Kinesis Video Streams makes it easy to securely stream video from connected devices to AWS for analytics, machine learning (ML), playback, and other processing. Kinesis Video Streams automatically provisions and elastically scales all the infrastructure needed to ingest streaming video data from millions of devices.",
        "searchKeywords": [
            "video stream",
            "signaling channel",
            "turn streaming",
            "webRTC",
            "video analytics",
            "HTTP live streaming",
            "HLS",
            "KVS"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/kinesis/video-streams",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonKinesisVideoStreams/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonKinesisVideoStreams/en_US.json",
        "slug": "KinesisVideoStreams",
        "mvpSupport": false,
        "comparableTerms": [
            "kinesisvideostreams"
        ]
    },
    "amazonLex": {
        "name": "Amazon Lex",
        "serviceCode": "amazonLex",
        "description": "Amazon Lex is a service for building conversational interfaces into any application using voice and text. With Amazon Lex, you pay only for what you use.",
        "searchKeywords": [
            "bot",
            "chat",
            "chatbot",
            "conversation",
            "conversational interfaces",
            "response",
            "speech",
            "streaming conversation",
            "text",
            "transcripts",
            "virtual agent",
            "voice chat"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-west-2",
            "af-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-west-2",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/lex",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonLex/en_US.json",
        "c2e": false,
        "slug": "lex",
        "mvpSupport": false,
        "comparableTerms": [
            "lex"
        ]
    },
    "amazonLightsail": {
        "name": "Amazon Lightsail",
        "serviceCode": "amazonLightsail",
        "description": "Lightsail is an easy-to-use virtual private server (VPS) that offers you everything needed to build an application or website, plus a cost-effective, monthly plan. Lightsail is ideal for simpler workloads, quick deployments, and getting started on AWS. It’s designed to help you start small, and then scale as you grow.",
        "searchKeywords": [
            "virtual servers",
            "databases",
            "containers",
            "load balancer",
            "content delivery network",
            "CDN",
            "block storage",
            "snapshots",
            "vps",
            "virtual private server"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/lightsail/",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonLightsail/en_US.json",
        "c2e": false,
        "templates": [
            "lightsailVirtualServers",
            "lightsailManagedDatabases",
            "lightsailContainers",
            "lightsailObjectStorage",
            "lightsailCdn",
            "lightsailLoadBalancer",
            "lightsailBlockStorage",
            "lightsailDataTransfer"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonLightsail/en_US.json",
        "slug": "Lightsail",
        "mvpSupport": false,
        "comparableTerms": [
            "lightsail"
        ]
    },
    "locationService": {
        "name": "Amazon Location Service",
        "serviceCode": "locationService",
        "description": "Amazon Location Service provides affordable data, tracking and geofencing capabilities, and native integrations with AWS services, so you can create sophisticated location-enabled applications quickly, without the high cost of custom development.",
        "searchKeywords": [
            "Location Service",
            "compromising data security",
            "user privacy",
            "asset tracking",
            "location-based marketing",
            "geofencing"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/location/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/locationService/en_US.json",
        "c2e": false,
        "templates": [
            "locationServiceMaps",
            "locationServicePlaces",
            "locationServiceRouting",
            "locationServiceTracking",
            "locationServiceGeofencing",
            "locationServiceServiceResources"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/locationService/en_US.json",
        "slug": "LocationService",
        "mvpSupport": false,
        "comparableTerms": [
            "location",
            "locationservice"
        ]
    },
    "amazonLookoutForEquipment": {
        "name": "Amazon Lookout for Equipment",
        "serviceCode": "amazonLookoutForEquipment",
        "description": "Amazon Lookout for Equipment is an ML industrial equipment monitoring service that detects abnormal equipment behavior so you can act and avoid unplanned downtime.",
        "searchKeywords": [
            "Amazon Lookout for Equipment",
            "equipement behavior"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/lookout-for-equipment/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonLookoutForEquipment/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonLookoutForEquipment/en_US.json",
        "slug": "lookoutforequipment",
        "mvpSupport": false,
        "comparableTerms": [
            "lookoutequipment",
            "lookoutforequipment"
        ]
    },
    "amazonLookoutForMetrics": {
        "name": "Amazon Lookout for Metrics",
        "serviceCode": "amazonLookoutForMetrics",
        "description": "Amazon Lookout for Metrics uses machine learning (ML) to automatically detect and diagnose anomalies (i.e. outliers from the norm) in business and operational data, such as a sudden dip in sales revenue or customer acquisition rates. In a couple of clicks, you can connect Amazon Lookout for Metrics to popular data stores like Amazon S3, Amazon Redshift, and Amazon Relational Database Service (RDS), as well as third-party SaaS applications, such as Salesforce, Servicenow, Zendesk, and Marketo, and start monitoring metrics that are important to your business. Amazon Lookout for Metrics automatically inspects and prepares the data from these sources to detect anomalies with greater speed and accuracy than traditional methods used for anomaly detection. You can also provide feedback on detected anomalies to tune the results and improve accuracy over time. Amazon Lookout for Metrics makes it easy to diagnose detected anomalies by grouping together anomalies that are related to the same event and sending an alert that includes a summary of the potential root cause. It also ranks anomalies in order of severity so that you can prioritize your attention to what matters the most to your business.",
        "searchKeywords": [
            "lookout for metrics",
            "metrics",
            "anomalies",
            "anomaly detection",
            "machine learning",
            "ML-powered anomaly detection",
            "Anomaly Grouping and Ranking",
            "Tunable results",
            "automated alerts",
            "anomaly detection model",
            "detector",
            "outlier",
            "outlier detection"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-2",
            "ap-southeast-2",
            "eu-north-1",
            "ap-southeast-1",
            "eu-west-1",
            "us-west-2",
            "us-east-1",
            "ap-northeast-1",
            "eu-central-1"
        ],
        "linkUrl": "https://aws.amazon.com/lookout-for-metrics/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonLookoutForMetrics/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonLookoutForMetrics/en_US.json",
        "slug": "LookoutForMetrics",
        "mvpSupport": false,
        "comparableTerms": [
            "lookoutformetrics",
            "lookoutmetrics"
        ]
    },
    "amazonLookoutForVision": {
        "name": "Amazon Lookout for Vision",
        "serviceCode": "amazonLookoutForVision",
        "description": "Amazon Lookout for Vision is a machine learning (ML) service that spots defects and anomalies in visual representations using computer vision (CV). With Amazon Lookout for Vision, manufacturing companies can increase quality and reduce operational costs by quickly identifying differences in images of objects at scale.",
        "searchKeywords": [
            "lookout",
            "vision"
        ],
        "type": "AWSService",
        "regions": [
            "ap-northeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/lookout-for-vision/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonLookoutForVision/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonLookoutForVision/en_US.json",
        "slug": "LookoutVision",
        "mvpSupport": false,
        "comparableTerms": [
            "lookoutforvision",
            "lookoutvision"
        ]
    },
    "amazonMacie": {
        "name": "Amazon Macie",
        "serviceCode": "amazonMacie",
        "description": "Amazon Macie is a fully managed data security and data privacy service that uses machine learning and pattern matching to discover and protect your sensitive data in AWS. With Amazon Macie, you are charged based on the number of Amazon S3 buckets evaluated for bucket-level security and access controls and the quantity of data processed for sensitive data discovery.",
        "searchKeywords": [
            "data security",
            "data privacy",
            "machine learning",
            "pattern matching",
            "sensitive data protection",
            "S3 buckets",
            "PII",
            "HIPAA",
            "GDPR"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/macie/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonMacie/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonMacie/en_US.json",
        "slug": "Macie",
        "mvpSupport": false,
        "comparableTerms": [
            "macie"
        ]
    },
    "amazonManagedBlockchain": {
        "name": "Amazon Managed Blockchain",
        "serviceCode": "amazonManagedBlockchain",
        "description": "Amazon Managed Blockchain is a fully managed service that makes it easy to join public networks or create and manage scalable private networks using the popular open-source frameworks Hyperledger Fabric and Ethereum.",
        "searchKeywords": [
            "hyperledger Fabric",
            "ethereum",
            "blockchain",
            "managed blockchain"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "eu-west-1",
            "eu-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/managed-blockchain/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonManagedBlockchain/en_US.json",
        "c2e": false,
        "slug": "ManagedBlockchain",
        "mvpSupport": false,
        "comparableTerms": [
            "managedblockchain"
        ]
    },
    "amazonManagedGrafana": {
        "name": "Amazon Managed Grafana",
        "serviceCode": "amazonManagedGrafana",
        "description": "Amazon Managed Grafana is a fully managed service for Grafana, a popular open-source analytics platform that enables you to query, visualize, and alert on your metrics, logs, and traces. There are no upfront fees, no required minimum commitments, and no long-term contracts. All user licenses are per workspace, per month. You pay only for what you use, based on an active user license per workspace. You will be charged at the end of the month for your usage.       An active user is defined as a unique user who has accessed a Amazon Managed Grafana workspace in a calendar month. Each workspace requires a minimum of one Editor license in order to manage and log into the workspace, even if no users log in.",
        "searchKeywords": [
            "Amazon Grafana"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/grafana",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonManagedGrafana/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonManagedGrafana/en_US.json",
        "slug": "grafana",
        "mvpSupport": false,
        "comparableTerms": [
            "grafana",
            "managedgrafana"
        ]
    },
    "amazonKinesisDataAnalytics": {
        "name": "Amazon Managed Service for Apache Flink",
        "serviceCode": "amazonKinesisDataAnalytics",
        "description": "Amazon Managed Service for Apache Flink is the easiest way to analyze streaming data, gain actionable insights, and respond to your business and customer needs in real time.",
        "searchKeywords": [
            "Kinesis",
            "streaming",
            "insights",
            "Flink",
            "Apache Flink"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "ap-east-1",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "af-south-1"
        ],
        "linkUrl": "https://aws.amazon.com/kinesis/data-analytics/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonKinesisDataAnalytics/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonKinesisDataAnalytics/en_US.json",
        "slug": "KinesisDataAnalytics",
        "mvpSupport": false,
        "comparableTerms": [
            "kinesisdataanalytics",
            "managedserviceapacheflink"
        ]
    },
    "amazonManagedServiceForPrometheus": {
        "name": "Amazon Managed Service for Prometheus",
        "serviceCode": "amazonManagedServiceForPrometheus",
        "description": "Amazon Managed Service for Prometheus is a Prometheus-compatible monitoring service that makes it easy to monitor containerized applications at scale. The Cloud Native Computing Foundation’s Prometheus project is a popular open source monitoring and alerting solution optimized for container environments. With Amazon Managed Service for Prometheus, you can use the open source Prometheus query language (PromQL) to monitor the performance of containerized workloads, without having to manage the underlying infrastructure.",
        "searchKeywords": [
            "MSP",
            "Prometheus",
            "Managed Service for Prometheus"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-north-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/prometheus/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonManagedServiceForPrometheus/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonManagedServiceForPrometheus/en_US.json",
        "slug": "Prometheus",
        "mvpSupport": false,
        "comparableTerms": [
            "managedserviceforprometheus",
            "managedserviceprometheus",
            "prometheus"
        ]
    },
    "amazonManagedStreamingForApacheKafkaMsk": {
        "name": "Amazon Managed Streaming for Apache Kafka (MSK)",
        "serviceCode": "amazonManagedStreamingForApacheKafkaMsk",
        "description": "Amazon MSK is a fully managed service that makes it easy for you to build and run applications that use Apache Kafka to process streaming data. With Amazon MSK, you can use native Apache Kafka APIs to populate data lakes, stream changes to and from databases, and power machine learning and analytics applications.",
        "searchKeywords": [
            "MSK",
            "Apache Kafka",
            "managed Kafka",
            "MSK Connect"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ap-northeast-3",
            "us-gov-east-1",
            "us-gov-west-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonManagedStreamingForApacheKafkaMsk/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonManagedStreamingForApacheKafkaMsk/en_US.json",
        "slug": "MSK",
        "mvpSupport": false,
        "comparableTerms": [
            "managedstreamingapachekafkamsk",
            "managedstreamingforapachekafkamsk",
            "msk"
        ]
    },
    "amazonManagedWorkflowsForApacheAirflow": {
        "name": "Amazon Managed Workflows for Apache Airflow",
        "serviceCode": "amazonManagedWorkflowsForApacheAirflow",
        "description": "Amazon Managed Workflows for Apache Airflow (MWAA) is a managed orchestration service for Apache Airflow1 that makes it easier to set up and operate end-to-end data pipelines in the cloud at scale. Apache Airflow is an open-source tool used to programmatically author, schedule, and monitor sequences of processes and tasks referred to as “workflows.” With Managed Workflows, you can use Airflow and Python to create workflows without having to manage the underlying infrastructure for scalability, availability, and security.",
        "searchKeywords": [
            "MWAA",
            "Workflows",
            "Apache Airflow",
            "Managed Workflows for Apache Airflow"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "sa-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/managed-workflows-for-apache-airflow/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonManagedWorkflowsForApacheAirflow/en_US.json",
        "c2e": false,
        "slug": "MWAA",
        "mvpSupport": false,
        "comparableTerms": [
            "managedworkflowsapacheairflow",
            "managedworkflowsforapacheairflow",
            "mwaa"
        ]
    },
    "amazonMemoryDbForRedis": {
        "name": "Amazon MemoryDB for Redis",
        "serviceCode": "amazonMemoryDbForRedis",
        "description": "Amazon MemoryDB for Redis is a Redis-compatible, durable, in-memory database that delivers ultra-fast performance and Multi-AZ durability.",
        "searchKeywords": [
            "memorydb",
            "Amazon MemoryDB for Redis"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "sa-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/memorydb/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonMemoryDbForRedis/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonMemoryDbForRedis/en_US.json",
        "slug": "memorydb",
        "mvpSupport": false,
        "comparableTerms": [
            "memorydb",
            "memorydbforredis",
            "memorydbredis"
        ]
    },
    "amazonMQ": {
        "name": "Amazon MQ",
        "serviceCode": "amazonMQ",
        "description": "Amazon MQ is a managed message broker service for Apache ActiveMQ that makes it easy to set up and operate message brokers in the cloud.",
        "searchKeywords": [
            "MQ",
            "rabbit",
            "broker",
            "Apache ActiveMQ"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1",
            "me-south-1",
            "us-gov-west-1",
            "us-gov-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/amazon-mq/",
        "isActive": "true",
        "hasDataTransfer": true,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonMQ/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonMQ/en_US.json",
        "slug": "MQ",
        "mvpSupport": false,
        "comparableTerms": [
            "mq"
        ]
    },
    "amazonNeptune": {
        "name": "Amazon Neptune",
        "serviceCode": "amazonNeptune",
        "description": "Amazon Neptune is a fast, reliable, fully managed graph database service that makes it easy to build and run applications that work with highly connected datasets.",
        "searchKeywords": [
            "Neptune",
            "Graph database"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-west-1",
            "us-gov-east-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/neptune/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonNeptune/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonNeptune/en_US.json",
        "slug": "neptune",
        "mvpSupport": false,
        "comparableTerms": [
            "neptune"
        ]
    },
    "amazonOmics": {
        "name": "Amazon Omics",
        "serviceCode": "amazonOmics",
        "description": "With Amazon Omics, you only pay for what you use. You are charged based on the amount of data you store and the compute instances you use for processing your workflow. With Amazon Omics, you can store sequence and reference data objects or variants and annotation data. You can also run bioinformatics workflows to analyze and transform genomic, transcriptomic, and other omics data. Amazon Omics is optimized for the storage and computation of omics data and works with other AWS services such as Amazon SageMaker, Amazon Simple Storage Service (S3), and Amazon Athena.",
        "searchKeywords": [
            "amazon omics",
            "omics"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/omics/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonOmics/en_US.json",
        "c2e": false,
        "templates": [
            "omicsStorage",
            "omicsAnalytics",
            "omicsWorkflows",
            "omicsReady2RunWorkflows"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonOmics/en_US.json",
        "slug": "omics",
        "mvpSupport": false,
        "comparableTerms": [
            "omics"
        ]
    },
    "amazonElasticsearchService": {
        "name": "Amazon OpenSearch Service",
        "serviceCode": "amazonElasticsearchService",
        "description": "Amazon OpenSearch Service is a fully managed service that makes it easy for you to deploy, secure, and operate OpenSearch clusters at scale.",
        "searchKeywords": [
            "Analytics",
            "ES",
            "Kibana",
            "Logstash",
            "Search",
            "Text search",
            "Time series",
            "Log analytics",
            "Analytics",
            "Real time analytics",
            "Streaming data analytics",
            "CloudSearch",
            "search",
            "ultraWarm",
            "ultrawarm",
            "opensearch",
            "open search"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/opensearch-service/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonElasticsearchService/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonElasticsearchService/en_US.json",
        "slug": "OpenSearchService",
        "mvpSupport": false,
        "comparableTerms": [
            "elasticsearch",
            "elasticsearchservice",
            "opensearch",
            "opensearchservice"
        ]
    },
    "amazonPersonalize": {
        "name": "Amazon Personalize",
        "serviceCode": "amazonPersonalize",
        "description": "Amazon Personalize enables developers to build applications with the same machine learning (ML) technology used by Amazon.com for real-time personalized recommendations – no ML expertise required.",
        "searchKeywords": [
            "personalize",
            "Amazon personalize"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/personalize/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonPersonalize/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonPersonalize/en_US.json",
        "slug": "personalize",
        "mvpSupport": false,
        "comparableTerms": [
            "personalize"
        ]
    },
    "amazonPinpoint": {
        "name": "Amazon Pinpoint",
        "serviceCode": "amazonPinpoint",
        "description": "Amazon Pinpoint is a flexible and scalable outbound and inbound marketing communications service. You can connect with customers over channels like email, SMS, push, or voice. Amazon Pinpoint is easy to set up, easy to use, and is flexible for all marketing communication scenarios. ",
        "searchKeywords": [
            "marketing",
            "communications",
            "email",
            "SMS",
            "messages",
            "campaign"
        ],
        "type": "AWSService",
        "regions": [
            "us-west-2",
            "us-east-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ap-southeast-1",
            "eu-west-2",
            "eu-west-1",
            "eu-central-1",
            "ca-central-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/pinpoint/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonPinpoint/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonPinpoint/en_US.json",
        "slug": "Pinpoint",
        "mvpSupport": false,
        "comparableTerms": [
            "pinpoint"
        ]
    },
    "amazonPolly": {
        "name": "Amazon Polly",
        "serviceCode": "amazonPolly",
        "description": "Amazon Polly is a service that turns text into lifelike speech, allowing you to create applications that talk, and build entirely new categories of speech-enabled products.",
        "searchKeywords": [
            "polly",
            "NLP",
            "speech",
            "text to speech"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/polly/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonPolly/en_US.json",
        "c2e": false,
        "templates": [
            "neuralTextToSpeech",
            "standardTextToSpeechTts"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonPolly/en_US.json",
        "slug": "polly",
        "mvpSupport": false,
        "comparableTerms": [
            "polly"
        ]
    },
    "amazonQuantumLedgerDatabaseQldb": {
        "name": "Amazon Quantum Ledger Database (QLDB)",
        "serviceCode": "amazonQuantumLedgerDatabaseQldb",
        "description": "Amazon Quantum Ledger Database (QLDB) is a fully managed ledger database that provides a transparent, immutable, and cryptographically verifiable transaction log.",
        "searchKeywords": [
            "qldb",
            "Amazon Quantum Ledger Database"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/qldb/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonQuantumLedgerDatabaseQldb/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonQuantumLedgerDatabaseQldb/en_US.json",
        "slug": "qldb",
        "mvpSupport": false,
        "comparableTerms": [
            "qldb",
            "quantumledgerdatabaseqldb"
        ]
    },
    "amazonQuickSight": {
        "name": "Amazon QuickSight",
        "serviceCode": "amazonQuickSight",
        "description": "Amazon QuickSight is a fast, cloud-powered business intelligence service that makes it easy to deliver insights to everyone in your organization. QuickSight dashboards can be embedded in applications, require no infrastructure setup or management, and can automatically scale to tens of thousands of users.",
        "searchKeywords": [
            "QuickSight",
            "Serverless",
            "Embedding",
            "BI",
            "Business intelligence",
            "Data visualization",
            "Insights",
            "Embedded Analytics"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/quicksight/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonQuickSight/en_US.json",
        "c2e": false,
        "templates": [
            "amazonQuickSightReadersAuthorsSpice",
            "amazonQuickSightAnomalyDetection"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonQuickSight/en_US.json",
        "slug": "QuickSight",
        "mvpSupport": false,
        "comparableTerms": [
            "quicksight"
        ]
    },
    "amazonQuickSightAnomalyDetection": {
        "name": "Amazon QuickSight Alerts & Anomaly Detection",
        "serviceCode": "amazonQuickSightAnomalyDetection",
        "description": "",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-north-1",
            "sa-east-1",
            "us-gov-west-1"
        ],
        "isActive": "true",
        "subType": "subService",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonQuickSightAnomalyDetection/en_US.json",
        "c2e": false,
        "mvpSupport": false,
        "comparableTerms": [
            "quicksightalertsanomalydetection",
            "quicksightanomalydetection"
        ],
        "parentServiceCode": "amazonQuickSight"
    },
    "amazonQuickSightReadersAuthorsSpice": {
        "name": "Amazon QuickSight Readers, Authors, SPICE",
        "serviceCode": "amazonQuickSightReadersAuthorsSpice",
        "description": "Amazon QuickSight is a fast, cloud-powered business intelligence service that makes it easy to deliver insights to everyone in your organization. QuickSight dashboards can be embedded in applications, require no infrastructure setup or management, and can automatically scale to tens of thousands of users.",
        "searchKeywords": [
            "QuickSight",
            "Serverless",
            "Embedding",
            "BI",
            "Business intelligence",
            "Data visualization",
            "Insights",
            "Embedded Analytics"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-north-1",
            "sa-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/quicksight/",
        "isActive": "true",
        "subType": "subService",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonQuickSightReadersAuthorsSpice/en_US.json",
        "c2e": false,
        "comparableTerms": [
            "quicksightreadersauthorsspice"
        ],
        "parentServiceCode": "amazonQuickSight"
    },
    "amazonRdsCustomForOracle": {
        "name": "Amazon RDS Custom for Oracle",
        "serviceCode": "amazonRdsCustomForOracle",
        "description": "Amazon Relational Database Service (Amazon RDS) Custom is a managed database service for legacy, custom, and packaged applications that require access to the underlying OS and DB environment. Amazon RDS Custom automates setup, operation, and scaling of databases in the cloud while granting access to the database and underlying operating system to configure settings, install patches, and enable native features to meet the dependent application's requirements.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-south-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/rds/custom",
        "isActive": "true",
        "hasDataTransfer": false,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRdsCustomForOracle/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonRdsCustomForOracle/en_US.json",
        "slug": "RDSCustomForOracle",
        "mvpSupport": false,
        "comparableTerms": [
            "rdscustom",
            "rdscustomfororacle",
            "rdscustomoracle"
        ]
    },
    "amazonRdsCustomForSqlServer": {
        "name": "Amazon RDS Custom for SQL Server",
        "serviceCode": "amazonRdsCustomForSqlServer",
        "description": "Amazon Relational Database Service (Amazon RDS) Custom is a managed database service for legacy, custom, and packaged applications that require access to the underlying OS and DB environment. Amazon RDS Custom automates setup, operation, and scaling of databases in the cloud while granting access to the database and underlying operating system to configure settings, install patches, and enable native features to meet the dependent application's requirements.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-south-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/rds/custom",
        "isActive": "true",
        "hasDataTransfer": false,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRdsCustomForSqlServer/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonRdsCustomForSqlServer/en_US.json",
        "slug": "RDSCustomForSQLServer",
        "mvpSupport": false,
        "comparableTerms": [
            "rdscustom",
            "rdscustomforsqlserver",
            "rdscustomsqlserver"
        ]
    },
    "amazonRDSMariaDB": {
        "name": "Amazon RDS for MariaDB",
        "serviceCode": "amazonRDSMariaDB",
        "description": "Amazon RDS makes it easy to set up, operate, and scale MariaDB database deployments in the cloud.",
        "searchKeywords": [
            "Database",
            "MariaDB",
            "database hosting",
            "hosted database",
            "Managed database"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2",
            "us-gov-east-1",
            "ap-east-1",
            "me-south-1",
            "me-central-1"
        ],
        "linkUrl": "https://aws.amazon.com/rds/mariadb",
        "isActive": "true",
        "hasDataTransfer": true,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRDSMariaDB/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonRDSMariaDB/en_US.json",
        "slug": "RDSMariaDB",
        "mvpSupport": false,
        "comparableTerms": [
            "rdsmariadb"
        ]
    },
    "amazonRDSMySQLDB": {
        "name": "Amazon RDS for MySQL",
        "serviceCode": "amazonRDSMySQLDB",
        "description": "MySQL is the world's most popular open source relational database. Amazon RDS makes it easy to set up, operate, and scale MySQL deployments in the cloud.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2",
            "us-gov-east-1",
            "eu-north-1",
            "ap-east-1",
            "me-south-1",
            "me-central-1"
        ],
        "linkUrl": "https://aws.amazon.com/rds/mysql",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRDSMySQLDB/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonRDSMySQLDB/en_US.json",
        "slug": "RDSMySQL",
        "mvpSupport": false,
        "comparableTerms": [
            "rdsmysql",
            "rdsmysqldb"
        ]
    },
    "amazonRdsForOracle": {
        "name": "Amazon RDS for Oracle",
        "serviceCode": "amazonRdsForOracle",
        "description": "Oracle® Database is a relational database management system developed by Oracle. Amazon RDS makes it easy to set up, operate, and scale Oracle Database deployments in the cloud. With Amazon RDS, you can deploy multiple editions of Oracle Database in minutes with cost-efficient and re-sizable hardware capacity.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-west-2",
            "us-west-1",
            "us-east-2",
            "us-east-1",
            "sa-east-1",
            "me-south-1",
            "me-central-1",
            "af-south-1",
            "eu-north-1",
            "eu-west-3",
            "eu-west-2",
            "eu-west-1",
            "eu-south-1",
            "eu-central-1",
            "ca-central-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "ap-northeast-1",
            "ap-southeast-2",
            "ap-southeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-southeast-3",
            "ap-south-1",
            "ap-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/rds/oracle",
        "isActive": "true",
        "hasDataTransfer": false,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRdsForOracle/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonRdsForOracle/en_US.json",
        "slug": "amazonRDSOracle",
        "mvpSupport": false,
        "comparableTerms": [
            "rdsfororacle",
            "rdsoracle"
        ]
    },
    "amazonRDSPostgreSQLDB": {
        "name": "Amazon RDS for PostgreSQL",
        "serviceCode": "amazonRDSPostgreSQLDB",
        "description": "Amazon RDS makes it easy to set up, operate, and scale PostgreSQL deployments in the cloud. With Amazon RDS, you can deploy scalable PostgreSQL deployments in minutes with cost-efficient and resizable hardware capacity. ",
        "searchKeywords": [
            "Database",
            "PostgreSQL",
            "postgresql",
            "database hosting",
            "hosted database",
            "Managed database"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2",
            "us-gov-east-1",
            "ap-east-1",
            "me-south-1",
            "me-central-1"
        ],
        "linkUrl": "https://aws.amazon.com/rds/postgresql",
        "isActive": "true",
        "hasDataTransfer": true,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRDSPostgreSQLDB/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonRDSPostgreSQLDB/en_US.json",
        "slug": "RDSPostgreSQL",
        "mvpSupport": false,
        "comparableTerms": [
            "rdspostgresql",
            "rdspostgresqldb"
        ]
    },
    "amazonRDSForSQLServer": {
        "name": "Amazon RDS for SQL server",
        "serviceCode": "amazonRDSForSQLServer",
        "description": "SQL Server is a relational database management system developed by Microsoft. Amazon RDS for SQL Server makes it easy to set up, operate, and scale SQL Server deployments in the cloud.",
        "searchKeywords": [
            "Database",
            "Aurora",
            "MySQL",
            "MariaDB",
            "Postgres",
            "Oracle",
            "SQL Server",
            "Database",
            "PostgreSQL",
            "Microsoft SQL Server",
            "Relational Database Service",
            "Database",
            "database hosting",
            "hosted database",
            "Managed database",
            "microsoft",
            "sql",
            "msft",
            "Managed Service",
            "MS",
            "Managed",
            "win"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "us-west-2",
            "us-west-1",
            "us-east-2",
            "us-east-1",
            "sa-east-1",
            "me-south-1",
            "me-central-1",
            "eu-north-1",
            "eu-west-3",
            "eu-west-2",
            "eu-west-1",
            "eu-south-1",
            "eu-central-1",
            "ca-central-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "ap-northeast-1",
            "ap-southeast-3",
            "ap-southeast-2",
            "ap-southeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/rds/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRDSForSQLServer/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonRDSForSQLServer/en_US.json",
        "slug": "RDSSQLServer",
        "mvpSupport": false,
        "comparableTerms": [
            "rds",
            "rdsforsqlserver",
            "rdssqlserver"
        ]
    },
    "amazonRdsForOutposts": {
        "name": "Amazon RDS on AWS Outposts",
        "serviceCode": "amazonRdsForOutposts",
        "description": "Amazon Relational Database Service (Amazon RDS) on AWS Outposts allows you to deploy fully managed database instances in your on-premises environments. AWS Outposts is a fully managed service that extends AWS infrastructure, AWS services, APIs, and tools to virtually any datacenter, co-location space, or on-premises facility for a truly consistent hybrid experience. You can deploy Amazon RDS on Outposts to set up, operate, and scale Microsoft SQL Server, MySQL and PostgreSQL relational databases on premises, just as you would in the cloud. Amazon RDS on Outposts provides cost-efficient and resizable capacity for on-premises databases, while automating time-consuming administration tasks including infrastructure provisioning, database setup, patching, and backups, freeing you to focus on your applications.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/rds/outposts",
        "isActive": "true",
        "hasDataTransfer": false,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRdsForOutposts/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "RDSOutposts",
        "mvpSupport": false,
        "comparableTerms": [
            "rdsforoutposts",
            "rdsonoutposts",
            "rdsoutposts"
        ]
    },
    "amazonRedshift": {
        "name": "Amazon Redshift",
        "serviceCode": "amazonRedshift",
        "description": "Amazon Redshift is a fully managed, petabyte-scale data warehouse service in the cloud. Amazon Redshift also extends data warehouse queries to your data lake, with no loading required. You can run analytic queries against petabytes of data stored locally in Redshift, and directly against exabytes of data stored in Amazon S3.",
        "searchKeywords": [
            "Database",
            "data warehouse",
            "data warehouse solution",
            "MySQL",
            "SQL",
            "data analysis",
            "business intelligence",
            "dw",
            "datawarehouse"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/redshift/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRedshift/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonRedshift/en_US.json",
        "slug": "Redshift",
        "mvpSupport": false,
        "comparableTerms": [
            "redshift"
        ]
    },
    "amazonRekognition": {
        "name": "Amazon Rekognition",
        "serviceCode": "amazonRekognition",
        "description": "Amazon Rekognition makes it easy to add image and video analysis to your applications using proven, highly scalable, deep learning technology that requires no machine learning expertise to use. With Amazon Rekognition, you can identify objects, people, text, scenes, and activities in images and videos, as well as detect any inappropriate content.",
        "searchKeywords": [
            "Rekognition",
            "image",
            "custom labels",
            "video"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/rekognition/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRekognition/en_US.json",
        "c2e": false,
        "templates": [
            "rekognitionImage",
            "rekognitionVideo",
            "rekognitionStreamingVideoEvents",
            "rekognitionCustomLabels",
            "rekognitionFaceLiveness"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonRekognition/en_US.json",
        "slug": "Rekognition",
        "mvpSupport": false,
        "comparableTerms": [
            "rekognition"
        ]
    },
    "amazonRoute53": {
        "name": "Amazon Route 53",
        "serviceCode": "amazonRoute53",
        "description": "Amazon Route 53 is a cloud Domain Name System (DNS) web service.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/route53/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRoute53/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonRoute53/en_US.json",
        "slug": "Route53",
        "mvpSupport": false,
        "comparableTerms": [
            "route53"
        ]
    },
    "amazonS3": {
        "name": "Amazon S3",
        "serviceCode": "amazonS3",
        "description": "Amazon Simple Storage Service (Amazon S3) is the largest and most performant, secure, and feature-rich object storage service. With Amazon S3, organizations of all sizes and industries can store any amount of data for any use case, including applications, IoT, data lakes, analytics, backup and restore, archive, and disaster recovery.",
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "eu-west-1",
            "eu-west-2",
            "eu-central-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-south-1"
        ],
        "linkUrl": "https://aws.amazon.com/s3",
        "isActive": "false",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonS3/en_US.json",
        "comparableTerms": [
            "s3"
        ]
    },
    "amazonSageMaker": {
        "name": "Amazon SageMaker",
        "serviceCode": "amazonSageMaker",
        "description": "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments. Pricing within Amazon SageMaker is broken down by on-demand ML instances, ML storage, and fees for data processing in hosting instances.",
        "searchKeywords": [
            "Sagemaker",
            "Model",
            "ML",
            "Machine Learning",
            "EI",
            "data scientist",
            "Data Wrangler",
            "Feature Store",
            "Sagemaker Edge"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/sagemaker/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonSageMaker/en_US.json",
        "c2e": false,
        "templates": [
            "sageMakerStudioNotebooks",
            "sageMakerRStudioOnSageMaker",
            "sageMakerOnDemandNotebookInstances",
            "sageMakerProcessing",
            "sageMakerDataWrangler",
            "sageMakerFeatureStore",
            "sageMakerTraining",
            "sageMakerRealTimeInference",
            "sageMakerAsynchronousInference",
            "sageMakerBatchTransform",
            "amazonSageMakerEdgeManager",
            "sageMakerServerlessInference",
            "sageMakerAutopilot"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonSageMaker/en_US.json",
        "slug": "SageMaker",
        "mvpSupport": false,
        "comparableTerms": [
            "sagemaker"
        ]
    },
    "amazonSageMakerGroundTruth": {
        "name": "Amazon SageMaker Ground Truth",
        "serviceCode": "amazonSageMakerGroundTruth",
        "description": "Amazon SageMaker Ground Truth helps you build training datasets for machine learning. Ground Truth will label your content (images, audio, text, etc) by guiding a human labeler step-by-step in a process called a workflow.",
        "searchKeywords": [
            "Sagemaker",
            "ground truth",
            "computer vision",
            "3d point clouds",
            "image labeling",
            "labeler",
            "Model",
            "ML",
            "Machine Learning",
            "EI",
            "data scientist"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "eu-west-1",
            "ap-southeast-1",
            "ap-northeast-1",
            "us-west-2",
            "ap-southeast-2",
            "eu-central-1",
            "ap-northeast-2",
            "ap-south-1",
            "us-east-2",
            "ca-central-1",
            "eu-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/sagemaker/groundtruth/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonSageMakerGroundTruth/en_US.json",
        "c2e": false,
        "slug": "SageMakerGroundTruth",
        "mvpSupport": false,
        "comparableTerms": [
            "sagemakergroundtruth"
        ]
    },
    "amazonSecurityLake": {
        "name": "Amazon Security Lake",
        "serviceCode": "amazonSecurityLake",
        "description": "Amazon Security Lake automatically centralizes security data from cloud, on-premises, and custom sources into a purpose-built data lake stored in your account. With Security Lake, you can get a more complete understanding of your security data across your entire organization. ",
        "searchKeywords": [
            "security",
            "lake"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/security-lake/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonSecurityLake/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonSecurityLake/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "securitylake"
        ]
    },
    "amazonSimpleEmailService": {
        "name": "Amazon Simple Email Service (SES)",
        "serviceCode": "amazonSimpleEmailService",
        "description": "Amazon Simple Email Service (Amazon SES) is a cloud-based email sending service designed to help digital marketers and application developers send marketing, notification, and transactional emails.",
        "searchKeywords": [
            "SES",
            "Email",
            "Amazon Simple Email Service",
            "Simple Email Service"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-west-2-wl1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/ses/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonSimpleEmailService/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonSimpleEmailService/en_US.json",
        "slug": "SES",
        "mvpSupport": false,
        "comparableTerms": [
            "ses",
            "simpleemail",
            "simpleemailservice",
            "simpleemailserviceses"
        ]
    },
    "amazonSimpleNotificationService": {
        "name": "Amazon Simple Notification Service (SNS)",
        "serviceCode": "amazonSimpleNotificationService",
        "description": "Amazon Simple Notification Service (SNS) is a highly available, durable, secure, fully managed pub/sub messaging service that enables you to decouple microservices, distributed systems, and serverless applications.",
        "searchKeywords": [
            "Messaging",
            "SNS",
            "notification topic",
            "publish message",
            "subscription",
            "text message",
            "sms",
            "topics",
            "push notifications",
            "push notification service queuing"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/sns/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonSimpleNotificationService/en_US.json",
        "c2e": false,
        "templates": [
            "standardTopics",
            "fifoTopics"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonSimpleNotificationService/en_US.json",
        "slug": "SNS",
        "mvpSupport": false,
        "comparableTerms": [
            "simplenotification",
            "simplenotificationservice",
            "simplenotificationservicesns",
            "sns"
        ]
    },
    "amazonSimpleQueueService": {
        "name": "Amazon Simple Queue Service (SQS)",
        "serviceCode": "amazonSimpleQueueService",
        "description": "Amazon Simple Queue Service (SQS) is a fully managed message queuing service that enables you to decouple and scale microservices, distributed systems, and serverless applications.",
        "searchKeywords": [
            "Messaging",
            "SQS",
            "queue service",
            "push notifications",
            "queueing",
            "message queueing",
            "batch processing",
            "managed queue",
            "transmit data",
            "hosted queues",
            "storing messages",
            "move data",
            "perform tasks",
            "decouple componenets",
            "message processing",
            "message repository",
            "temporary repository",
            "message delivery",
            "distributed queues",
            "delay queues"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-south-1",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/sqs",
        "isActive": "true",
        "hasDataTransfer": true,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonSimpleQueueService/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "SQS",
        "mvpSupport": false,
        "comparableTerms": [
            "simplequeue",
            "simplequeueservice",
            "simplequeueservicesqs",
            "sqs"
        ]
    },
    "amazonSimpleStorageServiceGroup": {
        "name": "Amazon Simple Storage Service (S3)",
        "serviceCode": "amazonSimpleStorageServiceGroup",
        "description": "Amazon Simple Storage Service (Amazon S3) is storage for the internet. You can use Amazon S3 to store and retrieve any amount of data at any time, from anywhere on the web.",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage",
            "S3",
            "s3"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/s3/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonSimpleStorageServiceGroup/en_US.json",
        "c2e": false,
        "templates": [
            "amazonS3Standard",
            "amazonS3IntelligentTiering",
            "amazonS3StandardInfrequentAccess",
            "s3OneZoneInfrequentAccess",
            "amazonS3Glacier",
            "amazonS3GlacierDeepArhive",
            "amazonS3StorageManagement",
            "s3ObjectLambda",
            "s3GlacierInstantRetrieval",
            "awsS3DataTransfer"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonSimpleStorageServiceGroup/en_US.json",
        "slug": "S3",
        "mvpSupport": false,
        "comparableTerms": [
            "s3",
            "simplestorageservicegroup",
            "simplestorageservices3"
        ]
    },
    "amazonSimpleWorkflowService": {
        "name": "Amazon Simple Workflow Service (SWF)",
        "serviceCode": "amazonSimpleWorkflowService",
        "description": "Amazon SWF helps developers build, run, and scale background jobs that have parallel or sequential steps. You can think of Amazon SWF as a fully-managed state tracker and task coordinator in the Cloud.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2",
            "me-south-1",
            "me-central-1"
        ],
        "linkUrl": "https://aws.amazon.com/swf/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonSimpleWorkflowService/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonSimpleWorkflowService/en_US.json",
        "slug": "SWF",
        "mvpSupport": false,
        "comparableTerms": [
            "simpleworkflow",
            "simpleworkflowservice",
            "simpleworkflowserviceswf",
            "swf"
        ]
    },
    "amazonTextract": {
        "name": "Amazon Textract",
        "serviceCode": "amazonTextract",
        "description": "Amazon Textract is a fully managed machine learning service that automatically extracts printed text, handwriting, and other data from scanned documents that goes beyond simple optical character recognition (OCR) to identify, understand, and extract data from forms and tables.",
        "searchKeywords": [
            "textract",
            "text"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/textract/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonTextract/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonTextract/en_US.json",
        "slug": "Textract",
        "mvpSupport": false,
        "comparableTerms": [
            "textract"
        ]
    },
    "amazonTimestream": {
        "name": "Amazon Timestream",
        "serviceCode": "amazonTimestream",
        "description": "Amazon Timestream is a fast, scalable, and serverless time series database service for IoT and operational applications that makes it easy to store and analyze trillions of events per day up to 1,000 times faster and at as little as 1/10th the cost of relational databases. Amazon Timestream saves you time and cost in managing the lifecycle of time series data by keeping recent data in memory and moving historical data to a cost optimized storage tier based upon user defined policies. Amazon Timestream’s purpose-built query engine lets you access and analyze recent and historical data together, without needing to specify explicitly in the query whether the data resides in the in-memory or cost-optimized tier. Amazon Timestream has built-in time series analytics functions, helping you identify trends and patterns in your data in near real-time. Amazon Timestream is serverless and automatically scales up or down to adjust capacity and performance, so you don’t need to manage the underlying infrastructure, freeing you to focus on building your applications.",
        "searchKeywords": [
            "timestream"
        ],
        "type": "AWSService",
        "regions": [
            "eu-central-1",
            "eu-west-1",
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "ap-northeast-1",
            "ap-southeast-2"
        ],
        "linkUrl": "https://aws.amazon.com/timestream/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonTimestream/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonTimestream/en_US.json",
        "slug": "AmazonTimestream",
        "mvpSupport": false,
        "comparableTerms": [
            "timestream"
        ]
    },
    "amazonTranscribe": {
        "name": "Amazon Transcribe",
        "serviceCode": "amazonTranscribe",
        "description": "Amazon Transcribe is a fully-managed automatic speech recognition (ASR) service that makes it easy for developers to add speech-to-text capabilities to voice applications. Powered by deep learning, the service supports transcription through its batch file (asynchronous) and streaming (real-time) APIs. Amazon Transcribe offers accurate transcription across more than 30 global languages and accents.",
        "searchKeywords": [
            "transcribe",
            "transcription",
            "STT",
            "VTT",
            "audio",
            "voice",
            "subtitles",
            "caption",
            "language",
            "scribes",
            "vocabulary",
            "medical",
            "archiving",
            "archives",
            "call",
            "analytics",
            "call analytics"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "sa-east-1",
            "me-south-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/transcribe/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonTranscribe/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonTranscribe/en_US.json",
        "slug": "Transcribe",
        "mvpSupport": false,
        "comparableTerms": [
            "transcribe"
        ]
    },
    "amazonTranscribeMedical": {
        "name": "Amazon Transcribe Medical",
        "serviceCode": "amazonTranscribeMedical",
        "description": "Amazon Transcribe Medical is a HIPAA-eligible automatic speech recognition (ASR) service that makes it easy for developers to add speech-to-text capabilities to their healthcare and life science applications.",
        "searchKeywords": [
            "transcribe",
            "transcription",
            "STT",
            "VTT",
            "audio",
            "voice",
            "subtitles",
            "caption",
            "language",
            "scribes",
            "vocabulary",
            "medical",
            "archiving",
            "archives"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-2",
            "ca-central-1",
            "eu-west-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/transcribe/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonTranscribeMedical/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonTranscribeMedical/en_US.json",
        "slug": "TranscribeMedical",
        "mvpSupport": false,
        "comparableTerms": [
            "transcribe",
            "transcribemedical"
        ]
    },
    "amazonTranslate": {
        "name": "Amazon Translate",
        "serviceCode": "amazonTranslate",
        "description": "Amazon Translate is a neural machine translation service that delivers fast, high-quality, and affordable language translation. Neural machine translation is a form of language translation automation that uses deep learning models to deliver more accurate and more natural sounding translation than traditional statistical and rule-based translation algorithms.",
        "searchKeywords": [
            "NLP",
            "Natural language processing",
            "language transalation",
            "Text analytics",
            "Language translation",
            "Amazon translate",
            "Translate"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/translate/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonTranslate/en_US.json",
        "c2e": false,
        "templates": [
            "standardRealTimeTranslation",
            "standardBatchTranslation",
            "activeCustomBatchTranslation",
            "realTimeDocumentTranslation"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonTranslate/en_US.json",
        "slug": "Translate",
        "mvpSupport": false,
        "comparableTerms": [
            "translate"
        ]
    },
    "amazonVerifiedPermissions": {
        "name": "Amazon Verified Permissions",
        "serviceCode": "amazonVerifiedPermissions",
        "description": "Amazon Verified Permissions is a scalable, fine-grained permissions management and authorization service for custom applications. The service centralizes fine-grained permissions for custom applications and helps developers authorize user actions within applications. Amazon Verified Permissions uses the Cedar policy language to define fine-grained permissions for application users.",
        "searchKeywords": [
            "security",
            "lake"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/verified-permissions/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonVerifiedPermissions/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonVerifiedPermissions/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "verifiedpermissions"
        ]
    },
    "amazonVirtualPrivateCloud": {
        "name": "Amazon Virtual Private Cloud (VPC)",
        "serviceCode": "amazonVirtualPrivateCloud",
        "description": "Amazon Virtual Private Cloud (Amazon VPC) lets you provision a logically isolated section of the AWS Cloud where you can launch AWS resources in a virtual network that you define.",
        "searchKeywords": [
            "access control",
            "ACL",
            "AWS Privatelink",
            "Cloud connectivity",
            "corporate network",
            "elastic IP",
            "Gateway load balancer",
            "home network VPN",
            "IPAM",
            "NAT",
            "NAT gateway",
            "Network Access Analyzer",
            "Network Address Translation",
            "Networking Content Delivery",
            "PrivateLink",
            "Reachability Analyzer",
            "security",
            "single tenant hardware",
            "static ip",
            "subnets",
            "Traffic mirroring",
            "Transit Gateway",
            "Virtual Private Cloud",
            "VPN"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/vpc/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonVirtualPrivateCloud/en_US.json",
        "c2e": false,
        "templates": [
            "vpnConnectionVpc",
            "networkAddressTranslationNatGatewayVpc",
            "transitGatewayVpc",
            "awsPrivateLinkVpc",
            "dataTransferVpc",
            "gatewayLoadBalancerVpc",
            "ipamVpc",
            "networkAccessAnalyzerVpc",
            "trafficMirroringVpc",
            "reachabilityAnalyzerVpc",
            "cloudWan"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonVirtualPrivateCloud/en_US.json",
        "slug": "VPC",
        "mvpSupport": false,
        "comparableTerms": [
            "virtualprivatecloud",
            "virtualprivatecloudvpc",
            "vpc"
        ]
    },
    "amazonWorkdocs": {
        "name": "Amazon WorkDocs",
        "serviceCode": "amazonWorkdocs",
        "description": "Amazon WorkDocs is a fully managed, secure content creation, storage, and collaboration service. With Amazon WorkDocs, you can easily create, edit, and share content, and because it’s stored centrally on AWS, access it from anywhere on any device.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-west-1",
            "us-east-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/workdocs/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonWorkdocs/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "WorkDocs",
        "mvpSupport": false,
        "comparableTerms": [
            "workdocs"
        ]
    },
    "amazonWorkmail": {
        "name": "Amazon WorkMail",
        "serviceCode": "amazonWorkmail",
        "description": "Amazon WorkMail is a secure, managed business email and calendar service with support for existing desktop and mobile email client applications. Amazon WorkMail gives users the ability to seamlessly access their email, contacts, and calendars using the client application of their choice, including Microsoft Outlook, native iOS and Android email applications, any client application supporting the IMAP protocol, or directly through a web browser. You can integrate Amazon WorkMail with your existing corporate directory, use email journaling to meet compliance requirements, and control both the keys that encrypt your data and the location in which your data is stored. You can also set up interoperability with Microsoft Exchange Server, and programmatically manage users, groups, and resources using the Amazon WorkMail SDK.",
        "searchKeywords": [
            "workmail",
            "business email",
            "managed email",
            "calendar service",
            "managed service",
            "outlook",
            "iOS",
            "andriod",
            "email applications",
            "exchange server",
            "IMAP"
        ],
        "type": "AWSService",
        "regions": [
            "eu-west-1",
            "us-east-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/workmail/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonWorkmail/en_US.json",
        "c2e": false,
        "slug": "WorkMail",
        "mvpSupport": false,
        "comparableTerms": [
            "workmail"
        ]
    },
    "amazonWorkspaces": {
        "name": "Amazon WorkSpaces",
        "serviceCode": "amazonWorkspaces",
        "description": "Amazon WorkSpaces is a managed, secure cloud desktop service. You can use Amazon WorkSpaces to provision either Windows or Linux desktops in just a few minutes and quickly scale to provide thousands of desktops to workers across the globe.",
        "searchKeywords": [
            "cloud desktop",
            "workspaces"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ap-northeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-west-2",
            "sa-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/workspaces/",
        "isActive": "true",
        "hasDataTransfer": false,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonWorkspaces/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/amazonWorkspaces/en_US.json",
        "slug": "WorkSpaces",
        "mvpSupport": false,
        "comparableTerms": [
            "workspaces"
        ]
    },
    "applicationLoadBalancer": {
        "name": "Application Load Balancer",
        "serviceCode": "applicationLoadBalancer",
        "description": "Elastic Load Balancing automatically distributes incoming application traffic across multiple targets, such as Amazon EC2 instances, containers, IP addresses, and Lambda functions.",
        "searchKeywords": [
            "ELB",
            "Elastic Load Balancer",
            "Load Balancer",
            "Application Load Balancer",
            "Network Load Balancer",
            "Classic Load Balancer"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-east-1",
            "us-east-1-atl-1",
            "us-east-1-bos-1",
            "us-east-1-chi-1",
            "us-east-1-dfw-1",
            "us-east-1-iah-1",
            "us-east-1-mci-1",
            "us-east-1-mia-1",
            "us-east-1-msp-1",
            "us-east-1-nyc-1",
            "us-east-1-phl-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-west-2-den-1",
            "us-west-2-las-1",
            "us-west-2-lax-1",
            "us-west-2-pdx-1",
            "us-west-2-phx-1",
            "us-west-2-sea-1",
            "us-east-1-wl1",
            "us-east-1-wl1-atl1",
            "us-east-1-wl1-chi1",
            "us-east-1-wl1-clt1",
            "us-east-1-wl1-dfw1",
            "us-east-1-wl1-dtw1",
            "us-east-1-wl1-iah1",
            "us-east-1-wl1-mia1",
            "us-east-1-wl1-msp1",
            "us-east-1-wl1-nyc1",
            "us-east-1-wl1-was1",
            "us-west-2-wl1",
            "us-west-2-wl1-den1",
            "us-west-2-wl1-las1",
            "us-west-2-wl1-lax1",
            "us-west-2-wl1-phx1",
            "us-west-2-wl1-sea1"
        ],
        "linkUrl": "https://aws.amazon.com/elasticloadbalancing/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/applicationLoadBalancer/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/applicationLoadBalancer/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "applicationloadbalancer"
        ],
        "parentServiceCode": "elasticLoadBalancing"
    },
    "appSyncApiCall": {
        "name": "AppSync API Request",
        "serviceCode": "appSyncApiCall",
        "searchKeywords": [
            "query",
            "graphql",
            "api"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/appsync/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/appSyncApiCall/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/appSyncApiCall/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "appsyncapicall",
            "appsyncapirequest"
        ],
        "parentServiceCode": "awsAppSync"
    },
    "appSyncCaching": {
        "name": "AppSync Caching",
        "serviceCode": "appSyncCaching",
        "searchKeywords": [
            "query",
            "graphql",
            "api"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/appsync/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/appSyncCaching/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/appSyncCaching/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "appsynccaching"
        ],
        "parentServiceCode": "awsAppSync"
    },
    "appsyncDataTransfer": {
        "name": "Appsync Data Transfer",
        "serviceCode": "appsyncDataTransfer",
        "searchKeywords": [
            "data transfer"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/appsync/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/appsyncDataTransfer/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/appsyncDataTransfer/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "appsyncdatatransfer"
        ],
        "parentServiceCode": "awsAppSync"
    },
    "appSyncRealTime": {
        "name": "AppSync Real-Time",
        "serviceCode": "appSyncRealTime",
        "searchKeywords": [
            "query"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/appsync/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/appSyncRealTime/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/appSyncRealTime/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "appsyncrealtime"
        ],
        "parentServiceCode": "awsAppSync"
    },
    "as2": {
        "name": "AS2",
        "serviceCode": "as2",
        "searchKeywords": [
            "sftp",
            "FTPS",
            "as2",
            "amazon s3",
            "s3",
            "winscp",
            "filezilla",
            "cyberduck",
            "ssh",
            "transfer",
            "ftp",
            "ftp/s",
            "openssh",
            "file transfer",
            "secure file transfer",
            "ssh ftp",
            "secure shell file transfer protocol",
            "file transfer protocol"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-gov-west-1",
            "us-gov-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/aws-transfer-family/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/as2/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/as2/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "as2"
        ],
        "parentServiceCode": "aWSTransferForSFTP"
    },
    "amazonAuroraBackup": {
        "name": "Aurora",
        "serviceCode": "amazonAuroraBackup",
        "description": "AWS Backup for Aurora",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/backup/",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonAuroraBackup/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonAuroraBackup/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "aurorabackup",
            "backupaurora"
        ],
        "parentServiceCode": "awsBackup"
    },
    "awsSystemsManagerAutomation": {
        "name": "Automation",
        "serviceCode": "awsSystemsManagerAutomation",
        "description": "AWS Systems Manager Automation feature",
        "searchKeywords": [
            "System Manager",
            "Automation",
            "steps",
            "automate"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/systems-manager/",
        "isActive": "true",
        "hasDataTransfer": false,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsSystemsManagerAutomation/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsSystemsManagerAutomation/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "automation",
            "systemsmanagerautomation"
        ],
        "parentServiceCode": "awsSystemsManager"
    },
    "awsAmplify": {
        "name": "AWS Amplify",
        "serviceCode": "awsAmplify",
        "description": "AWS Amplify is a set of tools and services that can be used together or on their own, to help front-end web and mobile developers build scalable full stack applications, powered by AWS. With Amplify, you can create an app backend for web and mobile, and then connect your Git branch to deploy and host a web app in a few clicks.",
        "searchKeywords": [
            "authentication",
            "datastore",
            "storage",
            "console",
            "analytics",
            "mobile apps",
            "flows",
            "predictions",
            "api",
            "graphql",
            "pubsub",
            "hosting",
            "libraries",
            "user management",
            "content management",
            "UI",
            "frontend",
            "database",
            "ci/cd",
            "git",
            "amplify",
            "SSR request"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/amplify/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsAmplify/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsAmplify/en_US.json",
        "slug": "Amplify",
        "mvpSupport": false,
        "comparableTerms": [
            "amplify"
        ]
    },
    "awsAppRunner": {
        "name": "AWS App Runner",
        "serviceCode": "awsAppRunner",
        "description": "AWS App Runner is a fully managed service that makes it easy for developers to quickly deploy containerized web applications and APIs, at scale and with no prior infrastructure experience required. Start with your source code or a container image. App Runner builds and deploys the web application automatically, load balances traffic with encryption, scales to meet your traffic needs, and makes it easy for your services to communicate with other AWS services and applications that run in a private Amazon VPC. With App Runner, rather than thinking about servers or scaling, you have more time to focus on your applications.",
        "searchKeywords": [
            "apprunner"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/apprunner/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsAppRunner/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsAppRunner/en_US.json",
        "slug": "apprunner",
        "mvpSupport": false,
        "comparableTerms": [
            "apprunner"
        ]
    },
    "awsAppConfig": {
        "name": "AWS AppConfig",
        "serviceCode": "awsAppConfig",
        "description": "AWS AppConfig enables you to provide validation logic to ensure your configuration data is syntactically and semantically correct according to your definitions before making it available to your application. AWS AppConfig also gives you the ability to roll out configuration changes over a defined time period while monitoring your application so that you can catch errors and roll back the changes if needed, to help you minimize the impact to the users.",
        "searchKeywords": [
            "Systems Manager",
            "AppConfig",
            "configuration",
            "monitoring"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ap-northeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/systems-manager/",
        "isActive": "true",
        "hasDataTransfer": false,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsAppConfig/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsAppConfig/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "appconfig"
        ],
        "parentServiceCode": "awsSystemsManager"
    },
    "awsAppFabric": {
        "name": "AWS AppFabric",
        "serviceCode": "awsAppFabric",
        "description": "AWS AppFabric quickly connects Software as a Service (SaaS) applications across the organization so IT and security teams can easily manage and secure applications using a standard schema, and employees can complete everyday tasks faster using generative AI.",
        "searchKeywords": [
            "AWS App Fabric"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/appfabric",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsAppFabric/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsAppFabric/en_US.json",
        "slug": "appfabric",
        "mvpSupport": false,
        "comparableTerms": [
            "appfabric"
        ]
    },
    "awsAppSync": {
        "name": "AWS AppSync",
        "serviceCode": "awsAppSync",
        "description": "AWS AppSync is a fully managed service that makes it easy to develop GraphQL APIs by handling the heavy lifting of securely connecting to data sources like AWS DynamoDB, Lambda, and more.",
        "searchKeywords": [
            "appsync",
            "query",
            "data modification",
            "data transfer"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/appsync/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsAppSync/en_US.json",
        "c2e": false,
        "templates": [
            "appSyncApiCall",
            "appSyncRealTime",
            "appSyncCaching",
            "appsyncDataTransfer"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsAppSync/en_US.json",
        "slug": "appSync",
        "mvpSupport": false,
        "comparableTerms": [
            "appsync"
        ]
    },
    "awsAuditManager": {
        "name": "AWS Audit Manager",
        "serviceCode": "awsAuditManager",
        "description": "AWS Audit Manager helps you continuously audit your AWS usage to simplify how you assess risk and compliance. When you define and launch an assessment based on an assessment framework, Audit Manager will execute a resource assessment for each individual resource, such as your Amazon EC2 instances, Amazon RDS instances, Amazon S3 buckets, or Amazon VPC subnets.",
        "searchKeywords": [
            "security",
            "lake"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/audit-manager/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsAuditManager/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsAuditManager/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "auditmanager"
        ]
    },
    "awsBackup": {
        "name": "AWS Backup",
        "serviceCode": "awsBackup",
        "description": "AWS Backup is a centralized and fully-managed service with an end-to-end solution for business and regulatory compliance requirements. Using this service, you can automate data protection across AWS services, in the cloud, and on premises. With a few clicks in the AWS Backup console, you can automate your data protection policies and schedules without creating custom scripts and manual processes.",
        "searchKeywords": [
            "data",
            "protection",
            "regulatory compliance",
            "EFS",
            "EBS",
            "RDS",
            "S3",
            "Aurora",
            "FSx",
            "Windows",
            "Lustre",
            "NetApp ONTAP",
            "OpenZFS",
            "Storage Gateway",
            "gateway",
            "VMware",
            "Neptune",
            "DynamoDB",
            "DocumentDB",
            "Backup"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/backup/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsBackup/en_US.json",
        "c2e": false,
        "templates": [
            "amazonEfsBackup",
            "amazonVMwareBackup",
            "amazonEbsBackup",
            "amazonRdsBackup",
            "amazonStorageGatewayBackup",
            "amazonS3Backup",
            "amazonFSxWindowsBackup",
            "amazonFSxLustreBackup",
            "amazonFSxNetAppOntapBackup",
            "amazonFSxOpenZfsBackup",
            "amazonDynamoDbBackup",
            "amazonAuroraBackup",
            "amazonNeptuneBackup",
            "amazonDocumentDbBackup"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsBackup/en_US.json",
        "slug": "Backup",
        "mvpSupport": false,
        "comparableTerms": [
            "backup"
        ]
    },
    "awsBillingConductor": {
        "name": "AWS Billing Conductor",
        "serviceCode": "awsBillingConductor",
        "description": "With AWS Billing Conductor, you only pay for the pro forma billing records you generate. AWS Billing Conductor gives you the ability to model your billing in a way that more closely matches your organizational structure while retaining the existing billing relationship you have with AWS. To achieve this alternative view of your billing data, the AWS Billing Conductor generates a second, pro forma version of your billing records, consistent with your desired account segmentation, rate management, and custom line items.",
        "searchKeywords": [
            "AWS Billing Conductor"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/aws-cost-management/aws-billing-conductor/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsBillingConductor/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsBillingConductor/en_US.json",
        "slug": "billingconductor",
        "mvpSupport": false,
        "comparableTerms": [
            "billingconductor",
            "costmanagementbillingconductor"
        ]
    },
    "mainframeBluAge": {
        "name": "AWS Blu Age automated refactoring",
        "serviceCode": "mainframeBluAge",
        "description": "For AWS M2 Blu Age managed runtime, you can choose on-demand instances and pay for the runtime by the hour with no long-term commitments or upfront fees, or choose committed plans for additional savings.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "sa-east-1",
            "us-east-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/mainframe-modernization/pricing/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/mainframeBluAge/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/mainframeBluAge/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "bluageautomatedrefactoring",
            "mainframebluage"
        ],
        "parentServiceCode": "amazonMainframeModernization"
    },
    "awsBudgets": {
        "name": "AWS Budgets",
        "serviceCode": "awsBudgets",
        "description": "AWS Budgets lets you set custom cost and usage budgets that alert you when your budget thresholds are exceeded (or forecasted to exceed). You can also create budgets to track your aggregate Reservation and Savings Plans utilization and coverage metrics.",
        "searchKeywords": [
            "budgets",
            "cost management",
            "budgets report"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/aws-cost-management/aws-budgets/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsBudgets/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsBudgets/en_US.json",
        "slug": "budgets",
        "mvpSupport": false,
        "comparableTerms": [
            "budgets",
            "costmanagementbudgets"
        ]
    },
    "awsCloudMap": {
        "name": "AWS Cloud Map",
        "serviceCode": "awsCloudMap",
        "description": "AWS Cloud Map is a cloud resource discovery service. With Cloud Map, you can define custom names for your application resources, and it maintains the updated location of these dynamically changing resources. This increases your application availability because your web service always discovers the most up-to-date locations of its resources.",
        "searchKeywords": [
            "API calls",
            "DNS queries",
            "resource discoveries",
            "discovery queries",
            "service discovery",
            "discovery API"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/cloud-map/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsCloudMap/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsCloudMap/en_US.json",
        "slug": "CloudMap",
        "mvpSupport": false,
        "comparableTerms": [
            "cloudmap"
        ]
    },
    "awsCloudFormation": {
        "name": "AWS CloudFormation",
        "serviceCode": "awsCloudFormation",
        "description": "AWS CloudFormation provides a common language for you to model and provision AWS and third party application extensions in your cloud environment.",
        "searchKeywords": [
            "cloudformation",
            "formation",
            "cloud",
            "application resources"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/cloudformation/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsCloudFormation/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "CloudFormation",
        "mvpSupport": false,
        "comparableTerms": [
            "cloudformation"
        ]
    },
    "awsCloudHsm": {
        "name": "AWS CloudHSM",
        "serviceCode": "awsCloudHsm",
        "description": "AWS CloudHSM is a cloud-based hardware security module (HSM) that enables you to easily generate and use your own encryption keys on the AWS Cloud. With CloudHSM, you can manage your own encryption keys using FIPS 140-2 Level 3 validated HSMs.",
        "searchKeywords": [
            "crypto"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "eu-south-1",
            "af-south-1"
        ],
        "linkUrl": "https://aws.amazon.com/cloudhsm",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsCloudHsm/en_US.json",
        "c2e": false,
        "slug": "CloudHSM",
        "comparableTerms": [
            "cloudhsm"
        ]
    },
    "awsCloudTrail": {
        "name": "AWS CloudTrail",
        "serviceCode": "awsCloudTrail",
        "description": "AWS CloudTrail is a service that enables governance, compliance, operational auditing, and risk auditing of your AWS account. With CloudTrail, you can log, continuously monitor, and retain account activity related to actions across your AWS infrastructure.",
        "searchKeywords": [
            "cloudtrail",
            "operational auditing",
            "governance",
            "compliance",
            "risk auditing",
            "event history",
            "unusual activity",
            "troubleshooting",
            "operational analysis",
            "logs",
            "monitor account activity",
            "trail"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/cloudtrail/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsCloudTrail/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsCloudTrail/en_US.json",
        "slug": "CloudTrail",
        "mvpSupport": false,
        "comparableTerms": [
            "cloudtrail"
        ]
    },
    "awsCodeArtifact": {
        "name": "AWS CodeArtifact",
        "serviceCode": "awsCodeArtifact",
        "description": "AWS CodeArtifact is a fully managed artifact repository service that makes it easy for organizations of any size to securely store, publish, and share software packages used in their software development process.",
        "searchKeywords": [
            "artifacts",
            "reqeusts",
            "data transfer",
            "public aritfact repositories",
            "storage",
            "npm",
            "maven",
            "nuget",
            "pypi",
            "python",
            "nuget"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "eu-north-1",
            "eu-south-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "ap-northeast-1",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2"
        ],
        "linkUrl": "https://aws.amazon.com/codeartifact/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsCodeArtifact/en_US.json",
        "c2e": false,
        "slug": "CodeArtifact",
        "mvpSupport": false,
        "comparableTerms": [
            "codeartifact"
        ]
    },
    "awsCodeBuild": {
        "name": "AWS CodeBuild",
        "serviceCode": "awsCodeBuild",
        "description": "AWS CodeBuild is a fully managed continuous integration service that compiles source code, runs tests, and produces software packages that are ready to deploy.",
        "searchKeywords": [
            "CodeBuild",
            "Code",
            "code build"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-south-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-west-1",
            "us-gov-east-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/codebuild/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsCodeBuild/en_US.json",
        "c2e": false,
        "slug": "codebuild",
        "mvpSupport": false,
        "comparableTerms": [
            "codebuild"
        ]
    },
    "awsCodeCommit": {
        "name": "AWS CodeCommit",
        "serviceCode": "awsCodeCommit",
        "description": "AWS CodeCommit is a secure, highly scalable, fully managed source control service that hosts private Git repositories.",
        "searchKeywords": [
            "codecommit",
            "code",
            "commit"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/codecommit/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsCodeCommit/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": true,
        "serviceDefinitionUrlPath": "/data/awsCodeCommit/en_US.json",
        "slug": "codecommit",
        "mvpSupport": false,
        "comparableTerms": [
            "codecommit"
        ]
    },
    "awsCodeDeploy": {
        "name": "AWS CodeDeploy",
        "serviceCode": "awsCodeDeploy",
        "description": "AWS CodeDeploy is a fully managed deployment service that automates software deployments to a variety of compute services such as Amazon EC2, AWS Fargate, AWS Lambda, and your on-premises servers.",
        "searchKeywords": [
            "codedeploy",
            "CodeDeploy",
            "deployment"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/codedeploy/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsCodeDeploy/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "CodeDeploy",
        "mvpSupport": false,
        "comparableTerms": [
            "codedeploy"
        ]
    },
    "awsCodePipeline": {
        "name": "AWS CodePipeline",
        "serviceCode": "awsCodePipeline",
        "description": "AWS CodePipeline is a fully managed continuous delivery service that helps you automate your release pipelines for fast and reliable application and infrastructure updates.",
        "searchKeywords": [
            "code",
            "pipeline"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/codepipeline/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsCodePipeline/en_US.json",
        "c2e": false,
        "slug": "CodePipeline",
        "comparableTerms": [
            "codepipeline"
        ]
    },
    "awsConfig": {
        "name": "AWS Config",
        "serviceCode": "awsConfig",
        "description": "AWS Config is a service that enables you to assess, audit, and evaluate the configurations of your AWS resources. Config continuously monitors and records your AWS resource configurations and allows you to automate the evaluation of recorded configurations against desired configurations.",
        "searchKeywords": [
            "Management Tools",
            "management tools",
            "configuration management",
            "CMDB",
            "inventory",
            "discovery",
            "Config Rules",
            "compliance",
            "governance",
            "audit"
        ],
        "type": "AWSService",
        "regions": [
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/config/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsConfig/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsConfig/en_US.json",
        "slug": "Config",
        "mvpSupport": false,
        "comparableTerms": [
            "config"
        ]
    },
    "awsCostExplorer": {
        "name": "AWS Cost Explorer",
        "serviceCode": "awsCostExplorer",
        "description": "AWS Cost Explorer provides you with a set of default reports that you can use as the starting place for your analysis. From there, use the filtering and grouping capabilities to dive deeper into your cost and usage data and generate custom insights.",
        "searchKeywords": [
            "aws cost explorer",
            "aws budgets",
            "cost management",
            "budgets"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/aws-cost-management/aws-cost-explorer/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsCostExplorer/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsCostExplorer/en_US.json",
        "slug": "cost-explorer",
        "mvpSupport": false,
        "comparableTerms": [
            "costexplorer",
            "costmanagementcostexplorer"
        ]
    },
    "awsDataPipeline": {
        "name": "AWS Data Pipeline",
        "serviceCode": "awsDataPipeline",
        "description": "AWS Data Pipeline is a web service that helps you reliably process and move data between different AWS compute and storage services, as well as on-premises data sources, at specified intervals.",
        "searchKeywords": [
            "datapipeline",
            "data",
            "move data"
        ],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1",
            "ap-southeast-2",
            "eu-west-1",
            "us-west-2",
            "us-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/datapipeline/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsDataPipeline/en_US.json",
        "c2e": false,
        "slug": "datapipeline",
        "mvpSupport": false,
        "comparableTerms": [
            "datapipeline"
        ]
    },
    "aWSDataTransfer": {
        "name": "AWS Data Transfer",
        "serviceCode": "aWSDataTransfer",
        "description": "The cost of transferring data at AWS for services without unique transfer costs.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-1-wl1-nrt1",
            "ap-northeast-2",
            "ap-northeast-2-wl1-cjj1",
            "ap-northeast-2-wl1-sel1",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "ca-central-1-wl1-yto1",
            "cloudfront",
            "me-south-1",
            "me-central-1",
            "eu-central-1",
            "eu-central-1-wl1-dtm1",
            "eu-central-1-wl1-ber1",
            "eu-central-1-wl1-muc1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-2-wl1-lon1",
            "eu-west-3",
            "sa-east-1",
            "us-east-1",
            "us-east-1-atl-1",
            "us-east-1-bos-1",
            "us-east-1-chi-1",
            "us-east-1-dfw-1",
            "us-west-2-den-1",
            "us-east-1-iah-1",
            "us-east-1-mci-1",
            "us-east-1-mia-1",
            "us-east-1-msp-1",
            "us-east-1-nyc-1",
            "us-east-1-phl-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2",
            "us-west-2-las-1",
            "us-west-2-lax-1",
            "us-west-2-phx-1",
            "us-west-2-pdx-1",
            "us-west-2-sea-1",
            "us-west-2-wl1",
            "us-west-2-wl1-las1",
            "us-east-1-wl1",
            "us-east-1-wl1-atl1",
            "us-east-1-wl1-chi1",
            "us-east-1-wl1-clt1",
            "us-east-1-wl1-dfw1",
            "us-east-1-wl1-dtw1",
            "us-east-1-wl1-iah1",
            "us-east-1-wl1-mia1",
            "us-east-1-wl1-msp1",
            "us-east-1-wl1-bna1",
            "us-east-1-wl1-nyc1",
            "us-east-1-wl1-tpa1",
            "us-east-1-wl1-was1",
            "us-west-2-wl1-den1",
            "us-west-2-wl1-phx1",
            "us-west-2-wl1-lax1",
            "us-west-2-wl1-sea1"
        ],
        "linkUrl": "https://aws.amazon.com/ec2/pricing/on-demand/#Data_Transfer",
        "isActive": "true",
        "hasDataTransfer": true,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/aWSDataTransfer/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/aWSDataTransfer/en_US.json",
        "slug": "DataTransfer",
        "mvpSupport": false,
        "comparableTerms": [
            "datatransfer"
        ]
    },
    "awsDatabaseMigrationService": {
        "name": "AWS Database Migration Service",
        "serviceCode": "awsDatabaseMigrationService",
        "description": "AWS Database Migration Service helps you migrate databases to AWS quickly and securely. There are two options to choose from: On-Demand Instances and Serverless.",
        "searchKeywords": [
            "Database",
            "Aurora",
            "MySQL",
            "MariaDB",
            "Postgres",
            "Oracle",
            "SQL Server",
            "PostgreSQL",
            "Microsoft SQL Server",
            "Migration",
            "microsoft",
            "sql",
            "msft",
            "DMS",
            "SCT",
            "DB",
            "MS",
            "win"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/dms/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsDatabaseMigrationService/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsDatabaseMigrationService/en_US.json",
        "slug": "DMS",
        "mvpSupport": false,
        "comparableTerms": [
            "databasemigration",
            "databasemigrationservice",
            "dms"
        ]
    },
    "aWSDataSync": {
        "name": "AWS DataSync",
        "serviceCode": "aWSDataSync",
        "description": "AWS DataSync is an online data transfer service that simplifies, automates, and accelerates moving data between on-premises storage systems and AWS Storage services, as well as between AWS Storage services.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ap-northeast-3",
            "us-gov-east-1",
            "us-gov-west-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/datasync/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/aWSDataSync/en_US.json",
        "c2e": false,
        "slug": "DataSync",
        "mvpSupport": false,
        "comparableTerms": [
            "datasync"
        ]
    },
    "awsDeepRacer": {
        "name": "AWS DeepRacer",
        "serviceCode": "awsDeepRacer",
        "description": "With AWS DeepRacer, you can create your own machine learning models (in a process called 'training') and race them (in a process called 'evaluation'). You pay for training, evaluating and storing your machine learning models. Charges are based on the amount of time you train and evaluate a new model and the size of the model stored. Additionally, you can purchase a fully autonomous 1/18th scale DeepRacer car, which will allow you to try your models out on real tracks. No purchase is necessary to enter the DeepRacer League.",
        "searchKeywords": [
            "deepracer",
            "machine learning",
            "model training",
            "model evaluation",
            "ml"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/deepracer/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsDeepRacer/en_US.json",
        "c2e": false,
        "slug": "DeepRacer",
        "mvpSupport": false,
        "comparableTerms": [
            "deepracer"
        ]
    },
    "awsDeviceFarm": {
        "name": "AWS Device Farm",
        "serviceCode": "awsDeviceFarm",
        "description": "AWS Device Farm is an application testing service that lets you improve the quality of your web and mobile apps by testing them across an extensive range of desktop browsers and real mobile devices; without having to provision and manage any testing infrastructure. The service enables you to run your tests concurrently on multiple desktop browsers or real devices to speed up the execution of your test suite, and generates videos and logs to help you quickly identify issues with your app.",
        "searchKeywords": [
            "application testing",
            "mobile devices",
            "desktop browsers",
            "device farm",
            "automated testing",
            "remote access",
            "iOS",
            "Android",
            "unlimited testing",
            "pay as you go",
            "device minutes",
            "device slots",
            "free device minutes",
            "browser instances"
        ],
        "type": "AWSService",
        "regions": [
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/device-farm/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsDeviceFarm/en_US.json",
        "c2e": false,
        "slug": "DeviceFarm",
        "mvpSupport": false,
        "comparableTerms": [
            "devicefarm"
        ]
    },
    "awsDirectConnect": {
        "name": "AWS Direct Connect",
        "serviceCode": "awsDirectConnect",
        "description": "AWS Direct Connect is a cloud service solution that makes it easy to establish a dedicated network connection from your premises to AWS.",
        "searchKeywords": [
            "Direct Connect",
            "Data Transfer"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/directconnect/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsDirectConnect/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsDirectConnect/en_US.json",
        "slug": "DirectConnect",
        "mvpSupport": false,
        "comparableTerms": [
            "directconnect"
        ]
    },
    "aWSDirectoryService": {
        "name": "AWS Directory Service",
        "serviceCode": "aWSDirectoryService",
        "description": "AWS Directory Service is a managed service offering, providing directories that contain information about your organization, including users, groups, computers, and other resources.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-south-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/directoryservice/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/aWSDirectoryService/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/aWSDirectoryService/en_US.json",
        "slug": "DirectoryService",
        "mvpSupport": false,
        "comparableTerms": [
            "directory",
            "directoryservice"
        ]
    },
    "awsDrsDrill": {
        "name": "AWS DRS - Drill/Recovery",
        "serviceCode": "awsDrsDrill",
        "description": "AWS Elastic Disaster Recovery (AWS DRS) minimizes downtime and data loss with fast, reliable recovery of on-premises and cloud-based applications using affordable storage, minimal compute, and point-in-time recovery.",
        "searchKeywords": [
            "disaster recovery",
            "replicate",
            "elastic recovery",
            "point in time",
            "recovery",
            "on-premises recovery",
            "cloud-based",
            "affordable storage"
        ],
        "type": "AWSService",
        "regions": [
            "eu-west-1",
            "ap-northeast-1",
            "us-east-2",
            "us-west-2",
            "us-east-1",
            "ap-southeast-2",
            "eu-west-2",
            "eu-central-1",
            "ap-southeast-1"
        ],
        "linkUrl": "https://aws.amazon.com/disaster-recovery/pricing",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsDrsDrill/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsDrsDrill/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "drsdrill",
            "drsdrillrecovery"
        ],
        "parentServiceCode": "awsElasticDisasterRecovery"
    },
    "awsDrsRecoveryReplication": {
        "name": "AWS DRS - Replication",
        "serviceCode": "awsDrsRecoveryReplication",
        "description": "AWS Elastic Disaster Recovery (AWS DRS) minimizes downtime and data loss with fast, reliable recovery of on-premises and cloud-based applications using affordable storage, minimal compute, and point-in-time recovery.",
        "searchKeywords": [
            "disaster recovery",
            "replicate",
            "elastic recovery",
            "point in time",
            "recovery",
            "on-premises recovery",
            "cloud-based",
            "affordable storage"
        ],
        "type": "AWSService",
        "regions": [
            "eu-west-1",
            "ap-northeast-1",
            "us-east-2",
            "us-west-2",
            "us-east-1",
            "ap-southeast-2",
            "eu-west-2",
            "eu-central-1",
            "ap-southeast-1"
        ],
        "linkUrl": "https://aws.amazon.com/disaster-recovery/pricing",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsDrsRecoveryReplication/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsDrsRecoveryReplication/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "drsrecoveryreplication",
            "drsreplication"
        ],
        "parentServiceCode": "awsElasticDisasterRecovery"
    },
    "awsElasticDisasterRecovery": {
        "name": "AWS Elastic Disaster Recovery",
        "serviceCode": "awsElasticDisasterRecovery",
        "description": "AWS Elastic Disaster Recovery (AWS DRS) minimizes downtime and data loss with fast, reliable recovery of on-premises and cloud-based applications using affordable storage, minimal compute, and point-in-time recovery.",
        "searchKeywords": [
            "disaster recovery",
            "replicate",
            "elastic recovery",
            "point in time",
            "recovery",
            "on-premises recovery",
            "cloud-based",
            "affordable storage"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/disaster-recovery/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsElasticDisasterRecovery/en_US.json",
        "c2e": false,
        "templates": [
            "awsDrsRecoveryReplication",
            "awsDrsDrill"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsElasticDisasterRecovery/en_US.json",
        "slug": "ElasticDisasterRecovery",
        "mvpSupport": false,
        "comparableTerms": [
            "disasterrecovery",
            "elasticdisasterrecovery"
        ]
    },
    "awsElementalMediaTailor": {
        "name": "AWS Elemental Media Tailor",
        "serviceCode": "awsElementalMediaTailor",
        "description": "AWS Elemental MediaTailor is a channel assembly and personalized ad insertion service for video providers to create linear OTT (internet delivered) channels using existing video content and monetize those channels, or other live streams and VOD content, with personalized advertising.",
        "searchKeywords": [
            "elemental",
            "tailor",
            "mediatailor"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "us-east-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/mediatailor/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsElementalMediaTailor/en_US.json",
        "c2e": false,
        "slug": "ElementalMediaTailor",
        "mvpSupport": false,
        "comparableTerms": [
            "elementalmediatailor",
            "mediatailor"
        ]
    },
    "awsElementalMediaConnect": {
        "name": "AWS Elemental MediaConnect",
        "serviceCode": "awsElementalMediaConnect",
        "description": "AWS Elemental MediaConnect is a high-quality transport service for live video.",
        "searchKeywords": [
            "transport",
            "video",
            "broadcast",
            "live",
            "flows",
            "JPEG XS",
            "CDI"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/mediaconnect/",
        "isActive": "true",
        "hasDataTransfer": true,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsElementalMediaConnect/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "ElementalMediaConnect",
        "mvpSupport": false,
        "comparableTerms": [
            "elementalmediaconnect",
            "mediaconnect"
        ]
    },
    "elementalMediaConvert": {
        "name": "AWS Elemental MediaConvert",
        "serviceCode": "elementalMediaConvert",
        "description": "AWS Elemental MediaConvert is a file-based video transcoding service with broadcast-grade features. It allows you to easily create video-on-demand (VOD) content for broadcast and multiscreen delivery at scale.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "sa-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/mediaconvert/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/elementalMediaConvert/en_US.json",
        "c2e": false,
        "mvpSupport": false,
        "comparableTerms": [
            "elementalmediaconvert",
            "mediaconvert"
        ]
    },
    "awsElementalMediaLive": {
        "name": "AWS Elemental MediaLive",
        "serviceCode": "awsElementalMediaLive",
        "description": "AWS Elemental MediaLive is a broadcast-grade live video processing service. It lets you create high-quality video streams for delivery to broadcast televisions and internet-connected multiscreen devices, like connected TVs, tablets, smart phones, and set-top boxes.",
        "searchKeywords": [
            "media",
            "video processing",
            "broadcast",
            "TV",
            "video streams",
            "channels"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/medialive/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsElementalMediaLive/en_US.json",
        "c2e": false,
        "templates": [
            "mediaLiveInput1",
            "mediaLiveOutput1",
            "mediaLiveAudioAddOns"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsElementalMediaLive/en_US.json",
        "slug": "ElementalMediaLive",
        "mvpSupport": false,
        "comparableTerms": [
            "elementalmedialive",
            "medialive"
        ]
    },
    "awsElementalMediaPackage": {
        "name": "AWS Elemental MediaPackage",
        "serviceCode": "awsElementalMediaPackage",
        "description": "AWS Elemental MediaPackage reliably prepares and protects your video for delivery over the Internet. From a single video input, AWS Elemental MediaPackage creates video streams formatted to play on connected TVs, mobile phones, computers, tablets, and game consoles.",
        "searchKeywords": [
            "media",
            "video processing",
            "broadcast",
            "TV",
            "video streams",
            "channels"
        ],
        "type": "AWSService",
        "regions": [
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/mediapackage/",
        "isActive": "true",
        "hasDataTransfer": true,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsElementalMediaPackage/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "ElementalMediaPackage",
        "mvpSupport": false,
        "comparableTerms": [
            "elementalmediapackage",
            "mediapackage"
        ]
    },
    "awsEntityResolution": {
        "name": "AWS Entity Resolution",
        "serviceCode": "awsEntityResolution",
        "description": "AWS Entity Resolution helps you match and link related records without the need to build custom solutions. Use flexible, configurable machine learning (ML) and rule-based techniques to optimize record matching based on your business needs.",
        "searchKeywords": [
            "Entity Resolution"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/entity-resolution/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsEntityResolution/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsEntityResolution/en_US.json",
        "slug": "EntityResolution",
        "mvpSupport": false,
        "comparableTerms": [
            "entityresolution"
        ]
    },
    "awsFargate": {
        "name": "AWS Fargate",
        "serviceCode": "awsFargate",
        "description": "AWS Fargate is a serverless compute engine for containers that works with both Amazon Elastic Container Service (ECS) and Amazon Elastic Kubernetes Service (EKS). Fargate makes it easy for you to focus on building your applications. Fargate removes the need to provision and manage servers, lets you specify and pay for resources per application, and improves security through application isolation by design.",
        "searchKeywords": [
            "serverless",
            "compute",
            "engine",
            "ECS",
            "EKS",
            "container",
            "Kubernetes"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/fargate/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsFargate/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsFargate/en_US.json",
        "slug": "Fargate",
        "mvpSupport": false,
        "comparableTerms": [
            "fargate"
        ]
    },
    "awsFaultINjectorSimulator": {
        "name": "AWS Fault Injector Simulator",
        "serviceCode": "awsFaultINjectorSimulator",
        "description": "AWS Fault Injection Simulator (FIS) is a fully managed service for running fault injection experiments to improve an application’s performance, observability, and resiliency. FIS simplifies the process of setting up and running controlled fault injection experiments across a range of AWS services, so teams can build confidence in their application behavior.",
        "searchKeywords": [
            "fault injector",
            "aws fault",
            "fault injector simulator",
            "stress test"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/fis/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsFaultINjectorSimulator/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsFaultINjectorSimulator/en_US.json",
        "slug": "faultinjectorsimulator",
        "mvpSupport": false,
        "comparableTerms": [
            "faultinjectorsimulator",
            "fis"
        ]
    },
    "awsFirewallManager": {
        "name": "AWS Firewall Manager",
        "serviceCode": "awsFirewallManager",
        "description": "AWS Firewall Manager is a security management service that allows you to centrally configure and manage firewall rules across your accounts and applications in AWS Organizations. As new applications are created, Firewall Manager makes it easier to bring new applications and resources into compliance by enforcing a common set of security rules.",
        "searchKeywords": [
            "firewall",
            "manager",
            "config",
            "WAF",
            "network",
            "VPC",
            "route53",
            "shield",
            "fms"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/firewall-manager/pricing/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsFirewallManager/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsFirewallManager/en_US.json",
        "slug": "firewallManager",
        "mvpSupport": false,
        "comparableTerms": [
            "firewallmanager",
            "firewallmanagerpricing"
        ]
    },
    "awsGlue": {
        "name": "AWS Glue",
        "serviceCode": "awsGlue",
        "description": "AWS Glue is a serverless data preparation service that makes it easy for data engineers, extract, transform, and load (ETL) developers, data analysts, and data scientists to extract, clean, enrich, normalize, and load data. AWS Glue reduces the time it takes to start analyzing your data from months to minutes.",
        "searchKeywords": [
            "etl",
            "AWS glue data catalog",
            "glue",
            "crawlers",
            "development endpoints",
            "databrew"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/glue/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsGlue/en_US.json",
        "c2e": false,
        "templates": [
            "awsEtlJobsAndDevelopmentEndpoints",
            "awsEtlJobsFlexExecutionOption",
            "awsGlueEtlForRayJobsAndInteractiveSessions",
            "awsGlueDataCatalogStorageRequests",
            "awsGlueDataBrewInteractiveSessions",
            "awsGlueCrawlers"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsGlue/en_US.json",
        "slug": "Glue",
        "mvpSupport": false,
        "comparableTerms": [
            "glue"
        ]
    },
    "awsGlueCrawlers": {
        "name": "AWS Glue Crawlers",
        "serviceCode": "awsGlueCrawlers",
        "description": "",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsGlueCrawlers/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsGlueCrawlers/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "gluecrawlers"
        ],
        "parentServiceCode": "awsGlue"
    },
    "awsGlueDataCatalogStorageRequests": {
        "name": "AWS Glue Data Catalog storage requests",
        "serviceCode": "awsGlueDataCatalogStorageRequests",
        "description": "",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsGlueDataCatalogStorageRequests/en_US.json",
        "c2e": false,
        "mvpSupport": false,
        "comparableTerms": [
            "gluedatacatalogstoragerequests"
        ],
        "parentServiceCode": "awsGlue"
    },
    "awsGlueDataBrewInteractiveSessions": {
        "name": "AWS Glue DataBrew interactive sessions",
        "serviceCode": "awsGlueDataBrewInteractiveSessions",
        "description": "",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsGlueDataBrewInteractiveSessions/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsGlueDataBrewInteractiveSessions/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "gluedatabrewinteractivesessions"
        ],
        "parentServiceCode": "awsGlue"
    },
    "awsGlueEtlForRayJobsAndInteractiveSessions": {
        "name": "AWS Glue ETL for Ray jobs and interactive sessions",
        "serviceCode": "awsGlueEtlForRayJobsAndInteractiveSessions",
        "description": "",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-east-1"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsGlueEtlForRayJobsAndInteractiveSessions/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsGlueEtlForRayJobsAndInteractiveSessions/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "glueetlforrayjobsandinteractivesessions",
            "glueetlrayjobsinteractivesessions"
        ],
        "parentServiceCode": "awsGlue"
    },
    "awsEtlJobsAndDevelopmentEndpoints": {
        "name": "AWS Glue ETL jobs and interactive sessions",
        "serviceCode": "awsEtlJobsAndDevelopmentEndpoints",
        "description": "",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsEtlJobsAndDevelopmentEndpoints/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/awsEtlJobsAndDevelopmentEndpoints/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "etljobsanddevelopmentendpoints",
            "glueetljobsinteractivesessions"
        ],
        "parentServiceCode": "awsGlue"
    },
    "awsEtlJobsFlexExecutionOption": {
        "name": "AWS Glue ETL jobs with Flex execution option",
        "serviceCode": "awsEtlJobsFlexExecutionOption",
        "description": "",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsEtlJobsFlexExecutionOption/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "mvpSupport": false,
        "comparableTerms": [
            "etljobsflexexecutionoption",
            "glueetljobswithflexexecutionoption"
        ],
        "parentServiceCode": "awsGlue"
    },
    "amazonHealthImaging": {
        "name": "AWS HealthImaging",
        "serviceCode": "amazonHealthImaging",
        "description": "AWS HealthImaging is a HIPAA-eligible service that empowers healthcare providers and their software partners to store, analyze, and share medical images at petabyte scale.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/healthimaging/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonHealthImaging/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonHealthImaging/en_US.json",
        "slug": "healthimaging",
        "mvpSupport": false,
        "comparableTerms": [
            "healthimaging"
        ]
    },
    "awsIoTAnalytics": {
        "name": "AWS IoT Analytics",
        "serviceCode": "awsIoTAnalytics",
        "description": "AWS IoT Analytics is a fully-managed IoT analytics service that collects, pre-processes, enriches, stores, and analyzes IoT device data at scale.",
        "searchKeywords": [
            "AWS IoT Analytics",
            "iot analytics",
            "analytics"
        ],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1",
            "ap-south-1",
            "ap-southeast-2",
            "eu-central-1",
            "eu-west-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/iot-analytics/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsIoTAnalytics/en_US.json",
        "c2e": false,
        "slug": "iot-analytics",
        "mvpSupport": false,
        "comparableTerms": [
            "iotanalytics"
        ]
    },
    "awsIoTCore": {
        "name": "AWS IoT Core",
        "serviceCode": "awsIoTCore",
        "description": "AWS IoT Core is a managed cloud service that lets connected devices easily and securely interact with cloud applications and other devices.",
        "searchKeywords": [
            "iot",
            "device",
            "messages",
            "shadow",
            "registry",
            "rules",
            "device shadow",
            "rules engine",
            "basic ingest",
            "mqtt",
            "LoRaWAN"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/iot-core/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsIoTCore/en_US.json",
        "c2e": false,
        "templates": [
            "awsIoTCoreMqtt",
            "awsIoTCoreHttp",
            "awsIoTCoreLoRaWan"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsIoTCore/en_US.json",
        "slug": "IoTCore",
        "mvpSupport": false,
        "comparableTerms": [
            "iotcore"
        ]
    },
    "awsIoTDeviceDefender": {
        "name": "AWS IoT Device Defender",
        "serviceCode": "awsIoTDeviceDefender",
        "description": "AWS IoT Device Defender is a fully managed service that helps you secure your fleet of IoT devices.",
        "searchKeywords": [
            "device",
            "iot",
            "iot device defender",
            "defender",
            "audit",
            "detect",
            "metric",
            "fleet"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/iot-device-defender/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsIoTDeviceDefender/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsIoTDeviceDefender/en_US.json",
        "slug": "IoTDeviceDefender",
        "mvpSupport": false,
        "comparableTerms": [
            "iotdevicedefender"
        ]
    },
    "awsIoTDeviceManagement": {
        "name": "AWS IoT Device Management",
        "serviceCode": "awsIoTDeviceManagement",
        "description": "AWS IoT Device Management makes it easy for you to manage your fleets of connected devices at any scale.",
        "searchKeywords": [
            "device management",
            "fleet indexing",
            "index updates",
            "device query",
            "device queries",
            "jobs",
            "remote actions",
            "secure tunneling",
            "tunnels"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/iot-device-management/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsIoTDeviceManagement/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsIoTDeviceManagement/en_US.json",
        "slug": "IoTDeviceManagement",
        "mvpSupport": false,
        "comparableTerms": [
            "iotdevicemanagement"
        ]
    },
    "awsIoTEvents": {
        "name": "AWS IoT Events",
        "serviceCode": "awsIoTEvents",
        "description": "AWS IoT Events makes it easy to detect and respond to changes indicated by IoT sensors and applications – such as malfunctioning machinery, a stuck conveyor belt, or a slowdown in production output – and automatically trigger actions or alerts in response.",
        "searchKeywords": [
            "iot",
            "iot events"
        ],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-south-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/iot-events/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsIoTEvents/en_US.json",
        "c2e": false,
        "slug": "iot-events",
        "mvpSupport": false,
        "comparableTerms": [
            "iotevents"
        ]
    },
    "awsIoTFleetWise": {
        "name": "AWS IoT FleetWise",
        "serviceCode": "awsIoTFleetWise",
        "description": "AWS IoT FleetWise makes it easier for you to collect, transform, and transfer vehicle data to the cloud in near real time and use that data to improve vehicle quality, safety, and autonomy.",
        "searchKeywords": [
            "iot",
            "device",
            "fleetwise",
            "iot auto"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/iot-fleetwise/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsIoTFleetWise/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsIoTFleetWise/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "iotfleetwise"
        ]
    },
    "awsIoTGreengrass": {
        "name": "AWS IoT Greengrass",
        "serviceCode": "awsIoTGreengrass",
        "description": "AWS IoT Greengrass is an Internet of Things (IoT) open source edge runtime and cloud service that helps you build, deploy, and manage device software. Customers use AWS IoT Greengrass for their IoT applications on millions of devices in homes, factories, vehicles, and businesses.",
        "searchKeywords": [
            "greengrass",
            "AWS IoT Greengrass"
        ],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/greengrass/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsIoTGreengrass/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "greengrass",
        "mvpSupport": false,
        "comparableTerms": [
            "greengrass",
            "iotgreengrass"
        ]
    },
    "awsIoTThingsGraph": {
        "name": "AWS IoT Things Graph",
        "serviceCode": "awsIoTThingsGraph",
        "description": "AWS IoT Things Graph makes it easy to rapidly build IoT applications by connecting devices and web services from different vendors that speak different protocols.",
        "searchKeywords": [
            "IoT",
            "Things",
            "graph",
            "IoT Things Graph"
        ],
        "type": "AWSService",
        "regions": [
            "ap-northeast-2",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-west-1",
            "us-east-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/iot-things-graph/",
        "isActive": "true",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsIoTThingsGraph/en_US.json",
        "c2e": false,
        "slug": "IoTThingsGraph",
        "comparableTerms": [
            "iotthingsgraph"
        ]
    },
    "awsKeyManagementService": {
        "name": "AWS Key Management Service",
        "serviceCode": "awsKeyManagementService",
        "description": "Securely Generate and Manage AWS Encryption Keys",
        "searchKeywords": [
            "KMS",
            "Key Management System"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/kms/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsKeyManagementService/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "KMS",
        "mvpSupport": false,
        "comparableTerms": [
            "keymanagement",
            "keymanagementservice",
            "kms"
        ]
    },
    "awsLakeFormation": {
        "name": "AWS Lake Formation",
        "serviceCode": "awsLakeFormation",
        "description": "AWS Lake Formation provides database, table, column and tag-based access controls, and cross-account sharing at no charge. Governed Tables provide ACID transactions as a fully managed service that enable you to reliably update multiple tables, while maintaining a consistent view for all users. Managing concurrent transactions and being able to travel back to previous version of the table requires storing metadata about each transaction. Lake Formation charges a fee for transaction requests and for metadata storage. In addition, to providing a consistent view of data and enforce row and cell-level security the Lake Formation Storage API scans data in Amazon S3 and applies row and cell filters before returning results to applications. There is a fee for this filtering.",
        "searchKeywords": [
            "Lake Formation",
            "LF",
            "If",
            "Formation",
            "lakeformation",
            "Lake"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "eu-west-1",
            "eu-west-2",
            "eu-central-1",
            "eu-north-1",
            "ca-central-1"
        ],
        "linkUrl": "https://aws.amazon.com/lake-formation/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsLakeFormation/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsLakeFormation/en_US.json",
        "slug": "LakeFormation",
        "mvpSupport": false,
        "comparableTerms": [
            "lakeformation"
        ]
    },
    "aWSLambda": {
        "name": "AWS Lambda",
        "serviceCode": "aWSLambda",
        "description": "AWS Lambda lets you run code without provisioning or managing servers. You pay only for the compute time you consume - there is no charge when your code is not running.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/lambda/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/aWSLambda/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/aWSLambda/en_US.json",
        "slug": "Lambda",
        "mvpSupport": false,
        "comparableTerms": [
            "lambda"
        ]
    },
    "amazonMainframeModernization": {
        "name": "AWS Mainframe Modernization",
        "serviceCode": "amazonMainframeModernization",
        "description": "AWS Mainframe Modernization (Preview) is a set of managed tools providing infrastructure and software for migrating, modernizing, and executing mainframe applications.",
        "searchKeywords": [
            "Blu Age",
            "Micro",
            "Mainframe",
            "m2",
            "instance",
            "modernization"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/mainframe-modernization/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonMainframeModernization/en_US.json",
        "c2e": false,
        "templates": [
            "mainframeBluAge",
            "mainframeMicroFocus"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonMainframeModernization/en_US.json",
        "slug": "mainframeModernization",
        "mvpSupport": false,
        "comparableTerms": [
            "mainframemodernization"
        ]
    },
    "migrationHubRefactorSpaces": {
        "name": "AWS Migration Hub Refactor Spaces",
        "serviceCode": "migrationHubRefactorSpaces",
        "description": "AWS Migration Hub Refactor Spaces is the starting point for incremental application refactoring to microservices. Refactor Spaces eliminates the undifferentiated work of building and operating AWS infrastructure for incremental refactoring. You can use Refactor Spaces to reduce the risk of evolving applications into microservices or extending existing applications with new features written in microservices.",
        "searchKeywords": [
            "Migration Hub",
            "cloud migration",
            "IT asset",
            "inventory data",
            "Refactor Spaces"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-north-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/migration-hub/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/migrationHubRefactorSpaces/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "slug": "migration-hub",
        "mvpSupport": false,
        "comparableTerms": [
            "migrationhub",
            "migrationhubrefactorspaces"
        ]
    },
    "modularDataCenter": {
        "name": "AWS Modular Data Center (MDC)",
        "serviceCode": "modularDataCenter",
        "description": "AWS Modular Data Center (MDC) is a service that makes it simple and cost-effective for defense and intelligence agencies to deploy AWS managed data centers anywhere in the world to run low latency applications. AWS MDC is available as a self-contained modular data center—a physical, environmentally-controlled enclosure that holds up to five racks of AWS Outposts or AWS Snowball Edge devices, and can scale further through deployment of additional modules. AWS MDC reduces the time and resources it takes for customers to deploy data centers in remote environments with limited infrastructure. Customers can proactively monitor and manage their modular data centers using a management system that comes with every MDC. Each modular data center is equipped with Building Management System (BMS) sensors to monitor the environmental conditions of the MDC including temperature, humidity, ventilation, HVAC performance, and power quality. The BMS also monitors the life safety systems, such as smoke detection, fire alarm, and the Access Control (ACS) / Intrusion Detection System (IDS).",
        "searchKeywords": [
            "Modular Data Center"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1"
        ],
        "isActive": "true",
        "hasDataTransfer": false,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/modularDataCenter/en_US.json",
        "c2e": true,
        "templates": [],
        "disableRegionSupport": true,
        "serviceDefinitionUrlPath": "/data/modularDataCenter/en_US.json",
        "slug": "MDC",
        "mvpSupport": true,
        "comparableTerms": [
            "mdc",
            "modulardatacenter",
            "modulardatacentermdc"
        ]
    },
    "amazonNetworkFirewall": {
        "name": "AWS Network Firewall",
        "serviceCode": "amazonNetworkFirewall",
        "description": "AWS Network Firewall is a managed service that makes it easy to deploy essential network protections for all of your Amazon Virtual Private Clouds (VPCs). The service can be setup with just a few clicks and scales automatically with your network traffic, so you don't have to worry about deploying and managing any infrastructure.",
        "searchKeywords": [
            "amazonNetworkFirewall",
            "AWS Network Firewall"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "sa-east-1",
            "af-south-1"
        ],
        "linkUrl": "https://aws.amazon.com/network-firewall/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonNetworkFirewall/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonNetworkFirewall/en_US.json",
        "slug": "networkfirewall",
        "mvpSupport": false,
        "comparableTerms": [
            "networkfirewall"
        ]
    },
    "awsOutposts": {
        "name": "AWS Outposts",
        "serviceCode": "awsOutposts",
        "description": "AWS Outposts is a fully managed service that offers the same AWS infrastructure, AWS services, APIs, and tools to virtually any datacenter, co-location space, or on-premises facility for a truly consistent hybrid experience. AWS Outposts is ideal for workloads that require low latency access to on-premises systems, local data processing, data residency, and migration of applications with local system interdependencies.",
        "searchKeywords": [
            "Outposts",
            "AWS infrastructure",
            "AWS services",
            "API",
            "datacenter",
            "on-premises facility",
            "hybrid",
            "compute",
            "storage",
            "database",
            "EC2",
            "EBS",
            "S3"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/outposts/",
        "isActive": "true",
        "hasDataTransfer": false,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsOutposts/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": true,
        "serviceDefinitionUrlPath": "/data/awsOutposts/en_US.json",
        "slug": "Outposts",
        "mvpSupport": false,
        "comparableTerms": [
            "outposts"
        ]
    },
    "awsPaymentCryptography": {
        "name": "AWS Payment Cryptography",
        "serviceCode": "awsPaymentCryptography",
        "description": "Create and host payment processing applications using cloud-native payments cryptography and key exchange.",
        "searchKeywords": [
            "AWS Payment Cryptography"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/payment-cryptography/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsPaymentCryptography/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsPaymentCryptography/en_US.json",
        "slug": "paymentcryptography",
        "mvpSupport": false,
        "comparableTerms": [
            "paymentcryptography"
        ]
    },
    "aWSPricingCalculatorStrings": {
        "name": "AWS Pricing Calculator Strings",
        "serviceCode": "aWSPricingCalculatorStrings",
        "searchKeywords": [],
        "type": "static",
        "regions": [],
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/aWSPricingCalculatorStrings/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/aWSPricingCalculatorStrings/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "pricingcalculatorstrings"
        ]
    },
    "awsCertificateManager": {
        "name": "AWS Private Certificate Authority",
        "serviceCode": "awsCertificateManager",
        "description": "AWS Private Certificate Authority is a service that lets you easily provision, manage, and deploy public and private Secure Sockets Layer/Transport Layer Security (SSL/TLS) certificates for use with AWS services and your internal connected resources.",
        "searchKeywords": [
            "PCA",
            "OCSP",
            "certificates x.509",
            "private"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/certificate-manager/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsCertificateManager/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsCertificateManager/en_US.json",
        "slug": "certificateManager",
        "mvpSupport": false,
        "comparableTerms": [
            "certificatemanager",
            "privatecertificateauthority"
        ]
    },
    "awsPrivateLinkVpc": {
        "name": "AWS PrivateLink",
        "serviceCode": "awsPrivateLinkVpc",
        "description": "WS Virtual Private Network solutions establish secure connections between your on-premises networks, remote offices, client devices, and the AWS global network. AWS VPN is comprised of two services: AWS Site-to-Site VPN and AWS Client VPN. Each service provides a highly-available, managed, and elastic cloud VPN solution to protect your network traffic.",
        "searchKeywords": [
            "access control",
            "ACL",
            "AWS Privatelink",
            "Cloud connectivity",
            "corporate network",
            "elastic IP",
            "Gateway load balancer",
            "home network VPN",
            "IPAM",
            "NAT",
            "NAT gateway",
            "Network Access Analyzer",
            "Network Address Translation",
            "Networking Content Delivery",
            "PrivateLink",
            "Reachability Analyzer",
            "security",
            "single tenant hardware",
            "static ip",
            "subnets",
            "Traffic mirroring",
            "Transit Gateway",
            "Virtual Private Cloud",
            "VPN"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-gov-west-1"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsPrivateLinkVpc/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsPrivateLinkVpc/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "privatelink",
            "privatelinkvpc"
        ],
        "parentServiceCode": "amazonVirtualPrivateCloud"
    },
    "awsProfessionalServices": {
        "name": "AWS Professional Services",
        "serviceCode": "awsProfessionalServices",
        "description": " The AWS Professional Services team provides assistance through a collection of offerings that help you achieve specific outcomes related to enterprise cloud adoption. We also deliver focused guidance through our global specialty practices, which cover a variety of solutions, technologies, and industries.",
        "searchKeywords": [
            "ProServe",
            "professional",
            "Service"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/professional-services/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsProfessionalServices/en_US.json",
        "c2e": true,
        "templates": [
            "proServeYear1Cost",
            "proServeYear2Cost",
            "proServeYear3Cost",
            "proServeYear4Cost",
            "proServeYear5Cost"
        ],
        "disableRegionSupport": true,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/awsProfessionalServices/en_US.json",
        "mvpSupport": true,
        "comparableTerms": [
            "professionalservices"
        ]
    },
    "awsResilienceHub": {
        "name": "AWS Resilience Hub",
        "serviceCode": "awsResilienceHub",
        "description": "Prepare and protect your applications from disruptions. With AWS Resilience Hub, you pay only for what you use. There are no upfront costs or minimum fees. You are charged based on the number of applications you described in AWS Resilience Hub.",
        "searchKeywords": [
            "AWS Resilience Hub"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/resilience-hub",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsResilienceHub/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsResilienceHub/en_US.json",
        "slug": "resiliencehub",
        "mvpSupport": false,
        "comparableTerms": [
            "resiliencehub"
        ]
    },
    "awsSecretsManager": {
        "name": "AWS Secrets Manager",
        "serviceCode": "awsSecretsManager",
        "description": "AWS Secrets Manager enables you to rotate, manage, and retrieve secrets throughout their lifecycle, making it easier to maintain a secure environment that meets your security and compliance needs. With Secrets Manager, you pay based on the number of secrets stored and API calls made.",
        "searchKeywords": [
            "Secrets",
            "Secrets Manager"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/secrets-manager/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsSecretsManager/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsSecretsManager/en_US.json",
        "slug": "SecretsManager",
        "mvpSupport": false,
        "comparableTerms": [
            "secretsmanager"
        ]
    },
    "awsSecurityHub": {
        "name": "AWS Security Hub",
        "serviceCode": "awsSecurityHub",
        "description": "AWS Security Hub performs security best practice checks and ingests security findings from AWS security services and partners.",
        "searchKeywords": [
            "security",
            "hub"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/security-hub/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsSecurityHub/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsSecurityHub/en_US.json",
        "slug": "securityHub",
        "mvpSupport": false,
        "comparableTerms": [
            "securityhub"
        ]
    },
    "awsServiceCatalog": {
        "name": "AWS Service Catalog",
        "serviceCode": "awsServiceCatalog",
        "description": "AWS Service Catalog lets you centrally manage deployed IT services, applications, resources, and metadata to achieve consistent governance of your infrastructure as code (IaC) templates. With AWS Service Catalog, you can meet your compliance requirements while making sure your customers can quickly deploy the approved IT services they need.",
        "searchKeywords": [
            "AWS Service Catalog"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/servicecatalog",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsServiceCatalog/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsServiceCatalog/en_US.json",
        "slug": "servicecatalog",
        "mvpSupport": false,
        "comparableTerms": [
            "servicecatalog"
        ]
    },
    "awsShield": {
        "name": "AWS Shield",
        "serviceCode": "awsShield",
        "description": "AWS Shield Advanced is a paid service that provides additional protections for internet-facing applications running on Amazon Elastic Compute Cloud (EC2), Elastic Load Balancing (ELB), Amazon CloudFront, AWS Global Accelerator, and Amazon Route 53. AWS Shield Advanced is available to all customers; however, to contact the AWS Shield Response Team customers will need the Enterprise or Business Support levels of AWS Premium Support.",
        "searchKeywords": [
            "shield",
            "DDoS"
        ],
        "type": "AWSService",
        "regions": [
            " "
        ],
        "linkUrl": "https://aws.amazon.com/shield/pricing/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsShield/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/awsShield/en_US.json",
        "slug": "shield",
        "mvpSupport": false,
        "comparableTerms": [
            "shield",
            "shieldpricing"
        ]
    },
    "simSpaceWeaver": {
        "name": "AWS SimSpace Weaver",
        "serviceCode": "simSpaceWeaver",
        "description": "AWS SimSpace Weaver is a fully managed compute service that helps customers build, operate, and oversee large-scale spatial simulations. AWS SimSpace Weaver helps developers expand their spatial simulation capabilities to new levels of scale and complexity—resulting in deeper insights and larger virtual worlds with millions of independent and interacting entities.",
        "searchKeywords": [
            "sim space weaver",
            "simspaceweaver"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/simspaceweaver/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/simSpaceWeaver/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/simSpaceWeaver/en_US.json",
        "slug": "simspaceweaver",
        "mvpSupport": false,
        "comparableTerms": [
            "simspaceweaver"
        ]
    },
    "awsSnowball": {
        "name": "AWS Snowball",
        "serviceCode": "awsSnowball",
        "description": "AWS Snowball, a part of the AWS Snow Family, is an edge computing, data migration, and edge storage device that comes in two options. Snowball Edge Storage Optimized devices provide both block storage and Amazon S3-compatible object storage, and 40 vCPUs. They are well suited for local storage and large scale-data transfer. Snowball Edge Compute Optimized devices provide up to 104 vCPUs, block and object storage, and an optional GPU for use cases like advanced machine learning and full motion video analysis in disconnected environments.",
        "searchKeywords": [
            "Snow",
            "Snowball",
            "Snowball Edge",
            "Disconnected Data Transfer",
            "Edge Computing",
            "Data Export"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/snowball/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsSnowball/en_US.json",
        "c2e": false,
        "templates": [
            "snowballEdgeComputeOptimizedWithEc2ComputeInstances",
            "snowballEdgeComputeOptimizedGpuWithEc2ComputeInstances",
            "snowballEdgeStorageOptimizedWithEc2ComputeInstances",
            "snowballEdgeStorageOptimizedDataTransferOnly"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsSnowball/en_US.json",
        "slug": "Snowball",
        "mvpSupport": false,
        "comparableTerms": [
            "snowball"
        ]
    },
    "awsSnowmobile": {
        "name": "AWS Snowmobile",
        "serviceCode": "awsSnowmobile",
        "description": "AWS Snowmobile is an Exabyte-scale data transfer service used to move extremely large amounts of data to AWS. You can transfer up to 100PB per Snowmobile, a 45-foot long ruggedized shipping container, pulled by a semi-trailer truck. Snowmobile makes it easy to move massive volumes of data to the cloud, including video libraries, image repositories, or even a complete data center migration. Transferring data with Snowmobile is more secure, fast and cost effective.",
        "searchKeywords": [
            "Snowmobile",
            "data transfer",
            "video libraries",
            "image repositories",
            "data center migration",
            "truck",
            "shipping container"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/snowmobile/",
        "isActive": "true",
        "hasDataTransfer": false,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsSnowmobile/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": true,
        "serviceDefinitionUrlPath": "/data/awsSnowmobile/en_US.json",
        "slug": "Snowmobile",
        "mvpSupport": false,
        "comparableTerms": [
            "snowmobile"
        ]
    },
    "awsStepFunctions": {
        "name": "AWS Step Functions",
        "serviceCode": "awsStepFunctions",
        "description": "AWS Step Functions is a serverless function orchestrator that makes it easy to sequence AWS Lambda functions and multiple AWS services into business-critical applications.",
        "searchKeywords": [
            "workflows",
            " workflow",
            " orchestrator",
            " orchestration",
            " serverless",
            " state machine",
            " State Machines",
            " States",
            " State",
            " Microservices",
            " application integration",
            " Amazon States Language",
            " ASL",
            " Data Science SDK",
            " data processing",
            " API orchestration",
            " DAG",
            " DAGs",
            " Step Functions",
            " Step Function",
            " Step",
            " media processing",
            " application orchestration",
            " serverless orchestration",
            " serverless workflow",
            " lambda orchestration",
            " serverless state machine",
            " asynchronous",
            " synchronous",
            " event-driven data processing",
            " event-driven",
            " event orchestration",
            " standard workflows",
            " standard workflow",
            " express workflow",
            " express workflows",
            " standard workflows",
            " error handling",
            " service integrations",
            " state management",
            " visual workflow",
            " visual monitoring",
            " high volume orchestration",
            " function",
            " functions",
            " machine learning workflow",
            " machine learning workflows",
            " JSON",
            " serverless workflows",
            " serverless workflow",
            " Business logic",
            " complex workflows",
            " data pipeline",
            " data processing",
            " decoupling",
            " decouple applications",
            " abstraction",
            " abstraction layer",
            " automation",
            " It automation",
            " connecting aws services",
            " integration of aws services",
            " coordinating AWS services",
            " managed workflows",
            " call back patterns",
            " callback pattern",
            " callback patterns",
            " call back pattern",
            " human approval",
            " manual approval",
            " human intervention",
            " EKS orchestration",
            " container orchestration",
            " short duration workflows",
            " long duration workflows",
            " short-duration workflows",
            " short-duration workflow",
            " long-running workflow",
            " long-running workflows",
            " machine-learning workflows",
            " ML workflows",
            " ML workflow",
            " API orchestration",
            " function",
            " functions",
            " compute function",
            " compute functions",
            " Lambda retry",
            " Lambda retries",
            " serverless compute",
            " parallel processing",
            " Lambda chaining",
            " error-handling",
            " retries",
            " saga pattern",
            " nested",
            " branching",
            " nesting",
            " nested pattern",
            " branching pattern",
            " nesting pattern",
            " serverless patterns",
            " event-driven patterns",
            " coordinating workflows"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/step-functions/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsStepFunctions/en_US.json",
        "c2e": false,
        "templates": [
            "stepFunctionStandard",
            "stepFunctionExpress"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsStepFunctions/en_US.json",
        "slug": "StepFunctions",
        "mvpSupport": false,
        "comparableTerms": [
            "stepfunctions"
        ]
    },
    "aWSStorageGateway": {
        "name": "AWS Storage Gateway",
        "serviceCode": "aWSStorageGateway",
        "description": "AWS Storage Gateway is a hybrid storage service that enables your on-premises applications to seamlessly use AWS cloud storage. You can use the service for backup and archiving, disaster recovery, cloud data processing, storage tiering, and migration.",
        "searchKeywords": [
            "Storage",
            "on premises",
            "cloud migration",
            "integrated storage",
            "store data in the cloud",
            "secure storage",
            "storage integration",
            "hybrid storage",
            "on prem storage",
            "gateway cached volumes",
            "gateway stored volumes",
            "gateway virtual tape library",
            "VTL",
            "backup",
            "disaster recovery",
            "disaster resilience",
            "corporate file sharing",
            "data mirroring",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            ""
        ],
        "linkUrl": "https://aws.amazon.com/storagegateway/",
        "isActive": "true",
        "hasDataTransfer": true,
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/aWSStorageGateway/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/aWSStorageGateway/en_US.json",
        "slug": "StorageGateway",
        "mvpSupport": false,
        "comparableTerms": [
            "storagegateway"
        ]
    },
    "awsSupplyChain": {
        "name": "AWS Supply Chain",
        "serviceCode": "awsSupplyChain",
        "description": "AWS Supply Chain is a cloud application that unifies data and provides machine learning (ML)–powered actionable insights, built-in contextual collaboration, and demand planning. AWS Supply Chain connects to your existing enterprise resource planning (ERP) and supply chain management systems, without replatforming, up-front licensing fees, or long-term contracts.",
        "searchKeywords": [
            "supply chain",
            "insights",
            "supply chain insights",
            "demand planning"
        ],
        "type": "AWSService",
        "regions": [
            "eu-central-1",
            "us-west-2-pdx-1",
            "us-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/aws-supply-chain/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsSupplyChain/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsSupplyChain/en_US.json",
        "slug": "supplyChain",
        "mvpSupport": false,
        "comparableTerms": [
            "supplychain"
        ]
    },
    "awsSystemsManager": {
        "name": "AWS Systems Manager",
        "serviceCode": "awsSystemsManager",
        "description": "AWS Systems Manager gives you visibility and control of your infrastructure on AWS. Systems Manager provides a unified user interface so you can view operational data from multiple AWS services and allows you to automate operational tasks across your AWS resources.",
        "searchKeywords": [
            "Manager",
            "Systems",
            "control",
            "infrastructure",
            "operational data",
            "visibility",
            "resource management",
            "application management",
            "unified user interface",
            "OpsCenter",
            "Automation",
            "On-premesis instance management",
            "Distributor",
            "Parameter Store",
            "AWS AppConfig"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/systems-manager/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsSystemsManager/en_US.json",
        "c2e": false,
        "templates": [
            "awsSystemsManagerOpsCenter",
            "awsAppConfig",
            "awsSystemsManagerParameterStore",
            "awsSystemsManagerOnPremisesInstanceManagement",
            "awsSystemsManagerDistributor",
            "awsSystemsManagerAutomation",
            "awsSystemsManagerIncidentManager"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsSystemsManager/en_US.json",
        "slug": "SystemsManager",
        "mvpSupport": false,
        "comparableTerms": [
            "systemsmanager"
        ]
    },
    "awsTelcoNetworkBuilder": {
        "name": "AWS Telco Network Builder",
        "serviceCode": "awsTelcoNetworkBuilder",
        "description": "AWS Telco Network Builder (TNB) helps communication service providers (CSPs) automate the deployment and management of their telco networks on AWS. You pay for two dimensions when using AWS TNB: by managed network function item (MNFI) hours and by number of API requests. You also incur additional charges for the other services you use with AWS TNB.",
        "searchKeywords": [
            "API requests",
            "managed network function item",
            "MNFI",
            "AWS TNB",
            "CSPs",
            "networks",
            "telecom",
            "tnb",
            "telco"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/tnb/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsTelcoNetworkBuilder/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsTelcoNetworkBuilder/en_US.json",
        "slug": "TelcoNetworkBuilder",
        "mvpSupport": false,
        "comparableTerms": [
            "telconetworkbuilder",
            "tnb"
        ]
    },
    "aWSTransferForSFTP": {
        "name": "AWS Transfer Family",
        "serviceCode": "aWSTransferForSFTP",
        "description": "Amazon Transfer Family is a fully managed SFTP, FTPS, FTP, and AS2 service.",
        "searchKeywords": [
            "sftp",
            "FTPS",
            "as2",
            "amazon s3",
            "s3",
            "winscp",
            "filezilla",
            "cyberduck",
            "ssh",
            "transfer",
            "ftp",
            "ftp/s",
            "openssh",
            "file transfer",
            "secure file transfer",
            "ssh ftp",
            "secure shell file transfer protocol",
            "file transfer protocol"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/aws-transfer-family/",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/aWSTransferForSFTP/en_US.json",
        "c2e": false,
        "templates": [
            "as2",
            "sftp",
            "ftps",
            "ftp"
        ],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/aWSTransferForSFTP/en_US.json",
        "slug": "TransferFamily",
        "mvpSupport": false,
        "comparableTerms": [
            "transferfamily",
            "transferforsftp"
        ]
    },
    "awsWebApplicationFirewall": {
        "name": "AWS Web Application Firewall (WAF)",
        "serviceCode": "awsWebApplicationFirewall",
        "description": "AWS WAF is a web application firewall that helps protect your web applications or APIs against common web exploits that may affect availability, compromise security, or consume excessive resources.",
        "searchKeywords": [
            "Security Identity Compliance",
            "appsec",
            "application security",
            "web security",
            "blacklisting",
            "whitelisting",
            "Security as a service (SAAS)",
            "perimeter security",
            "perimeter protection",
            "bot detection",
            "DDoS",
            "firewall",
            "IP blocking",
            "OWASP",
            "IP reputation",
            "HTTP flood",
            "AWS Firewall Manager",
            "Cross Account WAF",
            "Cross Account Firewall",
            "Firewall Compliance",
            "Firewall Manager"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/waf/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsWebApplicationFirewall/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsWebApplicationFirewall/en_US.json",
        "slug": "WAF",
        "mvpSupport": false,
        "comparableTerms": [
            "waf",
            "webapplicationfirewall",
            "webapplicationfirewallwaf"
        ]
    },
    "awsWickr": {
        "name": "AWS Wickr",
        "serviceCode": "awsWickr",
        "description": "Enable secure communication with end-to-end encryption. ",
        "searchKeywords": [
            "aws wickr",
            "wickr"
        ],
        "type": "AWSService",
        "regions": [
            " "
        ],
        "linkUrl": "https://aws.amazon.com/wickr",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsWickr/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/awsWickr/en_US.json",
        "slug": "wickr",
        "mvpSupport": false,
        "comparableTerms": [
            "wickr"
        ]
    },
    "awsXRay": {
        "name": "AWS X-Ray",
        "serviceCode": "awsXRay",
        "description": "AWS X-Ray makes it easy for developers to analyze the behavior of their production, distributed applications with end-to-end tracing capabilities. You can use X-Ray to identify performance bottlenecks, edge case errors, and other hard to detect issues.",
        "searchKeywords": [
            "X-Ray",
            "xray",
            "monitor"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-2",
            "us-gov-west-1",
            "us-gov-east-1",
            "us-west-1",
            "us-west-2",
            "us-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/xray/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsXRay/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsXRay/en_US.json",
        "slug": "xray",
        "mvpSupport": false,
        "comparableTerms": [
            "xray"
        ]
    },
    "chimeSdkCallAnalyticsAndRecording": {
        "name": "Call Analytics and Recording",
        "serviceCode": "chimeSdkCallAnalyticsAndRecording",
        "description": "Amazon Chime lets you meet, chat, and collaborate with the security of AWS. You can work seamlessly on your devices, and meet from your desk or on the go - ensuring you always stay connected.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/chime/chime-sdk",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/chimeSdkCallAnalyticsAndRecording/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/chimeSdkCallAnalyticsAndRecording/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "callanalyticsrecording",
            "chimesdkcallanalyticsandrecording"
        ],
        "parentServiceCode": "amazonChimeSdk"
    },
    "chimeSdk": {
        "name": "Chime SDK",
        "serviceCode": "chimeSdk",
        "description": "Amazon Chime lets you meet, chat, and collaborate with the security of AWS. You can work seamlessly on your devices, and meet from your desk or on the go - ensuring you always stay connected.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/chime/",
        "isActive": "true",
        "subType": "subService",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/chimeSdk/en_US.json",
        "c2e": false,
        "comparableTerms": [
            "chimesdk"
        ]
    },
    "chimeVoiceConnectorAnalysis": {
        "name": "Chime Voice Connector analysis",
        "serviceCode": "chimeVoiceConnectorAnalysis",
        "description": "Amazon Chime lets you meet, chat, and collaborate with the security of AWS. You can work seamlessly on your devices, and meet from your desk or on the go - ensuring you always stay connected.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/chime/",
        "isActive": "true",
        "subType": "subService",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/chimeVoiceConnectorAnalysis/en_US.json",
        "c2e": false,
        "mvpSupport": false,
        "comparableTerms": [
            "chimevoiceconnectoranalysis"
        ]
    },
    "classicLoadBalancer": {
        "name": "Classic Load Balancer",
        "serviceCode": "classicLoadBalancer",
        "description": "Elastic Load Balancing automatically distributes incoming application traffic across multiple targets, such as Amazon EC2 instances, containers, IP addresses, and Lambda functions.",
        "searchKeywords": [
            "ELB",
            "Elastic Load Balancer",
            "Load Balancer",
            "Application Load Balancer",
            "Network Load Balancer",
            "Classic Load Balancer"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/elasticloadbalancing/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/classicLoadBalancer/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/classicLoadBalancer/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "classicloadbalancer"
        ],
        "parentServiceCode": "elasticLoadBalancing"
    },
    "cloudWan": {
        "name": "Cloud WAN",
        "serviceCode": "cloudWan",
        "description": "AWS Cloud WAN provides a central dashboard for making connections between your branch offices, data centers, and Amazon Virtual Private Clouds (VPCs) – building a global network with only a few clicks. You use network policies to automate network management and security tasks in one location. Cloud WAN generates a complete view of your on-premises and AWS networks to help you monitor network health, security, and performance.",
        "searchKeywords": [
            "Cloud WAN",
            "cloud",
            "cloudwan"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/cloudWan/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/cloudWan/en_US.json",
        "slug": "cloudwan",
        "mvpSupport": false,
        "comparableTerms": [
            "cloudwan"
        ],
        "parentServiceCode": "amazonVirtualPrivateCloud"
    },
    "comprehendCustomClassification": {
        "name": "Comprehend Custom Classification",
        "serviceCode": "comprehendCustomClassification",
        "description": "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/comprehendCustomClassification/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/comprehendCustomClassification/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "comprehendcustomclassification"
        ],
        "parentServiceCode": "amazonComprehend"
    },
    "comprehendCustomEntities": {
        "name": "Comprehend Custom Entities",
        "serviceCode": "comprehendCustomEntities",
        "description": "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/comprehendCustomEntities/en_US.json",
        "c2e": false,
        "mvpSupport": false,
        "comparableTerms": [
            "comprehendcustomentities"
        ],
        "parentServiceCode": "amazonComprehend"
    },
    "containsPii": {
        "name": "Contains PII",
        "serviceCode": "containsPii",
        "description": "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Contains PII",
            "Redaction",
            "Language detection",
            "Free form text analytics"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/containsPii/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/containsPii/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "containspii"
        ],
        "parentServiceCode": "amazonComprehend"
    },
    "awsS3DataTransfer": {
        "name": "Data Transfer",
        "serviceCode": "awsS3DataTransfer",
        "description": "The cost of transferring data at AWS for services without unique transfer costs.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "me-south-1",
            "me-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/ec2/pricing/on-demand/#Data_Transfer",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsS3DataTransfer/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "mvpSupport": false,
        "comparableTerms": [
            "datatransfer",
            "s3datatransfer"
        ],
        "parentServiceCode": "amazonSimpleStorageServiceGroup"
    },
    "dataTransferVpc": {
        "name": "Data Transfer",
        "serviceCode": "dataTransferVpc",
        "description": "WS Virtual Private Network solutions establish secure connections between your on-premises networks, remote offices, client devices, and the AWS global network. AWS VPN is comprised of two services: AWS Site-to-Site VPN and AWS Client VPN. Each service provides a highly-available, managed, and elastic cloud VPN solution to protect your network traffic.",
        "searchKeywords": [
            "access control",
            "ACL",
            "AWS Privatelink",
            "Cloud connectivity",
            "corporate network",
            "elastic IP",
            "Gateway load balancer",
            "home network VPN",
            "IPAM",
            "NAT",
            "NAT gateway",
            "Network Access Analyzer",
            "Network Address Translation",
            "Networking Content Delivery",
            "PrivateLink",
            "Reachability Analyzer",
            "security",
            "single tenant hardware",
            "static ip",
            "subnets",
            "Traffic mirroring",
            "Transit Gateway",
            "Virtual Private Cloud",
            "VPN"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-southeast-3",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/dataTransferVpc/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/dataTransferVpc/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "datatransfer",
            "datatransfervpc"
        ],
        "parentServiceCode": "amazonVirtualPrivateCloud"
    },
    "piiDetection": {
        "name": "Detect PII",
        "serviceCode": "piiDetection",
        "description": "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/piiDetection/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/piiDetection/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "detectpii",
            "piidetection"
        ],
        "parentServiceCode": "amazonComprehend"
    },
    "awsSystemsManagerDistributor": {
        "name": "Distributor",
        "serviceCode": "awsSystemsManagerDistributor",
        "description": "AWS Systems Manager Distributor feature",
        "searchKeywords": [
            "System Manager",
            "Distributor",
            "distriubte and maintain software packages"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/systems-manager/",
        "isActive": "true",
        "hasDataTransfer": false,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsSystemsManagerDistributor/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsSystemsManagerDistributor/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "distributor",
            "systemsmanagerdistributor"
        ],
        "parentServiceCode": "awsSystemsManager"
    },
    "amazonDocumentDbBackup": {
        "name": "DocumentDB",
        "serviceCode": "amazonDocumentDbBackup",
        "description": "AWS Backup for DocumentDB",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/backup/",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonDocumentDbBackup/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonDocumentDbBackup/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "backupdocumentdb",
            "documentdbbackup"
        ],
        "parentServiceCode": "awsBackup"
    },
    "amazonDynamoDbBackup": {
        "name": "DynamoDB",
        "serviceCode": "amazonDynamoDbBackup",
        "description": "AWS Backup for DynamoDB",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/backup/",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonDynamoDbBackup/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonDynamoDbBackup/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "backupdynamodb",
            "dynamodbbackup"
        ],
        "parentServiceCode": "awsBackup"
    },
    "amazonDynamoDbDaxClusters": {
        "name": "DynamoDB Accelerator (DAX) clusters",
        "serviceCode": "amazonDynamoDbDaxClusters",
        "description": "Amazon DynamoDB is a key-value and document database that delivers single-digit millisecond performance at any scale. It's a fully managed, multiregion, multimaster, durable database with built-in security, backup and restore, and in-memory caching for internet-scale applications.",
        "searchKeywords": [
            "Database",
            "DDB",
            "NoSQL",
            "SQL",
            "Table",
            "nosql databases",
            "database schema",
            "database software",
            "cloud database",
            "document database",
            "key value store",
            "database as a service",
            "database scheme",
            "nosql hosting",
            "hosted nosql",
            "data store",
            "unstructured database",
            "Accelerator",
            "DAX"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/dynamodb/",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonDynamoDbDaxClusters/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonDynamoDbDaxClusters/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "dax",
            "dynamodbacceleratordaxclusters",
            "dynamodbdaxclusters"
        ],
        "parentServiceCode": "amazonDynamoDb"
    },
    "dynamoDbBackup": {
        "name": "DynamoDB Backup and restore",
        "serviceCode": "dynamoDbBackup",
        "description": "Amazon DynamoDB is a key-value and document database that delivers single-digit millisecond performance at any scale. It's a fully managed, multiregion, multimaster, durable database with built-in security, backup and restore, and in-memory caching for internet-scale applications.",
        "searchKeywords": [
            "Database",
            "DDB",
            "NoSQL",
            "SQL",
            "Table",
            "nosql databases",
            "database schema",
            "database software",
            "cloud database",
            "document database",
            "key value store",
            "database as a service",
            "database scheme",
            "nosql hosting",
            "hosted nosql",
            "data store",
            "unstructured database",
            "Accelerator",
            "DAX"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/dynamodb/",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/dynamoDbBackup/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/dynamoDbBackup/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "dynamodbbackup",
            "dynamodbbackuprestore"
        ],
        "parentServiceCode": "amazonDynamoDb"
    },
    "dynamoDbChangeDateCapture": {
        "name": "DynamoDB change data capture",
        "serviceCode": "dynamoDbChangeDateCapture",
        "description": "Amazon DynamoDB is a key-value and document database that delivers single-digit millisecond performance at any scale. It's a fully managed, multiregion, multimaster, durable database with built-in security, backup and restore, and in-memory caching for internet-scale applications.",
        "searchKeywords": [
            "Database",
            "DDB",
            "NoSQL",
            "SQL",
            "Table",
            "nosql databases",
            "database schema",
            "database software",
            "cloud database",
            "document database",
            "key value store",
            "database as a service",
            "database scheme",
            "nosql hosting",
            "hosted nosql",
            "data store",
            "unstructured database",
            "Accelerator",
            "DAX",
            "change data capture",
            "Kinesis"
        ],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/dynamodb/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/dynamoDbChangeDateCapture/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/dynamoDbChangeDateCapture/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "dynamodbchangedatacapture",
            "dynamodbchangedatecapture"
        ],
        "parentServiceCode": "amazonDynamoDb"
    },
    "dynamoDbDataExportToAmazonS3": {
        "name": "DynamoDB Data export to Amazon S3",
        "serviceCode": "dynamoDbDataExportToAmazonS3",
        "description": "Amazon DynamoDB is a key-value and document database that delivers single-digit millisecond performance at any scale. It's a fully managed, multiregion, multimaster, durable database with built-in security, backup and restore, and in-memory caching for internet-scale applications.",
        "searchKeywords": [
            "Database",
            "DDB",
            "NoSQL",
            "SQL",
            "Table",
            "nosql databases",
            "database schema",
            "database software",
            "cloud database",
            "document database",
            "key value store",
            "database as a service",
            "database scheme",
            "nosql hosting",
            "hosted nosql",
            "data store",
            "unstructured database",
            "Accelerator",
            "DAX"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/dynamodb/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/dynamoDbDataExportToAmazonS3/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/dynamoDbDataExportToAmazonS3/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "dynamodbdataexporttoamazons3",
            "dynamodbdataexporttos3"
        ],
        "parentServiceCode": "amazonDynamoDb"
    },
    "dynamoDbDataImportFromAmazonS3": {
        "name": "DynamoDB Data Import from Amazon S3",
        "serviceCode": "dynamoDbDataImportFromAmazonS3",
        "description": "Amazon DynamoDB is a key-value and document database that delivers single-digit millisecond performance at any scale. It's a fully managed, multiregion, multimaster, durable database with built-in security, backup and restore, and in-memory caching for internet-scale applications.",
        "searchKeywords": [
            "Database",
            "DDB",
            "NoSQL",
            "SQL",
            "Table",
            "nosql databases",
            "database schema",
            "database software",
            "cloud database",
            "document database",
            "key value store",
            "database as a service",
            "database scheme",
            "nosql hosting",
            "hosted nosql",
            "data store",
            "unstructured database",
            "Accelerator",
            "DAX"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/dynamodb/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/dynamoDbDataImportFromAmazonS3/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/dynamoDbDataImportFromAmazonS3/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "dynamodbdataimportfromamazons3",
            "dynamodbdataimportfroms3"
        ],
        "parentServiceCode": "amazonDynamoDb"
    },
    "dynamoDbOnDemand": {
        "name": "DynamoDB on-demand capacity",
        "serviceCode": "dynamoDbOnDemand",
        "description": "Amazon DynamoDB is a key-value and document database that delivers single-digit millisecond performance at any scale. It's a fully managed, multiregion, multimaster, durable database with built-in security, backup and restore, and in-memory caching for internet-scale applications.",
        "searchKeywords": [
            "Database",
            "DDB",
            "NoSQL",
            "SQL",
            "Table",
            "nosql databases",
            "database schema",
            "database software",
            "cloud database",
            "document database",
            "key value store",
            "database as a service",
            "database scheme",
            "nosql hosting",
            "hosted nosql",
            "data store",
            "unstructured database",
            "Accelerator",
            "DAX"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/dynamodb/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/dynamoDbOnDemand/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/dynamoDbOnDemand/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "dynamodbdemandcapacity",
            "dynamodbondemand"
        ],
        "parentServiceCode": "amazonDynamoDb"
    },
    "amazonDynamoDbProvisionedThroughputCapacity": {
        "name": "DynamoDB provisioned capacity",
        "serviceCode": "amazonDynamoDbProvisionedThroughputCapacity",
        "description": "Amazon DynamoDB is a key-value and document database that delivers single-digit millisecond performance at any scale. It's a fully managed, multiregion, multimaster, durable database with built-in security, backup and restore, and in-memory caching for internet-scale applications.",
        "searchKeywords": [
            "Provisioned",
            "Throughput",
            "Database",
            "DynamoDB",
            "DDB",
            "NoSQL",
            "SQL",
            "Table",
            "nosql databases",
            "database schema",
            "database software",
            "cloud database",
            "document database",
            "key value store",
            "database as a service",
            "database scheme",
            "nosql hosting",
            "hosted nosql",
            "data store",
            "unstructured database",
            "Accelerator",
            "DAX"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/dynamodb",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonDynamoDbProvisionedThroughputCapacity/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonDynamoDbProvisionedThroughputCapacity/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "dynamodbprovisionedcapacity",
            "dynamodbprovisionedthroughputcapacity"
        ],
        "parentServiceCode": "amazonDynamoDb"
    },
    "amazonDynamoDbStreams": {
        "name": "DynamoDB Streams",
        "serviceCode": "amazonDynamoDbStreams",
        "description": "Amazon DynamoDB is a key-value and document database that delivers single-digit millisecond performance at any scale. It's a fully managed, multiregion, multimaster, durable database with built-in security, backup and restore, and in-memory caching for internet-scale applications.",
        "searchKeywords": [
            "Database",
            "DDB",
            "NoSQL",
            "SQL",
            "Table",
            "nosql databases",
            "database schema",
            "database software",
            "cloud database",
            "document database",
            "key value store",
            "database as a service",
            "database scheme",
            "nosql hosting",
            "hosted nosql",
            "data store",
            "unstructured database",
            "Accelerator",
            "DAX"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/dynamodb/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonDynamoDbStreams/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonDynamoDbStreams/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "dynamodbstreams"
        ],
        "parentServiceCode": "amazonDynamoDb"
    },
    "amazonEbsBackup": {
        "name": "EBS",
        "serviceCode": "amazonEbsBackup",
        "description": "AWS Backup for EBS",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/backup/",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonEbsBackup/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonEbsBackup/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "backupebs",
            "ebsbackup"
        ],
        "parentServiceCode": "awsBackup"
    },
    "amazonEfsBackup": {
        "name": "EFS",
        "serviceCode": "amazonEfsBackup",
        "description": "AWS Backup for EFS",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/backup/",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonEfsBackup/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonEfsBackup/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "backupefs",
            "efsbackup"
        ],
        "parentServiceCode": "awsBackup"
    },
    "elasticLoadBalancing": {
        "name": "Elastic Load Balancing",
        "serviceCode": "elasticLoadBalancing",
        "description": "Elastic Load Balancing automatically distributes incoming application traffic across multiple targets, such as Amazon EC2 instances, containers, IP addresses, and Lambda functions.",
        "searchKeywords": [
            "ELB",
            "Elastic Load Balancer",
            "Load Balancer",
            "Application Load Balancer",
            "Network Load Balancer",
            "Gateway Load Balancer",
            "Classic Load Balancer"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/elasticloadbalancing",
        "isActive": "true",
        "subType": "subServiceSelector",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/elasticLoadBalancing/en_US.json",
        "c2e": false,
        "templates": [
            "applicationLoadBalancer",
            "networkLoadBalancer",
            "gatewayLoadBalancer",
            "classicLoadBalancer"
        ],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/elasticLoadBalancing/en_US.json",
        "slug": "ElasticLoadBalancing",
        "mvpSupport": false,
        "comparableTerms": [
            "elasticloadbalancing"
        ]
    },
    "entityRecognition": {
        "name": "Entity Recognition",
        "serviceCode": "entityRecognition",
        "description": "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/entityRecognition/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/entityRecognition/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "entityrecognition"
        ],
        "parentServiceCode": "amazonComprehend"
    },
    "eventDetectionPerEventType": {
        "name": "Event Detection",
        "serviceCode": "eventDetectionPerEventType",
        "description": "Comprehend Events identifies real-world events such as acquisitions, IPOs and bankruptcies from text documents and extracts all the related details around the event such as investor, invested, deal amount and more. You can apply natural language processing with asynchronous jobs for event detection across large collections of documents.",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics",
            "Event",
            "Event Analysis"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/eventDetectionPerEventType/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/eventDetectionPerEventType/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "eventdetection",
            "eventdetectionpereventtype"
        ],
        "parentServiceCode": "amazonComprehend"
    },
    "fifoTopics": {
        "name": "FIFO Topics",
        "serviceCode": "fifoTopics",
        "description": "Amazon Simple Notification Service (SNS) is a highly available, durable, secure, fully managed pub/sub messaging service that enables you to decouple microservices, distributed systems, and serverless applications",
        "searchKeywords": [
            "Messaging",
            "SNS",
            "notification topic",
            "publish message",
            "subscription",
            "text message",
            "sms",
            "topics",
            "push notifications",
            "push notification service queuing",
            "FIFO topics"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/sns/pricing/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/fifoTopics/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/fifoTopics/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "fifotopics"
        ],
        "parentServiceCode": "amazonSimpleNotificationService"
    },
    "amazonFSxLustreBackup": {
        "name": "FSx Lustre",
        "serviceCode": "amazonFSxLustreBackup",
        "description": "AWS Backup for FSx for Lustre",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/backup/",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonFSxLustreBackup/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonFSxLustreBackup/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "fsxlustre",
            "fsxlustrebackup"
        ],
        "parentServiceCode": "awsBackup"
    },
    "amazonFSxNetAppOntapBackup": {
        "name": "FSx NetApp ONTAP",
        "serviceCode": "amazonFSxNetAppOntapBackup",
        "description": "AWS Backup for FSx NetApp ONTAP",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/backup/",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonFSxNetAppOntapBackup/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonFSxNetAppOntapBackup/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "backupfsxnetappontap",
            "fsxnetappontapbackup"
        ],
        "parentServiceCode": "awsBackup"
    },
    "amazonFSxOpenZfsBackup": {
        "name": "FSx OpenZFS",
        "serviceCode": "amazonFSxOpenZfsBackup",
        "description": "AWS Backup for FSx OpenZFS",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/backup/",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonFSxOpenZfsBackup/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonFSxOpenZfsBackup/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "backupfsxopenzfs",
            "fsxopenzfsbackup"
        ],
        "parentServiceCode": "awsBackup"
    },
    "amazonFSxWindowsBackup": {
        "name": "FSx Windows",
        "serviceCode": "amazonFSxWindowsBackup",
        "description": "AWS Backup for FSx for Windows",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/backup/",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonFSxWindowsBackup/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonFSxWindowsBackup/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "fsxwindows",
            "fsxwindowsbackup"
        ],
        "parentServiceCode": "awsBackup"
    },
    "ftp": {
        "name": "FTP",
        "serviceCode": "ftp",
        "searchKeywords": [
            "sftp",
            "FTPS",
            "as2",
            "amazon s3",
            "s3",
            "winscp",
            "filezilla",
            "cyberduck",
            "ssh",
            "transfer",
            "ftp",
            "ftp/s",
            "openssh",
            "file transfer",
            "secure file transfer",
            "ssh ftp",
            "secure shell file transfer protocol",
            "file transfer protocol"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-gov-west-1",
            "us-gov-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/aws-transfer-family/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/ftp/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/ftp/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "ftp"
        ],
        "parentServiceCode": "aWSTransferForSFTP"
    },
    "ftps": {
        "name": "FTPS",
        "serviceCode": "ftps",
        "searchKeywords": [
            "sftp",
            "FTPS",
            "as2",
            "amazon s3",
            "s3",
            "winscp",
            "filezilla",
            "cyberduck",
            "ssh",
            "transfer",
            "ftp",
            "ftp/s",
            "openssh",
            "file transfer",
            "secure file transfer",
            "ssh ftp",
            "secure shell file transfer protocol",
            "file transfer protocol"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-gov-west-1",
            "us-gov-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/aws-transfer-family/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/ftps/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/ftps/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "ftps"
        ],
        "parentServiceCode": "aWSTransferForSFTP"
    },
    "gatewayLoadBalancer": {
        "name": "Gateway Load Balancer",
        "serviceCode": "gatewayLoadBalancer",
        "description": "Elastic Load Balancing automatically distributes incoming application traffic across multiple targets, such as Amazon EC2 instances, containers, IP addresses, and Lambda functions.",
        "searchKeywords": [
            "ELB",
            "Elastic Load Balancer",
            "Load Balancer",
            "Application Load Balancer",
            "Network Load Balancer",
            "Classic Load Balancer",
            "Gateway Load Balancer"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/elasticloadbalancing/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/gatewayLoadBalancer/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/gatewayLoadBalancer/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "gatewayloadbalancer"
        ],
        "parentServiceCode": "elasticLoadBalancing"
    },
    "gatewayLoadBalancerVpc": {
        "name": "Gateway Load Balancer",
        "serviceCode": "gatewayLoadBalancerVpc",
        "description": "Elastic Load Balancing automatically distributes incoming application traffic across multiple targets, such as Amazon EC2 instances, containers, IP addresses, and Lambda functions.",
        "searchKeywords": [
            "ELB",
            "Elastic Load Balancer",
            "Load Balancer",
            "Application Load Balancer",
            "Network Load Balancer",
            "Classic Load Balancer",
            "Gateway Load Balancer"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/elasticloadbalancing/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/gatewayLoadBalancerVpc/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/gatewayLoadBalancerVpc/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "gatewayloadbalancer",
            "gatewayloadbalancervpc"
        ],
        "parentServiceCode": "amazonVirtualPrivateCloud"
    },
    "locationServiceGeofencing": {
        "name": "Geofencing",
        "serviceCode": "locationServiceGeofencing",
        "description": "Amazon Location Service provides affordable data, tracking and geofencing capabilities, and native integrations with AWS services, so you can create sophisticated location-enabled applications quickly, without the high cost of custom development.",
        "searchKeywords": [
            "Location Service",
            "compromising data security",
            "user privacy",
            "asset tracking",
            "location-based marketing",
            "maps",
            "places",
            "routing",
            "tracking",
            "geofencing",
            "Service Resources"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "eu-north-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/location/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/locationServiceGeofencing/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/locationServiceGeofencing/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "geofencing",
            "locationservicegeofencing"
        ],
        "parentServiceCode": "locationService"
    },
    "awsIoTCoreHttp": {
        "name": "HTTP",
        "serviceCode": "awsIoTCoreHttp",
        "description": "AWS IoT Core is a managed cloud service that lets connected devices easily and securely interact with cloud applications and other devices.",
        "searchKeywords": [
            "iot",
            "device",
            "messages",
            "shadow",
            "registry",
            "rules",
            "device shadow",
            "rules engine",
            "basic ingest",
            "mqtt",
            "LoRaWAN"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/iot-core/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsIoTCoreHttp/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/awsIoTCoreHttp/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "http",
            "iotcorehttp"
        ],
        "parentServiceCode": "awsIoTCore"
    },
    "awsSystemsManagerIncidentManager": {
        "name": "Incident Manager",
        "serviceCode": "awsSystemsManagerIncidentManager",
        "description": "AWS AppConfig enables you to provide validation logic to ensure your configuration data is syntactically and semantically correct according to your definitions before making it available to your application. AWS AppConfig also gives you the ability to roll out configuration changes over a defined time period while monitoring your application so that you can catch errors and roll back the changes if needed, to help you minimize the impact to the users.",
        "searchKeywords": [
            "Systems Manager",
            "AppConfig",
            "configuration",
            "monitoring"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "ap-southeast-1",
            "ap-northeast-1",
            "ap-southeast-2",
            "eu-north-1",
            "eu-west-1",
            "eu-central-1",
            "me-central-1"
        ],
        "linkUrl": "https://aws.amazon.com/systems-manager/",
        "isActive": "true",
        "hasDataTransfer": false,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsSystemsManagerIncidentManager/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsSystemsManagerIncidentManager/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "incidentmanager",
            "systemsmanagerincidentmanager"
        ],
        "parentServiceCode": "awsSystemsManager"
    },
    "ipamVpc": {
        "name": "IPAM",
        "serviceCode": "ipamVpc",
        "description": "WS Virtual Private Network solutions establish secure connections between your on-premises networks, remote offices, client devices, and the AWS global network. AWS VPN is comprised of two services: AWS Site-to-Site VPN and AWS Client VPN. Each service provides a highly-available, managed, and elastic cloud VPN solution to protect your network traffic.",
        "searchKeywords": [
            "access control",
            "ACL",
            "AWS Privatelink",
            "Cloud connectivity",
            "corporate network",
            "elastic IP",
            "Gateway load balancer",
            "home network VPN",
            "IPAM",
            "NAT",
            "NAT gateway",
            "Network Access Analyzer",
            "Network Address Translation",
            "Networking Content Delivery",
            "PrivateLink",
            "Reachability Analyzer",
            "security",
            "single tenant hardware",
            "static ip",
            "subnets",
            "Traffic mirroring",
            "Transit Gateway",
            "Virtual Private Cloud",
            "VPN"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/ipamVpc/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/ipamVpc/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "ipam",
            "ipamvpc"
        ],
        "parentServiceCode": "amazonVirtualPrivateCloud"
    },
    "keyPhraseExtraction": {
        "name": "Keyphrase Extraction",
        "serviceCode": "keyPhraseExtraction",
        "description": "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/keyPhraseExtraction/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/keyPhraseExtraction/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "keyphraseextraction"
        ],
        "parentServiceCode": "amazonComprehend"
    },
    "languageDetection": {
        "name": "Language Detection",
        "serviceCode": "languageDetection",
        "description": "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/languageDetection/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/languageDetection/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "languagedetection"
        ],
        "parentServiceCode": "amazonComprehend"
    },
    "lightsailBlockStorage": {
        "name": "Lightsail Block Storage",
        "serviceCode": "lightsailBlockStorage",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3"
        ],
        "linkUrl": "https://aws.amazon.com/lightsail/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/lightsailBlockStorage/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/lightsailBlockStorage/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "lightsailblockstorage"
        ],
        "parentServiceCode": "amazonLightsail"
    },
    "lightsailCdn": {
        "name": "Lightsail CDN",
        "serviceCode": "lightsailCdn",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/lightsail/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/lightsailCdn/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/lightsailCdn/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "lightsailcdn"
        ],
        "parentServiceCode": "amazonLightsail"
    },
    "lightsailContainers": {
        "name": "Lightsail Containers",
        "serviceCode": "lightsailContainers",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3"
        ],
        "linkUrl": "https://aws.amazon.com/lightsail/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/lightsailContainers/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/lightsailContainers/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "lightsailcontainers"
        ],
        "parentServiceCode": "amazonLightsail"
    },
    "lightsailDataTransfer": {
        "name": "Lightsail Data Transfer",
        "serviceCode": "lightsailDataTransfer",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/lightsail/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/lightsailDataTransfer/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/lightsailDataTransfer/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "lightsaildatatransfer"
        ],
        "parentServiceCode": "amazonLightsail"
    },
    "lightsailLoadBalancer": {
        "name": "Lightsail Load Balancer",
        "serviceCode": "lightsailLoadBalancer",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3"
        ],
        "linkUrl": "https://aws.amazon.com/lightsail/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/lightsailLoadBalancer/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/lightsailLoadBalancer/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "lightsailloadbalancer"
        ],
        "parentServiceCode": "amazonLightsail"
    },
    "lightsailManagedDatabases": {
        "name": "Lightsail Managed Databases",
        "serviceCode": "lightsailManagedDatabases",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3"
        ],
        "linkUrl": "https://aws.amazon.com/lightsail/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/lightsailManagedDatabases/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/lightsailManagedDatabases/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "lightsailmanageddatabases"
        ],
        "parentServiceCode": "amazonLightsail"
    },
    "lightsailObjectStorage": {
        "name": "Lightsail Object Storage",
        "serviceCode": "lightsailObjectStorage",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "us-east-2",
            "us-east-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/lightsail/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/lightsailObjectStorage/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/lightsailObjectStorage/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "lightsailobjectstorage"
        ],
        "parentServiceCode": "amazonLightsail"
    },
    "lightsailVirtualServers": {
        "name": "Lightsail Virtual Servers",
        "serviceCode": "lightsailVirtualServers",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-2",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3"
        ],
        "linkUrl": "https://aws.amazon.com/lightsail/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/lightsailVirtualServers/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/lightsailVirtualServers/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "lightsailvirtualservers"
        ],
        "parentServiceCode": "amazonLightsail"
    },
    "awsIoTCoreLoRaWan": {
        "name": "LoRaWAN",
        "serviceCode": "awsIoTCoreLoRaWan",
        "description": "AWS IoT Core is a managed cloud service that lets connected devices easily and securely interact with cloud applications and other devices.",
        "searchKeywords": [
            "iot",
            "device",
            "messages",
            "shadow",
            "registry",
            "rules",
            "device shadow",
            "rules engine",
            "basic ingest",
            "mqtt",
            "LoRaWAN"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "eu-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/iot-core/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsIoTCoreLoRaWan/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/awsIoTCoreLoRaWan/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "iotcorelorawan",
            "lorawan"
        ],
        "parentServiceCode": "awsIoTCore"
    },
    "locationServiceMaps": {
        "name": "Maps",
        "serviceCode": "locationServiceMaps",
        "description": "Amazon Location Service provides affordable data, tracking and geofencing capabilities, and native integrations with AWS services, so you can create sophisticated location-enabled applications quickly, without the high cost of custom development.",
        "searchKeywords": [
            "Location Service",
            "compromising data security",
            "user privacy",
            "asset tracking",
            "location-based marketing",
            "maps",
            "places",
            "routing",
            "tracking",
            "geofencing",
            "Service Resources"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "eu-north-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/location/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/locationServiceMaps/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/locationServiceMaps/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "locationservicemaps",
            "maps"
        ],
        "parentServiceCode": "locationService"
    },
    "mediaLiveAudioAddOns": {
        "name": "MediaLive Add Ons",
        "serviceCode": "mediaLiveAudioAddOns",
        "description": "Elemental Media Live Audio Add Ons",
        "searchKeywords": [
            "streaming",
            "media",
            "elemental media live"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "eu-west-2",
            "eu-central-1",
            "ap-southeast-1",
            "sa-east-1",
            "us-east-2",
            "ap-northeast-2",
            "eu-north-1",
            "ap-northeast-1",
            "ap-south-1",
            "eu-west-1",
            "us-west-2",
            "ap-southeast-2",
            "eu-west-3"
        ],
        "linkUrl": "https://aws.amazon.com/medialive/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/mediaLiveAudioAddOns/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/mediaLiveAudioAddOns/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "medialiveaddons",
            "medialiveaudioaddons"
        ],
        "parentServiceCode": "awsElementalMediaLive"
    },
    "mediaLiveInput1": {
        "name": "MediaLive Inputs",
        "serviceCode": "mediaLiveInput1",
        "description": "EML input 1",
        "searchKeywords": [
            "streaming",
            "media",
            "elemental media live"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "eu-west-2",
            "eu-central-1",
            "ap-southeast-1",
            "sa-east-1",
            "us-east-2",
            "ap-northeast-2",
            "eu-north-1",
            "ap-northeast-1",
            "ap-south-1",
            "eu-west-1",
            "us-west-2",
            "ap-southeast-2",
            "eu-west-3"
        ],
        "linkUrl": "https://aws.amazon.com/medialive/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/mediaLiveInput1/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/mediaLiveInput1/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "medialiveinput1",
            "medialiveinputs"
        ],
        "parentServiceCode": "awsElementalMediaLive"
    },
    "mediaLiveOutput1": {
        "name": "MediaLive Outputs",
        "serviceCode": "mediaLiveOutput1",
        "description": "EML Output 1",
        "searchKeywords": [
            "streaming",
            "media",
            "elemental media live"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "eu-west-2",
            "eu-central-1",
            "ap-southeast-1",
            "sa-east-1",
            "us-east-2",
            "ap-northeast-2",
            "eu-north-1",
            "ap-northeast-1",
            "ap-south-1",
            "eu-west-1",
            "us-west-2",
            "ap-southeast-2",
            "eu-west-3"
        ],
        "linkUrl": "https://aws.amazon.com/medialive/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/mediaLiveOutput1/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/mediaLiveOutput1/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "medialiveoutput1",
            "medialiveoutputs"
        ],
        "parentServiceCode": "awsElementalMediaLive"
    },
    "medicalIcd10CmOntologyLinkingApi": {
        "name": "Medical ICD-10-CM Ontology Linking API",
        "serviceCode": "medicalIcd10CmOntologyLinkingApi",
        "description": "",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-2",
            "ca-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-gov-west-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/medicalIcd10CmOntologyLinkingApi/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/medicalIcd10CmOntologyLinkingApi/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "medicalicd10cmontologylinkingapi"
        ],
        "parentServiceCode": "amazonComprehendMedical"
    },
    "medicalNamedEntityAndRelationshipExtractionNeReApi": {
        "name": "Medical Named Entity and Relationship Extraction (NERe) API",
        "serviceCode": "medicalNamedEntityAndRelationshipExtractionNeReApi",
        "description": "",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-2",
            "ca-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-gov-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/medicalNamedEntityAndRelationshipExtractionNeReApi/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/medicalNamedEntityAndRelationshipExtractionNeReApi/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "medicalnamedentityandrelationshipextractionnereapi",
            "medicalnamedentityrelationshipextractionnereapi",
            "nere"
        ],
        "parentServiceCode": "amazonComprehendMedical"
    },
    "medicalProtectedHealthInformationDataExtractionAndIdentificationPhIdApi": {
        "name": "Medical Protected Health Information Data Extraction and Identification (PHId) API",
        "serviceCode": "medicalProtectedHealthInformationDataExtractionAndIdentificationPhIdApi",
        "description": "",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-2",
            "ca-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-gov-west-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/medicalProtectedHealthInformationDataExtractionAndIdentificationPhIdApi/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/medicalProtectedHealthInformationDataExtractionAndIdentificationPhIdApi/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "medicalprotectedhealthinformationdataextractionandidentificationphidapi",
            "medicalprotectedhealthinformationdataextractionidentificationphidapi",
            "phid"
        ],
        "parentServiceCode": "amazonComprehendMedical"
    },
    "medicalRxNormOntologyLinkingApi": {
        "name": "Medical RxNORM Ontology Linking API",
        "serviceCode": "medicalRxNormOntologyLinkingApi",
        "description": "",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-2",
            "ca-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-gov-west-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/medicalRxNormOntologyLinkingApi/en_US.json",
        "c2e": false,
        "mvpSupport": false,
        "comparableTerms": [
            "medicalrxnormontologylinkingapi"
        ],
        "parentServiceCode": "amazonComprehendMedical"
    },
    "medicalSystematizedNomenclatureOfMedicineClinicalTermsSnomedCtApi": {
        "name": "Medical Systematized Nomenclature of Medicine Clinical Terms (SNOMED CT) API",
        "serviceCode": "medicalSystematizedNomenclatureOfMedicineClinicalTermsSnomedCtApi",
        "description": "",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-2",
            "ca-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-gov-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/medicalSystematizedNomenclatureOfMedicineClinicalTermsSnomedCtApi/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/medicalSystematizedNomenclatureOfMedicineClinicalTermsSnomedCtApi/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "medicalsystematizednomenclaturemedicineclinicaltermssnomedctapi",
            "medicalsystematizednomenclatureofmedicineclinicaltermssnomedctapi",
            "snomedct"
        ],
        "parentServiceCode": "amazonComprehendMedical"
    },
    "chimeSdkMessaging": {
        "name": "Messaging",
        "serviceCode": "chimeSdkMessaging",
        "description": "TBD",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "eu-central-1",
            "us-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/chime/chime-sdk",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/chimeSdkMessaging/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/chimeSdkMessaging/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "chimesdkmessaging",
            "messaging"
        ],
        "parentServiceCode": "amazonChimeSdk"
    },
    "mainframeMicroFocus": {
        "name": "Micro Focus replatforming",
        "serviceCode": "mainframeMicroFocus",
        "description": "For AWS M2 Blu Age managed runtime, you can choose on-demand instances and pay for the runtime by the hour with no long-term commitments or upfront fees, or choose committed plans for additional savings.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "sa-east-1",
            "us-east-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/mainframe-modernization/pricing/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/mainframeMicroFocus/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/mainframeMicroFocus/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "mainframemicrofocus",
            "microfocusreplatforming"
        ],
        "parentServiceCode": "amazonMainframeModernization"
    },
    "awsIoTCoreMqtt": {
        "name": "MQTT",
        "serviceCode": "awsIoTCoreMqtt",
        "description": "AWS IoT Core is a managed cloud service that lets connected devices easily and securely interact with cloud applications and other devices.",
        "searchKeywords": [
            "iot",
            "device",
            "messages",
            "shadow",
            "registry",
            "rules",
            "device shadow",
            "rules engine",
            "basic ingest",
            "mqtt",
            "LoRaWAN"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/iot-core/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsIoTCoreMqtt/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/awsIoTCoreMqtt/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "iotcoremqtt",
            "mqtt"
        ],
        "parentServiceCode": "awsIoTCore"
    },
    "amazonNeptuneBackup": {
        "name": "Neptune",
        "serviceCode": "amazonNeptuneBackup",
        "description": "AWS Backup for Neptune",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/backup/",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonNeptuneBackup/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonNeptuneBackup/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "backupneptune",
            "neptunebackup"
        ],
        "parentServiceCode": "awsBackup"
    },
    "networkAccessAnalyzerVpc": {
        "name": "Network Access Analyzer",
        "serviceCode": "networkAccessAnalyzerVpc",
        "description": "WS Virtual Private Network solutions establish secure connections between your on-premises networks, remote offices, client devices, and the AWS global network. AWS VPN is comprised of two services: AWS Site-to-Site VPN and AWS Client VPN. Each service provides a highly-available, managed, and elastic cloud VPN solution to protect your network traffic.",
        "searchKeywords": [
            "access control",
            "ACL",
            "AWS Privatelink",
            "Cloud connectivity",
            "corporate network",
            "elastic IP",
            "Gateway load balancer",
            "home network VPN",
            "IPAM",
            "NAT",
            "NAT gateway",
            "Network Access Analyzer",
            "Network Address Translation",
            "Networking Content Delivery",
            "PrivateLink",
            "Reachability Analyzer",
            "security",
            "single tenant hardware",
            "static ip",
            "subnets",
            "Traffic mirroring",
            "Transit Gateway",
            "Virtual Private Cloud",
            "VPN"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/networkAccessAnalyzerVpc/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/networkAccessAnalyzerVpc/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "networkaccessanalyzer",
            "networkaccessanalyzervpc"
        ],
        "parentServiceCode": "amazonVirtualPrivateCloud"
    },
    "networkAddressTranslationNatGatewayVpc": {
        "name": "Network Address Translation (NAT) Gateway",
        "serviceCode": "networkAddressTranslationNatGatewayVpc",
        "description": "WS Virtual Private Network solutions establish secure connections between your on-premises networks, remote offices, client devices, and the AWS global network. AWS VPN is comprised of two services: AWS Site-to-Site VPN and AWS Client VPN. Each service provides a highly-available, managed, and elastic cloud VPN solution to protect your network traffic.",
        "searchKeywords": [
            "access control",
            "ACL",
            "AWS Privatelink",
            "Cloud connectivity",
            "corporate network",
            "elastic IP",
            "Gateway load balancer",
            "home network VPN",
            "IPAM",
            "NAT",
            "NAT gateway",
            "Network Access Analyzer",
            "Network Address Translation",
            "Networking Content Delivery",
            "PrivateLink",
            "Reachability Analyzer",
            "security",
            "single tenant hardware",
            "static ip",
            "subnets",
            "Traffic mirroring",
            "Transit Gateway",
            "Virtual Private Cloud",
            "VPN"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/networkAddressTranslationNatGatewayVpc/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/networkAddressTranslationNatGatewayVpc/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "nat",
            "networkaddresstranslationnatgateway",
            "networkaddresstranslationnatgatewayvpc"
        ],
        "parentServiceCode": "amazonVirtualPrivateCloud"
    },
    "networkLoadBalancer": {
        "name": "Network Load Balancer",
        "serviceCode": "networkLoadBalancer",
        "description": "Elastic Load Balancing automatically distributes incoming application traffic across multiple targets, such as Amazon EC2 instances, containers, IP addresses, and Lambda functions.",
        "searchKeywords": [
            "ELB",
            "Elastic Load Balancer",
            "Load Balancer",
            "Application Load Balancer",
            "Network Load Balancer",
            "Classic Load Balancer"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/elasticloadbalancing/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/networkLoadBalancer/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/networkLoadBalancer/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "networkloadbalancer"
        ],
        "parentServiceCode": "elasticLoadBalancing"
    },
    "neuralTextToSpeech": {
        "name": "Neural Text-to-Speech",
        "serviceCode": "neuralTextToSpeech",
        "description": "Amazon Polly is a service that turns text into lifelike speech, allowing you to create applications that talk, and build entirely new categories of speech-enabled products.",
        "searchKeywords": [
            "polly",
            "NLP",
            "speech",
            "Neural Text-to-Speech"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/polly/",
        "isActive": "true",
        "subType": "subService",
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/neuralTextToSpeech/en_US.json",
        "c2e": false,
        "comparableTerms": [
            "neuraltexttospeech"
        ],
        "parentServiceCode": "amazonPolly"
    },
    "omicsAnalytics": {
        "name": "Omics Analytics",
        "serviceCode": "omicsAnalytics",
        "description": "With Amazon Omics, you only pay for what you use. You are charged based on the amount of data you store and the compute instances you use for processing your workflow. With Amazon Omics, you can store sequence and reference data objects or variants and annotation data. You can also run bioinformatics workflows to analyze and transform genomic, transcriptomic, and other omics data. Amazon Omics is optimized for the storage and computation of omics data and works with other AWS services such as Amazon SageMaker, Amazon Simple Storage Service (S3), and Amazon Athena.",
        "searchKeywords": [
            "amazon omics",
            "omics",
            "omics analytics"
        ],
        "type": "AWSService",
        "regions": [],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/omicsAnalytics/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/omicsAnalytics/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "omicsanalytics"
        ],
        "parentServiceCode": "amazonOmics"
    },
    "omicsReady2RunWorkflows": {
        "name": "Omics Ready2Run Workflows",
        "serviceCode": "omicsReady2RunWorkflows",
        "description": "With Amazon Omics, you only pay for what you use. You are charged based on the amount of data you store and the compute instances you use for processing your workflow. With Amazon Omics, you can store sequence and reference data objects or variants and annotation data. You can also run bioinformatics workflows to analyze and transform genomic, transcriptomic, and other omics data. Amazon Omics is optimized for the storage and computation of omics data and works with other AWS services such as Amazon SageMaker, Amazon Simple Storage Service (S3), and Amazon Athena.",
        "searchKeywords": [
            "amazon omics",
            "omics",
            "omics Workflows"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/omics/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/omicsReady2RunWorkflows/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/omicsReady2RunWorkflows/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "omicsready2runworkflows"
        ],
        "parentServiceCode": "amazonOmics"
    },
    "omicsStorage": {
        "name": "Omics Storage",
        "serviceCode": "omicsStorage",
        "description": "With Amazon Omics, you only pay for what you use. You are charged based on the amount of data you store and the compute instances you use for processing your workflow. With Amazon Omics, you can store sequence and reference data objects or variants and annotation data. You can also run bioinformatics workflows to analyze and transform genomic, transcriptomic, and other omics data. Amazon Omics is optimized for the storage and computation of omics data and works with other AWS services such as Amazon SageMaker, Amazon Simple Storage Service (S3), and Amazon Athena.",
        "searchKeywords": [
            "amazon omics",
            "omics",
            "omics Storage"
        ],
        "type": "AWSService",
        "regions": [],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/omicsStorage/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/omicsStorage/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "omicsstorage"
        ],
        "parentServiceCode": "amazonOmics"
    },
    "omicsWorkflows": {
        "name": "Omics Workflows",
        "serviceCode": "omicsWorkflows",
        "description": "With Amazon Omics, you only pay for what you use. You are charged based on the amount of data you store and the compute instances you use for processing your workflow. With Amazon Omics, you can store sequence and reference data objects or variants and annotation data. You can also run bioinformatics workflows to analyze and transform genomic, transcriptomic, and other omics data. Amazon Omics is optimized for the storage and computation of omics data and works with other AWS services such as Amazon SageMaker, Amazon Simple Storage Service (S3), and Amazon Athena.",
        "searchKeywords": [
            "amazon omics",
            "omics",
            "omics Workflows"
        ],
        "type": "AWSService",
        "regions": [],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/omicsWorkflows/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/omicsWorkflows/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "omicsworkflows"
        ],
        "parentServiceCode": "amazonOmics"
    },
    "awsSystemsManagerOnPremisesInstanceManagement": {
        "name": "On-Premises Instance Management",
        "serviceCode": "awsSystemsManagerOnPremisesInstanceManagement",
        "description": "AWS Systems Manager On-Premises Instance Management feature",
        "searchKeywords": [
            "Systems Manager",
            "On-Premises Instance Management",
            "On-Prem",
            "Session Manager"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ap-northeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/systems-manager/",
        "isActive": "true",
        "hasDataTransfer": false,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsSystemsManagerOnPremisesInstanceManagement/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsSystemsManagerOnPremisesInstanceManagement/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "onpremisesinstancemanagement",
            "systemsmanageronpremisesinstancemanagement"
        ],
        "parentServiceCode": "awsSystemsManager"
    },
    "awsSystemsManagerOpsCenter": {
        "name": "OpsCenter",
        "serviceCode": "awsSystemsManagerOpsCenter",
        "description": "AWS Systems Manager OpsCenter feature",
        "searchKeywords": [
            "System Manager",
            "OpsCenter",
            "operational issues",
            "OpsItems"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-gov-west-1",
            "us-gov-east-1",
            "eu-south-1",
            "af-south-1"
        ],
        "linkUrl": "https://aws.amazon.com/systems-manager/",
        "isActive": "true",
        "hasDataTransfer": false,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsSystemsManagerOpsCenter/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsSystemsManagerOpsCenter/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "opscenter",
            "systemsmanageropscenter"
        ],
        "parentServiceCode": "awsSystemsManager"
    },
    "awsSystemsManagerParameterStore": {
        "name": "Parameter Store",
        "serviceCode": "awsSystemsManagerParameterStore",
        "description": "AWS Systems Manager Parameter Store feature",
        "searchKeywords": [
            "System Manager",
            "Parameter Store",
            "API",
            "parameter"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/systems-manager/",
        "isActive": "true",
        "hasDataTransfer": false,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/awsSystemsManagerParameterStore/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/awsSystemsManagerParameterStore/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "parameterstore",
            "systemsmanagerparameterstore"
        ],
        "parentServiceCode": "awsSystemsManager"
    },
    "locationServicePlaces": {
        "name": "Places",
        "serviceCode": "locationServicePlaces",
        "description": "Amazon Location Service provides affordable data, tracking and geofencing capabilities, and native integrations with AWS services, so you can create sophisticated location-enabled applications quickly, without the high cost of custom development.",
        "searchKeywords": [
            "Location Service",
            "compromising data security",
            "user privacy",
            "asset tracking",
            "location-based marketing",
            "maps",
            "places",
            "routing",
            "tracking",
            "geofencing",
            "Service Resources"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "eu-north-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/location/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/locationServicePlaces/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/locationServicePlaces/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "locationserviceplaces",
            "places"
        ],
        "parentServiceCode": "locationService"
    },
    "proServeYear1Cost": {
        "name": "ProServe Year 1 Price",
        "serviceCode": "proServeYear1Cost",
        "description": "AWS Professional Services Year 1 Price",
        "searchKeywords": [
            "ProServe",
            "professional",
            "services"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/professional-services/",
        "isActive": "true",
        "hasDataTransfer": false,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/proServeYear1Cost/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": true,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/proServeYear1Cost/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "proserveyear1cost",
            "proserveyear1price"
        ],
        "parentServiceCode": "awsProfessionalServices"
    },
    "proServeYear2Cost": {
        "name": "ProServe Year 2 Price",
        "serviceCode": "proServeYear2Cost",
        "description": "AWS Professional Services Year 2 Price",
        "searchKeywords": [
            "ProServe",
            "professional",
            "services"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/professional-services/",
        "isActive": "true",
        "hasDataTransfer": false,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/proServeYear2Cost/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": true,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/proServeYear2Cost/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "proserveyear2cost",
            "proserveyear2price"
        ],
        "parentServiceCode": "awsProfessionalServices"
    },
    "proServeYear3Cost": {
        "name": "ProServe Year 3 Price",
        "serviceCode": "proServeYear3Cost",
        "description": "AWS Professional Services Year 3 Price",
        "searchKeywords": [
            "ProServe",
            "professional",
            "services"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/professional-services/",
        "isActive": "true",
        "hasDataTransfer": false,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/proServeYear3Cost/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": true,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/proServeYear3Cost/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "proserveyear3cost",
            "proserveyear3price"
        ],
        "parentServiceCode": "awsProfessionalServices"
    },
    "proServeYear4Cost": {
        "name": "ProServe Year 4 Price",
        "serviceCode": "proServeYear4Cost",
        "description": "AWS Professional Services Year 4 Price",
        "searchKeywords": [
            "ProServe",
            "professional",
            "services"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/professional-services/",
        "isActive": "true",
        "hasDataTransfer": false,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/proServeYear4Cost/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": true,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/proServeYear4Cost/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "proserveyear4cost",
            "proserveyear4price"
        ],
        "parentServiceCode": "awsProfessionalServices"
    },
    "proServeYear5Cost": {
        "name": "ProServe Year 5 Price",
        "serviceCode": "proServeYear5Cost",
        "description": "AWS Professional Services Year 5 Price",
        "searchKeywords": [
            "ProServe",
            "professional",
            "services"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-gov-west-1"
        ],
        "linkUrl": "https://aws.amazon.com/professional-services/",
        "isActive": "true",
        "hasDataTransfer": false,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/proServeYear5Cost/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": true,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/proServeYear5Cost/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "proserveyear5cost",
            "proserveyear5price"
        ],
        "parentServiceCode": "awsProfessionalServices"
    },
    "proxyPhoneSession": {
        "name": "Proxy Phone Session",
        "serviceCode": "proxyPhoneSession",
        "description": "Amazon Chime lets you meet, chat, and collaborate with the security of AWS. You can work seamlessly on your devices, and meet from your desk or on the go - ensuring you always stay connected.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/chime/chime-sdk",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/proxyPhoneSession/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/proxyPhoneSession/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "proxyphonesession"
        ],
        "parentServiceCode": "amazonChimeSdk"
    },
    "ptsnAudio": {
        "name": "PSTN Audio",
        "serviceCode": "ptsnAudio",
        "description": "Amazon Chime lets you meet, chat, and collaborate with the security of AWS. You can work seamlessly on your devices, and meet from your desk or on the go - ensuring you always stay connected.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/chime/chime-sdk",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/ptsnAudio/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "bulkImportEnabled": false,
        "serviceDefinitionUrlPath": "/data/ptsnAudio/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "pstnaudio",
            "ptsnaudio"
        ],
        "parentServiceCode": "amazonChimeSdk"
    },
    "amazonRdsBackup": {
        "name": "RDS",
        "serviceCode": "amazonRdsBackup",
        "description": "AWS Backup for RDS",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/backup/",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonRdsBackup/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonRdsBackup/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "backuprds",
            "rdsbackup"
        ],
        "parentServiceCode": "awsBackup"
    },
    "reachabilityAnalyzerVpc": {
        "name": "Reachability Analyzer",
        "serviceCode": "reachabilityAnalyzerVpc",
        "description": "WS Virtual Private Network solutions establish secure connections between your on-premises networks, remote offices, client devices, and the AWS global network. AWS VPN is comprised of two services: AWS Site-to-Site VPN and AWS Client VPN. Each service provides a highly-available, managed, and elastic cloud VPN solution to protect your network traffic.",
        "searchKeywords": [
            "access control",
            "ACL",
            "AWS Privatelink",
            "Cloud connectivity",
            "corporate network",
            "elastic IP",
            "Gateway load balancer",
            "home network VPN",
            "IPAM",
            "NAT",
            "NAT gateway",
            "Network Access Analyzer",
            "Network Address Translation",
            "Networking Content Delivery",
            "PrivateLink",
            "Reachability Analyzer",
            "security",
            "single tenant hardware",
            "static ip",
            "subnets",
            "Traffic mirroring",
            "Transit Gateway",
            "Virtual Private Cloud",
            "VPN"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/reachabilityAnalyzerVpc/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/reachabilityAnalyzerVpc/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "reachabilityanalyzer",
            "reachabilityanalyzervpc"
        ],
        "parentServiceCode": "amazonVirtualPrivateCloud"
    },
    "realTimeDocumentTranslation": {
        "name": "Real-Time Document Translation",
        "serviceCode": "realTimeDocumentTranslation",
        "description": "Amazon Translate is a neural machine translation service that delivers fast, high-quality, and affordable language translation. Neural machine translation is a form of language translation automation that uses deep learning models to deliver more accurate and more natural sounding translation than traditional statistical and rule-based translation algorithms.",
        "searchKeywords": [
            "NLP",
            "Natural language processing",
            "language transalation",
            "Text analytics",
            "Language translation",
            "Amazon translate",
            "Translate"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/translate/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/realTimeDocumentTranslation/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/realTimeDocumentTranslation/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "realtimedocumenttranslation"
        ],
        "parentServiceCode": "amazonTranslate"
    },
    "rekognitionCustomLabels": {
        "name": "Rekognition Custom Labels",
        "serviceCode": "rekognitionCustomLabels",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-west-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/rekognitionCustomLabels/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/rekognitionCustomLabels/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "rekognitioncustomlabels"
        ],
        "parentServiceCode": "amazonRekognition"
    },
    "rekognitionFaceLiveness": {
        "name": "Rekognition Face Liveness",
        "serviceCode": "rekognitionFaceLiveness",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/rekognitionFaceLiveness/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/rekognitionFaceLiveness/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "rekognitionfaceliveness"
        ],
        "parentServiceCode": "amazonRekognition"
    },
    "rekognitionImage": {
        "name": "Rekognition Image",
        "serviceCode": "rekognitionImage",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/rekognitionImage/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/rekognitionImage/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "rekognitionimage"
        ],
        "parentServiceCode": "amazonRekognition"
    },
    "rekognitionVideo": {
        "name": "Rekognition Stored Video",
        "serviceCode": "rekognitionVideo",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/rekognitionVideo/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/rekognitionVideo/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "rekognitionstoredvideo",
            "rekognitionvideo"
        ],
        "parentServiceCode": "amazonRekognition"
    },
    "rekognitionStreamingVideoEvents": {
        "name": "Rekognition Streaming Video Events",
        "serviceCode": "rekognitionStreamingVideoEvents",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "ap-south-1",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/rekognitionStreamingVideoEvents/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/rekognitionStreamingVideoEvents/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "rekognitionstreamingvideoevents"
        ],
        "parentServiceCode": "amazonRekognition"
    },
    "locationServiceRouting": {
        "name": "Routing",
        "serviceCode": "locationServiceRouting",
        "description": "Amazon Location Service provides affordable data, tracking and geofencing capabilities, and native integrations with AWS services, so you can create sophisticated location-enabled applications quickly, without the high cost of custom development.",
        "searchKeywords": [
            "Location Service",
            "compromising data security",
            "user privacy",
            "asset tracking",
            "location-based marketing",
            "maps",
            "places",
            "routing",
            "tracking",
            "geofencing",
            "Service Resources"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "eu-north-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/location/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/locationServiceRouting/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/locationServiceRouting/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "locationservicerouting",
            "routing"
        ],
        "parentServiceCode": "locationService"
    },
    "sageMakerRStudioOnSageMaker": {
        "name": "RStudio on SageMaker",
        "serviceCode": "sageMakerRStudioOnSageMaker",
        "description": "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.",
        "searchKeywords": [
            "Sagemaker",
            "Model",
            "ML",
            "Machine Learning",
            "EI",
            "data scientist"
        ],
        "type": "AWSService",
        "regions": [
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/sagemaker/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerRStudioOnSageMaker/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/sageMakerRStudioOnSageMaker/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "rstudiosagemaker",
            "sagemakerrstudioonsagemaker"
        ],
        "parentServiceCode": "amazonSageMaker"
    },
    "amazonS3Backup": {
        "name": "S3",
        "serviceCode": "amazonS3Backup",
        "description": "AWS Backup for S3",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/backup/",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonS3Backup/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonS3Backup/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "backups3",
            "s3backup"
        ],
        "parentServiceCode": "awsBackup"
    },
    "amazonS3GlacierDeepArhive": {
        "name": "S3 Glacier Deep Archive",
        "serviceCode": "amazonS3GlacierDeepArhive",
        "description": "Amazon Simple Storage Service (Amazon S3) is storage for the internet. You can use Amazon S3 to store and retrieve any amount of data at any time, from anywhere on the web.",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/s3/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonS3GlacierDeepArhive/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonS3GlacierDeepArhive/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "s3glacierdeeparchive",
            "s3glacierdeeparhive"
        ],
        "parentServiceCode": "amazonSimpleStorageServiceGroup"
    },
    "amazonS3Glacier": {
        "name": "S3 Glacier Flexible Retrieval",
        "serviceCode": "amazonS3Glacier",
        "description": "Amazon Simple Storage Service (Amazon S3) is storage for the internet. You can use Amazon S3 to store and retrieve any amount of data at any time, from anywhere on the web.",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/s3",
        "isActive": "true",
        "subType": "TCOCalculator",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonS3Glacier/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonS3Glacier/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "s3glacier",
            "s3glacierflexibleretrieval"
        ],
        "parentServiceCode": "amazonSimpleStorageServiceGroup"
    },
    "s3GlacierInstantRetrieval": {
        "name": "S3 Glacier Instant Retrieval",
        "serviceCode": "s3GlacierInstantRetrieval",
        "description": "Amazon Simple Storage Service (Amazon S3) is storage for the internet. You can use Amazon S3 to store and retrieve any amount of data at any time, from anywhere on the web.",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/s3/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/s3GlacierInstantRetrieval/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/s3GlacierInstantRetrieval/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "s3glacierinstantretrieval"
        ],
        "parentServiceCode": "amazonSimpleStorageServiceGroup"
    },
    "amazonS3IntelligentTiering": {
        "name": "S3 Intelligent - Tiering",
        "serviceCode": "amazonS3IntelligentTiering",
        "description": "Amazon Simple Storage Service (Amazon S3) is storage for the internet. You can use Amazon S3 to store and retrieve any amount of data at any time, from anywhere on the web.",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/s3/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonS3IntelligentTiering/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonS3IntelligentTiering/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "s3intelligenttiering"
        ],
        "parentServiceCode": "amazonSimpleStorageServiceGroup"
    },
    "amazonS3StorageManagement": {
        "name": "S3 Management and Insights",
        "serviceCode": "amazonS3StorageManagement",
        "description": "S3 Storage Management and Analytics is priced per feature (Amazon S3 Inventory, S3 Storage Class Analysis, S3 Storage Lens, and S3 Object Tagging) that is enabled on your account’s bucket.",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/s3/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonS3StorageManagement/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonS3StorageManagement/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "s3managementinsights",
            "s3storagemanagement"
        ],
        "parentServiceCode": "amazonSimpleStorageServiceGroup"
    },
    "s3ObjectLambda": {
        "name": "S3 Object Lambda",
        "serviceCode": "s3ObjectLambda",
        "description": "Amazon Simple Storage Service (Amazon S3) is storage for the internet. You can use Amazon S3 to store and retrieve any amount of data at any time, from anywhere on the web.",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage",
            "S3",
            "s3"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/s3",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/s3ObjectLambda/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "mvpSupport": false,
        "comparableTerms": [
            "s3objectlambda"
        ],
        "parentServiceCode": "amazonSimpleStorageServiceGroup"
    },
    "s3OneZoneInfrequentAccess": {
        "name": "S3 One Zone - Infrequent Access",
        "serviceCode": "s3OneZoneInfrequentAccess",
        "description": "Amazon Simple Storage Service (Amazon S3) is storage for the internet. You can use Amazon S3 to store and retrieve any amount of data at any time, from anywhere on the web.",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/s3/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/s3OneZoneInfrequentAccess/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/s3OneZoneInfrequentAccess/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "s3onezoneinfrequentaccess"
        ],
        "parentServiceCode": "amazonSimpleStorageServiceGroup"
    },
    "amazonS3Standard": {
        "name": "S3 Standard",
        "serviceCode": "amazonS3Standard",
        "description": "Amazon Simple Storage Service (Amazon S3) is storage for the internet. You can use Amazon S3 to store and retrieve any amount of data at any time, from anywhere on the web.",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage",
            "S3",
            "s3"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/s3",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonS3Standard/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonS3Standard/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "s3standard"
        ],
        "parentServiceCode": "amazonSimpleStorageServiceGroup"
    },
    "amazonS3StandardInfrequentAccess": {
        "name": "S3 Standard - Infrequent Access",
        "serviceCode": "amazonS3StandardInfrequentAccess",
        "description": "Amazon Simple Storage Service (Amazon S3) is storage for the internet. You can use Amazon S3 to store and retrieve any amount of data at any time, from anywhere on the web.",
        "searchKeywords": [
            "Storage",
            "Simple Storage Service",
            "bucket",
            "file storage",
            "cloud storage",
            "static website hosting",
            "object storage",
            "store objects",
            "store files",
            "data migration",
            "ongoing data ingestion",
            "backup and recovery",
            "big data analytics",
            "nearline archive",
            "disaster recovery",
            "content distribution",
            "cloud storage"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-gov-east-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "eu-south-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/s3/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonS3StandardInfrequentAccess/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonS3StandardInfrequentAccess/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "s3standardinfrequentaccess"
        ],
        "parentServiceCode": "amazonSimpleStorageServiceGroup"
    },
    "sageMakerAsynchronousInference": {
        "name": "SageMaker Asynchronous Inference",
        "serviceCode": "sageMakerAsynchronousInference",
        "description": "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.",
        "searchKeywords": [
            "Sagemaker",
            "Model",
            "ML",
            "Machine Learning",
            "EI",
            "data scientist"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/sagemaker/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerAsynchronousInference/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/sageMakerAsynchronousInference/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "sagemakerasynchronousinference"
        ],
        "parentServiceCode": "amazonSageMaker"
    },
    "sageMakerAutopilot": {
        "name": "SageMaker Autopilot",
        "serviceCode": "sageMakerAutopilot",
        "description": "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.",
        "searchKeywords": [
            "Sagemaker",
            "Model",
            "ML",
            "Machine Learning",
            "EI",
            "data scientist",
            "Auto ML",
            "AML",
            "Autopilot"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/sagemaker/autopilot/?sagemaker-data-wrangler-whats-new.sort-by=item.additionalFields.postDateTime&sagemaker-data-wrangler-whats-new.sort-order=desc",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerAutopilot/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/sageMakerAutopilot/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "sagemakerautopilot"
        ],
        "parentServiceCode": "amazonSageMaker"
    },
    "sageMakerBatchTransform": {
        "name": "SageMaker Batch Transform",
        "serviceCode": "sageMakerBatchTransform",
        "description": "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.",
        "searchKeywords": [
            "Sagemaker",
            "Model",
            "ML",
            "Machine Learning",
            "EI",
            "data scientist"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "eu-west-1",
            "us-west-1",
            "ap-southeast-1",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-west-2",
            "sa-east-1",
            "ap-southeast-2",
            "eu-central-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "us-east-2",
            "ca-central-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "ap-east-1",
            "me-south-1",
            "eu-south-1",
            "af-south-1"
        ],
        "linkUrl": "https://aws.amazon.com/sagemaker/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerBatchTransform/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/sageMakerBatchTransform/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "sagemakerbatchtransform"
        ],
        "parentServiceCode": "amazonSageMaker"
    },
    "sageMakerDataWrangler": {
        "name": "SageMaker Data Wrangler",
        "serviceCode": "sageMakerDataWrangler",
        "description": "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.",
        "searchKeywords": [
            "Sagemaker",
            "Model",
            "ML",
            "Machine Learning",
            "EI",
            "data scientist"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/sagemaker/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerDataWrangler/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/sageMakerDataWrangler/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "sagemakerdatawrangler"
        ],
        "parentServiceCode": "amazonSageMaker"
    },
    "amazonSageMakerEdgeManager": {
        "name": "SageMaker Edge Manager",
        "serviceCode": "amazonSageMakerEdgeManager",
        "description": "Amazon SageMaker Edge Manager makes it easy for ML developers to optimize, secure, monitor, and maintain ML models on fleets of edge devices.",
        "searchKeywords": [
            "Sagemaker",
            "Model",
            "ML",
            "Machine Learning",
            "EI",
            "data scientist",
            "Edge Manager"
        ],
        "type": "AWSService",
        "regions": [
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/sagemaker/edge-manager/pricing/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonSageMakerEdgeManager/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonSageMakerEdgeManager/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "sagemakeredgemanager"
        ],
        "parentServiceCode": "amazonSageMaker"
    },
    "sageMakerFeatureStore": {
        "name": "SageMaker Feature Store",
        "serviceCode": "sageMakerFeatureStore",
        "description": "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.",
        "searchKeywords": [
            "Sagemaker",
            "Model",
            "ML",
            "Machine Learning",
            "EI",
            "data scientist"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "eu-west-1",
            "us-west-1",
            "ap-southeast-1",
            "ap-northeast-1",
            "us-west-2",
            "sa-east-1",
            "ap-southeast-2",
            "eu-central-1",
            "ap-northeast-2",
            "ap-south-1",
            "us-east-2",
            "ca-central-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "ap-east-1",
            "me-south-1",
            "eu-south-1",
            "af-south-1"
        ],
        "linkUrl": "https://aws.amazon.com/sagemaker/",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerFeatureStore/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/sageMakerFeatureStore/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "sagemakerfeaturestore"
        ],
        "parentServiceCode": "amazonSageMaker"
    },
    "sagemakerGeospatialCapabilities": {
        "name": "Sagemaker Geospatial ML",
        "serviceCode": "sagemakerGeospatialCapabilities",
        "description": "Amazon SageMaker geospatial capabilities make it easier for data scientists and machine learning (ML) engineers to build, train, and deploy ML models using geospatial data. Access open-source data, processing, and visualization tools to more efficiently prepare geospatial data for ML. You can increase productivity by using purpose-built operations and pretrained ML models to speed up model building and training. Use built-in visualization tools to explore prediction outputs on an interactive map and discuss the insights and results across interdisciplinary teams.",
        "searchKeywords": [
            "Sagemaker",
            "Model",
            "ML",
            "Machine Learning",
            "EI",
            "data scientist",
            "geospatial"
        ],
        "type": "AWSService",
        "regions": [],
        "linkUrl": "https://aws.amazon.com/sagemaker/geospatial/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/sagemakerGeospatialCapabilities/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/sagemakerGeospatialCapabilities/en_US.json",
        "slug": "geospatialML",
        "mvpSupport": false,
        "comparableTerms": [
            "geospatialml",
            "sagemakergeospatial",
            "sagemakergeospatialcapabilities",
            "sagemakergeospatialml"
        ]
    },
    "sageMakerOnDemandNotebookInstances": {
        "name": "SageMaker On-Demand Notebook Instances",
        "serviceCode": "sageMakerOnDemandNotebookInstances",
        "description": "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.",
        "searchKeywords": [
            "Sagemaker",
            "Model",
            "ML",
            "Machine Learning",
            "EI",
            "data scientist"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "eu-west-1",
            "us-west-1",
            "ap-southeast-1",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-west-2",
            "sa-east-1",
            "ap-southeast-2",
            "eu-central-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "us-east-2",
            "ca-central-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "ap-east-1",
            "me-south-1",
            "eu-south-1",
            "af-south-1"
        ],
        "linkUrl": "https://aws.amazon.com/sagemaker/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerOnDemandNotebookInstances/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/sageMakerOnDemandNotebookInstances/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "sagemakerdemandnotebookinstances",
            "sagemakerondemandnotebookinstances"
        ],
        "parentServiceCode": "amazonSageMaker"
    },
    "sageMakerProcessing": {
        "name": "SageMaker Processing",
        "serviceCode": "sageMakerProcessing",
        "description": "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.",
        "searchKeywords": [
            "Sagemaker",
            "Model",
            "ML",
            "Machine Learning",
            "EI",
            "data scientist"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "eu-west-1",
            "us-west-1",
            "ap-southeast-1",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-west-2",
            "sa-east-1",
            "ap-southeast-2",
            "eu-central-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "us-east-2",
            "ca-central-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "ap-east-1",
            "me-south-1",
            "eu-south-1",
            "af-south-1"
        ],
        "linkUrl": "https://aws.amazon.com/sagemaker/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerProcessing/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/sageMakerProcessing/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "sagemakerprocessing"
        ],
        "parentServiceCode": "amazonSageMaker"
    },
    "sageMakerRealTimeInference": {
        "name": "SageMaker Real-Time Inference",
        "serviceCode": "sageMakerRealTimeInference",
        "description": "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.",
        "searchKeywords": [
            "Sagemaker",
            "Model",
            "ML",
            "Machine Learning",
            "EI",
            "data scientist"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "eu-west-1",
            "us-west-1",
            "ap-southeast-1",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-west-2",
            "sa-east-1",
            "ap-southeast-2",
            "eu-central-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "us-east-2",
            "ca-central-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "ap-east-1",
            "me-south-1",
            "eu-south-1",
            "af-south-1"
        ],
        "linkUrl": "https://aws.amazon.com/sagemaker/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerRealTimeInference/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/sageMakerRealTimeInference/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "sagemakerrealtimeinference"
        ],
        "parentServiceCode": "amazonSageMaker"
    },
    "sageMakerServerlessInference": {
        "name": "SageMaker Serverless Inference",
        "serviceCode": "sageMakerServerlessInference",
        "description": "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.",
        "searchKeywords": [
            "Sagemaker",
            "Model",
            "ML",
            "Machine Learning",
            "EI",
            "data scientist",
            "Serverless",
            "Serverless Inference"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/sagemaker/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerServerlessInference/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/sageMakerServerlessInference/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "sagemakerserverlessinference"
        ],
        "parentServiceCode": "amazonSageMaker"
    },
    "sageMakerStudioNotebooks": {
        "name": "SageMaker Studio Notebooks",
        "serviceCode": "sageMakerStudioNotebooks",
        "description": "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.",
        "searchKeywords": [
            "Sagemaker",
            "Model",
            "ML",
            "Machine Learning",
            "EI",
            "data scientist"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/sagemaker/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerStudioNotebooks/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/sageMakerStudioNotebooks/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "sagemakerstudionotebooks"
        ],
        "parentServiceCode": "amazonSageMaker"
    },
    "sageMakerTraining": {
        "name": "SageMaker Training",
        "serviceCode": "sageMakerTraining",
        "description": "With Amazon SageMaker, you pay only for what you use. Building, training, and deploying ML models is billed by the second, with no minimum fees and no upfront commitments.",
        "searchKeywords": [
            "Sagemaker",
            "Model",
            "ML",
            "Machine Learning",
            "EI",
            "data scientist"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "eu-west-1",
            "us-west-1",
            "ap-southeast-1",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-west-2",
            "sa-east-1",
            "ap-southeast-2",
            "eu-central-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "us-east-2",
            "ca-central-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "ap-east-1",
            "me-south-1",
            "eu-south-1",
            "af-south-1"
        ],
        "linkUrl": "https://aws.amazon.com/sagemaker/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/sageMakerTraining/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/sageMakerTraining/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "sagemakertraining"
        ],
        "parentServiceCode": "amazonSageMaker"
    },
    "sentimentAnalysis": {
        "name": "Sentiment Analysis",
        "serviceCode": "sentimentAnalysis",
        "description": "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/sentimentAnalysis/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/sentimentAnalysis/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "sentimentanalysis"
        ],
        "parentServiceCode": "amazonComprehend"
    },
    "locationServiceServiceResources": {
        "name": "Service Resources",
        "serviceCode": "locationServiceServiceResources",
        "description": "Amazon Location Service provides affordable data, tracking and geofencing capabilities, and native integrations with AWS services, so you can create sophisticated location-enabled applications quickly, without the high cost of custom development.",
        "searchKeywords": [
            "Location Service",
            "compromising data security",
            "user privacy",
            "asset tracking",
            "location-based marketing",
            "maps",
            "places",
            "routing",
            "tracking",
            "geofencing",
            "Service Resources"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "eu-north-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/location/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/locationServiceServiceResources/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/locationServiceServiceResources/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "locationserviceserviceresources",
            "serviceresources"
        ],
        "parentServiceCode": "locationService"
    },
    "sftp": {
        "name": "SFTP",
        "serviceCode": "sftp",
        "searchKeywords": [
            "sftp",
            "FTPS",
            "as2",
            "amazon s3",
            "s3",
            "winscp",
            "filezilla",
            "cyberduck",
            "ssh",
            "transfer",
            "ftp",
            "ftp/s",
            "openssh",
            "file transfer",
            "secure file transfer",
            "ssh ftp",
            "secure shell file transfer protocol",
            "file transfer protocol"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-gov-west-1",
            "us-gov-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/aws-transfer-family/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/sftp/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/sftp/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "sftp"
        ],
        "parentServiceCode": "aWSTransferForSFTP"
    },
    "sipTrunking": {
        "name": "SIP Trunking",
        "serviceCode": "sipTrunking",
        "description": "Amazon Chime lets you meet, chat, and collaborate with the security of AWS. You can work seamlessly on your devices, and meet from your desk or on the go - ensuring you always stay connected.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/chime/chime-sdk",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/sipTrunking/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/sipTrunking/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "siptrunking"
        ],
        "parentServiceCode": "amazonChimeSdk"
    },
    "snowballEdgeComputeOptimizedGpuWithEc2ComputeInstances": {
        "name": "Snowball Edge Compute Optimized GPU with EC2 Compute Instances",
        "serviceCode": "snowballEdgeComputeOptimizedGpuWithEc2ComputeInstances",
        "description": "AWS Snowball, a part of the AWS Snow Family, is an edge computing, data migration, and edge storage device that comes in two options.",
        "searchKeywords": [
            "Snow",
            "Snowball",
            "Snowball Edge",
            "Disconnected Data Transfer",
            "Edge Computing",
            "Data Export"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "af-south-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/snowball/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/snowballEdgeComputeOptimizedGpuWithEc2ComputeInstances/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/snowballEdgeComputeOptimizedGpuWithEc2ComputeInstances/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "snowballedgecomputeoptimizedgpuwithec2computeinstances"
        ],
        "parentServiceCode": "awsSnowball"
    },
    "snowballEdgeComputeOptimizedWithEc2ComputeInstances": {
        "name": "Snowball Edge Compute Optimized with EC2 Compute Instances",
        "serviceCode": "snowballEdgeComputeOptimizedWithEc2ComputeInstances",
        "description": "AWS Snowball, a part of the AWS Snow Family, is an edge computing, data migration, and edge storage device that comes in two options.",
        "searchKeywords": [
            "Snow",
            "Snowball",
            "Snowball Edge",
            "Disconnected Data Transfer",
            "Edge Computing",
            "Data Export"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "af-south-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "ca-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/snowball/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/snowballEdgeComputeOptimizedWithEc2ComputeInstances/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/snowballEdgeComputeOptimizedWithEc2ComputeInstances/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "snowballedgecomputeoptimizedwithec2computeinstances"
        ],
        "parentServiceCode": "awsSnowball"
    },
    "snowballEdgeStorageOptimizedDataTransferOnly": {
        "name": "Snowball Edge Storage Optimized Data Transfer Only",
        "serviceCode": "snowballEdgeStorageOptimizedDataTransferOnly",
        "description": "AWS Snowball, a part of the AWS Snow Family, is an edge computing, data migration, and edge storage device that comes in two options.",
        "searchKeywords": [
            "Snow",
            "Snowball",
            "Snowball Edge",
            "Disconnected Data Transfer",
            "Edge Computing",
            "Data Export"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "af-south-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/snowball/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/snowballEdgeStorageOptimizedDataTransferOnly/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/snowballEdgeStorageOptimizedDataTransferOnly/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "snowballedgestorageoptimizeddatatransferonly"
        ],
        "parentServiceCode": "awsSnowball"
    },
    "snowballEdgeStorageOptimizedWithEc2ComputeInstances": {
        "name": "Snowball Edge Storage Optimized with EC2 Compute Instances",
        "serviceCode": "snowballEdgeStorageOptimizedWithEc2ComputeInstances",
        "description": "AWS Snowball, a part of the AWS Snow Family, is an edge computing, data migration, and edge storage device that comes in two options.",
        "searchKeywords": [
            "Snow",
            "Snowball",
            "Snowball Edge",
            "Disconnected Data Transfer",
            "Edge Computing",
            "Data Export"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "af-south-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/snowball/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/snowballEdgeStorageOptimizedWithEc2ComputeInstances/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/snowballEdgeStorageOptimizedWithEc2ComputeInstances/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "snowballedgestorageoptimizedwithec2computeinstances"
        ],
        "parentServiceCode": "awsSnowball"
    },
    "standardBatchTranslation": {
        "name": "Standard Batch Translation",
        "serviceCode": "standardBatchTranslation",
        "description": "Amazon Translate is a neural machine translation service that delivers fast, high-quality, and affordable language translation. Neural machine translation is a form of language translation automation that uses deep learning models to deliver more accurate and more natural sounding translation than traditional statistical and rule-based translation algorithms.",
        "searchKeywords": [
            "NLP",
            "Natural language processing",
            "language transalation",
            "Text analytics",
            "Language translation",
            "Amazon translate",
            "Translate"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "eu-west-1",
            "us-west-2",
            "eu-central-1",
            "ap-northeast-2",
            "us-east-2",
            "eu-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/translate/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/standardBatchTranslation/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/standardBatchTranslation/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "standardbatchtranslation"
        ],
        "parentServiceCode": "amazonTranslate"
    },
    "standardRealTimeTranslation": {
        "name": "Standard Real-Time Translation",
        "serviceCode": "standardRealTimeTranslation",
        "description": "Amazon Translate is a neural machine translation service that delivers fast, high-quality, and affordable language translation. Neural machine translation is a form of language translation automation that uses deep learning models to deliver more accurate and more natural sounding translation than traditional statistical and rule-based translation algorithms.",
        "searchKeywords": [
            "NLP",
            "Natural language processing",
            "language transalation",
            "Text analytics",
            "Language translation",
            "Amazon translate",
            "Translate"
        ],
        "type": "AWSService",
        "regions": [
            "us-east-1",
            "eu-west-1",
            "us-west-1",
            "ap-southeast-1",
            "ap-northeast-1",
            "us-gov-west-1",
            "us-west-2",
            "ap-southeast-2",
            "eu-central-1",
            "ap-northeast-2",
            "ap-south-1",
            "us-east-2",
            "ca-central-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "ap-east-1"
        ],
        "linkUrl": "https://aws.amazon.com/translate/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/standardRealTimeTranslation/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/standardRealTimeTranslation/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "standardrealtimetranslation"
        ],
        "parentServiceCode": "amazonTranslate"
    },
    "standardTextToSpeechTts": {
        "name": "Standard Text-to-Speech",
        "serviceCode": "standardTextToSpeechTts",
        "description": "Amazon Polly is a service that turns text into lifelike speech, allowing you to create applications that talk, and build entirely new categories of speech-enabled products.",
        "searchKeywords": [
            "polly",
            "NLP",
            "speech"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/polly/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/standardTextToSpeechTts/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/standardTextToSpeechTts/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "standardtexttospeech",
            "standardtexttospeechtts"
        ],
        "parentServiceCode": "amazonPolly"
    },
    "standardTopics": {
        "name": "Standard topics",
        "serviceCode": "standardTopics",
        "description": "Amazon Simple Notification Service (SNS) is a highly available, durable, secure, fully managed pub/sub messaging service that enables you to decouple microservices, distributed systems, and serverless applications",
        "searchKeywords": [
            "Messaging",
            "SNS",
            "notification topic",
            "publish message",
            "subscription",
            "text message",
            "sms",
            "topics",
            "push notifications",
            "push notification service queuing"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2",
            "me-south-1",
            "me-central-1"
        ],
        "linkUrl": "https://aws.amazon.com/sns/pricing/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/standardTopics/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/standardTopics/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "standardtopics"
        ],
        "parentServiceCode": "amazonSimpleNotificationService"
    },
    "stepFunctionExpress": {
        "name": "Step Functions - Express Workflows",
        "serviceCode": "stepFunctionExpress",
        "description": "AWS Step Functions is a serverless function orchestrator that makes it easy to sequence AWS Lambda functions and multiple AWS services into business-critical applications.",
        "searchKeywords": [
            "workflows",
            " workflow",
            " orchestrator",
            " orchestration",
            " serverless",
            " state machine",
            " State Machines",
            " States",
            " State",
            " Microservices",
            " application integration",
            " Amazon States Language",
            " ASL",
            " Data Science SDK",
            " data processing",
            " API orchestration",
            " DAG",
            " DAGs",
            " Step Functions",
            " Step Function",
            " Step",
            " media processing",
            " application orchestration",
            " serverless orchestration",
            " serverless workflow",
            " lambda orchestration",
            " serverless state machine",
            " asynchronous",
            " synchronous",
            " event-driven data processing",
            " event-driven",
            " event orchestration",
            " standard workflows",
            " standard workflow",
            " express workflow",
            " express workflows",
            " standard workflows",
            " error handling",
            " service integrations",
            " state management",
            " visual workflow",
            " visual monitoring",
            " high volume orchestration",
            " function",
            " functions",
            " machine learning workflow",
            " machine learning workflows",
            " JSON",
            " serverless workflows",
            " serverless workflow",
            " Business logic",
            " complex workflows",
            " data pipeline",
            " data processing",
            " decoupling",
            " decouple applications",
            " abstraction",
            " abstraction layer",
            " automation",
            " It automation",
            " connecting aws services",
            " integration of aws services",
            " coordinating AWS services",
            " managed workflows",
            " call back patterns",
            " callback pattern",
            " callback patterns",
            " call back pattern",
            " human approval",
            " manual approval",
            " human intervention",
            " EKS orchestration",
            " container orchestration",
            " short duration workflows",
            " long duration workflows",
            " short-duration workflows",
            " short-duration workflow",
            " long-running workflow",
            " long-running workflows",
            " machine-learning workflows",
            " ML workflows",
            " ML workflow",
            " API orchestration",
            " function",
            " functions",
            " compute function",
            " compute functions",
            " Lambda retry",
            " Lambda retries",
            " serverless compute",
            " parallel processing",
            " Lambda chaining",
            " error-handling",
            " retries",
            " saga pattern",
            " nested",
            " branching",
            " nesting",
            " nested pattern",
            " branching pattern",
            " nesting pattern",
            " serverless patterns",
            " event-driven patterns",
            " coordinating workflows"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/stepFunctionExpress/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/stepFunctionExpress/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "stepfunctionexpress",
            "stepfunctionsexpressworkflows"
        ],
        "parentServiceCode": "awsStepFunctions"
    },
    "stepFunctionStandard": {
        "name": "Step Functions - Standard Workflows",
        "serviceCode": "stepFunctionStandard",
        "description": "AWS Step Functions is a serverless function orchestrator that makes it easy to sequence AWS Lambda functions and multiple AWS services into business-critical applications.",
        "searchKeywords": [
            "workflows",
            " workflow",
            " orchestrator",
            " orchestration",
            " serverless",
            " state machine",
            " State Machines",
            " States",
            " State",
            " Microservices",
            " application integration",
            " Amazon States Language",
            " ASL",
            " Data Science SDK",
            " data processing",
            " API orchestration",
            " DAG",
            " DAGs",
            " Step Functions",
            " Step Function",
            " Step",
            " media processing",
            " application orchestration",
            " serverless orchestration",
            " serverless workflow",
            " lambda orchestration",
            " serverless state machine",
            " asynchronous",
            " synchronous",
            " event-driven data processing",
            " event-driven",
            " event orchestration",
            " standard workflows",
            " standard workflow",
            " express workflow",
            " express workflows",
            " standard workflows",
            " error handling",
            " service integrations",
            " state management",
            " visual workflow",
            " visual monitoring",
            " high volume orchestration",
            " function",
            " functions",
            " machine learning workflow",
            " machine learning workflows",
            " JSON",
            " serverless workflows",
            " serverless workflow",
            " Business logic",
            " complex workflows",
            " data pipeline",
            " data processing",
            " decoupling",
            " decouple applications",
            " abstraction",
            " abstraction layer",
            " automation",
            " It automation",
            " connecting aws services",
            " integration of aws services",
            " coordinating AWS services",
            " managed workflows",
            " call back patterns",
            " callback pattern",
            " callback patterns",
            " call back pattern",
            " human approval",
            " manual approval",
            " human intervention",
            " EKS orchestration",
            " container orchestration",
            " short duration workflows",
            " long duration workflows",
            " short-duration workflows",
            " short-duration workflow",
            " long-running workflow",
            " long-running workflows",
            " machine-learning workflows",
            " ML workflows",
            " ML workflow",
            " API orchestration",
            " function",
            " functions",
            " compute function",
            " compute functions",
            " Lambda retry",
            " Lambda retries",
            " serverless compute",
            " parallel processing",
            " Lambda chaining",
            " error-handling",
            " retries",
            " saga pattern",
            " nested",
            " branching",
            " nesting",
            " nested pattern",
            " branching pattern",
            " nesting pattern",
            " serverless patterns",
            " event-driven patterns",
            " coordinating workflows"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/stepFunctionStandard/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/stepFunctionStandard/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "stepfunctionsstandardworkflows",
            "stepfunctionstandard"
        ],
        "parentServiceCode": "awsStepFunctions"
    },
    "amazonStorageGatewayBackup": {
        "name": "Storage Gateway",
        "serviceCode": "amazonStorageGatewayBackup",
        "description": "AWS Backup for Storage Gateway",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/backup/",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonStorageGatewayBackup/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonStorageGatewayBackup/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "backupstoragegateway",
            "storagegatewaybackup"
        ],
        "parentServiceCode": "awsBackup"
    },
    "syntaxAnalysis": {
        "name": "Syntax Analysis",
        "serviceCode": "syntaxAnalysis",
        "description": "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/syntaxAnalysis/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/syntaxAnalysis/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "syntaxanalysis"
        ],
        "parentServiceCode": "amazonComprehend"
    },
    "targetedSentiment": {
        "name": "Targeted Sentiment",
        "serviceCode": "targetedSentiment",
        "description": "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics",
            "Targeted Sentiment"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/targetedSentiment/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/targetedSentiment/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "targetedsentiment"
        ],
        "parentServiceCode": "amazonComprehend"
    },
    "comprehendTopicModeling": {
        "name": "Topic Modeling",
        "serviceCode": "comprehendTopicModeling",
        "description": "With Amazon Comprehend, you only pay for what you use. You are charged based on the amount of text processed on a monthly basis. Amazon Comprehend provides natural language processing, topic modeling, and Custom Classification capabilities, enabling a broad range of applications that can analyze text.",
        "searchKeywords": [
            "Comprehend",
            "NLP",
            "Natural language processing",
            "Sentiment analysis",
            "Text analytics",
            "Entity extraction",
            "Named entity recognition",
            "NER",
            "Key phrase extraction",
            "Topic modeling",
            "Unsupervised clustering",
            "Supervised machine learning",
            "Custom entity recognition",
            "Custom classification",
            "Document classifier",
            "Personally identifiable information",
            "PII",
            "Redaction",
            "Language detection",
            "Free form text analytics"
        ],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "ap-south-1",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/comprehendTopicModeling/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/comprehendTopicModeling/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "comprehendtopicmodeling",
            "topicmodeling"
        ],
        "parentServiceCode": "amazonComprehend"
    },
    "locationServiceTracking": {
        "name": "Tracking",
        "serviceCode": "locationServiceTracking",
        "description": "Amazon Location Service provides affordable data, tracking and geofencing capabilities, and native integrations with AWS services, so you can create sophisticated location-enabled applications quickly, without the high cost of custom development.",
        "searchKeywords": [
            "Location Service",
            "compromising data security",
            "user privacy",
            "asset tracking",
            "location-based marketing",
            "maps",
            "places",
            "routing",
            "tracking",
            "geofencing",
            "Service Resources"
        ],
        "type": "AWSService",
        "regions": [
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-northeast-1",
            "eu-central-1",
            "eu-west-1",
            "eu-north-1",
            "us-east-1",
            "us-east-2",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/location/",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/locationServiceTracking/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/locationServiceTracking/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "locationservicetracking",
            "tracking"
        ],
        "parentServiceCode": "locationService"
    },
    "trafficMirroringVpc": {
        "name": "Traffic Mirroring",
        "serviceCode": "trafficMirroringVpc",
        "description": "WS Virtual Private Network solutions establish secure connections between your on-premises networks, remote offices, client devices, and the AWS global network. AWS VPN is comprised of two services: AWS Site-to-Site VPN and AWS Client VPN. Each service provides a highly-available, managed, and elastic cloud VPN solution to protect your network traffic.",
        "searchKeywords": [
            "access control",
            "ACL",
            "AWS Privatelink",
            "Cloud connectivity",
            "corporate network",
            "elastic IP",
            "Gateway load balancer",
            "home network VPN",
            "IPAM",
            "NAT",
            "NAT gateway",
            "Network Access Analyzer",
            "Network Address Translation",
            "Networking Content Delivery",
            "PrivateLink",
            "Reachability Analyzer",
            "security",
            "single tenant hardware",
            "static ip",
            "subnets",
            "Traffic mirroring",
            "Transit Gateway",
            "Virtual Private Cloud",
            "VPN"
        ],
        "type": "AWSService",
        "regions": [
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/trafficMirroringVpc/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/trafficMirroringVpc/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "trafficmirroring",
            "trafficmirroringvpc"
        ],
        "parentServiceCode": "amazonVirtualPrivateCloud"
    },
    "transitGatewayVpc": {
        "name": "Transit Gateway",
        "serviceCode": "transitGatewayVpc",
        "description": "AWS Transit Gateway connects VPCs and on-premises networks through a central hub. This simplifies your network and puts an end to complex peering relationships. It acts as a cloud router – each new connection is only made once.",
        "searchKeywords": [
            "Transit Gateway"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/transitGatewayVpc/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/transitGatewayVpc/en_US.json",
        "slug": "transitgatewayvpc",
        "mvpSupport": false,
        "comparableTerms": [
            "transitgateway",
            "transitgatewayvpc"
        ],
        "parentServiceCode": "amazonVirtualPrivateCloud"
    },
    "amazonVMwareBackup": {
        "name": "VMware",
        "serviceCode": "amazonVMwareBackup",
        "description": "AWS Backup for VMware",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "us-gov-west-1",
            "us-gov-east-1",
            "af-south-1",
            "ap-east-1",
            "ap-south-1",
            "ap-northeast-3",
            "ap-northeast-2",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ap-northeast-1",
            "ca-central-1",
            "eu-central-1",
            "eu-west-1",
            "eu-west-2",
            "eu-south-1",
            "eu-west-3",
            "eu-north-1",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/backup/",
        "isActive": "true",
        "hasDataTransfer": true,
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/amazonVMwareBackup/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/amazonVMwareBackup/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "backupvmware",
            "vmwarebackup"
        ],
        "parentServiceCode": "awsBackup"
    },
    "vpnConnectionVpc": {
        "name": "VPN Connection",
        "serviceCode": "vpnConnectionVpc",
        "description": "WS Virtual Private Network solutions establish secure connections between your on-premises networks, remote offices, client devices, and the AWS global network. AWS VPN is comprised of two services: AWS Site-to-Site VPN and AWS Client VPN. Each service provides a highly-available, managed, and elastic cloud VPN solution to protect your network traffic.",
        "searchKeywords": [
            "access control",
            "ACL",
            "AWS Privatelink",
            "Cloud connectivity",
            "corporate network",
            "elastic IP",
            "Gateway load balancer",
            "home network VPN",
            "IPAM",
            "NAT",
            "NAT gateway",
            "Network Access Analyzer",
            "Network Address Translation",
            "Networking Content Delivery",
            "PrivateLink",
            "Reachability Analyzer",
            "security",
            "single tenant hardware",
            "static ip",
            "subnets",
            "Traffic mirroring",
            "Transit Gateway",
            "Virtual Private Cloud",
            "VPN"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ap-southeast-3",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "me-central-1",
            "sa-east-1",
            "us-east-1",
            "us-east-2",
            "us-west-1",
            "us-west-2",
            "us-gov-east-1",
            "us-gov-west-1"
        ],
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/vpnConnectionVpc/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/vpnConnectionVpc/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "vpnconnection",
            "vpnconnectionvpc"
        ],
        "parentServiceCode": "amazonVirtualPrivateCloud"
    },
    "webRtcMedia": {
        "name": "WebRTC Media",
        "serviceCode": "webRtcMedia",
        "description": "Amazon Chime lets you meet, chat, and collaborate with the security of AWS. You can work seamlessly on your devices, and meet from your desk or on the go - ensuring you always stay connected.",
        "searchKeywords": [],
        "type": "AWSService",
        "regions": [
            "ap-southeast-1",
            "us-gov-east-1",
            "us-gov-west-1",
            "eu-central-1",
            "us-east-1",
            "us-west-2"
        ],
        "linkUrl": "https://aws.amazon.com/chime/chime-sdk",
        "isActive": "true",
        "subType": "subService",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/webRtcMedia/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/webRtcMedia/en_US.json",
        "mvpSupport": false,
        "comparableTerms": [
            "webrtcmedia"
        ],
        "parentServiceCode": "amazonChimeSdk"
    },
    "windowsWorkloads": {
        "name": "Windows Server and SQL Server on Amazon EC2",
        "serviceCode": "windowsWorkloads",
        "description": "The Windows Server and SQL Server on Amazon EC2 calculator provides a pricing estimate for specific workloads. It recommends suitable cloud deployment options and cost-saving pricing models based on licensing and infrastructure inputs.",
        "searchKeywords": [
            "EC2",
            "Windows",
            "SQL",
            "Microsoft",
            "Compute",
            "VM",
            "Database",
            "migration",
            "msft",
            "olap",
            "oltp",
            "Win",
            "DB",
            "MS",
            "DW",
            "Data Warehouse",
            "SSIS",
            "SSAS",
            "SSRS",
            "ODS"
        ],
        "type": "AWSService",
        "regions": [
            "af-south-1",
            "ap-east-1",
            "ap-northeast-1",
            "ap-northeast-2",
            "ap-northeast-3",
            "ap-south-1",
            "ap-southeast-1",
            "ap-southeast-2",
            "ca-central-1",
            "eu-central-1",
            "eu-north-1",
            "eu-south-1",
            "eu-west-1",
            "eu-west-2",
            "eu-west-3",
            "me-south-1",
            "sa-east-1",
            "us-east-1-bos-1",
            "us-east-1-iah-1",
            "us-east-1-mia-1",
            "us-east-1",
            "us-east-2",
            "us-gov-east-1",
            "us-gov-west-1",
            "us-west-1",
            "us-west-2",
            "us-west-2-lax-1",
            "us-east-1-wl1-atl1",
            "us-east-1-wl1-dfw1",
            "us-east-1-wl1-mia1",
            "us-east-1-wl1-nyc1",
            "us-east-1-wl1-was1",
            "us-west-2-wl1",
            "us-west-2-wl1-las1",
            "us-east-1-wl1"
        ],
        "linkUrl": "https://aws.amazon.com/windows/",
        "isActive": "true",
        "disableConfigure": false,
        "serviceDefinitionLocation": "https://d1qsjq9pzbk1k6.cloudfront.net/data/windowsWorkloads/en_US.json",
        "c2e": false,
        "templates": [],
        "disableRegionSupport": false,
        "serviceDefinitionUrlPath": "/data/windowsWorkloads/en_US.json",
        "slug": "EC2WinSQL",
        "mvpSupport": false,
        "comparableTerms": [
            "ec2winsql",
            "windows",
            "windowsserversqlserveronec2",
            "windowsworkloads"
        ]
    }
};
exports.PRICING_SLUGS = [
    "appmigrationsvc",
    "APIGateway",
    "Appflow",
    "AppStream",
    "Athena",
    "a2i",
    "AuroraMySQL",
    "AuroraPostgreSQL",
    "Braket",
    "CarrierIP",
    "Chime",
    "ChimeSDK",
    "CloudFront",
    "CloudWatch",
    "CodeGuruReviewer",
    "CodeGuruReviewerv2",
    "codewhisperer",
    "Cognito",
    "Comprehend",
    "ComprehendMedical",
    "detective",
    "DevOpsGuru",
    "DocumentDB",
    "DynamoDB",
    "EC2",
    "ec2-enhancement",
    "EC2DedicatedHosts",
    "EKS",
    "EBS",
    "ECR",
    "EFS",
    "ElasticGraphics",
    "ElasticIP",
    "ElasticTranscoder",
    "ElastiCache",
    "EMR",
    "eventbridge",
    "filecache",
    "FinSpace",
    "forecast",
    "frauddetector",
    "FSxForLustre",
    "FSxForNetAppOntap",
    "FSxForOpenZFS",
    "FSx",
    "GameLift",
    "guardduty",
    "HealthLake",
    "Inspector",
    "Kendra",
    "keyspaces",
    "KinesisDataFirehose",
    "KinesisDataStreams",
    "KinesisVideoStreams",
    "lex",
    "Lightsail",
    "LocationService",
    "lookoutforequipment",
    "LookoutForMetrics",
    "LookoutVision",
    "Macie",
    "ManagedBlockchain",
    "grafana",
    "KinesisDataAnalytics",
    "Prometheus",
    "MSK",
    "MWAA",
    "memorydb",
    "MQ",
    "neptune",
    "omics",
    "OpenSearchService",
    "personalize",
    "Pinpoint",
    "polly",
    "qldb",
    "QuickSight",
    "RDSCustomForOracle",
    "RDSCustomForSQLServer",
    "RDSMariaDB",
    "RDSMySQL",
    "amazonRDSOracle",
    "RDSPostgreSQL",
    "RDSSQLServer",
    "RDSOutposts",
    "Redshift",
    "Rekognition",
    "Route53",
    "SageMaker",
    "SageMakerGroundTruth",
    "SES",
    "SNS",
    "SQS",
    "S3",
    "SWF",
    "Textract",
    "AmazonTimestream",
    "Transcribe",
    "TranscribeMedical",
    "Translate",
    "VPC",
    "WorkDocs",
    "WorkMail",
    "WorkSpaces",
    "Amplify",
    "apprunner",
    "appfabric",
    "appSync",
    "Backup",
    "billingconductor",
    "budgets",
    "CloudMap",
    "CloudFormation",
    "CloudHSM",
    "CloudTrail",
    "CodeArtifact",
    "codebuild",
    "codecommit",
    "CodeDeploy",
    "CodePipeline",
    "Config",
    "cost-explorer",
    "datapipeline",
    "DataTransfer",
    "DMS",
    "DataSync",
    "DeepRacer",
    "DeviceFarm",
    "DirectConnect",
    "DirectoryService",
    "ElasticDisasterRecovery",
    "ElementalMediaTailor",
    "ElementalMediaConnect",
    "ElementalMediaLive",
    "ElementalMediaPackage",
    "EntityResolution",
    "Fargate",
    "faultinjectorsimulator",
    "firewallManager",
    "Glue",
    "healthimaging",
    "iot-analytics",
    "IoTCore",
    "IoTDeviceDefender",
    "IoTDeviceManagement",
    "iot-events",
    "greengrass",
    "IoTThingsGraph",
    "KMS",
    "LakeFormation",
    "Lambda",
    "mainframeModernization",
    "migration-hub",
    "MDC",
    "networkfirewall",
    "Outposts",
    "paymentcryptography",
    "certificateManager",
    "resiliencehub",
    "SecretsManager",
    "securityHub",
    "servicecatalog",
    "shield",
    "simspaceweaver",
    "Snowball",
    "Snowmobile",
    "StepFunctions",
    "StorageGateway",
    "supplyChain",
    "SystemsManager",
    "TelcoNetworkBuilder",
    "TransferFamily",
    "WAF",
    "wickr",
    "xray",
    "cloudwan",
    "ElasticLoadBalancing",
    "geospatialML",
    "transitgatewayvpc",
    "EC2WinSQL"
];
//# sourceMappingURL=data:application/json;base64,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