"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseAssetPath = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const contants_1 = require("../../contants");
const definitions_1 = require("../categories/definitions");
/** Parse asset key into parts */
function parseAssetPath(assetPath) {
    if (assetPath.endsWith(contants_1.CATEGORY_ICON)) {
        const [category] = assetPath.split("/");
        return { assetKey: assetPath, category, basename: contants_1.CATEGORY_ICON };
    }
    if (assetPath.endsWith(contants_1.SERVICE_ICON)) {
        const [category, service] = assetPath.split("/");
        return { assetKey: assetPath, category, service, basename: contants_1.SERVICE_ICON };
    }
    if (assetPath.startsWith(definitions_1.AwsCategoryDefinitions.general.id)) {
        const [, basename] = assetPath.split("/");
        return {
            assetKey: assetPath,
            category: definitions_1.AwsCategoryDefinitions.general.id,
            basename,
        };
    }
    if (assetPath.startsWith("compute/ec2/instance/")) {
        const [category, service, instanceDir, instanceType] = assetPath.split("/");
        return {
            assetKey: assetPath,
            category,
            service,
            instanceType,
            basename: instanceDir + "/" + instanceType,
        };
    }
    if (assetPath.startsWith("internet_of_things/thing/")) {
        const [category, service, thingDir, iotThing] = assetPath.split("/");
        return {
            assetKey: assetPath,
            category,
            service,
            iotThing,
            basename: thingDir + "/" + iotThing,
        };
    }
    const [category, service, basename] = assetPath.split("/");
    const resource = `${service}_${basename}`;
    return { assetKey: assetPath, category, service, resource, basename };
}
exports.parseAssetPath = parseAssetPath;
//# sourceMappingURL=data:application/json;base64,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