"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.drawioStyleObjectToString = exports.DRAWIO_RESOURCE_STYLE_BASE = exports.DrawioAws4ParentShapes = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
/** Draiwio aws4 parent shapes enum */
var DrawioAws4ParentShapes;
(function (DrawioAws4ParentShapes) {
    DrawioAws4ParentShapes["RESOURCE_ICON"] = "mxgraph.aws4.resourceIcon";
})(DrawioAws4ParentShapes || (exports.DrawioAws4ParentShapes = DrawioAws4ParentShapes = {}));
/** Base drawio aws resource style */
exports.DRAWIO_RESOURCE_STYLE_BASE = {
    outlineConnect: 0,
    gradientDirection: "north",
    strokeColor: "#ffffff",
    dashed: 0,
    verticalLabelPosition: "bottom",
    verticalAlign: "top",
    align: "center",
    html: 1,
    fontSize: 12,
    fontStyle: 0,
    aspect: "fixed",
};
/** Convert drawio style object to style string */
function drawioStyleObjectToString(styleObject) {
    return Object.entries(styleObject)
        .map(([key, value]) => `${key}=${value};`)
        .join("");
}
exports.drawioStyleObjectToString = drawioStyleObjectToString;
//# sourceMappingURL=data:application/json;base64,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