"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DarkTheme = exports.DarkPalette = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const palette_1 = require("./palette");
/** Dark theme color palette */
var DarkPalette;
(function (DarkPalette) {
    DarkPalette["PUBLIC"] = "#E9F3E6";
    DarkPalette["PRIVATE"] = "#E6F2F8";
    DarkPalette["GENERIC"] = "#FAFAFA33";
    DarkPalette["PRIMARY"] = "#FAFAFA";
    DarkPalette["SECONDARY"] = "#5B9BD5";
    DarkPalette["TERTIARY"] = "#8FA7C4";
})(DarkPalette || (exports.DarkPalette = DarkPalette = {}));
/** Dark theme definition */
exports.DarkTheme = {
    id: "dark",
    backgrounds: {
        base: palette_1.BasePalette.DARK_BLUE,
        private: DarkPalette.PRIVATE,
        public: DarkPalette.PUBLIC,
        generic: DarkPalette.GENERIC,
    },
    text: {
        default: palette_1.BasePalette.WHITE,
        primary: DarkPalette.PRIMARY,
        secondary: DarkPalette.SECONDARY,
        tertiary: DarkPalette.TERTIARY,
    },
    groups: {
        cloud: {
            color: "#FAFAFA",
            bgcolor: false,
            borderColor: "#FAFAFA",
            borderStyle: "solid",
            iconPng: "theme/light/groups/AWSCloud.png",
        },
        cloudAlt: {
            color: "#FAFAFA",
            bgcolor: false,
            borderColor: "#FAFAFA",
            borderStyle: "solid",
            iconPng: "theme/light/groups/Cloud.png",
        },
        region: {
            color: "#00A0C8",
            bgcolor: false,
            borderColor: "#00A0C8",
            borderStyle: "dotted",
            iconPng: "theme/light/groups/Region.png",
        },
        availabilityZone: {
            color: "#00A0C8",
            bgcolor: false,
            borderColor: "#00A0C8",
            borderStyle: "dashed",
        },
        securityGroup: {
            color: "#FC584C",
            bgcolor: false,
            borderColor: "#FC584C",
            borderStyle: "solid",
        },
        autoScalingGroup: {
            color: "#D86613",
            bgcolor: false,
            borderColor: "#D86613",
            borderStyle: "dashed",
            iconPng: "theme/light/groups/AutoScalingGroup.png",
        },
        vpc: {
            color: "#69AE35",
            bgcolor: false,
            borderColor: "#69AE35",
            borderStyle: "solid",
            iconPng: "theme/light/groups/VPC.png",
        },
        privateSubnet: {
            color: "#127EBA",
            bgcolor: false,
            borderColor: "#127EBA",
            borderStyle: "none",
            iconPng: "theme/light/groups/PrivateSubnet.png",
        },
        publicSubnet: {
            color: "#69AE35",
            bgcolor: false,
            borderColor: "#69AE35",
            borderStyle: "none",
            iconPng: "theme/light/groups/PublicSubnet.png",
        },
        serverContents: {
            color: "#8FA7C4",
            bgcolor: false,
            borderColor: "#8FA7C4",
            borderStyle: "solid",
            iconPng: "theme/light/groups/ServerContents.png",
        },
        corporateDataCenter: {
            color: "#8FA7C4",
            bgcolor: false,
            borderColor: "#8FA7C4",
            borderStyle: "solid",
            iconPng: "theme/light/groups/CorporateDataCenter.png",
        },
        ec2InstanceContents: {
            color: "#FF9900",
            bgcolor: false,
            borderColor: "#FF9900",
            borderStyle: "solid",
            iconPng: "theme/light/groups/EC2InstanceContents.png",
        },
        spotFleet: {
            color: "#FF9900",
            bgcolor: false,
            borderColor: "#FF9900",
            borderStyle: "solid",
            iconPng: "theme/light/groups/SpotFleet.png",
        },
        awsAccount: {
            color: "#B0084D",
            bgcolor: false,
            borderColor: "#B0084D",
            borderStyle: "solid",
            iconPng: "theme/light/groups/AWSAccount.png",
        },
        awsIoTGreengrassDeployment: {
            color: "#3F8624",
            bgcolor: false,
            borderColor: "#3F8624",
            borderStyle: "solid",
            iconPng: "theme/light/groups/AWSIoTGreengrassDeployment.png",
        },
        awsIoTGreengrass: {
            color: "#3F8624",
            bgcolor: false,
            borderColor: "#3F8624",
            borderStyle: "solid",
            iconPng: "theme/light/groups/AWSIoTGreengrass.png",
        },
        elasticBeanstalkContainer: {
            color: "#FF9900",
            bgcolor: false,
            borderColor: "#FF9900",
            borderStyle: "solid",
            iconPng: "theme/light/groups/ElasticBeanstalkContainer.png",
        },
        awsStepFunctionsWorkflow: {
            color: "#FF4F8B",
            bgcolor: false,
            borderColor: "#FF4F8B",
            borderStyle: "solid",
            iconPng: "theme/light/groups/AWSStepFunctionsWorkflow.png",
        },
        generic: {
            color: "#8FA7C4",
            bgcolor: "magenta",
            borderColor: "#8FA7C4",
            borderStyle: "dashed",
        },
        genericAlt: {
            color: "#FAFAFACC",
            bgcolor: "#FAFAFA33",
            borderColor: false,
            borderStyle: "none",
        },
    },
    arrows: {
        default: {
            color: DarkPalette.GENERIC,
            head: "none",
            tail: "normal",
            width: 0.75,
            style: "solid",
        },
        child: {
            color: DarkPalette.TERTIARY,
            tail: "none",
            head: "normal",
            width: 1,
            style: "solid",
        },
        reference: {
            color: DarkPalette.TERTIARY,
            head: "none",
            tail: "normal",
            width: 0.75,
            style: "solid",
        },
        dependency: {
            color: DarkPalette.SECONDARY,
            tail: "normal",
            head: "odot",
            width: 0.75,
            style: "dotted",
        },
    },
};
//# sourceMappingURL=data:application/json;base64,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