"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FONT_CSS_CLASSES = exports.GraphFonts = exports.FONT_STYLESHEET = exports.FONT_FAMILY = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
/**
 * Graph font family
 * @internal
 */
exports.FONT_FAMILY = "Roboto Condensed";
var FontWeights;
(function (FontWeights) {
    FontWeights[FontWeights["LIGHT"] = 300] = "LIGHT";
    FontWeights[FontWeights["REGULAR"] = 400] = "REGULAR";
    FontWeights[FontWeights["BOLD"] = 700] = "BOLD";
})(FontWeights || (FontWeights = {}));
var FontStyles;
(function (FontStyles) {
    FontStyles["NORMAL"] = "normal";
    FontStyles["ITALIC"] = "italic";
})(FontStyles || (FontStyles = {}));
/**
 * Graph font stylesheet
 * @internal
 */
exports.FONT_STYLESHEET = "https://fonts.googleapis.com/css2?family=Roboto+Condensed:wght@300;400;700&display=swap";
function fontClassName(weight, style) {
    if (style === "NORMAL") {
        return `font_${weight.toLowerCase()}`;
    }
    return `font_${weight.toLowerCase()}_${style.toLowerCase()}`;
}
function defineGraphFont(weight, style) {
    return {
        fontname: exports.FONT_FAMILY,
        class: fontClassName(weight, style),
    };
}
/**
 * Graph fonts
 * @internal
 */
exports.GraphFonts = {
    LIGHT: defineGraphFont("LIGHT", "NORMAL"),
    LIGHT_ITALIC: defineGraphFont("LIGHT", "ITALIC"),
    REGULAR: defineGraphFont("REGULAR", "NORMAL"),
    REGULAR_ITALIC: defineGraphFont("REGULAR", "ITALIC"),
    BOLD: defineGraphFont("BOLD", "NORMAL"),
    BOLD_ITALIC: defineGraphFont("BOLD", "ITALIC"),
};
/**
 * Graph font css style classes
 * @internal
 */
exports.FONT_CSS_CLASSES = Object.keys(exports.GraphFonts).reduce((_css, _fontKey) => {
    const [_weightKey, _styleKey = "NORMAL"] = _fontKey.split("_");
    const _className = fontClassName(_weightKey, _styleKey);
    const _weight = FontWeights[_weightKey];
    const _style = FontStyles[_styleKey];
    return (_css +
        `\n.${_className} { font-family: "${exports.FONT_FAMILY}", sans-serif; font-style: ${_style}; font-weight: ${_weight}; }`);
}, "");
//# sourceMappingURL=data:application/json;base64,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