"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Counter = void 0;
/**
 * Counter class provides utils for adding/subtracting key based counts.
 *
 * For example, you can create a counter to track number of each CfnResourceType based on resource type key.
 *
 * @internal
 */
class Counter {
    constructor() {
        /** @internal */
        this._counts = new Map();
    }
    /** Gets record of keyed counts */
    get counts() {
        return Object.fromEntries(this._counts);
    }
    /** Increment key count by 1 */
    add(key) {
        const count = (this._counts.get(key) || 0) + 1;
        this._counts.set(key, count);
        return count;
    }
    /** Decrement key count by 1 */
    subtract(key) {
        const count = (this._counts.get(key) || 0) - 1;
        if (count < 0) {
            throw new Error(`Attempt to subtract count from zero`);
        }
        this._counts.set(key, count);
        return count;
    }
    /** Gets the current count for given key */
    getCount(key) {
        return this._counts.get(key) || 0;
    }
}
exports.Counter = Counter;
//# sourceMappingURL=data:application/json;base64,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