import { TypeSafeApiProject } from "../type-safe-api";
import { ReactTypeScriptProject } from "projen/lib/web";
import { ReactTypeScriptProjectOptions } from "./react-ts-project-options";
/**
 * Configuration options for the CloudscapeReactTsWebsiteProject.
 */
export interface CloudscapeReactTsWebsiteProjectOptions extends ReactTypeScriptProjectOptions {
    /**
     * Name of the application name.
     *
     * @default "Sample App"
     */
    readonly applicationName?: string;
    /**
     * Public directory.
     *
     * @default "public"
     */
    readonly publicDir?: string;
    /**
     * TypeSafeApi instance to use when setting up the initial project sample code.
     * @deprecated use typeSafeApis
     */
    readonly typeSafeApi?: TypeSafeApiProject;
    /**
     * TypeSafeApi instances to use when setting up the initial project sample code.
     */
    readonly typeSafeApis?: TypeSafeApiProject[];
}
/**
 * Synthesizes a Cloudscape React Typescript Website Project.
 *
 * @pjid cloudscape-react-ts-website
 */
export declare class CloudscapeReactTsWebsiteProject extends ReactTypeScriptProject {
    readonly applicationName: string;
    readonly publicDir: string;
    readonly typeSafeApis?: TypeSafeApiProject[];
    constructor(options: CloudscapeReactTsWebsiteProjectOptions);
    private setupSwaggerUi;
    private buildSampleDirEntries;
}
