import { CloudscapeReactTsWebsiteProject } from "../../../cloudscape-react-ts-website";
import { TypeSafeApiProject } from "../../../type-safe-api";
import { AwsCdkPythonApp } from "projen/lib/awscdk";
import { AwsCdkPythonAppOptions } from "./aws-cdk-py-app-options";
/**
 * Configuration options for the InfrastructurePyProject.
 */
export interface InfrastructurePyProjectOptions extends AwsCdkPythonAppOptions {
    /**
     * Stack name.
     *
     * @default infra-dev
     */
    readonly stackName?: string;
    /**
     * TypeSafeApi instance to use when setting up the initial project sample code.
     * @deprecated use typeSafeApis
     */
    readonly typeSafeApi?: TypeSafeApiProject;
    /**
     * CloudscapeReactTsWebsiteProject instance to use when setting up the initial project sample code.
     * @deprecated use cloudscapeReactTsWebsites
     */
    readonly cloudscapeReactTsWebsite?: CloudscapeReactTsWebsiteProject;
    /**
     * TypeSafeApi instances to use when setting up the initial project sample code.
     */
    readonly typeSafeApis?: TypeSafeApiProject[];
    /**
     * CloudscapeReactTsWebsiteProject instances to use when setting up the initial project sample code.
     */
    readonly cloudscapeReactTsWebsites?: CloudscapeReactTsWebsiteProject[];
}
/**
 * Synthesizes a Infrastructure Python Project.
 */
export declare class InfrastructurePyProject extends AwsCdkPythonApp {
    constructor(options: InfrastructurePyProjectOptions);
    private generateTypeSafeMustacheConfig;
    private capitalize;
    private emitSampleFiles;
}
