"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MonorepoJavaProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const fs = require("fs");
const path = require("path");
const projen_1 = require("projen");
const java_1 = require("projen/lib/java");
const nx_configurator_1 = require("../../components/nx-configurator");
const projen_dependency_1 = require("../../components/projen-dependency");
const MVN_PLUGIN_PATH = "./.nx/plugins/nx_plugin.js";
/**
 * This project type will bootstrap a NX based monorepo with support for polygot
 * builds, build caching, dependency graph visualization and much more.
 *
 * @pjid monorepo-java
 */
class MonorepoJavaProject extends java_1.JavaProject {
    constructor(options) {
        super({
            ...options,
            sample: false,
            junit: false,
            version: options.version ?? "0.0.0",
            groupId: options.groupId ?? "com.aws",
            artifactId: options.artifactId ?? "monorepo",
            projenrcJavaOptions: {
                ...options.projenrcJavaOptions,
                projenVersion: options.projenrcJavaOptions?.projenVersion ?? projen_dependency_1.DEFAULT_PROJEN_VERSION,
            },
        });
        this.projenVersion =
            options.projenrcJavaOptions?.projenVersion ?? projen_dependency_1.DEFAULT_PROJEN_VERSION;
        this.addTestDependency("software.aws/pdk@^0");
        this.nxConfigurator = new nx_configurator_1.NxConfigurator(this, {
            defaultReleaseBranch: options.defaultReleaseBranch ?? "main",
        });
        // Setup maven nx plugin
        new projen_1.TextFile(this, MVN_PLUGIN_PATH, {
            readonly: true,
            lines: fs
                .readFileSync(path.join(__dirname, "plugin/mvn_plugin.js"))
                .toString("utf-8")
                .split("\n"),
        });
        this.nx.plugins.push("@jnxplus/nx-maven", MVN_PLUGIN_PATH);
        this.installTask = this.nxConfigurator.ensureNxInstallTask({
            "@jnxplus/nx-maven": "^0.x",
        });
        // Map tasks to nx run-many
        this.nxConfigurator._overrideNxBuildTask(this.buildTask, { target: "build" }, { force: true });
        this.nxConfigurator._overrideNxBuildTask(this.preCompileTask, {
            target: "pre-compile",
        });
        this.nxConfigurator._overrideNxBuildTask(this.compileTask, {
            target: "compile",
        });
        this.nxConfigurator._overrideNxBuildTask(this.postCompileTask, {
            target: "post-compile",
        });
        this.nxConfigurator._overrideNxBuildTask(this.testTask, {
            target: "test",
        });
        this.nxConfigurator._overrideNxBuildTask(this.packageTask, {
            target: "package",
        });
    }
    /**
     * @inheritdoc
     */
    get nx() {
        return this.nxConfigurator.nx;
    }
    /**
     * @inheritdoc
     */
    execNxRunManyCommand(options) {
        return this.nxConfigurator.execNxRunManyCommand(options);
    }
    /**
     * @inheritdoc
     */
    composeNxRunManyCommand(options) {
        return this.nxConfigurator.composeNxRunManyCommand(options);
    }
    /**
     * @inheritdoc
     */
    addNxRunManyTask(name, options) {
        return this.nxConfigurator.addNxRunManyTask(name, options);
    }
    /**
     * @inheritdoc
     */
    addImplicitDependency(dependent, dependee) {
        this.nxConfigurator.addImplicitDependency(dependent, dependee);
    }
    /**
     * @inheritdoc
     */
    addJavaDependency(dependent, dependee) {
        this.nxConfigurator.addJavaDependency(dependent, dependee);
    }
    /**
     * @inheritdoc
     */
    addPythonPoetryDependency(dependent, dependee) {
        this.nxConfigurator.addPythonPoetryDependency(dependent, dependee);
    }
    addUpgradeDepsTask() {
        const upgradeDepsTask = new projen_1.Task("upgrade-deps", {
            description: "Upgrade dependencies in the monorepo",
        });
        this.nxConfigurator._overrideNxBuildTask(upgradeDepsTask, {
            target: "upgrade",
        });
        this.nxConfigurator._configurePythonSubprojectUpgradeDeps(this, upgradeDepsTask);
    }
    /**
     * @inheritdoc
     */
    preSynthesize() {
        // Calling before super() to ensure proper pre-synth of NxProject component and its nested components
        this.nxConfigurator.preSynthesize();
        this.addUpgradeDepsTask();
        super.preSynthesize();
        (0, projen_dependency_1.syncProjenVersions)(this.subprojects, this.projenVersion);
    }
    /**
     * @inheritDoc
     */
    synth() {
        this.nxConfigurator.synth();
        super.synth();
    }
    postSynthesize() {
        super.postSynthesize();
        this.installNx();
    }
    /**
     * Run the install task which will install nx locally
     */
    installNx() {
        this.logger.info("Installing dependencies...");
        const runtime = new projen_1.TaskRuntime(this.outdir);
        runtime.runTask(this.installTask.name);
    }
}
exports.MonorepoJavaProject = MonorepoJavaProject;
_a = JSII_RTTI_SYMBOL_1;
MonorepoJavaProject[_a] = { fqn: "@aws/pdk.monorepo.MonorepoJavaProject", version: "0.23.9" };
//# sourceMappingURL=data:application/json;base64,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