/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
import { Component, Project } from "projen";
/**
 * Utility for projen projects
 * @experimental
 */
export declare namespace ProjectUtils {
    /**
     * Returns whether the given project is an instance of the given project class.
     * Uses the class name to perform this check, such that the check still passes for
     * classes imported from mismatching package versions.
     */
    function isNamedInstanceOf<TParent extends Project | Component, TChild extends TParent>(instance: TParent, clazz: {
        new (...args: any[]): TChild;
    }): instance is TChild;
}
