"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.extendProjectsWithTargetDirs = void 0;
const path_1 = __importDefault(require("path"));
const dependency_path_1 = require("@pnpm/dependency-path");
function extendProjectsWithTargetDirs(projects, lockfile, ctx) {
    const getLocalLocations = ctx.pkgLocationsByDepPath != null
        ? (depPath) => ctx.pkgLocationsByDepPath[depPath]
        : (depPath, pkgName) => [path_1.default.join(ctx.virtualStoreDir, (0, dependency_path_1.depPathToFilename)(depPath), 'node_modules', pkgName)];
    const projectsById = Object.fromEntries(projects.map((project) => [project.id, { ...project, targetDirs: [] }]));
    Object.entries(lockfile.packages ?? {})
        .forEach(([depPath, pkg]) => {
        if (pkg.resolution?.type !== 'directory')
            return;
        const pkgId = pkg.id ?? depPath;
        const importerId = pkgId.replace(/^file:/, '');
        if (projectsById[importerId] == null)
            return;
        const localLocations = getLocalLocations(depPath, pkg.name);
        projectsById[importerId].targetDirs.push(...localLocations);
        projectsById[importerId].stages = ['preinstall', 'install', 'postinstall', 'prepare', 'prepublishOnly'];
    });
    return Object.values(projectsById);
}
exports.extendProjectsWithTargetDirs = extendProjectsWithTargetDirs;
//# sourceMappingURL=extendProjectsWithTargetDirs.js.map