"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnapStartFunction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
/**
 * A lambda function which enables SnapStart on published versions by default
 */
class SnapStartFunction extends aws_lambda_1.Function {
    constructor(scope, id, props) {
        super(scope, id, props);
        if (!props.disableSnapStart) {
            this.node.defaultChild.addPropertyOverride("SnapStart", {
                ApplyOn: "PublishedVersions",
            });
        }
    }
}
exports.SnapStartFunction = SnapStartFunction;
_a = JSII_RTTI_SYMBOL_1;
SnapStartFunction[_a] = { fqn: "@aws/pdk.type_safe_api.SnapStartFunction", version: "0.23.9" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic25hcC1zdGFydC1qYXZhLWZ1bmN0aW9uLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsic25hcC1zdGFydC1qYXZhLWZ1bmN0aW9uLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUE7c0NBQ3NDO0FBQ3RDLHVEQUE4RTtBQWM5RTs7R0FFRztBQUNILE1BQWEsaUJBQWtCLFNBQVEscUJBQVE7SUFDN0MsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUE2QjtRQUNyRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxLQUFLLENBQUMsQ0FBQztRQUV4QixJQUFJLENBQUMsS0FBSyxDQUFDLGdCQUFnQixFQUFFO1lBQzFCLElBQUksQ0FBQyxJQUFJLENBQUMsWUFBNEIsQ0FBQyxtQkFBbUIsQ0FBQyxXQUFXLEVBQUU7Z0JBQ3ZFLE9BQU8sRUFBRSxtQkFBbUI7YUFDN0IsQ0FBQyxDQUFDO1NBQ0o7SUFDSCxDQUFDOztBQVRILDhDQVVDIiwic291cmNlc0NvbnRlbnQiOlsiLyohIENvcHlyaWdodCBbQW1hem9uLmNvbV0oaHR0cDovL2FtYXpvbi5jb20vKSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cblNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wICovXG5pbXBvcnQgeyBDZm5GdW5jdGlvbiwgRnVuY3Rpb24sIEZ1bmN0aW9uUHJvcHMgfSBmcm9tIFwiYXdzLWNkay1saWIvYXdzLWxhbWJkYVwiO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSBcImNvbnN0cnVjdHNcIjtcblxuLyoqXG4gKiBPcHRpb25zIGZvciB0aGUgU25hcFN0YXJ0RnVuY3Rpb24gY29uc3RydWN0XG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgU25hcFN0YXJ0RnVuY3Rpb25Qcm9wcyBleHRlbmRzIEZ1bmN0aW9uUHJvcHMge1xuICAvKipcbiAgICogV2hlbiB0cnVlLCBkaXNhYmxlIHNuYXAgc3RhcnRcbiAgICogQGRlZmF1bHQgZmFsc2VcbiAgICovXG4gIHJlYWRvbmx5IGRpc2FibGVTbmFwU3RhcnQ/OiBib29sZWFuO1xufVxuXG4vKipcbiAqIEEgbGFtYmRhIGZ1bmN0aW9uIHdoaWNoIGVuYWJsZXMgU25hcFN0YXJ0IG9uIHB1Ymxpc2hlZCB2ZXJzaW9ucyBieSBkZWZhdWx0XG4gKi9cbmV4cG9ydCBjbGFzcyBTbmFwU3RhcnRGdW5jdGlvbiBleHRlbmRzIEZ1bmN0aW9uIHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IFNuYXBTdGFydEZ1bmN0aW9uUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHByb3BzKTtcblxuICAgIGlmICghcHJvcHMuZGlzYWJsZVNuYXBTdGFydCkge1xuICAgICAgKHRoaXMubm9kZS5kZWZhdWx0Q2hpbGQgYXMgQ2ZuRnVuY3Rpb24pLmFkZFByb3BlcnR5T3ZlcnJpZGUoXCJTbmFwU3RhcnRcIiwge1xuICAgICAgICBBcHBseU9uOiBcIlB1Ymxpc2hlZFZlcnNpb25zXCIsXG4gICAgICB9KTtcbiAgICB9XG4gIH1cbn1cbiJdfQ==