import { Size } from "aws-cdk-lib";
import { RestApiBaseProps, SpecRestApi } from "aws-cdk-lib/aws-apigateway";
import { CfnIPSet, CfnWebACL, CfnWebACLAssociation } from "aws-cdk-lib/aws-wafv2";
import { Construct } from "constructs";
import { TypeSafeApiOptions } from "./spec";
import { TypeSafeApiWebAclOptions } from "./waf/types";
/**
 * Configuration for the TypeSafeRestApi construct
 */
export interface TypeSafeRestApiProps extends RestApiBaseProps, TypeSafeApiOptions {
    /**
     * Path to the JSON open api spec
     */
    readonly specPath: string;
    /**
     * Options for the AWS WAF v2 WebACL associated with the api. By default, a Web ACL with the AWS default managed
     * rule set will be associated with the API. These options may disable or override the defaults.
     */
    readonly webAclOptions?: TypeSafeApiWebAclOptions;
    /**
     * A Size(in bytes, kibibytes, mebibytes etc) that is used to enable compression (with non-negative
     * between 0 and 10485760 (10M) bytes, inclusive) or disable compression
     * (when undefined) on an API. When compression is enabled, compression or
     * decompression is not applied on the payload if the payload size is
     * smaller than this value. Setting it to zero allows compression for any
     * payload size.
     *
     * @default - Compression is disabled.
     */
    readonly minCompressionSize?: Size;
}
/**
 * A construct for creating an api gateway rest api based on the definition in the OpenAPI spec.
 */
export declare class TypeSafeRestApi extends Construct {
    /**
     * Underlying API Gateway API construct
     */
    readonly api: SpecRestApi;
    /**
     * The OpenAPI specification with applied API gateway extensions
     */
    readonly extendedApiSpecification: any;
    /**
     * Reference to the webacl, if created
     */
    readonly webAcl?: CfnWebACL;
    /**
     * Reference to the IP set if created
     */
    readonly ipSet?: CfnIPSet;
    /**
     * Reference to the web acl association if created
     */
    readonly webAclAssociation?: CfnWebACLAssociation;
    constructor(scope: Construct, id: string, props: TypeSafeRestApiProps);
}
