"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpenApiGeneratorHandlebarsIgnoreFile = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const projen_1 = require("projen");
/**
 * Represents an .openapi-generator-ignore-handlebars file.
 * This is used for an optional second code generation pass to generate files using the handlebars templating engine
 * @see https://github.com/OpenAPITools/openapi-generator/blob/master/docs/customization.md#ignore-file-format
 */
class OpenApiGeneratorHandlebarsIgnoreFile extends projen_1.IgnoreFile {
    constructor(project) {
        super(project, ".openapi-generator-ignore-handlebars");
        // Ignore all files by default to allow opting in to generate with specific handlebars templates
        this.addPatterns("/*", "**/*", "*");
    }
}
exports.OpenApiGeneratorHandlebarsIgnoreFile = OpenApiGeneratorHandlebarsIgnoreFile;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoib3Blbi1hcGktZ2VuZXJhdG9yLWhhbmRsZWJhcnMtaWdub3JlLWZpbGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJvcGVuLWFwaS1nZW5lcmF0b3ItaGFuZGxlYmFycy1pZ25vcmUtZmlsZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQTtzQ0FDc0M7QUFDdEMsbUNBQTZDO0FBRTdDOzs7O0dBSUc7QUFDSCxNQUFhLG9DQUFxQyxTQUFRLG1CQUFVO0lBQ2xFLFlBQVksT0FBZ0I7UUFDMUIsS0FBSyxDQUFDLE9BQU8sRUFBRSxzQ0FBc0MsQ0FBQyxDQUFDO1FBRXZELGdHQUFnRztRQUNoRyxJQUFJLENBQUMsV0FBVyxDQUFDLElBQUksRUFBRSxNQUFNLEVBQUUsR0FBRyxDQUFDLENBQUM7SUFDdEMsQ0FBQztDQUNGO0FBUEQsb0ZBT0MiLCJzb3VyY2VzQ29udGVudCI6WyIvKiEgQ29weXJpZ2h0IFtBbWF6b24uY29tXShodHRwOi8vYW1hem9uLmNvbS8pLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjAgKi9cbmltcG9ydCB7IElnbm9yZUZpbGUsIFByb2plY3QgfSBmcm9tIFwicHJvamVuXCI7XG5cbi8qKlxuICogUmVwcmVzZW50cyBhbiAub3BlbmFwaS1nZW5lcmF0b3ItaWdub3JlLWhhbmRsZWJhcnMgZmlsZS5cbiAqIFRoaXMgaXMgdXNlZCBmb3IgYW4gb3B0aW9uYWwgc2Vjb25kIGNvZGUgZ2VuZXJhdGlvbiBwYXNzIHRvIGdlbmVyYXRlIGZpbGVzIHVzaW5nIHRoZSBoYW5kbGViYXJzIHRlbXBsYXRpbmcgZW5naW5lXG4gKiBAc2VlIGh0dHBzOi8vZ2l0aHViLmNvbS9PcGVuQVBJVG9vbHMvb3BlbmFwaS1nZW5lcmF0b3IvYmxvYi9tYXN0ZXIvZG9jcy9jdXN0b21pemF0aW9uLm1kI2lnbm9yZS1maWxlLWZvcm1hdFxuICovXG5leHBvcnQgY2xhc3MgT3BlbkFwaUdlbmVyYXRvckhhbmRsZWJhcnNJZ25vcmVGaWxlIGV4dGVuZHMgSWdub3JlRmlsZSB7XG4gIGNvbnN0cnVjdG9yKHByb2plY3Q6IFByb2plY3QpIHtcbiAgICBzdXBlcihwcm9qZWN0LCBcIi5vcGVuYXBpLWdlbmVyYXRvci1pZ25vcmUtaGFuZGxlYmFyc1wiKTtcblxuICAgIC8vIElnbm9yZSBhbGwgZmlsZXMgYnkgZGVmYXVsdCB0byBhbGxvdyBvcHRpbmcgaW4gdG8gZ2VuZXJhdGUgd2l0aCBzcGVjaWZpYyBoYW5kbGViYXJzIHRlbXBsYXRlc1xuICAgIHRoaXMuYWRkUGF0dGVybnMoXCIvKlwiLCBcIioqLypcIiwgXCIqXCIpO1xuICB9XG59XG4iXX0=