"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpenApiGeneratorIgnoreFile = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const projen_1 = require("projen");
/**
 * Represents an .openapi-generator-ignore file
 * @see https://github.com/OpenAPITools/openapi-generator/blob/master/docs/customization.md#ignore-file-format
 */
class OpenApiGeneratorIgnoreFile extends projen_1.IgnoreFile {
    constructor(project) {
        super(project, ".openapi-generator-ignore");
        // We should always use the projen .gitignore since projen manages the build, and therefore the ignored build
        // artifacts
        this.addPatterns(".gitignore");
    }
}
exports.OpenApiGeneratorIgnoreFile = OpenApiGeneratorIgnoreFile;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoib3Blbi1hcGktZ2VuZXJhdG9yLWlnbm9yZS1maWxlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsib3Blbi1hcGktZ2VuZXJhdG9yLWlnbm9yZS1maWxlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBO3NDQUNzQztBQUN0QyxtQ0FBNkM7QUFFN0M7OztHQUdHO0FBQ0gsTUFBYSwwQkFBMkIsU0FBUSxtQkFBVTtJQUN4RCxZQUFZLE9BQWdCO1FBQzFCLEtBQUssQ0FBQyxPQUFPLEVBQUUsMkJBQTJCLENBQUMsQ0FBQztRQUU1Qyw2R0FBNkc7UUFDN0csWUFBWTtRQUNaLElBQUksQ0FBQyxXQUFXLENBQUMsWUFBWSxDQUFDLENBQUM7SUFDakMsQ0FBQztDQUNGO0FBUkQsZ0VBUUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKiEgQ29weXJpZ2h0IFtBbWF6b24uY29tXShodHRwOi8vYW1hem9uLmNvbS8pLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjAgKi9cbmltcG9ydCB7IElnbm9yZUZpbGUsIFByb2plY3QgfSBmcm9tIFwicHJvamVuXCI7XG5cbi8qKlxuICogUmVwcmVzZW50cyBhbiAub3BlbmFwaS1nZW5lcmF0b3ItaWdub3JlIGZpbGVcbiAqIEBzZWUgaHR0cHM6Ly9naXRodWIuY29tL09wZW5BUElUb29scy9vcGVuYXBpLWdlbmVyYXRvci9ibG9iL21hc3Rlci9kb2NzL2N1c3RvbWl6YXRpb24ubWQjaWdub3JlLWZpbGUtZm9ybWF0XG4gKi9cbmV4cG9ydCBjbGFzcyBPcGVuQXBpR2VuZXJhdG9ySWdub3JlRmlsZSBleHRlbmRzIElnbm9yZUZpbGUge1xuICBjb25zdHJ1Y3Rvcihwcm9qZWN0OiBQcm9qZWN0KSB7XG4gICAgc3VwZXIocHJvamVjdCwgXCIub3BlbmFwaS1nZW5lcmF0b3ItaWdub3JlXCIpO1xuXG4gICAgLy8gV2Ugc2hvdWxkIGFsd2F5cyB1c2UgdGhlIHByb2plbiAuZ2l0aWdub3JlIHNpbmNlIHByb2plbiBtYW5hZ2VzIHRoZSBidWlsZCwgYW5kIHRoZXJlZm9yZSB0aGUgaWdub3JlZCBidWlsZFxuICAgIC8vIGFydGlmYWN0c1xuICAgIHRoaXMuYWRkUGF0dGVybnMoXCIuZ2l0aWdub3JlXCIpO1xuICB9XG59XG4iXX0=