/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
import { Project, ProjectOptions } from "projen";
import { GeneratedHtml2DocumentationOptions } from "../../types";
export interface GeneratedHtml2DocumentationProjectOptions extends ProjectOptions, GeneratedHtml2DocumentationOptions {
    /**
     * Path to the OpenAPI Specification for which to generate docs, relative to the project outdir
     */
    readonly specPath: string;
}
export declare class GeneratedHtml2DocumentationProject extends Project {
    private readonly generateTask;
    constructor(options: GeneratedHtml2DocumentationProjectOptions);
}
