import { JavaProject } from "projen/lib/java";
import { CodeGenerationSourceOptions, GeneratedJavaInfrastructureOptions } from "../../../types";
import { GeneratedHandlersProjects } from "../../generate";
import { GeneratedJavaRuntimeProject } from "../../runtime/generated-java-runtime-project";
export interface GeneratedJavaCdkInfrastructureProjectOptions extends GeneratedJavaInfrastructureOptions, CodeGenerationSourceOptions {
    /**
     * The generated java types
     */
    readonly generatedJavaTypes: GeneratedJavaRuntimeProject;
    /**
     * Generated handlers projects
     */
    readonly generatedHandlers: GeneratedHandlersProjects;
}
export declare class GeneratedJavaCdkInfrastructureProject extends JavaProject {
    /**
     * Options configured for the project
     * @private
     */
    private readonly options;
    /**
     * Source directory
     * @private
     */
    private readonly srcDir;
    /**
     * Java package name
     * @private
     */
    private readonly packageName;
    constructor(options: GeneratedJavaCdkInfrastructureProjectOptions);
    buildGenerateCommandArgs: () => string;
    buildGenerateMockDataCommand: () => string;
}
