import { PythonProject } from "projen/lib/python";
import { CodeGenerationSourceOptions, GeneratedPythonInfrastructureOptions } from "../../../types";
import { GeneratedHandlersProjects } from "../../generate";
import { GeneratedPythonRuntimeProject } from "../../runtime/generated-python-runtime-project";
export interface GeneratedPythonCdkInfrastructureProjectOptions extends GeneratedPythonInfrastructureOptions, CodeGenerationSourceOptions {
    /**
     * The generated python types
     */
    readonly generatedPythonTypes: GeneratedPythonRuntimeProject;
    /**
     * Generated handlers projects
     */
    readonly generatedHandlers: GeneratedHandlersProjects;
}
export declare class GeneratedPythonCdkInfrastructureProject extends PythonProject {
    /**
     * Options configured for the project
     * @private
     */
    private readonly options;
    constructor(options: GeneratedPythonCdkInfrastructureProjectOptions);
    buildGenerateCommandArgs: () => string;
    buildGenerateMockDataCommand: () => string;
}
