import { TypeScriptProject } from "projen/lib/typescript";
import { CodeGenerationSourceOptions, GeneratedTypeScriptReactQueryHooksOptions } from "../../types";
/**
 * Configuration for the generated typescript client project
 */
export interface GeneratedTypescriptReactQueryHooksProjectOptions extends GeneratedTypeScriptReactQueryHooksOptions, CodeGenerationSourceOptions {
    /**
     * Whether this project is parented by an monorepo or not
     */
    readonly isWithinMonorepo?: boolean;
}
/**
 * Typescript project containing generated react-query hooks
 */
export declare class TypescriptReactQueryHooksLibrary extends TypeScriptProject {
    /**
     * Patterns that are excluded from code generation
     */
    static openApiIgnorePatterns: string[];
    /**
     * Options configured for the project
     * @private
     */
    private readonly options;
    constructor(options: GeneratedTypescriptReactQueryHooksProjectOptions);
    buildGenerateCommandArgs: () => string;
}
