import { JavaProject } from "projen/lib/java";
import { CodeGenerationSourceOptions, GeneratedJavaRuntimeOptions } from "../../types";
/**
 * Configuration for the generated java runtime project
 */
export interface GeneratedJavaTypesProjectOptions extends GeneratedJavaRuntimeOptions, CodeGenerationSourceOptions {
}
/**
 * Java project containing types generated using OpenAPI Generator CLI
 */
export declare class GeneratedJavaRuntimeProject extends JavaProject {
    /**
     * Patterns that are excluded from code generation
     */
    static openApiIgnorePatterns: string[];
    /**
     * The package name, for use in imports
     */
    readonly packageName: string;
    /**
     * Options configured for the project
     * @private
     */
    private readonly options;
    constructor(options: GeneratedJavaTypesProjectOptions);
    buildGenerateCommandArgs: () => string;
}
