"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DocumentationFormat = exports.Library = exports.PythonVersion = exports.JavaVersion = exports.NodeVersion = exports.Language = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
/**
 * Supported languages for runtimes and infrastructure
 */
var Language;
(function (Language) {
    Language["TYPESCRIPT"] = "typescript";
    Language["PYTHON"] = "python";
    Language["JAVA"] = "java";
})(Language || (exports.Language = Language = {}));
/**
 * Versions of node
 */
var NodeVersion;
(function (NodeVersion) {
    NodeVersion["NODE_18"] = "NODE_18";
    NodeVersion["NODE_20"] = "NODE_20";
})(NodeVersion || (exports.NodeVersion = NodeVersion = {}));
/**
 * Versions of java
 */
var JavaVersion;
(function (JavaVersion) {
    JavaVersion["JAVA_8"] = "JAVA_8";
    JavaVersion["JAVA_11"] = "JAVA_11";
    JavaVersion["JAVA_17"] = "JAVA_17";
    JavaVersion["JAVA_21"] = "JAVA_21";
})(JavaVersion || (exports.JavaVersion = JavaVersion = {}));
/**
 * Versions of python
 */
var PythonVersion;
(function (PythonVersion) {
    PythonVersion["PYTHON_3_11"] = "PYTHON_3_11";
    PythonVersion["PYTHON_3_12"] = "PYTHON_3_12";
})(PythonVersion || (exports.PythonVersion = PythonVersion = {}));
/**
 * Supported libraries for code generation
 */
var Library;
(function (Library) {
    Library["TYPESCRIPT_REACT_QUERY_HOOKS"] = "typescript-react-query-hooks";
})(Library || (exports.Library = Library = {}));
/**
 * Formats for documentation generation
 */
var DocumentationFormat;
(function (DocumentationFormat) {
    /**
     * HTML Documentation generated by redoc
     * @see https://github.com/Redocly/redoc
     */
    DocumentationFormat["HTML_REDOC"] = "html_redoc";
    /**
     * OpenAPI Generator 'html2' documentation
     * @see https://github.com/OpenAPITools/openapi-generator/blob/master/docs/generators/html2.md
     */
    DocumentationFormat["HTML2"] = "html2";
    /**
     * OpenAPI Generator 'markdown' documentation
     * @see https://github.com/OpenAPITools/openapi-generator/blob/master/docs/generators/markdown.md
     */
    DocumentationFormat["MARKDOWN"] = "markdown";
    /**
     * OpenAPI Generator 'plantuml' documentation
     * @see https://github.com/OpenAPITools/openapi-generator/blob/master/docs/generators/plantuml.md
     */
    DocumentationFormat["PLANTUML"] = "plantuml";
})(DocumentationFormat || (exports.DocumentationFormat = DocumentationFormat = {}));
//# sourceMappingURL=data:application/json;base64,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