"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpenApiDefinition = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const projen_1 = require("projen");
/**
 * The OpenAPI Spec
 */
class OpenApiDefinition extends projen_1.Component {
    constructor(project, options) {
        super(project);
        /**
         * Path to the root OpenAPI specification file
         */
        this.openApiSpecificationPath = "src/main/openapi/main.yaml";
        const firstHandlerLanguage = options.handlerLanguages?.[0];
        // Create a sample OpenAPI spec yaml if not defined
        new projen_1.SampleFile(project, this.openApiSpecificationPath, {
            contents: `openapi: 3.0.3
info:
  version: 1.0.0
  title: ${options.openApiOptions.title}
paths:
  /hello:
    get:
      operationId: sayHello${firstHandlerLanguage
                ? `
      x-handler:
        language: ${firstHandlerLanguage}`
                : ""}
      parameters:
        - in: query
          name: name
          schema:
            type: string
          required: true
      responses:
        200:
          description: Successful response
          content:
            'application/json':
              schema:
                $ref: '#/components/schemas/SayHelloResponseContent'
        500:
          description: An internal failure at the fault of the server
          content:
            'application/json':
              schema:
                $ref: '#/components/schemas/InternalFailureErrorResponseContent'
        400:
          description: An error at the fault of the client sending invalid input
          content:
            'application/json':
              schema:
                $ref: '#/components/schemas/BadRequestErrorResponseContent'
        403:
          description: An error due to the client not being authorized to access the resource
          content:
            'application/json':
              schema:
                $ref: '#/components/schemas/NotAuthorizedErrorResponseContent'
components:
  schemas:
    SayHelloResponseContent:
      type: object
      properties:
        message:
          type: string
      required:
        - message
    InternalFailureErrorResponseContent:
      type: object
      properties:
        message:
          type: string
      required:
        - message
    BadRequestErrorResponseContent:
      type: object
      properties:
        message:
          type: string
      required:
        - message
    NotAuthorizedErrorResponseContent:
      type: object
      properties:
        message:
          type: string
      required:
        - message
`,
        });
    }
}
exports.OpenApiDefinition = OpenApiDefinition;
_a = JSII_RTTI_SYMBOL_1;
OpenApiDefinition[_a] = { fqn: "@aws/pdk.type_safe_api.OpenApiDefinition", version: "0.23.9" };
//# sourceMappingURL=data:application/json;base64,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